/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators.test;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToAcesiiEcpInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToAcesiiInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToAmicaInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToDaltonInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToDeMon2001Input;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToDeMonKSInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToGamessUSInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToHondoEcpInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToHondoInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToHyperChemInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToMeldfEcpInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToMeldfInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToMolcasInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToMolproEcpInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToMolproInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToMolproIntEcpInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToMolproIntInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToNWChemEcpInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToNWChemInput;
import org.scidac.cmcs.tools.bse.translators.BasisXmlToSupermoleculeInput;

public class TestXmlToBasisSet {
    public static void main(String[] args) {
        if (args.length != 4 && args.length != 5) {
            System.out.println("Usage: ");
            System.out.println("\tTestXmlToBasisSet <file> <tmpdir> <type> <optimize> <elementList>");
            System.out.println("\t<type> is one of [nw gamessus molpro molproi super hondo meldf molcas acesii hyperchem dalton demon-ks demon-2001 amica nw-ecp molpro-ecp molproi-ecp hondo-ecp meldf-ecp acesii-ecp]");
            System.out.println("\t<optimize> is true or false ");
            System.out.println("\tOPTIONAL: <elementList> for e.g.\"H Na\". ");
            System.exit(-1);
        }
        String input = args[0];
        String tmpdir = args[1];
        String type = args[2];
        boolean optimize = args[3].equals("true");
        Vector<String> elementList = new Vector<String>();
        if (args.length == 5) {
            String[] elements = args[4].split(" ");
            for (int i = 0; i < elements.length; ++i) {
                elementList.add(elements[i]);
            }
        }
        System.out.println("Converting " + input + " of type " + type + " for " + elementList);
        try {
            AbstractBasisSetXmlToText converter;
            if (type.equals("nw")) {
                converter = new BasisXmlToNWChemInput();
            } else if (type.equals("gamessus")) {
                converter = new BasisXmlToGamessUSInput();
            } else if (type.equals("molpro")) {
                converter = new BasisXmlToMolproInput();
            } else if (type.equals("molproi")) {
                converter = new BasisXmlToMolproIntInput();
            } else if (type.equals("super")) {
                converter = new BasisXmlToSupermoleculeInput();
            } else if (type.equals("hondo")) {
                converter = new BasisXmlToHondoInput();
            } else if (type.equals("meldf")) {
                converter = new BasisXmlToMeldfInput();
            } else if (type.equals("molcas")) {
                converter = new BasisXmlToMolcasInput();
            } else if (type.equals("acesii")) {
                converter = new BasisXmlToAcesiiInput();
            } else if (type.equals("hyperchem")) {
                converter = new BasisXmlToHyperChemInput();
            } else if (type.equals("dalton")) {
                converter = new BasisXmlToDaltonInput();
            } else if (type.equals("demon-ks")) {
                converter = new BasisXmlToDeMonKSInput();
            } else if (type.equals("demon-2001")) {
                converter = new BasisXmlToDeMon2001Input();
            } else if (type.equals("amica")) {
                converter = new BasisXmlToAmicaInput();
            } else if (type.equals("nw-ecp")) {
                converter = new BasisXmlToNWChemEcpInput();
            } else if (type.equals("molpro-ecp")) {
                converter = new BasisXmlToMolproEcpInput();
            } else if (type.equals("molproi-ecp")) {
                converter = new BasisXmlToMolproIntEcpInput();
            } else if (type.equals("hondo-ecp")) {
                converter = new BasisXmlToHondoEcpInput();
            } else if (type.equals("meldf-ecp")) {
                converter = new BasisXmlToMeldfEcpInput();
            } else if (type.equals("acesii-ecp")) {
                converter = new BasisXmlToAcesiiEcpInput();
            } else {
                throw new Exception("Unrecognized type " + type);
            }
            FileInputStream fis = new FileInputStream(input);
            byte[] b = new byte[fis.available()];
            fis.read(b);
            fis.close();
            String data = new String(b);
            String output = converter.convert(data, elementList, optimize);
            System.out.println(output);
            File dirpath = new File(tmpdir);
            File outfile = File.createTempFile("xml2txt", ".txt", dirpath);
            System.out.println("Writing to file " + outfile.getName());
            FileOutputStream fos = new FileOutputStream(outfile);
            PrintWriter pw = new PrintWriter(fos);
            pw.print(output);
            pw.flush();
            pw.close();
        }
        catch (Exception ex) {
            System.out.println("Oh Oh " + ex.getMessage() + ex);
            ex.printStackTrace();
        }
    }

    static void makeFile(File file, Document doc) throws FormatException {
        Format format = Format.getPrettyFormat();
        XMLOutputter outputter = new XMLOutputter(format);
        try {
            FileOutputStream fis = new FileOutputStream(file);
            outputter.output(doc, (OutputStream)new FileOutputStream(file));
            fis.flush();
            fis.close();
        }
        catch (Exception jdome) {
            throw new FormatException(jdome.getMessage());
        }
    }
}

