/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.List;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.CandidateInfo;
import org.chefproject.core.CandidateInfoEdit;
import org.chefproject.core.CandidatePath;
import org.chefproject.core.CandidatePathEdit;
import org.chefproject.core.Dissertation;
import org.chefproject.core.DissertationEdit;
import org.chefproject.core.DissertationStep;
import org.chefproject.core.DissertationStepEdit;
import org.chefproject.core.StepStatus;
import org.chefproject.core.StepStatusEdit;
import org.chefproject.service.component.BaseDbSingleStorage;
import org.chefproject.service.component.BaseDissertationService;

public class DbCachedDissertationService
extends BaseDissertationService {
    protected String m_dissertationsTableName = "DISSERTATION_DISSERTATION";
    protected String m_stepsTableName = "DISSERTATION_STEP";
    protected String m_pathsTableName = "DISSERTATION_PATH";
    protected String m_statusTableName = "DISSERTATION_STATUS";
    protected String m_infosTableName = "DISSERTATION_INFO";
    protected boolean m_locksInDb = true;

    public void init(RunData data) throws InitializationException {
        this.m_locksInDb = new Boolean(this.getProperties().getProperty("locks-db", "true"));
        this.m_dissertationsTableName = this.getProperties().getProperty("dissertationTable", this.m_dissertationsTableName);
        this.m_stepsTableName = this.getProperties().getProperty("dissertationStepTable", this.m_stepsTableName);
        this.m_pathsTableName = this.getProperties().getProperty("dissertationPathTable", this.m_pathsTableName);
        this.m_statusTableName = this.getProperties().getProperty("dissertationStatusTable", this.m_statusTableName);
        this.m_infosTableName = this.getProperties().getProperty("dissertationCandidateinfoTable", this.m_infosTableName);
        super.init(data);
        Log.info("chef", this + ".init(rundata): dissertations table: " + this.m_dissertationsTableName + " steps table: " + this.m_stepsTableName + " paths table : " + this.m_pathsTableName + " status table: " + this.m_statusTableName + " canididateinfo table : " + this.m_infosTableName);
    }

    protected BaseDissertationService.DissertationStorage newDissertationStorage() {
        return new DbCachedDissertationStorage(new BaseDissertationService.DissertationStorageUser());
    }

    protected BaseDissertationService.DissertationStepStorage newDissertationStepStorage() {
        return new DbCachedDissertationStepStorage(new BaseDissertationService.DissertationStepStorageUser());
    }

    protected BaseDissertationService.CandidatePathStorage newCandidatePathStorage() {
        return new DbCachedCandidatePathStorage(new BaseDissertationService.CandidatePathStorageUser());
    }

    protected BaseDissertationService.StepStatusStorage newStepStatusStorage() {
        return new DbCachedStepStatusStorage(new BaseDissertationService.StepStatusStorageUser());
    }

    protected BaseDissertationService.CandidateInfoStorage newCandidateInfoStorage() {
        return new DbCachedCandidateInfoStorage(new BaseDissertationService.CandidateInfoStorageUser());
    }

    protected class DbCachedCandidateInfoStorage
    extends BaseDbSingleStorage
    implements BaseDissertationService.CandidateInfoStorage {
        public DbCachedCandidateInfoStorage(BaseDissertationService.CandidateInfoStorageUser info) {
            super(DbCachedDissertationService.this.m_infosTableName, "INFO_ID", null, DbCachedDissertationService.this.m_locksInDb, "info", info);
        }

        public boolean check(String id) {
            return super.checkResource(id);
        }

        public CandidateInfo get(String id) {
            return (CandidateInfo)super.getResource(id);
        }

        public List getAll() {
            return super.getAllResources();
        }

        public CandidateInfoEdit put(String id, String context) {
            Object[] other = new Object[]{context};
            return (CandidateInfoEdit)super.putResource(id, other);
        }

        public CandidateInfoEdit edit(String id) {
            return (CandidateInfoEdit)super.editResource(id);
        }

        public void commit(CandidateInfoEdit edit) {
            super.commitResource(edit);
        }

        public void cancel(CandidateInfoEdit edit) {
            super.cancelResource(edit);
        }

        public void remove(CandidateInfoEdit edit) {
            super.removeResource(edit);
        }
    }

    protected class DbCachedStepStatusStorage
    extends BaseDbSingleStorage
    implements BaseDissertationService.StepStatusStorage {
        public DbCachedStepStatusStorage(BaseDissertationService.StepStatusStorageUser status) {
            super(DbCachedDissertationService.this.m_statusTableName, "STATUS_ID", null, DbCachedDissertationService.this.m_locksInDb, "status", status);
        }

        public boolean check(String id) {
            return super.checkResource(id);
        }

        public StepStatus get(String id) {
            return (StepStatus)super.getResource(id);
        }

        public List getAll() {
            return super.getAllResources();
        }

        public StepStatusEdit put(String id, String context) {
            Object[] other = new Object[]{context};
            return (StepStatusEdit)super.putResource(id, other);
        }

        public StepStatusEdit edit(String id) {
            return (StepStatusEdit)super.editResource(id);
        }

        public void commit(StepStatusEdit edit) {
            super.commitResource(edit);
        }

        public void cancel(StepStatusEdit edit) {
            super.cancelResource(edit);
        }

        public void remove(StepStatusEdit edit) {
            super.removeResource(edit);
        }
    }

    protected class DbCachedCandidatePathStorage
    extends BaseDbSingleStorage
    implements BaseDissertationService.CandidatePathStorage {
        public DbCachedCandidatePathStorage(BaseDissertationService.CandidatePathStorageUser path) {
            super(DbCachedDissertationService.this.m_pathsTableName, "PATH_ID", null, DbCachedDissertationService.this.m_locksInDb, "path", path);
        }

        public boolean check(String id) {
            return super.checkResource(id);
        }

        public CandidatePath get(String id) {
            return (CandidatePath)super.getResource(id);
        }

        public List getAll() {
            return super.getAllResources();
        }

        public CandidatePathEdit put(String id, String context) {
            Object[] other = new Object[]{context};
            return (CandidatePathEdit)super.putResource(id, other);
        }

        public CandidatePathEdit edit(String id) {
            return (CandidatePathEdit)super.editResource(id);
        }

        public void commit(CandidatePathEdit edit) {
            super.commitResource(edit);
        }

        public void cancel(CandidatePathEdit edit) {
            super.cancelResource(edit);
        }

        public void remove(CandidatePathEdit edit) {
            super.removeResource(edit);
        }
    }

    protected class DbCachedDissertationStepStorage
    extends BaseDbSingleStorage
    implements BaseDissertationService.DissertationStepStorage {
        public DbCachedDissertationStepStorage(BaseDissertationService.DissertationStepStorageUser step) {
            super(DbCachedDissertationService.this.m_stepsTableName, "STEP_ID", null, DbCachedDissertationService.this.m_locksInDb, "step", step);
        }

        public boolean check(String id) {
            return super.checkResource(id);
        }

        public DissertationStep get(String id) {
            return (DissertationStep)super.getResource(id);
        }

        public List getAll() {
            return super.getAllResources();
        }

        public DissertationStepEdit put(String id, String context) {
            Object[] other = new Object[]{context};
            return (DissertationStepEdit)super.putResource(id, other);
        }

        public DissertationStepEdit edit(String id) {
            return (DissertationStepEdit)super.editResource(id);
        }

        public void commit(DissertationStepEdit edit) {
            super.commitResource(edit);
        }

        public void cancel(DissertationStepEdit edit) {
            super.cancelResource(edit);
        }

        public void remove(DissertationStepEdit edit) {
            super.removeResource(edit);
        }
    }

    protected class DbCachedDissertationStorage
    extends BaseDbSingleStorage
    implements BaseDissertationService.DissertationStorage {
        public DbCachedDissertationStorage(BaseDissertationService.DissertationStorageUser dissertation) {
            super(DbCachedDissertationService.this.m_dissertationsTableName, "DISSERTATION_ID", null, DbCachedDissertationService.this.m_locksInDb, "dissertation", dissertation);
        }

        public boolean check(String id) {
            return super.checkResource(id);
        }

        public Dissertation get(String id) {
            return (Dissertation)super.getResource(id);
        }

        public List getAll() {
            return super.getAllResources();
        }

        public DissertationEdit put(String id, String context) {
            Object[] other = new Object[]{context};
            return (DissertationEdit)super.putResource(id, other);
        }

        public DissertationEdit edit(String id) {
            return (DissertationEdit)super.editResource(id);
        }

        public void commit(DissertationEdit edit) {
            super.commitResource(edit);
        }

        public void cancel(DissertationEdit edit) {
            super.cancelResource(edit);
        }

        public void remove(DissertationEdit edit) {
            super.removeResource(edit);
        }
    }
}

