/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Cacher;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.EventTrackingService;
import org.chefproject.service.SecurityService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.generic.GenericMemoryService;

public class BasicMemoryService
extends TurbineBaseService
implements GenericMemoryService,
Runnable {
    protected static long PERIOD = 60000L;
    protected Thread m_thread = null;
    protected boolean m_threadStop = false;
    protected long m_lastMemoryValue = 0L;
    protected HashSet m_cachers = null;

    protected void start() {
        this.m_threadStop = false;
        this.m_thread = new Thread((Runnable)this, this.getClass().getName());
        this.m_thread.start();
    }

    protected void stop() {
        if (this.m_thread == null) {
            return;
        }
        this.m_threadStop = true;
        this.m_thread.interrupt();
        this.m_thread = null;
    }

    public void run() {
        while (!this.m_threadStop && !Thread.currentThread().isInterrupted()) {
            try {
                System.gc();
                this.m_lastMemoryValue = Runtime.getRuntime().freeMemory();
                long k = this.m_lastMemoryValue / 1024L;
                short m = (short)(k / 1024L);
                k = (this.m_lastMemoryValue - (long)(m * 1024 * 1024)) / 1024L;
                long totalBytes = Runtime.getRuntime().totalMemory();
                long tk = totalBytes / 1024L;
                short tm = (short)(tk / 1024L);
                tk = (totalBytes - (long)(tm * 1024 * 1024)) / 1024L;
                Log.info("chef", "Memory: " + m + "." + k + "(" + this.m_lastMemoryValue + ") " + "total: " + tm + "." + tk + "(" + totalBytes + ") ");
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                Thread.sleep(PERIOD);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig)");
        this.start();
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        Log.info("chef", this + ".init(RunData)");
    }

    public void init() throws InitializationException {
        super.init();
        this.m_cachers = new HashSet();
        Log.info("chef", this + ".init()");
    }

    public void shutdown() {
        this.stop();
        this.m_cachers.clear();
        this.m_cachers = null;
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    public long getAvailableMemory() {
        return this.m_lastMemoryValue;
    }

    public void resetCachers() throws PermissionException {
        if (!SecurityService.isSuperUser()) {
            throw new PermissionException(UsageSessionService.getSessionUser().getId(), "memory.reset", "");
        }
        EventTrackingService.post(EventTrackingService.newEvent("memory.reset", "", false));
        if (this.m_cachers.isEmpty()) {
            return;
        }
        Iterator it = this.m_cachers.iterator();
        while (it.hasNext()) {
            Cacher cacher = (Cacher)it.next();
            cacher.resetCache();
        }
        System.gc();
    }

    public void registerCacher(Cacher cacher) {
        this.m_cachers.add(cacher);
    }

    public void unregisterCacher(Cacher cacher) {
        this.m_cachers.remove(cacher);
    }
}

