/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.upload.FileItem;
import org.apache.velocity.context.Context;
import org.chefproject.actions.PermissionsAction;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.core.ContentCollection;
import org.chefproject.core.ContentResource;
import org.chefproject.core.Resource;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.ToolConfigurationEdit;
import org.chefproject.exception.EmptyException;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.InconsistentException;
import org.chefproject.exception.OverQuotaException;
import org.chefproject.exception.PermissionException;
import org.chefproject.exception.TypeException;
import org.chefproject.service.ContentHostingService;
import org.chefproject.service.ContentTypeImageService;
import org.chefproject.service.PortalService;
import org.chefproject.service.SiteService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.generic.GenericContentHostingService;
import org.chefproject.util.ContentHostingComparator;
import org.chefproject.util.DefaultId;
import org.chefproject.util.Dropbox;
import org.chefproject.util.EventObservingCourier;
import org.chefproject.util.Menu;
import org.chefproject.util.MenuEntry;
import org.chefproject.util.Reference;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Time;
import org.chefproject.util.TimeBreakdown;
import org.chefproject.util.Validator;

public class ResourcesAction
extends VelocityPortletPaneledAction {
    private static final String FILE_UPLOAD_MAX_SIZE = "20MB";
    private static final String RESOURCES_MODE_RESOURCES = "resources";
    private static final String RESOURCES_MODE_DROPBOX = "dropbox";
    private static final String EXPANDED_COLLECTIONS = "expanded_collections";
    private static final String NULL_STRING = "";
    private static final String DUPLICATE_STRING = "Copy of ";
    private static final String SHORTCUT_STRING = "Shortcut to ";
    private static final String COPYRIGHT_SYMBOL = "&#169;";
    private static final String NEW_WINDOW = "_blank";
    private static final String NEW_COPYRIGHT = "newcopyright";
    private static final String RESOURCE_NOT_EXIST_STRING = "The resource/collection does not exist. ";
    private static final String RESOURCE_INVALID_TITLE_STRING = "The title cannot contain any of the following characters: / \\ % ";
    private static final String RESOURCE_INVALID_OPERATION_ON_COLLECTION_STRING = "Copy, cut, paste and paste shortcut are not currently supported on folders.";
    private static final int MULTI_ADD_NUMBER = 10;
    private static final String SIMPLE_TEXT_TYPE = "text/plain";
    private static final String URL_TYPE = "text/URL";
    private static final String STATE_INITIALIZED = "resources.initialized";
    private static final String STATE_CONTENT_SERVICE = "resources.content_service";
    private static final String STATE_RESOURCES_MODE = "resources.resources_mode";
    private static final String STATE_CONTENT_TYPE_IMAGE_SERVICE = "resources.content_type_image_service";
    private static final String STATE_MY_COPYRIGHT = "resources.mycopyright";
    private static final String STATE_COLLECTION_ID = "resources.collection_id";
    private static final String STATE_HOME_COLLECTION_ID = "resources.collection_home";
    private static final String STATE_HOME_COLLECTION_DISPLAY_NAME = "resources.collection_home_display_name";
    private static final String STATE_UNQUALIFIED_INPUT_FIELD = "resources.unqualified_input_field";
    private static final String STATE_COLLECTION_PATH = "resources.collection_path";
    private static final String STATE_SORT_BY = "resources.sort_by";
    private static final String STATE_SORT_ASC = "resources.sort_asc";
    private static final String STATE_COPY_FLAG = "resources.copy_flag";
    private static final String STATE_CUT_FLAG = "resources.cut_flag";
    private static final String STATE_SELECT_ALL_FLAG = "resources.select_all_flag";
    private static final String STATE_EXPAND_ALL_FLAG = "resources.expand_all_flag";
    private static final String STATE_FROM = "resources.from";
    private static final String STATE_ADD_FILE_NUMBER = "resources.add_file_number";
    private static final String STATE_ADD_FILE_OS_NAME = "resources.add_file_os_name";
    private static final String STATE_ADD_FILE_TITLE = "resources.add_file_title";
    private static final String STATE_ADD_FILE_CONTENT = "resources.add_file_content";
    private static final String STATE_ADD_FILE_CONTENT_TYPE = "resources.add_file_content_type";
    private static final String STATE_ADD_FILE_COPYRIGHT = "resources.add_file_copyright";
    private static final String STATE_ADD_FILE_NEW_COPYRIGHT = "resources.add_file_new_copyright";
    private static final String STATE_ADD_FILE_DESCRIPTION = "resources.add_file_description";
    private static final String STATE_ADD_FILE_TARGET = "resources.add_file_target";
    private static final String STATE_ADD_FOLDER_NUMBER = "resources.add_folder_number";
    private static final String STATE_ADD_FOLDER_TITLE = "resources.add_folder_title";
    private static final String STATE_ADD_FOLDER_DESCRIPTION = "resources.add_folder_description";
    private static final String STATE_ADD_FOLDER_COPYRIGHT = "resources.add_folder_copyright";
    private static final String STATE_ADD_SIMPLE_TEXT_CONTENT = "resources.add_simple_text_content";
    private static final String STATE_ADD_SIMPLE_TEXT_COPYRIGHT = "resources.add_simple_text_copyright";
    private static final String STATE_ADD_SIMPLE_TEXT_DESCRIPTION = "resources.add_simple_text_description";
    private static final String STATE_ADD_SIMPLE_TEXT_NEW_COPYRIGHT = "resources.add_simple_text_new_copyright";
    private static final String STATE_ADD_SIMPLE_TEXT_TARGET = "resources.add_simple_text_target";
    private static final String STATE_ADD_SIMPLE_TEXT_TITLE = "resources.add_simple_text_title";
    private static final String STATE_ADD_URL_NUMBER = "resources.add_url_number";
    private static final String STATE_ADD_URL_COPYRIGHT = "resources.add_url_copyright";
    private static final String STATE_ADD_URL_DESCRIPTION = "resources.add_url_description";
    private static final String STATE_ADD_URL_NEW_COPYRIGHT = "resources.add_url_new_copyright";
    private static final String STATE_ADD_URL_TARGET = "resources.add_url_target";
    private static final String STATE_ADD_URL_TITLE = "resources.add_url_title";
    private static final String STATE_ADD_URL_URL = "resources.add_url_url";
    private static final String STATE_MORE_ID = "resources.more_id";
    private static final String STATE_MORE_FROM = "resources.more_from";
    private static final String STATE_PROPERTIES_ID = "resources.properties_id";
    private static final String STATE_DELETE_IDS = "resources.delete_ids";
    private static final String STATE_NOT_EMPTY_DELETE_IDS = "resource.not_empty_delete_ids";
    private static final String STATE_REPLACE_ID = "resources.replace_id";
    private static final String STATE_REPLACE_OS_NAME = "resources.replace_os_name";
    private static final String STATE_REPLACE_TITLE = "resources.replace_title";
    private static final String STATE_REPLACE_CONTENT = "resources.replace_content";
    private static final String STATE_REPLACE_CONTENT_TYPE = "resources.replace_content_type";
    private static final String STATE_REVISE_ID = "resources.revise_id";
    private static final String STATE_CUT_IDS = "resources.revise_cut_ids";
    private static final String STATE_COPIED_IDS = "resources.revise_copied_ids";
    private static final String MODE_BROWSE = "show";
    private static final String MODE_ADD_ITEM = "add";
    private static final String MODE_ADD_FILE_BASIC = "addFileBasic";
    private static final String MODE_ADD_FILE_OPTIONS = "addFileOptions";
    private static final String MODE_ADD_FOLDER = "addFolder";
    private static final String MODE_ADD_URL = "addURL";
    private static final String MODE_ADD_SIMPLE_TEXT = "addSimpleText";
    private static final String MODE_DElETE_CONFIRM = "deleteConfirm";
    private static final String MODE_MORE = "more";
    private static final String MODE_PROPERTIES = "properties";
    private static final String MODE_REPLACE = "replace";
    private static final String MODE_REVISE_SIMPLE_TEXT = "reviseSimpleText";
    private static final String MODE_DELETE_CONFIRM = "deleteConfirm";
    private static final String TEMPLATE_BROWSE = "chef_resources_show";
    private static final String TEMPLATE_ADD_ITEM = "chef_resources_addItem";
    private static final String TEMPLATE_ADD_FILE_BASIC = "chef_resources_addFileBasic";
    private static final String TEMPLATE_ADD_FILE_OPTIONS = "chef_resources_addFileOptions";
    private static final String TEMPLATE_ADD_FOLDER = "chef_resources_addFolderBasic";
    private static final String TEMPLATE_ADD_SIMPLE_TEXT = "chef_resources_addSimpleText";
    private static final String TEMPLATE_ADD_URL = "chef_resources_addURLBasic";
    private static final String TEMPLATE_DELETE_CONFIRM = "chef_resources_deleteConfirm";
    private static final String TEMPLATE_MORE = "chef_resources_more";
    private static final String TEMPLATE_PROPERTIES = "chef_resources_properties";
    private static final String TEMPLATE_REPLACE = "chef_resources_replace";

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        String template;
        String helperMode = (String)state.getAttribute("pemissions.mode");
        if (helperMode != null) {
            template = PermissionsAction.buildHelperContext(portlet, context, data, state);
            if (template == null) {
                this.addAlert(state, "There is a problem setting Folder Permissions at this time.");
            } else {
                return template;
            }
        }
        template = null;
        String mode = (String)state.getAttribute("mode");
        if (mode.equals(MODE_BROWSE)) {
            EventObservingCourier o = (EventObservingCourier)state.getAttribute("obsever");
            o.setDeliveryId(this.clientWindowId(state, portlet.getID()));
            o.enable();
            template = this.buildBrowseContext(portlet, context, data, state);
        } else if (mode.equals(MODE_ADD_ITEM)) {
            ((EventObservingCourier)state.getAttribute("obsever")).disable();
            template = this.buildAddItemContext(portlet, context, data, state);
        } else if (mode.equals(MODE_ADD_FILE_BASIC)) {
            ((EventObservingCourier)state.getAttribute("obsever")).disable();
            template = this.buildAddFileBasicContext(portlet, context, data, state);
        } else if (mode.equals(MODE_ADD_FILE_OPTIONS)) {
            ((EventObservingCourier)state.getAttribute("obsever")).disable();
            template = this.buildAddFileOptionsContext(portlet, context, data, state);
        } else if (mode.equals(MODE_ADD_FOLDER)) {
            ((EventObservingCourier)state.getAttribute("obsever")).disable();
            template = this.buildAddFolderContext(portlet, context, data, state);
        } else if (mode.equals(MODE_ADD_SIMPLE_TEXT)) {
            ((EventObservingCourier)state.getAttribute("obsever")).disable();
            template = this.buildAddSimpleTextContext(portlet, context, data, state);
        } else if (mode.equals("deleteConfirm")) {
            ((EventObservingCourier)state.getAttribute("obsever")).disable();
            template = this.buildDeleteConfirmContext(portlet, context, data, state);
        } else if (mode.equals(MODE_MORE)) {
            ((EventObservingCourier)state.getAttribute("obsever")).disable();
            template = this.buildMoreContext(portlet, context, data, state);
        } else if (mode.equals(MODE_PROPERTIES)) {
            ((EventObservingCourier)state.getAttribute("obsever")).disable();
            template = this.buildPropertiesContext(portlet, context, data, state);
        } else if (mode.equals(MODE_REPLACE)) {
            ((EventObservingCourier)state.getAttribute("obsever")).disable();
            template = this.buildReplaceContext(portlet, context, data, state);
        } else if (mode.equals(MODE_ADD_URL)) {
            ((EventObservingCourier)state.getAttribute("obsever")).disable();
            template = this.buildAddUrlContext(portlet, context, data, state);
        } else if (mode.equals("options")) {
            ((EventObservingCourier)state.getAttribute("obsever")).disable();
            template = this.buildOptionsPanelContext(portlet, context, data, state);
        }
        return template;
    }

    public String buildBrowseContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        context.put("expandedCollections", state.getAttribute(EXPANDED_COLLECTIONS));
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        GenericContentHostingService contentService = (GenericContentHostingService)state.getAttribute(STATE_CONTENT_SERVICE);
        context.put("service", contentService);
        boolean atHome = false;
        String collectionId = (String)state.getAttribute(STATE_COLLECTION_ID);
        String homeCollectionId = (String)state.getAttribute(STATE_HOME_COLLECTION_ID);
        if (collectionId.equals(homeCollectionId)) {
            atHome = true;
            context.put("collectionDisplayName", state.getAttribute(STATE_HOME_COLLECTION_DISPLAY_NAME));
        } else {
            try {
                context.put("collectionDisplayName", contentService.getCollection(collectionId).getProperties().getProperty("DAV:displayname"));
            }
            catch (IdUnusedException e) {
            }
            catch (TypeException e) {
            }
            catch (PermissionException e) {
                // empty catch block
            }
        }
        context.put("homeCollection", homeCollectionId);
        context.put("collectionId", collectionId);
        Vector<String> collectionPath = new Vector<String>();
        String currentCollectionId = collectionId;
        while (contentService.getContainingCollectionId(currentCollectionId).length() > 0 && !currentCollectionId.equals(state.getAttribute(STATE_HOME_COLLECTION_ID))) {
            String containingId = contentService.getContainingCollectionId(currentCollectionId);
            collectionPath.insertElementAt(containingId, 0);
            currentCollectionId = containingId;
        }
        state.setAttribute(STATE_COLLECTION_PATH, collectionPath);
        context.put("collectionPath", collectionPath);
        String testCollection = collectionId + "test/";
        String testResource = collectionId + "test";
        String sortedBy = (String)state.getAttribute(STATE_SORT_BY);
        String sortedAsc = (String)state.getAttribute(STATE_SORT_ASC);
        context.put("currentSortedBy", sortedBy);
        context.put("currentSortAsc", sortedAsc);
        boolean allowAdd = !(!contentService.allowAddCollection(testCollection) && !contentService.allowAddResource(testResource) || !contentService.allowGetProperties(testCollection) && !contentService.allowGetProperties(testResource));
        boolean allowReplace = contentService.allowGetProperties(testResource) && contentService.allowUpdateResource(testResource);
        boolean allowRevise = contentService.allowGetProperties(testResource) && contentService.allowUpdateResource(testResource) && contentService.allowAddProperty(testResource);
        boolean allowGetProperties = contentService.allowGetProperties(testResource);
        boolean allowRemove = false;
        boolean emptyFolder = true;
        try {
            contentService.checkCollection(collectionId);
            context.put("collectionFlag", Boolean.TRUE.toString());
            String cutFlag = (String)state.getAttribute(STATE_CUT_FLAG);
            String copyFlag = (String)state.getAttribute(STATE_COPY_FLAG);
            context.put("cutFlag", cutFlag);
            context.put("copyFlag", copyFlag);
            if (cutFlag.equals(Boolean.TRUE.toString())) {
                context.put("cutItems", state.getAttribute(STATE_CUT_IDS));
            }
            if (copyFlag.equals(Boolean.TRUE.toString())) {
                context.put("copiedItems", state.getAttribute(STATE_COPIED_IDS));
            }
            context.put("selectallflag", state.getAttribute(STATE_SELECT_ALL_FLAG));
            context.put("expandallflag", state.getAttribute(STATE_EXPAND_ALL_FLAG));
            HashSet expandedCollections = (HashSet)state.getAttribute(EXPANDED_COLLECTIONS);
            List members = this.getShowMembers(collectionId, expandedCollections, sortedBy, sortedAsc, state);
            context.put("collectionMembers", members);
            if (members.size() > 0) {
                emptyFolder = false;
            }
            int i = 0;
            while (!allowRemove && i < members.size()) {
                String id = ((Resource)members.get(i)).getId();
                if (ContentHostingService.getProperties(id).getProperty("CHEF:is-collection").equals(Boolean.TRUE.toString())) {
                    if (ContentHostingService.allowRemoveCollection(id)) {
                        allowRemove = true;
                    }
                } else if (ContentHostingService.allowRemoveResource(id)) {
                    allowRemove = true;
                }
                ++i;
            }
            this.buildMenu(portlet, context, data, state, allowAdd, allowRemove, allowReplace, allowRevise, emptyFolder, atHome);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Can not find this folder. ");
            context.put("collectionFlag", Boolean.FALSE.toString());
            this.buildMenu(portlet, context, data, state, allowAdd, allowRemove, allowReplace, allowRevise, emptyFolder, atHome);
        }
        catch (TypeException e) {
            Log.error("chef", (Object)((Object)this) + "TypeException.");
            context.put("collectionFlag", Boolean.FALSE.toString());
            this.buildMenu(portlet, context, data, state, false, false, false, false, emptyFolder, atHome);
        }
        catch (PermissionException e) {
            this.addAlert(state, "You do not have permission to view this folder. ");
            context.put("collectionFlag", Boolean.FALSE.toString());
            this.buildMenu(portlet, context, data, state, false, false, false, false, emptyFolder, atHome);
        }
        context.put("resourceProperties", contentService.newResourceProperties());
        ((EventObservingCourier)state.getAttribute("obsever")).justDelivered();
        return TEMPLATE_BROWSE;
    }

    public String buildAddItemContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        context.put("collectionId", (String)state.getAttribute(STATE_COLLECTION_ID));
        return TEMPLATE_ADD_ITEM;
    }

    public String buildAddFileBasicContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        Integer fileNumberInteger = (Integer)state.getAttribute(STATE_ADD_FILE_NUMBER);
        context.put("fileNumber", fileNumberInteger);
        if (StringUtil.trimToNull(data.getParameters().getString("special")) != null) {
            if (fileNumberInteger > 1) {
                this.addAlert(state, "The upload size limit of 20MB has been exceeded.  Please try uploading one file at a time.");
            } else {
                this.addAlert(state, "The upload size limit of 20MB has been exceeded.");
            }
        }
        context.put("osNames", state.getAttribute(STATE_ADD_FILE_OS_NAME));
        context.put("titles", state.getAttribute(STATE_ADD_FILE_TITLE));
        context.put("descriptions", state.getAttribute(STATE_ADD_FILE_DESCRIPTION));
        context.put("copyrights", state.getAttribute(STATE_ADD_FILE_COPYRIGHT));
        context.put("newcopyrights", state.getAttribute(STATE_ADD_FILE_NEW_COPYRIGHT));
        context.put("openIns", state.getAttribute(STATE_ADD_FILE_TARGET));
        context.put("collectionId", (String)state.getAttribute(STATE_COLLECTION_ID));
        context.put("collectionPath", state.getAttribute(STATE_COLLECTION_PATH));
        context.put("unqualified_fields", state.getAttribute(STATE_UNQUALIFIED_INPUT_FIELD));
        context.put("service", state.getAttribute(STATE_CONTENT_SERVICE));
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        return TEMPLATE_ADD_FILE_BASIC;
    }

    public String buildAddFileOptionsContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        Integer fileNumberInteger = (Integer)state.getAttribute(STATE_ADD_FILE_NUMBER);
        context.put("fileNumber", fileNumberInteger);
        context.put("osNames", state.getAttribute(STATE_ADD_FILE_OS_NAME));
        context.put("titles", state.getAttribute(STATE_ADD_FILE_TITLE));
        context.put("descriptions", state.getAttribute(STATE_ADD_FILE_DESCRIPTION));
        context.put("copyrights", state.getAttribute(STATE_ADD_FILE_COPYRIGHT));
        context.put("newcopyrights", state.getAttribute(STATE_ADD_FILE_NEW_COPYRIGHT));
        context.put("openIns", state.getAttribute(STATE_ADD_FILE_TARGET));
        context.put("collectionId", state.getAttribute(STATE_COLLECTION_ID));
        context.put("unqualified_fields", state.getAttribute(STATE_UNQUALIFIED_INPUT_FIELD));
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        context.put("service", state.getAttribute(STATE_CONTENT_SERVICE));
        return TEMPLATE_ADD_FILE_OPTIONS;
    }

    public String buildAddFolderContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        Integer folderNumberInteger = (Integer)state.getAttribute(STATE_ADD_FOLDER_NUMBER);
        context.put("titles", state.getAttribute(STATE_ADD_FOLDER_TITLE));
        context.put("descriptions", state.getAttribute(STATE_ADD_FOLDER_DESCRIPTION));
        context.put("folderNumber", folderNumberInteger);
        context.put("collectionId", state.getAttribute(STATE_COLLECTION_ID));
        context.put("collectionPath", state.getAttribute(STATE_COLLECTION_PATH));
        context.put("unqualified_fields", state.getAttribute(STATE_UNQUALIFIED_INPUT_FIELD));
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        context.put("service", state.getAttribute(STATE_CONTENT_SERVICE));
        return TEMPLATE_ADD_FOLDER;
    }

    public String buildAddSimpleTextContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        context.put("collectionId", state.getAttribute(STATE_COLLECTION_ID));
        context.put("collectionPath", state.getAttribute(STATE_COLLECTION_PATH));
        context.put("title", state.getAttribute(STATE_ADD_SIMPLE_TEXT_TITLE));
        context.put("description", state.getAttribute(STATE_ADD_SIMPLE_TEXT_DESCRIPTION));
        context.put("content", state.getAttribute(STATE_ADD_SIMPLE_TEXT_CONTENT));
        context.put("copyright", state.getAttribute(STATE_ADD_SIMPLE_TEXT_COPYRIGHT));
        context.put(NEW_COPYRIGHT, state.getAttribute(STATE_ADD_SIMPLE_TEXT_NEW_COPYRIGHT));
        context.put("openIn", state.getAttribute(STATE_ADD_SIMPLE_TEXT_TARGET));
        context.put("unqualified_fields", ((Vector)state.getAttribute(STATE_UNQUALIFIED_INPUT_FIELD)).get(1));
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        context.put("service", state.getAttribute(STATE_CONTENT_SERVICE));
        return TEMPLATE_ADD_SIMPLE_TEXT;
    }

    public String buildDeleteConfirmContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        context.put("collectionId", state.getAttribute(STATE_COLLECTION_ID));
        context.put("collectionPath", state.getAttribute(STATE_COLLECTION_PATH));
        context.put("deleteResourceIds", state.getAttribute(STATE_DELETE_IDS));
        String notEmptyDeleteIds = (String)state.getAttribute(STATE_NOT_EMPTY_DELETE_IDS);
        if (notEmptyDeleteIds.length() > 0) {
            if (notEmptyDeleteIds.indexOf(",") > -1) {
                this.addAlert(state, "Note: the folders " + notEmptyDeleteIds + " contain objects that will also be deleted! ");
            } else {
                this.addAlert(state, "Note: the folder " + notEmptyDeleteIds + " contains objects that will also be deleted! ");
            }
        }
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        context.put("service", state.getAttribute(STATE_CONTENT_SERVICE));
        return TEMPLATE_DELETE_CONFIRM;
    }

    public String buildMoreContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        GenericContentHostingService service = (GenericContentHostingService)state.getAttribute(STATE_CONTENT_SERVICE);
        context.put("service", service);
        context.put("collectionId", state.getAttribute(STATE_COLLECTION_ID));
        context.put("collectionPath", state.getAttribute(STATE_COLLECTION_PATH));
        String id = (String)state.getAttribute(STATE_MORE_ID);
        context.put("id", id);
        context.put("from", (String)state.getAttribute(STATE_MORE_FROM));
        try {
            String type;
            ResourceProperties properties = service.getProperties(id);
            context.put(MODE_PROPERTIES, properties);
            if (properties.getProperty("CHEF:is-collection").equals(Boolean.FALSE.toString()) && ((type = properties.getProperty("DAV:getcontenttype")).equals(SIMPLE_TEXT_TYPE) || type.equals(URL_TYPE))) {
                ContentResource moreResource = service.getResource(id);
                String body = NULL_STRING;
                if (moreResource.getContent() != null) {
                    body = new String(moreResource.getContent());
                }
                context.put("content", body);
            }
        }
        catch (IdUnusedException e) {
            this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
            context.put("notExistFlag", new Boolean(true));
        }
        catch (TypeException e) {
            this.addAlert(state, " Type exception. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, " You do not have permission to view resource " + id + ". ");
        }
        if (state.getAttribute("message") == null) {
            context.put("notExistFlag", new Boolean(false));
        }
        return TEMPLATE_MORE;
    }

    public String buildPropertiesContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        String type;
        GenericContentHostingService service = (GenericContentHostingService)state.getAttribute(STATE_CONTENT_SERVICE);
        context.put("service", service);
        context.put("from", state.getAttribute(STATE_FROM));
        context.put("mycopyright", (String)state.getAttribute(STATE_MY_COPYRIGHT));
        String collectionId = (String)state.getAttribute(STATE_COLLECTION_ID);
        context.put("collectionId", collectionId);
        context.put("collectionPath", state.getAttribute(STATE_COLLECTION_PATH));
        String id = (String)state.getAttribute(STATE_PROPERTIES_ID);
        context.put("id", id);
        ResourceProperties properties = null;
        try {
            properties = service.getProperties(id);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
        }
        catch (PermissionException e) {
            this.addAlert(state, " You do not have permission to view resource " + collectionId);
        }
        context.put("unqualified_fields", state.getAttribute(STATE_UNQUALIFIED_INPUT_FIELD));
        if (properties.getProperty("CHEF:is-collection").equals(Boolean.FALSE.toString()) && ((type = properties.getProperty("DAV:getcontenttype")).equals(SIMPLE_TEXT_TYPE) || type.equals(URL_TYPE))) {
            try {
                ContentResource propertiesResource = service.getResource(id);
                String body = NULL_STRING;
                if (propertiesResource.getContent() != null) {
                    body = new String(propertiesResource.getContent());
                }
                context.put("content", body);
            }
            catch (IdUnusedException e) {
                this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
            }
            catch (TypeException e) {
                this.addAlert(state, " Type exception. ");
            }
            catch (PermissionException e) {
                this.addAlert(state, " You do not have permission to view resource " + id + ". ");
            }
        }
        context.put(MODE_PROPERTIES, properties);
        return TEMPLATE_PROPERTIES;
    }

    public String buildReplaceContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        int replaceItemNum = ((Vector)state.getAttribute(STATE_REPLACE_ID)).size() - 1;
        if (StringUtil.trimToNull(data.getParameters().getString("special")) != null) {
            if (replaceItemNum > 1) {
                this.addAlert(state, "The upload size limit of 20MB has been exceeded.  Please try uploading one file at a time.");
            } else {
                this.addAlert(state, "The upload size limit of 20MB has been exceeded.");
            }
        }
        context.put("collectionId", (String)state.getAttribute(STATE_COLLECTION_ID));
        context.put("collectionPath", state.getAttribute(STATE_COLLECTION_PATH));
        context.put("replaceItems", state.getAttribute(STATE_REPLACE_ID));
        context.put("replaceNumber", new Integer(replaceItemNum));
        context.put("osNames", state.getAttribute(STATE_REPLACE_OS_NAME));
        context.put("titles", state.getAttribute(STATE_REPLACE_TITLE));
        context.put("unqualified_fields", state.getAttribute(STATE_UNQUALIFIED_INPUT_FIELD));
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        GenericContentHostingService service = (GenericContentHostingService)state.getAttribute(STATE_CONTENT_SERVICE);
        context.put("service", service);
        context.put("resourceProperties", service.newResourceProperties());
        return TEMPLATE_REPLACE;
    }

    public String buildAddUrlContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        Integer UrlNumberInteger = (Integer)state.getAttribute(STATE_ADD_URL_NUMBER);
        context.put("UrlNumber", UrlNumberInteger);
        context.put("urls", state.getAttribute(STATE_ADD_URL_URL));
        context.put("titles", state.getAttribute(STATE_ADD_URL_TITLE));
        context.put("descriptions", state.getAttribute(STATE_ADD_URL_DESCRIPTION));
        context.put("openIns", state.getAttribute(STATE_ADD_URL_TARGET));
        context.put("copyrights", state.getAttribute(STATE_ADD_URL_COPYRIGHT));
        context.put("newcopyrights", state.getAttribute(STATE_ADD_URL_NEW_COPYRIGHT));
        context.put("unqualified_fields", state.getAttribute(STATE_UNQUALIFIED_INPUT_FIELD));
        context.put("collectionId", (String)state.getAttribute(STATE_COLLECTION_ID));
        context.put("collectionPath", state.getAttribute(STATE_COLLECTION_PATH));
        String mycopyright = (String)state.getAttribute(STATE_MY_COPYRIGHT);
        context.put("service", state.getAttribute(STATE_CONTENT_SERVICE));
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        return TEMPLATE_ADD_URL;
    }

    public void doNavigate(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (state.getAttribute(STATE_SELECT_ALL_FLAG) != null && state.getAttribute(STATE_SELECT_ALL_FLAG).equals(Boolean.TRUE.toString())) {
            state.setAttribute(STATE_SELECT_ALL_FLAG, (Object)Boolean.FALSE.toString());
        }
        if (state.getAttribute(STATE_EXPAND_ALL_FLAG) != null && state.getAttribute(STATE_EXPAND_ALL_FLAG).equals(Boolean.TRUE.toString())) {
            state.setAttribute(STATE_EXPAND_ALL_FLAG, (Object)Boolean.FALSE.toString());
        }
        state.setAttribute("mode", (Object)MODE_BROWSE);
        String collectionId = data.getParameters().getString("collectionId");
        try {
            ContentHostingService.checkCollection(collectionId);
        }
        catch (PermissionException e) {
            this.addAlert(state, " You do not have permission to view this collection. ");
        }
        catch (IdUnusedException e) {
            this.addAlert(state, " The collection does not exist. ");
        }
        catch (TypeException e) {
            this.addAlert(state, " The collection does not exist. ");
        }
        if (state.getAttribute("message") == null) {
            state.setAttribute(STATE_COLLECTION_ID, (Object)collectionId);
            state.setAttribute(EXPANDED_COLLECTIONS, new HashSet());
        }
    }

    public void doMore(RunData data) {
        String collectionId;
        String from;
        SessionState state;
        block16: {
            state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
            ParameterParser params = data.getParameters();
            String id = NULL_STRING;
            from = NULL_STRING;
            collectionId = NULL_STRING;
            try {
                id = params.getString("id");
                if (id != null) {
                    state.setAttribute(STATE_MORE_ID, (Object)id);
                } else {
                    id = (String)state.getAttribute(STATE_MORE_ID);
                }
                from = params.getString("from");
                state.setAttribute(STATE_MORE_FROM, (Object)from);
                collectionId = params.getString("collectionId");
                if (!collectionId.equals((String)state.getAttribute(STATE_HOME_COLLECTION_ID))) break block16;
                try {
                    ContentCollection collection = ContentHostingService.getCollection(collectionId);
                }
                catch (IdUnusedException e) {
                    try {
                        String mycopyright = (String)state.getAttribute(STATE_MY_COPYRIGHT);
                        ResourcePropertiesEdit resourceProperties = ContentHostingService.newResourceProperties();
                        String homeCollectionId = (String)state.getAttribute(STATE_HOME_COLLECTION_ID);
                        resourceProperties.addProperty("DAV:displayname", ContentHostingService.getProperties(homeCollectionId).getPropertyFormatted("DAV:displayname"));
                        resourceProperties.addProperty("CHEF:copyright", mycopyright);
                        ContentCollection collection = ContentHostingService.addCollection(homeCollectionId, resourceProperties);
                    }
                    catch (IdUsedException ee) {
                        this.addAlert(state, " Id has been used. ");
                    }
                    catch (IdUnusedException ee) {
                        this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
                    }
                    catch (IdInvalidException ee) {
                        this.addAlert(state, " The title" + ee.getMessage());
                    }
                    catch (PermissionException ee) {
                        this.addAlert(state, " Permission exception ");
                    }
                    catch (InconsistentException ee) {
                        this.addAlert(state, " The title cannot contain any of the following characters: / \\ %");
                    }
                }
                catch (TypeException e) {
                    this.addAlert(state, " Type exception. ");
                }
                catch (PermissionException e) {
                    this.addAlert(state, " Permission exception. ");
                }
            }
            catch (NullPointerException eE) {
                this.addAlert(state, " There is null pointer exception for resource id=" + id + ". ");
            }
        }
        if (state.getAttribute("message") == null) {
            state.setAttribute("mode", (Object)MODE_MORE);
            if (from.equals(MODE_BROWSE)) {
                state.setAttribute(STATE_MORE_FROM, (Object)MODE_BROWSE);
            }
            state.setAttribute(STATE_COLLECTION_ID, (Object)collectionId);
        }
    }

    public void doNewitem(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)MODE_ADD_ITEM);
    }

    public void doAdditem(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String mycopyright = (String)state.getAttribute(STATE_MY_COPYRIGHT);
        ParameterParser params = data.getParameters();
        String collectionId = (String)state.getAttribute(STATE_COLLECTION_ID);
        try {
            ContentHostingService.checkCollection((String)state.getAttribute(STATE_HOME_COLLECTION_ID));
        }
        catch (IdUnusedException e) {
            try {
                ResourcePropertiesEdit resourceProperties = ContentHostingService.newResourceProperties();
                String homeCollectionId = (String)state.getAttribute(STATE_HOME_COLLECTION_ID);
                String displayName = (String)state.getAttribute(STATE_HOME_COLLECTION_DISPLAY_NAME);
                if (displayName == null || displayName.length() == 0) {
                    displayName = homeCollectionId;
                }
                resourceProperties.addProperty("DAV:displayname", displayName);
                resourceProperties.addProperty("CHEF:copyright", mycopyright);
                ContentCollection collection = ContentHostingService.addCollection(homeCollectionId, resourceProperties);
            }
            catch (IdUsedException ee) {
                this.addAlert(state, " Id has been used. ");
            }
            catch (IdInvalidException ee) {
                this.addAlert(state, " The title" + ee.getMessage());
            }
            catch (PermissionException ee) {
                this.addAlert(state, " You do not have proper permissions to add resources. ");
            }
            catch (InconsistentException ee) {
                this.addAlert(state, " The title cannot contain any of the following characters: / \\ %");
            }
        }
        catch (TypeException e) {
            this.addAlert(state, " Type exception. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, " Permission exception. ");
        }
        if (state.getAttribute("message") == null) {
            Vector titles;
            String s;
            if (params.getString("itemType").equals("file")) {
                int newFileNumber = 1;
                s = params.getString("select");
                if (s != null) {
                    newFileNumber = new Integer(s);
                    state.setAttribute(STATE_ADD_FILE_NUMBER, (Object)new Integer(newFileNumber));
                    int oldFileNumber = 1;
                    s = params.getString("fileNumber");
                    if (s != null) {
                        oldFileNumber = new Integer(s);
                    }
                    Vector osNames = (Vector)state.getAttribute(STATE_ADD_FILE_OS_NAME);
                    titles = this.emptyVector(11);
                    Vector contents = (Vector)state.getAttribute(STATE_ADD_FILE_CONTENT);
                    Vector types = (Vector)state.getAttribute(STATE_ADD_FILE_CONTENT_TYPE);
                    Vector copyrights = this.emptyVector(11);
                    Vector newcopyrights = this.emptyVector(11);
                    Vector descriptions = this.emptyVector(11);
                    Vector targets = this.emptyVector(11);
                    int i = 1;
                    while (i <= (newFileNumber < oldFileNumber ? newFileNumber : oldFileNumber)) {
                        String description;
                        String newcopyrighttext;
                        String copyright;
                        FileItem fi = params.getFileItem("filename" + i);
                        String title = params.getString("title" + i);
                        if (title != null) {
                            titles.set(i, title);
                        }
                        if ((copyright = params.getString("copyright" + i)) != null) {
                            copyrights.set(i, copyright);
                        }
                        if ((newcopyrighttext = params.getString("newcopyrighttext" + i)) != null) {
                            newcopyrights.set(i, newcopyrighttext);
                        }
                        if ((description = params.getString("description" + i)) != null) {
                            descriptions.set(i, description);
                        }
                        targets.set(i, Boolean.TRUE.toString());
                        if (fi != null) {
                            contents.set(i, fi.get());
                            osNames.set(i, fi.getFileName());
                            types.set(i, fi.getContentType());
                        }
                        if (title.length() == 0) {
                            title = Validator.getFileName((String)osNames.get(i));
                        }
                        titles.set(i, title);
                        ++i;
                    }
                    int j = newFileNumber < oldFileNumber ? newFileNumber + 1 : oldFileNumber + 1;
                    while (j <= (newFileNumber > oldFileNumber ? newFileNumber : oldFileNumber)) {
                        osNames.set(j, NULL_STRING);
                        contents.set(j, NULL_STRING);
                        types.set(j, NULL_STRING);
                        ++j;
                    }
                    state.setAttribute(STATE_ADD_FILE_CONTENT, (Object)contents);
                    state.setAttribute(STATE_ADD_FILE_CONTENT_TYPE, (Object)types);
                    state.setAttribute(STATE_ADD_FILE_OS_NAME, (Object)osNames);
                    state.setAttribute(STATE_ADD_FILE_TITLE, (Object)titles);
                    state.setAttribute(STATE_ADD_FILE_COPYRIGHT, (Object)copyrights);
                    state.setAttribute(STATE_ADD_FILE_NEW_COPYRIGHT, (Object)newcopyrights);
                    state.setAttribute(STATE_ADD_FILE_DESCRIPTION, (Object)descriptions);
                    state.setAttribute(STATE_ADD_FILE_TARGET, (Object)targets);
                } else {
                    this.initAddFileContext(state);
                }
                state.setAttribute("mode", (Object)MODE_ADD_FILE_BASIC);
            } else if (params.getString("itemType").equals("emptyFolder")) {
                int newFolderNumber = 1;
                s = params.getString("select");
                if (s != null) {
                    newFolderNumber = new Integer(s);
                    state.setAttribute(STATE_ADD_FOLDER_NUMBER, (Object)new Integer(newFolderNumber));
                    int oldFolderNumber = Integer.valueOf(params.getString("folderNumber"));
                    Vector titles2 = this.emptyVector(11);
                    Vector descriptions = this.emptyVector(11);
                    int i = 1;
                    while (i <= (newFolderNumber < oldFolderNumber ? newFolderNumber : oldFolderNumber)) {
                        titles2.add(i, params.getString("name" + i));
                        descriptions.add(i, params.getString("description" + i));
                        ++i;
                    }
                    state.setAttribute(STATE_ADD_FOLDER_TITLE, (Object)titles2);
                    state.setAttribute(STATE_ADD_FOLDER_DESCRIPTION, (Object)descriptions);
                } else {
                    this.initAddFolderContext(state);
                }
                state.setAttribute("mode", (Object)MODE_ADD_FOLDER);
            } else if (params.getString("itemType").equals("simpleText")) {
                this.initAddSimpleTextContext(state);
                state.setAttribute("mode", (Object)MODE_ADD_SIMPLE_TEXT);
            } else if (params.getString("itemType").equals("Url")) {
                int newUrlNumber = 1;
                s = params.getString("select");
                if (s != null) {
                    newUrlNumber = new Integer(s);
                    state.setAttribute(STATE_ADD_URL_NUMBER, (Object)new Integer(newUrlNumber));
                    int oldUrlNumber = 1;
                    s = params.getString("UrlNumber");
                    if (s != null) {
                        oldUrlNumber = new Integer(s);
                    }
                    Vector urls = this.emptyVector(11);
                    titles = this.emptyVector(11);
                    Vector descriptions = this.emptyVector(11);
                    Vector copyrights = this.emptyVector(11);
                    Vector newcopyrights = this.emptyVector(11);
                    Vector targets = this.emptyVector(11);
                    Vector unqualified_fields = this.emptyVector(11);
                    int i = 1;
                    while (i <= (newUrlNumber < oldUrlNumber ? newUrlNumber : oldUrlNumber)) {
                        urls.set(i, params.getString("Url" + i));
                        titles.set(i, params.getString("title" + i));
                        descriptions.set(i, params.getString("description" + i));
                        copyrights.set(i, params.getString("copyright" + i));
                        newcopyrights.set(i, params.getString(NEW_COPYRIGHT + i));
                        targets.set(i, Boolean.TRUE.toString());
                        ++i;
                    }
                    state.setAttribute(STATE_ADD_URL_URL, (Object)urls);
                    state.setAttribute(STATE_ADD_URL_TITLE, (Object)titles);
                    state.setAttribute(STATE_ADD_URL_DESCRIPTION, (Object)descriptions);
                    state.setAttribute(STATE_ADD_URL_COPYRIGHT, (Object)copyrights);
                    state.setAttribute(STATE_ADD_URL_NEW_COPYRIGHT, (Object)newcopyrights);
                    state.setAttribute(STATE_ADD_URL_TARGET, (Object)targets);
                } else {
                    this.initAddURLContext(state);
                }
                state.setAttribute("mode", (Object)MODE_ADD_URL);
            }
        }
    }

    public void doAdd_file_basic(RunData data) {
        String n;
        int repeatedNames_index;
        String contentType;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        String collectionId = (String)state.getAttribute(STATE_COLLECTION_ID);
        String mycopyright = (String)state.getAttribute(STATE_MY_COPYRIGHT);
        int fileNumber = Integer.valueOf(params.getString("fileNumber"));
        Vector osNames = (Vector)state.getAttribute(STATE_ADD_FILE_OS_NAME);
        Vector titles = this.emptyVector(11);
        Vector contents = (Vector)state.getAttribute(STATE_ADD_FILE_CONTENT);
        Vector types = (Vector)state.getAttribute(STATE_ADD_FILE_CONTENT_TYPE);
        Vector copyrights = this.emptyVector(11);
        Vector newcopyrights = this.emptyVector(11);
        Vector descriptions = this.emptyVector(11);
        Vector targets = this.emptyVector(11);
        Vector unqualified_fields = this.emptyVector(11);
        int realFileNumber = 0;
        int i = 1;
        while (i <= fileNumber) {
            String description;
            String newcopyrighttext;
            String copyright;
            String u_fields = NULL_STRING;
            FileItem fi = params.getFileItem("filename" + i);
            String title = params.getString("title" + i);
            if (title != null) {
                titles.set(i, title);
            }
            if ((copyright = params.getString("copyright" + i)) != null) {
                copyrights.set(i, copyright);
            }
            if ((newcopyrighttext = params.getString("newcopyrighttext" + i)) != null) {
                newcopyrights.set(i, newcopyrighttext);
            }
            if (copyright.equals(NEW_COPYRIGHT) && newcopyrighttext != null && newcopyrighttext.length() == 0) {
                this.addAlert(state, "Please specify the new copyright information for file item " + i + ". ");
                u_fields = u_fields + "CHEF:copyright";
            }
            if ((description = params.getString("description" + i)) != null) {
                descriptions.set(i, description);
            }
            if ((((String)titles.get(i)).length() != 0 || ((String)newcopyrights.get(i)).length() != 0 || ((String)descriptions.get(i)).length() != 0) && fi == null && ((byte[])contents.get(i)).length == 1) {
                this.addAlert(state, "Please choose the file for file item " + i + ". ");
                titles.set(i, title);
                u_fields = u_fields + "osname";
            }
            if (fi != null) {
                contents.set(i, fi.get());
                osNames.set(i, fi.getFileName());
                contentType = fi.getContentType();
                types.set(i, contentType);
                if (contentType.equals(SIMPLE_TEXT_TYPE) || contentType.equals("text/html") || contentType.equals("image/gif") || contentType.equals("image/jpeg") || contentType.equals("application/pdf") || contentType.equals("text/xml")) {
                    targets.set(i, NEW_WINDOW);
                } else {
                    targets.set(i, "_self");
                }
            }
            if (title.length() == 0) {
                title = Validator.getFileName((String)osNames.get(i));
            }
            titles.set(i, title);
            if (title.indexOf("/") != -1 || title.indexOf("\\") != -1 || title.indexOf("%") != -1) {
                this.addAlert(state, " The title " + title + " cannot contain any of the following characters: / \\ %");
                u_fields = u_fields + "DAV:displayname";
            }
            if (((String)titles.get(i)).length() > 0) {
                ++realFileNumber;
            }
            unqualified_fields.add(i, u_fields);
            ++i;
        }
        if (realFileNumber == 0) {
            this.addAlert(state, "You need to specify at least one file. ");
        }
        if ((repeatedNames_index = this.repeatedName(titles, fileNumber)) > 0) {
            n = (String)titles.get(repeatedNames_index);
            if (n.length() > 0) {
                this.addAlert(state, "Can not add files with the same title " + n + ". ");
                unqualified_fields.set(repeatedNames_index, (String)unqualified_fields.get(repeatedNames_index) + "DAV:displayname");
            }
        } else {
            repeatedNames_index = this.foundInResource(titles, fileNumber, state, false);
            if (repeatedNames_index > 0) {
                n = (String)titles.get(repeatedNames_index);
                if (n.length() > 0) {
                    this.addAlert(state, " The title " + n + " of file item " + repeatedNames_index + " has been used in resources. Please use a different title. ");
                    unqualified_fields.set(repeatedNames_index, (String)unqualified_fields.get(repeatedNames_index) + "DAV:displayname");
                }
            } else if (state.getAttribute("message") == null) {
                Vector<Integer> addedFileIndex = new Vector<Integer>();
                String currentName = NULL_STRING;
                int i2 = 1;
                while (i2 <= fileNumber) {
                    if (((String)titles.get(i2)).length() > 0) {
                        String newResourceId = collectionId + (String)titles.get(i2);
                        ResourcePropertiesEdit resourceProperties = ContentHostingService.newResourceProperties();
                        resourceProperties.addProperty("DAV:displayname", (String)titles.get(i2));
                        if (((String)copyrights.get(i2)).equals(NEW_COPYRIGHT)) {
                            resourceProperties.addProperty("CHEF:copyright", (String)newcopyrights.get(i2));
                        } else {
                            resourceProperties.addProperty("CHEF:copyright", mycopyright);
                        }
                        resourceProperties.addProperty("CHEF:description", (String)descriptions.get(i2));
                        contentType = (String)types.get(i2);
                        if (contentType.equals(SIMPLE_TEXT_TYPE) || contentType.equals("text/html") || contentType.equals("image/gif") || contentType.equals("image/jpeg") || contentType.equals("application/pdf") || contentType.equals("text/xml")) {
                            resourceProperties.addProperty("CHEF:open-newwindow", NEW_WINDOW);
                        } else {
                            resourceProperties.addProperty("CHEF:open-newwindow", "_self");
                        }
                        try {
                            ContentResource resource = ContentHostingService.addResource(newResourceId, (String)types.get(i2), (byte[])contents.get(i2), resourceProperties);
                            addedFileIndex.add(new Integer(i2));
                        }
                        catch (IdUsedException e) {
                            this.addAlert(state, " File with the same title " + titles.get(i2) + " already exists. ");
                            unqualified_fields.set(i2, (String)unqualified_fields.get(i2) + "DAV:displayname");
                        }
                        catch (IdInvalidException e) {
                            this.addAlert(state, " The title" + e.getMessage());
                            unqualified_fields.set(i2, (String)unqualified_fields.get(i2) + "DAV:displayname");
                        }
                        catch (PermissionException e) {
                            this.addAlert(state, " You do not have proper permissions to add resources. ");
                        }
                        catch (OverQuotaException e) {
                            this.addAlert(state, "Adding this resource would place this account over quota. To add this resource, some resources may need to be deleted.");
                        }
                        catch (InconsistentException e) {
                            this.addAlert(state, " The title " + titles.get(i2) + " cannot contain any of the following characters: / \\ %");
                            unqualified_fields.set(i2, (String)unqualified_fields.get(i2) + "DAV:displayname");
                        }
                    }
                    ++i2;
                }
                if (state.getAttribute("message") != null) {
                    int k = 0;
                    while (k < addedFileIndex.size()) {
                        int tempIndex = (Integer)addedFileIndex.get(k);
                        contents.removeElementAt(tempIndex);
                        types.removeElementAt(tempIndex);
                        osNames.removeElementAt(tempIndex);
                        titles.removeElementAt(tempIndex);
                        copyrights.removeElementAt(tempIndex);
                        newcopyrights.removeElementAt(tempIndex);
                        descriptions.removeElementAt(tempIndex);
                        targets.removeElementAt(tempIndex);
                        unqualified_fields.removeElementAt(tempIndex);
                        ++k;
                    }
                    fileNumber -= addedFileIndex.size();
                }
            }
        }
        state.setAttribute(STATE_ADD_FILE_CONTENT, (Object)contents);
        state.setAttribute(STATE_ADD_FILE_CONTENT_TYPE, (Object)types);
        state.setAttribute(STATE_ADD_FILE_OS_NAME, (Object)osNames);
        state.setAttribute(STATE_ADD_FILE_TITLE, (Object)titles);
        state.setAttribute(STATE_ADD_FILE_COPYRIGHT, (Object)copyrights);
        state.setAttribute(STATE_ADD_FILE_NEW_COPYRIGHT, (Object)newcopyrights);
        state.setAttribute(STATE_ADD_FILE_DESCRIPTION, (Object)descriptions);
        state.setAttribute(STATE_ADD_FILE_TARGET, (Object)targets);
        state.setAttribute(STATE_ADD_FILE_NUMBER, (Object)new Integer(fileNumber));
        if (state.getAttribute("message") == null) {
            state.setAttribute("mode", (Object)MODE_BROWSE);
            this.initAddFileContext(state);
            state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)this.emptyVector(11));
        } else {
            state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)unqualified_fields);
        }
    }

    public void doSet_file_properties(RunData data) {
        String n;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        String collectionId = (String)state.getAttribute(STATE_COLLECTION_ID);
        String mycopyright = (String)state.getAttribute(STATE_MY_COPYRIGHT);
        int fileNumber = Integer.valueOf(params.getString("fileNumber"));
        state.setAttribute(STATE_ADD_FILE_NUMBER, (Object)new Integer(fileNumber));
        Vector osNames = (Vector)state.getAttribute(STATE_ADD_FILE_OS_NAME);
        Vector titles = this.emptyVector(11);
        Vector contents = (Vector)state.getAttribute(STATE_ADD_FILE_CONTENT);
        Vector types = (Vector)state.getAttribute(STATE_ADD_FILE_CONTENT_TYPE);
        Vector copyrights = this.emptyVector(11);
        Vector unqualified_fields = this.emptyVector(11);
        int i = 1;
        while (i <= fileNumber) {
            String u_fields = NULL_STRING;
            FileItem fi = params.getFileItem("filename" + i);
            if (fi == null && ((String)osNames.get(i)).length() == 0) {
                this.addAlert(state, "Please choose the file for file item " + i + ". ");
                titles.set(i, NULL_STRING);
                u_fields = "DAV:displayname";
            } else {
                String name;
                if (fi != null) {
                    contents.set(i, fi.get());
                    osNames.set(i, fi.getFileName());
                    types.set(i, fi.getContentType());
                }
                if ((name = params.getString("title" + i)).length() == 0) {
                    name = Validator.getFileName((String)osNames.get(i));
                }
                titles.set(i, name);
                copyrights.set(i, state.getAttribute(STATE_MY_COPYRIGHT));
            }
            unqualified_fields.add(i, u_fields);
            ++i;
        }
        state.setAttribute(STATE_ADD_FILE_CONTENT, (Object)contents);
        state.setAttribute(STATE_ADD_FILE_CONTENT_TYPE, (Object)types);
        state.setAttribute(STATE_ADD_FILE_OS_NAME, (Object)osNames);
        state.setAttribute(STATE_ADD_FILE_TITLE, (Object)titles);
        state.setAttribute(STATE_ADD_FILE_COPYRIGHT, (Object)copyrights);
        int repeatedNames_index = this.repeatedName(titles, fileNumber);
        if (repeatedNames_index > 0 && (n = (String)titles.get(repeatedNames_index)).length() > 0) {
            this.addAlert(state, "Can not add files with the same title " + n + ". ");
            unqualified_fields.set(repeatedNames_index, (String)unqualified_fields.get(repeatedNames_index) + n);
        }
        if (state.getAttribute("message") == null) {
            state.setAttribute("mode", (Object)MODE_ADD_FILE_OPTIONS);
            state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)this.emptyVector(11));
        } else {
            state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)unqualified_fields);
        }
    }

    public void doAddfolder(RunData data) {
        String n;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String mycopyright = (String)state.getAttribute(STATE_MY_COPYRIGHT);
        ParameterParser params = data.getParameters();
        String collectionId = params.getString("collectionId");
        state.setAttribute(STATE_COLLECTION_ID, (Object)collectionId);
        int folderNumber = Integer.valueOf(params.getString("folderNumber"));
        state.setAttribute(STATE_ADD_FOLDER_NUMBER, (Object)new Integer(folderNumber));
        Vector titles = this.emptyVector(11);
        Vector descriptions = this.emptyVector(11);
        Vector unqualified_fields = this.emptyVector(11);
        int i = 1;
        while (i <= folderNumber) {
            String u_fields = NULL_STRING;
            String name = params.getString("name" + i);
            String description = params.getString("description" + i);
            if (name.length() == 0) {
                this.addAlert(state, "Please specify the folder name for folder item " + i + ". ");
                u_fields = "DAV:displayname";
            }
            titles.add(i, name);
            descriptions.add(i, description);
            unqualified_fields.add(i, u_fields);
            ++i;
        }
        state.setAttribute(STATE_ADD_FOLDER_TITLE, (Object)titles);
        state.setAttribute(STATE_ADD_FOLDER_DESCRIPTION, (Object)descriptions);
        int repeatedNames_index = this.repeatedName(titles, folderNumber);
        if (repeatedNames_index > 0) {
            n = (String)titles.get(repeatedNames_index);
            if (n.length() > 0) {
                this.addAlert(state, "Can not add folders with the same title " + n + ". ");
                unqualified_fields.set(repeatedNames_index, (String)unqualified_fields.get(repeatedNames_index) + n);
            }
        } else {
            repeatedNames_index = this.foundInResource(titles, folderNumber, state, true);
            if (repeatedNames_index > 0) {
                n = (String)titles.get(repeatedNames_index);
                this.addAlert(state, " The title " + n + " of folder item " + repeatedNames_index + " has been used in resources. Please use a different title. ");
                unqualified_fields.set(repeatedNames_index, (String)unqualified_fields.get(repeatedNames_index) + n);
            } else if (state.getAttribute("message") == null) {
                int i2 = 1;
                while (i2 <= folderNumber) {
                    String newCollectionId = collectionId + (String)((Vector)state.getAttribute(STATE_ADD_FOLDER_TITLE)).get(i2) + "/";
                    ResourcePropertiesEdit resourceProperties = ContentHostingService.newResourceProperties();
                    try {
                        resourceProperties.addProperty("DAV:displayname", (String)((Vector)state.getAttribute(STATE_ADD_FOLDER_TITLE)).get(i2));
                        resourceProperties.addProperty("CHEF:description", (String)((Vector)state.getAttribute(STATE_ADD_FOLDER_DESCRIPTION)).get(i2));
                        resourceProperties.addProperty("CHEF:copyright", (String)state.getAttribute(STATE_MY_COPYRIGHT));
                        ContentCollection collection = ContentHostingService.addCollection(newCollectionId, resourceProperties);
                        state.setAttribute(STATE_ADD_FOLDER_NUMBER, (Object)new Integer((Integer)state.getAttribute(STATE_ADD_FOLDER_NUMBER) - 1));
                    }
                    catch (IdUsedException e) {
                        this.addAlert(state, "The title " + ((Vector)state.getAttribute(STATE_ADD_FOLDER_TITLE)).get(i2) + " is already used. ");
                    }
                    catch (IdInvalidException e) {
                        this.addAlert(state, "The title " + e.getMessage());
                    }
                    catch (PermissionException e) {
                        this.addAlert(state, "You do not have proper permissions to folder " + ((Vector)state.getAttribute(STATE_ADD_FOLDER_TITLE)).get(i2) + ". ");
                    }
                    catch (InconsistentException e) {
                        this.addAlert(state, RESOURCE_INVALID_TITLE_STRING);
                    }
                    ++i2;
                }
            }
        }
        if (state.getAttribute("message") != null) {
            state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)unqualified_fields);
        } else {
            state.setAttribute("mode", (Object)MODE_BROWSE);
            this.initAddFolderContext(state);
            state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)this.emptyVector(11));
        }
    }

    public void doDelete(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        Vector deleteIds = (Vector)state.getAttribute(STATE_DELETE_IDS);
        Hashtable<Integer, Vector<String>> deleteItems = new Hashtable<Integer, Vector<String>>();
        String collectionId = (String)state.getAttribute(STATE_COLLECTION_ID);
        int maxDepth = 0;
        int depth = 0;
        String currentId = NULL_STRING;
        int i = 0;
        while (i < deleteIds.size()) {
            Vector<String> v;
            currentId = (String)deleteIds.elementAt(i);
            depth = ContentHostingService.getDepth(currentId, collectionId);
            if (depth > maxDepth) {
                maxDepth = depth;
            }
            if ((v = (Vector<String>)deleteItems.get(new Integer(depth))) == null) {
                v = new Vector<String>();
            }
            v.add(currentId);
            deleteItems.put(new Integer(depth), v);
            ++i;
        }
        boolean isCollection = false;
        int j = maxDepth;
        while (j > 0) {
            Vector v = (Vector)deleteItems.get(new Integer(j));
            if (v != null) {
                int k = 0;
                while (k < v.size()) {
                    currentId = (String)v.get(k);
                    isCollection = false;
                    String displayName = NULL_STRING;
                    try {
                        isCollection = ContentHostingService.getProperties(currentId).getBooleanProperty("CHEF:is-collection");
                        displayName = ContentHostingService.getProperties(currentId).getPropertyFormatted("DAV:displayname");
                        if (isCollection) {
                            ContentHostingService.removeCollection(currentId);
                        } else {
                            ContentHostingService.removeResource(currentId);
                        }
                    }
                    catch (PermissionException e) {
                        this.addAlert(state, "You do not have proper permission to delete the resource " + displayName + ". ");
                    }
                    catch (IdUnusedException e) {
                        this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
                    }
                    catch (EmptyException e) {
                        this.addAlert(state, "The delete resource " + displayName + " is empty. ");
                    }
                    catch (TypeException e) {
                        this.addAlert(state, "The delete resource " + displayName + " has wrong type. ");
                    }
                    catch (InUseException e) {
                        this.addAlert(state, "The delete resource" + displayName + " is locked by another usage. ");
                    }
                    ++k;
                }
            }
            --j;
        }
        if (state.getAttribute("message") == null) {
            state.setAttribute("mode", (Object)MODE_BROWSE);
            if (((String)state.getAttribute(STATE_SELECT_ALL_FLAG)).equals(Boolean.TRUE.toString())) {
                state.setAttribute(STATE_SELECT_ALL_FLAG, (Object)Boolean.FALSE.toString());
            }
        }
    }

    public void doCancel(RunData data) {
        String from;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String currentMode = (String)state.getAttribute("mode");
        if (currentMode.equals(MODE_ADD_FILE_BASIC)) {
            this.initAddFileContext(state);
        } else if (currentMode.equals(MODE_ADD_FOLDER)) {
            this.initAddFolderContext(state);
        } else if (currentMode.equals(MODE_ADD_SIMPLE_TEXT)) {
            this.initAddSimpleTextContext(state);
        } else if (currentMode.equals(MODE_ADD_URL)) {
            this.initAddURLContext(state);
        } else if (currentMode.equals(MODE_REPLACE)) {
            this.initReplaceContext(state);
        }
        String collectionId = data.getParameters().getString("collectionId");
        if (collectionId != null) {
            state.setAttribute(STATE_COLLECTION_ID, (Object)collectionId);
        }
        if ((from = data.getParameters().getString("from")) != null) {
            state.setAttribute("mode", (Object)from);
        } else {
            state.setAttribute("mode", (Object)MODE_BROWSE);
        }
    }

    public void doHandlepaste(RunData data) {
        ContentResource newResource;
        String propertyName;
        Iterator propertyNames;
        ResourcePropertiesEdit resourceProperties;
        int countNumber;
        ResourceProperties p;
        ContentResource resource;
        ResourceProperties properties;
        int i;
        ParameterParser params = data.getParameters();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        Vector pasteCutItems = (Vector)state.getAttribute(STATE_CUT_IDS);
        Vector pasteCopiedItems = (Vector)state.getAttribute(STATE_COPIED_IDS);
        String collectionId = params.getString("collectionId");
        String originalDisplayName = NULL_STRING;
        if (((String)state.getAttribute(STATE_CUT_FLAG)).equals(Boolean.TRUE.toString())) {
            i = 0;
            while (i < pasteCutItems.size()) {
                String currentPasteCutItem = (String)pasteCutItems.get(i);
                try {
                    properties = ContentHostingService.getProperties(currentPasteCutItem);
                    originalDisplayName = properties.getPropertyFormatted("DAV:displayname");
                    if (properties.getProperty("CHEF:is-collection").equals(Boolean.TRUE.toString())) {
                        this.addAlert(state, RESOURCE_INVALID_OPERATION_ON_COLLECTION_STRING);
                    } else {
                        resource = ContentHostingService.getResource(currentPasteCutItem);
                        p = ContentHostingService.getProperties(currentPasteCutItem);
                        String id = collectionId + p.getProperty("DAV:displayname");
                        boolean addResourceSuccess = false;
                        boolean cutPasteSameCollection = false;
                        String displayName = p.getProperty("DAV:displayname");
                        countNumber = 1;
                        while (!addResourceSuccess) {
                            resourceProperties = ContentHostingService.newResourceProperties();
                            propertyNames = properties.getPropertyNames();
                            while (propertyNames.hasNext()) {
                                propertyName = (String)propertyNames.next();
                                if (properties.isLiveProperty(propertyName)) continue;
                                if (propertyName.equals("DAV:displayname") && displayName.length() > 0) {
                                    resourceProperties.addProperty(propertyName, displayName);
                                    continue;
                                }
                                resourceProperties.addProperty(propertyName, properties.getProperty(propertyName));
                            }
                            try {
                                newResource = ContentHostingService.addResource(id, resource.getContentType(), resource.getContent(), resourceProperties);
                                addResourceSuccess = true;
                            }
                            catch (InconsistentException e) {
                                this.addAlert(state, RESOURCE_INVALID_TITLE_STRING);
                            }
                            catch (OverQuotaException e) {
                                this.addAlert(state, "Adding this resource would place this account over quota. To add this resource, some resources may need to be deleted. ");
                            }
                            catch (IdInvalidException e) {
                                this.addAlert(state, "The title" + e.getMessage());
                            }
                            catch (IdUsedException e) {
                                if (id.equals(currentPasteCutItem)) {
                                    addResourceSuccess = true;
                                    cutPasteSameCollection = true;
                                    continue;
                                }
                                if (countNumber == 1) {
                                    displayName = DUPLICATE_STRING + p.getProperty("DAV:displayname");
                                    id = collectionId + displayName;
                                } else {
                                    displayName = "Copy (" + countNumber + ") of " + p.getProperty("DAV:displayname");
                                    id = collectionId + displayName;
                                }
                                ++countNumber;
                            }
                        }
                        if (!cutPasteSameCollection) {
                            ContentHostingService.removeResource(currentPasteCutItem);
                        }
                    }
                }
                catch (InUseException e) {
                    this.addAlert(state, "Someone else is editing " + originalDisplayName + ". ");
                }
                catch (PermissionException e) {
                    this.addAlert(state, "You do not have proper permissions to cut or paste " + originalDisplayName + ". ");
                }
                catch (IdUnusedException e) {
                    this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
                }
                catch (TypeException e) {
                    this.addAlert(state, " The pasted item " + originalDisplayName + " has type mismatch. ");
                }
                ++i;
            }
        }
        if (((String)state.getAttribute(STATE_COPY_FLAG)).equals(Boolean.TRUE.toString())) {
            i = 0;
            while (i < pasteCopiedItems.size()) {
                String currentPasteCopiedItem = (String)pasteCopiedItems.get(i);
                try {
                    properties = ContentHostingService.getProperties(currentPasteCopiedItem);
                    originalDisplayName = properties.getPropertyFormatted("DAV:displayname");
                    if (properties.getProperty("CHEF:is-collection").equals(Boolean.TRUE.toString())) {
                        this.addAlert(state, RESOURCE_INVALID_OPERATION_ON_COLLECTION_STRING);
                    } else {
                        resource = ContentHostingService.getResource(currentPasteCopiedItem);
                        p = ContentHostingService.getProperties(currentPasteCopiedItem);
                        String displayName = DUPLICATE_STRING + p.getProperty("DAV:displayname");
                        String id = collectionId + displayName;
                        boolean addResourceSuccess = false;
                        boolean cutPasteSameCollection = false;
                        countNumber = 2;
                        resourceProperties = ContentHostingService.newResourceProperties();
                        while (!addResourceSuccess) {
                            propertyNames = properties.getPropertyNames();
                            while (propertyNames.hasNext()) {
                                propertyName = (String)propertyNames.next();
                                if (properties.isLiveProperty(propertyName)) continue;
                                if (propertyName.equals("DAV:displayname") && displayName.length() > 0) {
                                    resourceProperties.addProperty(propertyName, displayName);
                                    continue;
                                }
                                resourceProperties.addProperty(propertyName, properties.getProperty(propertyName));
                            }
                            try {
                                newResource = ContentHostingService.addResource(id, resource.getContentType(), resource.getContent(), resourceProperties);
                                addResourceSuccess = true;
                            }
                            catch (InconsistentException e) {
                                this.addAlert(state, RESOURCE_INVALID_TITLE_STRING);
                            }
                            catch (IdInvalidException e) {
                                this.addAlert(state, "The title" + e.getMessage());
                            }
                            catch (OverQuotaException e) {
                                this.addAlert(state, "Adding this resource would place this account over quota. To add this resource, some resources may need to be deleted. ");
                            }
                            catch (IdUsedException e) {
                                displayName = "Copy (" + countNumber + ") of " + p.getProperty("DAV:displayname");
                                id = collectionId + displayName;
                                ++countNumber;
                            }
                        }
                    }
                }
                catch (PermissionException e) {
                    this.addAlert(state, "You do not have proper permission to cut or paste " + originalDisplayName + ". ");
                }
                catch (IdUnusedException e) {
                    this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
                }
                catch (TypeException e) {
                    this.addAlert(state, " The pasted item " + originalDisplayName + " has type mismatch. ");
                }
                ++i;
            }
        }
        if (state.getAttribute("message") == null) {
            state.setAttribute("mode", (Object)MODE_BROWSE);
            if (((String)state.getAttribute(STATE_CUT_FLAG)).equals(Boolean.TRUE.toString())) {
                state.setAttribute(STATE_CUT_FLAG, (Object)Boolean.FALSE.toString());
            }
            if (((String)state.getAttribute(STATE_COPY_FLAG)).equals(Boolean.TRUE.toString())) {
                state.setAttribute(STATE_COPY_FLAG, (Object)Boolean.FALSE.toString());
            }
        }
    }

    public void doHandlepasteshortcut(RunData data) {
        ParameterParser params = data.getParameters();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        Vector pasteItems = new Vector();
        if (((String)state.getAttribute(STATE_COPY_FLAG)).equals(Boolean.TRUE.toString())) {
            pasteItems = (Vector)((Vector)state.getAttribute(STATE_COPIED_IDS)).clone();
        }
        String collectionId = params.getString("collectionId");
        String originalDisplayName = NULL_STRING;
        int i = 0;
        while (i < pasteItems.size()) {
            String currentPasteItem = (String)pasteItems.get(i);
            try {
                ResourceProperties properties = ContentHostingService.getProperties(currentPasteItem);
                originalDisplayName = properties.getPropertyFormatted("DAV:displayname");
                if (!properties.getProperty("CHEF:is-collection").equals(Boolean.TRUE.toString())) {
                    ContentResource resource = ContentHostingService.getResource(currentPasteItem);
                    ResourceProperties p = ContentHostingService.getProperties(currentPasteItem);
                    String displayName = SHORTCUT_STRING + p.getProperty("DAV:displayname");
                    String id = collectionId + displayName;
                    boolean addResourceSuccess = false;
                    int countNumber = 2;
                    while (!addResourceSuccess) {
                        ResourcePropertiesEdit resourceProperties = ContentHostingService.newResourceProperties();
                        Iterator propertyNames = properties.getPropertyNames();
                        while (propertyNames.hasNext()) {
                            String propertyName = (String)propertyNames.next();
                            if (properties.isLiveProperty(propertyName) || propertyName.equals("DAV:displayname")) continue;
                            resourceProperties.addProperty(propertyName, properties.getProperty(propertyName));
                        }
                        resourceProperties.addProperty("DAV:displayname", displayName);
                        try {
                            ContentResource referedResource = ContentHostingService.getResource(currentPasteItem);
                            ContentResource newResource = ContentHostingService.addResource(id, URL_TYPE, referedResource.getUrl().getBytes(), resourceProperties);
                            addResourceSuccess = true;
                        }
                        catch (InconsistentException e) {
                            this.addAlert(state, RESOURCE_INVALID_TITLE_STRING);
                        }
                        catch (OverQuotaException e) {
                            this.addAlert(state, "Adding this resource would place this account over quota. To add this resource, some resources may need to be deleted. ");
                        }
                        catch (IdInvalidException e) {
                            this.addAlert(state, "The title" + e.getMessage());
                        }
                        catch (IdUsedException e) {
                            displayName = "Shortcut (" + countNumber + ") to " + p.getProperty("DAV:displayname");
                            id = collectionId + displayName;
                            ++countNumber;
                        }
                    }
                }
            }
            catch (PermissionException e) {
                this.addAlert(state, "You do not have proper permission to paste shortcut of " + currentPasteItem.substring(currentPasteItem.lastIndexOf("/") + 1) + ". ");
            }
            catch (IdUnusedException e) {
                this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
            }
            catch (TypeException e) {
                this.addAlert(state, " The pasted item " + currentPasteItem.substring(currentPasteItem.lastIndexOf("/") + 1) + " has type mismatch. ");
            }
            ++i;
        }
        if (((String)state.getAttribute(STATE_COPY_FLAG)).equals(Boolean.TRUE.toString())) {
            state.setAttribute(STATE_COPY_FLAG, (Object)Boolean.FALSE.toString());
        }
        if (state.getAttribute("message") == null) {
            state.setAttribute("mode", (Object)MODE_BROWSE);
        }
    }

    public void doProperties(RunData data) {
        ParameterParser params = data.getParameters();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String id = NULL_STRING;
        String from = params.getString("from");
        if (from != null && from.equals("revise")) {
            String[] reviseIds = data.getParameters().getStrings("selectedMembers");
            if (reviseIds == null) {
                this.addAlert(state, "Please choose the file to revise.");
            } else if (reviseIds.length > 1) {
                this.addAlert(state, "Please choose only one resource at a time for revision. ");
            } else {
                id = reviseIds[0];
                state.setAttribute(STATE_FROM, (Object)MODE_BROWSE);
            }
        } else {
            id = params.getString("id");
            state.setAttribute(STATE_FROM, (Object)MODE_MORE);
        }
        if (id.length() > 0) {
            state.setAttribute(STATE_PROPERTIES_ID, (Object)id);
            String collectionId = (String)state.getAttribute(STATE_COLLECTION_ID);
            ResourceProperties properties = null;
            String displayName = NULL_STRING;
            try {
                properties = ContentHostingService.getProperties(id);
            }
            catch (IdUnusedException e) {
                this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
            }
            catch (PermissionException e) {
                this.addAlert(state, " you do not have permission to view resource " + id + ". ");
            }
        }
        if (state.getAttribute("message") == null) {
            state.setAttribute("mode", (Object)MODE_PROPERTIES);
        }
    }

    public void doModifyproperties(RunData data) {
        ParameterParser params = data.getParameters();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String id = params.getString("id");
        state.setAttribute(STATE_PROPERTIES_ID, (Object)id);
        String mycopyright = (String)state.getAttribute(STATE_MY_COPYRIGHT);
        String collectionId = (String)state.getAttribute(STATE_COLLECTION_ID);
        ResourceProperties properties = null;
        String u_fields = NULL_STRING;
        if (state.getAttribute("message") == null) {
            try {
                String type;
                properties = ContentHostingService.getProperties(id);
                String copyright = params.getString("copyright");
                String newcopyright = params.getString(NEW_COPYRIGHT);
                if (!properties.getBooleanProperty("CHEF:is-collection") || !id.equals((String)state.getAttribute(STATE_HOME_COLLECTION_ID))) {
                    String displayName = params.getString("DAV:displayname");
                    if (displayName.length() == 0) {
                        this.addAlert(state, "The title field can not be null. ");
                        u_fields = u_fields + "DAV:displayname";
                        ContentHostingService.addProperty(id, "DAV:displayname", NULL_STRING);
                    } else {
                        ContentHostingService.addProperty(id, "DAV:displayname", displayName);
                    }
                }
                if (copyright.equals(NEW_COPYRIGHT) && newcopyright.length() == 0) {
                    this.addAlert(state, "please specify the new copyright information. ");
                    u_fields = u_fields + "CHEF:copyright";
                }
                if (copyright.equals(NEW_COPYRIGHT)) {
                    ContentHostingService.addProperty(id, "CHEF:copyright", newcopyright);
                } else {
                    ContentHostingService.addProperty(id, "CHEF:copyright", mycopyright);
                }
                if (params.getString("CHEF:description").length() > 0 && !params.getString("CHEF:description").equals(properties.getProperty("CHEF:description"))) {
                    ContentHostingService.addProperty(id, "CHEF:description", params.getString("CHEF:description"));
                }
                if ((type = properties.getProperty("DAV:getcontenttype")) != null && (type.equals(SIMPLE_TEXT_TYPE) || type.equals(URL_TYPE))) {
                    String content = params.getString("content");
                    try {
                        ContentHostingService.updateResource(id, type, content.getBytes());
                    }
                    catch (IdUnusedException e) {
                        this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
                    }
                    catch (PermissionException e) {
                        this.addAlert(state, " You do not have permission to modify the properties of resource " + properties.getProperty("DAV:displayname") + ". ");
                    }
                    catch (OverQuotaException e) {
                        this.addAlert(state, " Changing this resource will put this account over quota: " + properties.getProperty("DAV:displayname") + ". To change this resource, some resources may need to be deleted.");
                    }
                    catch (TypeException e) {
                        this.addAlert(state, "Type excpetion for " + properties.getProperty("DAV:displayname") + ". ");
                    }
                }
            }
            catch (TypeException e) {
                this.addAlert(state, " type exception " + properties.getProperty("DAV:displayname"));
            }
            catch (IdUnusedException e) {
                this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
            }
            catch (PermissionException e) {
                this.addAlert(state, " You do not have proper permissions to modify the resource " + properties.getProperty("DAV:displayname") + ". ");
            }
            catch (EmptyException e) {
                this.addAlert(state, " Empty exception. ");
            }
            catch (InUseException e) {
                this.addAlert(state, "Someone else is editing " + properties.getProperty("DAV:displayname") + ". ");
            }
        }
        if (state.getAttribute("message") != null) {
            Vector v = (Vector)this.emptyVector(1).clone();
            v.set(1, u_fields);
            state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)v);
        } else {
            state.setAttribute("mode", (Object)MODE_BROWSE);
            state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)((Vector)this.emptyVector(1).clone()));
        }
    }

    public void doReplacefile(RunData data) {
        String n;
        ParameterParser params = data.getParameters();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String collectionId = (String)state.getAttribute(STATE_COLLECTION_ID);
        Vector replaceItems = (Vector)state.getAttribute(STATE_REPLACE_ID);
        int r_size = replaceItems.size() - 1;
        Vector unqualified_fields = (Vector)this.emptyVector(r_size).clone();
        Vector osNames = (Vector)state.getAttribute(STATE_REPLACE_OS_NAME);
        Vector titles = (Vector)state.getAttribute(STATE_REPLACE_TITLE);
        Vector contents = (Vector)state.getAttribute(STATE_REPLACE_CONTENT);
        Vector types = (Vector)state.getAttribute(STATE_REPLACE_CONTENT_TYPE);
        int i = 1;
        while (i <= r_size) {
            String currentReplaceItem = (String)replaceItems.get(i);
            if (currentReplaceItem.length() != 0) {
                String u_fields = NULL_STRING;
                FileItem fi = params.getFileItem("fileName" + i);
                if (fi == null && ((String)osNames.get(i)).length() == 0) {
                    this.addAlert(state, "You must specify the replacement file in the required field below.");
                    u_fields = u_fields + "DAV:displayname";
                } else {
                    String title;
                    if (fi != null) {
                        contents.set(i, fi.get());
                        osNames.set(i, fi.getFileName());
                        types.set(i, fi.getContentType());
                    }
                    if ((title = params.getString("title" + i)).length() == 0) {
                        title = Validator.getFileName((String)osNames.get(i));
                    }
                    titles.set(i, title);
                }
                unqualified_fields.add(i, u_fields);
            }
            ++i;
        }
        state.setAttribute(STATE_REPLACE_CONTENT, (Object)contents);
        state.setAttribute(STATE_REPLACE_CONTENT_TYPE, (Object)types);
        state.setAttribute(STATE_REPLACE_OS_NAME, (Object)osNames);
        state.setAttribute(STATE_REPLACE_TITLE, (Object)titles);
        int repeatedNames_index = this.repeatedName(titles, r_size);
        if (repeatedNames_index > 0) {
            n = (String)titles.get(repeatedNames_index);
            if (n.length() > 0) {
                this.addAlert(state, "Can not add replace file with the same title " + n + ". ");
                unqualified_fields.set(repeatedNames_index, (String)unqualified_fields.get(repeatedNames_index) + n);
            }
        } else {
            repeatedNames_index = this.foundInResource(titles, r_size, state, false);
            if (repeatedNames_index > 0) {
                try {
                    n = (String)titles.get(repeatedNames_index);
                    String s = ContentHostingService.getProperties((String)replaceItems.get(repeatedNames_index)).getProperty("DAV:displayname");
                    if (n.length() > 0 && !s.equalsIgnoreCase(n)) {
                        this.addAlert(state, " The title " + n + " of replace file item " + repeatedNames_index + " has been used in resources. Please use a different title.");
                        unqualified_fields.set(repeatedNames_index, (String)unqualified_fields.get(repeatedNames_index) + n);
                    }
                }
                catch (PermissionException e) {
                    this.addAlert(state, "You are not allowed to view the properties of the resource to be replaced. ");
                }
                catch (IdUnusedException e) {
                    this.addAlert(state, "Can not find the resource which is to be replaced. ");
                }
            }
        }
        if (state.getAttribute("message") == null) {
            int i2 = 1;
            while (i2 <= r_size) {
                String currentReplaceItem = (String)replaceItems.get(i2);
                if (((String)replaceItems.get(i2)).length() != 0) {
                    String displayName = NULL_STRING;
                    try {
                        ContentHostingService.updateResource(currentReplaceItem, (String)((Vector)state.getAttribute(STATE_REPLACE_CONTENT_TYPE)).get(i2), (byte[])((Vector)state.getAttribute(STATE_REPLACE_CONTENT)).get(i2));
                        ContentHostingService.addProperty(currentReplaceItem, "DAV:displayname", (String)((Vector)state.getAttribute(STATE_REPLACE_TITLE)).get(i2));
                    }
                    catch (InUseException e) {
                        this.addAlert(state, "Someone else is editing " + displayName + ". ");
                    }
                    catch (PermissionException e) {
                        this.addAlert(state, " You do not have permission to replace resource " + displayName + ". ");
                    }
                    catch (OverQuotaException e) {
                        this.addAlert(state, " Changing this resource will put this account over quota: " + displayName + ". To change this resource, some resources may need to be deleted.");
                    }
                    catch (IdUnusedException e) {
                        this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
                    }
                    catch (TypeException e) {
                        this.addAlert(state, " The replace resource id= " + displayName + " has type error. ");
                    }
                }
                ++i2;
            }
        }
        if (state.getAttribute("message") != null) {
            state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)unqualified_fields);
        } else {
            state.setAttribute("mode", (Object)MODE_BROWSE);
            if (((String)state.getAttribute(STATE_SELECT_ALL_FLAG)).equals(Boolean.TRUE.toString())) {
                state.setAttribute(STATE_SELECT_ALL_FLAG, (Object)Boolean.FALSE.toString());
            }
            this.initReplaceContext(state);
            state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)this.emptyVector(11));
        }
    }

    public void doAddsimpletext(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String mycopyright = (String)state.getAttribute(STATE_MY_COPYRIGHT);
        ParameterParser params = data.getParameters();
        String collectionId = NULL_STRING;
        Object inputStream = null;
        String content = params.getString("content");
        state.setAttribute(STATE_ADD_SIMPLE_TEXT_CONTENT, (Object)content);
        String copyright = params.getString("copyright");
        state.setAttribute(STATE_ADD_SIMPLE_TEXT_COPYRIGHT, (Object)copyright);
        String newcopyright = params.getString(NEW_COPYRIGHT);
        state.setAttribute(STATE_ADD_SIMPLE_TEXT_NEW_COPYRIGHT, (Object)newcopyright);
        String target = NEW_WINDOW;
        state.setAttribute(STATE_ADD_SIMPLE_TEXT_TARGET, (Object)target);
        collectionId = params.getString("collectionId");
        String title = params.getString("title");
        state.setAttribute(STATE_ADD_SIMPLE_TEXT_TITLE, (Object)title);
        String description = params.getString("description");
        state.setAttribute(STATE_ADD_SIMPLE_TEXT_DESCRIPTION, (Object)description);
        String u_fields = NULL_STRING;
        if (title.equals(NULL_STRING)) {
            this.addAlert(state, "Please specify the file title. ");
            u_fields = u_fields + "DAV:displayname";
        }
        if (content.equals(NULL_STRING)) {
            this.addAlert(state, "Please specify the file content. ");
            u_fields = u_fields + "content";
        }
        if (copyright.equals(NEW_COPYRIGHT) && newcopyright.length() == 0) {
            this.addAlert(state, "Please specify the copyright information. ");
            u_fields = u_fields + "CHEF:copyright";
        }
        if (state.getAttribute("message") == null) {
            String newResourceId = collectionId + title;
            Vector<String> titles = new Vector<String>();
            titles.add(0, NULL_STRING);
            titles.add(1, title);
            int repeatedNames_index = this.foundInResource(titles, 1, state, false);
            if (repeatedNames_index != 0) {
                u_fields = u_fields + " " + title;
                this.addAlert(state, " The title " + title + " has been used in the resources. ");
            } else {
                ResourcePropertiesEdit resourceProperties = ContentHostingService.newResourceProperties();
                resourceProperties.addProperty("DAV:displayname", title);
                resourceProperties.addProperty("CHEF:description", description);
                if (!copyright.equals(NEW_COPYRIGHT)) {
                    resourceProperties.addProperty("CHEF:copyright", mycopyright);
                } else {
                    resourceProperties.addProperty("CHEF:copyright", newcopyright);
                }
                resourceProperties.addProperty("CHEF:open-newwindow", target);
                try {
                    ContentResource resource = ContentHostingService.addResource(newResourceId, SIMPLE_TEXT_TYPE, content.getBytes(), resourceProperties);
                }
                catch (IdUsedException e) {
                    this.addAlert(state, "The resource title " + title + " has been used. ");
                }
                catch (IdInvalidException e) {
                    this.addAlert(state, "The title " + title + " is invalid. ");
                }
                catch (PermissionException e) {
                    this.addAlert(state, "You do not have proper permissions to add the simple text resources. ");
                }
                catch (OverQuotaException e) {
                    this.addAlert(state, "Adding this resource would place this account over quota. To add this resource, some resources may need to be deleted.");
                }
                catch (InconsistentException e) {
                    this.addAlert(state, RESOURCE_INVALID_TITLE_STRING);
                }
            }
        }
        if (state.getAttribute("message") != null) {
            Vector v = (Vector)this.emptyVector(1).clone();
            v.set(1, u_fields);
            state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)v);
        } else {
            state.setAttribute("mode", (Object)MODE_BROWSE);
            this.initAddSimpleTextContext(state);
            state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)((Vector)this.emptyVector(1).clone()));
        }
    }

    public void doAddurl(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String mycopyright = (String)state.getAttribute(STATE_MY_COPYRIGHT);
        ParameterParser params = data.getParameters();
        String collectionId = params.getString("collectionId");
        state.setAttribute(STATE_COLLECTION_ID, (Object)collectionId);
        int UrlNumber = Integer.valueOf(params.getString("UrlNumber"));
        state.setAttribute(STATE_ADD_URL_NUMBER, (Object)new Integer(UrlNumber));
        Vector urls = this.emptyVector(11);
        Vector titles = this.emptyVector(11);
        Vector descriptions = this.emptyVector(11);
        Vector copyrights = this.emptyVector(11);
        Vector newcopyrights = this.emptyVector(11);
        Vector targets = this.emptyVector(11);
        Vector unqualified_fields = this.emptyVector(11);
        boolean sameURLName = false;
        int i = 1;
        while (i <= UrlNumber) {
            String u_fields = NULL_STRING;
            String url = params.getString("Url" + i);
            if (url.equals(NULL_STRING)) {
                this.addAlert(state, "Please specify the URL field. ");
                u_fields = u_fields + "URLcontent";
            } else if (url.indexOf("://") == -1) {
                url = "http://" + url;
            }
            try {
                URL u = new URL(url);
            }
            catch (MalformedURLException e) {
                this.addAlert(state, "Please enter a valid URL string. ");
            }
            urls.set(i, url);
            String title = params.getString("title" + i);
            if (title.equals(NULL_STRING)) {
                title = url;
            }
            titles.set(i, title);
            String description = params.getString("description" + i);
            descriptions.set(i, description);
            String copyright = params.getString("copyright" + i);
            copyrights.set(i, copyright);
            String newcopyright = params.getString(NEW_COPYRIGHT + i);
            if (copyright.equals(NEW_COPYRIGHT) && newcopyright.length() == 0) {
                this.addAlert(state, "Please specify the new copyright information of URL item " + i + ". ");
                u_fields = u_fields + "CHEF:copyright";
            }
            newcopyrights.set(i, newcopyright);
            String target = Boolean.TRUE.toString();
            targets.set(i, target);
            unqualified_fields.set(i, u_fields);
            ++i;
        }
        state.setAttribute(STATE_ADD_URL_URL, (Object)urls);
        state.setAttribute(STATE_ADD_URL_TITLE, (Object)titles);
        state.setAttribute(STATE_ADD_URL_DESCRIPTION, (Object)descriptions);
        state.setAttribute(STATE_ADD_URL_COPYRIGHT, (Object)copyrights);
        state.setAttribute(STATE_ADD_URL_NEW_COPYRIGHT, (Object)newcopyrights);
        state.setAttribute(STATE_ADD_URL_TARGET, (Object)targets);
        if (state.getAttribute("message") == null) {
            String n;
            int repeatedNames_index = this.repeatedName(titles, UrlNumber);
            if (repeatedNames_index > 0) {
                n = (String)titles.get(repeatedNames_index);
                if (n.length() > 0) {
                    this.addAlert(state, "Can not add URL with the same title " + n + ". ");
                    unqualified_fields.set(repeatedNames_index, (String)unqualified_fields.get(repeatedNames_index) + n);
                }
            } else {
                repeatedNames_index = this.foundInResource(titles, UrlNumber, state, false);
                if (repeatedNames_index > 0) {
                    n = (String)titles.get(repeatedNames_index);
                    this.addAlert(state, " The title " + n + " of URL item " + repeatedNames_index + " has been used in resources. Please use a different title. ");
                    unqualified_fields.set(repeatedNames_index, (String)unqualified_fields.get(repeatedNames_index) + n);
                } else {
                    int i2 = 1;
                    while (i2 <= UrlNumber) {
                        String currentTitle = (String)((Vector)state.getAttribute(STATE_ADD_URL_TITLE)).get(i2);
                        String newResourceId = collectionId + Validator.escapeResourceName(currentTitle);
                        ResourcePropertiesEdit resourceProperties = ContentHostingService.newResourceProperties();
                        resourceProperties.addProperty("DAV:displayname", currentTitle);
                        resourceProperties.addProperty("CHEF:description", (String)((Vector)state.getAttribute(STATE_ADD_URL_DESCRIPTION)).get(i2));
                        if (((String)((Vector)state.getAttribute(STATE_ADD_URL_COPYRIGHT)).get(i2)).equals(NEW_COPYRIGHT)) {
                            resourceProperties.addProperty("CHEF:copyright", (String)((Vector)state.getAttribute(STATE_ADD_URL_NEW_COPYRIGHT)).get(i2));
                        } else {
                            resourceProperties.addProperty("CHEF:copyright", mycopyright);
                        }
                        resourceProperties.addProperty("CHEF:open-newwindow", (String)((Vector)state.getAttribute(STATE_ADD_URL_TARGET)).get(i2));
                        try {
                            ContentResource resource = ContentHostingService.addResource(newResourceId, URL_TYPE, ((String)((Vector)state.getAttribute(STATE_ADD_URL_URL)).get(i2)).getBytes(), resourceProperties);
                        }
                        catch (IdUsedException e) {
                            this.addAlert(state, " The URL title " + currentTitle + " has been used. ");
                        }
                        catch (IdInvalidException e) {
                            this.addAlert(state, " The URL title" + e.getMessage());
                        }
                        catch (PermissionException e) {
                            this.addAlert(state, " You do not have proper permissions to add the URL " + currentTitle + ". ");
                        }
                        catch (OverQuotaException e) {
                            this.addAlert(state, "Adding this resource would place this account over quota. To add this resource, some resources may need to be deleted. ");
                        }
                        catch (InconsistentException e) {
                            this.addAlert(state, " The title cannot contain any of the following characters: / \\ % ");
                        }
                        ++i2;
                    }
                }
            }
        }
        if (state.getAttribute("message") != null) {
            state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)unqualified_fields);
        } else {
            state.setAttribute("mode", (Object)MODE_BROWSE);
            this.initAddURLContext(state);
            state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)this.emptyVector(11));
        }
    }

    public void doSort(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        String criteria = params.getString("criteria");
        if (criteria.equals("title")) {
            criteria = "DAV:displayname";
        } else if (criteria.equals("size")) {
            criteria = "DAV:getcontentlength";
        } else if (criteria.equals("created by")) {
            criteria = "CHEF:creator";
        } else if (criteria.equals("last modified")) {
            criteria = "DAV:getlastmodified";
        }
        String asc = NULL_STRING;
        if (!criteria.equals(state.getAttribute(STATE_SORT_BY))) {
            state.setAttribute(STATE_SORT_BY, (Object)criteria);
            asc = Boolean.TRUE.toString();
            state.setAttribute(STATE_SORT_ASC, (Object)asc);
        } else {
            asc = (String)state.getAttribute(STATE_SORT_ASC);
            asc = asc.equals(Boolean.TRUE.toString()) ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
            state.setAttribute(STATE_SORT_ASC, (Object)asc);
        }
        if (state.getAttribute("message") == null) {
            state.setAttribute("mode", (Object)MODE_BROWSE);
        }
    }

    public void doDeleteconfirm(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String[] deleteIds = data.getParameters().getStrings("selectedMembers");
        if (deleteIds == null) {
            this.addAlert(state, "Please choose the file(s) to delete. ");
        } else {
            Vector<String> deleteIdsVector = new Vector<String>();
            String notEmptyDeleteIds = NULL_STRING;
            String nonDeleteIds = NULL_STRING;
            int i = 0;
            while (i < deleteIds.length) {
                String currentId = deleteIds[i];
                try {
                    ResourceProperties p = ContentHostingService.getProperties(currentId);
                    String name = p.getPropertyFormatted("DAV:displayname");
                    if (p.getPropertyFormatted("CHEF:is-collection").equals(Boolean.TRUE.toString())) {
                        if (ContentHostingService.allowRemoveCollection(currentId)) {
                            deleteIdsVector.add(currentId);
                            ContentCollection c = ContentHostingService.getCollection(currentId);
                            Iterator iterator = c.getMembers().iterator();
                            if (iterator.hasNext()) {
                                notEmptyDeleteIds = notEmptyDeleteIds.length() > 0 ? notEmptyDeleteIds + ", " + name : name;
                            }
                        } else {
                            nonDeleteIds = nonDeleteIds.length() > 0 ? nonDeleteIds + ", " + name : name;
                        }
                    } else if (ContentHostingService.allowRemoveResource(currentId)) {
                        deleteIdsVector.add(currentId);
                    } else {
                        nonDeleteIds = nonDeleteIds.length() > 0 ? nonDeleteIds + "; " + name : name;
                    }
                }
                catch (PermissionException e) {
                }
                catch (IdUnusedException e) {
                    this.addAlert(state, "The resource \"" + currentId + "\"" + " does not exist. ");
                }
                catch (TypeException e) {
                    // empty catch block
                }
                ++i;
            }
            if (nonDeleteIds.length() > 0) {
                this.addAlert(state, "You do not have permissions to delete: " + nonDeleteIds);
            }
            state.setAttribute(STATE_DELETE_IDS, deleteIdsVector);
            state.setAttribute(STATE_NOT_EMPTY_DELETE_IDS, (Object)notEmptyDeleteIds);
        }
        if (state.getAttribute("message") == null) {
            state.setAttribute("mode", (Object)"deleteConfirm");
        }
    }

    public void doPrereplace(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        Vector<String> replaceItemsVector = new Vector<String>();
        replaceItemsVector.add(0, NULL_STRING);
        Vector<String> titles = new Vector<String>();
        titles.add(0, NULL_STRING);
        String[] replaceItems = data.getParameters().getStrings("selectedMembers");
        if (replaceItems == null) {
            String id = data.getParameters().getString("id");
            if (id == null) {
                this.addAlert(state, "Please choose the file(s) to replace. ");
                state.setAttribute("mode", (Object)MODE_BROWSE);
            } else {
                replaceItemsVector.add(id);
            }
        } else {
            int i = 0;
            while (i < replaceItems.length) {
                replaceItemsVector.add(replaceItems[i]);
                ++i;
            }
        }
        boolean qualify = true;
        if (replaceItemsVector.size() > 10) {
            this.addAlert(state, " You can not replace more than 10 items at one time. ");
        } else {
            int i = 1;
            while (i < replaceItemsVector.size()) {
                String displayName = NULL_STRING;
                String id = (String)replaceItemsVector.get(i);
                try {
                    if (ContentHostingService.getProperties(id).getPropertyFormatted("CHEF:is-collection").equals(Boolean.TRUE.toString())) {
                        qualify = false;
                    } else if (ContentHostingService.getProperties(id).getProperty("DAV:getcontenttype").equals(URL_TYPE)) {
                        qualify = false;
                    } else if (ContentHostingService.getProperties(id).getProperty("DAV:getcontenttype").equals(SIMPLE_TEXT_TYPE)) {
                        qualify = false;
                    }
                    displayName = ContentHostingService.getProperties(id).getPropertyFormatted("DAV:displayname");
                    if (displayName.indexOf(SHORTCUT_STRING) != -1) {
                        qualify = false;
                    }
                    titles.add(i, displayName);
                }
                catch (PermissionException e) {
                    this.addAlert(state, "You do not have proper permission to replace " + displayName + ". ");
                }
                catch (IdUnusedException e) {
                    this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
                }
                ++i;
            }
        }
        if (!qualify) {
            this.addAlert(state, " You can not replace folders, URLs, simple text files or shortcuts. To make changes, choose \"Revise\". ");
        }
        if (state.getAttribute("message") == null) {
            if (replaceItemsVector.size() > 0) {
                state.setAttribute(STATE_REPLACE_ID, replaceItemsVector);
            }
            state.setAttribute(STATE_REPLACE_TITLE, titles);
            state.setAttribute("mode", (Object)MODE_REPLACE);
        }
    }

    public void doCut(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String[] cutItems = data.getParameters().getStrings("selectedMembers");
        if (cutItems == null) {
            this.addAlert(state, "Please choose the file(s) to cut.");
            state.setAttribute("mode", (Object)MODE_BROWSE);
        } else {
            Vector<String> cutIdsVector = new Vector<String>();
            String nonCutIds = NULL_STRING;
            int i = 0;
            while (i < cutItems.length) {
                try {
                    ResourceProperties properties = ContentHostingService.getProperties(cutItems[i]);
                    if (properties.getProperty("CHEF:is-collection").equals(Boolean.TRUE.toString())) {
                        this.addAlert(state, RESOURCE_INVALID_OPERATION_ON_COLLECTION_STRING);
                    } else if (ContentHostingService.allowRemoveResource(cutItems[i])) {
                        cutIdsVector.add(cutItems[i]);
                    } else {
                        nonCutIds = nonCutIds + " " + properties.getProperty("DAV:displayname") + "; ";
                    }
                }
                catch (PermissionException e) {
                    this.addAlert(state, "You do not have proper permission to view the properties. ");
                }
                catch (IdUnusedException e) {
                    this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
                }
                ++i;
            }
            if (state.getAttribute("message") == null) {
                if (nonCutIds.length() > 0) {
                    this.addAlert(state, "You do not have permissions to cut " + nonCutIds);
                }
                if (cutIdsVector.size() > 0) {
                    state.setAttribute(STATE_CUT_FLAG, (Object)Boolean.TRUE.toString());
                    if (((String)state.getAttribute(STATE_SELECT_ALL_FLAG)).equals(Boolean.TRUE.toString())) {
                        state.setAttribute(STATE_SELECT_ALL_FLAG, (Object)Boolean.FALSE.toString());
                    }
                    Vector copiedIds = (Vector)state.getAttribute(STATE_COPIED_IDS);
                    int i2 = 0;
                    while (i2 < cutIdsVector.size()) {
                        String currentId = (String)cutIdsVector.elementAt(i2);
                        if (copiedIds.contains(currentId)) {
                            copiedIds.remove(currentId);
                        }
                        ++i2;
                    }
                    if (copiedIds.size() == 0) {
                        state.setAttribute(STATE_COPY_FLAG, (Object)Boolean.FALSE.toString());
                    }
                    state.setAttribute(STATE_COPIED_IDS, (Object)copiedIds);
                    state.setAttribute(STATE_CUT_IDS, cutIdsVector);
                }
            }
        }
    }

    public void doCopy(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        Vector<String> copyItemsVector = new Vector<String>();
        String[] copyItems = data.getParameters().getStrings("selectedMembers");
        if (copyItems == null) {
            this.addAlert(state, "Please choose the file(s) to copy.");
            state.setAttribute("mode", (Object)MODE_BROWSE);
        } else {
            int i = 0;
            while (i < copyItems.length) {
                try {
                    ResourceProperties properties = ContentHostingService.getProperties(copyItems[i]);
                    if (properties.getProperty("CHEF:is-collection").equals(Boolean.TRUE.toString())) {
                        this.addAlert(state, RESOURCE_INVALID_OPERATION_ON_COLLECTION_STRING);
                    }
                }
                catch (PermissionException e) {
                    this.addAlert(state, "You do not have proper permission to the properties. ");
                }
                catch (IdUnusedException e) {
                    this.addAlert(state, RESOURCE_NOT_EXIST_STRING);
                }
                ++i;
            }
            if (state.getAttribute("message") == null) {
                state.setAttribute(STATE_COPY_FLAG, (Object)Boolean.TRUE.toString());
                if (((String)state.getAttribute(STATE_SELECT_ALL_FLAG)).equals(Boolean.TRUE.toString())) {
                    state.setAttribute(STATE_SELECT_ALL_FLAG, (Object)Boolean.FALSE.toString());
                }
                Vector cutIds = (Vector)state.getAttribute(STATE_CUT_IDS);
                int i2 = 0;
                while (i2 < copyItems.length) {
                    if (cutIds.contains(copyItems[i2])) {
                        cutIds.remove(copyItems[i2]);
                    }
                    copyItemsVector.add(copyItems[i2]);
                    ++i2;
                }
                if (cutIds.size() == 0) {
                    state.setAttribute(STATE_CUT_FLAG, (Object)Boolean.FALSE.toString());
                }
                state.setAttribute(STATE_CUT_IDS, (Object)cutIds);
                state.setAttribute(STATE_COPIED_IDS, copyItemsVector);
            }
        }
    }

    public void doSelectall(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_SELECT_ALL_FLAG, (Object)Boolean.TRUE.toString());
    }

    public void doUnselectall(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_SELECT_ALL_FLAG, (Object)Boolean.FALSE.toString());
    }

    public void doExpandall(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        HashSet expandedCollectionIds = (HashSet)state.getAttribute(EXPANDED_COLLECTIONS);
        String currentCollectionId = params.getString("collectionId");
        try {
            ContentCollection currentCollection = ContentHostingService.getCollection(currentCollectionId);
            Iterator allCollectionIterator = this.threadIterator(currentCollection.getMembers().iterator());
            while (allCollectionIterator.hasNext()) {
                String newId = (String)allCollectionIterator.next();
                if (expandedCollectionIds.contains(newId)) continue;
                expandedCollectionIds.add(newId);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        state.setAttribute(EXPANDED_COLLECTIONS, (Object)expandedCollectionIds);
        state.setAttribute(STATE_EXPAND_ALL_FLAG, (Object)Boolean.TRUE.toString());
    }

    public void doUnexpandall(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(EXPANDED_COLLECTIONS, new HashSet());
        state.setAttribute(STATE_EXPAND_ALL_FLAG, (Object)Boolean.FALSE.toString());
    }

    protected Iterator threadIterator(Iterator topLevel) {
        final Stack stack = new Stack();
        Vector<String> v = new Vector<String>();
        while (topLevel.hasNext()) {
            String rId = (String)topLevel.next();
            try {
                if (!ContentHostingService.getProperties(rId).getBooleanProperty("CHEF:is-collection")) continue;
                v.add(rId);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        stack.push(v.iterator());
        return new Iterator(){
            private Object m_next = null;
            private Stack m_stack = stack;
            private Set m_alreadyReturned = new HashSet();

            public Object next() {
                this.hasNext();
                if (this.m_next == null) {
                    throw new NoSuchElementException();
                }
                Object rv = this.m_next;
                this.m_next = null;
                this.m_alreadyReturned.add(rv);
                return rv;
            }

            /*
             * Unable to fully structure code
             */
            public boolean hasNext() {
                block12: {
                    if (this.m_next == null) ** GOTO lbl5
                    return true;
lbl-1000:
                    // 1 sources

                    {
                        this.m_stack.pop();
lbl5:
                        // 2 sources

                        ** while (!this.m_stack.empty() && !((Iterator)this.m_stack.peek()).hasNext())
                    }
lbl6:
                    // 1 sources

                    if (this.m_stack.empty()) {
                        return false;
                    }
                    this.m_next = ((Iterator)this.m_stack.peek()).next();
                    if (!this.m_alreadyReturned.contains(this.m_next)) {
                        try {
                            members = ContentHostingService.getCollection((String)this.m_next).getMemberResources();
                            vNew = new Vector<String>();
                            if (members == null || members.size() == 0) break block12;
                            j = 0;
                            while (j < members.size()) {
                                try {
                                    p = ContentHostingService.getProperties(((Resource)members.get(j)).getId());
                                    if (p.getBooleanProperty("CHEF:is-collection")) {
                                        vNew.add(((Resource)members.get(j)).getId());
                                    }
                                }
                                catch (PermissionException ignore) {
                                }
                                catch (EmptyException ignore) {
                                }
                                catch (IdUnusedException ignore) {
                                }
                                catch (TypeException ignore) {
                                    // empty catch block
                                }
                                ++j;
                            }
                            this.m_stack.push(vNew.iterator());
                        }
                        catch (Exception var1_2) {
                            // empty catch block
                        }
                    }
                }
                return true;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void buildMenu(VelocityPortlet portlet, Context context, RunData data, SessionState state, boolean allowAdd, boolean allowRemove, boolean allowReplace, boolean allowRevise, boolean emptyFolder, boolean atHome) {
        String copyFlag = (String)state.getAttribute(STATE_COPY_FLAG);
        String cutFlag = (String)state.getAttribute(STATE_CUT_FLAG);
        String formName = "showForm";
        Menu bar = new Menu((Portlet)portlet, data, "ResourcesAction");
        bar.add(new MenuEntry("New...", null, allowAdd, 0, "doNewitem", formName));
        bar.add(new MenuEntry("Delete", null, !emptyFolder && allowRemove, 0, "doDeleteconfirm", formName));
        bar.add(new MenuEntry("Cut", null, allowAdd && !emptyFolder, 0, "doCut", formName));
        bar.add(new MenuEntry("Copy", null, allowAdd && !emptyFolder, 0, "doCopy", formName));
        if (copyFlag.equals(Boolean.TRUE.toString()) || cutFlag.equals(Boolean.TRUE.toString())) {
            bar.add(new MenuEntry("Paste", null, allowAdd, 0, "doHandlepaste", formName));
            bar.add(new MenuEntry("Paste Shortcut", null, allowAdd, 0, "doHandlepasteshortcut", formName));
        } else {
            bar.add(new MenuEntry("Paste", null, false, 0, "doHandlepaste", formName));
            bar.add(new MenuEntry("Paste Shortcut", null, false, 0, "doHandlepasteshortcut", formName));
        }
        bar.add(new MenuEntry("Replace...", null, allowReplace && !emptyFolder, 0, "doPrereplace", formName));
        bar.add(new MenuEntry("Revise...", null, allowRevise && !emptyFolder, 0, "doProperties", formName));
        if (state.getAttribute(STATE_SELECT_ALL_FLAG).equals(Boolean.FALSE.toString())) {
            bar.add(new MenuEntry("Select All", null, !emptyFolder, 0, "doSelectall", formName));
        } else {
            bar.add(new MenuEntry("Unselect All", null, !emptyFolder, 0, "doUnselectall", formName));
        }
        if (state.getAttribute(STATE_EXPAND_ALL_FLAG).equals(Boolean.FALSE.toString())) {
            bar.add(new MenuEntry("Expand All", null, !emptyFolder, 0, "doExpandall", formName));
        } else {
            bar.add(new MenuEntry("Collapse All", null, !emptyFolder, 0, "doUnexpandall", formName));
        }
        if (!RESOURCES_MODE_DROPBOX.equalsIgnoreCase((String)state.getAttribute(STATE_RESOURCES_MODE)) && SiteService.allowUpdateSite(PortalService.getCurrentSiteId())) {
            if (atHome) {
                bar.add(new MenuEntry("Permissions...", "doPermissions"));
            } else {
                bar.add(new MenuEntry("Folder Permissions...", "doFolder_permissions"));
            }
        }
        context.put("menu", bar);
        context.put("action", state.getAttribute("action"));
    }

    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData data) {
        super.initState(state, portlet, data);
        if (state.getAttribute(STATE_INITIALIZED) != null) {
            return;
        }
        state.setAttribute(STATE_CONTENT_SERVICE, (Object)TurbineServices.getInstance().getService(GenericContentHostingService.SERVICE_NAME));
        state.setAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE, (Object)TurbineServices.getInstance().getService(ContentTypeImageService.SERVICE_NAME));
        TimeBreakdown timeBreakdown = new Time().breakdownLocal();
        String mycopyright = "&#169; " + timeBreakdown.getYear() + ", " + UsageSessionService.getSessionUser().getDisplayName() + ". All Rights Reserved. ";
        state.setAttribute(STATE_MY_COPYRIGHT, (Object)mycopyright);
        state.setAttribute("mode", (Object)MODE_BROWSE);
        state.setAttribute(STATE_SORT_BY, (Object)"DAV:displayname");
        state.setAttribute(STATE_SORT_ASC, (Object)Boolean.TRUE.toString());
        state.setAttribute(STATE_SELECT_ALL_FLAG, (Object)Boolean.FALSE.toString());
        state.setAttribute(STATE_EXPAND_ALL_FLAG, (Object)Boolean.FALSE.toString());
        state.setAttribute(STATE_FROM, (Object)NULL_STRING);
        state.setAttribute(STATE_COLLECTION_PATH, new Vector());
        String resources_mode = portlet.getPortletConfig().getInitParameter("resources_mode");
        state.setAttribute(STATE_RESOURCES_MODE, (Object)resources_mode);
        String home = StringUtil.trimToNull(portlet.getPortletConfig().getInitParameter("home"));
        state.setAttribute(STATE_HOME_COLLECTION_DISPLAY_NAME, (Object)home);
        if (home == null || home.length() == 0) {
            if (resources_mode.equalsIgnoreCase(RESOURCES_MODE_DROPBOX) && (home = Dropbox.getCollection()) != null) {
                state.setAttribute(STATE_HOME_COLLECTION_DISPLAY_NAME, (Object)Dropbox.getDisplayName());
                Dropbox.createCollection();
            }
            if (home == null || home.length() == 0) {
                home = DefaultId.getCollection();
                state.setAttribute(STATE_HOME_COLLECTION_DISPLAY_NAME, (Object)DefaultId.getDisplayName());
            }
        }
        state.setAttribute(STATE_HOME_COLLECTION_ID, (Object)home);
        state.setAttribute(STATE_COLLECTION_ID, state.getAttribute(STATE_HOME_COLLECTION_ID));
        HashSet expandedCollections = new HashSet();
        state.setAttribute(EXPANDED_COLLECTIONS, expandedCollections);
        this.initCopyContext(state);
        this.initCutContext(state);
        this.initAddFileContext(state);
        this.initAddFolderContext(state);
        this.initAddSimpleTextContext(state);
        this.initAddURLContext(state);
        this.initReplaceContext(state);
        if (state.getAttribute("obsever") == null) {
            String deliveryId = this.clientWindowId(state, portlet.getID());
            String elementId = VelocityPortletPaneledAction.mainPanelUpdateId(portlet.getID());
            String pattern = ContentHostingService.getReference(NULL_STRING);
            state.setAttribute("obsever", (Object)new EventObservingCourier(deliveryId, elementId, pattern));
        }
        state.setAttribute(STATE_INITIALIZED, (Object)Boolean.TRUE.toString());
        this.updateObservation(state, portlet.getID());
    }

    private void updateObservation(SessionState state, String peid) {
        EventObservingCourier observer = (EventObservingCourier)state.getAttribute("obsever");
        String pattern = ContentHostingService.getReference(NULL_STRING);
        observer.setResourcePattern(pattern);
        String deliveryId = this.clientWindowId(state, peid);
        observer.setDeliveryId(deliveryId);
    }

    private void initCopyContext(SessionState state) {
        state.setAttribute(STATE_COPIED_IDS, new Vector());
        state.setAttribute(STATE_COPY_FLAG, (Object)Boolean.FALSE.toString());
    }

    private void initCutContext(SessionState state) {
        state.setAttribute(STATE_CUT_IDS, new Vector());
        state.setAttribute(STATE_CUT_FLAG, (Object)Boolean.FALSE.toString());
    }

    private void initAddFileContext(SessionState state) {
        state.setAttribute(STATE_ADD_FILE_NUMBER, (Object)new Integer(1));
        Vector emptyVector = this.emptyVector(11);
        state.setAttribute(STATE_ADD_FILE_OS_NAME, emptyVector.clone());
        state.setAttribute(STATE_ADD_FILE_TITLE, emptyVector.clone());
        state.setAttribute(STATE_ADD_FILE_COPYRIGHT, emptyVector.clone());
        state.setAttribute(STATE_ADD_FILE_CONTENT_TYPE, emptyVector.clone());
        state.setAttribute(STATE_ADD_FILE_NEW_COPYRIGHT, emptyVector.clone());
        state.setAttribute(STATE_ADD_FILE_DESCRIPTION, emptyVector.clone());
        state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, emptyVector.clone());
        Vector<byte[]> emptyByteVector = new Vector<byte[]>();
        int i = 0;
        while (i < 11) {
            emptyByteVector.add(i, new byte[1]);
            ++i;
        }
        state.setAttribute(STATE_ADD_FILE_CONTENT, emptyByteVector);
        Vector<String> targetVector = new Vector<String>();
        int i2 = 0;
        while (i2 < 11) {
            targetVector.add(Boolean.TRUE.toString());
            ++i2;
        }
        state.setAttribute(STATE_ADD_FILE_TARGET, targetVector);
    }

    private void initAddFolderContext(SessionState state) {
        state.setAttribute(STATE_ADD_FOLDER_NUMBER, (Object)new Integer(1));
        Vector emptyVector = this.emptyVector(11);
        state.setAttribute(STATE_ADD_FOLDER_TITLE, emptyVector.clone());
        state.setAttribute(STATE_ADD_FOLDER_COPYRIGHT, emptyVector.clone());
        state.setAttribute(STATE_ADD_FOLDER_DESCRIPTION, emptyVector.clone());
        state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, emptyVector.clone());
    }

    private void initAddSimpleTextContext(SessionState state) {
        state.setAttribute(STATE_ADD_SIMPLE_TEXT_CONTENT, (Object)NULL_STRING);
        state.setAttribute(STATE_ADD_SIMPLE_TEXT_TITLE, (Object)NULL_STRING);
        state.setAttribute(STATE_ADD_SIMPLE_TEXT_COPYRIGHT, (Object)NULL_STRING);
        state.setAttribute(STATE_ADD_SIMPLE_TEXT_NEW_COPYRIGHT, (Object)NULL_STRING);
        state.setAttribute(STATE_ADD_SIMPLE_TEXT_DESCRIPTION, (Object)NULL_STRING);
        state.setAttribute(STATE_ADD_SIMPLE_TEXT_TARGET, (Object)Boolean.TRUE.toString());
        Vector emptyVector = this.emptyVector(11);
        state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, (Object)emptyVector);
    }

    private void initAddURLContext(SessionState state) {
        state.setAttribute(STATE_ADD_URL_NUMBER, (Object)new Integer(1));
        Vector v = this.emptyVector(11);
        state.setAttribute(STATE_ADD_URL_TITLE, v.clone());
        state.setAttribute(STATE_ADD_URL_COPYRIGHT, v.clone());
        state.setAttribute(STATE_ADD_URL_URL, v.clone());
        state.setAttribute(STATE_ADD_URL_NEW_COPYRIGHT, v.clone());
        state.setAttribute(STATE_ADD_URL_DESCRIPTION, v.clone());
        state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, v.clone());
        Vector<String> targetVector = new Vector<String>();
        int i = 0;
        while (i < 11) {
            targetVector.add(Boolean.TRUE.toString());
            ++i;
        }
        state.setAttribute(STATE_ADD_URL_TARGET, targetVector);
    }

    private void initReplaceContext(SessionState state) {
        Vector v = this.emptyVector(11);
        state.setAttribute(STATE_REPLACE_ID, v.clone());
        state.setAttribute(STATE_REPLACE_OS_NAME, v.clone());
        state.setAttribute(STATE_REPLACE_TITLE, v.clone());
        state.setAttribute(STATE_REPLACE_CONTENT_TYPE, v.clone());
        state.setAttribute(STATE_UNQUALIFIED_INPUT_FIELD, v.clone());
        Vector<byte[]> emptyByteVector = new Vector<byte[]>();
        int i = 0;
        while (i < 11) {
            emptyByteVector.add(i, new byte[1]);
            ++i;
        }
        state.setAttribute(STATE_REPLACE_CONTENT, emptyByteVector);
    }

    private int repeatedName(Vector testVector, int testSize) {
        int i = 1;
        while (i <= testSize) {
            String currentName = (String)testVector.get(i);
            int j = i + 1;
            while (j <= testSize) {
                String comparedTitle = (String)testVector.get(j);
                if (comparedTitle.length() > 0 && currentName.length() > 0 && comparedTitle.equals(currentName)) {
                    return j;
                }
                ++j;
            }
            ++i;
        }
        return 0;
    }

    private int foundInResource(Vector testVector, int testSize, SessionState state, boolean isCollection) {
        String collectionId = (String)state.getAttribute(STATE_COLLECTION_ID);
        int i = 1;
        while (i <= testSize) {
            if (((String)testVector.get(i)).length() > 0) {
                try {
                    if (!isCollection) {
                        ContentHostingService.getResource(collectionId + (String)testVector.get(i));
                    } else {
                        ContentHostingService.getCollection(collectionId + (String)testVector.get(i) + "/");
                    }
                    return i;
                }
                catch (IdUnusedException e) {
                }
                catch (TypeException e) {
                }
                catch (PermissionException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        return 0;
    }

    private Vector emptyVector(int size) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i <= size) {
            v.add(i, NULL_STRING);
            ++i;
        }
        return v;
    }

    public String buildOptionsPanelContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        String home = (String)state.getAttribute(STATE_HOME_COLLECTION_ID);
        context.put("home", home);
        context.put("action", "ResourcesAction");
        context.put("doUpdate", "eventSubmit_doConfigure_update");
        context.put("doCancel", "eventSubmit_doCancel_options");
        String template = (String)this.getContext(data).get("template");
        return template + "-customize";
    }

    public void doConfigure_update(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        String home = data.getParameters().getString("home");
        if (!home.equals(state.getAttribute(STATE_HOME_COLLECTION_ID))) {
            state.setAttribute(STATE_HOME_COLLECTION_ID, (Object)home);
            state.setAttribute(STATE_COLLECTION_ID, state.getAttribute(STATE_HOME_COLLECTION_ID));
            ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
            tool.getPropertiesEdit().addProperty("home", (String)state.getAttribute(STATE_HOME_COLLECTION_ID));
        }
        state.setAttribute("mode", (Object)MODE_BROWSE);
        this.saveOptions();
    }

    public void doCancel_options(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        this.cancelOptions();
        state.setAttribute("mode", (Object)MODE_BROWSE);
    }

    public void doExpand_collection(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        HashSet currentSet = (HashSet)state.getAttribute(EXPANDED_COLLECTIONS);
        ParameterParser params = data.getParameters();
        String id = params.getString("collectionId");
        currentSet.add(id);
        state.setAttribute(EXPANDED_COLLECTIONS, (Object)currentSet);
    }

    public void doCollapse_collection(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        HashSet currentSet = (HashSet)state.getAttribute(EXPANDED_COLLECTIONS);
        ParameterParser params = data.getParameters();
        String collectionId = params.getString("collectionId");
        HashSet<String> newSet = new HashSet<String>();
        Iterator l = currentSet.iterator();
        while (l.hasNext()) {
            String id = (String)l.next();
            if (id.indexOf(collectionId) != -1) continue;
            newSet.add(id);
        }
        state.setAttribute(EXPANDED_COLLECTIONS, newSet);
    }

    public List getShowMembers(String collectionId, HashSet expandedCollections, String sortedBy, String sortedAsc, SessionState state) {
        try {
            ContentCollection collection = ContentHostingService.getCollection(collectionId);
            List newMembers = collection.getMemberResources();
            Collections.sort(newMembers, new ContentHostingComparator(sortedBy, Boolean.valueOf(sortedAsc)));
            int size = newMembers.size();
            Hashtable<Integer, List> moreMembers = new Hashtable<Integer, List>();
            int i = 0;
            while (i < size) {
                String nextId = ((Resource)newMembers.get(i)).getId();
                ResourceProperties properties = ContentHostingService.getProperties(nextId);
                String isCollection = properties.getProperty("CHEF:is-collection");
                if (isCollection != null && isCollection.equals(Boolean.TRUE.toString()) && expandedCollections.contains(nextId) && ContentHostingService.getCollection(nextId).getMemberResources().size() != 0) {
                    moreMembers.put(new Integer(i), this.getShowMembers(nextId, expandedCollections, sortedBy, sortedAsc, state));
                }
                ++i;
            }
            Enumeration keys = moreMembers.keys();
            while (keys.hasMoreElements()) {
                Integer index = (Integer)keys.nextElement();
                newMembers.addAll(index + 1, (Vector)moreMembers.get(index));
            }
            return newMembers;
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "IdUnusedException.");
        }
        catch (TypeException e) {
            this.addAlert(state, "TypeException.");
        }
        catch (PermissionException e) {
            this.addAlert(state, "PermissionException");
        }
        return new Vector();
    }

    public void doFolder_permissions(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String collectionId = (String)state.getAttribute(STATE_COLLECTION_ID);
        Reference ref = new Reference(ContentHostingService.getReference(collectionId));
        String siteId = ref.getContext();
        state.setAttribute("permission.realmId", (Object)ref.getReference());
        state.setAttribute("permission.realmRolesId", (Object)SiteService.siteReference(siteId));
        state.setAttribute("permission.description", (Object)("Set permissions for folder " + collectionId));
        state.setAttribute("permission.prefix", (Object)"content.");
        state.setAttribute("pemissions.mode", (Object)"main");
    }

    public void doPermissions(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String collectionId = (String)state.getAttribute(STATE_COLLECTION_ID);
        Reference ref = new Reference(ContentHostingService.getReference(collectionId));
        String siteRef = SiteService.siteReference(ref.getContext());
        state.setAttribute("permission.realmId", (Object)siteRef);
        state.setAttribute("permission.realmRolesId", (Object)siteRef);
        state.setAttribute("permission.description", (Object)("Set permissions for Resources in worksite " + SiteService.getSiteDisplay(ref.getContext())));
        state.setAttribute("permission.prefix", (Object)"content.");
        state.setAttribute("pemissions.mode", (Object)"main");
    }

    static {
        FILE_UPLOAD_MAX_SIZE = FILE_UPLOAD_MAX_SIZE;
        RESOURCES_MODE_RESOURCES = RESOURCES_MODE_RESOURCES;
        RESOURCES_MODE_DROPBOX = RESOURCES_MODE_DROPBOX;
        EXPANDED_COLLECTIONS = EXPANDED_COLLECTIONS;
        NULL_STRING = NULL_STRING;
        DUPLICATE_STRING = DUPLICATE_STRING;
        SHORTCUT_STRING = SHORTCUT_STRING;
        COPYRIGHT_SYMBOL = COPYRIGHT_SYMBOL;
        NEW_WINDOW = NEW_WINDOW;
        NEW_COPYRIGHT = NEW_COPYRIGHT;
        RESOURCE_NOT_EXIST_STRING = RESOURCE_NOT_EXIST_STRING;
        RESOURCE_INVALID_TITLE_STRING = RESOURCE_INVALID_TITLE_STRING;
        RESOURCE_INVALID_OPERATION_ON_COLLECTION_STRING = RESOURCE_INVALID_OPERATION_ON_COLLECTION_STRING;
        MULTI_ADD_NUMBER = 10;
        SIMPLE_TEXT_TYPE = SIMPLE_TEXT_TYPE;
        URL_TYPE = URL_TYPE;
        STATE_INITIALIZED = STATE_INITIALIZED;
        STATE_CONTENT_SERVICE = STATE_CONTENT_SERVICE;
        STATE_RESOURCES_MODE = STATE_RESOURCES_MODE;
        STATE_CONTENT_TYPE_IMAGE_SERVICE = STATE_CONTENT_TYPE_IMAGE_SERVICE;
        STATE_MY_COPYRIGHT = STATE_MY_COPYRIGHT;
        STATE_COLLECTION_ID = STATE_COLLECTION_ID;
        STATE_HOME_COLLECTION_ID = STATE_HOME_COLLECTION_ID;
        STATE_HOME_COLLECTION_DISPLAY_NAME = STATE_HOME_COLLECTION_DISPLAY_NAME;
        STATE_UNQUALIFIED_INPUT_FIELD = STATE_UNQUALIFIED_INPUT_FIELD;
        STATE_COLLECTION_PATH = STATE_COLLECTION_PATH;
        STATE_SORT_BY = STATE_SORT_BY;
        STATE_SORT_ASC = STATE_SORT_ASC;
        STATE_COPY_FLAG = STATE_COPY_FLAG;
        STATE_CUT_FLAG = STATE_CUT_FLAG;
        STATE_SELECT_ALL_FLAG = STATE_SELECT_ALL_FLAG;
        STATE_EXPAND_ALL_FLAG = STATE_EXPAND_ALL_FLAG;
        STATE_FROM = STATE_FROM;
        STATE_ADD_FILE_NUMBER = STATE_ADD_FILE_NUMBER;
        STATE_ADD_FILE_OS_NAME = STATE_ADD_FILE_OS_NAME;
        STATE_ADD_FILE_TITLE = STATE_ADD_FILE_TITLE;
        STATE_ADD_FILE_CONTENT = STATE_ADD_FILE_CONTENT;
        STATE_ADD_FILE_CONTENT_TYPE = STATE_ADD_FILE_CONTENT_TYPE;
        STATE_ADD_FILE_COPYRIGHT = STATE_ADD_FILE_COPYRIGHT;
        STATE_ADD_FILE_NEW_COPYRIGHT = STATE_ADD_FILE_NEW_COPYRIGHT;
        STATE_ADD_FILE_DESCRIPTION = STATE_ADD_FILE_DESCRIPTION;
        STATE_ADD_FILE_TARGET = STATE_ADD_FILE_TARGET;
        STATE_ADD_FOLDER_NUMBER = STATE_ADD_FOLDER_NUMBER;
        STATE_ADD_FOLDER_TITLE = STATE_ADD_FOLDER_TITLE;
        STATE_ADD_FOLDER_DESCRIPTION = STATE_ADD_FOLDER_DESCRIPTION;
        STATE_ADD_FOLDER_COPYRIGHT = STATE_ADD_FOLDER_COPYRIGHT;
        STATE_ADD_SIMPLE_TEXT_CONTENT = STATE_ADD_SIMPLE_TEXT_CONTENT;
        STATE_ADD_SIMPLE_TEXT_COPYRIGHT = STATE_ADD_SIMPLE_TEXT_COPYRIGHT;
        STATE_ADD_SIMPLE_TEXT_DESCRIPTION = STATE_ADD_SIMPLE_TEXT_DESCRIPTION;
        STATE_ADD_SIMPLE_TEXT_NEW_COPYRIGHT = STATE_ADD_SIMPLE_TEXT_NEW_COPYRIGHT;
        STATE_ADD_SIMPLE_TEXT_TARGET = STATE_ADD_SIMPLE_TEXT_TARGET;
        STATE_ADD_SIMPLE_TEXT_TITLE = STATE_ADD_SIMPLE_TEXT_TITLE;
        STATE_ADD_URL_NUMBER = STATE_ADD_URL_NUMBER;
        STATE_ADD_URL_COPYRIGHT = STATE_ADD_URL_COPYRIGHT;
        STATE_ADD_URL_DESCRIPTION = STATE_ADD_URL_DESCRIPTION;
        STATE_ADD_URL_NEW_COPYRIGHT = STATE_ADD_URL_NEW_COPYRIGHT;
        STATE_ADD_URL_TARGET = STATE_ADD_URL_TARGET;
        STATE_ADD_URL_TITLE = STATE_ADD_URL_TITLE;
        STATE_ADD_URL_URL = STATE_ADD_URL_URL;
        STATE_MORE_ID = STATE_MORE_ID;
        STATE_MORE_FROM = STATE_MORE_FROM;
        STATE_PROPERTIES_ID = STATE_PROPERTIES_ID;
        STATE_DELETE_IDS = STATE_DELETE_IDS;
        STATE_NOT_EMPTY_DELETE_IDS = STATE_NOT_EMPTY_DELETE_IDS;
        STATE_REPLACE_ID = STATE_REPLACE_ID;
        STATE_REPLACE_OS_NAME = STATE_REPLACE_OS_NAME;
        STATE_REPLACE_TITLE = STATE_REPLACE_TITLE;
        STATE_REPLACE_CONTENT = STATE_REPLACE_CONTENT;
        STATE_REPLACE_CONTENT_TYPE = STATE_REPLACE_CONTENT_TYPE;
        STATE_REVISE_ID = STATE_REVISE_ID;
        STATE_CUT_IDS = STATE_CUT_IDS;
        STATE_COPIED_IDS = STATE_COPIED_IDS;
        MODE_BROWSE = MODE_BROWSE;
        MODE_ADD_ITEM = MODE_ADD_ITEM;
        MODE_ADD_FILE_BASIC = MODE_ADD_FILE_BASIC;
        MODE_ADD_FILE_OPTIONS = MODE_ADD_FILE_OPTIONS;
        MODE_ADD_FOLDER = MODE_ADD_FOLDER;
        MODE_ADD_URL = MODE_ADD_URL;
        MODE_ADD_SIMPLE_TEXT = MODE_ADD_SIMPLE_TEXT;
        MODE_DElETE_CONFIRM = "deleteConfirm";
        MODE_MORE = MODE_MORE;
        MODE_PROPERTIES = MODE_PROPERTIES;
        MODE_REPLACE = MODE_REPLACE;
        MODE_REVISE_SIMPLE_TEXT = MODE_REVISE_SIMPLE_TEXT;
        MODE_DELETE_CONFIRM = "deleteConfirm";
        TEMPLATE_BROWSE = TEMPLATE_BROWSE;
        TEMPLATE_ADD_ITEM = TEMPLATE_ADD_ITEM;
        TEMPLATE_ADD_FILE_BASIC = TEMPLATE_ADD_FILE_BASIC;
        TEMPLATE_ADD_FILE_OPTIONS = TEMPLATE_ADD_FILE_OPTIONS;
        TEMPLATE_ADD_FOLDER = TEMPLATE_ADD_FOLDER;
        TEMPLATE_ADD_SIMPLE_TEXT = TEMPLATE_ADD_SIMPLE_TEXT;
        TEMPLATE_ADD_URL = TEMPLATE_ADD_URL;
        TEMPLATE_DELETE_CONFIRM = TEMPLATE_DELETE_CONFIRM;
        TEMPLATE_MORE = TEMPLATE_MORE;
        TEMPLATE_PROPERTIES = TEMPLATE_PROPERTIES;
        TEMPLATE_REPLACE = TEMPLATE_REPLACE;
    }
}

