/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jserv;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.http.Cookie;

public final class JServUtils {
    private static SimpleDateFormat cookieDate = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zz", Locale.US);

    public static String encodeCookie(Cookie cookie) {
        StringBuffer buf = new StringBuffer(cookie.getName());
        buf.append('=');
        buf.append(cookie.getValue());
        long age = cookie.getMaxAge();
        if (age > 0L) {
            buf.append("; expires=");
            buf.append(cookieDate.format(new Date(System.currentTimeMillis() + age * 1000L)));
        } else if (age == 0L) {
            buf.append("; expires=");
            buf.append(cookieDate.format(new Date(0L)));
        }
        if (cookie.getDomain() != null) {
            buf.append("; domain=");
            buf.append(cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            buf.append("; path=");
            buf.append(cookie.getPath());
        }
        if (cookie.getSecure()) {
            buf.append("; secure");
        }
        return buf.toString();
    }

    public static String parseCharacterEncoding(String contentType) {
        int start;
        if (contentType == null || (start = contentType.indexOf("charset=")) == -1) {
            return "ISO-8859-1";
        }
        String encoding = contentType.substring(start + 8);
        int end = encoding.indexOf(";");
        if (end > -1) {
            return encoding.substring(0, end);
        }
        return encoding;
    }

    public static Cookie[] parseCookieHeader(String cookieHdr) {
        Vector<Cookie> cookieJar = new Vector<Cookie>();
        if (cookieHdr == null || cookieHdr.length() == 0) {
            return new Cookie[0];
        }
        StringTokenizer stok = new StringTokenizer(cookieHdr, "; ");
        while (stok.hasMoreTokens()) {
            try {
                String name;
                String tok = stok.nextToken();
                int equals_pos = tok.indexOf(61);
                if (equals_pos > 0) {
                    name = JServUtils.URLDecode(tok.substring(0, equals_pos));
                    String value = JServUtils.URLDecode(tok.substring(equals_pos + 1));
                    cookieJar.addElement(new Cookie(name, value));
                    continue;
                }
                if (tok.length() <= 0 || equals_pos != -1) continue;
                name = JServUtils.URLDecode(tok);
                cookieJar.addElement(new Cookie(name, ""));
            }
            catch (IllegalArgumentException badcookie) {
            }
            catch (NoSuchElementException badcookie) {
                // empty catch block
            }
        }
        Object[] cookies = new Cookie[cookieJar.size()];
        cookieJar.copyInto(cookies);
        return cookies;
    }

    public static final String URLDecode(String str) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        StringBuffer dec = new StringBuffer();
        int strPos = 0;
        int strLen = str.length();
        dec.ensureCapacity(str.length());
        while (strPos < strLen) {
            int laPos = strPos;
            while (laPos < strLen) {
                char laChar = str.charAt(laPos);
                if (laChar == '+' || laChar == '%') break;
                ++laPos;
            }
            if (laPos > strPos) {
                dec.append(str.substring(strPos, laPos));
                strPos = laPos;
            }
            if (strPos >= strLen) break;
            char metaChar = str.charAt(strPos);
            if (metaChar == '+') {
                dec.append(' ');
                ++strPos;
                continue;
            }
            if (metaChar != '%') continue;
            try {
                dec.append((char)Integer.parseInt(str.substring(strPos + 1, strPos + 3), 16));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("invalid hexadecimal " + str.substring(strPos + 1, strPos + 3) + " in URLencoded string (illegal unescaped '%'?)");
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("illegal unescaped '%'  in URLencoded string");
            }
            strPos += 3;
        }
        return dec.toString();
    }

    public static final String URLEncode(String str) {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str);
    }

    static {
        cookieDate.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

