/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class SnoopServlet
extends HttpServlet {
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Cookie[] cookies;
        boolean getSession = false;
        res.setContentType("text/html; charset=UTF-8");
        PrintWriter out = res.getWriter();
        out.println("<html>");
        out.println("<head><title>Snoop Servlet</title></head>");
        out.println("<body>");
        out.println("<h1>Requested URL:</h1>");
        out.println("<pre>");
        this.printHex(out, "HttpUtils.getRequestURL(req)", HttpUtils.getRequestURL((HttpServletRequest)req).toString());
        out.println("</pre>");
        out.println("<h1>Default Encoding:</h1>");
        out.println("<pre>");
        this.print(out, "file.encoding", System.getProperty("file.encoding"));
        out.println("</pre>");
        Enumeration enumeration = this.getServletConfig().getInitParameterNames();
        if (enumeration != null) {
            boolean first = true;
            while (enumeration.hasMoreElements()) {
                if (first) {
                    out.println("<h1>Init Parameters</h1>");
                    out.println("<pre>");
                    first = false;
                }
                String param = (String)enumeration.nextElement();
                out.println(" " + param + ": " + this.getInitParameter(param));
            }
            out.println("</pre>");
        }
        out.println("<h1>Request information:</h1>");
        out.println("<pre>");
        this.print(out, "Request method", req.getMethod());
        this.printHex(out, "Request URI", req.getRequestURI());
        this.print(out, "Request protocol", req.getProtocol());
        this.printHex(out, "Servlet path", req.getServletPath());
        this.printHex(out, "Path info", req.getPathInfo());
        this.print(out, "Path translated", req.getPathTranslated());
        this.printHex(out, "Query string", req.getQueryString());
        this.print(out, "Content length", req.getContentLength());
        this.print(out, "Content type", req.getContentType());
        this.print(out, "Server name", req.getServerName());
        this.print(out, "Server port", req.getServerPort());
        this.print(out, "Remote user", req.getRemoteUser());
        this.print(out, "Remote address", req.getRemoteAddr());
        this.print(out, "Remote host", req.getRemoteHost());
        this.print(out, "Authorization scheme", req.getAuthType());
        this.print(out, "Encoding", req.getCharacterEncoding());
        out.println("</pre>");
        Enumeration e = req.getHeaderNames();
        if (e.hasMoreElements()) {
            out.println("<h1>Request headers:</h1>");
            out.println("<pre>");
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                out.println(" " + name + ": " + req.getHeader(name));
            }
            out.println("</pre>");
        }
        if ((cookies = req.getCookies()) != null) {
            out.println("<h1>Cookies:</h1>");
            out.println("<pre>");
            int i = 0;
            while (i < cookies.length) {
                this.printHex(out, "name", cookies[i].getName());
                this.printHex(out, "value", cookies[i].getValue());
                ++i;
            }
            out.println("</pre>");
        }
        if ((e = req.getParameterNames()).hasMoreElements()) {
            out.println("<h1>Servlet parameters (Single Value style):</h1>");
            out.println("<pre>");
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.printHex(out, "name", name);
                this.printHex(out, "value", req.getParameter(name));
                if (!name.equals("session")) continue;
                getSession = true;
            }
            out.println("</pre>");
        }
        if ((e = req.getParameterNames()).hasMoreElements()) {
            out.println("<h1>Servlet parameters (Multiple Value style):</h1>");
            out.println("<pre>");
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.printHex(out, "name", name);
                String[] vals = req.getParameterValues(name);
                if (vals == null) continue;
                int i = 0;
                while (i < vals.length) {
                    this.printHex(out, "value", vals[i]);
                    ++i;
                }
            }
            out.println("</pre>");
        }
        this.test(req, out);
        this.test2(req, out);
        if (getSession) {
            req.getSession(true);
            out.println("<h1>Session started</h1>");
        }
        out.println("</body></html>");
    }

    protected void print(PrintWriter out, String name, String value) {
        out.print(" " + name + ": ");
        out.println(value == null ? "&lt;none&gt;" : value);
    }

    protected void printHex(PrintWriter out, String name, String value) {
        this.print(out, name, value);
        if (value != null) {
            out.print(value.length() + " bytes: ");
            int i = 0;
            while (i < value.length()) {
                out.print(Integer.toHexString(value.charAt(i)) + " ");
                ++i;
            }
            out.println();
        }
    }

    protected void print(PrintWriter out, String name, int value) {
        out.print(" " + name + ": ");
        if (value == -1) {
            out.println("&lt;none&gt;");
        } else {
            out.println(value);
        }
    }

    public void test(HttpServletRequest req, PrintWriter out) {
        out.println("<h1>Turbine's DefaultParameterParser's method:</h1>");
        out.println("<pre>");
        Enumeration names = req.getParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String tmp = (String)names.nextElement();
                this.printHex(out, "(query)name", tmp);
                String[] vals = req.getParameterValues(tmp);
                if (vals == null) continue;
                int i = 0;
                while (i < vals.length) {
                    this.printHex(out, "value", vals[i]);
                    ++i;
                }
            }
        }
        try {
            StringTokenizer st = new StringTokenizer(req.getPathInfo(), "/");
            boolean name = true;
            String pathPart = null;
            String tmp = null;
            while (st.hasMoreTokens()) {
                if (name) {
                    tmp = URLDecoder.decode(st.nextToken());
                    name = false;
                    continue;
                }
                pathPart = URLDecoder.decode(st.nextToken());
                if (tmp.length() != 0) {
                    this.printHex(out, "(path)name", tmp);
                    this.printHex(out, "value", pathPart);
                }
                name = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        out.println("</pre>");
    }

    public void test2(HttpServletRequest req, PrintWriter out) {
        out.println("<h1>Turbine's DefaultParameterParser's method (repaired):</h1>");
        out.println("<pre>");
        Enumeration names = req.getParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String tmp = (String)names.nextElement();
                String[] vals = req.getParameterValues(tmp);
                tmp = this.decodeUtf8(tmp);
                this.printHex(out, "name", tmp);
                if (vals == null) continue;
                int i = 0;
                while (i < vals.length) {
                    vals[i] = this.decodeUtf8(vals[i]);
                    this.printHex(out, "value", vals[i]);
                    ++i;
                }
            }
        }
        String path = req.getRequestURI();
        String servletPath = req.getServletPath();
        int pos = path.indexOf(req.getServletPath());
        path = path.substring(pos + servletPath.length());
        this.printHex(out, "path isolated", path);
        try {
            StringTokenizer st = new StringTokenizer(path, "/");
            boolean name = true;
            String pathPart = null;
            String tmp = null;
            while (st.hasMoreTokens()) {
                if (name) {
                    tmp = URLDecoder.decode(st.nextToken(), "ISO-8859-1");
                    tmp = this.decodeUtf8(tmp);
                    name = false;
                    continue;
                }
                String value = st.nextToken();
                this.printHex(out, " value", value);
                pathPart = URLDecoder.decode(value, "ISO-8859-1");
                this.printHex(out, " URLdecoded", pathPart);
                pathPart = this.decodeUtf8(pathPart);
                if (tmp.length() != 0) {
                    this.printHex(out, "(path)name", tmp);
                    this.printHex(out, "value", pathPart);
                }
                name = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        out.println("</pre>");
    }

    protected String decodeUtf8(String value) {
        if (value == null) {
            return null;
        }
        try {
            ByteBuffer strBytes = ByteBuffer.wrap(value.getBytes("8859_1"));
            Charset utfCharset = Charset.forName("UTF-8");
            CharsetDecoder decoder = utfCharset.newDecoder();
            CharBuffer testChars = decoder.decode(strBytes);
            value = testChars.subSequence(0, testChars.length()).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

