/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.profile.BasePSMLDocument;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.profile.QueryLocator;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.psmlmanager.PsmlManagerService;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.Site;
import org.chefproject.core.SitePage;
import org.chefproject.core.ToolConfiguration;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.service.SiteService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Xml;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SitePsmlManager
extends TurbineBaseService
implements PsmlManagerService {
    public static final String DEFAULT_MAPPING = "/WEB-INF/conf/psml-mapping.xml";
    protected String m_mapFile = null;
    protected Mapping m_mapping = null;

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        this.m_mapFile = DEFAULT_MAPPING;
        this.m_mapFile = TurbineServlet.getRealPath(this.m_mapFile);
        this.m_mapping = this.loadMapping(this.m_mapFile);
        Log.info("chef", this + ".init(ServletConfig): mapFile: " + this.m_mapFile);
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        Log.info("chef", this + ".init(RunData)");
    }

    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()");
    }

    public void shutdown() {
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    public PSMLDocument getDocument(String name) {
        return null;
    }

    public PSMLDocument getDocument(ProfileLocator locator) {
        Site site = this.findSite(locator);
        if (site == null) {
            return null;
        }
        String xml = this.getPsmlXml(site);
        BasePSMLDocument doc = new BasePSMLDocument();
        doc.setName(site.getId());
        try {
            Portlets portlets = this.load(new StringReader(xml));
            doc.setPortlets(portlets);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return doc;
    }

    public PSMLDocument getDocument(List locators) {
        return null;
    }

    public boolean store(Profile profile) {
        return false;
    }

    public boolean saveDocument(PSMLDocument doc) {
        return false;
    }

    public boolean saveDocument(String fileOrUrl, PSMLDocument doc) {
        return false;
    }

    public PSMLDocument createDocument(Profile profile) {
        return null;
    }

    public void removeDocument(ProfileLocator locator) {
    }

    public void removeUserDocuments(JetspeedUser user) {
    }

    public void removeGroupDocuments(Group group) {
    }

    public void removeRoleDocuments(Role role) {
    }

    public Iterator query(QueryLocator locator) {
        return null;
    }

    public int export(PsmlManagerService consumer, QueryLocator locator) {
        return 0;
    }

    protected Mapping loadMapping(String mapFile) throws InitializationException {
        Mapping rv = null;
        if (mapFile != null) {
            File map = new File(mapFile);
            if (map.exists() && map.isFile() && map.canRead()) {
                try {
                    rv = new Mapping();
                    InputSource is = new InputSource(new FileReader(map));
                    is.setSystemId(mapFile);
                    rv.loadMapping(is);
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".loadMapping:", (Throwable)e);
                    throw new InitializationException("Error in mapping", e);
                }
            } else {
                throw new InitializationException("PSML Mapping not found or not a file or unreadable: " + mapFile);
            }
        }
        return rv;
    }

    protected Portlets load(Reader reader) throws IOException, MarshalException, ValidationException, MappingException {
        Unmarshaller unmarshaller = new Unmarshaller(this.m_mapping);
        Portlets portlets = (Portlets)unmarshaller.unmarshal(reader);
        return portlets;
    }

    protected String getPsmlXml(Site site) {
        Document doc = Xml.createDocument();
        Element root = null;
        if (!site.getId().equals("~anon")) {
            root = doc.createElement("portlets");
            doc.appendChild(root);
            root.setAttribute("id", site.getId());
            Element meta = doc.createElement("metainfo");
            root.appendChild(meta);
            Element el = doc.createElement("title");
            meta.appendChild(el);
            el.appendChild(doc.createCDATASection(site.getTitle()));
            el = doc.createElement("skin");
            root.appendChild(el);
            el.setAttribute("name", "ctng-standard");
            el = doc.createElement("control");
            root.appendChild(el);
            el.setAttribute("name", "ChefWorkspaceControl");
            el = doc.createElement("controller");
            root.appendChild(el);
            el.setAttribute("name", "ChefWorkspaceController");
        }
        List pages = site.getPages();
        Iterator iPages = pages.iterator();
        while (iPages.hasNext()) {
            SitePage page = (SitePage)iPages.next();
            Element portlets = doc.createElement("portlets");
            if (root == null) {
                doc.appendChild(portlets);
            } else {
                root.appendChild(portlets);
            }
            portlets.setAttribute("id", page.getId());
            Element meta = doc.createElement("metainfo");
            portlets.appendChild(meta);
            Element el = doc.createElement("title");
            meta.appendChild(el);
            el.appendChild(doc.createCDATASection(page.getTitle()));
            el = doc.createElement("skin");
            portlets.appendChild(el);
            el.setAttribute("name", "ctng-standard");
            el = doc.createElement("controller");
            portlets.appendChild(el);
            switch (page.getLayout()) {
                case 0: {
                    el.setAttribute("name", "ChefOneColumn");
                    break;
                }
                case 1: {
                    el.setAttribute("name", "ChefTwoColumns");
                }
            }
            List tools = page.getTools();
            Iterator iTools = tools.iterator();
            while (iTools.hasNext()) {
                String[] parts;
                String hints;
                ToolConfiguration tool = (ToolConfiguration)iTools.next();
                Element entry = doc.createElement("entry");
                portlets.appendChild(entry);
                entry.setAttribute("id", tool.getId());
                entry.setAttribute("parent", tool.getToolId());
                meta = doc.createElement("metainfo");
                entry.appendChild(meta);
                el = doc.createElement("title");
                meta.appendChild(el);
                el.appendChild(doc.createCDATASection(tool.getTitle()));
                if (page.getLayout() == 1 && (hints = tool.getLayoutHints()) != null && (parts = StringUtil.split(hints, ",")).length == 2) {
                    Element layout = doc.createElement("layout");
                    entry.appendChild(layout);
                    layout.setAttribute("position", "-1");
                    layout.setAttribute("size", "-1");
                    el = doc.createElement("property");
                    layout.appendChild(el);
                    el.setAttribute("name", "column");
                    el.setAttribute("value", parts[1]);
                    el = doc.createElement("property");
                    layout.appendChild(el);
                    el.setAttribute("name", "row");
                    el.setAttribute("value", parts[0]);
                }
                ResourceProperties params = tool.getProperties();
                Iterator iParams = params.getPropertyNames();
                while (iParams.hasNext()) {
                    String name = (String)iParams.next();
                    String value = params.getProperty(name);
                    Element parameter = doc.createElement("parameter");
                    entry.appendChild(parameter);
                    parameter.setAttribute("name", name);
                    parameter.setAttribute("value", value);
                }
            }
            if (root == null) break;
        }
        String xml = Xml.writeDocumentToString(doc);
        return xml;
    }

    protected Site findSite(ProfileLocator locator) {
        Role role = locator.getRole();
        Group group = locator.getGroup();
        JetspeedUser user = locator.getUser();
        String name = locator.getName();
        String id = null;
        if (group != null) {
            id = group.getName();
        } else if (user != null) {
            id = "~" + user.getUserName();
        } else if (role != null && "user".equals(role.getName())) {
            id = "~" + UsageSessionService.safelyGetSessionUserId();
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".findSite() wants Site: " + id + " for locator: " + locator.toString());
        }
        Site site = null;
        try {
            site = SiteService.getSite(id);
        }
        catch (IdUnusedException e) {
            // empty catch block
        }
        if (site == null && id.startsWith("~")) {
            id = "~";
            try {
                site = SiteService.getSite(id);
            }
            catch (IdUnusedException e) {
                // empty catch block
            }
        }
        return site;
    }

    static {
        DEFAULT_MAPPING = DEFAULT_MAPPING;
    }
}

