      subroutine tce_ccsd_lambda_perturbative(perturbative,ref,corr,
     &        d_t1,k_t1_offset,d_t2,k_t2_offset,
     &        d_y1,k_y1_offset,d_y2,k_y2_offset,
     &        d_f1,k_f1_offset,d_v2,k_v2_offset)
c
c $Id: tce_ccsd_lambda_perturbative.F 20795 2011-06-30 13:53:08Z d3p852 $
c 
c Main routine for many-electron theory calculations.
c Some of the subroutines have been generated by 
c operator/tensor contraction engines.
c
c Written by Jeff Hammond, January 2008.
c
      implicit none
#include "mafdecls.fh"
#include "tcgmsg.fh"
#include "global.fh"
#include "bas.fh"
#include "geom.fh"
#include "sym.fh"
#include "util.fh"
#include "msgids.fh"
#include "stdio.fh"
#include "sf.fh"
#include "inp.fh"
#include "errquit.fh"
#include "tce.fh"
c#include "tce_main.fh"
c#include "tce_prop.fh"
c#include "tce_ints.fh"
c#include "tce_amps.fh"
c#include "tce_diis.fh"
c
c     CI, CC, & MBPT
c
      logical nodezero         ! True if node 0
      double precision cpu     ! CPU sec counter
      double precision wall    ! WALL sec counter
c      integer d_e              ! SF handle for e file
c      integer l_e_offset       ! Offset for e file
c      integer k_e_offset       ! Offset for e file
c      integer size_e           ! File size in doubles
      integer d_f1             ! SF handle for MO 1e integrals
      integer k_f1_offset      ! Offset for 1e integral file
      integer d_v2             ! SF handle for MO 2e integrals
      integer k_v2_offset      ! Offset for 2e integral file
      integer d_t1             ! SF handle for t1 amplitudes
      integer k_t1_offset      ! Offset for t1 file
      integer l_t1_offset      !
      integer size_t1          ! File size in doubles
      integer d_t2             ! SF handle for t2 amplitudes
      integer k_t2_offset      ! Offset for t2 file
      integer d_y1             ! SF handle for y1 amplitudes
      integer k_y1_offset      ! Offset for y1 file
      integer d_y2             ! SF handle for y2 amplitudes
      integer k_y2_offset      ! Offset for y2 file
      double precision ref     ! Ground state energy
      double precision corr    ! Correlation energy
      double precision pt3_1   ! [T] energy
      double precision pt3_2   ! (T)-[T] energy
      character*10 perturbative! PT model
      character*255 filename
      character*20 title
      character*4 irrepname
      nodezero=(ga_nodeid().eq.0)
c -------------------
c CCSD(T) and CCSD[T]
c -------------------
        if ((perturbative.eq.'lambda(t)').or.
     &      (perturbative.eq.'lambda[t]')) then
          cpu = - util_cpusec()
          wall = - util_wallsec()
          call tce_t1_offset(l_t1_offset,k_t1_offset,size_t1)
          call ccsd_t(d_t1,k_t1_offset,d_t2,k_t2_offset,
     1                d_v2,k_v2_offset,pt3_1,pt3_2,size_t1)
          if (nodezero) then
            write(LuOut,*)
            write(LuOut,9070) "Lambda-CCSD[T]",corr+pt3_1
            write(LuOut,9080) "Lambda-CCSD[T]",ref+corr+pt3_1
          endif
          cpu = cpu + util_cpusec()
          wall = wall + util_wallsec()
          if (nodezero) then
            write(LuOut,9070) "Lambda-CCSD(T)",corr+pt3_2
            write(LuOut,9080) "Lambda-CCSD(T)",ref+corr+pt3_2
            write(LuOut,9020) cpu, wall
          endif
          if (perturbative.eq.'lambda[t]') then
            corr = corr + pt3_1
          else if (perturbative.eq.'lambda(t)') then
            corr = corr + pt3_2
          endif
        endif
c
c     ======
c     Format
c     ======
c
 9000 format(1x,A,' file size   = ',i16)
 9010 format(1x,A,' file name   = ',A)
 9090 format(1x,A,' file handle = ',i10)
 9020 format(1x,'Cpu & wall time / sec',2f15.1)
 9480 format(1x,'Cpu & wall time / sec for ',A,2f15.1)
 9070 format(1x,A,' correlation energy / hartree = ',f25.15)
 9080 format(1x,A,' total energy / hartree       = ',f25.15)
 9100 format(1x,i4,2f18.13,2f8.1)
 9120 format(1x,A)
 9250 format(1x,'Ground-state symmetry is ',A4)
 9210 format(/,1x,'Iteration ',i3,' using ',i4,' trial vectors')
 9230 format(1x,f17.13,f18.13,f11.5,2f8.1)
 9310 format(1x,A,' ground state energy / hartree  =',f25.15)
 9420 format(1x,i4,f18.13,2f8.1)
 9440 format(1x,A3,' axis ( ',A4,'symmetry)')
      end
