/*
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 2.0

/**
* Computes the versed sine.
*
* ## Notes
*
* -   The versed sine is defined as `1 - cos(x)`.
*
* @param x - input value (in radians)
* @returns versed sine
*
* @example
* var v = versin( 0.0 );
* // returns 0.0
*
* @example
* var v = versin( 3.141592653589793/2.0 );
* // returns ~1.0
*
* @example
* var v = versin( -3.141592653589793/6.0 );
* // returns ~0.13397
*
* @example
* var v = versin( NaN );
* // returns NaN
*/
declare function versin( x: number ): number;


// EXPORTS //

export = versin;
