/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* This script compiles modules for evaluating polynomial functions. If any polynomial coefficients change, this script should be rerun to update the compiled files.
*/
'use strict';

// MODULES //

var resolve = require( 'path' ).resolve;
var writeFileSync = require( '@stdlib/fs/write-file' ).sync;
var licenseHeader = require( '@stdlib/_tools/licenses/header' );
var compile = require( './../../../../base/tools/evalrational-compile' );


// VARIABLES //

// Polynomial coefficients ordered in ascending degree...
var P1 = [
	-0.180355685678449379109e-1,
	0.25126649619989678683e-1,
	0.494103151567532234274e-1,
	0.172491608709613993966e-1,
	-0.259453563205438108893e-3,
	-0.541009869215204396339e-3,
	-0.324588649825948492091e-4,
	0.0
];
var Q1 = [
	0.1e1,
	0.196202987197795200688e1,
	0.148019669424231326694e1,
	0.541391432071720958364e0,
	0.988504251128010129477e-1,
	0.82130967464889339326e-2,
	0.224936291922115757597e-3,
	-0.223352763208617092964e-6
];

var P2 = [
	0.490622454069039543534e-1,
	-0.969117530159521214579e-1,
	-0.414983358359495381969e0,
	-0.406567124211938417342e0,
	-0.158413586390692192217e0,
	-0.240149820648571559892e-1,
	-0.100346687696279557415e-2
];
var Q2 = [
	0.1e1,
	0.302349829846463038743e1,
	0.348739585360723852576e1,
	0.191415588274426679201e1,
	0.507137738614363510846e0,
	0.577039722690451849648e-1,
	0.195768102601107189171e-2
];

var P3 = [
	-0.292329721830270012337e-1,
	0.144216267757192309184e0,
	-0.142440390738631274135e0,
	0.542809694055053558157e-1,
	-0.850535976868336437746e-2,
	0.431171342679297331241e-3,
	0.0
];
var Q3 = [
	0.1e1,
	-0.150169356054485044494e1,
	0.846973248876495016101e0,
	-0.220095151814995745555e0,
	0.25582797155975869989e-1,
	-0.100666795539143372762e-2,
	-0.827193521891290553639e-6
];

// Header to add to output files:
var header = licenseHeader( 'Apache-2.0', 'js', {
	'year': ( new Date() ).getFullYear(),
	'copyright': 'The Stdlib Authors'
});
header += '\n/* This is a generated file. Do not edit directly. */\n';


// MAIN //

/**
* Main execution sequence.
*
* @private
*/
function main() {
	var fpath;
	var opts;
	var str;

	opts = {
		'encoding': 'utf8'
	};

	fpath = resolve( __dirname, '..', 'lib', 'rational_p1q1.js' );
	str = header + compile( P1, Q1 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p2q2.js' );
	str = header + compile( P2, Q2 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p3q3.js' );
	str = header + compile( P3, Q3 );
	writeFileSync( fpath, str, opts );
}

main();
