C
C $Id: hstlst.f,v 1.7 2008-07-27 00:17:15 haley Exp $
C                                                                      
C                Copyright (C)  2000
C        University Corporation for Atmospheric Research
C                All Rights Reserved
C
C The use of this Software is governed by a License Agreement.
C
C *************************************************************
C
      SUBROUTINE HSTLST
C
C *************************************************************
C
C
      COMMON /HSTGC1/ HORZNT, PERCNT, MIDVAL, SHADE, MEDIAN, PERIM,
     -       HFRAME, LISTOP, WINDOW, COLORS, HSTFOR, TITLE, LABEL,
     -       FREQNC, HWIND(4), COLSHA, COLREC, COLAXI, COLMED, COLTEX,
     -       COLTIT, COLPER, DRAWL, SPACE, LABMAX, CHARL, HEIGHT,
     -       ORIENT, COLSH2, SETSPA, SETSP2, MVALU, SETMVA, SETEPS,
     -       NMVAL, PMVAL, PERTIT
      LOGICAL HORZNT, PERCNT, MIDVAL, SHADE, MEDIAN, PERIM, HFRAME,
     -        LISTOP, WINDOW, COLORS, HSTFOR, TITLE, LABEL, FREQNC,
     -        DRAWL, SPACE, CHARL, MVALU, NMVAL, PMVAL, PERTIT
      COMMON /HSTGC2/ STRFOR, STRTIT, STRLAB, STRFRE, STRPER, LABTEX
      CHARACTER*96  STRTIT
      CHARACTER*55  STRFOR, STRLAB, STRFRE, STRPER
      CHARACTER*15 LABTEX(30)
      INTEGER  COLSHA, COLREC, COLAXI, COLMED, COLTEX
      INTEGER  COLTIT, COLPER, COLSH2, HEIGHT, ORIENT
C
C  GET THE STANDARD OUTPUT UNIT TO WRITE THE OPTION VALUE LIST
C
      IUNIT = I1MACH(2)
      WRITE(IUNIT,1000)
 1000 FORMAT(//' HISTOGRAM OPTION VALUE LIST'/)
C
C  HORIZONTAL
C
      WRITE(IUNIT,1020)
 1020 FORMAT(5X,'HORIZONTAL, HOR')
      IF (HORZNT) THEN
          WRITE(IUNIT,1111)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  PERCENT AXIS
C
      WRITE(IUNIT,1030)
 1030 FORMAT(5X,'PERCENT, PER')
      IF (PERCNT) THEN
          WRITE(IUNIT,1111)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  MIDVALUES LABELED
C
      WRITE(IUNIT,1040)
 1040 FORMAT(5X,'MIDVALUE, MID')
      IF (MIDVAL) THEN
          WRITE(IUNIT,1111)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  SPACING
C
      WRITE(IUNIT,1050)
 1050 FORMAT(5X,'SPACE, SPA')
      IF (SPACE) THEN
          WRITE(IUNIT,1111)
          WRITE(IUNIT,1055)SETSPA,SETSP2
 1055 FORMAT(19X,'SPACING    =',F5.2/
     -       19X,'OVERLAP    =',F5.2)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  SPECIAL VALUE DETECTION
C
      WRITE(IUNIT,1051)
 1051 FORMAT(5X,'MVALU, MVA')
      IF (MVALU) THEN
          WRITE(IUNIT,1111)
	  WRITE(IUNIT,1056)SETMVA,SETEPS
 1056 FORMAT(19X,'VALUE      =',E9.2/
     -       19X,'EPSILON    =',E9.2)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  SPECIAL VALUE NORMALIZATION
C
      WRITE(IUNIT,1052)
 1052 FORMAT(5X,'NMVAL, NMV')
      IF (NMVAL) THEN
	  WRITE(IUNIT,1110)
      ELSE
	  WRITE(IUNIT,1111)
      ENDIF
C
C  SPECIAL VALUE PRINTING
C
      WRITE(IUNIT,1053)
 1053 FORMAT(5X,'PMVAL, PMV')
      IF (PMVAL) THEN
	  WRITE(IUNIT,1111)
      ELSE
	  WRITE(IUNIT,1110)
      ENDIF
C
C  SHADING
C
      WRITE(IUNIT,1060)
 1060 FORMAT(5X,'SHADING, SHA')
      IF (SHADE) THEN
          WRITE(IUNIT,1111)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  DRAWLINE
C
      WRITE(IUNIT,1070)
 1070 FORMAT(5x,'DRAWLINE,DRL')
      IF (DRAWL) THEN
          WRITE(IUNIT,1111)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  MEDIAN
C
      WRITE(IUNIT,1080)
 1080 FORMAT(5X,'MEDIAN, MED')
      IF (MEDIAN) THEN
          WRITE(IUNIT,1111)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  PERIMETER
C
      WRITE(IUNIT,1090)
 1090 FORMAT(5X,'PERIMETER, PRM')
      IF (PERIM) THEN
          WRITE(IUNIT,1111)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  FRAME CALLED
C
      WRITE(IUNIT,1120)
 1120 FORMAT(5X,'FRAME ADVANCE, FRA')
      IF (HFRAME) THEN
          WRITE(IUNIT,1111)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  WINDOW SET
C
      WRITE(IUNIT,1130)
 1130 FORMAT(5X,'WINDOW (VIEWPORT), WIN')
      IF (WINDOW) THEN
          WRITE(IUNIT,1111)
          WRITE(IUNIT,1140)(HWIND(I),I=1,4)
 1140 FORMAT(24X,'XMIN  =',F6.2/
     -       24X,'XMAX  =',F6.2/
     -       24X,'YMIN  =',F6.2/
     -       24X,'YMAX  =',F6.2)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  COLORS SET
C
      WRITE(IUNIT,1150)
 1150 FORMAT(5X,'COLORS, COL')
      IF (COLORS) THEN
          WRITE(IUNIT,1111)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
          WRITE(IUNIT,1160)COLSHA,COLSH2,COLREC,COLAXI,COLMED,COLTEX,
     -    COLTIT,COLPER
 1160 FORMAT(19X,'SHADING    =',I4/
     -       19X,'SHADE2     =',I4/
     -       19X,'RECTANGLES =',I4/
     -       19X,'AXES       =',I4/
     -       19X,'MEDIAN     =',I4/
     -       19X,'TEXT       =',I4/
     -       19X,'TITLE      =',I4/
     -       19X,'PERIMETER  =',I4)
C
C  CLASS INTERVAL FORMAT CHANGED
C
      WRITE(IUNIT,1170)
 1170 FORMAT(5X,'FORMAT, FOR')
      IF (HSTFOR) THEN
          WRITE(IUNIT,1111)
          WRITE(IUNIT,1180)STRFOR
 1180 FORMAT(8X,'CLASS INTERVAL FORMAT = ',55A)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  TITLE
C
      WRITE(IUNIT,1190)
 1190 FORMAT(5X,'TITLE, TIT')
      IF (TITLE) THEN
          WRITE(IUNIT,1111)
          WRITE(IUNIT,1200)STRTIT
 1200 FORMAT(20X,'TITLE : ',48A,/,32X,48A)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  CLASS INTERVAL LABEL CHANGED
C
      WRITE(IUNIT,1210)
 1210 FORMAT(/5X,'CLASS INTERVAL LABEL CHANGED, LAB')
      IF (LABEL) THEN
          WRITE(IUNIT,1111)
          WRITE(IUNIT,1220)STRLAB
 1220 FORMAT(20X,'CLASS INTERVAL LABEL : ',55A)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  FREQUENCY LABEL CHANGED
C
      WRITE(IUNIT,1230)
 1230 FORMAT(/5X,'FREQUENCY LABEL, FRE')
      IF (FREQNC) THEN
          WRITE(IUNIT,1111)
          WRITE(IUNIT,1240)STRFRE
 1240 FORMAT(20X,'FREQUENCY LABEL : ',55A)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  PERCENT LABEL CHANGED
C
      WRITE(IUNIT,1231)
 1231 FORMAT(/5X,'PERCENT LABEL, PTI')
      IF (PERTIT) THEN
          WRITE(IUNIT,1111)
	  WRITE(IUNIT,1241)STRPER
 1241 FORMAT(20X,'PERCENT LABEL : ',55A)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  ALPHANUMERIC CLASS LABELS USED
C
      WRITE(IUNIT,1250)
 1250 FORMAT(/5X,'CHARACTER CLASS-VALUE LABELS, CHR')
      IF (CHARL) THEN
          WRITE(IUNIT,1111)
      ELSE
          WRITE(IUNIT,1110)
      ENDIF
C
C  CHARACTER HEIGHT AND ORIENTATION OF CLASS LABELS
C
      WRITE(IUNIT,1260)HEIGHT,ORIENT
 1260 FORMAT(/5x,'CLASS LABEL HEIGHT AND ORIENTATION'/,
     -20X,'HEIGHT= ',I3,'    ORIENT= ',I3//)
C
 1110 FORMAT(30X,'= OFF')
 1111 FORMAT(30X,'= ON')
C
      RETURN
      END
