C
C $Id: isblda.f,v 1.6 2008-07-27 00:17:15 haley Exp $
C
C                Copyright (C)  2000
C        University Corporation for Atmospheric Research
C                All Rights Reserved
C
C The use of this Software is governed by a License Agreement.
C
      SUBROUTINE ISBLDA
C
C Calling this do-nothing subroutine forces "ld" to load the following
C block data routine (but only if they are in the same ".f" file).
C
        RETURN
C
      END
CNOSPLIT
      BLOCKDATA ISBLDAX
C
C Block data routine, in which some default values are set.
C
      COMMON /ISCOMN/ BIG,BIGD,DBPI,IDONE,IFILL,IFLIP,IONES,IHSS(1000),
     +                IREF,ISCA(16,256),ISCALE,ISCR(16,256),ISLBT,ISDR,
     +                LHSS,LX,NFPW,NINU,NINV,NINW,NX,NY,R0,RNX,RNY,
     +                SMALL,SVAL,TENSN,U,V,W,XMAX,XMIN,YMAX,YMIN,XVPL,
     +                XVPR,YVPB,YVPT
      SAVE   /ISCOMN/
C
      COMMON /TEMPRX/ RZERO
      SAVE   /TEMPRX/
C
C DBPI is the desired distance between interpolated points used to
C represent the smooth curves generated by the spline fitter.  It is
C given in the fractional coordinate system.
C
      DATA DBPI / .01 /
C
C IDONE is the "initialization-done" flag.
C
      DATA IDONE / 0 /
C
C SVAL, if non-zero, is the "special value" that signals missing data.
C
      DATA SVAL / 0. /
C
C IREF is a flag controlling the drawing of reference planes and/or
C axes.  By default, these are turned on.
C
      DATA IREF / 1 /
C
C ISDR is set non-zero to suppress drawing of lines by the routine
C ISPLTF.
C
      DATA ISDR / 0 /
C
C LX is the first dimension of the screen model arrays; its value must
C be consistent with the declarations of ISCA and ISCR, above.
C
      DATA LX / 16 /
C
C NX and NY are the dimensions of the screen models.  The two values
C should be set equal to one another, and both values should be either
C 128 or 256.
C
      DATA NX,NY / 128,128 /
C
C LHSS is the length of the array IHSS, in which the contour-tracing
C routine keeps track of horizontal segments already seen.
C
      DATA LHSS / 1000 /
C
C RZERO is set non-zero if the "relative size feature" is to be used.
C
      DATA RZERO / 0. /
C
C SMALL is used by the routines ISTRCL and ISSMTH.  It specifies, in the
C fractional coordinate system, the smallest distance between two points
C in order for the points to be considered distinct.
C
      DATA SMALL / .000001 /
C
C TENSN is the tension on the splines used by the routine ISSMTH.
C
      DATA TENSN / 0. /
C
C XVPL, XVPR, YVPB, YVPT specify the left, right, bottom, and top edges
C of the viewport in which the ISOSRF plot is to be drawn.  Each is a
C real number between 0 and 1.
C
      DATA XVPL,XVPR,YVPB,YVPT / 0.,1.,0.,1. /
C
      END
