#/bin/bash

if [ "$1" != "mingw32" ] && [ "$1" != "mingw64" ]
then 
	echo "This script requires one argument : mingw32 or mingw64"
	exit 1
fi

srcDir="/$1/bin"
destDir="/c/msXpertSuite-libDeps/$1"

echo "Copying dll files from ${srcDir} to ${destDir}"
echo "OK ? yY|nN"

read answer

if [ ${answer} != "y" ] && [ ${answer} != "Y" ] 
then
	echo "Operation aborted by the user."
fi

wasError="false"

for file in ${destDir}/*.dll
do
	# echo "Current file: ${file}"

	baseName=$(basename ${file})
	# echo "baseName: ${baseName}"

	if [ ! -e ${srcDir}/${baseName} ]
	then
		echo "Attention, file ${baseName} not found."
	else
		cp -v ${srcDir}/${baseName} ${destDir}

		if [ $? != 0 ]
		then
			echo "Failed to copy ${baseName}"
			wasError="true"
		fi

	fi
done

# And now the platforms/qwindows.dll
cp -v /$1/share/qt5/plugins/platforms/qwindows.dll ${destDir}/platforms

if [ "$?" != "0" ]
then
	echo "Attention, failed to copy platforms/qwindows.dll."
	exit 1
fi

if [ ${wasError} == "true" ]
then
	echo "There was at least one error."
	exit 1
fi

echo "Done."
exit 0

