/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQMarsBrowser_H
#define MvQMarsBrowser_H

#include "MvQMainWindow.h"
#include "MvQMenuItem.h"

class QAction;
class QComboBox;
class QHBoxLayout;
class QLabel;
class QListWidget;
class QListWidgetItem;
class QProgressBar;
class QSplitter;
class QPlainTextEdit;
class QTabWidget;
class QTreeWidget;
class QTreeWidgetItem;

class MvQLogBrowser;
class MvQMarsCatalog;
class MvQMarsCatalogData;
class MvQMarsCatalogNode;

class MvQMarsBrowser : public MvQMainWindow
{
    Q_OBJECT

public:
    MvQMarsBrowser(QWidget* parent = 0);
    ~MvQMarsBrowser();
    void init();

public slots:
    void slotFetchFinished(QString, bool);
    void slotNodeSelected(QTreeWidgetItem* item, int column);
    void slotNodeSelected(QTreeWidgetItem*, QTreeWidgetItem*);
    void slotValueSelected(QListWidgetItem*);
    void slotCreateMarsIcon();
    void slotShowAboutBox();
    void slotClearLog(bool);
    void slotUpdateLogOutput();

protected:
    void setupViewActions();
    void setupControlsActions();
    void setupHelpActions();
    void fetchStarted();
    void fetchFinished();
    void fetch();
    void reset();
    void updateUi();
    void readSettings();
    void writeSettings();

    void createAxisWidget(MvQMarsCatalogNode*);

    QComboBox* dbCombo_;
    QTreeWidget* nodeTree_;
    QListWidget* itemList_;

    MvQMarsCatalog* catalog_;
    MvQMarsCatalogData* data_;

    QTabWidget* mainTab_;
    QSplitter* mainSplitter_;
    QSplitter* centralSplitter_;
    QAction* actionLog_;
    QWidget* logPanel_;
    MvQLogBrowser* logBrowser_;
    QProgressBar* loadProgress_;
    QLabel* statusMessageLabel_;
    QPlainTextEdit* requestTe_;
    QPlainTextEdit* macroTe_;

    MvQMainWindow::MenuItemMap menuItems_;

    QHBoxLayout* axisLayout_;
    QList<QListWidget*> axisList_;
};

#endif