# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.open_gl_render_window import OpenGLRenderWindow


class VRRenderWindow(OpenGLRenderWindow):
    r"""
    VRRenderWindow - VR rendering window
    
    Superclass: OpenGLRenderWindow
    
    VRRenderWindow is a abstract class to define a render_window in a
    VR context.
    
    VR provides HMD and controller positions in the "Physical" coordinate
    system. For room scale VR this is based on the room setup per the
    underlying VR API being used. Units are in meters.
    
    Renderer shows actors in the World coordinate system. Transformation
    between Physical and World coordinate systems is defined by
    physical_to_world_matrix. This matrix determines the user's position and
    orientation in the rendered scene and scaling (magnification) of
    rendered actors.
    
    This class introduces the notion of device_handles. A device_handle is
    a uint32_t handle that represents a device in the underlying VR API
    such as open_vr or open_xr. Implementations of this class are
    responsible for mapping the actual devices from that API into unique
    device_handles. Typically these devices are handheld controllers,
    HMDs, stylus etc. The subclass should call add_device_handle when it
    first sees a new device.
    
    This class also uses the term Device from EventDataDevice to
    represent a generic device type that is used in the event handling
    system. Multiple device_handles could point to the same Device though
    most often there is a one to one mapping. For example
    EventDataDevice::LeftController will typically have one or zero
    device_handles that map to it.
    
    Most event processing works with generic devices and this class
    provides a number of methods to support that. This class also
    provides a number of methods that work on device_handles which are
    typically used by VR classes and their subclasses.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVRRenderWindow, obj, update, **traits)
    
    base_station_visibility = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get the visibility of the base stations. Defaults to false
        """
    )

    def _base_station_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBaseStationVisibility,
                        self.base_station_visibility_)

    def _get_helper_window(self):
        return wrap_vtk(self._vtk_obj.GetHelperWindow())
    def _set_helper_window(self, arg):
        old_val = self._get_helper_window()
        self._wrap_call(self._vtk_obj.SetHelperWindow,
                        deref_vtk(arg))
        self.trait_property_changed('helper_window', old_val, arg)
    helper_window = traits.Property(_get_helper_window, _set_helper_window, desc=\
        r"""
        Set/Get the window to use for the openGL context
        """
    )

    physical_scale = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get physical coordinate system in world coordinate system.
        
        Ratio of distance in world coordinate and physical and system
        (physical_scale = distance_World / distance_Physical). Example: if
        world coordinate system is in mm then physical_scale = 1000.0
        makes objects appear in real size. physical_scale = 100.0 makes
        objects appear 10x larger than real size.
        """
    )

    def _physical_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPhysicalScale,
                        self.physical_scale)

    def get_physical_to_world_matrix(self, *args):
        """
        get_physical_to_world_matrix(self, matrix:Matrix4x4) -> None
        
        Get physical to world transform matrix. Members used to calculate
        the matrix:
        \\sa physical_view_direction, \\sa physical_view_up, \\sa
            physical_translation, \\sa physical_scale
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetPhysicalToWorldMatrix, *my_args)
        return ret

    def set_physical_to_world_matrix(self, *args):
        """
        set_physical_to_world_matrix(self, matrix:Matrix4x4) -> None
        C++: void set_physical_to_world_matrix(Matrix4x4 *matrix)
        Set physical to world transform matrix. Members calculated and
        set from the matrix:
        \\sa physical_view_direction, \\sa physical_view_up, \\sa
            physical_translation, \\sa physical_scale
        The x axis scale is used for \\sa physical_scale
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetPhysicalToWorldMatrix, *my_args)
        return ret

    physical_translation = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set/get physical coordinate system in world coordinate system.
        
        Position of the physical coordinate system origin in world
        coordinates.
        \sa set_physical_view_direction, \sa set_physical_view_up,
        \sa set_physical_scale, \sa set_physical_to_world_matrix
        """
    )

    def _physical_translation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPhysicalTranslation,
                        self.physical_translation)

    physical_view_direction = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set/get physical coordinate system in world coordinate system.
        
        View direction is the -Z axis of the physical coordinate system
        in world coordinate system.
        \sa set_physical_view_up, \sa set_physical_translation,
        \sa set_physical_scale, \sa set_physical_to_world_matrix
        """
    )

    def _physical_view_direction_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPhysicalViewDirection,
                        self.physical_view_direction)

    physical_view_up = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set/get physical coordinate system in world coordinate system.
        
        View up is the +Y axis of the physical coordinate system in world
        coordinate system.
        \sa set_physical_view_direction, \sa set_physical_translation,
        \sa set_physical_scale, \sa set_physical_to_world_matrix
        """
    )

    def _physical_view_up_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPhysicalViewUp,
                        self.physical_view_up)

    size = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(0, 0), cols=2, desc=\
        r"""
        Set the size of the window in screen coordinates in pixels. This
        resizes the operating system's window and redraws it.
        
        If the size has changed, this method will fire
        Command::WindowResizeEvent.
        """
    )

    def _size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSize,
                        self.size)

    def _get_track_hmd(self):
        return self._vtk_obj.GetTrackHMD()
    def _set_track_hmd(self, arg):
        old_val = self._get_track_hmd()
        self._wrap_call(self._vtk_obj.SetTrackHMD,
                        arg)
        self.trait_property_changed('track_hmd', old_val, arg)
    track_hmd = traits.Property(_get_track_hmd, _set_track_hmd, desc=\
        r"""
        
        """
    )

    def get_device_to_physical_matrix_for_device(self, *args):
        """
        get_device_to_physical_matrix_for_device(self, idx:EventDataDevice)
            -> Matrix4x4
        C++: Matrix4x4 *get_device_to_physical_matrix_for_device(
            EventDataDevice idx)
        Get the device_to_physical matrix corresponding to the device or
        device handle. e.g. 0,0,0,1 pushed through this matrix will give
        you the location of the device in physical coordinates.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetDeviceToPhysicalMatrixForDevice, *my_args)
        return wrap_vtk(ret)

    def _get_initialized(self):
        return self._vtk_obj.GetInitialized()
    initialized = traits.Property(_get_initialized, desc=\
        r"""
        Get whether the window has been initialized successfully.
        """
    )

    def get_model_for_device(self, *args):
        """
        get_model_for_device(self, idx:EventDataDevice) -> VRModel
        C++: VRModel *get_model_for_device(EventDataDevice idx)
        Get the VRModel corresponding to the device or device handle.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetModelForDevice, *my_args)
        return wrap_vtk(ret)

    def get_render_buffer_size(self, *args):
        """
        get_render_buffer_size(self, width:int, height:int) -> None
        C++: void get_render_buffer_size(int &width, int &height)"""
        ret = self._wrap_call(self._vtk_obj.GetRenderBufferSize, *args)
        return ret

    def initialize_view_from_camera(self, *args):
        """
        initialize_view_from_camera(self, cam:Camera) -> None
        C++: virtual void initialize_view_from_camera(Camera *cam)
        Initialize the HMD to World setting and camera settings so that
        the VR world view most closely matched the view from the provided
        camera. This method is useful for initializing a VR world from an
        existing on screen window and camera. The Renderer and its camera
        must already be created and set when this is called.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializeViewFromCamera, *my_args)
        return ret

    def render_models(self):
        """
        render_models(self) -> None
        C++: virtual void render_models()
        Render the controller and base station models
        """
        ret = self._vtk_obj.RenderModels()
        return ret
        

    def update_hmd_matrix_pose(self):
        """
        update_hmd_matrix_pose(self) -> None
        C++: virtual void update_hmd_matrix_pose()
        Update the HMD pose.
        """
        ret = self._vtk_obj.UpdateHMDMatrixPose()
        return ret
        

    _updateable_traits_ = \
    (('base_station_visibility', 'GetBaseStationVisibility'),
    ('framebuffer_flip_y', 'GetFramebufferFlipY'), ('borders',
    'GetBorders'), ('full_screen', 'GetFullScreen'), ('line_smoothing',
    'GetLineSmoothing'), ('point_smoothing', 'GetPointSmoothing'),
    ('polygon_smoothing', 'GetPolygonSmoothing'), ('stencil_capable',
    'GetStencilCapable'), ('stereo_capable_window',
    'GetStereoCapableWindow'), ('stereo_render', 'GetStereoRender'),
    ('swap_buffers', 'GetSwapBuffers'), ('use_srgb_color_space',
    'GetUseSRGBColorSpace'), ('double_buffer', 'GetDoubleBuffer'),
    ('erase', 'GetErase'), ('off_screen_rendering',
    'GetOffScreenRendering'), ('show_window', 'GetShowWindow'),
    ('use_off_screen_buffers', 'GetUseOffScreenBuffers'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('frame_blit_mode', 'GetFrameBlitMode'), ('stereo_type',
    'GetStereoType'), ('physical_scale', 'GetPhysicalScale'),
    ('physical_to_world_matrix', 'GetPhysicalToWorldMatrix'),
    ('physical_translation', 'GetPhysicalTranslation'),
    ('physical_view_direction', 'GetPhysicalViewDirection'),
    ('physical_view_up', 'GetPhysicalViewUp'), ('size', 'GetSize'),
    ('global_maximum_number_of_multi_samples',
    'GetGlobalMaximumNumberOfMultiSamples'), ('abort_render',
    'GetAbortRender'), ('alpha_bit_planes', 'GetAlphaBitPlanes'),
    ('anaglyph_color_mask', 'GetAnaglyphColorMask'),
    ('anaglyph_color_saturation', 'GetAnaglyphColorSaturation'),
    ('current_cursor', 'GetCurrentCursor'), ('cursor_file_name',
    'GetCursorFileName'), ('desired_update_rate', 'GetDesiredUpdateRate'),
    ('device_index', 'GetDeviceIndex'), ('in_abort_check',
    'GetInAbortCheck'), ('multi_samples', 'GetMultiSamples'),
    ('number_of_layers', 'GetNumberOfLayers'), ('dpi', 'GetDPI'),
    ('position', 'GetPosition'), ('tile_scale', 'GetTileScale'),
    ('tile_viewport', 'GetTileViewport'), ('window_name',
    'GetWindowName'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['base_station_visibility', 'borders', 'debug', 'double_buffer',
    'erase', 'framebuffer_flip_y', 'full_screen',
    'global_warning_display', 'line_smoothing', 'off_screen_rendering',
    'point_smoothing', 'polygon_smoothing', 'show_window',
    'stencil_capable', 'stereo_capable_window', 'stereo_render',
    'swap_buffers', 'use_off_screen_buffers', 'use_srgb_color_space',
    'frame_blit_mode', 'stereo_type', 'abort_render', 'alpha_bit_planes',
    'anaglyph_color_mask', 'anaglyph_color_saturation', 'current_cursor',
    'cursor_file_name', 'desired_update_rate', 'device_index', 'dpi',
    'global_maximum_number_of_multi_samples', 'in_abort_check',
    'multi_samples', 'number_of_layers', 'object_name', 'physical_scale',
    'physical_to_world_matrix', 'physical_translation',
    'physical_view_direction', 'physical_view_up', 'position', 'size',
    'tile_scale', 'tile_viewport', 'window_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VRRenderWindow, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VRRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['base_station_visibility', 'borders', 'double_buffer', 'erase',
            'framebuffer_flip_y', 'full_screen', 'line_smoothing',
            'off_screen_rendering', 'point_smoothing', 'polygon_smoothing',
            'show_window', 'stencil_capable', 'stereo_capable_window',
            'stereo_render', 'swap_buffers', 'use_off_screen_buffers',
            'use_srgb_color_space'], ['frame_blit_mode', 'stereo_type'],
            ['abort_render', 'alpha_bit_planes', 'anaglyph_color_mask',
            'anaglyph_color_saturation', 'current_cursor', 'cursor_file_name',
            'desired_update_rate', 'device_index', 'dpi',
            'global_maximum_number_of_multi_samples', 'in_abort_check',
            'multi_samples', 'number_of_layers', 'object_name', 'physical_scale',
            'physical_to_world_matrix', 'physical_translation',
            'physical_view_direction', 'physical_view_up', 'position', 'size',
            'tile_scale', 'tile_viewport', 'window_name']),
            title='Edit VRRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VRRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

