#if   !defined(__EDIT_HPP)
#define __EDIT_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__SUBJECTOBSERVER_HPP)
#include <SubjectObserver.hpp>
#endif

DECLARE_CLASS( ListMediator );
DECLARE_CLASS( Edit );

/**
Edit listens for a selection event and
allows the user to change the entry
*/

class Edit : public SubjectObserver
{

public:

   //
   // Constructors and destructor
   //

                        /// Default constructor

                        Edit( void );   

                        /// Virtual destructor

   virtual              ~Edit( void );   

   //
   // Operator overloads
   //

            /// Equality operator

            bool operator==( EditCref ) const;

   //
   // Accessors
   //

   //
   // Mutators
   //
            /**
            Called by a subject when 
            an event that this observer is interested in
            gets generated.
            @param Event pointer to event
            */

   virtual  void  event( CORELINUX( Event<corelinux::Identifier> ) * ) throw ( CORELINUX(NullPointerException) );


protected:
                     /// Copy constructor
                  
                     Edit( EditCref ) throw ( CORELINUX( Assertion ) );

            /// Assignment operator

            EditRef  operator=( EditCref ) throw ( CORELINUX( Assertion ) );


private:


};

#endif // if !defined(__EDIT_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:49:01 $
   $Locker:  $
*/



