#
# This file is part of Config-Model
#
# This software is Copyright (c) 2005-2018 by Dominique Dumont.
#
# This is free software, licensed under:
#
#   The GNU Lesser General Public License, Version 2.1, February 1999
#

# test inifile backend

# specify where is the example file
$conf_file_name = 'test.kv';
$conf_dir = '/etc';

# specify the name of the class to test
$model_to_test = "IniKeyValue";

# create minimal model to test ini file backend.


$model->create_config_class(
    name => 'IniKeyValue',
    element => [
        [qw/package-status report-with/] => {
            qw/type leaf value_type uniline/,
        },
    ],
    read_config => [{
        backend     => 'IniFile',
        # specify where is the config file. this must match
        # the $conf_file_name and $conf_dir variable above
        assign_char => ':',
        assign_with => ' : ',
        config_dir  => '/etc/',
        file        => 'test.kv',
    }],
);


# the test suite
@tests = (
    {   # test complex parameters
        name  => 'bts-control',
    },
);

1;
