/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.xpath.XPathException;

public class IndexOf
extends CollatingFunction {
    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        AtomicComparer atomicComparer = this.getAtomicComparer(2, xPathContext);
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        AtomicValue atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        return new IndexIterator(sequenceIterator, atomicValue, atomicComparer);
    }

    private class IndexIterator
    implements SequenceIterator {
        SequenceIterator base;
        AtomicValue value;
        AtomicComparer comparer;
        int index = 0;
        int position = 0;
        Item current = null;

        public IndexIterator(SequenceIterator sequenceIterator, AtomicValue atomicValue, AtomicComparer atomicComparer) throws XPathException {
            this.base = sequenceIterator;
            this.value = atomicValue;
            this.comparer = atomicComparer;
        }

        public Item next() throws XPathException {
            AtomicValue atomicValue;
            while ((atomicValue = (AtomicValue)this.base.next()) != null) {
                ++this.index;
                if (!this.comparer.comparesEqual(atomicValue, this.value)) continue;
                this.current = new IntegerValue(this.index);
                ++this.position;
                return this.current;
            }
            return null;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new IndexIterator(this.base.getAnother(), this.value, this.comparer);
        }
    }
}

