package org.apache.solr.analysis;

/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.lucene.analysis.CharStream;
import org.apache.lucene.analysis.fa.PersianCharFilter;

/**
 * Factory for {@link PersianCharFilter}.
 * <pre class="prettyprint" >
 * &lt;fieldType name="text_fa" class="solr.TextField" positionIncrementGap="100"&gt;
 *   &lt;analyzer&gt;
 *     &lt;charFilter class="solr.PersianCharFilterFactory"/&gt;
 *     &lt;tokenizer class="solr.StandardTokenizerFactory"/&gt;
 *   &lt;/analyzer&gt;
 * &lt;/fieldType&gt;</pre>
 * @version $Id$
 */
public class PersianCharFilterFactory extends BaseCharFilterFactory implements MultiTermAwareComponent {

  public CharStream create(CharStream input) {
    return new PersianCharFilter(input);
  }

  public Object getMultiTermComponent() {
    return this;
  }
}
