/* linux/drivers/media/video/exynos/gsc/coef.c
 *
 * Copyright (c) 2011 Samsung Electronics Co., Ltd.
 *		http://www.samsung.com
 *
 * G-scaler poly-phase filter coefficients
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 2 of the License,
 * or (at your option) any later version.
 */

#include <linux/types.h>
#include "gsc-core.h"

/* 8-tap Filter Coefficient */
const int h_coef_8t[7][16][8] = {
	{	/* Ratio <= 65536 (~8:8) */
		{  0,  0,   0, 128,   0,   0,  0,  0 },/* 0 */
		{ -1,  2,  -6, 127,   7,  -2,  1,  0 },/* 1 */
		{ -1,  4, -12, 125,  16,  -5,  1,  0 },/* 2 */
		{ -1,  5, -15, 120,  25,  -8,  2,  0 },/* 3 */
		{ -1,  6, -18, 114,  35, -10,  3, -1 },/* 4 */
		{ -1,  6, -20, 107,  46, -13,  4, -1 },/* 5 */
		{ -2,  7, -21,  99,  57, -16,  5, -1 },/* 6 */
		{ -1,  6, -20,  89,  68, -18,  5, -1 },/* 7 */
		{ -1,  6, -20,  79,  79, -20,  6, -1 },/* 8 */
		{ -1,  5, -18,  68,  89, -20,  6, -1 },/* 9 */
		{ -1,  5, -16,  57,  99, -21,  7, -2 },/* 10 */
		{ -1,  4, -13,  46, 107, -20,  6, -1 },/* 11 */
		{ -1,  3, -10,  35, 114, -18,  6, -1 },/* 12 */
		{  0,  2,  -8,  25, 120, -15,  5, -1 },/* 13 */
		{  0,  1,  -5,  16, 125, -12,  4, -1 },/* 14 */
		{  0,  1,  -2,   7, 127,  -6,  2, -1 } /* 15 */
	},
	{	/* 65536 < Ratio <= 74898 (~8:7) */
		{  3, -8,  14, 111,  13,  -8,  3,  0 },/* 0 */
		{  2, -6,   7, 112,  21, -10,  3, -1 },/* 1 */
		{  2, -4,   1, 110,  28, -12,  4, -1 },/* 2 */
		{  1, -2,  -3, 106,  36, -13,  4, -1 },/* 3 */
		{  1, -1,  -7, 103,  44, -15,  4, -1 },/* 4 */
		{  1,  1, -11,  97,  53, -16,  4, -1 },/* 5 */
		{  0,  2, -13,  91,  61, -16,  4, -1 },/* 6 */
		{  0,  3, -15,  85,  69, -17,  4, -1 },/* 7 */
		{  0,  3, -16,  77,  77, -16,  3,  0 },/* 8 */
		{ -1,  4, -17,  69,  85, -15,  3,  0 },/* 9 */
		{ -1,  4, -16,  61,  91, -13,  2,  0 },/* 10 */
		{ -1,  4, -16,  53,  97, -11,  1,  1 },/* 11 */
		{ -1,  4, -15,  44, 103,  -7, -1,  1 },/* 12 */
		{ -1,  4, -13,  36, 106,  -3, -2,  1 },/* 13 */
		{ -1,  4, -12,  28, 110,   1, -4,  2 },/* 14 */
		{ -1,  3, -10,  21, 112,   7, -6,  2 } /* 15 */
	},
	{	/* 74898 < Ratio <= 87381 (~8:6) */
		{ 2, -11,  25,  96, 25, -11,   2,  0 },/* 0 */
		{ 2, -10,  19,  96, 31, -12,   2,  0 },/* 1 */
		{ 2,  -9,  14,  94, 37, -12,   2,  0 },/* 2 */
		{ 2,  -8,  10,  92, 43, -12,   1,  0 },/* 3 */
		{ 2,  -7,   5,  90, 49, -12,   1,  0 },/* 4 */
		{ 2,  -5,   1,  86, 55, -12,   0,  1 },/* 5 */
		{ 2,  -4,  -2,  82, 61, -11,  -1,  1 },/* 6 */
		{ 1,  -3,  -5,  77, 67,  -9,  -1,  1 },/* 7 */
		{ 1,  -2,  -7,  72, 72,  -7,  -2,  1 },/* 8 */
		{ 1,  -1,  -9,  67, 77,  -5,  -3,  1 },/* 9 */
		{ 1,  -1, -11,  61, 82,  -2,  -4,  2 },/* 10 */
		{ 1,   0, -12,  55, 86,   1,  -5,  2 },/* 11 */
		{ 0,   1, -12,  49, 90,   5,  -7,  2 },/* 12 */
		{ 0,   1, -12,  43, 92,  10,  -8,  2 },/* 13 */
		{ 0,   2, -12,  37, 94,  14,  -9,  2 },/* 14 */
		{ 0,   2, -12,  31, 96,  19, -10,  2 } /* 15 */
	},
	{	/* 87381 < Ratio <= 104857 (~8:5) */
		{ -1,  -8, 33,  80, 33,  -8,  -1,  0 },/* 0 */
		{ -1,  -8, 28,  80, 37,  -7,  -2,  1 },/* 1 */
		{  0,  -8, 24,  79, 41,  -7,  -2,  1 },/* 2 */
		{  0,  -8, 20,  78, 46,  -6,  -3,  1 },/* 3 */
		{  0,  -8, 16,  76, 50,  -4,  -3,  1 },/* 4 */
		{  0,  -7, 13,  74, 54,  -3,  -4,  1 },/* 5 */
		{  1,  -7, 10,  71, 58,  -1,  -5,  1 },/* 6 */
		{  1,  -6,  6,  68, 62,   1,  -5,  1 },/* 7 */
		{  1,  -6,  4,  65, 65,   4,  -6,  1 },/* 8 */
		{  1,  -5,  1,  62, 68,   6,  -6,  1 },/* 9 */
		{  1,  -5, -1,  58, 71,  10,  -7,  1 },/* 10 */
		{  1,  -4, -3,  54, 74,  13,  -7,  0 },/* 11 */
		{  1,  -3, -4,  50, 76,  16,  -8,  0 },/* 12 */
		{  1,  -3, -6,  46, 78,  20,  -8,  0 },/* 13 */
		{  1,  -2, -7,  41, 79,  24,  -8,  0 },/* 14 */
		{  1,  -2, -7,  37, 80,  28,  -8, -1 } /* 15 */
	},
	{	/* 104857 < Ratio <= 131072 (~8:4) */
		{ -3,   0, 35,  64, 35,   0,  -3,  0 },/* 0 */
		{ -3,  -1, 32,  64, 38,   1,  -3,  0 },/* 1 */
		{ -2,  -2, 29,  63, 41,   2,  -3,  0 },/* 2 */
		{ -2,  -3, 27,  63, 43,   4,  -4,  0 },/* 3 */
		{ -2,  -3, 24,  61, 46,   6,  -4,  0 },/* 4 */
		{ -2,  -3, 21,  60, 49,   7,  -4,  0 },/* 5 */
		{ -1,  -4, 19,  59, 51,   9,  -4, -1 },/* 6 */
		{ -1,  -4, 16,  57, 53,  12,  -4, -1 },/* 7 */
		{ -1,  -4, 14,  55, 55,  14,  -4, -1 },/* 8 */
		{ -1,  -4, 12,  53, 57,  16,  -4, -1 },/* 9 */
		{ -1,  -4,  9,  51, 59,  19,  -4, -1 },/* 10 */
		{  0,  -4,  7,  49, 60,  21,  -3, -2 },/* 11 */
		{  0,  -4,  6,  46, 61,  24,  -3, -2 },/* 12 */
		{  0,  -4,  4,  43, 63,  27,  -3, -2 },/* 13 */
		{  0,  -3,  2,  41, 63,  29,  -2, -2 },/* 14 */
		{  0,  -3,  1,  38, 64,  32,  -1, -3 } /* 15 */
	},
	{	/* 131072 < Ratio <= 174762 (~8:3) */
		{ -1,   8, 33,  48, 33,   8,  -1,  0 },/* 0 */
		{ -1,   7, 31,  49, 35,   9,  -1, -1 },/* 1 */
		{ -1,   6, 30,  49, 36,  10,  -1, -1 },/* 2 */
		{ -1,   5, 28,  48, 38,  12,  -1, -1 },/* 3 */
		{ -1,   4, 26,  48, 39,  13,   0, -1 },/* 4 */
		{ -1,   3, 24,  47, 41,  15,   0, -1 },/* 5 */
		{ -1,   2, 23,  47, 42,  16,   0, -1 },/* 6 */
		{ -1,   2, 21,  45, 43,  18,   1, -1 },/* 7 */
		{ -1,   1, 19,  45, 45,  19,   1, -1 },/* 8 */
		{ -1,   1, 18,  43, 45,  21,   2, -1 },/* 9 */
		{ -1,   0, 16,  42, 47,  23,   2, -1 },/* 10 */
		{ -1,   0, 15,  41, 47,  24,   3, -1 },/* 11 */
		{ -1,   0, 13,  39, 48,  26,   4, -1 },/* 12 */
		{ -1,  -1, 12,  38, 48,  28,   5, -1 },/* 13 */
		{ -1,  -1, 10,  36, 49,  30,   6, -1 },/* 14 */
		{ -1,  -1,  9,  35, 49,  31,   7, -1 } /* 15 */
	},
	{	/* 174762 < Ratio <= 262144 (~8:2) */
		{  2,  13, 30,  38, 30,  13,   2,  0 },/* 0 */
		{  2,  12, 29,  38, 30,  14,   3,  0 },/* 1 */
		{  2,  11, 28,  38, 31,  15,   3,  0 },/* 2 */
		{  2,  10, 26,  38, 32,  16,   4,  0 },/* 3 */
		{  1,  10, 26,  37, 33,  17,   4,  0 },/* 4 */
		{  1,   9, 24,  37, 34,  18,   5,  0 },/* 5 */
		{  1,   8, 24,  37, 34,  19,   5,  0 },/* 6 */
		{  1,   7, 22,  36, 35,  20,   6,  1 },/* 7 */
		{  1,   6, 21,  36, 36,  21,   6,  1 },/* 8 */
		{  1,   6, 20,  35, 36,  22,   7,  1 },/* 9 */
		{  0,   5, 19,  34, 37,  24,   8,  1 },/* 10 */
		{  0,   5, 18,  34, 37,  24,   9,  1 },/* 11 */
		{  0,   4, 17,  33, 37,  26,  10,  1 },/* 12 */
		{  0,   4, 16,  32, 38,  26,  10,  2 },/* 13 */
		{  0,   3, 15,  31, 38,  28,  11,  2 },/* 14 */
		{  0,   3, 14,  30, 38,  29,  12,  2 } /* 15 */
	}
};

/* 4-tap Filter Coefficient */
const int v_coef_4t[7][16][4] = {
	{	/* Ratio <= 65536 (~8:8) */
		{  0, 128,   0,  0 },/* 0 */
		{ -4, 127,   5,  0 },/* 1 */
		{ -6, 124,  11, -1 },/* 2 */
		{ -8, 118,  19, -1 },/* 3 */
		{ -8, 111,  27, -2 },/* 4 */
		{ -8, 102,  37, -3 },/* 5 */
		{ -8,  92,  48, -4 },/* 6 */
		{ -7,  81,  59, -5 },/* 7 */
		{ -6,  70,  70, -6 },/* 8 */
		{ -5,  59,  81, -7 },/* 9 */
		{ -4,  48,  92, -8 },/* 10 */
		{ -3,  37, 102, -8 },/* 11 */
		{ -2,  27, 111, -8 },/* 12 */
		{ -1,  19, 118, -8 },/* 13 */
		{ -1,  11, 124, -6 },/* 14 */
		{  0,   5, 127, -4 } /* 15 */
	},
	{	/* 65536 < Ratio <= 74898 (~8:7) */
		{  8, 112,   8,  0 },/* 0 */
		{  4, 111,  14, -1 },/* 1 */
		{  1, 109,  20, -2 },/* 2 */
		{ -2, 105,  27, -2 },/* 3 */
		{ -3, 100,  34, -3 },/* 4 */
		{ -5,  93,  43, -3 },/* 5 */
		{ -5,  86,  51, -4 },/* 6 */
		{ -5,  77,  60, -4 },/* 7 */
		{ -5,  69,  69, -5 },/* 8 */
		{ -4,  60,  77, -5 },/* 9 */
		{ -4,  51,  86, -5 },/* 10 */
		{ -3,  43,  93, -5 },/* 11 */
		{ -3,  34, 100, -3 },/* 12 */
		{ -2,  27, 105, -2 },/* 13 */
		{ -2,  20, 109,  1 },/* 14 */
		{ -1,  14, 111,  4 } /* 15 */
	},
	{	/* 74898 < Ratio <= 87381 (~8:6) */
		{ 16,  96,  16,  0 },/* 0 */
		{ 12,  97,  21, -2 },/* 1 */
		{  8,  96,  26, -2 },/* 2 */
		{  5,  93,  32, -2 },/* 3 */
		{  2,  89,  39, -2 },/* 4 */
		{  0,  84,  46, -2 },/* 5 */
		{ -1,  79,  53, -3 },/* 6 */
		{ -2,  73,  59, -2 },/* 7 */
		{ -2,  66,  66, -2 },/* 8 */
		{ -2,  59,  73, -2 },/* 9 */
		{ -3,  53,  79, -1 },/* 10 */
		{ -2,  46,  84,  0 },/* 11 */
		{ -2,  39,  89,  2 },/* 12 */
		{ -2,  32,  93,  5 },/* 13 */
		{ -2,  26,  96,  8 },/* 14 */
		{ -2,  21,  97, 12 } /* 15 */
	},
	{	/* 87381 < Ratio <= 104857 (~8:5) */
		{ 22,  84,  22,  0 },/* 0 */
		{ 18,  85,  26, -1 },/* 1 */
		{ 14,  84,  31, -1 },/* 2 */
		{ 11,  82,  36, -1 },/* 3 */
		{  8,  79,  42, -1 },/* 4 */
		{  6,  76,  47, -1 },/* 5 */
		{  4,  72,  52,  0 },/* 6 */
		{  2,  68,  58,  0 },/* 7 */
		{  1,  63,  63,  1 },/* 8 */
		{  0,  58,  68,  2 },/* 9 */
		{  0,  52,  72,  4 },/* 10 */
		{ -1,  47,  76,  6 },/* 11 */
		{ -1,  42,  79,  8 },/* 12 */
		{ -1,  36,  82, 11 },/* 13 */
		{ -1,  31,  84, 14 },/* 14 */
		{ -1,  26,  85, 18 } /* 15 */
	},
	{	/* 104857 < Ratio <= 131072 (~8:4) */
		{ 26,  76,  26,  0 },/* 0 */
		{ 22,  76,  30,  0 },/* 1 */
		{ 19,  75,  34,  0 },/* 2 */
		{ 16,  73,  38,  1 },/* 3 */
		{ 13,  71,  43,  1 },/* 4 */
		{ 10,  69,  47,  2 },/* 5 */
		{  8,  66,  51,  3 },/* 6 */
		{  6,  63,  55,  4 },/* 7 */
		{  5,  59,  59,  5 },/* 8 */
		{  4,  55,  63,  6 },/* 9 */
		{  3,  51,  66,  8 },/* 10 */
		{  2,  47,  69, 10 },/* 11 */
		{  1,  43,  71, 13 },/* 12 */
		{  1,  38,  73, 16 },/* 13 */
		{  0,  34,  75, 19 },/* 14 */
		{  0,  30,  76, 22 } /* 15 */
	},
	{	/* 131072 < Ratio <= 174762 (~8:3) */
		{ 29,  70,  29,  0 },/* 0 */
		{ 26,  68,  32,  2 },/* 1 */
		{ 23,  67,  36,  2 },/* 2 */
		{ 20,  66,  39,  3 },/* 3 */
		{ 17,  65,  43,  3 },/* 4 */
		{ 15,  63,  46,  4 },/* 5 */
		{ 12,  61,  50,  5 },/* 6 */
		{ 10,  58,  53,  7 },/* 7 */
		{  8,  56,  56,  8 },/* 8 */
		{  7,  53,  58, 10 },/* 9 */
		{  5,  50,  61, 12 },/* 10 */
		{  4,  46,  63, 15 },/* 11 */
		{  3,  43,  65, 17 },/* 12 */
		{  3,  39,  66, 20 },/* 13 */
		{  2,  36,  67, 23 },/* 14 */
		{  2,  32,  68, 26 } /* 15 */
	},
	{	/* 174762 < Ratio <= 262144 (~8:2) */
		{ 32,  64,  32,  0 },/* 0 */
		{ 28,  63,  34,  3 },/* 1 */
		{ 25,  62,  37,  4 },/* 2 */
		{ 22,  62,  40,  4 },/* 3 */
		{ 19,  61,  43,  5 },/* 4 */
		{ 17,  59,  46,  6 },/* 5 */
		{ 15,  58,  48,  7 },/* 6 */
		{ 13,  55,  51,  9 },/* 7 */
		{ 11,  53,  53, 11 },/* 8 */
		{  9,  51,  55, 13 },/* 9 */
		{  7,  48,  58, 15 },/* 10 */
		{  6,  46,  59, 17 },/* 11 */
		{  5,  43,  61, 19 },/* 12 */
		{  4,  40,  62, 22 },/* 13 */
		{  4,  37,  62, 25 },/* 14 */
		{  3,  34,  63, 28 } /* 15 */
	}
};
