#include "Regex.h"

using namespace stringf;
using namespace std;

////// RegexException

RegexException::RegexException(const regex_t& re, int code,
								const string& context) throw ()
							: SystemException(code, context)
{
	int size = 64;
	char* msg = new char[size];
	int nsize = regerror(code, &re, msg, size);
	if (nsize < size)
	{
		delete msg;
		msg = new char[nsize];
		regerror(code, &re, msg, nsize);
	}
	_message = msg;
	delete msg;
}


////// Regex

Regex::Regex(const char* expr, int flags)
	throw(RegexException)
{
	int res = regcomp(&re, expr, flags);
	if (res)
		throw RegexException(re, res, fmt("Compiling regexp \"%s\"", expr));
}

bool Regex::match(const char* str, int flags)
	throw(RegexException)
{
	int res = regexec(&re, str, 0, 0, flags);
	switch (res)
	{
		case 0:	return true;
		case REG_NOMATCH: return false;
		default: throw RegexException(re, res, fmt("Matching string \"%s\"", str));
	}
}

bool Regex::match(const char* str, int nmatch, regmatch_t pmatch[], int flags)
	throw(RegexException)
{
	int res = regexec(&re, str, nmatch, pmatch, flags);
	switch (res)
	{
		case 0:	return true;
		case REG_NOMATCH: return false;
		default: throw RegexException(re, res, fmt("Matching string \"%s\"", str));
	}
}

// vim:set ts=4 sw=4:
