/*
Jaxe - Editeur XML en Java

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package jaxe;

/**
 * Fonction applicable au document XML, et lanable  partir des menus.
 * Doit correspondre  un lment FONCTION dans le fichier de configuration de Jaxe.
 *
 * Le constructeur peut avoir en paramtre "Element fctdef" pour avoir l'lment correspondant
 * du fichier de config. Ceci permet ensuite d'appeler la mthode de Config valeurParametreFonction()
 * pour obtenir les valeurs des paramtres.
 */
public interface Fonction {
    
    /**
     * Applique la fonction au document. La position de la slection du texte est donne par start et end.
     * start == end s'il n'y a pas de slection (dans ce cas c'est juste la position du curseur).
     */
    public boolean appliquer(JaxeDocument doc, int start, int end);
    
}
