package jalview.bin.argparser;

import jalview.bin.Cache;
import jalview.gui.StructureChooser;

public class StructureLine
{
  private String viewerid = null;

  private boolean superpose = Cache
          .getDefault(StructureChooser.AUTOSUPERIMPOSE, true);

  private String source;

  private SubVals subvals;

  private String seqid;

  private String line;

  public StructureLine(String line)
  {
    this.line = line;
    String[] parts = line.split("\\s+", 2);
    String seqid0 = parts[0];
    subvals = new SubVals(parts[1]);
    source = subvals.getContent();
    seqid = seqid0.length() > 0 ? seqid0 : subvals.get(Arg.SEQID.getName());
    if (subvals.get(Arg.SUPERPOSE.getName()) != null)
    {
      superpose = true;
    }
    else if (subvals.get(Arg.SUPERPOSE.getNegatedName()) != null)
    {
      superpose = false;
    }
  }

  public String getViewerid()
  {
    return viewerid;
  }

  public void setViewerid(String viewerid)
  {
    this.viewerid = viewerid;
  }

  public boolean isSuperpose()
  {
    return superpose;
  }

  public String getSource()
  {
    return source;
  }

  public SubVals getSubvals()
  {
    return subvals;
  }

  public String getSeqid()
  {
    return seqid;
  }

  public String toString()
  {
    return line;
  }
}