dnl motif.m4
dnl
dnl Copyright (C) 2002 Tim Stadelmann
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software Foundation,
dnl Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

dnl The following macros are adapted from LessTif.

AC_DEFUN(TS_PATH_MOTIF,
[AC_REQUIRE_CPP()dnl

AC_ARG_WITH(motif-includes, [  --with-motif-includes=DIR     Motif include files are in DIR])
if test -z "$with_motif_includes"; then
  motif_includes=NONE
else
  motif_includes=$with_motif_includes
fi
AC_ARG_WITH(motif-libraries, [  --with-motif-libraries=DIR    Motif library files are in DIR])
if test -z "$with_motif_libraries"; then
  motif_libraries=NONE
else
  motif_libraries=$with_motif_libraries
fi

AC_MSG_CHECKING(for Motif)
AC_ARG_WITH(motif, [  --with-motif            enable Motif tests])
if test "x$with_motif" = xno; then
  no_motif=yes
else
  if test "x$motif_includes" != xNONE && test "x$motif_libraries" != xNONE; then
    no_motif=
  else
AC_CACHE_VAL(ac_cv_path_motif,
[# One or both of these vars are not set, and there is no cached value.
no_motif=yes
TS_PATH_MOTIF_DIRECT

if test "$no_motif" = yes; then
  ac_cv_path_motif="no_motif=yes"
else
  ac_cv_path_motif="no_motif= ac_motif_includes=$ac_motif_includes ac_motif_libraries=$ac_motif_libraries"
fi])dnl
  fi
  eval "$ac_cv_path_motif"
fi # with_motif != no

if test "$no_motif" = yes; then
  AC_MSG_RESULT(no)
else
  test "x$motif_includes" = xNONE && motif_includes=$ac_motif_includes
  test "x$motif_libraries" = xNONE && motif_libraries=$ac_motif_libraries
  ac_cv_path_motif="no_motif= ac_motif_includes=$motif_includes ac_motif_libraries=$motif_libraries"
  AC_MSG_RESULT([libraries $motif_libraries, headers $motif_includes])
fi
])

dnl Internal subroutine of TS_PATH_MOTIF.
AC_DEFUN(TS_PATH_MOTIF_DIRECT,
[test -z "$motif_direct_test_library" && motif_direct_test_library=Xm
test -z "$motif_direct_test_function" && motif_direct_test_function=XmCreatePushButton
test -z "$motif_direct_test_include" && motif_direct_test_include=Xm/Xm.h
  for ac_dir in               \
    /usr/include/Motif1.2     \
    /usr/Motif1.2/include     \
                              \
    /usr/motif/include        \
                              \
    /usr/X11R6/include        \
    /usr/X11R5/include        \
                              \
    /usr/include/X11R6        \
    /usr/include/X11R5        \
                              \
    /usr/local/X11R6/include  \
    /usr/local/X11R5/include  \
                              \
    /usr/local/include/X11R6  \
    /usr/local/include/X11R5  \
                              \
    /usr/X11/include          \
    /usr/include/X11          \
    /usr/local/X11/include    \
    /usr/local/include/X11    \
                              \
    /usr/X386/include         \
    /usr/x386/include         \
    /usr/XFree86/include/X11  \
                              \
    /usr/dt/include           \
    /usr/openwin/include      \
    /opt/openwin/include      \
                              \
    /usr/include              \
    /usr/local/include        \
    /usr/unsupported/include  \
    /usr/athena/include       \
    /usr/local/x11r5/include  \
    /usr/lpp/Xamples/include  \
    /usr/X11R6/LessTif/Motif2.0/include \
    /usr/local/X11R6/LessTif/Motif2.0/include \
    /usr/X11R6/LessTif/Motif1.2/include \
    /usr/local/X11R6/LessTif/Motif1.2/include \
    ; \
  do
    if test -r "$ac_dir/$motif_direct_test_include"; then
      no_motif= ac_motif_includes=$ac_dir
      break
    fi
  done

# Check for the libraries.
# See if we find them without any special options.
# Don't add to $LIBS permanently.
ts_save_LIBS="$LIBS"
LIBS="-l$motif_direct_test_library $LIBS"
# First see if replacing the include by lib works.
for ac_dir in `echo "$ac_motif_includes" | sed s/include/lib/` \
    /usr/lib/Motif1.2     \
    /usr/Motif1.2/lib     \
                          \
    /usr/motif/lib        \
                          \
    /usr/X11R6/lib        \
    /usr/X11R5/lib        \
                          \
    /usr/lib/X11R6        \
    /usr/lib/X11R5        \
                          \
    /usr/local/X11R6/lib  \
    /usr/local/X11R5/lib  \
                          \
    /usr/local/lib/X11R6  \
    /usr/local/lib/X11R5  \
                          \
    /usr/X11/lib          \
    /usr/lib/X11          \
    /usr/local/X11/lib    \
                          \
    /usr/X386/lib         \
    /usr/x386/lib         \
    /usr/XFree86/lib/X11  \
                          \
    /usr/dt/lib           \
    /usr/openwin/lib      \
    /opt/openwin/lib      \
                          \
    /usr/lib              \
    /usr/local/lib        \
    /usr/unsupported/lib  \
    /usr/athena/lib       \
    /usr/local/x11r5/lib  \
    /usr/lpp/Xamples/lib  \
    /usr/X11R6/LessTif/Motif2.0/lib \
    /usr/local/X11R6/LessTif/Motif2.0/lib \
    /usr/X11R6/LessTif/Motif1.2/lib \
    /usr/local/X11R6/LessTif/Motif1.2/lib \
    ; \
do
  for ac_extension in a so sl; do
    if test -r $ac_dir/lib${motif_direct_test_library}.$ac_extension; then
      no_motif= ac_motif_libraries=$ac_dir
      break 2
    fi
  done
done
LIBS=$ts_save_LIBS])

dnl Find additional libraries needed for Motif and define convenient
dnl output variables.  
AC_DEFUN(TS_PATH_MOTIF_EXTRA, [AC_REQUIRE([TS_PATH_MOTIF])dnl
if test "$no_motif" = yes; then
  MOTIF_LIBS= MOTIF_EXTRA_LIBS=
else
  # It would also be nice to do this for all -L options, not just this one.
  if test -n "$motif_libraries"; then
    MOTIF_LIBS="$MOTIF_LIBS -L$motif_libraries"
  fi

  # Check whether Motif requires -lXp or -lXext.
  ts_save_LDFLAGS="$LDFLAGS"
  test -n "$x_libraries" && LDFLAGS="$LDFLAGS -L$x_libraries"
  test -n "$motif_libraries" && LDFLAGS="$LDFLAGS -L$motif_libraries"
  ts_save_LIBS="$LIBS"

  # Check for -lXext.
  LIBS="$LIBS -lXp -lXm"
  AC_CACHE_CHECK(whether Motif needs -lXext, ts_cv_lib_motif_needs_xext,
  [AC_TRY_LINK( , , ts_cv_lib_motif_needs_xext=no,
  [ts_cv_lib_motif_needs_xext=yes
  MOTIF_EXTRA_LIBS="$MOTIF_EXTRA_LIBS -lXext"])])
  LIBS="$ts_save_LIBS"

  # Check for -lXp.
  LIBS="$LIBS -lXext -lXm"
  AC_CACHE_CHECK(whether Motif needs -lXp, ts_cv_lib_motif_needs_xp,
  [AC_TRY_LINK( , , ts_cv_lib_motif_needs_xp=no,
  [ts_cv_lib_motif_needs_xp=yes
  MOTIF_EXTRA_LIBS="$MOTIF_EXTRA_LIBS -lXp"])])
  LIBS="$ts_save_LIBS"

  LDFLAGS="$ts_save_LDFLAGS"

fi
AC_SUBST(MOTIF_LIBS)dnl
AC_SUBST(MOTIF_EXTRA_LIBS)dnl
])
