/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains interfaces for {@link com.gs.collections.api.partition.bag.sorted.PartitionSortedBag}.
 * <p>
 *     A PartitionSortedBag is the result of splitting a sorted bag into two sorted bags based on a Predicate.
 * </p>
 * <p>
 *      This package contains the following interfaces:
 * <ul>
 *     <li>
 *         {@link com.gs.collections.api.partition.bag.sorted.PartitionSortedBag} - a Read-only PartitionSortedSet API.
 *     </li>
 *     <li>
 *         {@link com.gs.collections.api.partition.bag.sorted.PartitionMutableSortedBag} - a modifiable PartitionSortedSet.
 *     </li>
 * </ul>
 * </p>
 */
package com.gs.collections.api.partition.bag.sorted;
