import sys

import glob

from ase.test.tasks.analyse import AnalyseSCFTask as Task

rundefs = {
    #
    'm103poisson': 'Mixer(0.10, 3)',
    #
    'm103mp': 'Mixer(0.10, 3)',
    'd203mp': 'MixerDif(0.20, 3)',
    'dzpd203mp': 'MixerDif(0.20, 3)',
    'cgm203mp': 'MixerDif(0.20, 3)',
    'cgdzpm203mp': 'MixerDif(0.20, 3)',
    'cgdzpd203mp': 'MixerDif(0.20, 3)',
    #
    'm251': 'Mixer(0.25, 1)',
    'm252': 'Mixer(0.25, 2)',
    'm253': 'Mixer(0.25, 3)',
    'm254': 'Mixer(0.25, 4)',
    'm255': 'Mixer(0.25, 5)',
    'm256': 'Mixer(0.25, 6)',
    'm257': 'Mixer(0.25, 7)',
    #
    'm201': 'Mixer(0.20, 1)',
    'm202': 'Mixer(0.20, 2)',
    'm203': 'Mixer(0.20, 3)',
    'm204': 'Mixer(0.20, 4)',
    'm205': 'Mixer(0.20, 5)',
    'm206': 'Mixer(0.20, 6)',
    'm207': 'Mixer(0.20, 7)',
    #
    'm151': 'Mixer(0.15, 1)',
    'm152': 'Mixer(0.15, 2)',
    'm153': 'Mixer(0.15, 3)',
    'm154': 'Mixer(0.15, 4)',
    'm155': 'Mixer(0.15, 5)',
    'm156': 'Mixer(0.15, 6)',
    'm157': 'Mixer(0.15, 7)',
    #
    'inititer00m': 'Mixer()',
    'inititer01m': 'Mixer()',
    'inititer02m': 'Mixer()',
    'inititer03m': 'Mixer()',
    'inititer04m': 'Mixer()',
    'inititer05m': 'Mixer()',
    'inititer06m': 'Mixer()',
    'inititer07m': 'Mixer()',
    'inititer08m': 'Mixer()',
    'inititer09m': 'Mixer()',
    'inititer10m': 'Mixer()',
    'inititer15m': 'Mixer()',
    'inititer20m': 'Mixer()',
    #
    'inititer05m051': 'Mixer(0.05, 1)',
    'inititer05m052': 'Mixer(0.05, 2)',
    'inititer05m101': 'Mixer(0.10, 1)',
    'inititer05m102': 'Mixer(0.10, 2)',
    'inititer10m051': 'Mixer(0.05, 1)',
    'inititer10m052': 'Mixer(0.05, 2)',
    'inititer10m101': 'Mixer(0.10, 1)',
    'inititer10m102': 'Mixer(0.10, 2)',
    'inititer20m051': 'Mixer(0.05, 1)',
    'inititer20m052': 'Mixer(0.05, 2)',
    'inititer20m101': 'Mixer(0.10, 1)',
    'inititer20m102': 'Mixer(0.10, 2)',
    #
    'inititer00d': 'MixerDif()',
    'inititer01d': 'MixerDif()',
    'inititer02d': 'MixerDif()',
    'inititer03d': 'MixerDif()',
    'inititer04d': 'MixerDif()',
    'inititer05d': 'MixerDif()',
    'inititer06d': 'MixerDif()',
    'inititer07d': 'MixerDif()',
    'inititer08d': 'MixerDif()',
    'inititer09d': 'MixerDif()',
    'inititer10d': 'MixerDif()',
    'inititer15d': 'MixerDif()',
    'inititer20d': 'MixerDif()',
    #
    'inititer05d051': 'MixerDif(0.05, 1)',
    'inititer05d052': 'MixerDif(0.05, 2)',
    'inititer05d101': 'MixerDif(0.10, 1)',
    'inititer05d102': 'MixerDif(0.10, 2)',
    'inititer10d051': 'MixerDif(0.05, 1)',
    'inititer10d052': 'MixerDif(0.05, 2)',
    'inititer10d101': 'MixerDif(0.10, 1)',
    'inititer10d102': 'MixerDif(0.10, 2)',
    'inititer20d051': 'MixerDif(0.05, 1)',
    'inititer20d052': 'MixerDif(0.05, 2)',
    'inititer20d101': 'MixerDif(0.10, 1)',
    'inititer20d102': 'MixerDif(0.10, 2)',
    #
    'bands00m': 'Mixer()',
    'bands01m': 'Mixer()',
    'bands02m': 'Mixer()',
    'bands03m': 'Mixer()',
    'bands04m': 'Mixer()',
    'bands05m': 'Mixer()',
    'bands06m': 'Mixer()',
    'bands07m': 'Mixer()',
    'bands08m': 'Mixer()',
    'bands09m': 'Mixer()',
    'bands10m': 'Mixer()',
    'bands15m': 'Mixer()',
    'bands20m': 'Mixer()',
    #
    'bands01cgm': 'Mixer()',
    'bands02cgm': 'Mixer()',
    'bands03cgm': 'Mixer()',
    'bands04cgm': 'Mixer()',
    'bands05cgm': 'Mixer()',
    'bands06cgm': 'Mixer()',
    'bands07cgm': 'Mixer()',
    'bands08cgm': 'Mixer()',
    'bands09cgm': 'Mixer()',
    'bands10cgm': 'Mixer()',
    'bands15cgm': 'Mixer()',
    'bands20cgm': 'Mixer()',
    #
    'mw1': 'Mixer(weight=1)',
    'mw25': 'Mixer(weight=25)',
    'mw50': 'Mixer(weight=50)',
    'mw100': 'Mixer(weight=100)',
    'mw200': 'Mixer(weight=200)',
    #
    'm101': 'Mixer(0.10, 1)',
    'm102': 'Mixer(0.10, 2)',
    'm103': 'Mixer(0.10, 3)', # default
    'm104': 'Mixer(0.10, 4)',
    'm105': 'Mixer(0.10, 5)',
    'm106': 'Mixer(0.10, 6)',
    'm107': 'Mixer(0.10, 7)',
    #
    'm051': 'Mixer(0.05, 1)',
    'm052': 'Mixer(0.05, 2)',
    'm053': 'Mixer(0.05, 3)',
    'm054': 'Mixer(0.05, 4)',
    'm055': 'Mixer(0.05, 5)',
    'm056': 'Mixer(0.05, 6)',
    'm057': 'Mixer(0.05, 7)',
    #
    'm302': 'Mixer(0.30, 2)',
    'm303': 'Mixer(0.30, 3)',
    'm304': 'Mixer(0.30, 4)',
    'm305': 'Mixer(0.30, 5)',
    'm306': 'Mixer(0.30, 6)',
    'm307': 'Mixer(0.30, 7)',
    'm308': 'Mixer(0.30, 8)',
    'm352': 'Mixer(0.35, 2)',
    'm353': 'Mixer(0.35, 3)',
    'm354': 'Mixer(0.35, 4)',
    'm355': 'Mixer(0.35, 5)',
    'm356': 'Mixer(0.35, 6)',
    'm357': 'Mixer(0.35, 7)',
    'm358': 'Mixer(0.35, 8)',
    'm402': 'Mixer(0.40, 2)',
    'm403': 'Mixer(0.40, 3)',
    'm404': 'Mixer(0.40, 4)',
    'm405': 'Mixer(0.40, 5)',
    'm406': 'Mixer(0.40, 6)',
    'm407': 'Mixer(0.40, 7)',
    'm408': 'Mixer(0.40, 8)',
    #
    's102': 'MixerSum(0.10, 2)',
    's103': 'MixerSum(0.10, 3)',
    's104': 'MixerSum(0.10, 4)',
    's105': 'MixerSum(0.10, 5)',
    's106': 'MixerSum(0.10, 6)',
    's107': 'MixerSum(0.10, 7)',
    's203': 'MixerSum(0.20, 3)',
    's253': 'MixerSum(0.25, 3)',
    #
    'dzps102': 'MixerSum(0.10, 2)',
    'dzps103': 'MixerSum(0.10, 3)',
    'dzps104': 'MixerSum(0.10, 4)',
    'dzps105': 'MixerSum(0.10, 5)',
    'dzps106': 'MixerSum(0.10, 6)',
    'dzps107': 'MixerSum(0.10, 7)',
    'dzps203': 'MixerSum(0.20, 3)',
    'dzps253': 'MixerSum(0.25, 3)',
    #
    'cgdzps102': 'MixerSum(0.10, 2)',
    'cgdzps103': 'MixerSum(0.10, 3)',
    'cgdzps104': 'MixerSum(0.10, 4)',
    'cgdzps105': 'MixerSum(0.10, 5)',
    'cgdzps106': 'MixerSum(0.10, 6)',
    'cgdzps107': 'MixerSum(0.10, 7)',
    'cgdzps203': 'MixerSum(0.20, 3)',
    'cgdzps253': 'MixerSum(0.25, 3)',
    #
    'b103': 'BroydenMixer(0.10, 3)',
    'b104': 'BroydenMixer(0.10, 4)',
    'b105': 'BroydenMixer(0.10, 5)',
    'b106': 'BroydenMixer(0.10, 6)',
    'b107': 'BroydenMixer(0.10, 7)',
    'b203': 'BroydenMixer(0.20, 3)',
    'b253': 'BroydenMixer(0.25, 3)',
    'b206': 'BroydenMixer(0.20, 6)',
    'b256': 'BroydenMixer(0.25, 6)',
    #
    'cgb103': 'BroydenMixer(0.10, 3)',
    'cgb104': 'BroydenMixer(0.10, 4)',
    'cgb105': 'BroydenMixer(0.10, 5)',
    'cgb106': 'BroydenMixer(0.10, 6)',
    'cgb107': 'BroydenMixer(0.10, 7)',
    #
    'cgdzpb103': 'BroydenMixer(0.10, 3)',
    'cgdzpb104': 'BroydenMixer(0.10, 4)',
    'cgdzpb105': 'BroydenMixer(0.10, 5)',
    'cgdzpb106': 'BroydenMixer(0.10, 6)',
    'cgdzpb107': 'BroydenMixer(0.10, 7)',
    'cgdzpb203': 'BroydenMixer(0.20, 3)',
    'cgdzpb206': 'BroydenMixer(0.20, 6)',
    #
    'dw1': 'MixerDif(weight=1)',
    'dw25': 'MixerDif(weight=25)',
    'dw50': 'MixerDif(weight=50)',
    'dw100': 'MixerDif(weight=100)',
    'd101': 'MixerDif(0.10, 1)',
    'd102': 'MixerDif(0.10, 2)',
    'd103': 'MixerDif(0.10, 3)',
    'd104': 'MixerDif(0.10, 4)',
    'd105': 'MixerDif(0.10, 5)',
    'd106': 'MixerDif(0.10, 6)',
    'd107': 'MixerDif(0.10, 7)',
    'd108': 'MixerDif(0.10, 8)',
    'd152': 'MixerDif(0.15, 2)',
    'd153': 'MixerDif(0.15, 3)',
    'd154': 'MixerDif(0.15, 4)',
    'd155': 'MixerDif(0.15, 5)',
    'd156': 'MixerDif(0.15, 6)',
    'd157': 'MixerDif(0.15, 7)',
    'd158': 'MixerDif(0.15, 8)',
    'd202': 'MixerDif(0.20, 2)',
    'd203': 'MixerDif(0.20, 3)',
    'd204': 'MixerDif(0.20, 4)',
    'd205': 'MixerDif(0.20, 5)',
    'd206': 'MixerDif(0.20, 6)',
    'd207': 'MixerDif(0.20, 7)',
    'd208': 'MixerDif(0.20, 8)',
    'd252': 'MixerDif(0.25, 2)',
    'd253': 'MixerDif(0.25, 3)',
    'd254': 'MixerDif(0.25, 4)',
    'd255': 'MixerDif(0.25, 5)',
    'd256': 'MixerDif(0.25, 6)',
    'd257': 'MixerDif(0.25, 7)',
    'd258': 'MixerDif(0.25, 8)',
    'd302': 'MixerDif(0.30, 2)',
    'd303': 'MixerDif(0.30, 3)',
    'd304': 'MixerDif(0.30, 4)',
    'd305': 'MixerDif(0.30, 5)',
    'd306': 'MixerDif(0.30, 6)',
    'd307': 'MixerDif(0.30, 7)',
    'd308': 'MixerDif(0.30, 8)',
    'd352': 'MixerDif(0.35, 2)',
    'd353': 'MixerDif(0.35, 3)',
    'd354': 'MixerDif(0.35, 4)',
    'd355': 'MixerDif(0.35, 5)',
    'd356': 'MixerDif(0.35, 6)',
    'd357': 'MixerDif(0.35, 7)',
    'd358': 'MixerDif(0.35, 8)',
    'd402': 'MixerDif(0.40, 2)',
    'd403': 'MixerDif(0.40, 3)',
    'd404': 'MixerDif(0.40, 4)',
    'd405': 'MixerDif(0.40, 5)',
    'd406': 'MixerDif(0.40, 6)',
    'd407': 'MixerDif(0.40, 7)',
    'd408': 'MixerDif(0.40, 8)',
    #
    'dzpdw1': 'MixerDif(weight=1)',
    'dzpdw25': 'MixerDif(weight=25)',
    'dzpdw50': 'MixerDif(weight=50)',
    'dzpdw100': 'MixerDif(weight=100)',
    'dzpd101': 'MixerDif(0.10, 1)',
    'dzpd102': 'MixerDif(0.10, 2)',
    'dzpd103': 'MixerDif(0.10, 3)',
    'dzpd104': 'MixerDif(0.10, 4)',
    'dzpd105': 'MixerDif(0.10, 5)',
    'dzpd106': 'MixerDif(0.10, 6)',
    'dzpd107': 'MixerDif(0.10, 7)',
    'dzpd152': 'MixerDif(0.15, 2)',
    'dzpd153': 'MixerDif(0.15, 3)',
    'dzpd154': 'MixerDif(0.15, 4)',
    'dzpd155': 'MixerDif(0.15, 5)',
    'dzpd156': 'MixerDif(0.15, 6)',
    'dzpd157': 'MixerDif(0.15, 7)',
    'dzpd202': 'MixerDif(0.20, 2)',
    'dzpd203': 'MixerDif(0.20, 3)',
    'dzpd204': 'MixerDif(0.20, 4)',
    'dzpd205': 'MixerDif(0.20, 5)',
    'dzpd206': 'MixerDif(0.20, 6)',
    'dzpd207': 'MixerDif(0.20, 7)',
    'dzpd252': 'MixerDif(0.25, 2)',
    'dzpd253': 'MixerDif(0.25, 3)',
    'dzpd254': 'MixerDif(0.25, 4)',
    'dzpd255': 'MixerDif(0.25, 5)',
    'dzpd256': 'MixerDif(0.25, 6)',
    'dzpd257': 'MixerDif(0.25, 7)',
    #
    'szdzpm': 'Mixer()',
    'szpdzpm': 'Mixer()',
    #
    'dzpmw1': 'Mixer(weight=1)',
    'dzpmw25': 'Mixer(weight=25)',
    'dzpmw50': 'Mixer(weight=50)',
    'dzpmw100': 'Mixer(weight=100)',
    'dzpm102': 'Mixer(0.10, 2)',
    'dzpm103': 'Mixer(0.10, 3)',
    'dzpm104': 'Mixer(0.10, 4)',
    'dzpm105': 'Mixer(0.10, 5)',
    'dzpm106': 'Mixer(0.10, 6)',
    'dzpm107': 'Mixer(0.10, 7)',
    'dzpm152': 'Mixer(0.15, 2)',
    'dzpm153': 'Mixer(0.15, 3)',
    'dzpm154': 'Mixer(0.15, 4)',
    'dzpm155': 'Mixer(0.15, 5)',
    'dzpm202': 'Mixer(0.20, 2)',
    'dzpm203': 'Mixer(0.20, 3)',
    'dzpm204': 'Mixer(0.20, 4)',
    'dzpm205': 'Mixer(0.20, 5)',
    'dzpm252': 'Mixer(0.25, 2)',
    'dzpm253': 'Mixer(0.25, 3)',
    'dzpm254': 'Mixer(0.25, 4)',
    'dzpm255': 'Mixer(0.25, 5)',
    #
    'dzpbands00m': 'Mixer()',
    'dzpbands01m': 'Mixer()',
    'dzpbands02m': 'Mixer()',
    'dzpbands03m': 'Mixer()',
    'dzpbands04m': 'Mixer()',
    'dzpbands05m': 'Mixer()',
    'dzpbands06m': 'Mixer()',
    'dzpbands07m': 'Mixer()',
    'dzpbands08m': 'Mixer()',
    'dzpbands09m': 'Mixer()',
    'dzpbands10m': 'Mixer()',
    'dzpbands15m': 'Mixer()',
    'dzpbands20m': 'Mixer()',
    #
    'dzpbands00d': 'MixerDiff()',
    'dzpbands01d': 'MixerDiff()',
    'dzpbands02d': 'MixerDiff()',
    'dzpbands03d': 'MixerDiff()',
    'dzpbands04d': 'MixerDiff()',
    'dzpbands05d': 'MixerDiff()',
    'dzpbands06d': 'MixerDiff()',
    'dzpbands07d': 'MixerDiff()',
    'dzpbands08d': 'MixerDiff()',
    'dzpbands09d': 'MixerDiff()',
    'dzpbands10d': 'MixerDiff()',
    'dzpbands15d': 'MixerDiff()',
    'dzpbands20d': 'MixerDiff()',
    #
    'fm101': 'FFTMixer(0.10, 1)',
    'fm102': 'FFTMixer(0.10, 2)',
    'fm103': 'FFTMixer(0.10, 3)',
    'fm104': 'FFTMixer(0.10, 4)',
    'fm105': 'FFTMixer(0.10, 5)',
    'fm106': 'FFTMixer(0.10, 6)',
    'fm107': 'FFTMixer(0.10, 7)',
    'fm108': 'FFTMixer(0.10, 8)',
    'fm152': 'FFTMixer(0.15, 2)',
    'fm153': 'FFTMixer(0.15, 3)',
    'fm154': 'FFTMixer(0.15, 4)',
    'fm155': 'FFTMixer(0.15, 5)',
    'fm156': 'FFTMixer(0.15, 6)',
    'fm157': 'FFTMixer(0.15, 7)',
    'fm158': 'FFTMixer(0.15, 8)',
    'fm202': 'FFTMixer(0.20, 2)',
    'fm203': 'FFTMixer(0.20, 3)',
    'fm204': 'FFTMixer(0.20, 4)',
    'fm205': 'FFTMixer(0.20, 5)',
    'fm206': 'FFTMixer(0.20, 6)',
    'fm207': 'FFTMixer(0.20, 7)',
    'fm208': 'FFTMixer(0.20, 8)',
    'fm252': 'FFTMixer(0.25, 2)',
    'fm253': 'FFTMixer(0.25, 3)',
    'fm254': 'FFTMixer(0.25, 4)',
    'fm255': 'FFTMixer(0.25, 5)',
    'fm256': 'FFTMixer(0.25, 6)',
    'fm257': 'FFTMixer(0.25, 7)',
    'fm258': 'FFTMixer(0.25, 8)',
    'fm302': 'FFTMixer(0.30, 2)',
    'fm303': 'FFTMixer(0.30, 3)',
    'fm304': 'FFTMixer(0.30, 4)',
    'fm305': 'FFTMixer(0.30, 5)',
    'fm306': 'FFTMixer(0.30, 6)',
    'fm307': 'FFTMixer(0.30, 7)',
    'fm308': 'FFTMixer(0.30, 8)',
    'fm352': 'FFTMixer(0.35, 2)',
    'fm353': 'FFTMixer(0.35, 3)',
    'fm354': 'FFTMixer(0.35, 4)',
    'fm355': 'FFTMixer(0.35, 5)',
    'fm356': 'FFTMixer(0.35, 6)',
    'fm357': 'FFTMixer(0.35, 7)',
    'fm358': 'FFTMixer(0.35, 8)',
    #
    'fs101': 'FFTMixerSum(0.10, 1)',
    'fs102': 'FFTMixerSum(0.10, 2)',
    'fs103': 'FFTMixerSum(0.10, 3)',
    'fs104': 'FFTMixerSum(0.10, 4)',
    'fs105': 'FFTMixerSum(0.10, 5)',
    'fs106': 'FFTMixerSum(0.10, 6)',
    'fs107': 'FFTMixerSum(0.10, 7)',
    'fs108': 'FFTMixerSum(0.10, 8)',
    'fs152': 'FFTMixerSum(0.15, 2)',
    'fs153': 'FFTMixerSum(0.15, 3)',
    'fs154': 'FFTMixerSum(0.15, 4)',
    'fs155': 'FFTMixerSum(0.15, 5)',
    'fs156': 'FFTMixerSum(0.15, 6)',
    'fs157': 'FFTMixerSum(0.15, 7)',
    'fs158': 'FFTMixerSum(0.15, 8)',
    'fs202': 'FFTMixerSum(0.20, 2)',
    'fs203': 'FFTMixerSum(0.20, 3)',
    'fs204': 'FFTMixerSum(0.20, 4)',
    'fs205': 'FFTMixerSum(0.20, 5)',
    'fs206': 'FFTMixerSum(0.20, 6)',
    'fs207': 'FFTMixerSum(0.20, 7)',
    'fs208': 'FFTMixerSum(0.20, 8)',
    'fs252': 'FFTMixerSum(0.25, 2)',
    'fs253': 'FFTMixerSum(0.25, 3)',
    'fs254': 'FFTMixerSum(0.25, 4)',
    'fs255': 'FFTMixerSum(0.25, 5)',
    'fs256': 'FFTMixerSum(0.25, 6)',
    'fs257': 'FFTMixerSum(0.25, 7)',
    'fs258': 'FFTMixerSum(0.25, 8)',
    'fs302': 'FFTMixerSum(0.30, 2)',
    'fs303': 'FFTMixerSum(0.30, 3)',
    'fs304': 'FFTMixerSum(0.30, 4)',
    'fs305': 'FFTMixerSum(0.30, 5)',
    'fs306': 'FFTMixerSum(0.30, 6)',
    'fs307': 'FFTMixerSum(0.30, 7)',
    'fs308': 'FFTMixerSum(0.30, 8)',
    'fs352': 'FFTMixerSum(0.35, 2)',
    'fs353': 'FFTMixerSum(0.35, 3)',
    'fs354': 'FFTMixerSum(0.35, 4)',
    'fs355': 'FFTMixerSum(0.35, 5)',
    'fs356': 'FFTMixerSum(0.35, 6)',
    'fs357': 'FFTMixerSum(0.35, 7)',
    'fs358': 'FFTMixerSum(0.35, 8)',
    #
    'fd101': 'FFTMixerDif(0.10, 1)',
    'fd102': 'FFTMixerDif(0.10, 2)',
    'fd103': 'FFTMixerDif(0.10, 3)',
    'fd104': 'FFTMixerDif(0.10, 4)',
    'fd105': 'FFTMixerDif(0.10, 5)',
    'fd106': 'FFTMixerDif(0.10, 6)',
    'fd107': 'FFTMixerDif(0.10, 7)',
    'fd108': 'FFTMixerDif(0.10, 8)',
    'fd152': 'FFTMixerDif(0.15, 2)',
    'fd153': 'FFTMixerDif(0.15, 3)',
    'fd154': 'FFTMixerDif(0.15, 4)',
    'fd155': 'FFTMixerDif(0.15, 5)',
    'fd156': 'FFTMixerDif(0.15, 6)',
    'fd157': 'FFTMixerDif(0.15, 7)',
    'fd158': 'FFTMixerDif(0.15, 8)',
    'fd202': 'FFTMixerDif(0.20, 2)',
    'fd203': 'FFTMixerDif(0.20, 3)',
    'fd204': 'FFTMixerDif(0.20, 4)',
    'fd205': 'FFTMixerDif(0.20, 5)',
    'fd206': 'FFTMixerDif(0.20, 6)',
    'fd207': 'FFTMixerDif(0.20, 7)',
    'fd208': 'FFTMixerDif(0.20, 8)',
    'fd252': 'FFTMixerDif(0.25, 2)',
    'fd253': 'FFTMixerDif(0.25, 3)',
    'fd254': 'FFTMixerDif(0.25, 4)',
    'fd255': 'FFTMixerDif(0.25, 5)',
    'fd256': 'FFTMixerDif(0.25, 6)',
    'fd257': 'FFTMixerDif(0.25, 7)',
    'fd258': 'FFTMixerDif(0.25, 8)',
    'fd302': 'FFTMixerDif(0.30, 2)',
    'fd303': 'FFTMixerDif(0.30, 3)',
    'fd304': 'FFTMixerDif(0.30, 4)',
    'fd305': 'FFTMixerDif(0.30, 5)',
    'fd306': 'FFTMixerDif(0.30, 6)',
    'fd307': 'FFTMixerDif(0.30, 7)',
    'fd308': 'FFTMixerDif(0.30, 8)',
    'fd352': 'FFTMixerDif(0.35, 2)',
    'fd353': 'FFTMixerDif(0.35, 3)',
    'fd354': 'FFTMixerDif(0.35, 4)',
    'fd355': 'FFTMixerDif(0.35, 5)',
    'fd356': 'FFTMixerDif(0.35, 6)',
    'fd357': 'FFTMixerDif(0.35, 7)',
    'fd358': 'FFTMixerDif(0.35, 8)',
    #
    'cgm101': 'Mixer(0.10, 1)',
    'cgm102': 'Mixer(0.10, 2)',
    'cgm103': 'Mixer(0.10, 3)',
    'cgm104': 'Mixer(0.10, 4)',
    'cgm105': 'Mixer(0.10, 5)',
    'cgm106': 'Mixer(0.10, 6)',
    'cgm107': 'Mixer(0.10, 7)',
    'cgm152': 'Mixer(0.15, 2)',
    'cgm153': 'Mixer(0.15, 3)',
    'cgm154': 'Mixer(0.15, 4)',
    'cgm155': 'Mixer(0.15, 5)',
    'cgm156': 'Mixer(0.15, 6)',
    'cgm157': 'Mixer(0.15, 7)',
    'cgm201': 'Mixer(0.20, 2)',
    'cgm202': 'Mixer(0.20, 2)',
    'cgm203': 'Mixer(0.20, 3)',
    'cgm204': 'Mixer(0.20, 4)',
    'cgm205': 'Mixer(0.20, 5)',
    'cgm206': 'Mixer(0.20, 6)',
    'cgm207': 'Mixer(0.20, 7)',
    'cgm252': 'Mixer(0.25, 2)',
    'cgm253': 'Mixer(0.25, 3)',
    'cgm254': 'Mixer(0.25, 4)',
    'cgm255': 'Mixer(0.25, 5)',
    'cgm256': 'Mixer(0.25, 6)',
    'cgm257': 'Mixer(0.25, 7)',
    #
    'cgbands00m': 'Mixer()',
    'cgbands01m': 'Mixer()',
    'cgbands02m': 'Mixer()',
    'cgbands03m': 'Mixer()',
    'cgbands04m': 'Mixer()',
    'cgbands05m': 'Mixer()',
    'cgbands06m': 'Mixer()',
    'cgbands07m': 'Mixer()',
    'cgbands08m': 'Mixer()',
    'cgbands09m': 'Mixer()',
    'cgbands10m': 'Mixer()',
    'cgbands15m': 'Mixer()',
    'cgbands20m': 'Mixer()',
    #
    'cgdzpm102': 'Mixer(0.10, 2)',
    'cgdzpm103': 'Mixer(0.10, 3)',
    'cgdzpm104': 'Mixer(0.10, 4)',
    'cgdzpm105': 'Mixer(0.10, 5)',
    'cgdzpm152': 'Mixer(0.15, 2)',
    'cgdzpm153': 'Mixer(0.15, 3)',
    'cgdzpm154': 'Mixer(0.15, 4)',
    'cgdzpm155': 'Mixer(0.15, 5)',
    'cgdzpm202': 'Mixer(0.20, 2)',
    'cgdzpm203': 'Mixer(0.20, 3)',
    'cgdzpm204': 'Mixer(0.20, 4)',
    'cgdzpm205': 'Mixer(0.20, 5)',
    'cgdzpm252': 'Mixer(0.25, 2)',
    'cgdzpm253': 'Mixer(0.25, 3)',
    'cgdzpm254': 'Mixer(0.25, 4)',
    'cgdzpm255': 'Mixer(0.25, 5)',
    #
    'cgd101': 'MixerDif(0.10, 1)',
    'cgd102': 'MixerDif(0.10, 2)',
    'cgd103': 'MixerDif(0.10, 3)',
    'cgd104': 'MixerDif(0.10, 4)',
    'cgd105': 'MixerDif(0.10, 5)',
    'cgd106': 'MixerDif(0.10, 6)',
    'cgd107': 'MixerDif(0.10, 7)',
    'cgd152': 'MixerDif(0.15, 2)',
    'cgd153': 'MixerDif(0.15, 3)',
    'cgd154': 'MixerDif(0.15, 4)',
    'cgd155': 'MixerDif(0.15, 5)',
    'cgd156': 'MixerDif(0.15, 6)',
    'cgd157': 'MixerDif(0.15, 7)',
    'cgd201': 'MixerDif(0.20, 2)',
    'cgd202': 'MixerDif(0.20, 2)',
    'cgd203': 'MixerDif(0.20, 3)',
    'cgd204': 'MixerDif(0.20, 4)',
    'cgd205': 'MixerDif(0.20, 5)',
    'cgd206': 'MixerDif(0.20, 6)',
    'cgd207': 'MixerDif(0.20, 7)',
    'cgd253': 'MixerDif(0.25, 3)',
    'cgd303': 'MixerDif(0.30, 3)',
    #
    'cgs101': 'MixerSum(0.10, 1)',
    'cgs102': 'MixerSum(0.10, 2)',
    'cgs103': 'MixerSum(0.10, 3)',
    'cgs104': 'MixerSum(0.10, 4)',
    'cgs105': 'MixerSum(0.10, 5)',
    'cgs106': 'MixerSum(0.10, 6)',
    'cgs107': 'MixerSum(0.10, 7)',
    'cgs152': 'MixerSum(0.15, 2)',
    'cgs153': 'MixerSum(0.15, 3)',
    'cgs154': 'MixerSum(0.15, 4)',
    'cgs155': 'MixerSum(0.15, 5)',
    'cgs156': 'MixerSum(0.15, 6)',
    'cgs157': 'MixerSum(0.15, 7)',
    'cgs201': 'MixerSum(0.20, 2)',
    'cgs202': 'MixerSum(0.20, 2)',
    'cgs203': 'MixerSum(0.20, 3)',
    'cgs204': 'MixerSum(0.20, 4)',
    'cgs205': 'MixerSum(0.20, 5)',
    'cgs206': 'MixerSum(0.20, 6)',
    'cgs207': 'MixerSum(0.20, 7)',
    #
    'cgdzpd102': 'MixerDif(0.10, 2)',
    'cgdzpd103': 'MixerDif(0.10, 3)',
    'cgdzpd104': 'MixerDif(0.10, 4)',
    'cgdzpd105': 'MixerDif(0.10, 5)',
    'cgdzpd106': 'MixerDif(0.10, 6)',
    'cgdzpd107': 'MixerDif(0.10, 7)',
    'cgdzpd108': 'MixerDif(0.10, 8)',
    'cgdzpd152': 'MixerDif(0.15, 2)',
    'cgdzpd153': 'MixerDif(0.15, 3)',
    'cgdzpd154': 'MixerDif(0.15, 4)',
    'cgdzpd155': 'MixerDif(0.15, 5)',
    'cgdzpd156': 'MixerDif(0.15, 6)',
    'cgdzpd157': 'MixerDif(0.15, 7)',
    'cgdzpd158': 'MixerDif(0.15, 8)',
    'cgdzpd202': 'MixerDif(0.20, 2)',
    'cgdzpd203': 'MixerDif(0.20, 3)',
    'cgdzpd204': 'MixerDif(0.20, 4)',
    'cgdzpd205': 'MixerDif(0.20, 5)',
    'cgdzpd206': 'MixerDif(0.20, 6)',
    'cgdzpd207': 'MixerDif(0.20, 7)',
    'cgdzpd208': 'MixerDif(0.20, 8)',
    'cgdzpd252': 'MixerDif(0.25, 2)',
    'cgdzpd253': 'MixerDif(0.25, 3)',
    'cgdzpd254': 'MixerDif(0.25, 4)',
    'cgdzpd255': 'MixerDif(0.25, 5)',
    'cgdzpd256': 'MixerDif(0.25, 6)',
    'cgdzpd257': 'MixerDif(0.25, 7)',
    'cgdzpd258': 'MixerDif(0.25, 8)',
    'cgdzpd302': 'MixerDif(0.30, 2)',
    'cgdzpd303': 'MixerDif(0.30, 3)',
    'cgdzpd304': 'MixerDif(0.30, 4)',
    'cgdzpd305': 'MixerDif(0.30, 5)',
    'cgdzpd306': 'MixerDif(0.30, 6)',
    'cgdzpd307': 'MixerDif(0.30, 7)',
    'cgdzpd308': 'MixerDif(0.30, 8)',
    'cgdzpd352': 'MixerDif(0.35, 2)',
    'cgdzpd353': 'MixerDif(0.35, 3)',
    'cgdzpd354': 'MixerDif(0.35, 4)',
    'cgdzpd355': 'MixerDif(0.35, 5)',
    'cgdzpd356': 'MixerDif(0.35, 6)',
    'cgdzpd357': 'MixerDif(0.35, 7)',
    'cgdzpd358': 'MixerDif(0.35, 8)',
    'cgdzpd402': 'MixerDif(0.40, 2)',
    'cgdzpd403': 'MixerDif(0.40, 3)',
    'cgdzpd404': 'MixerDif(0.40, 4)',
    'cgdzpd405': 'MixerDif(0.40, 5)',
    'cgdzpd406': 'MixerDif(0.40, 6)',
    'cgdzpd407': 'MixerDif(0.40, 7)',
    'cgdzpd408': 'MixerDif(0.40, 8)',
    #
    'cgfm101': 'FFTMixer(0.10, 1)',
    'cgfm102': 'FFTMixer(0.10, 2)',
    'cgfm103': 'FFTMixer(0.10, 3)',
    'cgfm104': 'FFTMixer(0.10, 4)',
    'cgfm105': 'FFTMixer(0.10, 5)',
    'cgfm106': 'FFTMixer(0.10, 6)',
    'cgfm107': 'FFTMixer(0.10, 7)',
    'cgfm152': 'FFTMixer(0.15, 2)',
    'cgfm153': 'FFTMixer(0.15, 3)',
    'cgfm154': 'FFTMixer(0.15, 4)',
    'cgfm155': 'FFTMixer(0.15, 5)',
    'cgfm156': 'FFTMixer(0.15, 6)',
    'cgfm157': 'FFTMixer(0.15, 7)',
    'cgfm201': 'FFTMixer(0.20, 2)',
    'cgfm202': 'FFTMixer(0.20, 2)',
    'cgfm203': 'FFTMixer(0.20, 3)',
    'cgfm204': 'FFTMixer(0.20, 4)',
    'cgfm205': 'FFTMixer(0.20, 5)',
    'cgfm206': 'FFTMixer(0.20, 6)',
    'cgfm207': 'FFTMixer(0.20, 7)',
    'cgfm252': 'FFTMixer(0.25, 2)',
    'cgfm253': 'FFTMixer(0.25, 3)',
    'cgfm254': 'FFTMixer(0.25, 4)',
    'cgfm255': 'FFTMixer(0.25, 5)',
    'cgfm256': 'FFTMixer(0.25, 6)',
    'cgfm257': 'FFTMixer(0.25, 7)',
    #
    'cgfs101': 'FFTMixerSum(0.10, 1)',
    'cgfs102': 'FFTMixerSum(0.10, 2)',
    'cgfs103': 'FFTMixerSum(0.10, 3)',
    'cgfs104': 'FFTMixerSum(0.10, 4)',
    'cgfs105': 'FFTMixerSum(0.10, 5)',
    'cgfs106': 'FFTMixerSum(0.10, 6)',
    'cgfs107': 'FFTMixerSum(0.10, 7)',
    'cgfs152': 'FFTMixerSum(0.15, 2)',
    'cgfs153': 'FFTMixerSum(0.15, 3)',
    'cgfs154': 'FFTMixerSum(0.15, 4)',
    'cgfs155': 'FFTMixerSum(0.15, 5)',
    'cgfs156': 'FFTMixerSum(0.15, 6)',
    'cgfs157': 'FFTMixerSum(0.15, 7)',
    'cgfs201': 'FFTMixerSum(0.20, 2)',
    'cgfs202': 'FFTMixerSum(0.20, 2)',
    'cgfs203': 'FFTMixerSum(0.20, 3)',
    'cgfs204': 'FFTMixerSum(0.20, 4)',
    'cgfs205': 'FFTMixerSum(0.20, 5)',
    'cgfs206': 'FFTMixerSum(0.20, 6)',
    'cgfs207': 'FFTMixerSum(0.20, 7)',
    'cgfs252': 'FFTMixerSum(0.25, 2)',
    'cgfs253': 'FFTMixerSum(0.25, 3)',
    'cgfs254': 'FFTMixerSum(0.25, 4)',
    'cgfs255': 'FFTMixerSum(0.25, 5)',
    'cgfs256': 'FFTMixerSum(0.25, 6)',
    'cgfs257': 'FFTMixerSum(0.25, 7)',
    #
    'cgfd101': 'FFTMixerDif(0.10, 1)',
    'cgfd102': 'FFTMixerDif(0.10, 2)',
    'cgfd103': 'FFTMixerDif(0.10, 3)',
    'cgfd104': 'FFTMixerDif(0.10, 4)',
    'cgfd105': 'FFTMixerDif(0.10, 5)',
    'cgfd106': 'FFTMixerDif(0.10, 6)',
    'cgfd107': 'FFTMixerDif(0.10, 7)',
    'cgfd152': 'FFTMixerDif(0.15, 2)',
    'cgfd153': 'FFTMixerDif(0.15, 3)',
    'cgfd154': 'FFTMixerDif(0.15, 4)',
    'cgfd155': 'FFTMixerDif(0.15, 5)',
    'cgfd156': 'FFTMixerDif(0.15, 6)',
    'cgfd157': 'FFTMixerDif(0.15, 7)',
    'cgfd201': 'FFTMixerDif(0.20, 2)',
    'cgfd202': 'FFTMixerDif(0.20, 2)',
    'cgfd203': 'FFTMixerDif(0.20, 3)',
    'cgfd204': 'FFTMixerDif(0.20, 4)',
    'cgfd205': 'FFTMixerDif(0.20, 5)',
    'cgfd206': 'FFTMixerDif(0.20, 6)',
    'cgfd207': 'FFTMixerDif(0.20, 7)',
    'cgfd252': 'FFTMixerDif(0.25, 2)',
    'cgfd253': 'FFTMixerDif(0.25, 3)',
    'cgfd254': 'FFTMixerDif(0.25, 4)',
    'cgfd255': 'FFTMixerDif(0.25, 5)',
    'cgfd256': 'FFTMixerDif(0.25, 6)',
    'cgfd257': 'FFTMixerDif(0.25, 7)',
    #
    'davm101': 'Mixer(0.10, 1)',
    'davm102': 'Mixer(0.10, 2)',
    'davm103': 'Mixer(0.10, 3)',
    'davm104': 'Mixer(0.10, 4)',
    'davm105': 'Mixer(0.10, 5)',
    'davm106': 'Mixer(0.10, 6)',
    'davm107': 'Mixer(0.10, 7)',
    'davm152': 'Mixer(0.15, 2)',
    'davm153': 'Mixer(0.15, 3)',
    'davm154': 'Mixer(0.15, 4)',
    'davm155': 'Mixer(0.15, 5)',
    'davm156': 'Mixer(0.15, 6)',
    'davm157': 'Mixer(0.15, 7)',
    'davm201': 'Mixer(0.20, 2)',
    'davm202': 'Mixer(0.20, 2)',
    'davm203': 'Mixer(0.20, 3)',
    'davm204': 'Mixer(0.20, 4)',
    'davm205': 'Mixer(0.20, 5)',
    'davm206': 'Mixer(0.20, 6)',
    'davm207': 'Mixer(0.20, 7)',
    'davm252': 'Mixer(0.25, 2)',
    'davm253': 'Mixer(0.25, 3)',
    'davm254': 'Mixer(0.25, 4)',
    'davm255': 'Mixer(0.25, 5)',
    'davm256': 'Mixer(0.25, 6)',
    'davm257': 'Mixer(0.25, 7)',
    #
    'davs101': 'MixerSum(0.10, 1)',
    'davs102': 'MixerSum(0.10, 2)',
    'davs103': 'MixerSum(0.10, 3)',
    'davs104': 'MixerSum(0.10, 4)',
    'davs105': 'MixerSum(0.10, 5)',
    'davs106': 'MixerSum(0.10, 6)',
    'davs107': 'MixerSum(0.10, 7)',
    'davs152': 'MixerSum(0.15, 2)',
    'davs153': 'MixerSum(0.15, 3)',
    'davs154': 'MixerSum(0.15, 4)',
    'davs155': 'MixerSum(0.15, 5)',
    'davs156': 'MixerSum(0.15, 6)',
    'davs157': 'MixerSum(0.15, 7)',
    'davs201': 'MixerSum(0.20, 2)',
    'davs202': 'MixerSum(0.20, 2)',
    'davs203': 'MixerSum(0.20, 3)',
    'davs204': 'MixerSum(0.20, 4)',
    'davs205': 'MixerSum(0.20, 5)',
    'davs206': 'MixerSum(0.20, 6)',
    'davs207': 'MixerSum(0.20, 7)',
    'davs252': 'MixerSum(0.25, 2)',
    'davs253': 'MixerSum(0.25, 3)',
    'davs254': 'MixerSum(0.25, 4)',
    'davs255': 'MixerSum(0.25, 5)',
    'davs256': 'MixerSum(0.25, 6)',
    'davs257': 'MixerSum(0.25, 7)',
    #
    'davd101': 'MixerDif(0.10, 1)',
    'davd102': 'MixerDif(0.10, 2)',
    'davd103': 'MixerDif(0.10, 3)',
    'davd104': 'MixerDif(0.10, 4)',
    'davd105': 'MixerDif(0.10, 5)',
    'davd106': 'MixerDif(0.10, 6)',
    'davd107': 'MixerDif(0.10, 7)',
    'davd152': 'MixerDif(0.15, 2)',
    'davd153': 'MixerDif(0.15, 3)',
    'davd154': 'MixerDif(0.15, 4)',
    'davd155': 'MixerDif(0.15, 5)',
    'davd156': 'MixerDif(0.15, 6)',
    'davd157': 'MixerDif(0.15, 7)',
    'davd201': 'MixerDif(0.20, 2)',
    'davd202': 'MixerDif(0.20, 2)',
    'davd203': 'MixerDif(0.20, 3)',
    'davd204': 'MixerDif(0.20, 4)',
    'davd205': 'MixerDif(0.20, 5)',
    'davd206': 'MixerDif(0.20, 6)',
    'davd207': 'MixerDif(0.20, 7)',
    'davd252': 'MixerDif(0.25, 2)',
    'davd253': 'MixerDif(0.25, 3)',
    'davd254': 'MixerDif(0.25, 4)',
    'davd255': 'MixerDif(0.25, 5)',
    'davd256': 'MixerDif(0.25, 6)',
    'davd257': 'MixerDif(0.25, 7)',
    #
    'davfm101': 'FFTMixer(0.10, 1)',
    'davfm102': 'FFTMixer(0.10, 2)',
    'davfm103': 'FFTMixer(0.10, 3)',
    'davfm104': 'FFTMixer(0.10, 4)',
    'davfm105': 'FFTMixer(0.10, 5)',
    'davfm106': 'FFTMixer(0.10, 6)',
    'davfm107': 'FFTMixer(0.10, 7)',
    'davfm152': 'FFTMixer(0.15, 2)',
    'davfm153': 'FFTMixer(0.15, 3)',
    'davfm154': 'FFTMixer(0.15, 4)',
    'davfm155': 'FFTMixer(0.15, 5)',
    'davfm156': 'FFTMixer(0.15, 6)',
    'davfm157': 'FFTMixer(0.15, 7)',
    'davfm201': 'FFTMixer(0.20, 2)',
    'davfm202': 'FFTMixer(0.20, 2)',
    'davfm203': 'FFTMixer(0.20, 3)',
    'davfm204': 'FFTMixer(0.20, 4)',
    'davfm205': 'FFTMixer(0.20, 5)',
    'davfm206': 'FFTMixer(0.20, 6)',
    'davfm207': 'FFTMixer(0.20, 7)',
    'davfm252': 'FFTMixer(0.25, 2)',
    'davfm253': 'FFTMixer(0.25, 3)',
    'davfm254': 'FFTMixer(0.25, 4)',
    'davfm255': 'FFTMixer(0.25, 5)',
    'davfm256': 'FFTMixer(0.25, 6)',
    'davfm257': 'FFTMixer(0.25, 7)',
    #
    'davfs101': 'FFTMixerSum(0.10, 1)',
    'davfs102': 'FFTMixerSum(0.10, 2)',
    'davfs103': 'FFTMixerSum(0.10, 3)',
    'davfs104': 'FFTMixerSum(0.10, 4)',
    'davfs105': 'FFTMixerSum(0.10, 5)',
    'davfs106': 'FFTMixerSum(0.10, 6)',
    'davfs107': 'FFTMixerSum(0.10, 7)',
    'davfs152': 'FFTMixerSum(0.15, 2)',
    'davfs153': 'FFTMixerSum(0.15, 3)',
    'davfs154': 'FFTMixerSum(0.15, 4)',
    'davfs155': 'FFTMixerSum(0.15, 5)',
    'davfs156': 'FFTMixerSum(0.15, 6)',
    'davfs157': 'FFTMixerSum(0.15, 7)',
    'davfs201': 'FFTMixerSum(0.20, 2)',
    'davfs202': 'FFTMixerSum(0.20, 2)',
    'davfs203': 'FFTMixerSum(0.20, 3)',
    'davfs204': 'FFTMixerSum(0.20, 4)',
    'davfs205': 'FFTMixerSum(0.20, 5)',
    'davfs206': 'FFTMixerSum(0.20, 6)',
    'davfs207': 'FFTMixerSum(0.20, 7)',
    'davfs252': 'FFTMixerSum(0.25, 2)',
    'davfs253': 'FFTMixerSum(0.25, 3)',
    'davfs254': 'FFTMixerSum(0.25, 4)',
    'davfs255': 'FFTMixerSum(0.25, 5)',
    'davfs256': 'FFTMixerSum(0.25, 6)',
    'davfs257': 'FFTMixerSum(0.25, 7)',
    #
    'davfd101': 'FFTMixerDif(0.10, 1)',
    'davfd102': 'FFTMixerDif(0.10, 2)',
    'davfd103': 'FFTMixerDif(0.10, 3)',
    'davfd104': 'FFTMixerDif(0.10, 4)',
    'davfd105': 'FFTMixerDif(0.10, 5)',
    'davfd106': 'FFTMixerDif(0.10, 6)',
    'davfd107': 'FFTMixerDif(0.10, 7)',
    'davfd152': 'FFTMixerDif(0.15, 2)',
    'davfd153': 'FFTMixerDif(0.15, 3)',
    'davfd154': 'FFTMixerDif(0.15, 4)',
    'davfd155': 'FFTMixerDif(0.15, 5)',
    'davfd156': 'FFTMixerDif(0.15, 6)',
    'davfd157': 'FFTMixerDif(0.15, 7)',
    'davfd201': 'FFTMixerDif(0.20, 2)',
    'davfd202': 'FFTMixerDif(0.20, 2)',
    'davfd203': 'FFTMixerDif(0.20, 3)',
    'davfd204': 'FFTMixerDif(0.20, 4)',
    'davfd205': 'FFTMixerDif(0.20, 5)',
    'davfd206': 'FFTMixerDif(0.20, 6)',
    'davfd207': 'FFTMixerDif(0.20, 7)',
    'davfd252': 'FFTMixerDif(0.25, 2)',
    'davfd253': 'FFTMixerDif(0.25, 3)',
    'davfd254': 'FFTMixerDif(0.25, 4)',
    'davfd255': 'FFTMixerDif(0.25, 5)',
    'davfd256': 'FFTMixerDif(0.25, 6)',
    'davfd257': 'FFTMixerDif(0.25, 7)',
    #
    'jacapo': 'dacapo',
    }

if __name__ == '__main__':

    import os
    import warnings
    # silence matplotlib.use() warning
    warnings.filterwarnings('ignore', '.*This call to matplotlib\.use.*',)

    assert len(sys.argv) > 1
    if len(sys.argv) == 2:
        taskname = sys.argv[1]
        tag = None
        runs = None
    if len(sys.argv) == 3:
        taskname = sys.argv[1]
        tag = sys.argv[2]
        runs = None
    if len(sys.argv) == 4:
        taskname = sys.argv[1]
        tag = sys.argv[2]
        runs = sys.argv[3]

    if runs is None:  # use all json files as runs
        runs = []
        for f in glob.glob(taskname + '-' + tag + '*.json'):
            runs.append(os.path.splitext(f)[0].split('_')[-1])
    else:
        runs = runs.split(',')

    labels = []
    for n, r in enumerate(runs):
        l = str(n) + ': ' + rundefs[r]
        # special cases
        if r == 'm':
            l += '\ndefault'
        elif r.startswith('inititer'):
            inititer = r[len('inititer'):len('inititer') + 2]
            if inititer == '00':
                inititer = 'None'
            else:
                inititer = str(int(inititer))
            l += '\n initial cg iter:' + inititer
        elif r.startswith('cgbands'):
            nbands = r[len('cgbands'):len('cgbands') + 2]
            if nbands == '00':
                nbands = 'None'
            else:
                nbands = str(-int(nbands))
            l += '\nnbands=' + nbands
        elif r.startswith('dzpbands'):
            nbands = r[len('dzpbands'):len('dzpbands') + 2]
            if nbands == '00':
                nbands = 'None'
            else:
                nbands = str(-int(nbands))
            l += '\nnbands=' + nbands
        elif r.startswith('bands'):
            nbands = r[len('bands'):len('bands') + 2]
            if nbands == '00':
                nbands = 'None'
            else:
                nbands = str(-int(nbands))
            l += '\nnbands=' + nbands
        elif r.startswith('szdzp'):
            l += '\nsz(dzp)'
        elif r.startswith('szpdzp'):
            l += '\nszp(dzp)'
        elif r.startswith('dzp'):
            l += '\ndzp'
        elif r.startswith('cgdzp'):
            l += '\ncg dzp'
        elif r.startswith('cg'):
            l += '\ncg'
        elif r.startswith('dav'):
            l += '\ndav'
        if 'mp' in r:
            l += '\nMethfesselPaxton'
        labels.append(l)

    steps = 80
    t = Task(taskname, ','.join(runs), labels=labels, tag=tag, steps=steps,
             tunit='h')
    t.analyse()
