// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/monitoring/dashboard/v1/common.proto

package dashboard

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The Aligner describes how to bring the data points in a single
// time series into temporal alignment.
type Aggregation_Aligner int32

const (
	// No alignment. Raw data is returned. Not valid if cross-time
	// series reduction is requested. The value type of the result is
	// the same as the value type of the input.
	Aggregation_ALIGN_NONE Aggregation_Aligner = 0
	// Align and convert to delta metric type. This alignment is valid
	// for cumulative metrics and delta metrics. Aligning an existing
	// delta metric to a delta metric requires that the alignment
	// period be increased. The value type of the result is the same
	// as the value type of the input.
	//
	// One can think of this aligner as a rate but without time units; that
	// is, the output is conceptually (second_point - first_point).
	Aggregation_ALIGN_DELTA Aggregation_Aligner = 1
	// Align and convert to a rate. This alignment is valid for
	// cumulative metrics and delta metrics with numeric values. The output is a
	// gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	//
	// One can think of this aligner as conceptually providing the slope of
	// the line that passes through the value at the start and end of the
	// window. In other words, this is conceptually ((y1 - y0)/(t1 - t0)),
	// and the output unit is one that has a "/time" dimension.
	//
	// If, by rate, you are looking for percentage change, see the
	// `ALIGN_PERCENT_CHANGE` aligner option.
	Aggregation_ALIGN_RATE Aggregation_Aligner = 2
	// Align by interpolating between adjacent points around the
	// period boundary. This alignment is valid for gauge
	// metrics with numeric values. The value type of the result is the same
	// as the value type of the input.
	Aggregation_ALIGN_INTERPOLATE Aggregation_Aligner = 3
	// Align by shifting the oldest data point before the period
	// boundary to the boundary. This alignment is valid for gauge
	// metrics. The value type of the result is the same as the
	// value type of the input.
	Aggregation_ALIGN_NEXT_OLDER Aggregation_Aligner = 4
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the minimum of all data points in the
	// period. This alignment is valid for gauge and delta metrics with numeric
	// values. The value type of the result is the same as the value
	// type of the input.
	Aggregation_ALIGN_MIN Aggregation_Aligner = 10
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the maximum of all data points in the
	// period. This alignment is valid for gauge and delta metrics with numeric
	// values. The value type of the result is the same as the value
	// type of the input.
	Aggregation_ALIGN_MAX Aggregation_Aligner = 11
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the average or arithmetic mean of all
	// data points in the period. This alignment is valid for gauge and delta
	// metrics with numeric values. The value type of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_MEAN Aggregation_Aligner = 12
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the count of all data points in the
	// period. This alignment is valid for gauge and delta metrics with numeric
	// or Boolean values. The value type of the output is
	// [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_ALIGN_COUNT Aggregation_Aligner = 13
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the sum of all data points in the
	// period. This alignment is valid for gauge and delta metrics with numeric
	// and distribution values. The value type of the output is the
	// same as the value type of the input.
	Aggregation_ALIGN_SUM Aggregation_Aligner = 14
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the standard deviation of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with numeric values. The value type of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_STDDEV Aggregation_Aligner = 15
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the count of True-valued data points in the
	// period. This alignment is valid for gauge metrics with
	// Boolean values. The value type of the output is
	// [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_ALIGN_COUNT_TRUE Aggregation_Aligner = 16
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the count of False-valued data points in the
	// period. This alignment is valid for gauge metrics with
	// Boolean values. The value type of the output is
	// [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_ALIGN_COUNT_FALSE Aggregation_Aligner = 24
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the fraction of True-valued data points in the
	// period. This alignment is valid for gauge metrics with Boolean values.
	// The output value is in the range [0, 1] and has value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_FRACTION_TRUE Aggregation_Aligner = 17
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the 99th percentile of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with distribution values. The output is a gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_PERCENTILE_99 Aggregation_Aligner = 18
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the 95th percentile of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with distribution values. The output is a gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_PERCENTILE_95 Aggregation_Aligner = 19
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the 50th percentile of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with distribution values. The output is a gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_PERCENTILE_50 Aggregation_Aligner = 20
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the 5th percentile of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with distribution values. The output is a gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_PERCENTILE_05 Aggregation_Aligner = 21
	// Align and convert to a percentage change. This alignment is valid for
	// gauge and delta metrics with numeric values. This alignment conceptually
	// computes the equivalent of "((current - previous)/previous)*100"
	// where previous value is determined based on the alignmentPeriod.
	// In the event that previous is 0 the calculated value is infinity with the
	// exception that if both (current - previous) and previous are 0 the
	// calculated value is 0.
	// A 10 minute moving mean is computed at each point of the time window
	// prior to the above calculation to smooth the metric and prevent false
	// positives from very short lived spikes.
	// Only applicable for data that is >= 0. Any values < 0 are treated as
	// no data. While delta metrics are accepted by this alignment special care
	// should be taken that the values for the metric will always be positive.
	// The output is a gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_PERCENT_CHANGE Aggregation_Aligner = 23
)

var Aggregation_Aligner_name = map[int32]string{
	0:  "ALIGN_NONE",
	1:  "ALIGN_DELTA",
	2:  "ALIGN_RATE",
	3:  "ALIGN_INTERPOLATE",
	4:  "ALIGN_NEXT_OLDER",
	10: "ALIGN_MIN",
	11: "ALIGN_MAX",
	12: "ALIGN_MEAN",
	13: "ALIGN_COUNT",
	14: "ALIGN_SUM",
	15: "ALIGN_STDDEV",
	16: "ALIGN_COUNT_TRUE",
	24: "ALIGN_COUNT_FALSE",
	17: "ALIGN_FRACTION_TRUE",
	18: "ALIGN_PERCENTILE_99",
	19: "ALIGN_PERCENTILE_95",
	20: "ALIGN_PERCENTILE_50",
	21: "ALIGN_PERCENTILE_05",
	23: "ALIGN_PERCENT_CHANGE",
}

var Aggregation_Aligner_value = map[string]int32{
	"ALIGN_NONE":           0,
	"ALIGN_DELTA":          1,
	"ALIGN_RATE":           2,
	"ALIGN_INTERPOLATE":    3,
	"ALIGN_NEXT_OLDER":     4,
	"ALIGN_MIN":            10,
	"ALIGN_MAX":            11,
	"ALIGN_MEAN":           12,
	"ALIGN_COUNT":          13,
	"ALIGN_SUM":            14,
	"ALIGN_STDDEV":         15,
	"ALIGN_COUNT_TRUE":     16,
	"ALIGN_COUNT_FALSE":    24,
	"ALIGN_FRACTION_TRUE":  17,
	"ALIGN_PERCENTILE_99":  18,
	"ALIGN_PERCENTILE_95":  19,
	"ALIGN_PERCENTILE_50":  20,
	"ALIGN_PERCENTILE_05":  21,
	"ALIGN_PERCENT_CHANGE": 23,
}

func (x Aggregation_Aligner) String() string {
	return proto.EnumName(Aggregation_Aligner_name, int32(x))
}

func (Aggregation_Aligner) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{0, 0}
}

// A Reducer describes how to aggregate data points from multiple
// time series into a single time series.
type Aggregation_Reducer int32

const (
	// No cross-time series reduction. The output of the aligner is
	// returned.
	Aggregation_REDUCE_NONE Aggregation_Reducer = 0
	// Reduce by computing the mean across time series for each
	// alignment period. This reducer is valid for delta and
	// gauge metrics with numeric or distribution values. The value type of the
	// output is [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_REDUCE_MEAN Aggregation_Reducer = 1
	// Reduce by computing the minimum across time series for each
	// alignment period. This reducer is valid for delta and
	// gauge metrics with numeric values. The value type of the output
	// is the same as the value type of the input.
	Aggregation_REDUCE_MIN Aggregation_Reducer = 2
	// Reduce by computing the maximum across time series for each
	// alignment period. This reducer is valid for delta and
	// gauge metrics with numeric values. The value type of the output
	// is the same as the value type of the input.
	Aggregation_REDUCE_MAX Aggregation_Reducer = 3
	// Reduce by computing the sum across time series for each
	// alignment period. This reducer is valid for delta and
	// gauge metrics with numeric and distribution values. The value type of
	// the output is the same as the value type of the input.
	Aggregation_REDUCE_SUM Aggregation_Reducer = 4
	// Reduce by computing the standard deviation across time series
	// for each alignment period. This reducer is valid for delta
	// and gauge metrics with numeric or distribution values. The value type of
	// the output is [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_REDUCE_STDDEV Aggregation_Reducer = 5
	// Reduce by computing the count of data points across time series
	// for each alignment period. This reducer is valid for delta
	// and gauge metrics of numeric, Boolean, distribution, and string value
	// type. The value type of the output is
	// [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_REDUCE_COUNT Aggregation_Reducer = 6
	// Reduce by computing the count of True-valued data points across time
	// series for each alignment period. This reducer is valid for delta
	// and gauge metrics of Boolean value type. The value type of
	// the output is [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_REDUCE_COUNT_TRUE Aggregation_Reducer = 7
	// Reduce by computing the count of False-valued data points across time
	// series for each alignment period. This reducer is valid for delta
	// and gauge metrics of Boolean value type. The value type of
	// the output is [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_REDUCE_COUNT_FALSE Aggregation_Reducer = 15
	// Reduce by computing the fraction of True-valued data points across time
	// series for each alignment period. This reducer is valid for delta
	// and gauge metrics of Boolean value type. The output value is in the
	// range [0, 1] and has value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_REDUCE_FRACTION_TRUE Aggregation_Reducer = 8
	// Reduce by computing 99th percentile of data points across time series
	// for each alignment period. This reducer is valid for gauge and delta
	// metrics of numeric and distribution type. The value of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE]
	Aggregation_REDUCE_PERCENTILE_99 Aggregation_Reducer = 9
	// Reduce by computing 95th percentile of data points across time series
	// for each alignment period. This reducer is valid for gauge and delta
	// metrics of numeric and distribution type. The value of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE]
	Aggregation_REDUCE_PERCENTILE_95 Aggregation_Reducer = 10
	// Reduce by computing 50th percentile of data points across time series
	// for each alignment period. This reducer is valid for gauge and delta
	// metrics of numeric and distribution type. The value of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE]
	Aggregation_REDUCE_PERCENTILE_50 Aggregation_Reducer = 11
	// Reduce by computing 5th percentile of data points across time series
	// for each alignment period. This reducer is valid for gauge and delta
	// metrics of numeric and distribution type. The value of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE]
	Aggregation_REDUCE_PERCENTILE_05 Aggregation_Reducer = 12
)

var Aggregation_Reducer_name = map[int32]string{
	0:  "REDUCE_NONE",
	1:  "REDUCE_MEAN",
	2:  "REDUCE_MIN",
	3:  "REDUCE_MAX",
	4:  "REDUCE_SUM",
	5:  "REDUCE_STDDEV",
	6:  "REDUCE_COUNT",
	7:  "REDUCE_COUNT_TRUE",
	15: "REDUCE_COUNT_FALSE",
	8:  "REDUCE_FRACTION_TRUE",
	9:  "REDUCE_PERCENTILE_99",
	10: "REDUCE_PERCENTILE_95",
	11: "REDUCE_PERCENTILE_50",
	12: "REDUCE_PERCENTILE_05",
}

var Aggregation_Reducer_value = map[string]int32{
	"REDUCE_NONE":          0,
	"REDUCE_MEAN":          1,
	"REDUCE_MIN":           2,
	"REDUCE_MAX":           3,
	"REDUCE_SUM":           4,
	"REDUCE_STDDEV":        5,
	"REDUCE_COUNT":         6,
	"REDUCE_COUNT_TRUE":    7,
	"REDUCE_COUNT_FALSE":   15,
	"REDUCE_FRACTION_TRUE": 8,
	"REDUCE_PERCENTILE_99": 9,
	"REDUCE_PERCENTILE_95": 10,
	"REDUCE_PERCENTILE_50": 11,
	"REDUCE_PERCENTILE_05": 12,
}

func (x Aggregation_Reducer) String() string {
	return proto.EnumName(Aggregation_Reducer_name, int32(x))
}

func (Aggregation_Reducer) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{0, 1}
}

// The value reducers that can be applied to a PickTimeSeriesFilter.
type PickTimeSeriesFilter_Method int32

const (
	// Not allowed in well-formed requests.
	PickTimeSeriesFilter_METHOD_UNSPECIFIED PickTimeSeriesFilter_Method = 0
	// Select the mean of all values.
	PickTimeSeriesFilter_METHOD_MEAN PickTimeSeriesFilter_Method = 1
	// Select the maximum value.
	PickTimeSeriesFilter_METHOD_MAX PickTimeSeriesFilter_Method = 2
	// Select the minimum value.
	PickTimeSeriesFilter_METHOD_MIN PickTimeSeriesFilter_Method = 3
	// Compute the sum of all values.
	PickTimeSeriesFilter_METHOD_SUM PickTimeSeriesFilter_Method = 4
	// Select the most recent value.
	PickTimeSeriesFilter_METHOD_LATEST PickTimeSeriesFilter_Method = 5
)

var PickTimeSeriesFilter_Method_name = map[int32]string{
	0: "METHOD_UNSPECIFIED",
	1: "METHOD_MEAN",
	2: "METHOD_MAX",
	3: "METHOD_MIN",
	4: "METHOD_SUM",
	5: "METHOD_LATEST",
}

var PickTimeSeriesFilter_Method_value = map[string]int32{
	"METHOD_UNSPECIFIED": 0,
	"METHOD_MEAN":        1,
	"METHOD_MAX":         2,
	"METHOD_MIN":         3,
	"METHOD_SUM":         4,
	"METHOD_LATEST":      5,
}

func (x PickTimeSeriesFilter_Method) String() string {
	return proto.EnumName(PickTimeSeriesFilter_Method_name, int32(x))
}

func (PickTimeSeriesFilter_Method) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{1, 0}
}

// Describes the ranking directions.
type PickTimeSeriesFilter_Direction int32

const (
	// Not allowed in well-formed requests.
	PickTimeSeriesFilter_DIRECTION_UNSPECIFIED PickTimeSeriesFilter_Direction = 0
	// Pass the highest ranking inputs.
	PickTimeSeriesFilter_TOP PickTimeSeriesFilter_Direction = 1
	// Pass the lowest ranking inputs.
	PickTimeSeriesFilter_BOTTOM PickTimeSeriesFilter_Direction = 2
)

var PickTimeSeriesFilter_Direction_name = map[int32]string{
	0: "DIRECTION_UNSPECIFIED",
	1: "TOP",
	2: "BOTTOM",
}

var PickTimeSeriesFilter_Direction_value = map[string]int32{
	"DIRECTION_UNSPECIFIED": 0,
	"TOP":                   1,
	"BOTTOM":                2,
}

func (x PickTimeSeriesFilter_Direction) String() string {
	return proto.EnumName(PickTimeSeriesFilter_Direction_name, int32(x))
}

func (PickTimeSeriesFilter_Direction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{1, 1}
}

// The filter methods that can be applied to a stream.
type StatisticalTimeSeriesFilter_Method int32

const (
	// Not allowed in well-formed requests.
	StatisticalTimeSeriesFilter_METHOD_UNSPECIFIED StatisticalTimeSeriesFilter_Method = 0
	// Compute the outlier score of each stream.
	StatisticalTimeSeriesFilter_METHOD_CLUSTER_OUTLIER StatisticalTimeSeriesFilter_Method = 1
)

var StatisticalTimeSeriesFilter_Method_name = map[int32]string{
	0: "METHOD_UNSPECIFIED",
	1: "METHOD_CLUSTER_OUTLIER",
}

var StatisticalTimeSeriesFilter_Method_value = map[string]int32{
	"METHOD_UNSPECIFIED":     0,
	"METHOD_CLUSTER_OUTLIER": 1,
}

func (x StatisticalTimeSeriesFilter_Method) String() string {
	return proto.EnumName(StatisticalTimeSeriesFilter_Method_name, int32(x))
}

func (StatisticalTimeSeriesFilter_Method) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{2, 0}
}

// Describes how to combine multiple time series to provide different views of
// the data.  Aggregation consists of an alignment step on individual time
// series (`alignment_period` and `per_series_aligner`) followed by an optional
// reduction step of the data across the aligned time series
// (`cross_series_reducer` and `group_by_fields`).  For more details, see
// [Aggregation](/monitoring/api/learn_more#aggregation).
type Aggregation struct {
	// The alignment period for per-[time series][TimeSeries]
	// alignment. If present, `alignmentPeriod` must be at least 60
	// seconds.  After per-time series alignment, each time series will
	// contain data points only on the period boundaries. If
	// `perSeriesAligner` is not specified or equals `ALIGN_NONE`, then
	// this field is ignored. If `perSeriesAligner` is specified and
	// does not equal `ALIGN_NONE`, then this field must be defined;
	// otherwise an error is returned.
	AlignmentPeriod *duration.Duration `protobuf:"bytes,1,opt,name=alignment_period,json=alignmentPeriod,proto3" json:"alignment_period,omitempty"`
	// The approach to be used to align individual time series. Not all
	// alignment functions may be applied to all time series, depending
	// on the metric type and value type of the original time
	// series. Alignment may change the metric type or the value type of
	// the time series.
	//
	// Time series data must be aligned in order to perform cross-time
	// series reduction. If `crossSeriesReducer` is specified, then
	// `perSeriesAligner` must be specified and not equal `ALIGN_NONE`
	// and `alignmentPeriod` must be specified; otherwise, an error is
	// returned.
	PerSeriesAligner Aggregation_Aligner `protobuf:"varint,2,opt,name=per_series_aligner,json=perSeriesAligner,proto3,enum=google.monitoring.dashboard.v1.Aggregation_Aligner" json:"per_series_aligner,omitempty"`
	// The approach to be used to combine time series. Not all reducer
	// functions may be applied to all time series, depending on the
	// metric type and the value type of the original time
	// series. Reduction may change the metric type of value type of the
	// time series.
	//
	// Time series data must be aligned in order to perform cross-time
	// series reduction. If `crossSeriesReducer` is specified, then
	// `perSeriesAligner` must be specified and not equal `ALIGN_NONE`
	// and `alignmentPeriod` must be specified; otherwise, an error is
	// returned.
	CrossSeriesReducer Aggregation_Reducer `protobuf:"varint,4,opt,name=cross_series_reducer,json=crossSeriesReducer,proto3,enum=google.monitoring.dashboard.v1.Aggregation_Reducer" json:"cross_series_reducer,omitempty"`
	// The set of fields to preserve when `crossSeriesReducer` is
	// specified. The `groupByFields` determine how the time series are
	// partitioned into subsets prior to applying the aggregation
	// function. Each subset contains time series that have the same
	// value for each of the grouping fields. Each individual time
	// series is a member of exactly one subset. The
	// `crossSeriesReducer` is applied to each subset of time series.
	// It is not possible to reduce across different resource types, so
	// this field implicitly contains `resource.type`.  Fields not
	// specified in `groupByFields` are aggregated away.  If
	// `groupByFields` is not specified and all the time series have
	// the same resource type, then the time series are aggregated into
	// a single output time series. If `crossSeriesReducer` is not
	// defined, this field is ignored.
	GroupByFields        []string `protobuf:"bytes,5,rep,name=group_by_fields,json=groupByFields,proto3" json:"group_by_fields,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Aggregation) Reset()         { *m = Aggregation{} }
func (m *Aggregation) String() string { return proto.CompactTextString(m) }
func (*Aggregation) ProtoMessage()    {}
func (*Aggregation) Descriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{0}
}

func (m *Aggregation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Aggregation.Unmarshal(m, b)
}
func (m *Aggregation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Aggregation.Marshal(b, m, deterministic)
}
func (m *Aggregation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Aggregation.Merge(m, src)
}
func (m *Aggregation) XXX_Size() int {
	return xxx_messageInfo_Aggregation.Size(m)
}
func (m *Aggregation) XXX_DiscardUnknown() {
	xxx_messageInfo_Aggregation.DiscardUnknown(m)
}

var xxx_messageInfo_Aggregation proto.InternalMessageInfo

func (m *Aggregation) GetAlignmentPeriod() *duration.Duration {
	if m != nil {
		return m.AlignmentPeriod
	}
	return nil
}

func (m *Aggregation) GetPerSeriesAligner() Aggregation_Aligner {
	if m != nil {
		return m.PerSeriesAligner
	}
	return Aggregation_ALIGN_NONE
}

func (m *Aggregation) GetCrossSeriesReducer() Aggregation_Reducer {
	if m != nil {
		return m.CrossSeriesReducer
	}
	return Aggregation_REDUCE_NONE
}

func (m *Aggregation) GetGroupByFields() []string {
	if m != nil {
		return m.GroupByFields
	}
	return nil
}

// Describes a ranking-based time series filter. Each input time series is
// ranked with an aligner. The filter lets through up to `num_time_series` time
// series, selecting them based on the relative ranking.
type PickTimeSeriesFilter struct {
	// `rankingMethod` is applied to each time series independently to produce the
	// value which will be used to compare the time series to other time series.
	RankingMethod PickTimeSeriesFilter_Method `protobuf:"varint,1,opt,name=ranking_method,json=rankingMethod,proto3,enum=google.monitoring.dashboard.v1.PickTimeSeriesFilter_Method" json:"ranking_method,omitempty"`
	// How many time series to return.
	NumTimeSeries int32 `protobuf:"varint,2,opt,name=num_time_series,json=numTimeSeries,proto3" json:"num_time_series,omitempty"`
	// How to use the ranking to select time series that pass through the filter.
	Direction            PickTimeSeriesFilter_Direction `protobuf:"varint,3,opt,name=direction,proto3,enum=google.monitoring.dashboard.v1.PickTimeSeriesFilter_Direction" json:"direction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *PickTimeSeriesFilter) Reset()         { *m = PickTimeSeriesFilter{} }
func (m *PickTimeSeriesFilter) String() string { return proto.CompactTextString(m) }
func (*PickTimeSeriesFilter) ProtoMessage()    {}
func (*PickTimeSeriesFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{1}
}

func (m *PickTimeSeriesFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PickTimeSeriesFilter.Unmarshal(m, b)
}
func (m *PickTimeSeriesFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PickTimeSeriesFilter.Marshal(b, m, deterministic)
}
func (m *PickTimeSeriesFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PickTimeSeriesFilter.Merge(m, src)
}
func (m *PickTimeSeriesFilter) XXX_Size() int {
	return xxx_messageInfo_PickTimeSeriesFilter.Size(m)
}
func (m *PickTimeSeriesFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_PickTimeSeriesFilter.DiscardUnknown(m)
}

var xxx_messageInfo_PickTimeSeriesFilter proto.InternalMessageInfo

func (m *PickTimeSeriesFilter) GetRankingMethod() PickTimeSeriesFilter_Method {
	if m != nil {
		return m.RankingMethod
	}
	return PickTimeSeriesFilter_METHOD_UNSPECIFIED
}

func (m *PickTimeSeriesFilter) GetNumTimeSeries() int32 {
	if m != nil {
		return m.NumTimeSeries
	}
	return 0
}

func (m *PickTimeSeriesFilter) GetDirection() PickTimeSeriesFilter_Direction {
	if m != nil {
		return m.Direction
	}
	return PickTimeSeriesFilter_DIRECTION_UNSPECIFIED
}

// A filter that ranks streams based on their statistical relation to other
// streams in a request.
type StatisticalTimeSeriesFilter struct {
	// `rankingMethod` is applied to a set of time series, and then the produced
	// value for each individual time series is used to compare a given time
	// series to others.
	// These are methods that cannot be applied stream-by-stream, but rather
	// require the full context of a request to evaluate time series.
	RankingMethod StatisticalTimeSeriesFilter_Method `protobuf:"varint,1,opt,name=ranking_method,json=rankingMethod,proto3,enum=google.monitoring.dashboard.v1.StatisticalTimeSeriesFilter_Method" json:"ranking_method,omitempty"`
	// How many time series to output.
	NumTimeSeries        int32    `protobuf:"varint,2,opt,name=num_time_series,json=numTimeSeries,proto3" json:"num_time_series,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StatisticalTimeSeriesFilter) Reset()         { *m = StatisticalTimeSeriesFilter{} }
func (m *StatisticalTimeSeriesFilter) String() string { return proto.CompactTextString(m) }
func (*StatisticalTimeSeriesFilter) ProtoMessage()    {}
func (*StatisticalTimeSeriesFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{2}
}

func (m *StatisticalTimeSeriesFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StatisticalTimeSeriesFilter.Unmarshal(m, b)
}
func (m *StatisticalTimeSeriesFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StatisticalTimeSeriesFilter.Marshal(b, m, deterministic)
}
func (m *StatisticalTimeSeriesFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatisticalTimeSeriesFilter.Merge(m, src)
}
func (m *StatisticalTimeSeriesFilter) XXX_Size() int {
	return xxx_messageInfo_StatisticalTimeSeriesFilter.Size(m)
}
func (m *StatisticalTimeSeriesFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_StatisticalTimeSeriesFilter.DiscardUnknown(m)
}

var xxx_messageInfo_StatisticalTimeSeriesFilter proto.InternalMessageInfo

func (m *StatisticalTimeSeriesFilter) GetRankingMethod() StatisticalTimeSeriesFilter_Method {
	if m != nil {
		return m.RankingMethod
	}
	return StatisticalTimeSeriesFilter_METHOD_UNSPECIFIED
}

func (m *StatisticalTimeSeriesFilter) GetNumTimeSeries() int32 {
	if m != nil {
		return m.NumTimeSeries
	}
	return 0
}

func init() {
	proto.RegisterEnum("google.monitoring.dashboard.v1.Aggregation_Aligner", Aggregation_Aligner_name, Aggregation_Aligner_value)
	proto.RegisterEnum("google.monitoring.dashboard.v1.Aggregation_Reducer", Aggregation_Reducer_name, Aggregation_Reducer_value)
	proto.RegisterEnum("google.monitoring.dashboard.v1.PickTimeSeriesFilter_Method", PickTimeSeriesFilter_Method_name, PickTimeSeriesFilter_Method_value)
	proto.RegisterEnum("google.monitoring.dashboard.v1.PickTimeSeriesFilter_Direction", PickTimeSeriesFilter_Direction_name, PickTimeSeriesFilter_Direction_value)
	proto.RegisterEnum("google.monitoring.dashboard.v1.StatisticalTimeSeriesFilter_Method", StatisticalTimeSeriesFilter_Method_name, StatisticalTimeSeriesFilter_Method_value)
	proto.RegisterType((*Aggregation)(nil), "google.monitoring.dashboard.v1.Aggregation")
	proto.RegisterType((*PickTimeSeriesFilter)(nil), "google.monitoring.dashboard.v1.PickTimeSeriesFilter")
	proto.RegisterType((*StatisticalTimeSeriesFilter)(nil), "google.monitoring.dashboard.v1.StatisticalTimeSeriesFilter")
}

func init() {
	proto.RegisterFile("google/monitoring/dashboard/v1/common.proto", fileDescriptor_adfe4653047f7180)
}

var fileDescriptor_adfe4653047f7180 = []byte{
	// 864 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0xdd, 0x8e, 0xda, 0x46,
	0x14, 0xae, 0x61, 0x7f, 0xc2, 0xb0, 0xc0, 0xec, 0x84, 0xdd, 0x90, 0x54, 0xaa, 0x56, 0xbe, 0xa8,
	0x56, 0xaa, 0x64, 0x76, 0x37, 0xe2, 0x22, 0x6c, 0x55, 0xc9, 0xd8, 0xc3, 0xc6, 0x12, 0xd8, 0x68,
	0x30, 0xd1, 0xaa, 0xaa, 0x64, 0x19, 0x98, 0x38, 0x56, 0xb0, 0x8d, 0x06, 0x13, 0x29, 0x4f, 0xd0,
	0x8b, 0x3e, 0x48, 0xaf, 0xab, 0xbe, 0x55, 0x2f, 0xfa, 0x0c, 0x95, 0x67, 0xc6, 0x18, 0x54, 0x36,
	0xa8, 0xcd, 0xe5, 0xf9, 0xbe, 0x73, 0xbe, 0x73, 0xfc, 0xcd, 0x1c, 0x0f, 0xf8, 0x21, 0x48, 0x92,
	0x60, 0x41, 0xdb, 0x51, 0x12, 0x87, 0x69, 0xc2, 0xc2, 0x38, 0x68, 0xcf, 0xfd, 0xd5, 0x87, 0x69,
	0xe2, 0xb3, 0x79, 0xfb, 0xd3, 0x6d, 0x7b, 0x96, 0x44, 0x51, 0x12, 0x6b, 0x4b, 0x96, 0xa4, 0x09,
	0xfa, 0x4e, 0x24, 0x6b, 0x45, 0xb2, 0xb6, 0x49, 0xd6, 0x3e, 0xdd, 0xbe, 0x92, 0x7c, 0x9b, 0x67,
	0x4f, 0xd7, 0xef, 0xdb, 0xf3, 0x35, 0xf3, 0xd3, 0x30, 0xaf, 0x57, 0x7f, 0x7d, 0x06, 0xaa, 0x7a,
	0x10, 0x30, 0x1a, 0x70, 0x14, 0x99, 0x00, 0xfa, 0x8b, 0x30, 0x88, 0x23, 0x1a, 0xa7, 0xde, 0x92,
	0xb2, 0x30, 0x99, 0xb7, 0x94, 0x2b, 0xe5, 0xba, 0x7a, 0xf7, 0x52, 0x93, 0xad, 0x72, 0x29, 0xcd,
	0x94, 0x52, 0xa4, 0xb1, 0x29, 0x19, 0xf1, 0x0a, 0xe4, 0x03, 0xb4, 0xa4, 0xcc, 0x5b, 0x51, 0x16,
	0xd2, 0x95, 0xc7, 0x59, 0xca, 0x5a, 0xa5, 0x2b, 0xe5, 0xba, 0x7e, 0xf7, 0x5a, 0xfb, 0xf2, 0xc8,
	0xda, 0xd6, 0x38, 0x9a, 0x2e, 0x4a, 0x09, 0x5c, 0x52, 0x36, 0xe6, 0x6a, 0x12, 0x41, 0x14, 0x34,
	0x67, 0x2c, 0x59, 0xad, 0xf2, 0x26, 0x8c, 0xce, 0xd7, 0x33, 0xca, 0x5a, 0x47, 0xff, 0xbd, 0x09,
	0x11, 0xa5, 0x04, 0x71, 0x41, 0xd1, 0x46, 0x62, 0xe8, 0x7b, 0xd0, 0x08, 0x58, 0xb2, 0x5e, 0x7a,
	0xd3, 0xcf, 0xde, 0xfb, 0x90, 0x2e, 0xe6, 0xab, 0xd6, 0xf1, 0x55, 0xf9, 0xba, 0x42, 0x6a, 0x1c,
	0xee, 0x7d, 0xee, 0x73, 0x50, 0xfd, 0xad, 0x0c, 0x4e, 0xf3, 0xd1, 0xea, 0x00, 0xe8, 0x03, 0xeb,
	0xc1, 0xf6, 0x6c, 0xc7, 0xc6, 0xf0, 0x1b, 0xd4, 0x00, 0x55, 0x11, 0x9b, 0x78, 0xe0, 0xea, 0x50,
	0x29, 0x12, 0x88, 0xee, 0x62, 0x58, 0x42, 0x17, 0xe0, 0x5c, 0xc4, 0x96, 0xed, 0x62, 0x32, 0x72,
	0x06, 0x19, 0x5c, 0x46, 0x4d, 0x00, 0xa5, 0x0e, 0x7e, 0x74, 0x3d, 0x67, 0x60, 0x62, 0x02, 0x8f,
	0x50, 0x0d, 0x54, 0x04, 0x3a, 0xb4, 0x6c, 0x08, 0xb6, 0x42, 0xfd, 0x11, 0x56, 0x0b, 0xe9, 0x21,
	0xd6, 0x6d, 0x78, 0x56, 0xf4, 0x36, 0x9c, 0x89, 0xed, 0xc2, 0x5a, 0x91, 0x3f, 0x9e, 0x0c, 0x61,
	0x1d, 0x41, 0x70, 0x26, 0x43, 0xd7, 0x34, 0xf1, 0x3b, 0xd8, 0x28, 0xba, 0xf2, 0x0a, 0xcf, 0x25,
	0x13, 0x0c, 0x61, 0x31, 0xa2, 0x40, 0xfb, 0xfa, 0x60, 0x8c, 0x61, 0x0b, 0xbd, 0x00, 0xcf, 0x05,
	0xdc, 0x27, 0xba, 0xe1, 0x5a, 0x8e, 0x2d, 0xf2, 0xcf, 0x0b, 0x62, 0x84, 0x89, 0x81, 0x6d, 0xd7,
	0x1a, 0x60, 0xef, 0xcd, 0x1b, 0x88, 0xf6, 0x13, 0x1d, 0xf8, 0x7c, 0x2f, 0xd1, 0xb9, 0x81, 0xcd,
	0xbd, 0xc4, 0x4d, 0x07, 0x5e, 0xa0, 0x16, 0x68, 0xee, 0x10, 0x9e, 0xf1, 0x56, 0xb7, 0x1f, 0x30,
	0x7c, 0xa1, 0xfe, 0x51, 0x02, 0xa7, 0xf9, 0x09, 0x36, 0x40, 0x95, 0x60, 0x73, 0x62, 0xe0, 0xad,
	0xe3, 0x90, 0x00, 0xf7, 0x88, 0x1f, 0x47, 0x0e, 0x58, 0x36, 0x2c, 0x6d, 0xc7, 0xfa, 0x23, 0x2c,
	0x6f, 0xc5, 0x99, 0x67, 0x47, 0xe8, 0x1c, 0xd4, 0xf2, 0x58, 0x98, 0x76, 0x9c, 0xd9, 0x28, 0x21,
	0xe1, 0xf3, 0x49, 0x66, 0xd8, 0x36, 0x22, 0x7c, 0x39, 0x45, 0x97, 0x00, 0xed, 0xc0, 0xc2, 0xc8,
	0x46, 0xf6, 0x2d, 0x12, 0xdf, 0x75, 0xf2, 0xd9, 0x16, 0xb3, 0x6b, 0x65, 0xe5, 0x09, 0xa6, 0x03,
	0xc1, 0x7e, 0xa6, 0x73, 0x03, 0xab, 0xfb, 0x99, 0x9b, 0x0e, 0x3c, 0x53, 0xff, 0x2c, 0x83, 0xe6,
	0x28, 0x9c, 0x7d, 0x74, 0xc3, 0x88, 0x8a, 0x1d, 0xe8, 0x87, 0x8b, 0x94, 0x32, 0x34, 0x05, 0x75,
	0xe6, 0xc7, 0x1f, 0xc3, 0x38, 0xf0, 0x22, 0x9a, 0x7e, 0x90, 0x3f, 0x84, 0xfa, 0xdd, 0xfd, 0xa1,
	0x1d, 0xdb, 0xa7, 0xa6, 0x0d, 0xb9, 0x04, 0xa9, 0x49, 0x49, 0x11, 0x66, 0x6b, 0x16, 0xaf, 0x23,
	0x2f, 0x0d, 0x23, 0x2a, 0x17, 0x9a, 0xff, 0x2d, 0x8e, 0x49, 0x2d, 0x5e, 0x47, 0x85, 0x06, 0xfa,
	0x05, 0x54, 0xe6, 0x21, 0xa3, 0xb3, 0x6c, 0x6f, 0x5b, 0x65, 0x3e, 0xc6, 0x4f, 0xff, 0x6b, 0x0c,
	0x33, 0x57, 0x21, 0x85, 0xa0, 0x9a, 0x82, 0x13, 0x39, 0xcf, 0x25, 0x40, 0x43, 0xec, 0xbe, 0x75,
	0x4c, 0x6f, 0x62, 0x8f, 0x47, 0xd8, 0xb0, 0xfa, 0x16, 0x36, 0xc5, 0xdd, 0x91, 0x78, 0x71, 0x77,
	0x72, 0x40, 0x7f, 0x14, 0x77, 0x27, 0x8f, 0x2d, 0x5b, 0xdc, 0x1d, 0x19, 0x6f, 0xee, 0x8e, 0x8c,
	0xb3, 0x25, 0x1f, 0xbb, 0xf0, 0x58, 0xbd, 0x07, 0x95, 0xcd, 0x34, 0xe8, 0x25, 0xb8, 0x30, 0x2d,
	0x82, 0xc5, 0x0d, 0xd8, 0xed, 0x7d, 0x0a, 0xca, 0xae, 0x33, 0x82, 0x0a, 0x02, 0xe0, 0xa4, 0xe7,
	0xb8, 0xae, 0x33, 0x84, 0x25, 0xf5, 0x6f, 0x05, 0x7c, 0x3b, 0x4e, 0xfd, 0x34, 0x5c, 0xa5, 0xe1,
	0xcc, 0x5f, 0xfc, 0xeb, 0xf0, 0xc2, 0x27, 0x0e, 0xaf, 0x77, 0xc8, 0xb5, 0x2f, 0x88, 0x7e, 0xdd,
	0x19, 0xaa, 0x3f, 0x1e, 0x74, 0xf9, 0x15, 0xb8, 0x94, 0xb8, 0x31, 0x98, 0x8c, 0x5d, 0x4c, 0x3c,
	0x67, 0xe2, 0x0e, 0x2c, 0x4c, 0xa0, 0xd2, 0xfb, 0x5d, 0x01, 0xea, 0x2c, 0x89, 0x0e, 0x8c, 0xdf,
	0xab, 0x1a, 0xfc, 0x95, 0x1c, 0x65, 0x6f, 0xd5, 0x48, 0xf9, 0xf9, 0x41, 0xa6, 0x07, 0xc9, 0xc2,
	0x8f, 0x03, 0x2d, 0x61, 0x41, 0x3b, 0xa0, 0x31, 0x7f, 0xc9, 0xda, 0x82, 0xf2, 0x97, 0xe1, 0xea,
	0xa9, 0x27, 0xf7, 0x7e, 0x13, 0xfc, 0x55, 0xba, 0x7e, 0xe0, 0xe9, 0xdd, 0xae, 0xb1, 0x48, 0xd6,
	0xf3, 0x6e, 0x77, 0xb8, 0x29, 0xe9, 0x76, 0xcd, 0x3c, 0xad, 0xdb, 0x7d, 0x77, 0x3b, 0x3d, 0xe1,
	0xf2, 0xaf, 0xff, 0x09, 0x00, 0x00, 0xff, 0xff, 0x83, 0x01, 0x17, 0xbb, 0xd0, 0x07, 0x00, 0x00,
}
