// Code generated by smithy-go-codegen DO NOT EDIT.

package rekognition

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/rekognition/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This operation applies only to Amazon Rekognition Custom Labels.
//
// Creates a new Amazon Rekognition Custom Labels dataset. You can create a
// dataset by using an Amazon Sagemaker format manifest file or by copying an
// existing Amazon Rekognition Custom Labels dataset.
//
// To create a training dataset for a project, specify TRAIN for the value of
// DatasetType . To create the test dataset for a project, specify TEST for the
// value of DatasetType .
//
// The response from CreateDataset is the Amazon Resource Name (ARN) for the
// dataset. Creating a dataset takes a while to complete. Use DescribeDatasetto check the current
// status. The dataset created successfully if the value of Status is
// CREATE_COMPLETE .
//
// To check if any non-terminal errors occurred, call ListDatasetEntries and check for the presence
// of errors lists in the JSON Lines.
//
// Dataset creation fails if a terminal error occurs ( Status = CREATE_FAILED ).
// Currently, you can't access the terminal error information.
//
// For more information, see Creating dataset in the Amazon Rekognition Custom
// Labels Developer Guide.
//
// This operation requires permissions to perform the rekognition:CreateDataset
// action. If you want to copy an existing dataset, you also require permission to
// perform the rekognition:ListDatasetEntries action.
func (c *Client) CreateDataset(ctx context.Context, params *CreateDatasetInput, optFns ...func(*Options)) (*CreateDatasetOutput, error) {
	if params == nil {
		params = &CreateDatasetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDataset", params, optFns, c.addOperationCreateDatasetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDatasetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDatasetInput struct {

	//  The type of the dataset. Specify TRAIN to create a training dataset. Specify
	// TEST to create a test dataset.
	//
	// This member is required.
	DatasetType types.DatasetType

	//  The ARN of the Amazon Rekognition Custom Labels project to which you want to
	// asssign the dataset.
	//
	// This member is required.
	ProjectArn *string

	//  The source files for the dataset. You can specify the ARN of an existing
	// dataset or specify the Amazon S3 bucket location of an Amazon Sagemaker format
	// manifest file. If you don't specify datasetSource , an empty dataset is created.
	// To add labeled images to the dataset, You can use the console or call UpdateDatasetEntries.
	DatasetSource *types.DatasetSource

	// A set of tags (key-value pairs) that you want to attach to the dataset.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateDatasetOutput struct {

	//  The ARN of the created Amazon Rekognition Custom Labels dataset.
	DatasetArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDatasetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateDataset{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateDataset{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDataset"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDatasetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDataset(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDataset(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDataset",
	}
}
