#pragma once
#include <stdint.h>

namespace cvtt { namespace Tables { namespace BC7SC {

struct TableEntry
{
    uint8_t m_min;
    uint8_t m_max;
    uint8_t m_actualColor;
};

struct Table
{
    uint8_t m_index;
    uint8_t m_pBits;
    TableEntry m_entries[256];
};

Table g_mode0_p00_i1=
{
    1,
    0,
    {
        { 0, 0, 0 }, { 0, 0, 0 }, { 0, 16, 2 }, { 0, 16, 2 }, { 0, 33, 5 }, { 0, 33, 5 }, { 0, 33, 5 }, { 0, 49, 7 },
        { 0, 49, 7 }, { 0, 66, 9 }, { 0, 66, 9 }, { 0, 82, 12 }, { 0, 82, 12 }, { 0, 82, 12 }, { 0, 99, 14 }, { 0, 99, 14 },
        { 0, 115, 16 }, { 0, 115, 16 }, { 16, 33, 18 }, { 0, 132, 19 }, { 0, 132, 19 }, { 0, 148, 21 }, { 0, 148, 21 }, { 0, 165, 23 },
        { 0, 165, 23 }, { 0, 181, 25 }, { 0, 181, 25 }, { 0, 198, 28 }, { 0, 198, 28 }, { 0, 198, 28 }, { 0, 214, 30 }, { 33, 16, 31 },
        { 0, 231, 32 }, { 33, 33, 33 }, { 0, 247, 35 }, { 0, 247, 35 }, { 0, 247, 35 }, { 16, 165, 37 }, { 33, 66, 38 }, { 16, 181, 39 },
        { 33, 82, 40 }, { 16, 198, 42 }, { 16, 198, 42 }, { 16, 198, 42 }, { 16, 214, 44 }, { 33, 115, 45 }, { 16, 231, 46 }, { 33, 132, 47 },
        { 16, 247, 48 }, { 33, 148, 49 }, { 33, 148, 49 }, { 49, 66, 51 }, { 33, 165, 52 }, { 33, 165, 52 }, { 33, 181, 54 }, { 33, 181, 54 },
        { 33, 198, 56 }, { 66, 0, 57 }, { 33, 214, 58 }, { 66, 16, 59 }, { 33, 231, 61 }, { 33, 231, 61 }, { 33, 231, 61 }, { 33, 247, 63 },
        { 66, 49, 64 }, { 49, 165, 65 }, { 66, 66, 66 }, { 49, 181, 68 }, { 49, 181, 68 }, { 49, 181, 68 }, { 49, 198, 70 }, { 66, 99, 71 },
        { 49, 214, 72 }, { 66, 115, 73 }, { 49, 231, 75 }, { 49, 231, 75 }, { 49, 231, 75 }, { 49, 247, 77 }, { 66, 148, 78 }, { 66, 148, 78 },
        { 66, 165, 80 }, { 66, 165, 80 }, { 66, 181, 82 }, { 66, 181, 82 }, { 82, 99, 84 }, { 66, 198, 85 }, { 66, 198, 85 }, { 66, 214, 87 },
        { 66, 214, 87 }, { 66, 231, 89 }, { 99, 33, 90 }, { 66, 247, 91 }, { 99, 49, 92 }, { 82, 165, 94 }, { 82, 165, 94 }, { 82, 165, 94 },
        { 82, 181, 96 }, { 99, 82, 97 }, { 82, 198, 98 }, { 99, 99, 99 }, { 82, 214, 101 }, { 82, 214, 101 }, { 82, 214, 101 }, { 82, 231, 103 },
        { 99, 132, 104 }, { 82, 247, 105 }, { 99, 148, 106 }, { 99, 148, 106 }, { 99, 165, 108 }, { 99, 165, 108 }, { 115, 82, 110 }, { 99, 181, 111 },
        { 99, 181, 111 }, { 99, 198, 113 }, { 99, 198, 113 }, { 99, 214, 115 }, { 132, 16, 116 }, { 115, 132, 117 }, { 99, 231, 118 }, { 99, 231, 118 },
        { 99, 247, 120 }, { 99, 247, 120 }, { 115, 165, 122 }, { 132, 66, 123 }, { 115, 181, 124 }, { 132, 82, 125 }, { 115, 198, 127 }, { 115, 198, 127 },
        { 115, 198, 127 }, { 115, 214, 129 }, { 132, 115, 130 }, { 115, 231, 131 }, { 132, 132, 132 }, { 115, 247, 134 }, { 115, 247, 134 }, { 115, 247, 134 },
        { 148, 66, 136 }, { 132, 165, 137 }, { 132, 165, 137 }, { 132, 181, 139 }, { 132, 181, 139 }, { 132, 198, 141 }, { 165, 0, 142 }, { 148, 115, 143 },
        { 132, 214, 144 }, { 132, 214, 144 }, { 132, 231, 146 }, { 132, 231, 146 }, { 132, 247, 148 }, { 165, 49, 149 }, { 148, 165, 150 }, { 165, 66, 151 },
        { 148, 181, 153 }, { 148, 181, 153 }, { 148, 181, 153 }, { 148, 198, 155 }, { 165, 99, 156 }, { 148, 214, 157 }, { 165, 115, 158 }, { 148, 231, 160 },
        { 148, 231, 160 }, { 148, 231, 160 }, { 148, 247, 162 }, { 165, 148, 163 }, { 165, 148, 163 }, { 165, 165, 165 }, { 165, 165, 165 }, { 165, 181, 167 },
        { 165, 181, 167 }, { 181, 99, 169 }, { 165, 198, 170 }, { 165, 198, 170 }, { 165, 214, 172 }, { 165, 214, 172 }, { 165, 231, 174 }, { 198, 33, 175 },
        { 181, 148, 176 }, { 165, 247, 177 }, { 165, 247, 177 }, { 181, 165, 179 }, { 181, 165, 179 }, { 181, 181, 181 }, { 198, 82, 182 }, { 181, 198, 183 },
        { 198, 99, 184 }, { 181, 214, 186 }, { 181, 214, 186 }, { 181, 214, 186 }, { 181, 231, 188 }, { 198, 132, 189 }, { 181, 247, 190 }, { 198, 148, 191 },
        { 198, 148, 191 }, { 198, 165, 193 }, { 198, 165, 193 }, { 214, 82, 195 }, { 198, 181, 196 }, { 198, 181, 196 }, { 198, 198, 198 }, { 231, 0, 199 },
        { 198, 214, 200 }, { 231, 16, 201 }, { 214, 132, 202 }, { 198, 231, 203 }, { 198, 231, 203 }, { 198, 247, 205 }, { 198, 247, 205 }, { 214, 165, 207 },
        { 231, 66, 208 }, { 214, 181, 209 }, { 231, 82, 210 }, { 214, 198, 212 }, { 214, 198, 212 }, { 214, 198, 212 }, { 214, 214, 214 }, { 231, 115, 215 },
        { 214, 231, 216 }, { 231, 132, 217 }, { 214, 247, 219 }, { 214, 247, 219 }, { 214, 247, 219 }, { 231, 165, 222 }, { 231, 165, 222 }, { 231, 165, 222 },
        { 231, 181, 224 }, { 231, 181, 224 }, { 231, 198, 226 }, { 231, 198, 226 }, { 247, 115, 228 }, { 231, 214, 229 }, { 231, 214, 229 }, { 231, 231, 231 },
        { 231, 231, 231 }, { 231, 247, 233 }, { 231, 247, 233 }, { 247, 165, 235 }, { 247, 165, 235 }, { 247, 181, 238 }, { 247, 181, 238 }, { 247, 181, 238 },
        { 247, 198, 240 }, { 247, 198, 240 }, { 247, 214, 242 }, { 247, 214, 242 }, { 247, 231, 245 }, { 247, 231, 245 }, { 247, 231, 245 }, { 247, 247, 247 },
        { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 },
    }
};

Table g_mode0_p00_i2=
{
    2,
    0,
    {
        { 0, 0, 0 }, { 0, 0, 0 }, { 0, 0, 0 }, { 0, 16, 5 }, { 0, 16, 5 }, { 0, 16, 5 }, { 0, 16, 5 }, { 0, 16, 5 },
        { 0, 33, 9 }, { 0, 33, 9 }, { 0, 33, 9 }, { 16, 0, 12 }, { 16, 0, 12 }, { 0, 49, 14 }, { 0, 49, 14 }, { 0, 49, 14 },
        { 16, 16, 16 }, { 16, 16, 16 }, { 0, 66, 19 }, { 0, 66, 19 }, { 0, 66, 19 }, { 16, 33, 21 }, { 0, 82, 23 }, { 0, 82, 23 },
        { 33, 0, 24 }, { 16, 49, 25 }, { 16, 49, 25 }, { 0, 99, 28 }, { 0, 99, 28 }, { 0, 99, 28 }, { 16, 66, 30 }, { 0, 115, 32 },
        { 0, 115, 32 }, { 33, 33, 33 }, { 16, 82, 35 }, { 16, 82, 35 }, { 0, 132, 37 }, { 0, 132, 37 }, { 33, 49, 38 }, { 16, 99, 39 },
        { 49, 16, 40 }, { 0, 148, 42 }, { 0, 148, 42 }, { 0, 148, 42 }, { 16, 115, 44 }, { 49, 33, 45 }, { 0, 165, 46 }, { 33, 82, 47 },
        { 16, 132, 49 }, { 16, 132, 49 }, { 0, 181, 51 }, { 0, 181, 51 }, { 33, 99, 52 }, { 16, 148, 53 }, { 49, 66, 54 }, { 0, 198, 56 },
        { 0, 198, 56 }, { 66, 33, 57 }, { 16, 165, 58 }, { 82, 0, 59 }, { 0, 214, 60 }, { 33, 132, 61 }, { 16, 181, 62 }, { 49, 99, 63 },
        { 0, 231, 65 }, { 0, 231, 65 }, { 66, 66, 66 }, { 16, 198, 67 }, { 49, 115, 68 }, { 0, 247, 69 }, { 33, 165, 70 }, { 66, 82, 71 },
        { 16, 214, 72 }, { 82, 49, 73 }, { 33, 181, 75 }, { 33, 181, 75 }, { 16, 231, 76 }, { 49, 148, 77 }, { 82, 66, 78 }, { 33, 198, 79 },
        { 66, 115, 80 }, { 16, 247, 81 }, { 49, 165, 82 }, { 115, 0, 83 }, { 33, 214, 84 }, { 66, 132, 85 }, { 49, 181, 86 }, { 82, 99, 87 },
        { 33, 231, 89 }, { 33, 231, 89 }, { 99, 66, 90 }, { 49, 198, 91 }, { 115, 33, 92 }, { 33, 247, 93 }, { 66, 165, 94 }, { 49, 214, 95 },
        { 82, 132, 96 }, { 66, 181, 98 }, { 66, 181, 98 }, { 99, 99, 99 }, { 49, 231, 100 }, { 82, 148, 101 }, { 66, 198, 103 }, { 66, 198, 103 },
        { 99, 115, 104 }, { 49, 247, 105 }, { 115, 82, 106 }, { 66, 214, 108 }, { 66, 214, 108 }, { 132, 49, 109 }, { 82, 181, 110 }, { 115, 99, 111 },
        { 66, 231, 112 }, { 99, 148, 113 }, { 82, 198, 115 }, { 82, 198, 115 }, { 148, 33, 116 }, { 66, 247, 117 }, { 99, 165, 118 }, { 82, 214, 119 },
        { 115, 132, 120 }, { 99, 181, 122 }, { 99, 181, 122 }, { 132, 99, 123 }, { 82, 231, 124 }, { 148, 66, 125 }, { 99, 198, 127 }, { 99, 198, 127 },
        { 82, 247, 128 }, { 115, 165, 129 }, { 181, 0, 130 }, { 99, 214, 131 }, { 132, 132, 132 }, { 115, 181, 134 }, { 115, 181, 134 }, { 181, 16, 135 },
        { 99, 231, 136 }, { 132, 148, 137 }, { 115, 198, 138 }, { 148, 115, 139 }, { 99, 247, 141 }, { 99, 247, 141 }, { 165, 82, 142 }, { 115, 214, 143 },
        { 148, 132, 144 }, { 132, 181, 146 }, { 132, 181, 146 }, { 198, 16, 147 }, { 115, 231, 148 }, { 181, 66, 149 }, { 132, 198, 151 }, { 132, 198, 151 },
        { 115, 247, 152 }, { 148, 165, 153 }, { 214, 0, 154 }, { 132, 214, 155 }, { 165, 132, 156 }, { 148, 181, 157 }, { 181, 99, 158 }, { 132, 231, 160 },
        { 132, 231, 160 }, { 198, 66, 161 }, { 148, 198, 162 }, { 214, 33, 163 }, { 132, 247, 164 }, { 165, 165, 165 }, { 231, 0, 166 }, { 148, 214, 167 },
        { 214, 49, 168 }, { 165, 181, 170 }, { 165, 181, 170 }, { 148, 231, 171 }, { 181, 148, 172 }, { 165, 198, 174 }, { 165, 198, 174 }, { 198, 115, 175 },
        { 148, 247, 176 }, { 181, 165, 177 }, { 247, 0, 178 }, { 165, 214, 179 }, { 231, 49, 180 }, { 181, 181, 181 }, { 214, 99, 182 }, { 165, 231, 184 },
        { 165, 231, 184 }, { 231, 66, 185 }, { 181, 198, 186 }, { 247, 33, 187 }, { 165, 247, 188 }, { 198, 165, 189 }, { 181, 214, 190 }, { 214, 132, 191 },
        { 198, 181, 193 }, { 198, 181, 193 }, { 231, 99, 194 }, { 181, 231, 195 }, { 247, 66, 196 }, { 198, 198, 198 }, { 198, 198, 198 }, { 181, 247, 200 },
        { 181, 247, 200 }, { 247, 82, 201 }, { 198, 214, 203 }, { 198, 214, 203 }, { 198, 214, 203 }, { 214, 181, 205 }, { 198, 231, 207 }, { 198, 231, 207 },
        { 231, 148, 208 }, { 214, 198, 210 }, { 214, 198, 210 }, { 198, 247, 212 }, { 198, 247, 212 }, { 198, 247, 212 }, { 214, 214, 214 }, { 247, 132, 215 },
        { 231, 181, 217 }, { 231, 181, 217 }, { 214, 231, 219 }, { 214, 231, 219 }, { 214, 231, 219 }, { 231, 198, 222 }, { 231, 198, 222 }, { 214, 247, 223 },
        { 247, 165, 224 }, { 231, 214, 226 }, { 231, 214, 226 }, { 231, 214, 226 }, { 247, 181, 228 }, { 247, 181, 228 }, { 231, 231, 231 }, { 231, 231, 231 },
        { 231, 231, 231 }, { 247, 198, 233 }, { 247, 198, 233 }, { 231, 247, 236 }, { 231, 247, 236 }, { 231, 247, 236 }, { 247, 214, 238 }, { 247, 214, 238 },
        { 247, 214, 238 }, { 247, 231, 243 }, { 247, 231, 243 }, { 247, 231, 243 }, { 247, 231, 243 }, { 247, 231, 243 }, { 247, 247, 247 }, { 247, 247, 247 },
        { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 },
    }
};

Table g_mode0_p00_i3=
{
    3,
    0,
    {
        { 0, 0, 0 }, { 0, 0, 0 }, { 0, 0, 0 }, { 0, 0, 0 }, { 0, 16, 7 }, { 0, 16, 7 }, { 0, 16, 7 }, { 0, 16, 7 },
        { 0, 16, 7 }, { 16, 0, 9 }, { 16, 0, 9 }, { 16, 0, 9 }, { 0, 33, 14 }, { 0, 33, 14 }, { 0, 33, 14 }, { 0, 33, 14 },
        { 16, 16, 16 }, { 16, 16, 16 }, { 33, 0, 19 }, { 33, 0, 19 }, { 0, 49, 21 }, { 0, 49, 21 }, { 0, 49, 21 }, { 16, 33, 23 },
        { 16, 33, 23 }, { 33, 16, 26 }, { 33, 16, 26 }, { 0, 66, 28 }, { 0, 66, 28 }, { 0, 66, 28 }, { 16, 49, 30 }, { 16, 49, 30 },
        { 33, 33, 33 }, { 33, 33, 33 }, { 0, 82, 35 }, { 0, 82, 35 }, { 0, 82, 35 }, { 16, 66, 37 }, { 66, 0, 38 }, { 33, 49, 40 },
        { 33, 49, 40 }, { 0, 99, 42 }, { 0, 99, 42 }, { 0, 99, 42 }, { 16, 82, 44 }, { 66, 16, 45 }, { 33, 66, 47 }, { 33, 66, 47 },
        { 0, 115, 49 }, { 0, 115, 49 }, { 0, 115, 49 }, { 16, 99, 51 }, { 66, 33, 52 }, { 33, 82, 54 }, { 33, 82, 54 }, { 0, 132, 56 },
        { 0, 132, 56 }, { 99, 0, 57 }, { 16, 115, 58 }, { 66, 49, 59 }, { 33, 99, 61 }, { 33, 99, 61 }, { 0, 148, 62 }, { 49, 82, 63 },
        { 99, 16, 64 }, { 16, 132, 65 }, { 66, 66, 66 }, { 33, 115, 68 }, { 33, 115, 68 }, { 0, 165, 70 }, { 0, 165, 70 }, { 99, 33, 71 },
        { 16, 148, 72 }, { 66, 82, 73 }, { 33, 132, 75 }, { 33, 132, 75 }, { 0, 181, 76 }, { 49, 115, 77 }, { 99, 49, 78 }, { 16, 165, 79 },
        { 66, 99, 80 }, { 33, 148, 82 }, { 33, 148, 82 }, { 132, 16, 83 }, { 0, 198, 84 }, { 99, 66, 85 }, { 16, 181, 86 }, { 66, 115, 87 },
        { 33, 165, 89 }, { 33, 165, 89 }, { 0, 214, 90 }, { 49, 148, 91 }, { 99, 82, 92 }, { 16, 198, 93 }, { 66, 132, 94 }, { 33, 181, 95 },
        { 82, 115, 96 }, { 0, 231, 97 }, { 49, 165, 98 }, { 99, 99, 99 }, { 16, 214, 100 }, { 66, 148, 101 }, { 165, 16, 102 }, { 33, 198, 103 },
        { 0, 247, 104 }, { 49, 181, 105 }, { 99, 115, 106 }, { 16, 231, 107 }, { 66, 165, 108 }, { 33, 214, 109 }, { 82, 148, 110 }, { 132, 82, 111 },
        { 49, 198, 112 }, { 16, 247, 113 }, { 198, 0, 114 }, { 66, 181, 115 }, { 165, 49, 116 }, { 33, 231, 117 }, { 132, 99, 118 }, { 49, 214, 119 },
        { 99, 148, 120 }, { 198, 16, 121 }, { 66, 198, 122 }, { 33, 247, 123 }, { 82, 181, 124 }, { 132, 115, 125 }, { 49, 231, 126 }, { 99, 165, 127 },
        { 66, 214, 128 }, { 115, 148, 129 }, { 165, 82, 130 }, { 82, 198, 131 }, { 132, 132, 132 }, { 49, 247, 133 }, { 99, 181, 134 }, { 198, 49, 135 },
        { 66, 231, 136 }, { 165, 99, 137 }, { 82, 214, 138 }, { 132, 148, 139 }, { 231, 16, 140 }, { 99, 198, 141 }, { 66, 247, 142 }, { 115, 181, 143 },
        { 165, 115, 144 }, { 82, 231, 145 }, { 132, 165, 146 }, { 231, 33, 147 }, { 99, 214, 148 }, { 198, 82, 149 }, { 115, 198, 150 }, { 165, 132, 151 },
        { 82, 247, 152 }, { 132, 181, 153 }, { 231, 49, 154 }, { 99, 231, 155 }, { 198, 99, 156 }, { 115, 214, 157 }, { 165, 148, 158 }, { 132, 198, 160 },
        { 132, 198, 160 }, { 99, 247, 161 }, { 148, 181, 162 }, { 198, 115, 163 }, { 115, 231, 164 }, { 165, 165, 165 }, { 132, 214, 167 }, { 132, 214, 167 },
        { 231, 82, 168 }, { 148, 198, 169 }, { 198, 132, 170 }, { 115, 247, 171 }, { 165, 181, 172 }, { 132, 231, 174 }, { 132, 231, 174 }, { 231, 99, 175 },
        { 148, 214, 176 }, { 198, 148, 177 }, { 165, 198, 179 }, { 165, 198, 179 }, { 132, 247, 181 }, { 132, 247, 181 }, { 231, 115, 182 }, { 148, 231, 183 },
        { 198, 165, 184 }, { 247, 99, 185 }, { 165, 214, 186 }, { 165, 214, 186 }, { 181, 198, 188 }, { 231, 132, 189 }, { 148, 247, 190 }, { 198, 181, 191 },
        { 165, 231, 193 }, { 165, 231, 193 }, { 165, 231, 193 }, { 181, 214, 195 }, { 231, 148, 196 }, { 198, 198, 198 }, { 198, 198, 198 }, { 165, 247, 200 },
        { 165, 247, 200 }, { 165, 247, 200 }, { 181, 231, 202 }, { 231, 165, 203 }, { 198, 214, 205 }, { 198, 214, 205 }, { 198, 214, 205 }, { 214, 198, 207 },
        { 181, 247, 209 }, { 181, 247, 209 }, { 231, 181, 210 }, { 198, 231, 212 }, { 198, 231, 212 }, { 198, 231, 212 }, { 214, 214, 214 }, { 214, 214, 214 },
        { 231, 198, 217 }, { 231, 198, 217 }, { 198, 247, 219 }, { 198, 247, 219 }, { 198, 247, 219 }, { 214, 231, 221 }, { 214, 231, 221 }, { 231, 214, 224 },
        { 231, 214, 224 }, { 231, 214, 224 }, { 247, 198, 226 }, { 214, 247, 228 }, { 214, 247, 228 }, { 214, 247, 228 }, { 231, 231, 231 }, { 231, 231, 231 },
        { 231, 231, 231 }, { 247, 214, 233 }, { 247, 214, 233 }, { 247, 214, 233 }, { 231, 247, 238 }, { 231, 247, 238 }, { 231, 247, 238 }, { 231, 247, 238 },
        { 247, 231, 240 }, { 247, 231, 240 }, { 247, 231, 240 }, { 247, 231, 240 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 },
        { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 }, { 247, 247, 247 },
    }
};

Table g_mode0_p01_i1=
{
    1,
    2,
    {
        { 0, 8, 1 }, { 0, 8, 1 }, { 0, 8, 1 }, { 0, 24, 3 }, { 0, 24, 3 }, { 0, 41, 6 }, { 0, 41, 6 }, { 0, 41, 6 },
        { 0, 57, 8 }, { 0, 57, 8 }, { 0, 74, 10 }, { 0, 74, 10 }, { 0, 90, 13 }, { 0, 90, 13 }, { 0, 90, 13 }, { 0, 107, 15 },
        { 0, 107, 15 }, { 0, 123, 17 }, { 0, 123, 17 }, { 0, 140, 20 }, { 0, 140, 20 }, { 0, 140, 20 }, { 0, 156, 22 }, { 0, 156, 22 },
        { 0, 173, 24 }, { 0, 173, 24 }, { 16, 90, 26 }, { 0, 189, 27 }, { 0, 189, 27 }, { 0, 206, 29 }, { 0, 206, 29 }, { 0, 222, 31 },
        { 33, 24, 32 }, { 16, 140, 33 }, { 0, 239, 34 }, { 0, 239, 34 }, { 0, 255, 36 }, { 0, 255, 36 }, { 16, 173, 38 }, { 33, 74, 39 },
        { 16, 189, 40 }, { 33, 90, 41 }, { 16, 206, 43 }, { 16, 206, 43 }, { 16, 206, 43 }, { 16, 222, 45 }, { 33, 123, 46 }, { 16, 239, 47 },
        { 33, 140, 48 }, { 16, 255, 50 }, { 16, 255, 50 }, { 16, 255, 50 }, { 33, 173, 53 }, { 33, 173, 53 }, { 33, 173, 53 }, { 33, 189, 55 },
        { 33, 189, 55 }, { 33, 206, 57 }, { 66, 8, 58 }, { 49, 123, 59 }, { 33, 222, 60 }, { 33, 222, 60 }, { 33, 239, 62 }, { 33, 239, 62 },
        { 33, 255, 64 }, { 66, 57, 65 }, { 49, 173, 66 }, { 66, 74, 67 }, { 49, 189, 69 }, { 49, 189, 69 }, { 49, 189, 69 }, { 49, 206, 71 },
        { 66, 107, 72 }, { 49, 222, 73 }, { 66, 123, 74 }, { 49, 239, 76 }, { 49, 239, 76 }, { 49, 239, 76 }, { 49, 255, 78 }, { 66, 156, 79 },
        { 66, 156, 79 }, { 66, 173, 81 }, { 66, 173, 81 }, { 66, 189, 83 }, { 66, 189, 83 }, { 66, 206, 86 }, { 66, 206, 86 }, { 66, 206, 86 },
        { 66, 222, 88 }, { 66, 222, 88 }, { 66, 239, 90 }, { 99, 41, 91 }, { 82, 156, 92 }, { 66, 255, 93 }, { 66, 255, 93 }, { 82, 173, 95 },
        { 82, 173, 95 }, { 82, 189, 97 }, { 99, 90, 98 }, { 82, 206, 99 }, { 99, 107, 100 }, { 82, 222, 102 }, { 82, 222, 102 }, { 82, 222, 102 },
        { 82, 239, 104 }, { 99, 140, 105 }, { 82, 255, 106 }, { 99, 156, 107 }, { 99, 156, 107 }, { 99, 173, 109 }, { 99, 173, 109 }, { 115, 90, 111 },
        { 99, 189, 112 }, { 99, 189, 112 }, { 99, 206, 114 }, { 132, 8, 115 }, { 99, 222, 116 }, { 132, 24, 117 }, { 99, 239, 119 }, { 99, 239, 119 },
        { 99, 239, 119 }, { 99, 255, 121 }, { 99, 255, 121 }, { 115, 173, 123 }, { 132, 74, 124 }, { 115, 189, 125 }, { 132, 90, 126 }, { 115, 206, 128 },
        { 115, 206, 128 }, { 115, 206, 128 }, { 115, 222, 130 }, { 132, 123, 131 }, { 115, 239, 132 }, { 132, 140, 133 }, { 115, 255, 135 }, { 115, 255, 135 },
        { 115, 255, 135 }, { 132, 173, 138 }, { 132, 173, 138 }, { 132, 173, 138 }, { 132, 189, 140 }, { 132, 189, 140 }, { 132, 206, 142 }, { 165, 8, 143 },
        { 148, 123, 144 }, { 132, 222, 145 }, { 132, 222, 145 }, { 132, 239, 147 }, { 165, 41, 148 }, { 132, 255, 149 }, { 165, 57, 150 }, { 148, 173, 152 },
        { 148, 173, 152 }, { 148, 173, 152 }, { 148, 189, 154 }, { 148, 189, 154 }, { 148, 206, 156 }, { 165, 107, 157 }, { 148, 222, 158 }, { 165, 123, 159 },
        { 148, 239, 161 }, { 148, 239, 161 }, { 148, 239, 161 }, { 148, 255, 163 }, { 165, 156, 164 }, { 165, 156, 164 }, { 165, 173, 166 }, { 165, 173, 166 },
        { 165, 189, 168 }, { 165, 189, 168 }, { 165, 206, 171 }, { 165, 206, 171 }, { 165, 206, 171 }, { 165, 222, 173 }, { 198, 24, 174 }, { 165, 239, 175 },
        { 198, 41, 176 }, { 181, 156, 177 }, { 165, 255, 178 }, { 165, 255, 178 }, { 181, 173, 180 }, { 198, 74, 181 }, { 181, 189, 182 }, { 198, 90, 183 },
        { 181, 206, 185 }, { 181, 206, 185 }, { 181, 206, 185 }, { 181, 222, 187 }, { 181, 222, 187 }, { 181, 239, 189 }, { 198, 140, 190 }, { 181, 255, 191 },
        { 198, 156, 192 }, { 198, 156, 192 }, { 198, 173, 194 }, { 198, 173, 194 }, { 198, 189, 197 }, { 198, 189, 197 }, { 198, 189, 197 }, { 198, 206, 199 },
        { 231, 8, 200 }, { 198, 222, 201 }, { 231, 24, 202 }, { 198, 239, 204 }, { 198, 239, 204 }, { 198, 239, 204 }, { 198, 255, 206 }, { 231, 57, 207 },
        { 214, 173, 208 }, { 231, 74, 209 }, { 214, 189, 210 }, { 231, 90, 211 }, { 214, 206, 213 }, { 214, 206, 213 }, { 231, 107, 214 }, { 214, 222, 215 },
        { 231, 123, 216 }, { 214, 239, 218 }, { 214, 239, 218 }, { 214, 239, 218 }, { 214, 255, 220 }, { 214, 255, 220 }, { 231, 173, 223 }, { 231, 173, 223 },
        { 231, 173, 223 }, { 231, 189, 225 }, { 231, 189, 225 }, { 231, 206, 227 }, { 231, 206, 227 }, { 231, 222, 230 }, { 231, 222, 230 }, { 231, 222, 230 },
        { 231, 239, 232 }, { 231, 239, 232 }, { 231, 255, 234 }, { 231, 255, 234 }, { 247, 173, 237 }, { 247, 173, 237 }, { 247, 173, 237 }, { 247, 189, 239 },
        { 247, 189, 239 }, { 247, 206, 241 }, { 247, 206, 241 }, { 247, 222, 243 }, { 247, 222, 243 }, { 247, 239, 246 }, { 247, 239, 246 }, { 247, 239, 246 },
        { 247, 255, 248 }, { 247, 255, 248 }, { 247, 255, 248 }, { 247, 255, 248 }, { 247, 255, 248 }, { 247, 255, 248 }, { 247, 255, 248 }, { 247, 255, 248 },
    }
};

Table g_mode0_p01_i2=
{
    2,
    2,
    {
        { 0, 8, 2 }, { 0, 8, 2 }, { 0, 8, 2 }, { 0, 8, 2 }, { 0, 8, 2 }, { 0, 24, 7 }, { 0, 24, 7 }, { 0, 24, 7 },
        { 0, 24, 7 }, { 0, 24, 7 }, { 0, 41, 12 }, { 0, 41, 12 }, { 0, 41, 12 }, { 0, 41, 12 }, { 16, 8, 14 }, { 0, 57, 16 },
        { 0, 57, 16 }, { 0, 57, 16 }, { 16, 24, 18 }, { 16, 24, 18 }, { 0, 74, 21 }, { 0, 74, 21 }, { 0, 74, 21 }, { 16, 41, 23 },
        { 0, 90, 25 }, { 0, 90, 25 }, { 33, 8, 26 }, { 16, 57, 28 }, { 16, 57, 28 }, { 0, 107, 30 }, { 0, 107, 30 }, { 0, 107, 30 },
        { 16, 74, 32 }, { 16, 74, 32 }, { 0, 123, 35 }, { 0, 123, 35 }, { 0, 123, 35 }, { 16, 90, 37 }, { 0, 140, 39 }, { 0, 140, 39 },
        { 33, 57, 40 }, { 16, 107, 42 }, { 16, 107, 42 }, { 0, 156, 44 }, { 0, 156, 44 }, { 33, 74, 45 }, { 16, 123, 46 }, { 49, 41, 47 },
        { 0, 173, 49 }, { 0, 173, 49 }, { 66, 8, 50 }, { 16, 140, 51 }, { 0, 189, 53 }, { 0, 189, 53 }, { 33, 107, 54 }, { 16, 156, 55 },
        { 49, 74, 56 }, { 0, 206, 58 }, { 0, 206, 58 }, { 66, 41, 59 }, { 16, 173, 60 }, { 49, 90, 61 }, { 0, 222, 62 }, { 33, 140, 63 },
        { 16, 189, 65 }, { 16, 189, 65 }, { 82, 24, 66 }, { 0, 239, 67 }, { 33, 156, 68 }, { 16, 206, 69 }, { 49, 123, 70 }, { 0, 255, 72 },
        { 0, 255, 72 }, { 66, 90, 73 }, { 16, 222, 74 }, { 49, 140, 75 }, { 33, 189, 77 }, { 33, 189, 77 }, { 66, 107, 78 }, { 16, 239, 79 },
        { 82, 74, 80 }, { 33, 206, 82 }, { 33, 206, 82 }, { 16, 255, 83 }, { 49, 173, 84 }, { 115, 8, 85 }, { 33, 222, 86 }, { 66, 140, 87 },
        { 49, 189, 88 }, { 82, 107, 89 }, { 33, 239, 91 }, { 33, 239, 91 }, { 99, 74, 92 }, { 49, 206, 93 }, { 82, 123, 94 }, { 33, 255, 95 },
        { 66, 173, 96 }, { 132, 8, 97 }, { 49, 222, 98 }, { 115, 57, 99 }, { 66, 189, 101 }, { 66, 189, 101 }, { 49, 239, 102 }, { 82, 156, 103 },
        { 66, 206, 105 }, { 66, 206, 105 }, { 99, 123, 106 }, { 49, 255, 107 }, { 82, 173, 108 }, { 148, 8, 109 }, { 66, 222, 110 }, { 99, 140, 111 },
        { 82, 189, 112 }, { 115, 107, 113 }, { 66, 239, 115 }, { 66, 239, 115 }, { 132, 74, 116 }, { 82, 206, 117 }, { 148, 41, 118 }, { 66, 255, 119 },
        { 99, 173, 120 }, { 82, 222, 121 }, { 115, 140, 122 }, { 99, 189, 124 }, { 99, 189, 124 }, { 132, 107, 125 }, { 82, 239, 126 }, { 115, 156, 127 },
        { 99, 206, 129 }, { 99, 206, 129 }, { 165, 41, 130 }, { 82, 255, 131 }, { 148, 90, 132 }, { 99, 222, 134 }, { 99, 222, 134 }, { 165, 57, 135 },
        { 115, 189, 136 }, { 181, 24, 137 }, { 99, 239, 138 }, { 132, 156, 139 }, { 115, 206, 141 }, { 115, 206, 141 }, { 181, 41, 142 }, { 99, 255, 143 },
        { 132, 173, 144 }, { 115, 222, 145 }, { 148, 140, 146 }, { 132, 189, 148 }, { 132, 189, 148 }, { 165, 107, 149 }, { 115, 239, 150 }, { 181, 74, 151 },
        { 132, 206, 153 }, { 132, 206, 153 }, { 115, 255, 154 }, { 148, 173, 155 }, { 214, 8, 156 }, { 132, 222, 157 }, { 165, 140, 158 }, { 148, 189, 160 },
        { 148, 189, 160 }, { 214, 24, 161 }, { 132, 239, 162 }, { 198, 74, 163 }, { 148, 206, 164 }, { 181, 123, 165 }, { 132, 255, 167 }, { 132, 255, 167 },
        { 198, 90, 168 }, { 148, 222, 169 }, { 214, 57, 170 }, { 165, 189, 172 }, { 165, 189, 172 }, { 231, 24, 173 }, { 148, 239, 174 }, { 214, 74, 175 },
        { 165, 206, 177 }, { 165, 206, 177 }, { 148, 255, 178 }, { 181, 173, 179 }, { 247, 8, 180 }, { 165, 222, 181 }, { 198, 140, 182 }, { 181, 189, 183 },
        { 214, 107, 184 }, { 165, 239, 186 }, { 165, 239, 186 }, { 231, 74, 187 }, { 181, 206, 188 }, { 247, 41, 189 }, { 165, 255, 190 }, { 198, 173, 191 },
        { 181, 222, 193 }, { 181, 222, 193 }, { 247, 57, 194 }, { 198, 189, 195 }, { 231, 107, 196 }, { 181, 239, 197 }, { 214, 156, 198 }, { 198, 206, 200 },
        { 198, 206, 200 }, { 231, 123, 201 }, { 181, 255, 202 }, { 247, 90, 203 }, { 198, 222, 205 }, { 198, 222, 205 }, { 198, 222, 205 }, { 214, 189, 207 },
        { 247, 107, 208 }, { 198, 239, 210 }, { 198, 239, 210 }, { 198, 239, 210 }, { 214, 206, 212 }, { 198, 255, 214 }, { 198, 255, 214 }, { 231, 173, 215 },
        { 214, 222, 216 }, { 247, 140, 217 }, { 231, 189, 219 }, { 231, 189, 219 }, { 214, 239, 221 }, { 214, 239, 221 }, { 214, 239, 221 }, { 231, 206, 224 },
        { 231, 206, 224 }, { 214, 255, 226 }, { 214, 255, 226 }, { 214, 255, 226 }, { 231, 222, 228 }, { 231, 222, 228 }, { 247, 189, 231 }, { 247, 189, 231 },
        { 231, 239, 233 }, { 231, 239, 233 }, { 231, 239, 233 }, { 247, 206, 235 }, { 247, 206, 235 }, { 231, 255, 238 }, { 231, 255, 238 }, { 231, 255, 238 },
        { 247, 222, 240 }, { 247, 222, 240 }, { 247, 222, 240 }, { 247, 239, 245 }, { 247, 239, 245 }, { 247, 239, 245 }, { 247, 239, 245 }, { 247, 239, 245 },
        { 247, 255, 249 }, { 247, 255, 249 }, { 247, 255, 249 }, { 247, 255, 249 }, { 247, 255, 249 }, { 247, 255, 249 }, { 247, 255, 249 }, { 247, 255, 249 },
    }
};

Table g_mode0_p01_i3=
{
    3,
    2,
    {
        { 0, 8, 3 }, { 0, 8, 3 }, { 0, 8, 3 }, { 0, 8, 3 }, { 0, 8, 3 }, { 0, 8, 3 }, { 0, 8, 3 }, { 0, 24, 10 },
        { 0, 24, 10 }, { 0, 24, 10 }, { 0, 24, 10 }, { 0, 24, 10 }, { 16, 8, 13 }, { 16, 8, 13 }, { 16, 8, 13 }, { 0, 41, 17 },
        { 0, 41, 17 }, { 0, 41, 17 }, { 0, 41, 17 }, { 16, 24, 19 }, { 16, 24, 19 }, { 33, 8, 22 }, { 33, 8, 22 }, { 0, 57, 24 },
        { 0, 57, 24 }, { 0, 57, 24 }, { 16, 41, 27 }, { 16, 41, 27 }, { 16, 41, 27 }, { 33, 24, 29 }, { 0, 74, 31 }, { 0, 74, 31 },
        { 49, 8, 32 }, { 16, 57, 33 }, { 16, 57, 33 }, { 33, 41, 36 }, { 33, 41, 36 }, { 0, 90, 38 }, { 0, 90, 38 }, { 0, 90, 38 },
        { 16, 74, 40 }, { 16, 74, 40 }, { 66, 8, 42 }, { 33, 57, 43 }, { 0, 107, 45 }, { 0, 107, 45 }, { 49, 41, 46 }, { 16, 90, 47 },
        { 66, 24, 48 }, { 33, 74, 50 }, { 33, 74, 50 }, { 82, 8, 51 }, { 0, 123, 52 }, { 0, 123, 52 }, { 16, 107, 54 }, { 66, 41, 55 },
        { 33, 90, 57 }, { 33, 90, 57 }, { 82, 24, 58 }, { 0, 140, 59 }, { 49, 74, 60 }, { 16, 123, 61 }, { 66, 57, 62 }, { 33, 107, 64 },
        { 33, 107, 64 }, { 82, 41, 65 }, { 0, 156, 66 }, { 99, 24, 67 }, { 16, 140, 68 }, { 66, 74, 69 }, { 115, 8, 70 }, { 33, 123, 71 },
        { 0, 173, 73 }, { 0, 173, 73 }, { 0, 173, 73 }, { 16, 156, 75 }, { 66, 90, 76 }, { 115, 24, 77 }, { 33, 140, 78 }, { 82, 74, 79 },
        { 0, 189, 80 }, { 99, 57, 81 }, { 16, 173, 82 }, { 66, 107, 83 }, { 115, 41, 84 }, { 33, 156, 85 }, { 132, 24, 86 }, { 0, 206, 87 },
        { 99, 74, 88 }, { 16, 189, 89 }, { 66, 123, 90 }, { 115, 57, 91 }, { 33, 173, 92 }, { 82, 107, 93 }, { 0, 222, 94 }, { 99, 90, 95 },
        { 16, 206, 96 }, { 66, 140, 97 }, { 115, 74, 98 }, { 33, 189, 99 }, { 132, 57, 100 }, { 0, 239, 101 }, { 99, 107, 102 }, { 16, 222, 103 },
        { 66, 156, 104 }, { 33, 206, 106 }, { 33, 206, 106 }, { 0, 255, 108 }, { 0, 255, 108 }, { 99, 123, 109 }, { 16, 239, 110 }, { 66, 173, 111 },
        { 115, 107, 112 }, { 33, 222, 113 }, { 132, 90, 114 }, { 49, 206, 115 }, { 99, 140, 116 }, { 16, 255, 117 }, { 66, 189, 118 }, { 165, 57, 119 },
        { 33, 239, 120 }, { 132, 107, 121 }, { 49, 222, 122 }, { 99, 156, 123 }, { 148, 90, 124 }, { 66, 206, 125 }, { 115, 140, 126 }, { 33, 255, 127 },
        { 132, 123, 128 }, { 49, 239, 129 }, { 99, 173, 130 }, { 148, 107, 131 }, { 66, 222, 132 }, { 165, 90, 133 }, { 82, 206, 134 }, { 132, 140, 135 },
        { 49, 255, 136 }, { 99, 189, 137 }, { 66, 239, 139 }, { 66, 239, 139 }, { 66, 239, 139 }, { 82, 222, 141 }, { 132, 156, 142 }, { 181, 90, 143 },
        { 99, 206, 144 }, { 148, 140, 145 }, { 66, 255, 146 }, { 165, 123, 147 }, { 82, 239, 148 }, { 132, 173, 149 }, { 181, 107, 150 }, { 99, 222, 151 },
        { 198, 90, 152 }, { 115, 206, 153 }, { 165, 140, 154 }, { 82, 255, 155 }, { 132, 189, 156 }, { 181, 123, 157 }, { 99, 239, 158 }, { 148, 173, 159 },
        { 115, 222, 160 }, { 165, 156, 161 }, { 214, 90, 162 }, { 132, 206, 163 }, { 181, 140, 164 }, { 99, 255, 165 }, { 198, 123, 166 }, { 115, 239, 167 },
        { 165, 173, 168 }, { 214, 107, 169 }, { 132, 222, 170 }, { 132, 222, 170 }, { 148, 206, 172 }, { 115, 255, 174 }, { 115, 255, 174 }, { 165, 189, 175 },
        { 214, 123, 176 }, { 132, 239, 177 }, { 181, 173, 178 }, { 148, 222, 179 }, { 198, 156, 180 }, { 247, 90, 181 }, { 165, 206, 182 }, { 214, 140, 183 },
        { 132, 255, 184 }, { 231, 123, 185 }, { 148, 239, 186 }, { 198, 173, 187 }, { 247, 107, 188 }, { 165, 222, 189 }, { 214, 156, 190 }, { 181, 206, 192 },
        { 181, 206, 192 }, { 148, 255, 193 }, { 198, 189, 194 }, { 247, 123, 195 }, { 165, 239, 196 }, { 214, 173, 197 }, { 181, 222, 198 }, { 231, 156, 199 },
        { 198, 206, 201 }, { 198, 206, 201 }, { 247, 140, 202 }, { 165, 255, 203 }, { 165, 255, 203 }, { 181, 239, 205 }, { 181, 239, 205 }, { 231, 173, 207 },
        { 198, 222, 208 }, { 247, 156, 209 }, { 214, 206, 211 }, { 214, 206, 211 }, { 181, 255, 212 }, { 231, 189, 213 }, { 198, 239, 215 }, { 198, 239, 215 },
        { 247, 173, 216 }, { 214, 222, 217 }, { 214, 222, 217 }, { 231, 206, 220 }, { 231, 206, 220 }, { 198, 255, 222 }, { 198, 255, 222 }, { 247, 189, 223 },
        { 214, 239, 225 }, { 214, 239, 225 }, { 214, 239, 225 }, { 231, 222, 227 }, { 231, 222, 227 }, { 247, 206, 230 }, { 247, 206, 230 }, { 214, 255, 231 },
        { 214, 255, 231 }, { 231, 239, 234 }, { 231, 239, 234 }, { 231, 239, 234 }, { 247, 222, 236 }, { 247, 222, 236 }, { 247, 222, 236 }, { 231, 255, 241 },
        { 231, 255, 241 }, { 231, 255, 241 }, { 231, 255, 241 }, { 247, 239, 244 }, { 247, 239, 244 }, { 247, 239, 244 }, { 247, 239, 244 }, { 247, 239, 244 },
        { 247, 255, 250 }, { 247, 255, 250 }, { 247, 255, 250 }, { 247, 255, 250 }, { 247, 255, 250 }, { 247, 255, 250 }, { 247, 255, 250 }, { 247, 255, 250 },
    }
};

Table g_mode0_p10_i1=
{
    1,
    1,
    {
        { 8, 0, 7 }, { 8, 0, 7 }, { 8, 0, 7 }, { 8, 0, 7 }, { 8, 0, 7 }, { 8, 0, 7 }, { 8, 0, 7 }, { 8, 0, 7 },
        { 8, 0, 7 }, { 8, 16, 9 }, { 8, 16, 9 }, { 8, 33, 12 }, { 8, 33, 12 }, { 8, 33, 12 }, { 8, 49, 14 }, { 8, 49, 14 },
        { 8, 66, 16 }, { 8, 66, 16 }, { 8, 82, 18 }, { 8, 82, 18 }, { 8, 99, 21 }, { 8, 99, 21 }, { 8, 99, 21 }, { 8, 115, 23 },
        { 8, 115, 23 }, { 8, 132, 25 }, { 8, 132, 25 }, { 8, 148, 28 }, { 8, 148, 28 }, { 8, 148, 28 }, { 8, 165, 30 }, { 8, 165, 30 },
        { 8, 181, 32 }, { 8, 181, 32 }, { 8, 198, 35 }, { 8, 198, 35 }, { 8, 198, 35 }, { 8, 214, 37 }, { 8, 214, 37 }, { 8, 231, 39 },
        { 41, 33, 40 }, { 24, 148, 41 }, { 8, 247, 42 }, { 8, 247, 42 }, { 24, 165, 44 }, { 41, 66, 45 }, { 24, 181, 46 }, { 41, 82, 47 },
        { 24, 198, 48 }, { 41, 99, 49 }, { 24, 214, 51 }, { 24, 214, 51 }, { 24, 214, 51 }, { 24, 231, 53 }, { 41, 132, 54 }, { 24, 247, 55 },
        { 41, 148, 56 }, { 41, 148, 56 }, { 41, 165, 58 }, { 41, 165, 58 }, { 41, 181, 61 }, { 41, 181, 61 }, { 41, 181, 61 }, { 41, 198, 63 },
        { 74, 0, 64 }, { 41, 214, 65 }, { 74, 16, 66 }, { 41, 231, 68 }, { 41, 231, 68 }, { 41, 231, 68 }, { 41, 247, 70 }, { 41, 247, 70 },
        { 57, 165, 72 }, { 74, 66, 73 }, { 57, 181, 74 }, { 74, 82, 75 }, { 57, 198, 77 }, { 57, 198, 77 }, { 74, 99, 78 }, { 57, 214, 79 },
        { 74, 115, 80 }, { 57, 231, 81 }, { 74, 132, 82 }, { 57, 247, 84 }, { 57, 247, 84 }, { 57, 247, 84 }, { 74, 165, 87 }, { 74, 165, 87 },
        { 74, 165, 87 }, { 74, 181, 89 }, { 74, 181, 89 }, { 74, 198, 91 }, { 107, 0, 92 }, { 74, 214, 94 }, { 74, 214, 94 }, { 74, 214, 94 },
        { 74, 231, 96 }, { 107, 33, 97 }, { 74, 247, 98 }, { 107, 49, 99 }, { 90, 165, 101 }, { 90, 165, 101 }, { 90, 165, 101 }, { 90, 181, 103 },
        { 90, 181, 103 }, { 90, 198, 105 }, { 107, 99, 106 }, { 90, 214, 107 }, { 107, 115, 108 }, { 90, 231, 110 }, { 90, 231, 110 }, { 107, 132, 111 },
        { 90, 247, 112 }, { 107, 148, 113 }, { 107, 148, 113 }, { 107, 165, 115 }, { 107, 165, 115 }, { 107, 181, 117 }, { 107, 181, 117 }, { 107, 198, 120 },
        { 107, 198, 120 }, { 107, 198, 120 }, { 107, 214, 122 }, { 140, 16, 123 }, { 107, 231, 124 }, { 140, 33, 125 }, { 107, 247, 127 }, { 107, 247, 127 },
        { 107, 247, 127 }, { 123, 165, 129 }, { 140, 66, 130 }, { 123, 181, 131 }, { 140, 82, 132 }, { 123, 198, 134 }, { 123, 198, 134 }, { 123, 198, 134 },
        { 123, 214, 136 }, { 123, 214, 136 }, { 123, 231, 138 }, { 140, 132, 139 }, { 123, 247, 140 }, { 140, 148, 141 }, { 140, 148, 141 }, { 156, 66, 143 },
        { 140, 165, 144 }, { 140, 165, 144 }, { 140, 181, 146 }, { 140, 181, 146 }, { 140, 198, 148 }, { 173, 0, 149 }, { 140, 214, 150 }, { 173, 16, 151 },
        { 140, 231, 153 }, { 140, 231, 153 }, { 140, 231, 153 }, { 140, 247, 155 }, { 173, 49, 156 }, { 156, 165, 157 }, { 173, 66, 158 }, { 156, 181, 160 },
        { 156, 181, 160 }, { 156, 181, 160 }, { 156, 198, 162 }, { 173, 99, 163 }, { 156, 214, 164 }, { 173, 115, 165 }, { 156, 231, 167 }, { 156, 231, 167 },
        { 156, 231, 167 }, { 156, 247, 169 }, { 156, 247, 169 }, { 173, 165, 172 }, { 173, 165, 172 }, { 173, 165, 172 }, { 173, 181, 174 }, { 173, 181, 174 },
        { 189, 99, 176 }, { 173, 198, 177 }, { 173, 198, 177 }, { 173, 214, 179 }, { 173, 214, 179 }, { 173, 231, 181 }, { 206, 33, 182 }, { 173, 247, 183 },
        { 206, 49, 184 }, { 189, 165, 186 }, { 189, 165, 186 }, { 189, 165, 186 }, { 189, 181, 188 }, { 206, 82, 189 }, { 189, 198, 190 }, { 206, 99, 191 },
        { 189, 214, 193 }, { 189, 214, 193 }, { 189, 214, 193 }, { 189, 231, 195 }, { 206, 132, 196 }, { 189, 247, 197 }, { 206, 148, 198 }, { 206, 148, 198 },
        { 206, 165, 200 }, { 206, 165, 200 }, { 206, 181, 202 }, { 206, 181, 202 }, { 206, 198, 205 }, { 206, 198, 205 }, { 206, 198, 205 }, { 206, 214, 207 },
        { 239, 16, 208 }, { 222, 132, 209 }, { 206, 231, 210 }, { 206, 231, 210 }, { 206, 247, 212 }, { 206, 247, 212 }, { 222, 165, 214 }, { 239, 66, 215 },
        { 222, 181, 216 }, { 239, 82, 217 }, { 222, 198, 219 }, { 222, 198, 219 }, { 222, 198, 219 }, { 222, 214, 221 }, { 239, 115, 222 }, { 222, 231, 223 },
        { 239, 132, 224 }, { 222, 247, 226 }, { 222, 247, 226 }, { 222, 247, 226 }, { 255, 66, 228 }, { 239, 165, 229 }, { 239, 165, 229 }, { 239, 181, 231 },
        { 239, 181, 231 }, { 239, 198, 233 }, { 239, 198, 233 }, { 239, 214, 235 }, { 239, 214, 235 }, { 239, 231, 238 }, { 239, 231, 238 }, { 239, 231, 238 },
        { 239, 247, 240 }, { 239, 247, 240 }, { 255, 165, 242 }, { 255, 165, 242 }, { 255, 181, 245 }, { 255, 181, 245 }, { 255, 181, 245 }, { 255, 198, 247 },
        { 255, 198, 247 }, { 255, 214, 249 }, { 255, 214, 249 }, { 255, 231, 252 }, { 255, 231, 252 }, { 255, 231, 252 }, { 255, 247, 254 }, { 255, 247, 254 },
    }
};

Table g_mode0_p10_i2=
{
    2,
    1,
    {
        { 8, 0, 6 }, { 8, 0, 6 }, { 8, 0, 6 }, { 8, 0, 6 }, { 8, 0, 6 }, { 8, 0, 6 }, { 8, 0, 6 }, { 8, 0, 6 },
        { 8, 0, 6 }, { 8, 16, 10 }, { 8, 16, 10 }, { 8, 16, 10 }, { 8, 16, 10 }, { 8, 33, 15 }, { 8, 33, 15 }, { 8, 33, 15 },
        { 8, 33, 15 }, { 24, 0, 17 }, { 24, 0, 17 }, { 8, 49, 20 }, { 8, 49, 20 }, { 8, 49, 20 }, { 24, 16, 22 }, { 8, 66, 24 },
        { 8, 66, 24 }, { 8, 66, 24 }, { 24, 33, 27 }, { 24, 33, 27 }, { 8, 82, 29 }, { 8, 82, 29 }, { 8, 82, 29 }, { 24, 49, 31 },
        { 24, 49, 31 }, { 8, 99, 34 }, { 8, 99, 34 }, { 8, 99, 34 }, { 24, 66, 36 }, { 8, 115, 38 }, { 8, 115, 38 }, { 41, 33, 39 },
        { 24, 82, 40 }, { 57, 0, 41 }, { 8, 132, 43 }, { 8, 132, 43 }, { 8, 132, 43 }, { 24, 99, 45 }, { 8, 148, 47 }, { 8, 148, 47 },
        { 41, 66, 48 }, { 24, 115, 50 }, { 24, 115, 50 }, { 8, 165, 52 }, { 8, 165, 52 }, { 41, 82, 53 }, { 24, 132, 54 }, { 57, 49, 55 },
        { 8, 181, 57 }, { 8, 181, 57 }, { 74, 16, 58 }, { 24, 148, 59 }, { 57, 66, 60 }, { 8, 198, 61 }, { 41, 115, 62 }, { 24, 165, 64 },
        { 24, 165, 64 }, { 90, 0, 65 }, { 8, 214, 66 }, { 41, 132, 67 }, { 24, 181, 68 }, { 57, 99, 69 }, { 8, 231, 71 }, { 8, 231, 71 },
        { 74, 66, 72 }, { 24, 198, 73 }, { 90, 33, 74 }, { 8, 247, 75 }, { 41, 165, 76 }, { 24, 214, 77 }, { 57, 132, 78 }, { 41, 181, 80 },
        { 41, 181, 80 }, { 74, 99, 81 }, { 24, 231, 82 }, { 57, 148, 83 }, { 41, 198, 85 }, { 41, 198, 85 }, { 74, 115, 86 }, { 24, 247, 87 },
        { 90, 82, 88 }, { 41, 214, 90 }, { 41, 214, 90 }, { 107, 49, 91 }, { 57, 181, 92 }, { 90, 99, 93 }, { 41, 231, 94 }, { 74, 148, 95 },
        { 57, 198, 97 }, { 57, 198, 97 }, { 123, 33, 98 }, { 41, 247, 99 }, { 74, 165, 100 }, { 57, 214, 101 }, { 90, 132, 102 }, { 74, 181, 104 },
        { 74, 181, 104 }, { 107, 99, 105 }, { 57, 231, 106 }, { 123, 66, 107 }, { 74, 198, 109 }, { 74, 198, 109 }, { 57, 247, 110 }, { 90, 165, 111 },
        { 156, 0, 112 }, { 74, 214, 113 }, { 107, 132, 114 }, { 90, 181, 116 }, { 90, 181, 116 }, { 156, 16, 117 }, { 74, 231, 118 }, { 107, 148, 119 },
        { 90, 198, 120 }, { 123, 115, 121 }, { 74, 247, 123 }, { 74, 247, 123 }, { 140, 82, 124 }, { 90, 214, 125 }, { 123, 132, 126 }, { 107, 181, 128 },
        { 107, 181, 128 }, { 173, 16, 129 }, { 90, 231, 130 }, { 156, 66, 131 }, { 107, 198, 133 }, { 107, 198, 133 }, { 90, 247, 134 }, { 123, 165, 135 },
        { 189, 0, 136 }, { 107, 214, 137 }, { 140, 132, 138 }, { 123, 181, 139 }, { 156, 99, 140 }, { 107, 231, 142 }, { 107, 231, 142 }, { 173, 66, 143 },
        { 123, 198, 144 }, { 189, 33, 145 }, { 107, 247, 146 }, { 140, 165, 147 }, { 206, 0, 148 }, { 123, 214, 149 }, { 189, 49, 150 }, { 140, 181, 152 },
        { 140, 181, 152 }, { 123, 231, 153 }, { 156, 148, 154 }, { 140, 198, 156 }, { 140, 198, 156 }, { 173, 115, 157 }, { 123, 247, 158 }, { 156, 165, 159 },
        { 222, 0, 160 }, { 140, 214, 161 }, { 206, 49, 162 }, { 156, 181, 163 }, { 189, 99, 164 }, { 140, 231, 166 }, { 140, 231, 166 }, { 206, 66, 167 },
        { 156, 198, 168 }, { 222, 33, 169 }, { 140, 247, 170 }, { 173, 165, 171 }, { 156, 214, 172 }, { 189, 132, 173 }, { 173, 181, 175 }, { 173, 181, 175 },
        { 206, 99, 176 }, { 156, 231, 177 }, { 222, 66, 178 }, { 173, 198, 180 }, { 173, 198, 180 }, { 239, 33, 181 }, { 156, 247, 182 }, { 222, 82, 183 },
        { 173, 214, 185 }, { 173, 214, 185 }, { 239, 49, 186 }, { 189, 181, 187 }, { 255, 16, 188 }, { 173, 231, 189 }, { 206, 148, 190 }, { 189, 198, 192 },
        { 189, 198, 192 }, { 255, 33, 193 }, { 173, 247, 194 }, { 239, 82, 195 }, { 189, 214, 196 }, { 222, 132, 197 }, { 206, 181, 199 }, { 206, 181, 199 },
        { 239, 99, 200 }, { 189, 231, 201 }, { 255, 66, 202 }, { 206, 198, 204 }, { 206, 198, 204 }, { 189, 247, 205 }, { 222, 165, 206 }, { 206, 214, 208 },
        { 206, 214, 208 }, { 239, 132, 209 }, { 222, 181, 210 }, { 255, 99, 211 }, { 206, 231, 213 }, { 206, 231, 213 }, { 206, 231, 213 }, { 222, 198, 215 },
        { 255, 115, 216 }, { 206, 247, 218 }, { 206, 247, 218 }, { 206, 247, 218 }, { 222, 214, 220 }, { 222, 214, 220 }, { 239, 181, 223 }, { 239, 181, 223 },
        { 222, 231, 225 }, { 222, 231, 225 }, { 222, 231, 225 }, { 239, 198, 227 }, { 222, 247, 229 }, { 222, 247, 229 }, { 255, 165, 230 }, { 239, 214, 232 },
        { 239, 214, 232 }, { 239, 214, 232 }, { 255, 181, 234 }, { 255, 181, 234 }, { 239, 231, 237 }, { 239, 231, 237 }, { 239, 231, 237 }, { 255, 198, 239 },
        { 239, 247, 241 }, { 239, 247, 241 }, { 239, 247, 241 }, { 255, 214, 243 }, { 255, 214, 243 }, { 255, 214, 243 }, { 255, 231, 248 }, { 255, 231, 248 },
        { 255, 231, 248 }, { 255, 231, 248 }, { 255, 231, 248 }, { 255, 247, 253 }, { 255, 247, 253 }, { 255, 247, 253 }, { 255, 247, 253 }, { 255, 247, 253 },
    }
};

Table g_mode0_p10_i3=
{
    3,
    3,
    {
        { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 },
        { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 24, 15 }, { 8, 24, 15 }, { 8, 24, 15 }, { 8, 24, 15 },
        { 8, 24, 15 }, { 24, 8, 17 }, { 24, 8, 17 }, { 24, 8, 17 }, { 8, 41, 22 }, { 8, 41, 22 }, { 8, 41, 22 }, { 8, 41, 22 },
        { 24, 24, 24 }, { 24, 24, 24 }, { 41, 8, 27 }, { 41, 8, 27 }, { 8, 57, 29 }, { 8, 57, 29 }, { 8, 57, 29 }, { 24, 41, 31 },
        { 24, 41, 31 }, { 41, 24, 34 }, { 41, 24, 34 }, { 8, 74, 36 }, { 8, 74, 36 }, { 8, 74, 36 }, { 24, 57, 38 }, { 24, 57, 38 },
        { 41, 41, 41 }, { 41, 41, 41 }, { 8, 90, 43 }, { 8, 90, 43 }, { 8, 90, 43 }, { 24, 74, 45 }, { 74, 8, 46 }, { 41, 57, 48 },
        { 41, 57, 48 }, { 8, 107, 50 }, { 8, 107, 50 }, { 8, 107, 50 }, { 24, 90, 52 }, { 74, 24, 53 }, { 41, 74, 55 }, { 41, 74, 55 },
        { 8, 123, 57 }, { 8, 123, 57 }, { 8, 123, 57 }, { 24, 107, 59 }, { 74, 41, 60 }, { 41, 90, 62 }, { 41, 90, 62 }, { 8, 140, 64 },
        { 8, 140, 64 }, { 107, 8, 65 }, { 24, 123, 66 }, { 74, 57, 67 }, { 41, 107, 69 }, { 41, 107, 69 }, { 8, 156, 70 }, { 57, 90, 71 },
        { 107, 24, 72 }, { 24, 140, 73 }, { 74, 74, 74 }, { 41, 123, 76 }, { 41, 123, 76 }, { 8, 173, 78 }, { 8, 173, 78 }, { 107, 41, 79 },
        { 24, 156, 80 }, { 74, 90, 81 }, { 41, 140, 83 }, { 41, 140, 83 }, { 8, 189, 84 }, { 57, 123, 85 }, { 107, 57, 86 }, { 24, 173, 87 },
        { 74, 107, 88 }, { 41, 156, 90 }, { 41, 156, 90 }, { 140, 24, 91 }, { 8, 206, 92 }, { 107, 74, 93 }, { 24, 189, 94 }, { 74, 123, 95 },
        { 41, 173, 97 }, { 41, 173, 97 }, { 8, 222, 98 }, { 57, 156, 99 }, { 107, 90, 100 }, { 24, 206, 101 }, { 74, 140, 102 }, { 41, 189, 103 },
        { 90, 123, 104 }, { 8, 239, 105 }, { 57, 173, 106 }, { 107, 107, 107 }, { 24, 222, 108 }, { 74, 156, 109 }, { 173, 24, 110 }, { 41, 206, 111 },
        { 8, 255, 112 }, { 57, 189, 113 }, { 107, 123, 114 }, { 24, 239, 115 }, { 74, 173, 116 }, { 41, 222, 117 }, { 90, 156, 118 }, { 140, 90, 119 },
        { 57, 206, 120 }, { 24, 255, 121 }, { 206, 8, 122 }, { 74, 189, 123 }, { 173, 57, 124 }, { 41, 239, 125 }, { 140, 107, 126 }, { 57, 222, 127 },
        { 107, 156, 128 }, { 206, 24, 129 }, { 74, 206, 130 }, { 41, 255, 131 }, { 90, 189, 132 }, { 140, 123, 133 }, { 57, 239, 134 }, { 107, 173, 135 },
        { 74, 222, 136 }, { 123, 156, 137 }, { 173, 90, 138 }, { 90, 206, 139 }, { 140, 140, 140 }, { 57, 255, 141 }, { 107, 189, 142 }, { 206, 57, 143 },
        { 74, 239, 144 }, { 173, 107, 145 }, { 90, 222, 146 }, { 140, 156, 147 }, { 239, 24, 148 }, { 107, 206, 149 }, { 74, 255, 150 }, { 123, 189, 151 },
        { 173, 123, 152 }, { 90, 239, 153 }, { 140, 173, 154 }, { 239, 41, 155 }, { 107, 222, 156 }, { 206, 90, 157 }, { 123, 206, 158 }, { 173, 140, 159 },
        { 90, 255, 160 }, { 140, 189, 161 }, { 239, 57, 162 }, { 107, 239, 163 }, { 206, 107, 164 }, { 123, 222, 165 }, { 173, 156, 166 }, { 140, 206, 168 },
        { 140, 206, 168 }, { 107, 255, 169 }, { 156, 189, 170 }, { 206, 123, 171 }, { 123, 239, 172 }, { 173, 173, 173 }, { 140, 222, 175 }, { 140, 222, 175 },
        { 239, 90, 176 }, { 156, 206, 177 }, { 206, 140, 178 }, { 123, 255, 179 }, { 173, 189, 180 }, { 140, 239, 182 }, { 140, 239, 182 }, { 239, 107, 183 },
        { 156, 222, 184 }, { 206, 156, 185 }, { 173, 206, 187 }, { 173, 206, 187 }, { 140, 255, 189 }, { 140, 255, 189 }, { 239, 123, 190 }, { 156, 239, 191 },
        { 206, 173, 192 }, { 255, 107, 193 }, { 173, 222, 194 }, { 173, 222, 194 }, { 189, 206, 196 }, { 239, 140, 197 }, { 156, 255, 198 }, { 206, 189, 199 },
        { 173, 239, 201 }, { 173, 239, 201 }, { 173, 239, 201 }, { 189, 222, 203 }, { 239, 156, 204 }, { 206, 206, 206 }, { 206, 206, 206 }, { 173, 255, 208 },
        { 173, 255, 208 }, { 173, 255, 208 }, { 189, 239, 210 }, { 239, 173, 211 }, { 206, 222, 213 }, { 206, 222, 213 }, { 206, 222, 213 }, { 222, 206, 215 },
        { 189, 255, 217 }, { 189, 255, 217 }, { 239, 189, 218 }, { 206, 239, 220 }, { 206, 239, 220 }, { 206, 239, 220 }, { 222, 222, 222 }, { 222, 222, 222 },
        { 239, 206, 225 }, { 239, 206, 225 }, { 206, 255, 227 }, { 206, 255, 227 }, { 206, 255, 227 }, { 222, 239, 229 }, { 222, 239, 229 }, { 239, 222, 232 },
        { 239, 222, 232 }, { 239, 222, 232 }, { 255, 206, 234 }, { 222, 255, 236 }, { 222, 255, 236 }, { 222, 255, 236 }, { 239, 239, 239 }, { 239, 239, 239 },
        { 239, 239, 239 }, { 255, 222, 241 }, { 255, 222, 241 }, { 255, 222, 241 }, { 239, 255, 246 }, { 239, 255, 246 }, { 239, 255, 246 }, { 239, 255, 246 },
        { 255, 239, 248 }, { 255, 239, 248 }, { 255, 239, 248 }, { 255, 239, 248 }, { 255, 255, 255 }, { 255, 255, 255 }, { 255, 255, 255 }, { 255, 255, 255 },
    }
};

Table g_mode0_p11_i1=
{
    1,
    3,
    {
        { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 },
        { 8, 8, 8 }, { 8, 8, 8 }, { 8, 24, 10 }, { 8, 24, 10 }, { 8, 41, 13 }, { 8, 41, 13 }, { 8, 41, 13 }, { 8, 57, 15 },
        { 8, 57, 15 }, { 8, 74, 17 }, { 8, 74, 17 }, { 8, 90, 20 }, { 8, 90, 20 }, { 8, 90, 20 }, { 8, 107, 22 }, { 8, 107, 22 },
        { 8, 123, 24 }, { 8, 123, 24 }, { 24, 41, 26 }, { 8, 140, 27 }, { 8, 140, 27 }, { 8, 156, 29 }, { 8, 156, 29 }, { 8, 173, 31 },
        { 8, 173, 31 }, { 8, 189, 33 }, { 8, 189, 33 }, { 8, 206, 36 }, { 8, 206, 36 }, { 8, 206, 36 }, { 8, 222, 38 }, { 41, 24, 39 },
        { 8, 239, 40 }, { 41, 41, 41 }, { 8, 255, 43 }, { 8, 255, 43 }, { 8, 255, 43 }, { 24, 173, 45 }, { 41, 74, 46 }, { 24, 189, 47 },
        { 41, 90, 48 }, { 24, 206, 50 }, { 24, 206, 50 }, { 24, 206, 50 }, { 24, 222, 52 }, { 41, 123, 53 }, { 24, 239, 54 }, { 41, 140, 55 },
        { 24, 255, 56 }, { 41, 156, 57 }, { 41, 156, 57 }, { 57, 74, 59 }, { 41, 173, 60 }, { 41, 173, 60 }, { 41, 189, 62 }, { 41, 189, 62 },
        { 41, 206, 64 }, { 74, 8, 65 }, { 41, 222, 66 }, { 74, 24, 67 }, { 41, 239, 69 }, { 41, 239, 69 }, { 41, 239, 69 }, { 41, 255, 71 },
        { 74, 57, 72 }, { 57, 173, 73 }, { 74, 74, 74 }, { 57, 189, 76 }, { 57, 189, 76 }, { 57, 189, 76 }, { 57, 206, 78 }, { 74, 107, 79 },
        { 57, 222, 80 }, { 74, 123, 81 }, { 57, 239, 83 }, { 57, 239, 83 }, { 57, 239, 83 }, { 57, 255, 85 }, { 74, 156, 86 }, { 74, 156, 86 },
        { 74, 173, 88 }, { 74, 173, 88 }, { 74, 189, 90 }, { 74, 189, 90 }, { 90, 107, 92 }, { 74, 206, 93 }, { 74, 206, 93 }, { 74, 222, 95 },
        { 74, 222, 95 }, { 74, 239, 97 }, { 107, 41, 98 }, { 74, 255, 99 }, { 107, 57, 100 }, { 90, 173, 102 }, { 90, 173, 102 }, { 90, 173, 102 },
        { 90, 189, 104 }, { 107, 90, 105 }, { 90, 206, 106 }, { 107, 107, 107 }, { 90, 222, 109 }, { 90, 222, 109 }, { 90, 222, 109 }, { 90, 239, 111 },
        { 107, 140, 112 }, { 90, 255, 113 }, { 107, 156, 114 }, { 107, 156, 114 }, { 107, 173, 116 }, { 107, 173, 116 }, { 123, 90, 118 }, { 107, 189, 119 },
        { 107, 189, 119 }, { 107, 206, 121 }, { 107, 206, 121 }, { 107, 222, 123 }, { 140, 24, 124 }, { 123, 140, 125 }, { 107, 239, 126 }, { 107, 239, 126 },
        { 107, 255, 128 }, { 107, 255, 128 }, { 123, 173, 130 }, { 140, 74, 131 }, { 123, 189, 132 }, { 140, 90, 133 }, { 123, 206, 135 }, { 123, 206, 135 },
        { 123, 206, 135 }, { 123, 222, 137 }, { 140, 123, 138 }, { 123, 239, 139 }, { 140, 140, 140 }, { 123, 255, 142 }, { 123, 255, 142 }, { 123, 255, 142 },
        { 156, 74, 144 }, { 140, 173, 145 }, { 140, 173, 145 }, { 140, 189, 147 }, { 140, 189, 147 }, { 140, 206, 149 }, { 173, 8, 150 }, { 156, 123, 151 },
        { 140, 222, 152 }, { 140, 222, 152 }, { 140, 239, 154 }, { 140, 239, 154 }, { 140, 255, 156 }, { 173, 57, 157 }, { 156, 173, 158 }, { 173, 74, 159 },
        { 156, 189, 161 }, { 156, 189, 161 }, { 156, 189, 161 }, { 156, 206, 163 }, { 173, 107, 164 }, { 156, 222, 165 }, { 173, 123, 166 }, { 156, 239, 168 },
        { 156, 239, 168 }, { 156, 239, 168 }, { 156, 255, 170 }, { 173, 156, 171 }, { 173, 156, 171 }, { 173, 173, 173 }, { 173, 173, 173 }, { 173, 189, 175 },
        { 173, 189, 175 }, { 189, 107, 177 }, { 173, 206, 178 }, { 173, 206, 178 }, { 173, 222, 180 }, { 173, 222, 180 }, { 173, 239, 182 }, { 206, 41, 183 },
        { 189, 156, 184 }, { 173, 255, 185 }, { 173, 255, 185 }, { 189, 173, 187 }, { 189, 173, 187 }, { 189, 189, 189 }, { 206, 90, 190 }, { 189, 206, 191 },
        { 206, 107, 192 }, { 189, 222, 194 }, { 189, 222, 194 }, { 189, 222, 194 }, { 189, 239, 196 }, { 206, 140, 197 }, { 189, 255, 198 }, { 206, 156, 199 },
        { 206, 156, 199 }, { 206, 173, 201 }, { 206, 173, 201 }, { 222, 90, 203 }, { 206, 189, 204 }, { 206, 189, 204 }, { 206, 206, 206 }, { 239, 8, 207 },
        { 206, 222, 208 }, { 239, 24, 209 }, { 222, 140, 210 }, { 206, 239, 211 }, { 206, 239, 211 }, { 206, 255, 213 }, { 206, 255, 213 }, { 222, 173, 215 },
        { 239, 74, 216 }, { 222, 189, 217 }, { 239, 90, 218 }, { 222, 206, 220 }, { 222, 206, 220 }, { 222, 206, 220 }, { 222, 222, 222 }, { 239, 123, 223 },
        { 222, 239, 224 }, { 239, 140, 225 }, { 222, 255, 227 }, { 222, 255, 227 }, { 222, 255, 227 }, { 239, 173, 230 }, { 239, 173, 230 }, { 239, 173, 230 },
        { 239, 189, 232 }, { 239, 189, 232 }, { 239, 206, 234 }, { 239, 206, 234 }, { 255, 123, 236 }, { 239, 222, 237 }, { 239, 222, 237 }, { 239, 239, 239 },
        { 239, 239, 239 }, { 239, 255, 241 }, { 239, 255, 241 }, { 255, 173, 243 }, { 255, 173, 243 }, { 255, 189, 246 }, { 255, 189, 246 }, { 255, 189, 246 },
        { 255, 206, 248 }, { 255, 206, 248 }, { 255, 222, 250 }, { 255, 222, 250 }, { 255, 239, 253 }, { 255, 239, 253 }, { 255, 239, 253 }, { 255, 255, 255 },
    }
};

Table g_mode0_p11_i2=
{
    2,
    3,
    {
        { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 },
        { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 24, 13 }, { 8, 24, 13 }, { 8, 24, 13 }, { 8, 24, 13 }, { 8, 24, 13 },
        { 8, 41, 17 }, { 8, 41, 17 }, { 8, 41, 17 }, { 24, 8, 20 }, { 24, 8, 20 }, { 8, 57, 22 }, { 8, 57, 22 }, { 8, 57, 22 },
        { 24, 24, 24 }, { 24, 24, 24 }, { 8, 74, 27 }, { 8, 74, 27 }, { 8, 74, 27 }, { 24, 41, 29 }, { 8, 90, 31 }, { 8, 90, 31 },
        { 41, 8, 32 }, { 24, 57, 33 }, { 24, 57, 33 }, { 8, 107, 36 }, { 8, 107, 36 }, { 8, 107, 36 }, { 24, 74, 38 }, { 8, 123, 40 },
        { 8, 123, 40 }, { 41, 41, 41 }, { 24, 90, 43 }, { 24, 90, 43 }, { 8, 140, 45 }, { 8, 140, 45 }, { 41, 57, 46 }, { 24, 107, 47 },
        { 57, 24, 48 }, { 8, 156, 50 }, { 8, 156, 50 }, { 8, 156, 50 }, { 24, 123, 52 }, { 57, 41, 53 }, { 8, 173, 54 }, { 41, 90, 55 },
        { 24, 140, 57 }, { 24, 140, 57 }, { 8, 189, 59 }, { 8, 189, 59 }, { 41, 107, 60 }, { 24, 156, 61 }, { 57, 74, 62 }, { 8, 206, 64 },
        { 8, 206, 64 }, { 74, 41, 65 }, { 24, 173, 66 }, { 90, 8, 67 }, { 8, 222, 68 }, { 41, 140, 69 }, { 24, 189, 70 }, { 57, 107, 71 },
        { 8, 239, 73 }, { 8, 239, 73 }, { 74, 74, 74 }, { 24, 206, 75 }, { 57, 123, 76 }, { 8, 255, 77 }, { 41, 173, 78 }, { 74, 90, 79 },
        { 24, 222, 80 }, { 90, 57, 81 }, { 41, 189, 83 }, { 41, 189, 83 }, { 24, 239, 84 }, { 57, 156, 85 }, { 90, 74, 86 }, { 41, 206, 87 },
        { 74, 123, 88 }, { 24, 255, 89 }, { 57, 173, 90 }, { 123, 8, 91 }, { 41, 222, 92 }, { 74, 140, 93 }, { 57, 189, 94 }, { 90, 107, 95 },
        { 41, 239, 97 }, { 41, 239, 97 }, { 107, 74, 98 }, { 57, 206, 99 }, { 123, 41, 100 }, { 41, 255, 101 }, { 74, 173, 102 }, { 57, 222, 103 },
        { 90, 140, 104 }, { 74, 189, 106 }, { 74, 189, 106 }, { 107, 107, 107 }, { 57, 239, 108 }, { 90, 156, 109 }, { 74, 206, 111 }, { 74, 206, 111 },
        { 107, 123, 112 }, { 57, 255, 113 }, { 123, 90, 114 }, { 74, 222, 116 }, { 74, 222, 116 }, { 140, 57, 117 }, { 90, 189, 118 }, { 123, 107, 119 },
        { 74, 239, 120 }, { 107, 156, 121 }, { 90, 206, 123 }, { 90, 206, 123 }, { 156, 41, 124 }, { 74, 255, 125 }, { 107, 173, 126 }, { 90, 222, 127 },
        { 123, 140, 128 }, { 107, 189, 130 }, { 107, 189, 130 }, { 140, 107, 131 }, { 90, 239, 132 }, { 156, 74, 133 }, { 107, 206, 135 }, { 107, 206, 135 },
        { 90, 255, 136 }, { 123, 173, 137 }, { 189, 8, 138 }, { 107, 222, 139 }, { 140, 140, 140 }, { 123, 189, 142 }, { 123, 189, 142 }, { 189, 24, 143 },
        { 107, 239, 144 }, { 140, 156, 145 }, { 123, 206, 146 }, { 156, 123, 147 }, { 107, 255, 149 }, { 107, 255, 149 }, { 173, 90, 150 }, { 123, 222, 151 },
        { 156, 140, 152 }, { 140, 189, 154 }, { 140, 189, 154 }, { 206, 24, 155 }, { 123, 239, 156 }, { 189, 74, 157 }, { 140, 206, 159 }, { 140, 206, 159 },
        { 123, 255, 160 }, { 156, 173, 161 }, { 222, 8, 162 }, { 140, 222, 163 }, { 173, 140, 164 }, { 156, 189, 165 }, { 189, 107, 166 }, { 140, 239, 168 },
        { 140, 239, 168 }, { 206, 74, 169 }, { 156, 206, 170 }, { 222, 41, 171 }, { 140, 255, 172 }, { 173, 173, 173 }, { 239, 8, 174 }, { 156, 222, 175 },
        { 222, 57, 176 }, { 173, 189, 178 }, { 173, 189, 178 }, { 156, 239, 179 }, { 189, 156, 180 }, { 173, 206, 182 }, { 173, 206, 182 }, { 206, 123, 183 },
        { 156, 255, 184 }, { 189, 173, 185 }, { 255, 8, 186 }, { 173, 222, 187 }, { 239, 57, 188 }, { 189, 189, 189 }, { 222, 107, 190 }, { 173, 239, 192 },
        { 173, 239, 192 }, { 239, 74, 193 }, { 189, 206, 194 }, { 255, 41, 195 }, { 173, 255, 196 }, { 206, 173, 197 }, { 189, 222, 198 }, { 222, 140, 199 },
        { 206, 189, 201 }, { 206, 189, 201 }, { 239, 107, 202 }, { 189, 239, 203 }, { 255, 74, 204 }, { 206, 206, 206 }, { 206, 206, 206 }, { 189, 255, 208 },
        { 189, 255, 208 }, { 255, 90, 209 }, { 206, 222, 211 }, { 206, 222, 211 }, { 206, 222, 211 }, { 222, 189, 213 }, { 206, 239, 215 }, { 206, 239, 215 },
        { 239, 156, 216 }, { 222, 206, 218 }, { 222, 206, 218 }, { 206, 255, 220 }, { 206, 255, 220 }, { 206, 255, 220 }, { 222, 222, 222 }, { 255, 140, 223 },
        { 239, 189, 225 }, { 239, 189, 225 }, { 222, 239, 227 }, { 222, 239, 227 }, { 222, 239, 227 }, { 239, 206, 230 }, { 239, 206, 230 }, { 222, 255, 231 },
        { 255, 173, 232 }, { 239, 222, 234 }, { 239, 222, 234 }, { 239, 222, 234 }, { 255, 189, 236 }, { 255, 189, 236 }, { 239, 239, 239 }, { 239, 239, 239 },
        { 239, 239, 239 }, { 255, 206, 241 }, { 255, 206, 241 }, { 239, 255, 244 }, { 239, 255, 244 }, { 239, 255, 244 }, { 255, 222, 246 }, { 255, 222, 246 },
        { 255, 222, 246 }, { 255, 239, 251 }, { 255, 239, 251 }, { 255, 239, 251 }, { 255, 239, 251 }, { 255, 239, 251 }, { 255, 255, 255 }, { 255, 255, 255 },
    }
};

Table g_mode0_p11_i3=
{
    3,
    3,
    {
        { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 },
        { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 8, 8 }, { 8, 24, 15 }, { 8, 24, 15 }, { 8, 24, 15 }, { 8, 24, 15 },
        { 8, 24, 15 }, { 24, 8, 17 }, { 24, 8, 17 }, { 24, 8, 17 }, { 8, 41, 22 }, { 8, 41, 22 }, { 8, 41, 22 }, { 8, 41, 22 },
        { 24, 24, 24 }, { 24, 24, 24 }, { 41, 8, 27 }, { 41, 8, 27 }, { 8, 57, 29 }, { 8, 57, 29 }, { 8, 57, 29 }, { 24, 41, 31 },
        { 24, 41, 31 }, { 41, 24, 34 }, { 41, 24, 34 }, { 8, 74, 36 }, { 8, 74, 36 }, { 8, 74, 36 }, { 24, 57, 38 }, { 24, 57, 38 },
        { 41, 41, 41 }, { 41, 41, 41 }, { 8, 90, 43 }, { 8, 90, 43 }, { 8, 90, 43 }, { 24, 74, 45 }, { 74, 8, 46 }, { 41, 57, 48 },
        { 41, 57, 48 }, { 8, 107, 50 }, { 8, 107, 50 }, { 8, 107, 50 }, { 24, 90, 52 }, { 74, 24, 53 }, { 41, 74, 55 }, { 41, 74, 55 },
        { 8, 123, 57 }, { 8, 123, 57 }, { 8, 123, 57 }, { 24, 107, 59 }, { 74, 41, 60 }, { 41, 90, 62 }, { 41, 90, 62 }, { 8, 140, 64 },
        { 8, 140, 64 }, { 107, 8, 65 }, { 24, 123, 66 }, { 74, 57, 67 }, { 41, 107, 69 }, { 41, 107, 69 }, { 8, 156, 70 }, { 57, 90, 71 },
        { 107, 24, 72 }, { 24, 140, 73 }, { 74, 74, 74 }, { 41, 123, 76 }, { 41, 123, 76 }, { 8, 173, 78 }, { 8, 173, 78 }, { 107, 41, 79 },
        { 24, 156, 80 }, { 74, 90, 81 }, { 41, 140, 83 }, { 41, 140, 83 }, { 8, 189, 84 }, { 57, 123, 85 }, { 107, 57, 86 }, { 24, 173, 87 },
        { 74, 107, 88 }, { 41, 156, 90 }, { 41, 156, 90 }, { 140, 24, 91 }, { 8, 206, 92 }, { 107, 74, 93 }, { 24, 189, 94 }, { 74, 123, 95 },
        { 41, 173, 97 }, { 41, 173, 97 }, { 8, 222, 98 }, { 57, 156, 99 }, { 107, 90, 100 }, { 24, 206, 101 }, { 74, 140, 102 }, { 41, 189, 103 },
        { 90, 123, 104 }, { 8, 239, 105 }, { 57, 173, 106 }, { 107, 107, 107 }, { 24, 222, 108 }, { 74, 156, 109 }, { 173, 24, 110 }, { 41, 206, 111 },
        { 8, 255, 112 }, { 57, 189, 113 }, { 107, 123, 114 }, { 24, 239, 115 }, { 74, 173, 116 }, { 41, 222, 117 }, { 90, 156, 118 }, { 140, 90, 119 },
        { 57, 206, 120 }, { 24, 255, 121 }, { 206, 8, 122 }, { 74, 189, 123 }, { 173, 57, 124 }, { 41, 239, 125 }, { 140, 107, 126 }, { 57, 222, 127 },
        { 107, 156, 128 }, { 206, 24, 129 }, { 74, 206, 130 }, { 41, 255, 131 }, { 90, 189, 132 }, { 140, 123, 133 }, { 57, 239, 134 }, { 107, 173, 135 },
        { 74, 222, 136 }, { 123, 156, 137 }, { 173, 90, 138 }, { 90, 206, 139 }, { 140, 140, 140 }, { 57, 255, 141 }, { 107, 189, 142 }, { 206, 57, 143 },
        { 74, 239, 144 }, { 173, 107, 145 }, { 90, 222, 146 }, { 140, 156, 147 }, { 239, 24, 148 }, { 107, 206, 149 }, { 74, 255, 150 }, { 123, 189, 151 },
        { 173, 123, 152 }, { 90, 239, 153 }, { 140, 173, 154 }, { 239, 41, 155 }, { 107, 222, 156 }, { 206, 90, 157 }, { 123, 206, 158 }, { 173, 140, 159 },
        { 90, 255, 160 }, { 140, 189, 161 }, { 239, 57, 162 }, { 107, 239, 163 }, { 206, 107, 164 }, { 123, 222, 165 }, { 173, 156, 166 }, { 140, 206, 168 },
        { 140, 206, 168 }, { 107, 255, 169 }, { 156, 189, 170 }, { 206, 123, 171 }, { 123, 239, 172 }, { 173, 173, 173 }, { 140, 222, 175 }, { 140, 222, 175 },
        { 239, 90, 176 }, { 156, 206, 177 }, { 206, 140, 178 }, { 123, 255, 179 }, { 173, 189, 180 }, { 140, 239, 182 }, { 140, 239, 182 }, { 239, 107, 183 },
        { 156, 222, 184 }, { 206, 156, 185 }, { 173, 206, 187 }, { 173, 206, 187 }, { 140, 255, 189 }, { 140, 255, 189 }, { 239, 123, 190 }, { 156, 239, 191 },
        { 206, 173, 192 }, { 255, 107, 193 }, { 173, 222, 194 }, { 173, 222, 194 }, { 189, 206, 196 }, { 239, 140, 197 }, { 156, 255, 198 }, { 206, 189, 199 },
        { 173, 239, 201 }, { 173, 239, 201 }, { 173, 239, 201 }, { 189, 222, 203 }, { 239, 156, 204 }, { 206, 206, 206 }, { 206, 206, 206 }, { 173, 255, 208 },
        { 173, 255, 208 }, { 173, 255, 208 }, { 189, 239, 210 }, { 239, 173, 211 }, { 206, 222, 213 }, { 206, 222, 213 }, { 206, 222, 213 }, { 222, 206, 215 },
        { 189, 255, 217 }, { 189, 255, 217 }, { 239, 189, 218 }, { 206, 239, 220 }, { 206, 239, 220 }, { 206, 239, 220 }, { 222, 222, 222 }, { 222, 222, 222 },
        { 239, 206, 225 }, { 239, 206, 225 }, { 206, 255, 227 }, { 206, 255, 227 }, { 206, 255, 227 }, { 222, 239, 229 }, { 222, 239, 229 }, { 239, 222, 232 },
        { 239, 222, 232 }, { 239, 222, 232 }, { 255, 206, 234 }, { 222, 255, 236 }, { 222, 255, 236 }, { 222, 255, 236 }, { 239, 239, 239 }, { 239, 239, 239 },
        { 239, 239, 239 }, { 255, 222, 241 }, { 255, 222, 241 }, { 255, 222, 241 }, { 239, 255, 246 }, { 239, 255, 246 }, { 239, 255, 246 }, { 239, 255, 246 },
        { 255, 239, 248 }, { 255, 239, 248 }, { 255, 239, 248 }, { 255, 239, 248 }, { 255, 255, 255 }, { 255, 255, 255 }, { 255, 255, 255 }, { 255, 255, 255 },
    }
};

Table g_mode1_p0_i1=
{
    1,
    0,
    {
        { 0, 0, 0 }, { 0, 4, 1 }, { 0, 12, 2 }, { 0, 20, 3 }, { 0, 28, 4 }, { 0, 32, 5 }, { 0, 40, 6 }, { 0, 48, 7 },
        { 0, 56, 8 }, { 0, 64, 9 }, { 0, 68, 10 }, { 0, 76, 11 }, { 0, 84, 12 }, { 0, 92, 13 }, { 0, 96, 14 }, { 0, 104, 15 },
        { 0, 112, 16 }, { 0, 120, 17 }, { 0, 129, 18 }, { 0, 133, 19 }, { 0, 141, 20 }, { 0, 149, 21 }, { 0, 153, 22 }, { 0, 161, 23 },
        { 0, 169, 24 }, { 0, 177, 25 }, { 0, 185, 26 }, { 0, 189, 27 }, { 0, 197, 28 }, { 0, 205, 29 }, { 0, 213, 30 }, { 0, 217, 31 },
        { 0, 225, 32 }, { 0, 233, 33 }, { 0, 241, 34 }, { 0, 249, 35 }, { 0, 253, 36 }, { 4, 237, 37 }, { 4, 245, 38 }, { 4, 253, 39 },
        { 8, 233, 40 }, { 8, 241, 41 }, { 8, 249, 42 }, { 12, 229, 43 }, { 12, 237, 44 }, { 12, 245, 45 }, { 12, 253, 46 }, { 16, 233, 47 },
        { 16, 241, 48 }, { 16, 249, 49 }, { 20, 233, 50 }, { 20, 237, 51 }, { 20, 245, 52 }, { 20, 253, 53 }, { 24, 237, 54 }, { 24, 241, 55 },
        { 24, 249, 56 }, { 28, 233, 57 }, { 28, 241, 58 }, { 28, 245, 59 }, { 28, 253, 60 }, { 32, 237, 61 }, { 32, 245, 62 }, { 32, 249, 63 },
        { 36, 233, 64 }, { 36, 241, 65 }, { 36, 249, 66 }, { 36, 253, 67 }, { 40, 237, 68 }, { 40, 245, 69 }, { 40, 253, 70 }, { 44, 233, 71 },
        { 44, 241, 72 }, { 44, 249, 73 }, { 48, 233, 74 }, { 48, 237, 75 }, { 48, 245, 76 }, { 48, 253, 77 }, { 52, 237, 78 }, { 52, 241, 79 },
        { 52, 249, 80 }, { 56, 233, 81 }, { 56, 241, 82 }, { 56, 245, 83 }, { 56, 253, 84 }, { 60, 237, 85 }, { 60, 245, 86 }, { 60, 249, 87 },
        { 64, 233, 88 }, { 64, 241, 89 }, { 64, 249, 90 }, { 64, 253, 91 }, { 68, 237, 92 }, { 68, 245, 93 }, { 68, 253, 94 }, { 72, 233, 95 },
        { 72, 241, 96 }, { 72, 249, 97 }, { 76, 229, 98 }, { 76, 237, 99 }, { 76, 245, 100 }, { 76, 253, 101 }, { 80, 233, 102 }, { 80, 241, 103 },
        { 80, 249, 104 }, { 84, 233, 105 }, { 84, 237, 106 }, { 84, 245, 107 }, { 84, 253, 108 }, { 88, 237, 109 }, { 88, 241, 110 }, { 88, 249, 111 },
        { 92, 233, 112 }, { 92, 241, 113 }, { 92, 245, 114 }, { 92, 253, 115 }, { 96, 237, 116 }, { 96, 245, 117 }, { 96, 249, 118 }, { 100, 233, 119 },
        { 100, 241, 120 }, { 100, 249, 121 }, { 100, 253, 122 }, { 104, 237, 123 }, { 104, 245, 124 }, { 104, 253, 125 }, { 108, 233, 126 }, { 108, 241, 127 },
        { 108, 249, 128 }, { 112, 233, 129 }, { 112, 237, 130 }, { 112, 245, 131 }, { 112, 253, 132 }, { 116, 237, 133 }, { 116, 241, 134 }, { 116, 249, 135 },
        { 120, 233, 136 }, { 120, 241, 137 }, { 120, 245, 138 }, { 120, 253, 139 }, { 124, 237, 140 }, { 124, 245, 141 }, { 124, 249, 142 }, { 129, 225, 143 },
        { 129, 233, 144 }, { 129, 241, 145 }, { 129, 249, 146 }, { 133, 229, 147 }, { 133, 237, 148 }, { 133, 245, 149 }, { 133, 253, 150 }, { 137, 233, 151 },
        { 137, 241, 152 }, { 137, 249, 153 }, { 141, 233, 154 }, { 141, 237, 155 }, { 141, 245, 156 }, { 141, 253, 157 }, { 145, 237, 158 }, { 145, 241, 159 },
        { 145, 249, 160 }, { 149, 233, 161 }, { 149, 241, 162 }, { 149, 245, 163 }, { 149, 253, 164 }, { 153, 237, 165 }, { 153, 245, 166 }, { 153, 249, 167 },
        { 157, 233, 168 }, { 157, 241, 169 }, { 157, 249, 170 }, { 157, 253, 171 }, { 161, 237, 172 }, { 161, 245, 173 }, { 161, 253, 174 }, { 165, 233, 175 },
        { 165, 241, 176 }, { 165, 249, 177 }, { 169, 233, 178 }, { 169, 237, 179 }, { 169, 245, 180 }, { 169, 253, 181 }, { 173, 237, 182 }, { 173, 241, 183 },
        { 173, 249, 184 }, { 177, 233, 185 }, { 177, 241, 186 }, { 177, 245, 187 }, { 177, 253, 188 }, { 181, 237, 189 }, { 181, 245, 190 }, { 181, 249, 191 },
        { 185, 233, 192 }, { 185, 241, 193 }, { 185, 249, 194 }, { 185, 253, 195 }, { 189, 237, 196 }, { 189, 245, 197 }, { 189, 253, 198 }, { 193, 233, 199 },
        { 193, 241, 200 }, { 193, 249, 201 }, { 197, 229, 202 }, { 197, 237, 203 }, { 197, 245, 204 }, { 197, 253, 205 }, { 201, 233, 206 }, { 201, 241, 207 },
        { 201, 249, 208 }, { 205, 233, 209 }, { 205, 237, 210 }, { 205, 245, 211 }, { 205, 253, 212 }, { 209, 237, 213 }, { 209, 241, 214 }, { 209, 249, 215 },
        { 213, 233, 216 }, { 213, 241, 217 }, { 213, 245, 218 }, { 213, 253, 219 }, { 217, 237, 220 }, { 217, 245, 221 }, { 217, 249, 222 }, { 221, 233, 223 },
        { 221, 241, 224 }, { 221, 249, 225 }, { 221, 253, 226 }, { 225, 237, 227 }, { 225, 245, 228 }, { 225, 253, 229 }, { 229, 233, 230 }, { 229, 241, 231 },
        { 229, 249, 232 }, { 233, 233, 233 }, { 233, 237, 234 }, { 233, 245, 235 }, { 233, 253, 236 }, { 237, 237, 237 }, { 237, 241, 238 }, { 237, 249, 239 },
        { 241, 233, 240 }, { 241, 241, 241 }, { 241, 245, 242 }, { 241, 253, 243 }, { 245, 237, 244 }, { 245, 245, 245 }, { 245, 249, 246 }, { 249, 233, 247 },
        { 249, 241, 248 }, { 249, 249, 249 }, { 249, 253, 250 }, { 253, 237, 251 }, { 253, 245, 252 }, { 253, 253, 253 }, { 253, 253, 253 }, { 253, 253, 253 },
    }
};

Table g_mode1_p0_i2=
{
    2,
    0,
    {
        { 0, 0, 0 }, { 0, 4, 1 }, { 0, 8, 2 }, { 0, 12, 3 }, { 4, 4, 4 }, { 0, 16, 5 }, { 0, 20, 6 }, { 0, 24, 7 },
        { 0, 28, 8 }, { 0, 32, 9 }, { 0, 36, 10 }, { 0, 40, 11 }, { 0, 44, 12 }, { 4, 36, 13 }, { 0, 48, 14 }, { 0, 52, 15 },
        { 0, 56, 16 }, { 0, 60, 17 }, { 0, 64, 18 }, { 0, 68, 19 }, { 0, 72, 20 }, { 0, 76, 21 }, { 4, 68, 22 }, { 0, 80, 23 },
        { 0, 84, 24 }, { 0, 88, 25 }, { 0, 92, 26 }, { 0, 96, 27 }, { 0, 100, 28 }, { 0, 104, 29 }, { 0, 108, 30 }, { 4, 100, 31 },
        { 0, 112, 32 }, { 0, 116, 33 }, { 0, 120, 34 }, { 0, 124, 35 }, { 0, 129, 36 }, { 0, 133, 37 }, { 4, 124, 38 }, { 0, 137, 39 },
        { 0, 141, 40 }, { 0, 145, 41 }, { 0, 149, 42 }, { 0, 153, 43 }, { 0, 157, 44 }, { 0, 161, 45 }, { 0, 165, 46 }, { 4, 157, 47 },
        { 0, 169, 48 }, { 0, 173, 49 }, { 0, 177, 50 }, { 0, 181, 51 }, { 0, 185, 52 }, { 0, 189, 53 }, { 0, 193, 54 }, { 0, 197, 55 },
        { 4, 189, 56 }, { 0, 201, 57 }, { 0, 205, 58 }, { 0, 209, 59 }, { 0, 213, 60 }, { 0, 217, 61 }, { 0, 221, 62 }, { 0, 225, 63 },
        { 0, 229, 64 }, { 4, 221, 65 }, { 0, 233, 66 }, { 0, 237, 67 }, { 0, 241, 68 }, { 0, 245, 69 }, { 0, 249, 70 }, { 0, 253, 71 },
        { 4, 245, 72 }, { 4, 249, 73 }, { 4, 253, 74 }, { 8, 245, 75 }, { 8, 249, 76 }, { 8, 253, 77 }, { 12, 245, 78 }, { 12, 249, 79 },
        { 12, 253, 80 }, { 20, 237, 81 }, { 16, 249, 82 }, { 16, 253, 83 }, { 20, 249, 84 }, { 24, 241, 85 }, { 20, 253, 86 }, { 24, 249, 87 },
        { 24, 253, 88 }, { 28, 245, 89 }, { 28, 249, 90 }, { 28, 253, 91 }, { 32, 245, 92 }, { 32, 249, 93 }, { 32, 253, 94 }, { 36, 245, 95 },
        { 36, 249, 96 }, { 36, 253, 97 }, { 40, 245, 98 }, { 40, 249, 99 }, { 40, 253, 100 }, { 44, 245, 101 }, { 44, 249, 102 }, { 44, 253, 103 },
        { 52, 237, 104 }, { 48, 249, 105 }, { 48, 253, 106 }, { 52, 249, 107 }, { 56, 241, 108 }, { 52, 253, 109 }, { 56, 249, 110 }, { 56, 253, 111 },
        { 60, 245, 112 }, { 60, 249, 113 }, { 60, 253, 114 }, { 64, 245, 115 }, { 64, 249, 116 }, { 64, 253, 117 }, { 68, 245, 118 }, { 68, 249, 119 },
        { 68, 253, 120 }, { 72, 245, 121 }, { 72, 249, 122 }, { 72, 253, 123 }, { 76, 245, 124 }, { 76, 249, 125 }, { 76, 253, 126 }, { 84, 237, 127 },
        { 80, 249, 128 }, { 80, 253, 129 }, { 84, 249, 130 }, { 88, 241, 131 }, { 84, 253, 132 }, { 88, 249, 133 }, { 88, 253, 134 }, { 92, 245, 135 },
        { 92, 249, 136 }, { 92, 253, 137 }, { 96, 245, 138 }, { 96, 249, 139 }, { 96, 253, 140 }, { 100, 245, 141 }, { 100, 249, 142 }, { 100, 253, 143 },
        { 104, 245, 144 }, { 104, 249, 145 }, { 104, 253, 146 }, { 108, 245, 147 }, { 108, 249, 148 }, { 108, 253, 149 }, { 116, 237, 150 }, { 112, 249, 151 },
        { 112, 253, 152 }, { 116, 249, 153 }, { 120, 241, 154 }, { 116, 253, 155 }, { 120, 249, 156 }, { 120, 253, 157 }, { 124, 245, 158 }, { 124, 249, 159 },
        { 124, 253, 160 }, { 129, 241, 161 }, { 129, 245, 162 }, { 129, 249, 163 }, { 129, 253, 164 }, { 133, 245, 165 }, { 133, 249, 166 }, { 133, 253, 167 },
        { 141, 237, 168 }, { 137, 249, 169 }, { 137, 253, 170 }, { 141, 249, 171 }, { 145, 241, 172 }, { 141, 253, 173 }, { 145, 249, 174 }, { 145, 253, 175 },
        { 149, 245, 176 }, { 149, 249, 177 }, { 149, 253, 178 }, { 153, 245, 179 }, { 153, 249, 180 }, { 153, 253, 181 }, { 157, 245, 182 }, { 157, 249, 183 },
        { 157, 253, 184 }, { 161, 245, 185 }, { 161, 249, 186 }, { 161, 253, 187 }, { 165, 245, 188 }, { 165, 249, 189 }, { 165, 253, 190 }, { 173, 237, 191 },
        { 169, 249, 192 }, { 169, 253, 193 }, { 173, 249, 194 }, { 177, 241, 195 }, { 173, 253, 196 }, { 177, 249, 197 }, { 177, 253, 198 }, { 181, 245, 199 },
        { 181, 249, 200 }, { 181, 253, 201 }, { 185, 245, 202 }, { 185, 249, 203 }, { 185, 253, 204 }, { 189, 245, 205 }, { 189, 249, 206 }, { 189, 253, 207 },
        { 193, 245, 208 }, { 193, 249, 209 }, { 193, 253, 210 }, { 197, 245, 211 }, { 197, 249, 212 }, { 197, 253, 213 }, { 205, 237, 214 }, { 201, 249, 215 },
        { 201, 253, 216 }, { 205, 249, 217 }, { 209, 241, 218 }, { 205, 253, 219 }, { 209, 249, 220 }, { 209, 253, 221 }, { 213, 245, 222 }, { 213, 249, 223 },
        { 213, 253, 224 }, { 217, 245, 225 }, { 217, 249, 226 }, { 217, 253, 227 }, { 221, 245, 228 }, { 221, 249, 229 }, { 221, 253, 230 }, { 225, 245, 231 },
        { 225, 249, 232 }, { 225, 253, 233 }, { 229, 245, 234 }, { 229, 249, 235 }, { 229, 253, 236 }, { 237, 237, 237 }, { 233, 249, 238 }, { 233, 253, 239 },
        { 237, 249, 240 }, { 241, 241, 241 }, { 237, 253, 242 }, { 241, 249, 243 }, { 241, 253, 244 }, { 245, 245, 245 }, { 245, 249, 246 }, { 245, 253, 247 },
        { 249, 245, 248 }, { 249, 249, 249 }, { 249, 253, 250 }, { 253, 245, 251 }, { 253, 249, 252 }, { 253, 253, 253 }, { 253, 253, 253 }, { 253, 253, 253 },
    }
};

Table g_mode1_p0_i3=
{
    3,
    0,
    {
        { 0, 0, 0 }, { 0, 0, 0 }, { 0, 4, 2 }, { 0, 8, 3 }, { 4, 4, 4 }, { 0, 12, 5 }, { 4, 8, 6 }, { 0, 16, 7 },
        { 0, 20, 8 }, { 4, 16, 9 }, { 0, 24, 10 }, { 4, 20, 11 }, { 0, 28, 12 }, { 8, 20, 13 }, { 0, 32, 14 }, { 0, 36, 15 },
        { 4, 32, 16 }, { 0, 40, 17 }, { 4, 36, 18 }, { 0, 44, 19 }, { 0, 48, 20 }, { 4, 44, 21 }, { 0, 52, 22 }, { 4, 48, 23 },
        { 0, 56, 24 }, { 0, 60, 25 }, { 4, 56, 26 }, { 0, 64, 27 }, { 4, 60, 28 }, { 0, 68, 29 }, { 0, 72, 30 }, { 4, 68, 31 },
        { 0, 76, 32 }, { 4, 72, 33 }, { 0, 80, 34 }, { 0, 84, 35 }, { 4, 80, 36 }, { 0, 88, 37 }, { 4, 84, 38 }, { 0, 92, 39 },
        { 8, 84, 40 }, { 0, 96, 41 }, { 0, 100, 42 }, { 4, 96, 43 }, { 0, 104, 44 }, { 4, 100, 45 }, { 0, 108, 46 }, { 0, 112, 47 },
        { 4, 108, 48 }, { 0, 116, 49 }, { 4, 112, 50 }, { 0, 120, 51 }, { 0, 124, 52 }, { 4, 120, 53 }, { 0, 129, 54 }, { 4, 124, 55 },
        { 0, 133, 56 }, { 4, 129, 57 }, { 0, 137, 58 }, { 0, 141, 59 }, { 4, 137, 60 }, { 0, 145, 61 }, { 4, 141, 62 }, { 0, 149, 63 },
        { 8, 141, 64 }, { 0, 153, 65 }, { 0, 157, 66 }, { 4, 153, 67 }, { 0, 161, 68 }, { 4, 157, 69 }, { 0, 165, 70 }, { 0, 169, 71 },
        { 4, 165, 72 }, { 0, 173, 73 }, { 4, 169, 74 }, { 0, 177, 75 }, { 0, 181, 76 }, { 4, 177, 77 }, { 0, 185, 78 }, { 4, 181, 79 },
        { 0, 189, 80 }, { 0, 193, 81 }, { 4, 189, 82 }, { 0, 197, 83 }, { 4, 193, 84 }, { 0, 201, 85 }, { 0, 205, 86 }, { 4, 201, 87 },
        { 0, 209, 88 }, { 4, 205, 89 }, { 0, 213, 90 }, { 8, 205, 91 }, { 0, 217, 92 }, { 0, 221, 93 }, { 4, 217, 94 }, { 0, 225, 95 },
        { 4, 221, 96 }, { 0, 229, 97 }, { 0, 233, 98 }, { 4, 229, 99 }, { 0, 237, 100 }, { 4, 233, 101 }, { 0, 241, 102 }, { 0, 245, 103 },
        { 4, 241, 104 }, { 0, 249, 105 }, { 4, 245, 106 }, { 0, 253, 107 }, { 8, 245, 108 }, { 4, 253, 109 }, { 8, 249, 110 }, { 8, 253, 111 },
        { 12, 249, 112 }, { 16, 245, 113 }, { 12, 253, 114 }, { 20, 245, 115 }, { 16, 253, 116 }, { 20, 249, 117 }, { 20, 253, 118 }, { 24, 249, 119 },
        { 28, 245, 120 }, { 24, 253, 121 }, { 32, 245, 122 }, { 28, 253, 123 }, { 32, 249, 124 }, { 32, 253, 125 }, { 36, 249, 126 }, { 44, 241, 127 },
        { 36, 253, 128 }, { 44, 245, 129 }, { 40, 253, 130 }, { 48, 245, 131 }, { 44, 253, 132 }, { 48, 249, 133 }, { 48, 253, 134 }, { 52, 249, 135 },
        { 56, 245, 136 }, { 52, 253, 137 }, { 60, 245, 138 }, { 56, 253, 139 }, { 60, 249, 140 }, { 60, 253, 141 }, { 64, 249, 142 }, { 68, 245, 143 },
        { 64, 253, 144 }, { 72, 245, 145 }, { 68, 253, 146 }, { 72, 249, 147 }, { 72, 253, 148 }, { 76, 249, 149 }, { 80, 245, 150 }, { 76, 253, 151 },
        { 84, 245, 152 }, { 80, 253, 153 }, { 84, 249, 154 }, { 84, 253, 155 }, { 88, 249, 156 }, { 92, 245, 157 }, { 88, 253, 158 }, { 96, 245, 159 },
        { 92, 253, 160 }, { 96, 249, 161 }, { 96, 253, 162 }, { 100, 249, 163 }, { 108, 241, 164 }, { 100, 253, 165 }, { 108, 245, 166 }, { 104, 253, 167 },
        { 112, 245, 168 }, { 108, 253, 169 }, { 112, 249, 170 }, { 112, 253, 171 }, { 116, 249, 172 }, { 120, 245, 173 }, { 116, 253, 174 }, { 124, 245, 175 },
        { 120, 253, 176 }, { 124, 249, 177 }, { 124, 253, 178 }, { 133, 241, 179 }, { 129, 249, 180 }, { 129, 253, 181 }, { 133, 249, 182 }, { 137, 245, 183 },
        { 133, 253, 184 }, { 141, 245, 185 }, { 137, 253, 186 }, { 141, 249, 187 }, { 141, 253, 188 }, { 145, 249, 189 }, { 149, 245, 190 }, { 145, 253, 191 },
        { 153, 245, 192 }, { 149, 253, 193 }, { 153, 249, 194 }, { 153, 253, 195 }, { 157, 249, 196 }, { 165, 241, 197 }, { 157, 253, 198 }, { 165, 245, 199 },
        { 161, 253, 200 }, { 169, 245, 201 }, { 165, 253, 202 }, { 169, 249, 203 }, { 169, 253, 204 }, { 173, 249, 205 }, { 177, 245, 206 }, { 173, 253, 207 },
        { 181, 245, 208 }, { 177, 253, 209 }, { 181, 249, 210 }, { 181, 253, 211 }, { 185, 249, 212 }, { 189, 245, 213 }, { 185, 253, 214 }, { 193, 245, 215 },
        { 189, 253, 216 }, { 193, 249, 217 }, { 193, 253, 218 }, { 197, 249, 219 }, { 201, 245, 220 }, { 197, 253, 221 }, { 205, 245, 222 }, { 201, 253, 223 },
        { 205, 249, 224 }, { 205, 253, 225 }, { 209, 249, 226 }, { 213, 245, 227 }, { 209, 253, 228 }, { 217, 245, 229 }, { 213, 253, 230 }, { 217, 249, 231 },
        { 217, 253, 232 }, { 221, 249, 233 }, { 229, 241, 234 }, { 221, 253, 235 }, { 229, 245, 236 }, { 225, 253, 237 }, { 233, 245, 238 }, { 229, 253, 239 },
        { 233, 249, 240 }, { 233, 253, 241 }, { 237, 249, 242 }, { 241, 245, 243 }, { 237, 253, 244 }, { 245, 245, 245 }, { 241, 253, 246 }, { 245, 249, 247 },
        { 245, 253, 248 }, { 249, 249, 249 }, { 253, 245, 250 }, { 249, 253, 251 }, { 249, 253, 251 }, { 253, 253, 253 }, { 253, 253, 253 }, { 253, 253, 253 },
    }
};

Table g_mode1_p1_i1=
{
    1,
    1,
    {
        { 2, 2, 2 }, { 2, 2, 2 }, { 2, 2, 2 }, { 2, 6, 3 }, { 2, 14, 4 }, { 2, 22, 5 }, { 2, 30, 6 }, { 2, 34, 7 },
        { 2, 42, 8 }, { 2, 50, 9 }, { 2, 58, 10 }, { 2, 66, 11 }, { 2, 70, 12 }, { 2, 78, 13 }, { 2, 86, 14 }, { 2, 94, 15 },
        { 2, 98, 16 }, { 2, 106, 17 }, { 2, 114, 18 }, { 2, 122, 19 }, { 2, 131, 20 }, { 2, 135, 21 }, { 2, 143, 22 }, { 2, 151, 23 },
        { 2, 155, 24 }, { 2, 163, 25 }, { 2, 171, 26 }, { 2, 179, 27 }, { 2, 187, 28 }, { 2, 191, 29 }, { 2, 199, 30 }, { 2, 207, 31 },
        { 2, 215, 32 }, { 2, 219, 33 }, { 2, 227, 34 }, { 2, 235, 35 }, { 2, 243, 36 }, { 2, 251, 37 }, { 2, 255, 38 }, { 6, 239, 39 },
        { 6, 247, 40 }, { 6, 255, 41 }, { 10, 235, 42 }, { 10, 243, 43 }, { 10, 251, 44 }, { 14, 231, 45 }, { 14, 239, 46 }, { 14, 247, 47 },
        { 14, 255, 48 }, { 18, 235, 49 }, { 18, 243, 50 }, { 18, 251, 51 }, { 22, 235, 52 }, { 22, 239, 53 }, { 22, 247, 54 }, { 22, 255, 55 },
        { 26, 239, 56 }, { 26, 243, 57 }, { 26, 251, 58 }, { 30, 235, 59 }, { 30, 243, 60 }, { 30, 247, 61 }, { 30, 255, 62 }, { 34, 239, 63 },
        { 34, 247, 64 }, { 34, 251, 65 }, { 38, 235, 66 }, { 38, 243, 67 }, { 38, 251, 68 }, { 38, 255, 69 }, { 42, 239, 70 }, { 42, 247, 71 },
        { 42, 255, 72 }, { 46, 235, 73 }, { 46, 243, 74 }, { 46, 251, 75 }, { 50, 235, 76 }, { 50, 239, 77 }, { 50, 247, 78 }, { 50, 255, 79 },
        { 54, 239, 80 }, { 54, 243, 81 }, { 54, 251, 82 }, { 58, 235, 83 }, { 58, 243, 84 }, { 58, 247, 85 }, { 58, 255, 86 }, { 62, 239, 87 },
        { 62, 247, 88 }, { 62, 251, 89 }, { 66, 235, 90 }, { 66, 243, 91 }, { 66, 251, 92 }, { 66, 255, 93 }, { 70, 239, 94 }, { 70, 247, 95 },
        { 70, 255, 96 }, { 74, 235, 97 }, { 74, 243, 98 }, { 74, 251, 99 }, { 78, 231, 100 }, { 78, 239, 101 }, { 78, 247, 102 }, { 78, 255, 103 },
        { 82, 235, 104 }, { 82, 243, 105 }, { 82, 251, 106 }, { 86, 235, 107 }, { 86, 239, 108 }, { 86, 247, 109 }, { 86, 255, 110 }, { 90, 239, 111 },
        { 90, 243, 112 }, { 90, 251, 113 }, { 94, 235, 114 }, { 94, 243, 115 }, { 94, 247, 116 }, { 94, 255, 117 }, { 98, 239, 118 }, { 98, 247, 119 },
        { 98, 251, 120 }, { 102, 235, 121 }, { 102, 243, 122 }, { 102, 251, 123 }, { 102, 255, 124 }, { 106, 239, 125 }, { 106, 247, 126 }, { 106, 255, 127 },
        { 110, 235, 128 }, { 110, 243, 129 }, { 110, 251, 130 }, { 114, 235, 131 }, { 114, 239, 132 }, { 114, 247, 133 }, { 114, 255, 134 }, { 118, 239, 135 },
        { 118, 243, 136 }, { 118, 251, 137 }, { 122, 235, 138 }, { 122, 243, 139 }, { 122, 247, 140 }, { 122, 255, 141 }, { 126, 239, 142 }, { 126, 247, 143 },
        { 126, 251, 144 }, { 131, 227, 145 }, { 131, 235, 146 }, { 131, 243, 147 }, { 131, 251, 148 }, { 135, 231, 149 }, { 135, 239, 150 }, { 135, 247, 151 },
        { 135, 255, 152 }, { 139, 235, 153 }, { 139, 243, 154 }, { 139, 251, 155 }, { 143, 235, 156 }, { 143, 239, 157 }, { 143, 247, 158 }, { 143, 255, 159 },
        { 147, 239, 160 }, { 147, 243, 161 }, { 147, 251, 162 }, { 151, 235, 163 }, { 151, 243, 164 }, { 151, 247, 165 }, { 151, 255, 166 }, { 155, 239, 167 },
        { 155, 247, 168 }, { 155, 251, 169 }, { 159, 235, 170 }, { 159, 243, 171 }, { 159, 251, 172 }, { 159, 255, 173 }, { 163, 239, 174 }, { 163, 247, 175 },
        { 163, 255, 176 }, { 167, 235, 177 }, { 167, 243, 178 }, { 167, 251, 179 }, { 171, 235, 180 }, { 171, 239, 181 }, { 171, 247, 182 }, { 171, 255, 183 },
        { 175, 239, 184 }, { 175, 243, 185 }, { 175, 251, 186 }, { 179, 235, 187 }, { 179, 243, 188 }, { 179, 247, 189 }, { 179, 255, 190 }, { 183, 239, 191 },
        { 183, 247, 192 }, { 183, 251, 193 }, { 187, 235, 194 }, { 187, 243, 195 }, { 187, 251, 196 }, { 187, 255, 197 }, { 191, 239, 198 }, { 191, 247, 199 },
        { 191, 255, 200 }, { 195, 235, 201 }, { 195, 243, 202 }, { 195, 251, 203 }, { 199, 231, 204 }, { 199, 239, 205 }, { 199, 247, 206 }, { 199, 255, 207 },
        { 203, 235, 208 }, { 203, 243, 209 }, { 203, 251, 210 }, { 207, 235, 211 }, { 207, 239, 212 }, { 207, 247, 213 }, { 207, 255, 214 }, { 211, 239, 215 },
        { 211, 243, 216 }, { 211, 251, 217 }, { 215, 235, 218 }, { 215, 243, 219 }, { 215, 247, 220 }, { 215, 255, 221 }, { 219, 239, 222 }, { 219, 247, 223 },
        { 219, 251, 224 }, { 223, 235, 225 }, { 223, 243, 226 }, { 223, 251, 227 }, { 223, 255, 228 }, { 227, 239, 229 }, { 227, 247, 230 }, { 227, 255, 231 },
        { 231, 235, 232 }, { 231, 243, 233 }, { 231, 251, 234 }, { 235, 235, 235 }, { 235, 239, 236 }, { 235, 247, 237 }, { 235, 255, 238 }, { 239, 239, 239 },
        { 239, 243, 240 }, { 239, 251, 241 }, { 243, 235, 242 }, { 243, 243, 243 }, { 243, 247, 244 }, { 243, 255, 245 }, { 247, 239, 246 }, { 247, 247, 247 },
        { 247, 251, 248 }, { 251, 235, 249 }, { 251, 243, 250 }, { 251, 251, 251 }, { 251, 255, 252 }, { 255, 239, 253 }, { 255, 247, 254 }, { 255, 255, 255 },
    }
};

Table g_mode1_p1_i2=
{
    2,
    1,
    {
        { 2, 2, 2 }, { 2, 2, 2 }, { 2, 2, 2 }, { 2, 6, 3 }, { 2, 10, 4 }, { 2, 14, 5 }, { 6, 6, 6 }, { 2, 18, 7 },
        { 2, 22, 8 }, { 2, 26, 9 }, { 2, 30, 10 }, { 2, 34, 11 }, { 2, 38, 12 }, { 2, 42, 13 }, { 2, 46, 14 }, { 6, 38, 15 },
        { 2, 50, 16 }, { 2, 54, 17 }, { 2, 58, 18 }, { 2, 62, 19 }, { 2, 66, 20 }, { 2, 70, 21 }, { 2, 74, 22 }, { 2, 78, 23 },
        { 6, 70, 24 }, { 2, 82, 25 }, { 2, 86, 26 }, { 2, 90, 27 }, { 2, 94, 28 }, { 2, 98, 29 }, { 2, 102, 30 }, { 2, 106, 31 },
        { 2, 110, 32 }, { 6, 102, 33 }, { 2, 114, 34 }, { 2, 118, 35 }, { 2, 122, 36 }, { 2, 126, 37 }, { 2, 131, 38 }, { 2, 135, 39 },
        { 6, 126, 40 }, { 2, 139, 41 }, { 2, 143, 42 }, { 2, 147, 43 }, { 2, 151, 44 }, { 2, 155, 45 }, { 2, 159, 46 }, { 2, 163, 47 },
        { 2, 167, 48 }, { 6, 159, 49 }, { 2, 171, 50 }, { 2, 175, 51 }, { 2, 179, 52 }, { 2, 183, 53 }, { 2, 187, 54 }, { 2, 191, 55 },
        { 2, 195, 56 }, { 2, 199, 57 }, { 6, 191, 58 }, { 2, 203, 59 }, { 2, 207, 60 }, { 2, 211, 61 }, { 2, 215, 62 }, { 2, 219, 63 },
        { 2, 223, 64 }, { 2, 227, 65 }, { 2, 231, 66 }, { 6, 223, 67 }, { 2, 235, 68 }, { 2, 239, 69 }, { 2, 243, 70 }, { 2, 247, 71 },
        { 2, 251, 72 }, { 2, 255, 73 }, { 6, 247, 74 }, { 6, 251, 75 }, { 6, 255, 76 }, { 10, 247, 77 }, { 10, 251, 78 }, { 10, 255, 79 },
        { 14, 247, 80 }, { 14, 251, 81 }, { 14, 255, 82 }, { 22, 239, 83 }, { 18, 251, 84 }, { 18, 255, 85 }, { 22, 251, 86 }, { 26, 243, 87 },
        { 22, 255, 88 }, { 26, 251, 89 }, { 26, 255, 90 }, { 30, 247, 91 }, { 30, 251, 92 }, { 30, 255, 93 }, { 34, 247, 94 }, { 34, 251, 95 },
        { 34, 255, 96 }, { 38, 247, 97 }, { 38, 251, 98 }, { 38, 255, 99 }, { 42, 247, 100 }, { 42, 251, 101 }, { 42, 255, 102 }, { 46, 247, 103 },
        { 46, 251, 104 }, { 46, 255, 105 }, { 54, 239, 106 }, { 50, 251, 107 }, { 50, 255, 108 }, { 54, 251, 109 }, { 58, 243, 110 }, { 54, 255, 111 },
        { 58, 251, 112 }, { 58, 255, 113 }, { 62, 247, 114 }, { 62, 251, 115 }, { 62, 255, 116 }, { 66, 247, 117 }, { 66, 251, 118 }, { 66, 255, 119 },
        { 70, 247, 120 }, { 70, 251, 121 }, { 70, 255, 122 }, { 74, 247, 123 }, { 74, 251, 124 }, { 74, 255, 125 }, { 78, 247, 126 }, { 78, 251, 127 },
        { 78, 255, 128 }, { 86, 239, 129 }, { 82, 251, 130 }, { 82, 255, 131 }, { 86, 251, 132 }, { 90, 243, 133 }, { 86, 255, 134 }, { 90, 251, 135 },
        { 90, 255, 136 }, { 94, 247, 137 }, { 94, 251, 138 }, { 94, 255, 139 }, { 98, 247, 140 }, { 98, 251, 141 }, { 98, 255, 142 }, { 102, 247, 143 },
        { 102, 251, 144 }, { 102, 255, 145 }, { 106, 247, 146 }, { 106, 251, 147 }, { 106, 255, 148 }, { 110, 247, 149 }, { 110, 251, 150 }, { 110, 255, 151 },
        { 118, 239, 152 }, { 114, 251, 153 }, { 114, 255, 154 }, { 118, 251, 155 }, { 122, 243, 156 }, { 118, 255, 157 }, { 122, 251, 158 }, { 122, 255, 159 },
        { 126, 247, 160 }, { 126, 251, 161 }, { 126, 255, 162 }, { 131, 243, 163 }, { 131, 247, 164 }, { 131, 251, 165 }, { 131, 255, 166 }, { 135, 247, 167 },
        { 135, 251, 168 }, { 135, 255, 169 }, { 143, 239, 170 }, { 139, 251, 171 }, { 139, 255, 172 }, { 143, 251, 173 }, { 147, 243, 174 }, { 143, 255, 175 },
        { 147, 251, 176 }, { 147, 255, 177 }, { 151, 247, 178 }, { 151, 251, 179 }, { 151, 255, 180 }, { 155, 247, 181 }, { 155, 251, 182 }, { 155, 255, 183 },
        { 159, 247, 184 }, { 159, 251, 185 }, { 159, 255, 186 }, { 163, 247, 187 }, { 163, 251, 188 }, { 163, 255, 189 }, { 167, 247, 190 }, { 167, 251, 191 },
        { 167, 255, 192 }, { 175, 239, 193 }, { 171, 251, 194 }, { 171, 255, 195 }, { 175, 251, 196 }, { 179, 243, 197 }, { 175, 255, 198 }, { 179, 251, 199 },
        { 179, 255, 200 }, { 183, 247, 201 }, { 183, 251, 202 }, { 183, 255, 203 }, { 187, 247, 204 }, { 187, 251, 205 }, { 187, 255, 206 }, { 191, 247, 207 },
        { 191, 251, 208 }, { 191, 255, 209 }, { 195, 247, 210 }, { 195, 251, 211 }, { 195, 255, 212 }, { 199, 247, 213 }, { 199, 251, 214 }, { 199, 255, 215 },
        { 207, 239, 216 }, { 203, 251, 217 }, { 203, 255, 218 }, { 207, 251, 219 }, { 211, 243, 220 }, { 207, 255, 221 }, { 211, 251, 222 }, { 211, 255, 223 },
        { 215, 247, 224 }, { 215, 251, 225 }, { 215, 255, 226 }, { 219, 247, 227 }, { 219, 251, 228 }, { 219, 255, 229 }, { 223, 247, 230 }, { 223, 251, 231 },
        { 223, 255, 232 }, { 227, 247, 233 }, { 227, 251, 234 }, { 227, 255, 235 }, { 231, 247, 236 }, { 231, 251, 237 }, { 231, 255, 238 }, { 239, 239, 239 },
        { 235, 251, 240 }, { 235, 255, 241 }, { 239, 251, 242 }, { 243, 243, 243 }, { 239, 255, 244 }, { 243, 251, 245 }, { 243, 255, 246 }, { 247, 247, 247 },
        { 247, 251, 248 }, { 247, 255, 249 }, { 251, 247, 250 }, { 251, 251, 251 }, { 251, 255, 252 }, { 255, 247, 253 }, { 255, 251, 254 }, { 255, 255, 255 },
    }
};

Table g_mode1_p1_i3=
{
    3,
    1,
    {
        { 2, 2, 2 }, { 2, 2, 2 }, { 2, 2, 2 }, { 2, 2, 2 }, { 2, 6, 4 }, { 2, 10, 5 }, { 6, 6, 6 }, { 2, 14, 7 },
        { 6, 10, 8 }, { 2, 18, 9 }, { 2, 22, 10 }, { 6, 18, 11 }, { 2, 26, 12 }, { 6, 22, 13 }, { 2, 30, 14 }, { 10, 22, 15 },
        { 2, 34, 16 }, { 2, 38, 17 }, { 6, 34, 18 }, { 2, 42, 19 }, { 6, 38, 20 }, { 2, 46, 21 }, { 2, 50, 22 }, { 6, 46, 23 },
        { 2, 54, 24 }, { 6, 50, 25 }, { 2, 58, 26 }, { 2, 62, 27 }, { 6, 58, 28 }, { 2, 66, 29 }, { 6, 62, 30 }, { 2, 70, 31 },
        { 2, 74, 32 }, { 6, 70, 33 }, { 2, 78, 34 }, { 6, 74, 35 }, { 2, 82, 36 }, { 2, 86, 37 }, { 6, 82, 38 }, { 2, 90, 39 },
        { 6, 86, 40 }, { 2, 94, 41 }, { 10, 86, 42 }, { 2, 98, 43 }, { 2, 102, 44 }, { 6, 98, 45 }, { 2, 106, 46 }, { 6, 102, 47 },
        { 2, 110, 48 }, { 2, 114, 49 }, { 6, 110, 50 }, { 2, 118, 51 }, { 6, 114, 52 }, { 2, 122, 53 }, { 2, 126, 54 }, { 6, 122, 55 },
        { 2, 131, 56 }, { 6, 126, 57 }, { 2, 135, 58 }, { 6, 131, 59 }, { 2, 139, 60 }, { 2, 143, 61 }, { 6, 139, 62 }, { 2, 147, 63 },
        { 6, 143, 64 }, { 2, 151, 65 }, { 10, 143, 66 }, { 2, 155, 67 }, { 2, 159, 68 }, { 6, 155, 69 }, { 2, 163, 70 }, { 6, 159, 71 },
        { 2, 167, 72 }, { 2, 171, 73 }, { 6, 167, 74 }, { 2, 175, 75 }, { 6, 171, 76 }, { 2, 179, 77 }, { 2, 183, 78 }, { 6, 179, 79 },
        { 2, 187, 80 }, { 6, 183, 81 }, { 2, 191, 82 }, { 2, 195, 83 }, { 6, 191, 84 }, { 2, 199, 85 }, { 6, 195, 86 }, { 2, 203, 87 },
        { 2, 207, 88 }, { 6, 203, 89 }, { 2, 211, 90 }, { 6, 207, 91 }, { 2, 215, 92 }, { 10, 207, 93 }, { 2, 219, 94 }, { 2, 223, 95 },
        { 6, 219, 96 }, { 2, 227, 97 }, { 6, 223, 98 }, { 2, 231, 99 }, { 2, 235, 100 }, { 6, 231, 101 }, { 2, 239, 102 }, { 6, 235, 103 },
        { 2, 243, 104 }, { 2, 247, 105 }, { 6, 243, 106 }, { 2, 251, 107 }, { 6, 247, 108 }, { 2, 255, 109 }, { 10, 247, 110 }, { 6, 255, 111 },
        { 10, 251, 112 }, { 10, 255, 113 }, { 14, 251, 114 }, { 18, 247, 115 }, { 14, 255, 116 }, { 22, 247, 117 }, { 18, 255, 118 }, { 22, 251, 119 },
        { 22, 255, 120 }, { 26, 251, 121 }, { 30, 247, 122 }, { 26, 255, 123 }, { 34, 247, 124 }, { 30, 255, 125 }, { 34, 251, 126 }, { 34, 255, 127 },
        { 38, 251, 128 }, { 46, 243, 129 }, { 38, 255, 130 }, { 46, 247, 131 }, { 42, 255, 132 }, { 50, 247, 133 }, { 46, 255, 134 }, { 50, 251, 135 },
        { 50, 255, 136 }, { 54, 251, 137 }, { 58, 247, 138 }, { 54, 255, 139 }, { 62, 247, 140 }, { 58, 255, 141 }, { 62, 251, 142 }, { 62, 255, 143 },
        { 66, 251, 144 }, { 70, 247, 145 }, { 66, 255, 146 }, { 74, 247, 147 }, { 70, 255, 148 }, { 74, 251, 149 }, { 74, 255, 150 }, { 78, 251, 151 },
        { 82, 247, 152 }, { 78, 255, 153 }, { 86, 247, 154 }, { 82, 255, 155 }, { 86, 251, 156 }, { 86, 255, 157 }, { 90, 251, 158 }, { 94, 247, 159 },
        { 90, 255, 160 }, { 98, 247, 161 }, { 94, 255, 162 }, { 98, 251, 163 }, { 98, 255, 164 }, { 102, 251, 165 }, { 110, 243, 166 }, { 102, 255, 167 },
        { 110, 247, 168 }, { 106, 255, 169 }, { 114, 247, 170 }, { 110, 255, 171 }, { 114, 251, 172 }, { 114, 255, 173 }, { 118, 251, 174 }, { 122, 247, 175 },
        { 118, 255, 176 }, { 126, 247, 177 }, { 122, 255, 178 }, { 126, 251, 179 }, { 126, 255, 180 }, { 135, 243, 181 }, { 131, 251, 182 }, { 131, 255, 183 },
        { 135, 251, 184 }, { 139, 247, 185 }, { 135, 255, 186 }, { 143, 247, 187 }, { 139, 255, 188 }, { 143, 251, 189 }, { 143, 255, 190 }, { 147, 251, 191 },
        { 151, 247, 192 }, { 147, 255, 193 }, { 155, 247, 194 }, { 151, 255, 195 }, { 155, 251, 196 }, { 155, 255, 197 }, { 159, 251, 198 }, { 167, 243, 199 },
        { 159, 255, 200 }, { 167, 247, 201 }, { 163, 255, 202 }, { 171, 247, 203 }, { 167, 255, 204 }, { 171, 251, 205 }, { 171, 255, 206 }, { 175, 251, 207 },
        { 179, 247, 208 }, { 175, 255, 209 }, { 183, 247, 210 }, { 179, 255, 211 }, { 183, 251, 212 }, { 183, 255, 213 }, { 187, 251, 214 }, { 191, 247, 215 },
        { 187, 255, 216 }, { 195, 247, 217 }, { 191, 255, 218 }, { 195, 251, 219 }, { 195, 255, 220 }, { 199, 251, 221 }, { 203, 247, 222 }, { 199, 255, 223 },
        { 207, 247, 224 }, { 203, 255, 225 }, { 207, 251, 226 }, { 207, 255, 227 }, { 211, 251, 228 }, { 215, 247, 229 }, { 211, 255, 230 }, { 219, 247, 231 },
        { 215, 255, 232 }, { 219, 251, 233 }, { 219, 255, 234 }, { 223, 251, 235 }, { 231, 243, 236 }, { 223, 255, 237 }, { 231, 247, 238 }, { 227, 255, 239 },
        { 235, 247, 240 }, { 231, 255, 241 }, { 235, 251, 242 }, { 235, 255, 243 }, { 239, 251, 244 }, { 243, 247, 245 }, { 239, 255, 246 }, { 247, 247, 247 },
        { 243, 255, 248 }, { 247, 251, 249 }, { 247, 255, 250 }, { 251, 251, 251 }, { 255, 247, 252 }, { 251, 255, 253 }, { 251, 255, 253 }, { 255, 255, 255 },
    }
};

Table g_mode2=
{
    1,
    0,
    {
        { 0, 0, 0 }, { 0, 0, 0 }, { 0, 8, 3 }, { 0, 8, 3 }, { 0, 8, 3 }, { 0, 16, 5 }, { 0, 16, 5 }, { 0, 24, 8 },
        { 0, 24, 8 }, { 0, 24, 8 }, { 0, 33, 11 }, { 0, 33, 11 }, { 0, 33, 11 }, { 0, 41, 13 }, { 0, 41, 13 }, { 0, 49, 16 },
        { 0, 49, 16 }, { 0, 49, 16 }, { 0, 57, 19 }, { 0, 57, 19 }, { 0, 57, 19 }, { 8, 49, 21 }, { 0, 66, 22 }, { 0, 66, 22 },
        { 0, 74, 24 }, { 33, 8, 25 }, { 0, 82, 27 }, { 0, 82, 27 }, { 41, 0, 28 }, { 16, 57, 29 }, { 0, 90, 30 }, { 0, 90, 30 },
        { 0, 99, 32 }, { 33, 33, 33 }, { 0, 107, 35 }, { 0, 107, 35 }, { 33, 41, 36 }, { 0, 115, 38 }, { 0, 115, 38 }, { 0, 115, 38 },
        { 0, 123, 40 }, { 33, 57, 41 }, { 0, 132, 43 }, { 0, 132, 43 }, { 33, 66, 44 }, { 0, 140, 46 }, { 0, 140, 46 }, { 66, 8, 47 },
        { 16, 115, 48 }, { 0, 148, 49 }, { 66, 16, 50 }, { 0, 156, 51 }, { 33, 90, 52 }, { 0, 165, 54 }, { 0, 165, 54 }, { 33, 99, 55 },
        { 24, 123, 56 }, { 0, 173, 57 }, { 66, 41, 58 }, { 0, 181, 59 }, { 8, 165, 60 }, { 74, 33, 61 }, { 0, 189, 62 }, { 33, 123, 63 },
        { 0, 198, 65 }, { 0, 198, 65 }, { 66, 66, 66 }, { 8, 189, 67 }, { 0, 206, 68 }, { 66, 74, 69 }, { 0, 214, 70 }, { 33, 148, 71 },
        { 99, 16, 72 }, { 0, 222, 73 }, { 66, 90, 74 }, { 107, 8, 75 }, { 0, 231, 76 }, { 66, 99, 77 }, { 0, 239, 78 }, { 33, 173, 79 },
        { 99, 41, 80 }, { 0, 247, 81 }, { 33, 181, 82 }, { 99, 49, 83 }, { 0, 255, 84 }, { 66, 123, 85 }, { 8, 247, 86 }, { 16, 231, 87 },
        { 66, 132, 88 }, { 8, 255, 89 }, { 33, 206, 90 }, { 99, 74, 91 }, { 16, 247, 92 }, { 41, 198, 93 }, { 16, 255, 94 }, { 24, 239, 95 },
        { 66, 156, 96 }, { 24, 247, 97 }, { 33, 231, 98 }, { 99, 99, 99 }, { 24, 255, 100 }, { 33, 239, 101 }, { 99, 107, 102 }, { 33, 247, 103 },
        { 66, 181, 104 }, { 132, 49, 105 }, { 33, 255, 106 }, { 99, 123, 107 }, { 140, 41, 108 }, { 41, 247, 109 }, { 99, 132, 110 }, { 41, 255, 111 },
        { 66, 206, 112 }, { 132, 74, 113 }, { 49, 247, 114 }, { 66, 214, 115 }, { 132, 82, 116 }, { 49, 255, 117 }, { 99, 156, 118 }, { 57, 247, 119 },
        { 66, 231, 120 }, { 99, 165, 121 }, { 57, 255, 122 }, { 66, 239, 123 }, { 132, 107, 124 }, { 66, 247, 125 }, { 74, 231, 126 }, { 140, 99, 127 },
        { 66, 255, 128 }, { 99, 189, 129 }, { 165, 57, 130 }, { 74, 247, 131 }, { 132, 132, 132 }, { 74, 255, 133 }, { 82, 239, 134 }, { 132, 140, 135 },
        { 82, 247, 136 }, { 99, 214, 137 }, { 165, 82, 138 }, { 82, 255, 139 }, { 132, 156, 140 }, { 173, 74, 141 }, { 90, 247, 142 }, { 132, 165, 143 },
        { 90, 255, 144 }, { 99, 239, 145 }, { 165, 107, 146 }, { 115, 214, 147 }, { 99, 247, 148 }, { 165, 115, 149 }, { 99, 255, 150 }, { 132, 189, 151 },
        { 198, 57, 152 }, { 107, 247, 153 }, { 132, 198, 154 }, { 123, 222, 155 }, { 107, 255, 156 }, { 165, 140, 157 }, { 115, 247, 158 }, { 132, 214, 159 },
        { 173, 132, 160 }, { 115, 255, 161 }, { 132, 222, 162 }, { 198, 90, 163 }, { 123, 247, 164 }, { 165, 165, 165 }, { 123, 255, 166 }, { 132, 239, 167 },
        { 165, 173, 168 }, { 231, 41, 169 }, { 132, 247, 170 }, { 198, 115, 171 }, { 132, 255, 172 }, { 165, 189, 173 }, { 206, 107, 174 }, { 140, 247, 175 },
        { 165, 198, 176 }, { 231, 66, 177 }, { 140, 255, 178 }, { 198, 140, 179 }, { 148, 247, 180 }, { 156, 231, 181 }, { 198, 148, 182 }, { 148, 255, 183 },
        { 165, 222, 184 }, { 231, 90, 185 }, { 156, 247, 186 }, { 165, 231, 187 }, { 156, 255, 188 }, { 165, 239, 189 }, { 198, 173, 190 }, { 165, 247, 192 },
        { 165, 247, 192 }, { 206, 165, 193 }, { 181, 222, 194 }, { 165, 255, 195 }, { 231, 123, 196 }, { 173, 247, 197 }, { 198, 198, 198 }, { 231, 132, 199 },
        { 173, 255, 200 }, { 198, 206, 201 }, { 181, 247, 203 }, { 181, 247, 203 }, { 231, 148, 204 }, { 181, 255, 205 }, { 198, 222, 206 }, { 239, 140, 207 },
        { 189, 247, 208 }, { 198, 231, 209 }, { 189, 255, 211 }, { 189, 255, 211 }, { 231, 173, 212 }, { 198, 247, 214 }, { 198, 247, 214 }, { 231, 181, 215 },
        { 198, 255, 217 }, { 198, 255, 217 }, { 198, 255, 217 }, { 206, 247, 219 }, { 214, 231, 220 }, { 206, 255, 222 }, { 206, 255, 222 }, { 231, 206, 223 },
        { 214, 247, 225 }, { 214, 247, 225 }, { 239, 198, 226 }, { 214, 255, 227 }, { 222, 239, 228 }, { 222, 239, 228 }, { 222, 247, 230 }, { 231, 231, 231 },
        { 222, 255, 233 }, { 222, 255, 233 }, { 231, 239, 234 }, { 231, 239, 234 }, { 231, 247, 236 }, { 231, 247, 236 }, { 231, 255, 239 }, { 231, 255, 239 },
        { 231, 255, 239 }, { 239, 247, 242 }, { 239, 247, 242 }, { 239, 247, 242 }, { 239, 255, 244 }, { 239, 255, 244 }, { 247, 247, 247 }, { 247, 247, 247 },
        { 247, 247, 247 }, { 247, 255, 250 }, { 247, 255, 250 }, { 247, 255, 250 }, { 255, 247, 252 }, { 255, 247, 252 }, { 255, 255, 255 }, { 255, 255, 255 },
    }
};

Table g_mode3_p0=
{
    1,
    0,
    {
        { 0, 0, 0 }, { 0, 2, 1 }, { 0, 6, 2 }, { 0, 8, 3 }, { 0, 12, 4 }, { 0, 14, 5 }, { 0, 18, 6 }, { 0, 20, 7 },
        { 0, 24, 8 }, { 0, 26, 9 }, { 0, 30, 10 }, { 0, 32, 11 }, { 0, 36, 12 }, { 0, 40, 13 }, { 0, 42, 14 }, { 0, 46, 15 },
        { 0, 48, 16 }, { 0, 52, 17 }, { 0, 54, 18 }, { 0, 58, 19 }, { 0, 60, 20 }, { 0, 64, 21 }, { 0, 66, 22 }, { 0, 70, 23 },
        { 0, 72, 24 }, { 0, 76, 25 }, { 0, 78, 26 }, { 0, 82, 27 }, { 0, 84, 28 }, { 0, 88, 29 }, { 0, 90, 30 }, { 0, 94, 31 },
        { 0, 96, 32 }, { 0, 100, 33 }, { 0, 104, 34 }, { 0, 106, 35 }, { 0, 110, 36 }, { 0, 112, 37 }, { 0, 116, 38 }, { 0, 118, 39 },
        { 0, 122, 40 }, { 0, 124, 41 }, { 0, 128, 42 }, { 0, 130, 43 }, { 0, 134, 44 }, { 0, 136, 45 }, { 0, 140, 46 }, { 0, 142, 47 },
        { 0, 146, 48 }, { 0, 148, 49 }, { 0, 152, 50 }, { 0, 154, 51 }, { 0, 158, 52 }, { 0, 160, 53 }, { 0, 164, 54 }, { 0, 168, 55 },
        { 0, 170, 56 }, { 0, 174, 57 }, { 0, 176, 58 }, { 0, 180, 59 }, { 0, 182, 60 }, { 0, 186, 61 }, { 0, 188, 62 }, { 0, 192, 63 },
        { 0, 194, 64 }, { 0, 198, 65 }, { 0, 200, 66 }, { 0, 204, 67 }, { 0, 206, 68 }, { 0, 210, 69 }, { 0, 212, 70 }, { 0, 216, 71 },
        { 0, 218, 72 }, { 0, 222, 73 }, { 0, 224, 74 }, { 0, 228, 75 }, { 0, 232, 76 }, { 0, 234, 77 }, { 0, 238, 78 }, { 0, 240, 79 },
        { 0, 244, 80 }, { 0, 246, 81 }, { 0, 250, 82 }, { 0, 252, 83 }, { 2, 252, 84 }, { 2, 254, 85 }, { 4, 254, 86 }, { 6, 252, 87 },
        { 8, 252, 88 }, { 8, 254, 89 }, { 10, 254, 90 }, { 12, 252, 91 }, { 14, 252, 92 }, { 14, 254, 93 }, { 16, 254, 94 }, { 18, 252, 95 },
        { 20, 252, 96 }, { 20, 254, 97 }, { 22, 254, 98 }, { 24, 252, 99 }, { 26, 250, 100 }, { 26, 254, 101 }, { 28, 252, 102 }, { 30, 252, 103 },
        { 30, 254, 104 }, { 32, 254, 105 }, { 34, 252, 106 }, { 36, 252, 107 }, { 36, 254, 108 }, { 38, 254, 109 }, { 40, 252, 110 }, { 42, 252, 111 },
        { 42, 254, 112 }, { 44, 254, 113 }, { 46, 252, 114 }, { 48, 252, 115 }, { 48, 254, 116 }, { 50, 254, 117 }, { 52, 252, 118 }, { 54, 252, 119 },
        { 54, 254, 120 }, { 56, 254, 121 }, { 58, 252, 122 }, { 60, 252, 123 }, { 60, 254, 124 }, { 62, 254, 125 }, { 64, 252, 126 }, { 66, 252, 127 },
        { 66, 254, 128 }, { 68, 254, 129 }, { 70, 252, 130 }, { 72, 252, 131 }, { 72, 254, 132 }, { 74, 254, 133 }, { 76, 252, 134 }, { 78, 252, 135 },
        { 78, 254, 136 }, { 80, 254, 137 }, { 82, 252, 138 }, { 84, 252, 139 }, { 84, 254, 140 }, { 86, 254, 141 }, { 88, 252, 142 }, { 90, 250, 143 },
        { 90, 254, 144 }, { 92, 252, 145 }, { 94, 252, 146 }, { 94, 254, 147 }, { 96, 254, 148 }, { 98, 252, 149 }, { 100, 252, 150 }, { 100, 254, 151 },
        { 102, 254, 152 }, { 104, 252, 153 }, { 106, 252, 154 }, { 106, 254, 155 }, { 108, 254, 156 }, { 110, 252, 157 }, { 112, 252, 158 }, { 112, 254, 159 },
        { 114, 254, 160 }, { 116, 252, 161 }, { 118, 252, 162 }, { 118, 254, 163 }, { 120, 254, 164 }, { 122, 252, 165 }, { 124, 252, 166 }, { 124, 254, 167 },
        { 126, 254, 168 }, { 128, 252, 169 }, { 130, 252, 170 }, { 130, 254, 171 }, { 132, 254, 172 }, { 134, 252, 173 }, { 136, 252, 174 }, { 136, 254, 175 },
        { 138, 254, 176 }, { 140, 252, 177 }, { 142, 252, 178 }, { 142, 254, 179 }, { 144, 254, 180 }, { 146, 252, 181 }, { 148, 252, 182 }, { 148, 254, 183 },
        { 150, 254, 184 }, { 152, 252, 185 }, { 154, 250, 186 }, { 154, 254, 187 }, { 156, 252, 188 }, { 158, 252, 189 }, { 158, 254, 190 }, { 160, 254, 191 },
        { 162, 252, 192 }, { 164, 252, 193 }, { 164, 254, 194 }, { 166, 254, 195 }, { 168, 252, 196 }, { 170, 252, 197 }, { 170, 254, 198 }, { 172, 254, 199 },
        { 174, 252, 200 }, { 176, 252, 201 }, { 176, 254, 202 }, { 178, 254, 203 }, { 180, 252, 204 }, { 182, 252, 205 }, { 182, 254, 206 }, { 184, 254, 207 },
        { 186, 252, 208 }, { 188, 252, 209 }, { 188, 254, 210 }, { 190, 254, 211 }, { 192, 252, 212 }, { 194, 252, 213 }, { 194, 254, 214 }, { 196, 254, 215 },
        { 198, 252, 216 }, { 200, 252, 217 }, { 200, 254, 218 }, { 202, 254, 219 }, { 204, 252, 220 }, { 206, 252, 221 }, { 206, 254, 222 }, { 208, 254, 223 },
        { 210, 252, 224 }, { 212, 252, 225 }, { 212, 254, 226 }, { 214, 254, 227 }, { 216, 252, 228 }, { 218, 250, 229 }, { 218, 254, 230 }, { 220, 252, 231 },
        { 222, 252, 232 }, { 222, 254, 233 }, { 224, 254, 234 }, { 226, 252, 235 }, { 228, 252, 236 }, { 228, 254, 237 }, { 230, 254, 238 }, { 232, 252, 239 },
        { 234, 252, 240 }, { 234, 254, 241 }, { 236, 254, 242 }, { 238, 252, 243 }, { 240, 252, 244 }, { 240, 254, 245 }, { 242, 254, 246 }, { 244, 252, 247 },
        { 246, 252, 248 }, { 246, 254, 249 }, { 248, 254, 250 }, { 250, 252, 251 }, { 252, 252, 252 }, { 252, 254, 253 }, { 254, 254, 254 }, { 254, 254, 254 },
    }
};

Table g_mode3_p1=
{
    1,
    1,
    {
        { 1, 1, 1 }, { 1, 1, 1 }, { 1, 3, 2 }, { 1, 7, 3 }, { 1, 9, 4 }, { 1, 13, 5 }, { 1, 15, 6 }, { 1, 19, 7 },
        { 1, 21, 8 }, { 1, 25, 9 }, { 1, 27, 10 }, { 1, 31, 11 }, { 1, 33, 12 }, { 1, 37, 13 }, { 1, 41, 14 }, { 1, 43, 15 },
        { 1, 47, 16 }, { 1, 49, 17 }, { 1, 53, 18 }, { 1, 55, 19 }, { 1, 59, 20 }, { 1, 61, 21 }, { 1, 65, 22 }, { 1, 67, 23 },
        { 1, 71, 24 }, { 1, 73, 25 }, { 1, 77, 26 }, { 1, 79, 27 }, { 1, 83, 28 }, { 1, 85, 29 }, { 1, 89, 30 }, { 1, 91, 31 },
        { 1, 95, 32 }, { 1, 97, 33 }, { 1, 101, 34 }, { 1, 105, 35 }, { 1, 107, 36 }, { 1, 111, 37 }, { 1, 113, 38 }, { 1, 117, 39 },
        { 1, 119, 40 }, { 1, 123, 41 }, { 1, 125, 42 }, { 1, 129, 43 }, { 1, 131, 44 }, { 1, 135, 45 }, { 1, 137, 46 }, { 1, 141, 47 },
        { 1, 143, 48 }, { 1, 147, 49 }, { 1, 149, 50 }, { 1, 153, 51 }, { 1, 155, 52 }, { 1, 159, 53 }, { 1, 161, 54 }, { 1, 165, 55 },
        { 1, 169, 56 }, { 1, 171, 57 }, { 1, 175, 58 }, { 1, 177, 59 }, { 1, 181, 60 }, { 1, 183, 61 }, { 1, 187, 62 }, { 1, 189, 63 },
        { 1, 193, 64 }, { 1, 195, 65 }, { 1, 199, 66 }, { 1, 201, 67 }, { 1, 205, 68 }, { 1, 207, 69 }, { 1, 211, 70 }, { 1, 213, 71 },
        { 1, 217, 72 }, { 1, 219, 73 }, { 1, 223, 74 }, { 1, 225, 75 }, { 1, 229, 76 }, { 1, 233, 77 }, { 1, 235, 78 }, { 1, 239, 79 },
        { 1, 241, 80 }, { 1, 245, 81 }, { 1, 247, 82 }, { 1, 251, 83 }, { 1, 253, 84 }, { 3, 253, 85 }, { 3, 255, 86 }, { 5, 255, 87 },
        { 7, 253, 88 }, { 9, 253, 89 }, { 9, 255, 90 }, { 11, 255, 91 }, { 13, 253, 92 }, { 15, 253, 93 }, { 15, 255, 94 }, { 17, 255, 95 },
        { 19, 253, 96 }, { 21, 253, 97 }, { 21, 255, 98 }, { 23, 255, 99 }, { 25, 253, 100 }, { 27, 251, 101 }, { 27, 255, 102 }, { 29, 253, 103 },
        { 31, 253, 104 }, { 31, 255, 105 }, { 33, 255, 106 }, { 35, 253, 107 }, { 37, 253, 108 }, { 37, 255, 109 }, { 39, 255, 110 }, { 41, 253, 111 },
        { 43, 253, 112 }, { 43, 255, 113 }, { 45, 255, 114 }, { 47, 253, 115 }, { 49, 253, 116 }, { 49, 255, 117 }, { 51, 255, 118 }, { 53, 253, 119 },
        { 55, 253, 120 }, { 55, 255, 121 }, { 57, 255, 122 }, { 59, 253, 123 }, { 61, 253, 124 }, { 61, 255, 125 }, { 63, 255, 126 }, { 65, 253, 127 },
        { 67, 253, 128 }, { 67, 255, 129 }, { 69, 255, 130 }, { 71, 253, 131 }, { 73, 253, 132 }, { 73, 255, 133 }, { 75, 255, 134 }, { 77, 253, 135 },
        { 79, 253, 136 }, { 79, 255, 137 }, { 81, 255, 138 }, { 83, 253, 139 }, { 85, 253, 140 }, { 85, 255, 141 }, { 87, 255, 142 }, { 89, 253, 143 },
        { 91, 251, 144 }, { 91, 255, 145 }, { 93, 253, 146 }, { 95, 253, 147 }, { 95, 255, 148 }, { 97, 255, 149 }, { 99, 253, 150 }, { 101, 253, 151 },
        { 101, 255, 152 }, { 103, 255, 153 }, { 105, 253, 154 }, { 107, 253, 155 }, { 107, 255, 156 }, { 109, 255, 157 }, { 111, 253, 158 }, { 113, 253, 159 },
        { 113, 255, 160 }, { 115, 255, 161 }, { 117, 253, 162 }, { 119, 253, 163 }, { 119, 255, 164 }, { 121, 255, 165 }, { 123, 253, 166 }, { 125, 253, 167 },
        { 125, 255, 168 }, { 127, 255, 169 }, { 129, 253, 170 }, { 131, 253, 171 }, { 131, 255, 172 }, { 133, 255, 173 }, { 135, 253, 174 }, { 137, 253, 175 },
        { 137, 255, 176 }, { 139, 255, 177 }, { 141, 253, 178 }, { 143, 253, 179 }, { 143, 255, 180 }, { 145, 255, 181 }, { 147, 253, 182 }, { 149, 253, 183 },
        { 149, 255, 184 }, { 151, 255, 185 }, { 153, 253, 186 }, { 155, 251, 187 }, { 155, 255, 188 }, { 157, 253, 189 }, { 159, 253, 190 }, { 159, 255, 191 },
        { 161, 255, 192 }, { 163, 253, 193 }, { 165, 253, 194 }, { 165, 255, 195 }, { 167, 255, 196 }, { 169, 253, 197 }, { 171, 253, 198 }, { 171, 255, 199 },
        { 173, 255, 200 }, { 175, 253, 201 }, { 177, 253, 202 }, { 177, 255, 203 }, { 179, 255, 204 }, { 181, 253, 205 }, { 183, 253, 206 }, { 183, 255, 207 },
        { 185, 255, 208 }, { 187, 253, 209 }, { 189, 253, 210 }, { 189, 255, 211 }, { 191, 255, 212 }, { 193, 253, 213 }, { 195, 253, 214 }, { 195, 255, 215 },
        { 197, 255, 216 }, { 199, 253, 217 }, { 201, 253, 218 }, { 201, 255, 219 }, { 203, 255, 220 }, { 205, 253, 221 }, { 207, 253, 222 }, { 207, 255, 223 },
        { 209, 255, 224 }, { 211, 253, 225 }, { 213, 253, 226 }, { 213, 255, 227 }, { 215, 255, 228 }, { 217, 253, 229 }, { 219, 251, 230 }, { 219, 255, 231 },
        { 221, 253, 232 }, { 223, 253, 233 }, { 223, 255, 234 }, { 225, 255, 235 }, { 227, 253, 236 }, { 229, 253, 237 }, { 229, 255, 238 }, { 231, 255, 239 },
        { 233, 253, 240 }, { 235, 253, 241 }, { 235, 255, 242 }, { 237, 255, 243 }, { 239, 253, 244 }, { 241, 253, 245 }, { 241, 255, 246 }, { 243, 255, 247 },
        { 245, 253, 248 }, { 247, 253, 249 }, { 247, 255, 250 }, { 249, 255, 251 }, { 251, 253, 252 }, { 253, 253, 253 }, { 253, 255, 254 }, { 255, 255, 255 },
    }
};

Table g_mode4_rgb_low=
{
    1,
    0,
    {
        { 0, 0, 0 }, { 0, 0, 0 }, { 0, 8, 3 }, { 0, 8, 3 }, { 0, 8, 3 }, { 0, 16, 5 }, { 0, 16, 5 }, { 0, 24, 8 },
        { 0, 24, 8 }, { 0, 24, 8 }, { 0, 33, 11 }, { 0, 33, 11 }, { 0, 33, 11 }, { 0, 41, 13 }, { 0, 41, 13 }, { 0, 49, 16 },
        { 0, 49, 16 }, { 0, 49, 16 }, { 0, 57, 19 }, { 0, 57, 19 }, { 0, 57, 19 }, { 8, 49, 21 }, { 0, 66, 22 }, { 0, 66, 22 },
        { 0, 74, 24 }, { 33, 8, 25 }, { 0, 82, 27 }, { 0, 82, 27 }, { 41, 0, 28 }, { 16, 57, 29 }, { 0, 90, 30 }, { 0, 90, 30 },
        { 0, 99, 32 }, { 33, 33, 33 }, { 0, 107, 35 }, { 0, 107, 35 }, { 33, 41, 36 }, { 0, 115, 38 }, { 0, 115, 38 }, { 0, 115, 38 },
        { 0, 123, 40 }, { 33, 57, 41 }, { 0, 132, 43 }, { 0, 132, 43 }, { 33, 66, 44 }, { 0, 140, 46 }, { 0, 140, 46 }, { 66, 8, 47 },
        { 16, 115, 48 }, { 0, 148, 49 }, { 66, 16, 50 }, { 0, 156, 51 }, { 33, 90, 52 }, { 0, 165, 54 }, { 0, 165, 54 }, { 33, 99, 55 },
        { 24, 123, 56 }, { 0, 173, 57 }, { 66, 41, 58 }, { 0, 181, 59 }, { 8, 165, 60 }, { 74, 33, 61 }, { 0, 189, 62 }, { 33, 123, 63 },
        { 0, 198, 65 }, { 0, 198, 65 }, { 66, 66, 66 }, { 8, 189, 67 }, { 0, 206, 68 }, { 66, 74, 69 }, { 0, 214, 70 }, { 33, 148, 71 },
        { 99, 16, 72 }, { 0, 222, 73 }, { 66, 90, 74 }, { 107, 8, 75 }, { 0, 231, 76 }, { 66, 99, 77 }, { 0, 239, 78 }, { 33, 173, 79 },
        { 99, 41, 80 }, { 0, 247, 81 }, { 33, 181, 82 }, { 99, 49, 83 }, { 0, 255, 84 }, { 66, 123, 85 }, { 8, 247, 86 }, { 16, 231, 87 },
        { 66, 132, 88 }, { 8, 255, 89 }, { 33, 206, 90 }, { 99, 74, 91 }, { 16, 247, 92 }, { 41, 198, 93 }, { 16, 255, 94 }, { 24, 239, 95 },
        { 66, 156, 96 }, { 24, 247, 97 }, { 33, 231, 98 }, { 99, 99, 99 }, { 24, 255, 100 }, { 33, 239, 101 }, { 99, 107, 102 }, { 33, 247, 103 },
        { 66, 181, 104 }, { 132, 49, 105 }, { 33, 255, 106 }, { 99, 123, 107 }, { 140, 41, 108 }, { 41, 247, 109 }, { 99, 132, 110 }, { 41, 255, 111 },
        { 66, 206, 112 }, { 132, 74, 113 }, { 49, 247, 114 }, { 66, 214, 115 }, { 132, 82, 116 }, { 49, 255, 117 }, { 99, 156, 118 }, { 57, 247, 119 },
        { 66, 231, 120 }, { 99, 165, 121 }, { 57, 255, 122 }, { 66, 239, 123 }, { 132, 107, 124 }, { 66, 247, 125 }, { 74, 231, 126 }, { 140, 99, 127 },
        { 66, 255, 128 }, { 99, 189, 129 }, { 165, 57, 130 }, { 74, 247, 131 }, { 132, 132, 132 }, { 74, 255, 133 }, { 82, 239, 134 }, { 132, 140, 135 },
        { 82, 247, 136 }, { 99, 214, 137 }, { 165, 82, 138 }, { 82, 255, 139 }, { 132, 156, 140 }, { 173, 74, 141 }, { 90, 247, 142 }, { 132, 165, 143 },
        { 90, 255, 144 }, { 99, 239, 145 }, { 165, 107, 146 }, { 115, 214, 147 }, { 99, 247, 148 }, { 165, 115, 149 }, { 99, 255, 150 }, { 132, 189, 151 },
        { 198, 57, 152 }, { 107, 247, 153 }, { 132, 198, 154 }, { 123, 222, 155 }, { 107, 255, 156 }, { 165, 140, 157 }, { 115, 247, 158 }, { 132, 214, 159 },
        { 173, 132, 160 }, { 115, 255, 161 }, { 132, 222, 162 }, { 198, 90, 163 }, { 123, 247, 164 }, { 165, 165, 165 }, { 123, 255, 166 }, { 132, 239, 167 },
        { 165, 173, 168 }, { 231, 41, 169 }, { 132, 247, 170 }, { 198, 115, 171 }, { 132, 255, 172 }, { 165, 189, 173 }, { 206, 107, 174 }, { 140, 247, 175 },
        { 165, 198, 176 }, { 231, 66, 177 }, { 140, 255, 178 }, { 198, 140, 179 }, { 148, 247, 180 }, { 156, 231, 181 }, { 198, 148, 182 }, { 148, 255, 183 },
        { 165, 222, 184 }, { 231, 90, 185 }, { 156, 247, 186 }, { 165, 231, 187 }, { 156, 255, 188 }, { 165, 239, 189 }, { 198, 173, 190 }, { 165, 247, 192 },
        { 165, 247, 192 }, { 206, 165, 193 }, { 181, 222, 194 }, { 165, 255, 195 }, { 231, 123, 196 }, { 173, 247, 197 }, { 198, 198, 198 }, { 231, 132, 199 },
        { 173, 255, 200 }, { 198, 206, 201 }, { 181, 247, 203 }, { 181, 247, 203 }, { 231, 148, 204 }, { 181, 255, 205 }, { 198, 222, 206 }, { 239, 140, 207 },
        { 189, 247, 208 }, { 198, 231, 209 }, { 189, 255, 211 }, { 189, 255, 211 }, { 231, 173, 212 }, { 198, 247, 214 }, { 198, 247, 214 }, { 231, 181, 215 },
        { 198, 255, 217 }, { 198, 255, 217 }, { 198, 255, 217 }, { 206, 247, 219 }, { 214, 231, 220 }, { 206, 255, 222 }, { 206, 255, 222 }, { 231, 206, 223 },
        { 214, 247, 225 }, { 214, 247, 225 }, { 239, 198, 226 }, { 214, 255, 227 }, { 222, 239, 228 }, { 222, 239, 228 }, { 222, 247, 230 }, { 231, 231, 231 },
        { 222, 255, 233 }, { 222, 255, 233 }, { 231, 239, 234 }, { 231, 239, 234 }, { 231, 247, 236 }, { 231, 247, 236 }, { 231, 255, 239 }, { 231, 255, 239 },
        { 231, 255, 239 }, { 239, 247, 242 }, { 239, 247, 242 }, { 239, 247, 242 }, { 239, 255, 244 }, { 239, 255, 244 }, { 247, 247, 247 }, { 247, 247, 247 },
        { 247, 247, 247 }, { 247, 255, 250 }, { 247, 255, 250 }, { 247, 255, 250 }, { 255, 247, 252 }, { 255, 247, 252 }, { 255, 255, 255 }, { 255, 255, 255 },
    }
};

Table g_mode4_rgb_high_i1=
{
    1,
    0,
    {
        { 0, 0, 0 }, { 0, 8, 1 }, { 0, 16, 2 }, { 0, 24, 3 }, { 0, 24, 3 }, { 0, 33, 5 }, { 0, 41, 6 }, { 0, 49, 7 },
        { 0, 57, 8 }, { 0, 66, 9 }, { 0, 74, 10 }, { 0, 74, 10 }, { 0, 82, 12 }, { 0, 90, 13 }, { 0, 99, 14 }, { 0, 107, 15 },
        { 0, 115, 16 }, { 0, 123, 17 }, { 8, 82, 18 }, { 0, 132, 19 }, { 0, 140, 20 }, { 0, 148, 21 }, { 0, 156, 22 }, { 0, 165, 23 },
        { 0, 173, 24 }, { 0, 181, 25 }, { 16, 90, 26 }, { 0, 189, 27 }, { 0, 198, 28 }, { 0, 206, 29 }, { 0, 214, 30 }, { 0, 222, 31 },
        { 0, 231, 32 }, { 8, 189, 33 }, { 0, 239, 34 }, { 0, 247, 35 }, { 0, 255, 36 }, { 8, 214, 37 }, { 8, 222, 38 }, { 8, 231, 39 },
        { 8, 239, 40 }, { 24, 148, 41 }, { 8, 247, 42 }, { 8, 255, 43 }, { 16, 214, 44 }, { 16, 222, 45 }, { 16, 231, 46 }, { 16, 239, 47 },
        { 16, 247, 48 }, { 33, 148, 49 }, { 16, 255, 50 }, { 24, 214, 51 }, { 24, 222, 52 }, { 24, 231, 53 }, { 24, 239, 54 }, { 24, 247, 55 },
        { 24, 255, 56 }, { 33, 206, 57 }, { 33, 214, 58 }, { 49, 123, 59 }, { 33, 222, 60 }, { 33, 231, 61 }, { 33, 239, 62 }, { 33, 247, 63 },
        { 33, 255, 64 }, { 41, 214, 65 }, { 41, 222, 66 }, { 66, 74, 67 }, { 41, 231, 68 }, { 41, 239, 69 }, { 41, 247, 70 }, { 41, 255, 71 },
        { 49, 214, 72 }, { 49, 222, 73 }, { 57, 181, 74 }, { 49, 231, 75 }, { 49, 239, 76 }, { 49, 247, 77 }, { 49, 255, 78 }, { 57, 214, 79 },
        { 57, 222, 80 }, { 57, 231, 81 }, { 66, 181, 82 }, { 57, 239, 83 }, { 57, 247, 84 }, { 57, 255, 85 }, { 66, 206, 86 }, { 66, 214, 87 },
        { 66, 222, 88 }, { 66, 231, 89 }, { 66, 239, 90 }, { 66, 247, 91 }, { 82, 156, 92 }, { 66, 255, 93 }, { 74, 214, 94 }, { 74, 222, 95 },
        { 74, 231, 96 }, { 74, 239, 97 }, { 74, 247, 98 }, { 74, 255, 99 }, { 99, 107, 100 }, { 82, 214, 101 }, { 82, 222, 102 }, { 82, 231, 103 },
        { 82, 239, 104 }, { 82, 247, 105 }, { 82, 255, 106 }, { 90, 214, 107 }, { 99, 165, 108 }, { 90, 222, 109 }, { 90, 231, 110 }, { 90, 239, 111 },
        { 90, 247, 112 }, { 90, 255, 113 }, { 99, 206, 114 }, { 99, 214, 115 }, { 99, 222, 116 }, { 107, 181, 117 }, { 99, 231, 118 }, { 99, 239, 119 },
        { 99, 247, 120 }, { 99, 255, 121 }, { 107, 214, 122 }, { 107, 222, 123 }, { 107, 231, 124 }, { 115, 189, 125 }, { 107, 239, 126 }, { 107, 247, 127 },
        { 107, 255, 128 }, { 115, 214, 129 }, { 115, 222, 130 }, { 115, 231, 131 }, { 115, 239, 132 }, { 132, 140, 133 }, { 115, 247, 134 }, { 115, 255, 135 },
        { 123, 214, 136 }, { 123, 222, 137 }, { 123, 231, 138 }, { 123, 239, 139 }, { 123, 247, 140 }, { 132, 198, 141 }, { 123, 255, 142 }, { 148, 115, 143 },
        { 132, 214, 144 }, { 132, 222, 145 }, { 132, 231, 146 }, { 132, 239, 147 }, { 132, 247, 148 }, { 132, 255, 149 }, { 140, 214, 150 }, { 156, 123, 151 },
        { 140, 222, 152 }, { 140, 231, 153 }, { 140, 239, 154 }, { 140, 247, 155 }, { 140, 255, 156 }, { 148, 214, 157 }, { 148, 222, 158 }, { 165, 123, 159 },
        { 148, 231, 160 }, { 148, 239, 161 }, { 148, 247, 162 }, { 148, 255, 163 }, { 156, 214, 164 }, { 156, 222, 165 }, { 165, 173, 166 }, { 156, 231, 167 },
        { 156, 239, 168 }, { 156, 247, 169 }, { 156, 255, 170 }, { 165, 206, 171 }, { 165, 214, 172 }, { 165, 222, 173 }, { 165, 231, 174 }, { 165, 239, 175 },
        { 181, 148, 176 }, { 165, 247, 177 }, { 165, 255, 178 }, { 173, 214, 179 }, { 173, 222, 180 }, { 173, 231, 181 }, { 173, 239, 182 }, { 173, 247, 183 },
        { 189, 156, 184 }, { 173, 255, 185 }, { 181, 214, 186 }, { 181, 222, 187 }, { 181, 231, 188 }, { 181, 239, 189 }, { 181, 247, 190 }, { 181, 255, 191 },
        { 198, 156, 192 }, { 189, 214, 193 }, { 189, 222, 194 }, { 189, 231, 195 }, { 189, 239, 196 }, { 189, 247, 197 }, { 189, 255, 198 }, { 198, 206, 199 },
        { 198, 214, 200 }, { 198, 222, 201 }, { 206, 181, 202 }, { 198, 231, 203 }, { 198, 239, 204 }, { 198, 247, 205 }, { 198, 255, 206 }, { 206, 214, 207 },
        { 206, 222, 208 }, { 214, 181, 209 }, { 206, 231, 210 }, { 206, 239, 211 }, { 206, 247, 212 }, { 206, 255, 213 }, { 214, 214, 214 }, { 214, 222, 215 },
        { 214, 231, 216 }, { 222, 189, 217 }, { 214, 239, 218 }, { 214, 247, 219 }, { 214, 255, 220 }, { 222, 214, 221 }, { 222, 222, 222 }, { 222, 231, 223 },
        { 222, 239, 224 }, { 231, 189, 225 }, { 222, 247, 226 }, { 222, 255, 227 }, { 247, 115, 228 }, { 231, 214, 229 }, { 231, 222, 230 }, { 231, 231, 231 },
        { 231, 239, 232 }, { 231, 247, 233 }, { 231, 255, 234 }, { 239, 214, 235 }, { 255, 123, 236 }, { 239, 222, 237 }, { 239, 231, 238 }, { 239, 239, 239 },
        { 239, 247, 240 }, { 239, 255, 241 }, { 247, 214, 242 }, { 247, 222, 243 }, { 247, 222, 243 }, { 247, 231, 245 }, { 247, 239, 246 }, { 247, 247, 247 },
        { 247, 255, 248 }, { 255, 214, 249 }, { 255, 222, 250 }, { 255, 222, 250 }, { 255, 231, 252 }, { 255, 239, 253 }, { 255, 247, 254 }, { 255, 255, 255 },
    }
};

Table g_mode4_rgb_high_i2=
{
    2,
    0,
    {
        { 0, 0, 0 }, { 0, 0, 0 }, { 0, 8, 2 }, { 0, 8, 2 }, { 0, 16, 5 }, { 0, 16, 5 }, { 8, 0, 6 }, { 0, 24, 7 },
        { 8, 8, 8 }, { 0, 33, 9 }, { 8, 16, 10 }, { 0, 41, 12 }, { 0, 41, 12 }, { 8, 24, 13 }, { 0, 49, 14 }, { 8, 33, 15 },
        { 0, 57, 16 }, { 8, 41, 17 }, { 16, 24, 18 }, { 0, 66, 19 }, { 8, 49, 20 }, { 0, 74, 21 }, { 8, 57, 22 }, { 0, 82, 23 },
        { 8, 66, 24 }, { 0, 90, 25 }, { 33, 8, 26 }, { 8, 74, 27 }, { 0, 99, 28 }, { 8, 82, 29 }, { 0, 107, 30 }, { 8, 90, 31 },
        { 0, 115, 32 }, { 24, 57, 33 }, { 8, 99, 34 }, { 0, 123, 35 }, { 8, 107, 36 }, { 0, 132, 37 }, { 8, 115, 38 }, { 0, 140, 39 },
        { 8, 123, 40 }, { 41, 41, 41 }, { 0, 148, 42 }, { 8, 132, 43 }, { 0, 156, 44 }, { 8, 140, 45 }, { 0, 165, 46 }, { 8, 148, 47 },
        { 41, 66, 48 }, { 0, 173, 49 }, { 8, 156, 50 }, { 0, 181, 51 }, { 8, 165, 52 }, { 0, 189, 53 }, { 8, 173, 54 }, { 16, 156, 55 },
        { 0, 198, 56 }, { 8, 181, 57 }, { 0, 206, 58 }, { 8, 189, 59 }, { 0, 214, 60 }, { 8, 198, 61 }, { 0, 222, 62 }, { 33, 140, 63 },
        { 8, 206, 64 }, { 0, 231, 65 }, { 8, 214, 66 }, { 0, 239, 67 }, { 8, 222, 68 }, { 0, 247, 69 }, { 24, 189, 70 }, { 8, 231, 71 },
        { 0, 255, 72 }, { 8, 239, 73 }, { 16, 222, 74 }, { 8, 247, 75 }, { 16, 231, 76 }, { 8, 255, 77 }, { 41, 173, 78 }, { 16, 239, 79 },
        { 24, 222, 80 }, { 16, 247, 81 }, { 24, 231, 82 }, { 16, 255, 83 }, { 24, 239, 84 }, { 41, 198, 85 }, { 33, 222, 86 }, { 24, 247, 87 },
        { 49, 189, 88 }, { 24, 255, 89 }, { 41, 214, 90 }, { 33, 239, 91 }, { 41, 222, 92 }, { 33, 247, 93 }, { 41, 231, 94 }, { 33, 255, 95 },
        { 66, 173, 96 }, { 41, 239, 97 }, { 49, 222, 98 }, { 41, 247, 99 }, { 49, 231, 100 }, { 41, 255, 101 }, { 49, 239, 102 }, { 57, 222, 103 },
        { 74, 181, 104 }, { 49, 247, 105 }, { 57, 231, 106 }, { 49, 255, 107 }, { 57, 239, 108 }, { 74, 198, 109 }, { 57, 247, 110 }, { 74, 206, 111 },
        { 66, 231, 112 }, { 57, 255, 113 }, { 107, 132, 114 }, { 66, 239, 115 }, { 74, 222, 116 }, { 66, 247, 117 }, { 74, 231, 118 }, { 66, 255, 119 },
        { 74, 239, 120 }, { 82, 222, 121 }, { 99, 181, 122 }, { 74, 247, 123 }, { 82, 231, 124 }, { 74, 255, 125 }, { 82, 239, 126 }, { 90, 222, 127 },
        { 82, 247, 128 }, { 99, 206, 129 }, { 90, 231, 130 }, { 82, 255, 131 }, { 90, 239, 132 }, { 107, 198, 133 }, { 90, 247, 134 }, { 107, 206, 135 },
        { 90, 255, 136 }, { 107, 214, 137 }, { 99, 239, 138 }, { 107, 222, 139 }, { 140, 140, 140 }, { 99, 247, 141 }, { 107, 231, 142 }, { 99, 255, 143 },
        { 107, 239, 144 }, { 115, 222, 145 }, { 107, 247, 146 }, { 140, 165, 147 }, { 115, 231, 148 }, { 107, 255, 149 }, { 115, 239, 150 }, { 123, 222, 151 },
        { 115, 247, 152 }, { 123, 231, 153 }, { 115, 255, 154 }, { 132, 214, 155 }, { 123, 239, 156 }, { 132, 222, 157 }, { 123, 247, 158 }, { 140, 206, 159 },
        { 123, 255, 160 }, { 140, 214, 161 }, { 132, 239, 162 }, { 140, 222, 163 }, { 132, 247, 164 }, { 156, 189, 165 }, { 140, 231, 166 }, { 132, 255, 167 },
        { 140, 239, 168 }, { 148, 222, 169 }, { 140, 247, 170 }, { 148, 231, 171 }, { 140, 255, 172 }, { 173, 173, 173 }, { 148, 239, 174 }, { 156, 222, 175 },
        { 148, 247, 176 }, { 156, 231, 177 }, { 148, 255, 178 }, { 156, 239, 179 }, { 173, 198, 180 }, { 165, 222, 181 }, { 156, 247, 182 }, { 181, 189, 183 },
        { 156, 255, 184 }, { 173, 214, 185 }, { 165, 239, 186 }, { 173, 222, 187 }, { 165, 247, 188 }, { 173, 231, 189 }, { 165, 255, 190 }, { 198, 173, 191 },
        { 173, 239, 192 }, { 181, 222, 193 }, { 173, 247, 194 }, { 181, 231, 195 }, { 173, 255, 196 }, { 181, 239, 197 }, { 189, 222, 198 }, { 206, 181, 199 },
        { 181, 247, 200 }, { 189, 231, 201 }, { 181, 255, 202 }, { 189, 239, 203 }, { 206, 198, 204 }, { 189, 247, 205 }, { 206, 206, 206 }, { 198, 231, 207 },
        { 189, 255, 208 }, { 239, 132, 209 }, { 198, 239, 210 }, { 206, 222, 211 }, { 198, 247, 212 }, { 206, 231, 213 }, { 198, 255, 214 }, { 206, 239, 215 },
        { 214, 222, 216 }, { 231, 181, 217 }, { 206, 247, 218 }, { 214, 231, 219 }, { 206, 255, 220 }, { 214, 239, 221 }, { 222, 222, 222 }, { 214, 247, 223 },
        { 231, 206, 224 }, { 222, 231, 225 }, { 214, 255, 226 }, { 222, 239, 227 }, { 231, 222, 228 }, { 222, 247, 229 }, { 239, 206, 230 }, { 222, 255, 231 },
        { 239, 214, 232 }, { 231, 239, 233 }, { 239, 222, 234 }, { 247, 206, 235 }, { 231, 247, 236 }, { 239, 231, 237 }, { 231, 255, 238 }, { 239, 239, 239 },
        { 247, 222, 240 }, { 239, 247, 241 }, { 239, 247, 241 }, { 247, 231, 243 }, { 239, 255, 244 }, { 247, 239, 245 }, { 255, 222, 246 }, { 247, 247, 247 },
        { 255, 231, 248 }, { 247, 255, 249 }, { 247, 255, 249 }, { 255, 239, 251 }, { 255, 239, 251 }, { 255, 247, 253 }, { 255, 247, 253 }, { 255, 255, 255 },
    }
};

Table g_mode4_rgb_high_i3=
{
    3,
    0,
    {
        { 0, 0, 0 }, { 0, 0, 0 }, { 0, 8, 3 }, { 0, 8, 3 }, { 0, 8, 3 }, { 8, 0, 5 }, { 0, 16, 7 }, { 0, 16, 7 },
        { 8, 8, 8 }, { 16, 0, 9 }, { 0, 24, 10 }, { 8, 16, 11 }, { 8, 16, 11 }, { 16, 8, 13 }, { 0, 33, 14 }, { 8, 24, 15 },
        { 16, 16, 16 }, { 0, 41, 17 }, { 0, 41, 17 }, { 8, 33, 19 }, { 0, 49, 21 }, { 0, 49, 21 }, { 8, 41, 22 }, { 16, 33, 23 },
        { 0, 57, 24 }, { 8, 49, 25 }, { 33, 16, 26 }, { 16, 41, 27 }, { 0, 66, 28 }, { 8, 57, 29 }, { 16, 49, 30 }, { 0, 74, 31 },
        { 8, 66, 32 }, { 16, 57, 33 }, { 41, 24, 34 }, { 0, 82, 35 }, { 8, 74, 36 }, { 16, 66, 37 }, { 0, 90, 38 }, { 8, 82, 39 },
        { 16, 74, 40 }, { 41, 41, 41 }, { 0, 99, 42 }, { 8, 90, 43 }, { 16, 82, 44 }, { 0, 107, 45 }, { 8, 99, 46 }, { 16, 90, 47 },
        { 24, 82, 48 }, { 0, 115, 49 }, { 8, 107, 50 }, { 16, 99, 51 }, { 0, 123, 52 }, { 8, 115, 53 }, { 16, 107, 54 }, { 41, 74, 55 },
        { 0, 132, 56 }, { 8, 123, 57 }, { 16, 115, 58 }, { 0, 140, 59 }, { 8, 132, 60 }, { 16, 123, 61 }, { 0, 148, 62 }, { 49, 82, 63 },
        { 8, 140, 64 }, { 16, 132, 65 }, { 0, 156, 66 }, { 8, 148, 67 }, { 16, 140, 68 }, { 41, 107, 69 }, { 0, 165, 70 }, { 33, 123, 71 },
        { 16, 148, 72 }, { 0, 173, 73 }, { 8, 165, 74 }, { 16, 156, 75 }, { 0, 181, 76 }, { 49, 115, 77 }, { 8, 173, 78 }, { 16, 165, 79 },
        { 0, 189, 80 }, { 8, 181, 81 }, { 16, 173, 82 }, { 24, 165, 83 }, { 0, 198, 84 }, { 33, 156, 85 }, { 16, 181, 86 }, { 0, 206, 87 },
        { 8, 198, 88 }, { 16, 189, 89 }, { 0, 214, 90 }, { 49, 148, 91 }, { 8, 206, 92 }, { 16, 198, 93 }, { 0, 222, 94 }, { 8, 214, 95 },
        { 16, 206, 96 }, { 0, 231, 97 }, { 8, 222, 98 }, { 33, 189, 99 }, { 16, 214, 100 }, { 0, 239, 101 }, { 8, 231, 102 }, { 16, 222, 103 },
        { 0, 247, 104 }, { 8, 239, 105 }, { 33, 206, 106 }, { 16, 231, 107 }, { 0, 255, 108 }, { 8, 247, 109 }, { 16, 239, 110 }, { 24, 231, 111 },
        { 8, 255, 112 }, { 16, 247, 113 }, { 41, 214, 114 }, { 24, 239, 115 }, { 57, 198, 116 }, { 16, 255, 117 }, { 24, 247, 118 }, { 49, 214, 119 },
        { 33, 239, 120 }, { 24, 255, 121 }, { 49, 222, 122 }, { 33, 247, 123 }, { 82, 181, 124 }, { 41, 239, 125 }, { 49, 231, 126 }, { 33, 255, 127 },
        { 41, 247, 128 }, { 49, 239, 129 }, { 57, 231, 130 }, { 41, 255, 131 }, { 66, 222, 132 }, { 49, 247, 133 }, { 57, 239, 134 }, { 107, 173, 135 },
        { 49, 255, 136 }, { 57, 247, 137 }, { 82, 214, 138 }, { 66, 239, 139 }, { 74, 231, 140 }, { 57, 255, 141 }, { 66, 247, 142 }, { 115, 181, 143 },
        { 74, 239, 144 }, { 82, 231, 145 }, { 66, 255, 146 }, { 74, 247, 147 }, { 82, 239, 148 }, { 90, 231, 149 }, { 74, 255, 150 }, { 99, 222, 151 },
        { 82, 247, 152 }, { 90, 239, 153 }, { 140, 173, 154 }, { 82, 255, 155 }, { 90, 247, 156 }, { 115, 214, 157 }, { 99, 239, 158 }, { 107, 231, 159 },
        { 90, 255, 160 }, { 99, 247, 161 }, { 148, 181, 162 }, { 107, 239, 163 }, { 115, 231, 164 }, { 99, 255, 165 }, { 107, 247, 166 }, { 115, 239, 167 },
        { 140, 206, 168 }, { 107, 255, 169 }, { 132, 222, 170 }, { 115, 247, 171 }, { 123, 239, 172 }, { 173, 173, 173 }, { 115, 255, 174 }, { 123, 247, 175 },
        { 148, 214, 176 }, { 132, 239, 177 }, { 140, 231, 178 }, { 123, 255, 179 }, { 156, 214, 180 }, { 132, 247, 181 }, { 140, 239, 182 }, { 148, 231, 183 },
        { 132, 255, 184 }, { 140, 247, 185 }, { 148, 239, 186 }, { 173, 206, 187 }, { 156, 231, 188 }, { 140, 255, 189 }, { 148, 247, 190 }, { 156, 239, 191 },
        { 181, 206, 192 }, { 148, 255, 193 }, { 156, 247, 194 }, { 181, 214, 195 }, { 165, 239, 196 }, { 173, 231, 197 }, { 156, 255, 198 }, { 206, 189, 199 },
        { 165, 247, 200 }, { 173, 239, 201 }, { 181, 231, 202 }, { 165, 255, 203 }, { 173, 247, 204 }, { 181, 239, 205 }, { 206, 206, 206 }, { 189, 231, 207 },
        { 173, 255, 208 }, { 181, 247, 209 }, { 189, 239, 210 }, { 214, 206, 211 }, { 181, 255, 212 }, { 189, 247, 213 }, { 214, 214, 214 }, { 198, 239, 215 },
        { 247, 173, 216 }, { 189, 255, 217 }, { 239, 189, 218 }, { 198, 247, 219 }, { 206, 239, 220 }, { 214, 231, 221 }, { 198, 255, 222 }, { 206, 247, 223 },
        { 231, 214, 224 }, { 214, 239, 225 }, { 222, 231, 226 }, { 206, 255, 227 }, { 214, 247, 228 }, { 222, 239, 229 }, { 247, 206, 230 }, { 214, 255, 231 },
        { 239, 222, 232 }, { 222, 247, 233 }, { 231, 239, 234 }, { 222, 255, 236 }, { 222, 255, 236 }, { 222, 255, 236 }, { 231, 247, 238 }, { 239, 239, 239 },
        { 247, 231, 240 }, { 231, 255, 241 }, { 239, 247, 242 }, { 239, 247, 242 }, { 247, 239, 244 }, { 255, 231, 245 }, { 239, 255, 246 }, { 247, 247, 247 },
        { 255, 239, 248 }, { 247, 255, 250 }, { 247, 255, 250 }, { 247, 255, 250 }, { 255, 247, 252 }, { 255, 247, 252 }, { 255, 255, 255 }, { 255, 255, 255 },
    }
};

Table g_mode4_a_low=
{
    1,
    0,
    {
        { 0, 0, 0 }, { 0, 4, 1 }, { 0, 4, 1 }, { 0, 8, 3 }, { 0, 12, 4 }, { 0, 16, 5 }, { 0, 16, 5 }, { 0, 20, 7 },
        { 0, 24, 8 }, { 0, 28, 9 }, { 0, 28, 9 }, { 0, 32, 11 }, { 0, 36, 12 }, { 0, 40, 13 }, { 0, 44, 14 }, { 4, 36, 15 },
        { 0, 48, 16 }, { 0, 52, 17 }, { 0, 56, 18 }, { 8, 40, 19 }, { 0, 60, 20 }, { 0, 65, 21 }, { 4, 60, 22 }, { 0, 69, 23 },
        { 0, 73, 24 }, { 0, 77, 25 }, { 12, 56, 26 }, { 0, 81, 27 }, { 0, 85, 28 }, { 0, 89, 29 }, { 16, 60, 30 }, { 0, 93, 31 },
        { 0, 97, 32 }, { 0, 101, 33 }, { 0, 105, 34 }, { 4, 97, 35 }, { 0, 109, 36 }, { 0, 113, 37 }, { 0, 117, 38 }, { 8, 101, 39 },
        { 0, 121, 40 }, { 0, 125, 41 }, { 4, 121, 42 }, { 0, 130, 43 }, { 0, 134, 44 }, { 0, 138, 45 }, { 8, 125, 46 }, { 0, 142, 47 },
        { 0, 146, 48 }, { 0, 150, 49 }, { 16, 121, 50 }, { 0, 154, 51 }, { 0, 158, 52 }, { 0, 162, 53 }, { 0, 166, 54 }, { 4, 158, 55 },
        { 0, 170, 56 }, { 0, 174, 57 }, { 0, 178, 58 }, { 8, 162, 59 }, { 0, 182, 60 }, { 0, 186, 61 }, { 0, 190, 62 }, { 12, 166, 63 },
        { 0, 195, 64 }, { 0, 199, 65 }, { 8, 186, 66 }, { 0, 203, 67 }, { 0, 207, 68 }, { 0, 211, 69 }, { 12, 190, 70 }, { 0, 215, 71 },
        { 0, 219, 72 }, { 0, 223, 73 }, { 0, 227, 74 }, { 4, 219, 75 }, { 0, 231, 76 }, { 0, 235, 77 }, { 0, 239, 78 }, { 8, 223, 79 },
        { 0, 243, 80 }, { 0, 247, 81 }, { 0, 251, 82 }, { 12, 227, 83 }, { 0, 255, 84 }, { 4, 251, 85 }, { 4, 255, 86 }, { 16, 231, 87 },
        { 8, 251, 88 }, { 8, 255, 89 }, { 12, 251, 90 }, { 20, 235, 91 }, { 12, 255, 92 }, { 16, 251, 93 }, { 16, 255, 94 }, { 24, 239, 95 },
        { 20, 251, 96 }, { 20, 255, 97 }, { 24, 251, 98 }, { 28, 243, 99 }, { 24, 255, 100 }, { 28, 251, 101 }, { 28, 255, 102 }, { 32, 247, 103 },
        { 32, 251, 104 }, { 32, 255, 105 }, { 56, 207, 106 }, { 36, 251, 107 }, { 36, 255, 108 }, { 40, 251, 109 }, { 60, 211, 110 }, { 40, 255, 111 },
        { 44, 251, 112 }, { 44, 255, 113 }, { 65, 215, 114 }, { 48, 251, 115 }, { 48, 255, 116 }, { 52, 251, 117 }, { 65, 227, 118 }, { 52, 255, 119 },
        { 56, 251, 120 }, { 56, 255, 121 }, { 65, 239, 122 }, { 60, 251, 123 }, { 60, 255, 124 }, { 65, 247, 125 }, { 65, 251, 126 }, { 65, 255, 127 },
        { 77, 231, 128 }, { 69, 251, 129 }, { 69, 255, 130 }, { 73, 251, 131 }, { 81, 235, 132 }, { 73, 255, 133 }, { 77, 251, 134 }, { 77, 255, 135 },
        { 85, 239, 136 }, { 81, 251, 137 }, { 81, 255, 138 }, { 85, 251, 139 }, { 89, 243, 140 }, { 85, 255, 141 }, { 89, 251, 142 }, { 89, 255, 143 },
        { 93, 247, 144 }, { 93, 251, 145 }, { 93, 255, 146 }, { 117, 207, 147 }, { 97, 251, 148 }, { 97, 255, 149 }, { 101, 251, 150 }, { 121, 211, 151 },
        { 101, 255, 152 }, { 105, 251, 153 }, { 105, 255, 154 }, { 125, 215, 155 }, { 109, 251, 156 }, { 109, 255, 157 }, { 113, 251, 158 }, { 130, 219, 159 },
        { 113, 255, 160 }, { 117, 251, 161 }, { 117, 255, 162 }, { 130, 231, 163 }, { 121, 251, 164 }, { 121, 255, 165 }, { 125, 251, 166 }, { 130, 243, 167 },
        { 125, 255, 168 }, { 138, 231, 169 }, { 130, 251, 170 }, { 130, 255, 171 }, { 134, 251, 172 }, { 142, 235, 173 }, { 134, 255, 174 }, { 138, 251, 175 },
        { 138, 255, 176 }, { 146, 239, 177 }, { 142, 251, 178 }, { 142, 255, 179 }, { 146, 251, 180 }, { 150, 243, 181 }, { 146, 255, 182 }, { 150, 251, 183 },
        { 150, 255, 184 }, { 154, 247, 185 }, { 154, 251, 186 }, { 154, 255, 187 }, { 178, 207, 188 }, { 158, 251, 189 }, { 158, 255, 190 }, { 162, 251, 191 },
        { 182, 211, 192 }, { 162, 255, 193 }, { 166, 251, 194 }, { 166, 255, 195 }, { 186, 215, 196 }, { 170, 251, 197 }, { 170, 255, 198 }, { 174, 251, 199 },
        { 190, 219, 200 }, { 174, 255, 201 }, { 178, 251, 202 }, { 178, 255, 203 }, { 195, 223, 204 }, { 182, 251, 205 }, { 182, 255, 206 }, { 186, 251, 207 },
        { 195, 235, 208 }, { 186, 255, 209 }, { 190, 251, 210 }, { 190, 255, 211 }, { 195, 247, 212 }, { 195, 251, 213 }, { 203, 235, 214 }, { 195, 255, 215 },
        { 199, 251, 216 }, { 199, 255, 217 }, { 207, 239, 218 }, { 203, 251, 219 }, { 203, 255, 220 }, { 207, 251, 221 }, { 211, 243, 222 }, { 207, 255, 223 },
        { 211, 251, 224 }, { 211, 255, 225 }, { 215, 247, 226 }, { 215, 251, 227 }, { 215, 255, 228 }, { 239, 207, 229 }, { 219, 251, 230 }, { 219, 255, 231 },
        { 223, 251, 232 }, { 243, 211, 233 }, { 223, 255, 234 }, { 227, 251, 235 }, { 227, 255, 236 }, { 247, 215, 237 }, { 231, 251, 238 }, { 231, 255, 239 },
        { 235, 251, 240 }, { 251, 219, 241 }, { 235, 255, 242 }, { 239, 251, 243 }, { 239, 255, 244 }, { 255, 223, 245 }, { 243, 251, 246 }, { 243, 255, 247 },
        { 247, 251, 248 }, { 247, 251, 248 }, { 247, 255, 250 }, { 251, 251, 251 }, { 251, 255, 252 }, { 251, 255, 252 }, { 255, 251, 254 }, { 255, 255, 255 },
    }
};

Table g_mode4_a_high_i1=
{
    1,
    0,
    {
        { 0, 0, 0 }, { 0, 4, 1 }, { 0, 12, 2 }, { 0, 20, 3 }, { 0, 28, 4 }, { 0, 32, 5 }, { 0, 40, 6 }, { 0, 48, 7 },
        { 0, 56, 8 }, { 0, 65, 9 }, { 0, 69, 10 }, { 0, 77, 11 }, { 0, 85, 12 }, { 0, 89, 13 }, { 0, 97, 14 }, { 0, 105, 15 },
        { 0, 113, 16 }, { 0, 121, 17 }, { 0, 125, 18 }, { 0, 134, 19 }, { 0, 142, 20 }, { 0, 146, 21 }, { 0, 154, 22 }, { 0, 162, 23 },
        { 0, 170, 24 }, { 0, 178, 25 }, { 0, 182, 26 }, { 0, 190, 27 }, { 0, 199, 28 }, { 0, 203, 29 }, { 0, 211, 30 }, { 0, 219, 31 },
        { 0, 227, 32 }, { 0, 235, 33 }, { 0, 239, 34 }, { 0, 247, 35 }, { 0, 255, 36 }, { 4, 239, 37 }, { 4, 243, 38 }, { 4, 251, 39 },
        { 8, 235, 40 }, { 8, 243, 41 }, { 8, 247, 42 }, { 8, 255, 43 }, { 12, 239, 44 }, { 12, 247, 45 }, { 12, 251, 46 }, { 16, 235, 47 },
        { 16, 243, 48 }, { 16, 251, 49 }, { 16, 255, 50 }, { 20, 239, 51 }, { 20, 247, 52 }, { 20, 255, 53 }, { 24, 235, 54 }, { 24, 243, 55 },
        { 24, 251, 56 }, { 28, 231, 57 }, { 28, 239, 58 }, { 28, 247, 59 }, { 28, 255, 60 }, { 32, 235, 61 }, { 32, 243, 62 }, { 32, 251, 63 },
        { 36, 235, 64 }, { 36, 239, 65 }, { 36, 247, 66 }, { 36, 255, 67 }, { 40, 239, 68 }, { 40, 243, 69 }, { 40, 251, 70 }, { 44, 235, 71 },
        { 44, 243, 72 }, { 44, 247, 73 }, { 44, 255, 74 }, { 48, 239, 75 }, { 48, 247, 76 }, { 48, 251, 77 }, { 52, 235, 78 }, { 52, 243, 79 },
        { 52, 251, 80 }, { 52, 255, 81 }, { 56, 239, 82 }, { 56, 247, 83 }, { 56, 255, 84 }, { 60, 235, 85 }, { 60, 243, 86 }, { 60, 251, 87 },
        { 65, 227, 88 }, { 65, 235, 89 }, { 65, 243, 90 }, { 65, 247, 91 }, { 65, 255, 92 }, { 69, 239, 93 }, { 69, 247, 94 }, { 69, 251, 95 },
        { 73, 235, 96 }, { 73, 243, 97 }, { 73, 251, 98 }, { 73, 255, 99 }, { 77, 239, 100 }, { 77, 247, 101 }, { 77, 255, 102 }, { 81, 235, 103 },
        { 81, 243, 104 }, { 81, 251, 105 }, { 85, 231, 106 }, { 85, 239, 107 }, { 85, 247, 108 }, { 85, 255, 109 }, { 89, 235, 110 }, { 89, 243, 111 },
        { 89, 251, 112 }, { 93, 235, 113 }, { 93, 239, 114 }, { 93, 247, 115 }, { 93, 255, 116 }, { 97, 239, 117 }, { 97, 243, 118 }, { 97, 251, 119 },
        { 101, 235, 120 }, { 101, 243, 121 }, { 101, 247, 122 }, { 101, 255, 123 }, { 105, 239, 124 }, { 105, 247, 125 }, { 105, 251, 126 }, { 109, 235, 127 },
        { 109, 243, 128 }, { 109, 251, 129 }, { 109, 255, 130 }, { 113, 239, 131 }, { 113, 247, 132 }, { 113, 255, 133 }, { 117, 235, 134 }, { 117, 243, 135 },
        { 117, 251, 136 }, { 121, 235, 137 }, { 121, 239, 138 }, { 121, 247, 139 }, { 121, 255, 140 }, { 125, 239, 141 }, { 125, 243, 142 }, { 125, 251, 143 },
        { 130, 227, 144 }, { 130, 235, 145 }, { 130, 243, 146 }, { 130, 251, 147 }, { 130, 255, 148 }, { 134, 239, 149 }, { 134, 247, 150 }, { 134, 255, 151 },
        { 138, 235, 152 }, { 138, 243, 153 }, { 138, 251, 154 }, { 142, 231, 155 }, { 142, 239, 156 }, { 142, 247, 157 }, { 142, 255, 158 }, { 146, 235, 159 },
        { 146, 243, 160 }, { 146, 251, 161 }, { 150, 235, 162 }, { 150, 239, 163 }, { 150, 247, 164 }, { 150, 255, 165 }, { 154, 239, 166 }, { 154, 243, 167 },
        { 154, 251, 168 }, { 158, 235, 169 }, { 158, 243, 170 }, { 158, 247, 171 }, { 158, 255, 172 }, { 162, 239, 173 }, { 162, 247, 174 }, { 162, 251, 175 },
        { 166, 235, 176 }, { 166, 243, 177 }, { 166, 251, 178 }, { 166, 255, 179 }, { 170, 239, 180 }, { 170, 247, 181 }, { 170, 255, 182 }, { 174, 235, 183 },
        { 174, 243, 184 }, { 174, 251, 185 }, { 178, 235, 186 }, { 178, 239, 187 }, { 178, 247, 188 }, { 178, 255, 189 }, { 182, 239, 190 }, { 182, 243, 191 },
        { 182, 251, 192 }, { 186, 235, 193 }, { 186, 243, 194 }, { 186, 247, 195 }, { 186, 255, 196 }, { 190, 239, 197 }, { 190, 247, 198 }, { 190, 251, 199 },
        { 195, 227, 200 }, { 195, 235, 201 }, { 195, 243, 202 }, { 195, 251, 203 }, { 199, 231, 204 }, { 199, 239, 205 }, { 199, 247, 206 }, { 199, 255, 207 },
        { 203, 235, 208 }, { 203, 243, 209 }, { 203, 251, 210 }, { 207, 235, 211 }, { 207, 239, 212 }, { 207, 247, 213 }, { 207, 255, 214 }, { 211, 239, 215 },
        { 211, 243, 216 }, { 211, 251, 217 }, { 215, 235, 218 }, { 215, 243, 219 }, { 215, 247, 220 }, { 215, 255, 221 }, { 219, 239, 222 }, { 219, 247, 223 },
        { 219, 251, 224 }, { 223, 235, 225 }, { 223, 243, 226 }, { 223, 251, 227 }, { 223, 255, 228 }, { 227, 239, 229 }, { 227, 247, 230 }, { 227, 255, 231 },
        { 231, 235, 232 }, { 231, 243, 233 }, { 231, 251, 234 }, { 235, 235, 235 }, { 235, 239, 236 }, { 235, 247, 237 }, { 235, 255, 238 }, { 239, 239, 239 },
        { 239, 243, 240 }, { 239, 251, 241 }, { 243, 235, 242 }, { 243, 243, 243 }, { 243, 247, 244 }, { 243, 255, 245 }, { 247, 239, 246 }, { 247, 247, 247 },
        { 247, 251, 248 }, { 251, 235, 249 }, { 251, 243, 250 }, { 251, 251, 251 }, { 251, 255, 252 }, { 255, 239, 253 }, { 255, 247, 254 }, { 255, 255, 255 },
    }
};

Table g_mode4_a_high_i2=
{
    2,
    0,
    {
        { 0, 0, 0 }, { 0, 4, 1 }, { 0, 8, 2 }, { 0, 12, 3 }, { 4, 4, 4 }, { 0, 16, 5 }, { 0, 20, 6 }, { 0, 24, 7 },
        { 0, 28, 8 }, { 0, 32, 9 }, { 0, 36, 10 }, { 0, 40, 11 }, { 0, 44, 12 }, { 4, 36, 13 }, { 0, 48, 14 }, { 0, 52, 15 },
        { 0, 56, 16 }, { 0, 60, 17 }, { 0, 65, 18 }, { 0, 69, 19 }, { 4, 60, 20 }, { 0, 73, 21 }, { 0, 77, 22 }, { 0, 81, 23 },
        { 0, 85, 24 }, { 0, 89, 25 }, { 0, 93, 26 }, { 0, 97, 27 }, { 0, 101, 28 }, { 4, 93, 29 }, { 0, 105, 30 }, { 0, 109, 31 },
        { 0, 113, 32 }, { 0, 117, 33 }, { 0, 121, 34 }, { 0, 125, 35 }, { 4, 117, 36 }, { 0, 130, 37 }, { 0, 134, 38 }, { 0, 138, 39 },
        { 0, 142, 40 }, { 0, 146, 41 }, { 0, 150, 42 }, { 0, 154, 43 }, { 0, 158, 44 }, { 4, 150, 45 }, { 0, 162, 46 }, { 0, 166, 47 },
        { 0, 170, 48 }, { 0, 174, 49 }, { 0, 178, 50 }, { 0, 182, 51 }, { 0, 186, 52 }, { 0, 190, 53 }, { 4, 182, 54 }, { 0, 195, 55 },
        { 0, 199, 56 }, { 0, 203, 57 }, { 0, 207, 58 }, { 0, 211, 59 }, { 0, 215, 60 }, { 4, 207, 61 }, { 0, 219, 62 }, { 0, 223, 63 },
        { 0, 227, 64 }, { 0, 231, 65 }, { 0, 235, 66 }, { 0, 239, 67 }, { 0, 243, 68 }, { 0, 247, 69 }, { 4, 239, 70 }, { 0, 251, 71 },
        { 0, 255, 72 }, { 4, 251, 73 }, { 8, 243, 74 }, { 4, 255, 75 }, { 8, 251, 76 }, { 8, 255, 77 }, { 12, 247, 78 }, { 12, 251, 79 },
        { 12, 255, 80 }, { 16, 247, 81 }, { 16, 251, 82 }, { 16, 255, 83 }, { 20, 247, 84 }, { 20, 251, 85 }, { 20, 255, 86 }, { 24, 247, 87 },
        { 24, 251, 88 }, { 24, 255, 89 }, { 28, 247, 90 }, { 28, 251, 91 }, { 28, 255, 92 }, { 36, 239, 93 }, { 32, 251, 94 }, { 32, 255, 95 },
        { 36, 251, 96 }, { 40, 243, 97 }, { 36, 255, 98 }, { 40, 251, 99 }, { 40, 255, 100 }, { 44, 247, 101 }, { 44, 251, 102 }, { 44, 255, 103 },
        { 48, 247, 104 }, { 48, 251, 105 }, { 48, 255, 106 }, { 52, 247, 107 }, { 52, 251, 108 }, { 52, 255, 109 }, { 56, 247, 110 }, { 56, 251, 111 },
        { 56, 255, 112 }, { 60, 247, 113 }, { 60, 251, 114 }, { 60, 255, 115 }, { 65, 247, 116 }, { 65, 251, 117 }, { 65, 255, 118 }, { 69, 247, 119 },
        { 69, 251, 120 }, { 69, 255, 121 }, { 73, 247, 122 }, { 73, 251, 123 }, { 73, 255, 124 }, { 77, 247, 125 }, { 77, 251, 126 }, { 77, 255, 127 },
        { 81, 247, 128 }, { 81, 251, 129 }, { 81, 255, 130 }, { 85, 247, 131 }, { 85, 251, 132 }, { 85, 255, 133 }, { 93, 239, 134 }, { 89, 251, 135 },
        { 89, 255, 136 }, { 93, 251, 137 }, { 97, 243, 138 }, { 93, 255, 139 }, { 97, 251, 140 }, { 97, 255, 141 }, { 101, 247, 142 }, { 101, 251, 143 },
        { 101, 255, 144 }, { 105, 247, 145 }, { 105, 251, 146 }, { 105, 255, 147 }, { 109, 247, 148 }, { 109, 251, 149 }, { 109, 255, 150 }, { 113, 247, 151 },
        { 113, 251, 152 }, { 113, 255, 153 }, { 117, 247, 154 }, { 117, 251, 155 }, { 117, 255, 156 }, { 125, 239, 157 }, { 121, 251, 158 }, { 121, 255, 159 },
        { 125, 251, 160 }, { 130, 239, 161 }, { 125, 255, 162 }, { 130, 247, 163 }, { 130, 251, 164 }, { 130, 255, 165 }, { 134, 247, 166 }, { 134, 251, 167 },
        { 134, 255, 168 }, { 138, 247, 169 }, { 138, 251, 170 }, { 138, 255, 171 }, { 142, 247, 172 }, { 142, 251, 173 }, { 142, 255, 174 }, { 150, 239, 175 },
        { 146, 251, 176 }, { 146, 255, 177 }, { 150, 251, 178 }, { 154, 243, 179 }, { 150, 255, 180 }, { 154, 251, 181 }, { 154, 255, 182 }, { 158, 247, 183 },
        { 158, 251, 184 }, { 158, 255, 185 }, { 162, 247, 186 }, { 162, 251, 187 }, { 162, 255, 188 }, { 166, 247, 189 }, { 166, 251, 190 }, { 166, 255, 191 },
        { 170, 247, 192 }, { 170, 251, 193 }, { 170, 255, 194 }, { 174, 247, 195 }, { 174, 251, 196 }, { 174, 255, 197 }, { 182, 239, 198 }, { 178, 251, 199 },
        { 178, 255, 200 }, { 182, 251, 201 }, { 186, 243, 202 }, { 182, 255, 203 }, { 186, 251, 204 }, { 186, 255, 205 }, { 190, 247, 206 }, { 190, 251, 207 },
        { 190, 255, 208 }, { 195, 243, 209 }, { 195, 247, 210 }, { 195, 251, 211 }, { 195, 255, 212 }, { 199, 247, 213 }, { 199, 251, 214 }, { 199, 255, 215 },
        { 207, 239, 216 }, { 203, 251, 217 }, { 203, 255, 218 }, { 207, 251, 219 }, { 211, 243, 220 }, { 207, 255, 221 }, { 211, 251, 222 }, { 211, 255, 223 },
        { 215, 247, 224 }, { 215, 251, 225 }, { 215, 255, 226 }, { 219, 247, 227 }, { 219, 251, 228 }, { 219, 255, 229 }, { 223, 247, 230 }, { 223, 251, 231 },
        { 223, 255, 232 }, { 227, 247, 233 }, { 227, 251, 234 }, { 227, 255, 235 }, { 231, 247, 236 }, { 231, 251, 237 }, { 231, 255, 238 }, { 239, 239, 239 },
        { 235, 251, 240 }, { 235, 255, 241 }, { 239, 251, 242 }, { 243, 243, 243 }, { 239, 255, 244 }, { 243, 251, 245 }, { 243, 255, 246 }, { 247, 247, 247 },
        { 247, 251, 248 }, { 247, 255, 249 }, { 251, 247, 250 }, { 251, 251, 251 }, { 251, 255, 252 }, { 255, 247, 253 }, { 255, 251, 254 }, { 255, 255, 255 },
    }
};

Table g_mode4_a_high_i3=
{
    3,
    0,
    {
        { 0, 0, 0 }, { 0, 0, 0 }, { 0, 4, 2 }, { 0, 8, 3 }, { 4, 4, 4 }, { 0, 12, 5 }, { 4, 8, 6 }, { 0, 16, 7 },
        { 0, 20, 8 }, { 4, 16, 9 }, { 0, 24, 10 }, { 4, 20, 11 }, { 0, 28, 12 }, { 8, 20, 13 }, { 0, 32, 14 }, { 0, 36, 15 },
        { 4, 32, 16 }, { 0, 40, 17 }, { 4, 36, 18 }, { 0, 44, 19 }, { 0, 48, 20 }, { 4, 44, 21 }, { 0, 52, 22 }, { 4, 48, 23 },
        { 0, 56, 24 }, { 0, 60, 25 }, { 4, 56, 26 }, { 0, 65, 27 }, { 4, 60, 28 }, { 0, 69, 29 }, { 4, 65, 30 }, { 0, 73, 31 },
        { 0, 77, 32 }, { 4, 73, 33 }, { 0, 81, 34 }, { 4, 77, 35 }, { 0, 85, 36 }, { 8, 77, 37 }, { 0, 89, 38 }, { 0, 93, 39 },
        { 4, 89, 40 }, { 0, 97, 41 }, { 4, 93, 42 }, { 0, 101, 43 }, { 0, 105, 44 }, { 4, 101, 45 }, { 0, 109, 46 }, { 4, 105, 47 },
        { 0, 113, 48 }, { 0, 117, 49 }, { 4, 113, 50 }, { 0, 121, 51 }, { 4, 117, 52 }, { 0, 125, 53 }, { 8, 117, 54 }, { 0, 130, 55 },
        { 8, 121, 56 }, { 0, 134, 57 }, { 0, 138, 58 }, { 4, 134, 59 }, { 0, 142, 60 }, { 4, 138, 61 }, { 0, 146, 62 }, { 0, 150, 63 },
        { 4, 146, 64 }, { 0, 154, 65 }, { 4, 150, 66 }, { 0, 158, 67 }, { 0, 162, 68 }, { 4, 158, 69 }, { 0, 166, 70 }, { 4, 162, 71 },
        { 0, 170, 72 }, { 0, 174, 73 }, { 4, 170, 74 }, { 0, 178, 75 }, { 4, 174, 76 }, { 0, 182, 77 }, { 0, 186, 78 }, { 4, 182, 79 },
        { 0, 190, 80 }, { 4, 186, 81 }, { 0, 195, 82 }, { 8, 186, 83 }, { 0, 199, 84 }, { 4, 195, 85 }, { 0, 203, 86 }, { 0, 207, 87 },
        { 4, 203, 88 }, { 0, 211, 89 }, { 4, 207, 90 }, { 0, 215, 91 }, { 0, 219, 92 }, { 4, 215, 93 }, { 0, 223, 94 }, { 4, 219, 95 },
        { 0, 227, 96 }, { 0, 231, 97 }, { 4, 227, 98 }, { 0, 235, 99 }, { 4, 231, 100 }, { 0, 239, 101 }, { 8, 231, 102 }, { 0, 243, 103 },
        { 0, 247, 104 }, { 4, 243, 105 }, { 0, 251, 106 }, { 4, 247, 107 }, { 0, 255, 108 }, { 8, 247, 109 }, { 4, 255, 110 }, { 8, 251, 111 },
        { 8, 255, 112 }, { 12, 251, 113 }, { 20, 243, 114 }, { 12, 255, 115 }, { 20, 247, 116 }, { 16, 255, 117 }, { 24, 247, 118 }, { 20, 255, 119 },
        { 24, 251, 120 }, { 24, 255, 121 }, { 28, 251, 122 }, { 32, 247, 123 }, { 28, 255, 124 }, { 36, 247, 125 }, { 32, 255, 126 }, { 36, 251, 127 },
        { 36, 255, 128 }, { 40, 251, 129 }, { 44, 247, 130 }, { 40, 255, 131 }, { 48, 247, 132 }, { 44, 255, 133 }, { 48, 251, 134 }, { 48, 255, 135 },
        { 52, 251, 136 }, { 56, 247, 137 }, { 52, 255, 138 }, { 60, 247, 139 }, { 56, 255, 140 }, { 60, 251, 141 }, { 60, 255, 142 }, { 65, 251, 143 },
        { 69, 247, 144 }, { 65, 255, 145 }, { 69, 251, 146 }, { 69, 255, 147 }, { 73, 251, 148 }, { 77, 247, 149 }, { 73, 255, 150 }, { 81, 247, 151 },
        { 77, 255, 152 }, { 81, 251, 153 }, { 81, 255, 154 }, { 85, 251, 155 }, { 89, 247, 156 }, { 85, 255, 157 }, { 93, 247, 158 }, { 89, 255, 159 },
        { 93, 251, 160 }, { 93, 255, 161 }, { 97, 251, 162 }, { 101, 247, 163 }, { 97, 255, 164 }, { 105, 247, 165 }, { 101, 255, 166 }, { 105, 251, 167 },
        { 105, 255, 168 }, { 109, 251, 169 }, { 113, 247, 170 }, { 109, 255, 171 }, { 117, 247, 172 }, { 113, 255, 173 }, { 117, 251, 174 }, { 117, 255, 175 },
        { 121, 251, 176 }, { 134, 235, 177 }, { 121, 255, 178 }, { 130, 247, 179 }, { 125, 255, 180 }, { 130, 251, 181 }, { 134, 247, 182 }, { 130, 255, 183 },
        { 138, 247, 184 }, { 134, 255, 185 }, { 138, 251, 186 }, { 138, 255, 187 }, { 142, 251, 188 }, { 146, 247, 189 }, { 142, 255, 190 }, { 150, 247, 191 },
        { 146, 255, 192 }, { 150, 251, 193 }, { 150, 255, 194 }, { 154, 251, 195 }, { 158, 247, 196 }, { 154, 255, 197 }, { 162, 247, 198 }, { 158, 255, 199 },
        { 162, 251, 200 }, { 162, 255, 201 }, { 166, 251, 202 }, { 174, 243, 203 }, { 166, 255, 204 }, { 174, 247, 205 }, { 170, 255, 206 }, { 178, 247, 207 },
        { 174, 255, 208 }, { 178, 251, 209 }, { 178, 255, 210 }, { 182, 251, 211 }, { 186, 247, 212 }, { 182, 255, 213 }, { 190, 247, 214 }, { 186, 255, 215 },
        { 190, 251, 216 }, { 190, 255, 217 }, { 199, 243, 218 }, { 195, 251, 219 }, { 195, 255, 220 }, { 199, 251, 221 }, { 203, 247, 222 }, { 199, 255, 223 },
        { 207, 247, 224 }, { 203, 255, 225 }, { 207, 251, 226 }, { 207, 255, 227 }, { 211, 251, 228 }, { 215, 247, 229 }, { 211, 255, 230 }, { 219, 247, 231 },
        { 215, 255, 232 }, { 219, 251, 233 }, { 219, 255, 234 }, { 223, 251, 235 }, { 231, 243, 236 }, { 223, 255, 237 }, { 231, 247, 238 }, { 227, 255, 239 },
        { 235, 247, 240 }, { 231, 255, 241 }, { 235, 251, 242 }, { 235, 255, 243 }, { 239, 251, 244 }, { 243, 247, 245 }, { 239, 255, 246 }, { 247, 247, 247 },
        { 243, 255, 248 }, { 247, 251, 249 }, { 247, 255, 250 }, { 251, 251, 251 }, { 255, 247, 252 }, { 251, 255, 253 }, { 251, 255, 253 }, { 255, 255, 255 },
    }
};

Table g_mode5_rgb_low=
{
    1,
    0,
    {
        { 0, 0, 0 }, { 0, 2, 1 }, { 0, 6, 2 }, { 0, 8, 3 }, { 0, 12, 4 }, { 0, 14, 5 }, { 0, 18, 6 }, { 0, 20, 7 },
        { 0, 24, 8 }, { 0, 26, 9 }, { 0, 30, 10 }, { 0, 32, 11 }, { 0, 36, 12 }, { 0, 40, 13 }, { 0, 42, 14 }, { 0, 46, 15 },
        { 0, 48, 16 }, { 0, 52, 17 }, { 0, 54, 18 }, { 0, 58, 19 }, { 0, 60, 20 }, { 0, 64, 21 }, { 0, 66, 22 }, { 0, 70, 23 },
        { 0, 72, 24 }, { 0, 76, 25 }, { 0, 78, 26 }, { 0, 82, 27 }, { 0, 84, 28 }, { 0, 88, 29 }, { 0, 90, 30 }, { 0, 94, 31 },
        { 0, 96, 32 }, { 0, 100, 33 }, { 0, 104, 34 }, { 0, 106, 35 }, { 0, 110, 36 }, { 0, 112, 37 }, { 0, 116, 38 }, { 0, 118, 39 },
        { 0, 122, 40 }, { 0, 124, 41 }, { 0, 129, 42 }, { 0, 131, 43 }, { 0, 133, 44 }, { 0, 137, 45 }, { 0, 139, 46 }, { 0, 143, 47 },
        { 0, 145, 48 }, { 0, 149, 49 }, { 0, 151, 50 }, { 0, 155, 51 }, { 0, 157, 52 }, { 0, 161, 53 }, { 0, 165, 54 }, { 0, 167, 55 },
        { 0, 171, 56 }, { 0, 173, 57 }, { 0, 177, 58 }, { 0, 179, 59 }, { 0, 183, 60 }, { 0, 185, 61 }, { 0, 189, 62 }, { 0, 191, 63 },
        { 0, 195, 64 }, { 0, 197, 65 }, { 0, 201, 66 }, { 0, 203, 67 }, { 0, 207, 68 }, { 0, 209, 69 }, { 0, 213, 70 }, { 0, 215, 71 },
        { 0, 219, 72 }, { 0, 221, 73 }, { 0, 225, 74 }, { 0, 229, 75 }, { 0, 231, 76 }, { 0, 235, 77 }, { 0, 237, 78 }, { 0, 241, 79 },
        { 0, 243, 80 }, { 0, 247, 81 }, { 0, 249, 82 }, { 0, 253, 83 }, { 0, 255, 84 }, { 2, 255, 85 }, { 4, 253, 86 }, { 6, 253, 87 },
        { 6, 255, 88 }, { 8, 255, 89 }, { 10, 253, 90 }, { 12, 253, 91 }, { 12, 255, 92 }, { 14, 255, 93 }, { 16, 253, 94 }, { 18, 253, 95 },
        { 18, 255, 96 }, { 20, 255, 97 }, { 22, 253, 98 }, { 24, 253, 99 }, { 24, 255, 100 }, { 26, 255, 101 }, { 28, 253, 102 }, { 30, 251, 103 },
        { 30, 255, 104 }, { 32, 253, 105 }, { 34, 253, 106 }, { 34, 255, 107 }, { 36, 255, 108 }, { 38, 253, 109 }, { 40, 253, 110 }, { 40, 255, 111 },
        { 42, 255, 112 }, { 44, 253, 113 }, { 46, 253, 114 }, { 46, 255, 115 }, { 48, 255, 116 }, { 50, 253, 117 }, { 52, 253, 118 }, { 52, 255, 119 },
        { 54, 255, 120 }, { 56, 253, 121 }, { 58, 253, 122 }, { 58, 255, 123 }, { 60, 255, 124 }, { 62, 253, 125 }, { 64, 253, 126 }, { 64, 255, 127 },
        { 66, 255, 128 }, { 68, 253, 129 }, { 70, 253, 130 }, { 70, 255, 131 }, { 72, 255, 132 }, { 74, 253, 133 }, { 76, 253, 134 }, { 76, 255, 135 },
        { 78, 255, 136 }, { 80, 253, 137 }, { 82, 253, 138 }, { 82, 255, 139 }, { 84, 255, 140 }, { 86, 253, 141 }, { 88, 253, 142 }, { 88, 255, 143 },
        { 90, 255, 144 }, { 92, 253, 145 }, { 94, 251, 146 }, { 94, 255, 147 }, { 96, 253, 148 }, { 98, 253, 149 }, { 98, 255, 150 }, { 100, 255, 151 },
        { 102, 253, 152 }, { 104, 253, 153 }, { 104, 255, 154 }, { 106, 255, 155 }, { 108, 253, 156 }, { 110, 253, 157 }, { 110, 255, 158 }, { 112, 255, 159 },
        { 114, 253, 160 }, { 116, 253, 161 }, { 116, 255, 162 }, { 118, 255, 163 }, { 120, 253, 164 }, { 122, 253, 165 }, { 122, 255, 166 }, { 124, 255, 167 },
        { 126, 253, 168 }, { 129, 251, 169 }, { 129, 253, 170 }, { 131, 253, 171 }, { 131, 255, 172 }, { 133, 255, 173 }, { 135, 253, 174 }, { 137, 253, 175 },
        { 137, 255, 176 }, { 139, 255, 177 }, { 141, 253, 178 }, { 143, 253, 179 }, { 143, 255, 180 }, { 145, 255, 181 }, { 147, 253, 182 }, { 149, 253, 183 },
        { 149, 255, 184 }, { 151, 255, 185 }, { 153, 253, 186 }, { 155, 251, 187 }, { 155, 255, 188 }, { 157, 253, 189 }, { 159, 253, 190 }, { 159, 255, 191 },
        { 161, 255, 192 }, { 163, 253, 193 }, { 165, 253, 194 }, { 165, 255, 195 }, { 167, 255, 196 }, { 169, 253, 197 }, { 171, 253, 198 }, { 171, 255, 199 },
        { 173, 255, 200 }, { 175, 253, 201 }, { 177, 253, 202 }, { 177, 255, 203 }, { 179, 255, 204 }, { 181, 253, 205 }, { 183, 253, 206 }, { 183, 255, 207 },
        { 185, 255, 208 }, { 187, 253, 209 }, { 189, 253, 210 }, { 189, 255, 211 }, { 191, 255, 212 }, { 193, 253, 213 }, { 195, 253, 214 }, { 195, 255, 215 },
        { 197, 255, 216 }, { 199, 253, 217 }, { 201, 253, 218 }, { 201, 255, 219 }, { 203, 255, 220 }, { 205, 253, 221 }, { 207, 253, 222 }, { 207, 255, 223 },
        { 209, 255, 224 }, { 211, 253, 225 }, { 213, 253, 226 }, { 213, 255, 227 }, { 215, 255, 228 }, { 217, 253, 229 }, { 219, 251, 230 }, { 219, 255, 231 },
        { 221, 253, 232 }, { 223, 253, 233 }, { 223, 255, 234 }, { 225, 255, 235 }, { 227, 253, 236 }, { 229, 253, 237 }, { 229, 255, 238 }, { 231, 255, 239 },
        { 233, 253, 240 }, { 235, 253, 241 }, { 235, 255, 242 }, { 237, 255, 243 }, { 239, 253, 244 }, { 241, 253, 245 }, { 241, 255, 246 }, { 243, 255, 247 },
        { 245, 253, 248 }, { 247, 253, 249 }, { 247, 255, 250 }, { 249, 255, 251 }, { 251, 253, 252 }, { 253, 253, 253 }, { 253, 255, 254 }, { 255, 255, 255 },
    }
};

Table g_mode6_p0_i1=
{
    1,
    0,
    {
        { 0, 0, 0 }, { 0, 8, 1 }, { 0, 24, 2 }, { 0, 40, 3 }, { 0, 56, 4 }, { 0, 72, 5 }, { 0, 88, 6 }, { 0, 104, 7 },
        { 0, 120, 8 }, { 0, 136, 9 }, { 0, 152, 10 }, { 0, 168, 11 }, { 0, 184, 12 }, { 0, 200, 13 }, { 0, 216, 14 }, { 0, 232, 15 },
        { 0, 248, 16 }, { 2, 234, 17 }, { 2, 250, 18 }, { 4, 236, 19 }, { 4, 252, 20 }, { 6, 238, 21 }, { 6, 254, 22 }, { 8, 240, 23 },
        { 10, 226, 24 }, { 10, 242, 25 }, { 12, 228, 26 }, { 12, 244, 27 }, { 14, 230, 28 }, { 14, 246, 29 }, { 16, 232, 30 }, { 16, 248, 31 },
        { 18, 234, 32 }, { 18, 250, 33 }, { 20, 236, 34 }, { 20, 252, 35 }, { 22, 238, 36 }, { 22, 254, 37 }, { 24, 240, 38 }, { 26, 226, 39 },
        { 26, 242, 40 }, { 28, 228, 41 }, { 28, 244, 42 }, { 30, 230, 43 }, { 30, 246, 44 }, { 32, 232, 45 }, { 32, 248, 46 }, { 34, 234, 47 },
        { 34, 250, 48 }, { 36, 236, 49 }, { 36, 252, 50 }, { 38, 238, 51 }, { 38, 254, 52 }, { 40, 240, 53 }, { 42, 226, 54 }, { 42, 242, 55 },
        { 44, 228, 56 }, { 44, 244, 57 }, { 46, 230, 58 }, { 46, 246, 59 }, { 48, 232, 60 }, { 48, 248, 61 }, { 50, 234, 62 }, { 50, 250, 63 },
        { 52, 236, 64 }, { 52, 252, 65 }, { 54, 238, 66 }, { 54, 254, 67 }, { 56, 240, 68 }, { 58, 226, 69 }, { 58, 242, 70 }, { 60, 228, 71 },
        { 60, 244, 72 }, { 62, 230, 73 }, { 62, 246, 74 }, { 64, 232, 75 }, { 64, 248, 76 }, { 66, 234, 77 }, { 66, 250, 78 }, { 68, 236, 79 },
        { 68, 252, 80 }, { 70, 238, 81 }, { 70, 254, 82 }, { 72, 240, 83 }, { 74, 226, 84 }, { 74, 242, 85 }, { 76, 228, 86 }, { 76, 244, 87 },
        { 78, 230, 88 }, { 78, 246, 89 }, { 80, 232, 90 }, { 80, 248, 91 }, { 82, 234, 92 }, { 82, 250, 93 }, { 84, 236, 94 }, { 84, 252, 95 },
        { 86, 238, 96 }, { 86, 254, 97 }, { 88, 240, 98 }, { 90, 226, 99 }, { 90, 242, 100 }, { 92, 228, 101 }, { 92, 244, 102 }, { 94, 230, 103 },
        { 94, 246, 104 }, { 96, 232, 105 }, { 96, 248, 106 }, { 98, 234, 107 }, { 98, 250, 108 }, { 100, 236, 109 }, { 100, 252, 110 }, { 102, 238, 111 },
        { 102, 254, 112 }, { 104, 240, 113 }, { 106, 226, 114 }, { 106, 242, 115 }, { 108, 228, 116 }, { 108, 244, 117 }, { 110, 230, 118 }, { 110, 246, 119 },
        { 112, 232, 120 }, { 112, 248, 121 }, { 114, 234, 122 }, { 114, 250, 123 }, { 116, 236, 124 }, { 116, 252, 125 }, { 118, 238, 126 }, { 118, 254, 127 },
        { 120, 240, 128 }, { 122, 226, 129 }, { 122, 242, 130 }, { 124, 228, 131 }, { 124, 244, 132 }, { 126, 230, 133 }, { 126, 246, 134 }, { 128, 232, 135 },
        { 128, 248, 136 }, { 130, 234, 137 }, { 130, 250, 138 }, { 132, 236, 139 }, { 132, 252, 140 }, { 134, 238, 141 }, { 134, 254, 142 }, { 136, 240, 143 },
        { 138, 226, 144 }, { 138, 242, 145 }, { 140, 228, 146 }, { 140, 244, 147 }, { 142, 230, 148 }, { 142, 246, 149 }, { 144, 232, 150 }, { 144, 248, 151 },
        { 146, 234, 152 }, { 146, 250, 153 }, { 148, 236, 154 }, { 148, 252, 155 }, { 150, 238, 156 }, { 150, 254, 157 }, { 152, 240, 158 }, { 154, 226, 159 },
        { 154, 242, 160 }, { 156, 228, 161 }, { 156, 244, 162 }, { 158, 230, 163 }, { 158, 246, 164 }, { 160, 232, 165 }, { 160, 248, 166 }, { 162, 234, 167 },
        { 162, 250, 168 }, { 164, 236, 169 }, { 164, 252, 170 }, { 166, 238, 171 }, { 166, 254, 172 }, { 168, 240, 173 }, { 170, 226, 174 }, { 170, 242, 175 },
        { 172, 228, 176 }, { 172, 244, 177 }, { 174, 230, 178 }, { 174, 246, 179 }, { 176, 232, 180 }, { 176, 248, 181 }, { 178, 234, 182 }, { 178, 250, 183 },
        { 180, 236, 184 }, { 180, 252, 185 }, { 182, 238, 186 }, { 182, 254, 187 }, { 184, 240, 188 }, { 186, 226, 189 }, { 186, 242, 190 }, { 188, 228, 191 },
        { 188, 244, 192 }, { 190, 230, 193 }, { 190, 246, 194 }, { 192, 232, 195 }, { 192, 248, 196 }, { 194, 234, 197 }, { 194, 250, 198 }, { 196, 236, 199 },
        { 196, 252, 200 }, { 198, 238, 201 }, { 198, 254, 202 }, { 200, 240, 203 }, { 202, 226, 204 }, { 202, 242, 205 }, { 204, 228, 206 }, { 204, 244, 207 },
        { 206, 230, 208 }, { 206, 246, 209 }, { 208, 232, 210 }, { 208, 248, 211 }, { 210, 234, 212 }, { 210, 250, 213 }, { 212, 236, 214 }, { 212, 252, 215 },
        { 214, 238, 216 }, { 214, 254, 217 }, { 216, 240, 218 }, { 218, 226, 219 }, { 218, 242, 220 }, { 220, 228, 221 }, { 220, 244, 222 }, { 222, 230, 223 },
        { 222, 246, 224 }, { 224, 232, 225 }, { 224, 248, 226 }, { 226, 234, 227 }, { 226, 250, 228 }, { 228, 236, 229 }, { 228, 252, 230 }, { 230, 238, 231 },
        { 230, 254, 232 }, { 232, 240, 233 }, { 234, 226, 234 }, { 234, 242, 235 }, { 236, 228, 236 }, { 236, 244, 237 }, { 238, 230, 238 }, { 238, 246, 239 },
        { 240, 232, 240 }, { 240, 248, 241 }, { 242, 234, 242 }, { 242, 250, 243 }, { 244, 236, 244 }, { 244, 252, 245 }, { 246, 238, 246 }, { 246, 254, 247 },
        { 248, 240, 248 }, { 250, 226, 249 }, { 250, 242, 250 }, { 252, 228, 251 }, { 252, 244, 252 }, { 254, 230, 253 }, { 254, 246, 254 }, { 254, 246, 254 },
    }
};

Table g_mode6_p0_i2=
{
    2,
    0,
    {
        { 0, 0, 0 }, { 0, 4, 1 }, { 0, 12, 2 }, { 0, 18, 3 }, { 0, 26, 4 }, { 0, 32, 5 }, { 0, 40, 6 }, { 0, 48, 7 },
        { 0, 54, 8 }, { 0, 62, 9 }, { 0, 68, 10 }, { 0, 76, 11 }, { 0, 82, 12 }, { 0, 90, 13 }, { 0, 96, 14 }, { 0, 104, 15 },
        { 0, 112, 16 }, { 0, 118, 17 }, { 0, 126, 18 }, { 0, 132, 19 }, { 0, 140, 20 }, { 0, 146, 21 }, { 0, 154, 22 }, { 0, 160, 23 },
        { 0, 168, 24 }, { 0, 176, 25 }, { 0, 182, 26 }, { 0, 190, 27 }, { 0, 196, 28 }, { 0, 204, 29 }, { 0, 210, 30 }, { 0, 218, 31 },
        { 0, 224, 32 }, { 0, 232, 33 }, { 0, 240, 34 }, { 0, 246, 35 }, { 0, 254, 36 }, { 2, 248, 37 }, { 4, 244, 38 }, { 4, 250, 39 },
        { 6, 246, 40 }, { 6, 252, 41 }, { 8, 248, 42 }, { 8, 254, 43 }, { 10, 250, 44 }, { 12, 244, 45 }, { 12, 252, 46 }, { 14, 246, 47 },
        { 14, 254, 48 }, { 16, 248, 49 }, { 18, 242, 50 }, { 18, 250, 51 }, { 20, 244, 52 }, { 20, 252, 53 }, { 22, 246, 54 }, { 22, 254, 55 },
        { 24, 248, 56 }, { 26, 244, 57 }, { 26, 250, 58 }, { 28, 246, 59 }, { 28, 252, 60 }, { 30, 248, 61 }, { 30, 254, 62 }, { 32, 250, 63 },
        { 34, 244, 64 }, { 34, 252, 65 }, { 36, 246, 66 }, { 36, 254, 67 }, { 38, 248, 68 }, { 40, 244, 69 }, { 40, 250, 70 }, { 42, 246, 71 },
        { 42, 252, 72 }, { 44, 248, 73 }, { 44, 254, 74 }, { 46, 250, 75 }, { 48, 244, 76 }, { 48, 252, 77 }, { 50, 246, 78 }, { 50, 254, 79 },
        { 52, 248, 80 }, { 54, 244, 81 }, { 54, 250, 82 }, { 56, 246, 83 }, { 56, 252, 84 }, { 58, 248, 85 }, { 58, 254, 86 }, { 60, 250, 87 },
        { 62, 244, 88 }, { 62, 252, 89 }, { 64, 246, 90 }, { 64, 254, 91 }, { 66, 248, 92 }, { 68, 244, 93 }, { 68, 250, 94 }, { 70, 246, 95 },
        { 70, 252, 96 }, { 72, 248, 97 }, { 72, 254, 98 }, { 74, 250, 99 }, { 76, 244, 100 }, { 76, 252, 101 }, { 78, 246, 102 }, { 78, 254, 103 },
        { 80, 248, 104 }, { 82, 242, 105 }, { 82, 250, 106 }, { 84, 244, 107 }, { 84, 252, 108 }, { 86, 246, 109 }, { 86, 254, 110 }, { 88, 248, 111 },
        { 90, 244, 112 }, { 90, 250, 113 }, { 92, 246, 114 }, { 92, 252, 115 }, { 94, 248, 116 }, { 94, 254, 117 }, { 96, 250, 118 }, { 98, 244, 119 },
        { 98, 252, 120 }, { 100, 246, 121 }, { 100, 254, 122 }, { 102, 248, 123 }, { 104, 244, 124 }, { 104, 250, 125 }, { 106, 246, 126 }, { 106, 252, 127 },
        { 108, 248, 128 }, { 108, 254, 129 }, { 110, 250, 130 }, { 112, 244, 131 }, { 112, 252, 132 }, { 114, 246, 133 }, { 114, 254, 134 }, { 116, 248, 135 },
        { 118, 244, 136 }, { 118, 250, 137 }, { 120, 246, 138 }, { 120, 252, 139 }, { 122, 248, 140 }, { 122, 254, 141 }, { 124, 250, 142 }, { 126, 244, 143 },
        { 126, 252, 144 }, { 128, 246, 145 }, { 128, 254, 146 }, { 130, 248, 147 }, { 132, 244, 148 }, { 132, 250, 149 }, { 134, 246, 150 }, { 134, 252, 151 },
        { 136, 248, 152 }, { 136, 254, 153 }, { 138, 250, 154 }, { 140, 244, 155 }, { 140, 252, 156 }, { 142, 246, 157 }, { 142, 254, 158 }, { 144, 248, 159 },
        { 146, 242, 160 }, { 146, 250, 161 }, { 148, 244, 162 }, { 148, 252, 163 }, { 150, 246, 164 }, { 150, 254, 165 }, { 152, 248, 166 }, { 154, 244, 167 },
        { 154, 250, 168 }, { 156, 246, 169 }, { 156, 252, 170 }, { 158, 248, 171 }, { 158, 254, 172 }, { 160, 250, 173 }, { 162, 244, 174 }, { 162, 252, 175 },
        { 164, 246, 176 }, { 164, 254, 177 }, { 166, 248, 178 }, { 168, 244, 179 }, { 168, 250, 180 }, { 170, 246, 181 }, { 170, 252, 182 }, { 172, 248, 183 },
        { 172, 254, 184 }, { 174, 250, 185 }, { 176, 244, 186 }, { 176, 252, 187 }, { 178, 246, 188 }, { 178, 254, 189 }, { 180, 248, 190 }, { 182, 244, 191 },
        { 182, 250, 192 }, { 184, 246, 193 }, { 184, 252, 194 }, { 186, 248, 195 }, { 186, 254, 196 }, { 188, 250, 197 }, { 190, 244, 198 }, { 190, 252, 199 },
        { 192, 246, 200 }, { 192, 254, 201 }, { 194, 248, 202 }, { 196, 244, 203 }, { 196, 250, 204 }, { 198, 246, 205 }, { 198, 252, 206 }, { 200, 248, 207 },
        { 200, 254, 208 }, { 202, 250, 209 }, { 204, 244, 210 }, { 204, 252, 211 }, { 206, 246, 212 }, { 206, 254, 213 }, { 208, 248, 214 }, { 210, 242, 215 },
        { 210, 250, 216 }, { 212, 244, 217 }, { 212, 252, 218 }, { 214, 246, 219 }, { 214, 254, 220 }, { 216, 248, 221 }, { 218, 244, 222 }, { 218, 250, 223 },
        { 220, 246, 224 }, { 220, 252, 225 }, { 222, 248, 226 }, { 222, 254, 227 }, { 224, 250, 228 }, { 226, 244, 229 }, { 226, 252, 230 }, { 228, 246, 231 },
        { 228, 254, 232 }, { 230, 248, 233 }, { 232, 244, 234 }, { 232, 250, 235 }, { 234, 246, 236 }, { 234, 252, 237 }, { 236, 248, 238 }, { 236, 254, 239 },
        { 238, 250, 240 }, { 240, 244, 241 }, { 240, 252, 242 }, { 242, 246, 243 }, { 242, 254, 244 }, { 244, 248, 245 }, { 246, 244, 246 }, { 246, 250, 247 },
        { 248, 246, 248 }, { 248, 252, 249 }, { 250, 248, 250 }, { 250, 254, 251 }, { 252, 250, 252 }, { 254, 244, 253 }, { 254, 252, 254 }, { 254, 252, 254 },
    }
};

Table g_mode6_p0_i3=
{
    3,
    0,
    {
        { 0, 0, 0 }, { 0, 4, 1 }, { 0, 8, 2 }, { 0, 14, 3 }, { 0, 18, 4 }, { 0, 24, 5 }, { 0, 28, 6 }, { 0, 32, 7 },
        { 0, 38, 8 }, { 0, 42, 9 }, { 0, 48, 10 }, { 0, 52, 11 }, { 0, 58, 12 }, { 0, 62, 13 }, { 0, 68, 14 }, { 0, 72, 15 },
        { 0, 78, 16 }, { 0, 82, 17 }, { 0, 88, 18 }, { 0, 92, 19 }, { 0, 96, 20 }, { 0, 102, 21 }, { 0, 106, 22 }, { 0, 112, 23 },
        { 0, 116, 24 }, { 0, 122, 25 }, { 0, 126, 26 }, { 0, 132, 27 }, { 0, 136, 28 }, { 0, 142, 29 }, { 0, 146, 30 }, { 0, 152, 31 },
        { 0, 156, 32 }, { 0, 160, 33 }, { 0, 166, 34 }, { 0, 170, 35 }, { 0, 176, 36 }, { 0, 180, 37 }, { 0, 186, 38 }, { 0, 190, 39 },
        { 0, 196, 40 }, { 0, 200, 41 }, { 0, 206, 42 }, { 0, 210, 43 }, { 0, 216, 44 }, { 0, 220, 45 }, { 0, 224, 46 }, { 0, 230, 47 },
        { 0, 234, 48 }, { 0, 240, 49 }, { 0, 244, 50 }, { 0, 250, 51 }, { 0, 254, 52 }, { 2, 252, 53 }, { 4, 248, 54 }, { 4, 254, 55 },
        { 6, 250, 56 }, { 8, 248, 57 }, { 8, 252, 58 }, { 10, 250, 59 }, { 10, 254, 60 }, { 12, 252, 61 }, { 14, 248, 62 }, { 14, 254, 63 },
        { 16, 250, 64 }, { 18, 248, 65 }, { 18, 252, 66 }, { 20, 250, 67 }, { 20, 254, 68 }, { 22, 252, 69 }, { 24, 248, 70 }, { 24, 254, 71 },
        { 26, 250, 72 }, { 28, 248, 73 }, { 28, 252, 74 }, { 30, 250, 75 }, { 30, 254, 76 }, { 32, 252, 77 }, { 34, 250, 78 }, { 34, 254, 79 },
        { 36, 252, 80 }, { 38, 248, 81 }, { 38, 254, 82 }, { 40, 250, 83 }, { 42, 248, 84 }, { 42, 252, 85 }, { 44, 250, 86 }, { 44, 254, 87 },
        { 46, 252, 88 }, { 48, 248, 89 }, { 48, 254, 90 }, { 50, 250, 91 }, { 52, 248, 92 }, { 52, 252, 93 }, { 54, 250, 94 }, { 54, 254, 95 },
        { 56, 252, 96 }, { 58, 248, 97 }, { 58, 254, 98 }, { 60, 250, 99 }, { 62, 248, 100 }, { 62, 252, 101 }, { 64, 250, 102 }, { 64, 254, 103 },
        { 66, 252, 104 }, { 68, 248, 105 }, { 68, 254, 106 }, { 70, 250, 107 }, { 72, 248, 108 }, { 72, 252, 109 }, { 74, 250, 110 }, { 74, 254, 111 },
        { 76, 252, 112 }, { 78, 248, 113 }, { 78, 254, 114 }, { 80, 250, 115 }, { 82, 248, 116 }, { 82, 252, 117 }, { 84, 250, 118 }, { 84, 254, 119 },
        { 86, 252, 120 }, { 88, 248, 121 }, { 88, 254, 122 }, { 90, 250, 123 }, { 92, 248, 124 }, { 92, 252, 125 }, { 94, 250, 126 }, { 94, 254, 127 },
        { 96, 252, 128 }, { 98, 250, 129 }, { 98, 254, 130 }, { 100, 252, 131 }, { 102, 248, 132 }, { 102, 254, 133 }, { 104, 250, 134 }, { 106, 248, 135 },
        { 106, 252, 136 }, { 108, 250, 137 }, { 108, 254, 138 }, { 110, 252, 139 }, { 112, 248, 140 }, { 112, 254, 141 }, { 114, 250, 142 }, { 116, 248, 143 },
        { 116, 252, 144 }, { 118, 250, 145 }, { 118, 254, 146 }, { 120, 252, 147 }, { 122, 248, 148 }, { 122, 254, 149 }, { 124, 250, 150 }, { 126, 248, 151 },
        { 126, 252, 152 }, { 128, 250, 153 }, { 128, 254, 154 }, { 130, 252, 155 }, { 132, 248, 156 }, { 132, 254, 157 }, { 134, 250, 158 }, { 136, 248, 159 },
        { 136, 252, 160 }, { 138, 250, 161 }, { 138, 254, 162 }, { 140, 252, 163 }, { 142, 248, 164 }, { 142, 254, 165 }, { 144, 250, 166 }, { 146, 248, 167 },
        { 146, 252, 168 }, { 148, 250, 169 }, { 148, 254, 170 }, { 150, 252, 171 }, { 152, 248, 172 }, { 152, 254, 173 }, { 154, 250, 174 }, { 156, 248, 175 },
        { 156, 252, 176 }, { 158, 250, 177 }, { 158, 254, 178 }, { 160, 252, 179 }, { 162, 250, 180 }, { 162, 254, 181 }, { 164, 252, 182 }, { 166, 248, 183 },
        { 166, 254, 184 }, { 168, 250, 185 }, { 170, 248, 186 }, { 170, 252, 187 }, { 172, 250, 188 }, { 172, 254, 189 }, { 174, 252, 190 }, { 176, 248, 191 },
        { 176, 254, 192 }, { 178, 250, 193 }, { 180, 248, 194 }, { 180, 252, 195 }, { 182, 250, 196 }, { 182, 254, 197 }, { 184, 252, 198 }, { 186, 248, 199 },
        { 186, 254, 200 }, { 188, 250, 201 }, { 190, 248, 202 }, { 190, 252, 203 }, { 192, 250, 204 }, { 192, 254, 205 }, { 194, 252, 206 }, { 196, 248, 207 },
        { 196, 254, 208 }, { 198, 250, 209 }, { 200, 248, 210 }, { 200, 252, 211 }, { 202, 250, 212 }, { 202, 254, 213 }, { 204, 252, 214 }, { 206, 248, 215 },
        { 206, 254, 216 }, { 208, 250, 217 }, { 210, 248, 218 }, { 210, 252, 219 }, { 212, 250, 220 }, { 212, 254, 221 }, { 214, 252, 222 }, { 216, 248, 223 },
        { 216, 254, 224 }, { 218, 250, 225 }, { 220, 248, 226 }, { 220, 252, 227 }, { 222, 250, 228 }, { 222, 254, 229 }, { 224, 252, 230 }, { 226, 250, 231 },
        { 226, 254, 232 }, { 228, 252, 233 }, { 230, 248, 234 }, { 230, 254, 235 }, { 232, 250, 236 }, { 234, 248, 237 }, { 234, 252, 238 }, { 236, 250, 239 },
        { 236, 254, 240 }, { 238, 252, 241 }, { 240, 248, 242 }, { 240, 254, 243 }, { 242, 250, 244 }, { 244, 248, 245 }, { 244, 252, 246 }, { 246, 250, 247 },
        { 246, 254, 248 }, { 248, 252, 249 }, { 250, 248, 250 }, { 250, 254, 251 }, { 252, 250, 252 }, { 254, 248, 253 }, { 254, 252, 254 }, { 254, 252, 254 },
    }
};

Table g_mode6_p0_i4=
{
    4,
    0,
    {
        { 0, 0, 0 }, { 0, 2, 1 }, { 0, 6, 2 }, { 0, 10, 3 }, { 0, 14, 4 }, { 0, 18, 5 }, { 0, 22, 6 }, { 0, 26, 7 },
        { 0, 30, 8 }, { 0, 32, 9 }, { 0, 36, 10 }, { 0, 40, 11 }, { 0, 44, 12 }, { 0, 48, 13 }, { 0, 52, 14 }, { 0, 56, 15 },
        { 0, 60, 16 }, { 0, 64, 17 }, { 0, 66, 18 }, { 0, 70, 19 }, { 0, 74, 20 }, { 0, 78, 21 }, { 0, 82, 22 }, { 0, 86, 23 },
        { 0, 90, 24 }, { 0, 94, 25 }, { 0, 96, 26 }, { 0, 100, 27 }, { 0, 104, 28 }, { 0, 108, 29 }, { 0, 112, 30 }, { 0, 116, 31 },
        { 0, 120, 32 }, { 0, 124, 33 }, { 0, 128, 34 }, { 0, 130, 35 }, { 0, 134, 36 }, { 0, 138, 37 }, { 0, 142, 38 }, { 0, 146, 39 },
        { 0, 150, 40 }, { 0, 154, 41 }, { 0, 158, 42 }, { 0, 160, 43 }, { 0, 164, 44 }, { 0, 168, 45 }, { 0, 172, 46 }, { 0, 176, 47 },
        { 0, 180, 48 }, { 0, 184, 49 }, { 0, 188, 50 }, { 0, 192, 51 }, { 0, 194, 52 }, { 0, 198, 53 }, { 0, 202, 54 }, { 0, 206, 55 },
        { 0, 210, 56 }, { 0, 214, 57 }, { 0, 218, 58 }, { 0, 222, 59 }, { 0, 224, 60 }, { 0, 228, 61 }, { 0, 232, 62 }, { 0, 236, 63 },
        { 0, 240, 64 }, { 0, 244, 65 }, { 0, 248, 66 }, { 0, 252, 67 }, { 2, 250, 68 }, { 2, 254, 69 }, { 4, 252, 70 }, { 6, 250, 71 },
        { 6, 254, 72 }, { 8, 252, 73 }, { 10, 250, 74 }, { 10, 254, 75 }, { 12, 252, 76 }, { 14, 250, 77 }, { 14, 254, 78 }, { 16, 252, 79 },
        { 18, 250, 80 }, { 18, 254, 81 }, { 20, 252, 82 }, { 22, 250, 83 }, { 22, 254, 84 }, { 24, 252, 85 }, { 26, 250, 86 }, { 26, 254, 87 },
        { 28, 252, 88 }, { 30, 252, 89 }, { 30, 254, 90 }, { 32, 254, 91 }, { 34, 252, 92 }, { 36, 250, 93 }, { 36, 254, 94 }, { 38, 252, 95 },
        { 40, 250, 96 }, { 40, 254, 97 }, { 42, 252, 98 }, { 44, 250, 99 }, { 44, 254, 100 }, { 46, 252, 101 }, { 48, 250, 102 }, { 48, 254, 103 },
        { 50, 252, 104 }, { 52, 250, 105 }, { 52, 254, 106 }, { 54, 252, 107 }, { 56, 250, 108 }, { 56, 254, 109 }, { 58, 252, 110 }, { 60, 252, 111 },
        { 60, 254, 112 }, { 62, 254, 113 }, { 64, 252, 114 }, { 66, 250, 115 }, { 66, 254, 116 }, { 68, 252, 117 }, { 70, 250, 118 }, { 70, 254, 119 },
        { 72, 252, 120 }, { 74, 250, 121 }, { 74, 254, 122 }, { 76, 252, 123 }, { 78, 250, 124 }, { 78, 254, 125 }, { 80, 252, 126 }, { 82, 250, 127 },
        { 82, 254, 128 }, { 84, 252, 129 }, { 86, 250, 130 }, { 86, 254, 131 }, { 88, 252, 132 }, { 90, 250, 133 }, { 90, 254, 134 }, { 92, 252, 135 },
        { 94, 252, 136 }, { 94, 254, 137 }, { 96, 254, 138 }, { 98, 252, 139 }, { 100, 250, 140 }, { 100, 254, 141 }, { 102, 252, 142 }, { 104, 250, 143 },
        { 104, 254, 144 }, { 106, 252, 145 }, { 108, 250, 146 }, { 108, 254, 147 }, { 110, 252, 148 }, { 112, 250, 149 }, { 112, 254, 150 }, { 114, 252, 151 },
        { 116, 250, 152 }, { 116, 254, 153 }, { 118, 252, 154 }, { 120, 250, 155 }, { 120, 254, 156 }, { 122, 252, 157 }, { 124, 252, 158 }, { 124, 254, 159 },
        { 126, 254, 160 }, { 128, 252, 161 }, { 130, 250, 162 }, { 130, 254, 163 }, { 132, 252, 164 }, { 134, 250, 165 }, { 134, 254, 166 }, { 136, 252, 167 },
        { 138, 250, 168 }, { 138, 254, 169 }, { 140, 252, 170 }, { 142, 250, 171 }, { 142, 254, 172 }, { 144, 252, 173 }, { 146, 250, 174 }, { 146, 254, 175 },
        { 148, 252, 176 }, { 150, 250, 177 }, { 150, 254, 178 }, { 152, 252, 179 }, { 154, 250, 180 }, { 154, 254, 181 }, { 156, 252, 182 }, { 158, 252, 183 },
        { 158, 254, 184 }, { 160, 254, 185 }, { 162, 252, 186 }, { 164, 250, 187 }, { 164, 254, 188 }, { 166, 252, 189 }, { 168, 250, 190 }, { 168, 254, 191 },
        { 170, 252, 192 }, { 172, 250, 193 }, { 172, 254, 194 }, { 174, 252, 195 }, { 176, 250, 196 }, { 176, 254, 197 }, { 178, 252, 198 }, { 180, 250, 199 },
        { 180, 254, 200 }, { 182, 252, 201 }, { 184, 250, 202 }, { 184, 254, 203 }, { 186, 252, 204 }, { 188, 252, 205 }, { 188, 254, 206 }, { 190, 254, 207 },
        { 192, 252, 208 }, { 194, 250, 209 }, { 194, 254, 210 }, { 196, 252, 211 }, { 198, 250, 212 }, { 198, 254, 213 }, { 200, 252, 214 }, { 202, 250, 215 },
        { 202, 254, 216 }, { 204, 252, 217 }, { 206, 250, 218 }, { 206, 254, 219 }, { 208, 252, 220 }, { 210, 250, 221 }, { 210, 254, 222 }, { 212, 252, 223 },
        { 214, 250, 224 }, { 214, 254, 225 }, { 216, 252, 226 }, { 218, 250, 227 }, { 218, 254, 228 }, { 220, 252, 229 }, { 222, 252, 230 }, { 222, 254, 231 },
        { 224, 254, 232 }, { 226, 252, 233 }, { 228, 250, 234 }, { 228, 254, 235 }, { 230, 252, 236 }, { 232, 250, 237 }, { 232, 254, 238 }, { 234, 252, 239 },
        { 236, 250, 240 }, { 236, 254, 241 }, { 238, 252, 242 }, { 240, 250, 243 }, { 240, 254, 244 }, { 242, 252, 245 }, { 244, 250, 246 }, { 244, 254, 247 },
        { 246, 252, 248 }, { 248, 250, 249 }, { 248, 254, 250 }, { 250, 252, 251 }, { 252, 252, 252 }, { 252, 254, 253 }, { 254, 254, 254 }, { 254, 254, 254 },
    }
};

Table g_mode6_p0_i5=
{
    5,
    0,
    {
        { 0, 0, 0 }, { 0, 2, 1 }, { 0, 6, 2 }, { 0, 8, 3 }, { 0, 12, 4 }, { 0, 14, 5 }, { 0, 18, 6 }, { 0, 20, 7 },
        { 0, 24, 8 }, { 0, 26, 9 }, { 0, 30, 10 }, { 0, 32, 11 }, { 0, 36, 12 }, { 0, 40, 13 }, { 0, 42, 14 }, { 0, 46, 15 },
        { 0, 48, 16 }, { 0, 52, 17 }, { 0, 54, 18 }, { 0, 58, 19 }, { 0, 60, 20 }, { 0, 64, 21 }, { 0, 66, 22 }, { 0, 70, 23 },
        { 0, 72, 24 }, { 0, 76, 25 }, { 0, 78, 26 }, { 0, 82, 27 }, { 0, 84, 28 }, { 0, 88, 29 }, { 0, 90, 30 }, { 0, 94, 31 },
        { 0, 96, 32 }, { 0, 100, 33 }, { 0, 104, 34 }, { 0, 106, 35 }, { 0, 110, 36 }, { 0, 112, 37 }, { 0, 116, 38 }, { 0, 118, 39 },
        { 0, 122, 40 }, { 0, 124, 41 }, { 0, 128, 42 }, { 0, 130, 43 }, { 0, 134, 44 }, { 0, 136, 45 }, { 0, 140, 46 }, { 0, 142, 47 },
        { 0, 146, 48 }, { 0, 148, 49 }, { 0, 152, 50 }, { 0, 154, 51 }, { 0, 158, 52 }, { 0, 160, 53 }, { 0, 164, 54 }, { 0, 168, 55 },
        { 0, 170, 56 }, { 0, 174, 57 }, { 0, 176, 58 }, { 0, 180, 59 }, { 0, 182, 60 }, { 0, 186, 61 }, { 0, 188, 62 }, { 0, 192, 63 },
        { 0, 194, 64 }, { 0, 198, 65 }, { 0, 200, 66 }, { 0, 204, 67 }, { 0, 206, 68 }, { 0, 210, 69 }, { 0, 212, 70 }, { 0, 216, 71 },
        { 0, 218, 72 }, { 0, 222, 73 }, { 0, 224, 74 }, { 0, 228, 75 }, { 0, 232, 76 }, { 0, 234, 77 }, { 0, 238, 78 }, { 0, 240, 79 },
        { 0, 244, 80 }, { 0, 246, 81 }, { 0, 250, 82 }, { 0, 252, 83 }, { 2, 252, 84 }, { 2, 254, 85 }, { 4, 254, 86 }, { 6, 252, 87 },
        { 8, 252, 88 }, { 8, 254, 89 }, { 10, 254, 90 }, { 12, 252, 91 }, { 14, 252, 92 }, { 14, 254, 93 }, { 16, 254, 94 }, { 18, 252, 95 },
        { 20, 252, 96 }, { 20, 254, 97 }, { 22, 254, 98 }, { 24, 252, 99 }, { 26, 250, 100 }, { 26, 254, 101 }, { 28, 252, 102 }, { 30, 252, 103 },
        { 30, 254, 104 }, { 32, 254, 105 }, { 34, 252, 106 }, { 36, 252, 107 }, { 36, 254, 108 }, { 38, 254, 109 }, { 40, 252, 110 }, { 42, 252, 111 },
        { 42, 254, 112 }, { 44, 254, 113 }, { 46, 252, 114 }, { 48, 252, 115 }, { 48, 254, 116 }, { 50, 254, 117 }, { 52, 252, 118 }, { 54, 252, 119 },
        { 54, 254, 120 }, { 56, 254, 121 }, { 58, 252, 122 }, { 60, 252, 123 }, { 60, 254, 124 }, { 62, 254, 125 }, { 64, 252, 126 }, { 66, 252, 127 },
        { 66, 254, 128 }, { 68, 254, 129 }, { 70, 252, 130 }, { 72, 252, 131 }, { 72, 254, 132 }, { 74, 254, 133 }, { 76, 252, 134 }, { 78, 252, 135 },
        { 78, 254, 136 }, { 80, 254, 137 }, { 82, 252, 138 }, { 84, 252, 139 }, { 84, 254, 140 }, { 86, 254, 141 }, { 88, 252, 142 }, { 90, 250, 143 },
        { 90, 254, 144 }, { 92, 252, 145 }, { 94, 252, 146 }, { 94, 254, 147 }, { 96, 254, 148 }, { 98, 252, 149 }, { 100, 252, 150 }, { 100, 254, 151 },
        { 102, 254, 152 }, { 104, 252, 153 }, { 106, 252, 154 }, { 106, 254, 155 }, { 108, 254, 156 }, { 110, 252, 157 }, { 112, 252, 158 }, { 112, 254, 159 },
        { 114, 254, 160 }, { 116, 252, 161 }, { 118, 252, 162 }, { 118, 254, 163 }, { 120, 254, 164 }, { 122, 252, 165 }, { 124, 252, 166 }, { 124, 254, 167 },
        { 126, 254, 168 }, { 128, 252, 169 }, { 130, 252, 170 }, { 130, 254, 171 }, { 132, 254, 172 }, { 134, 252, 173 }, { 136, 252, 174 }, { 136, 254, 175 },
        { 138, 254, 176 }, { 140, 252, 177 }, { 142, 252, 178 }, { 142, 254, 179 }, { 144, 254, 180 }, { 146, 252, 181 }, { 148, 252, 182 }, { 148, 254, 183 },
        { 150, 254, 184 }, { 152, 252, 185 }, { 154, 250, 186 }, { 154, 254, 187 }, { 156, 252, 188 }, { 158, 252, 189 }, { 158, 254, 190 }, { 160, 254, 191 },
        { 162, 252, 192 }, { 164, 252, 193 }, { 164, 254, 194 }, { 166, 254, 195 }, { 168, 252, 196 }, { 170, 252, 197 }, { 170, 254, 198 }, { 172, 254, 199 },
        { 174, 252, 200 }, { 176, 252, 201 }, { 176, 254, 202 }, { 178, 254, 203 }, { 180, 252, 204 }, { 182, 252, 205 }, { 182, 254, 206 }, { 184, 254, 207 },
        { 186, 252, 208 }, { 188, 252, 209 }, { 188, 254, 210 }, { 190, 254, 211 }, { 192, 252, 212 }, { 194, 252, 213 }, { 194, 254, 214 }, { 196, 254, 215 },
        { 198, 252, 216 }, { 200, 252, 217 }, { 200, 254, 218 }, { 202, 254, 219 }, { 204, 252, 220 }, { 206, 252, 221 }, { 206, 254, 222 }, { 208, 254, 223 },
        { 210, 252, 224 }, { 212, 252, 225 }, { 212, 254, 226 }, { 214, 254, 227 }, { 216, 252, 228 }, { 218, 250, 229 }, { 218, 254, 230 }, { 220, 252, 231 },
        { 222, 252, 232 }, { 222, 254, 233 }, { 224, 254, 234 }, { 226, 252, 235 }, { 228, 252, 236 }, { 228, 254, 237 }, { 230, 254, 238 }, { 232, 252, 239 },
        { 234, 252, 240 }, { 234, 254, 241 }, { 236, 254, 242 }, { 238, 252, 243 }, { 240, 252, 244 }, { 240, 254, 245 }, { 242, 254, 246 }, { 244, 252, 247 },
        { 246, 252, 248 }, { 246, 254, 249 }, { 248, 254, 250 }, { 250, 252, 251 }, { 252, 252, 252 }, { 252, 254, 253 }, { 254, 254, 254 }, { 254, 254, 254 },
    }
};

Table g_mode6_p0_i6=
{
    6,
    0,
    {
        { 0, 0, 0 }, { 0, 2, 1 }, { 0, 4, 2 }, { 0, 8, 3 }, { 0, 10, 4 }, { 0, 12, 5 }, { 0, 14, 6 }, { 0, 16, 7 },
        { 0, 20, 8 }, { 0, 22, 9 }, { 0, 24, 10 }, { 0, 26, 11 }, { 0, 30, 12 }, { 0, 32, 13 }, { 0, 34, 14 }, { 0, 36, 15 },
        { 0, 40, 16 }, { 0, 42, 17 }, { 0, 44, 18 }, { 0, 46, 19 }, { 0, 48, 20 }, { 0, 52, 21 }, { 0, 54, 22 }, { 0, 56, 23 },
        { 0, 58, 24 }, { 0, 62, 25 }, { 0, 64, 26 }, { 0, 66, 27 }, { 0, 68, 28 }, { 0, 72, 29 }, { 0, 74, 30 }, { 0, 76, 31 },
        { 0, 78, 32 }, { 0, 80, 33 }, { 0, 84, 34 }, { 0, 86, 35 }, { 0, 88, 36 }, { 0, 90, 37 }, { 0, 94, 38 }, { 0, 96, 39 },
        { 0, 98, 40 }, { 0, 100, 41 }, { 0, 104, 42 }, { 0, 106, 43 }, { 0, 108, 44 }, { 0, 110, 45 }, { 0, 112, 46 }, { 0, 116, 47 },
        { 0, 118, 48 }, { 0, 120, 49 }, { 0, 122, 50 }, { 0, 126, 51 }, { 0, 128, 52 }, { 0, 130, 53 }, { 0, 132, 54 }, { 0, 136, 55 },
        { 0, 138, 56 }, { 0, 140, 57 }, { 0, 142, 58 }, { 0, 144, 59 }, { 0, 148, 60 }, { 0, 150, 61 }, { 0, 152, 62 }, { 0, 154, 63 },
        { 0, 158, 64 }, { 0, 160, 65 }, { 0, 162, 66 }, { 0, 164, 67 }, { 0, 168, 68 }, { 0, 170, 69 }, { 0, 172, 70 }, { 0, 174, 71 },
        { 0, 176, 72 }, { 0, 180, 73 }, { 0, 182, 74 }, { 0, 184, 75 }, { 0, 186, 76 }, { 0, 190, 77 }, { 0, 192, 78 }, { 0, 194, 79 },
        { 0, 196, 80 }, { 0, 200, 81 }, { 0, 202, 82 }, { 0, 204, 83 }, { 0, 206, 84 }, { 0, 208, 85 }, { 0, 212, 86 }, { 0, 214, 87 },
        { 0, 216, 88 }, { 0, 218, 89 }, { 0, 222, 90 }, { 0, 224, 91 }, { 0, 226, 92 }, { 0, 228, 93 }, { 0, 232, 94 }, { 0, 234, 95 },
        { 0, 236, 96 }, { 0, 238, 97 }, { 0, 240, 98 }, { 0, 244, 99 }, { 0, 246, 100 }, { 0, 248, 101 }, { 0, 250, 102 }, { 0, 254, 103 },
        { 2, 252, 104 }, { 4, 252, 105 }, { 4, 254, 106 }, { 6, 254, 107 }, { 8, 254, 108 }, { 10, 254, 109 }, { 12, 252, 110 }, { 14, 252, 111 },
        { 14, 254, 112 }, { 16, 254, 113 }, { 18, 254, 114 }, { 20, 254, 115 }, { 22, 254, 116 }, { 24, 252, 117 }, { 26, 252, 118 }, { 26, 254, 119 },
        { 28, 254, 120 }, { 30, 254, 121 }, { 32, 254, 122 }, { 34, 252, 123 }, { 36, 252, 124 }, { 36, 254, 125 }, { 38, 254, 126 }, { 40, 254, 127 },
        { 42, 254, 128 }, { 44, 252, 129 }, { 46, 252, 130 }, { 46, 254, 131 }, { 48, 254, 132 }, { 50, 254, 133 }, { 52, 254, 134 }, { 54, 254, 135 },
        { 56, 252, 136 }, { 58, 252, 137 }, { 58, 254, 138 }, { 60, 254, 139 }, { 62, 254, 140 }, { 64, 254, 141 }, { 66, 252, 142 }, { 68, 252, 143 },
        { 68, 254, 144 }, { 70, 254, 145 }, { 72, 254, 146 }, { 74, 254, 147 }, { 76, 252, 148 }, { 78, 252, 149 }, { 78, 254, 150 }, { 80, 254, 151 },
        { 82, 254, 152 }, { 84, 254, 153 }, { 86, 254, 154 }, { 88, 252, 155 }, { 90, 252, 156 }, { 90, 254, 157 }, { 92, 254, 158 }, { 94, 254, 159 },
        { 96, 254, 160 }, { 98, 252, 161 }, { 100, 252, 162 }, { 100, 254, 163 }, { 102, 254, 164 }, { 104, 254, 165 }, { 106, 254, 166 }, { 108, 252, 167 },
        { 110, 252, 168 }, { 110, 254, 169 }, { 112, 254, 170 }, { 114, 254, 171 }, { 116, 254, 172 }, { 118, 254, 173 }, { 120, 252, 174 }, { 122, 252, 175 },
        { 122, 254, 176 }, { 124, 254, 177 }, { 126, 254, 178 }, { 128, 254, 179 }, { 130, 252, 180 }, { 132, 252, 181 }, { 132, 254, 182 }, { 134, 254, 183 },
        { 136, 254, 184 }, { 138, 254, 185 }, { 140, 252, 186 }, { 142, 252, 187 }, { 142, 254, 188 }, { 144, 254, 189 }, { 146, 254, 190 }, { 148, 254, 191 },
        { 150, 254, 192 }, { 152, 252, 193 }, { 154, 252, 194 }, { 154, 254, 195 }, { 156, 254, 196 }, { 158, 254, 197 }, { 160, 254, 198 }, { 162, 252, 199 },
        { 164, 252, 200 }, { 164, 254, 201 }, { 166, 254, 202 }, { 168, 254, 203 }, { 170, 254, 204 }, { 172, 252, 205 }, { 174, 252, 206 }, { 174, 254, 207 },
        { 176, 254, 208 }, { 178, 254, 209 }, { 180, 254, 210 }, { 182, 254, 211 }, { 184, 252, 212 }, { 186, 252, 213 }, { 186, 254, 214 }, { 188, 254, 215 },
        { 190, 254, 216 }, { 192, 254, 217 }, { 194, 252, 218 }, { 196, 252, 219 }, { 196, 254, 220 }, { 198, 254, 221 }, { 200, 254, 222 }, { 202, 254, 223 },
        { 204, 252, 224 }, { 206, 252, 225 }, { 206, 254, 226 }, { 208, 254, 227 }, { 210, 254, 228 }, { 212, 254, 229 }, { 214, 254, 230 }, { 216, 252, 231 },
        { 218, 252, 232 }, { 218, 254, 233 }, { 220, 254, 234 }, { 222, 254, 235 }, { 224, 254, 236 }, { 226, 252, 237 }, { 228, 252, 238 }, { 228, 254, 239 },
        { 230, 254, 240 }, { 232, 254, 241 }, { 234, 254, 242 }, { 236, 252, 243 }, { 238, 252, 244 }, { 238, 254, 245 }, { 240, 254, 246 }, { 242, 254, 247 },
        { 244, 254, 248 }, { 246, 254, 249 }, { 248, 252, 250 }, { 250, 252, 251 }, { 250, 254, 252 }, { 252, 254, 253 }, { 254, 254, 254 }, { 254, 254, 254 },
    }
};

Table g_mode6_p0_i7=
{
    7,
    0,
    {
        { 0, 0, 0 }, { 0, 2, 1 }, { 0, 4, 2 }, { 0, 6, 3 }, { 0, 8, 4 }, { 0, 10, 5 }, { 0, 12, 6 }, { 0, 14, 7 },
        { 0, 16, 8 }, { 0, 20, 9 }, { 0, 22, 10 }, { 0, 24, 11 }, { 0, 26, 12 }, { 0, 28, 13 }, { 0, 30, 14 }, { 0, 32, 15 },
        { 0, 34, 16 }, { 0, 36, 17 }, { 0, 38, 18 }, { 0, 40, 19 }, { 0, 42, 20 }, { 0, 44, 21 }, { 0, 46, 22 }, { 0, 48, 23 },
        { 0, 52, 24 }, { 0, 54, 25 }, { 0, 56, 26 }, { 0, 58, 27 }, { 0, 60, 28 }, { 0, 62, 29 }, { 0, 64, 30 }, { 0, 66, 31 },
        { 0, 68, 32 }, { 0, 70, 33 }, { 0, 72, 34 }, { 0, 74, 35 }, { 0, 76, 36 }, { 0, 78, 37 }, { 0, 80, 38 }, { 0, 84, 39 },
        { 0, 86, 40 }, { 0, 88, 41 }, { 0, 90, 42 }, { 0, 92, 43 }, { 0, 94, 44 }, { 0, 96, 45 }, { 0, 98, 46 }, { 0, 100, 47 },
        { 0, 102, 48 }, { 0, 104, 49 }, { 0, 106, 50 }, { 0, 108, 51 }, { 0, 110, 52 }, { 0, 112, 53 }, { 0, 116, 54 }, { 0, 118, 55 },
        { 0, 120, 56 }, { 0, 122, 57 }, { 0, 124, 58 }, { 0, 126, 59 }, { 0, 128, 60 }, { 0, 130, 61 }, { 0, 132, 62 }, { 0, 134, 63 },
        { 0, 136, 64 }, { 0, 138, 65 }, { 0, 140, 66 }, { 0, 142, 67 }, { 0, 144, 68 }, { 0, 148, 69 }, { 0, 150, 70 }, { 0, 152, 71 },
        { 0, 154, 72 }, { 0, 156, 73 }, { 0, 158, 74 }, { 0, 160, 75 }, { 0, 162, 76 }, { 0, 164, 77 }, { 0, 166, 78 }, { 0, 168, 79 },
        { 0, 170, 80 }, { 0, 172, 81 }, { 0, 174, 82 }, { 0, 176, 83 }, { 0, 180, 84 }, { 0, 182, 85 }, { 0, 184, 86 }, { 0, 186, 87 },
        { 0, 188, 88 }, { 0, 190, 89 }, { 0, 192, 90 }, { 0, 194, 91 }, { 0, 196, 92 }, { 0, 198, 93 }, { 0, 200, 94 }, { 0, 202, 95 },
        { 0, 204, 96 }, { 0, 206, 97 }, { 0, 208, 98 }, { 0, 212, 99 }, { 0, 214, 100 }, { 0, 216, 101 }, { 0, 218, 102 }, { 0, 220, 103 },
        { 0, 222, 104 }, { 0, 224, 105 }, { 0, 226, 106 }, { 0, 228, 107 }, { 0, 230, 108 }, { 0, 232, 109 }, { 0, 234, 110 }, { 0, 236, 111 },
        { 0, 238, 112 }, { 0, 240, 113 }, { 0, 244, 114 }, { 0, 246, 115 }, { 0, 248, 116 }, { 0, 250, 117 }, { 0, 252, 118 }, { 0, 254, 119 },
        { 2, 254, 120 }, { 4, 254, 121 }, { 6, 254, 122 }, { 8, 254, 123 }, { 10, 254, 124 }, { 12, 252, 125 }, { 14, 252, 126 }, { 14, 254, 127 },
        { 16, 254, 128 }, { 18, 254, 129 }, { 20, 254, 130 }, { 22, 254, 131 }, { 24, 254, 132 }, { 26, 254, 133 }, { 28, 254, 134 }, { 30, 254, 135 },
        { 32, 254, 136 }, { 34, 254, 137 }, { 36, 254, 138 }, { 38, 254, 139 }, { 40, 254, 140 }, { 42, 254, 141 }, { 44, 252, 142 }, { 46, 252, 143 },
        { 46, 254, 144 }, { 48, 254, 145 }, { 50, 254, 146 }, { 52, 254, 147 }, { 54, 254, 148 }, { 56, 254, 149 }, { 58, 254, 150 }, { 60, 254, 151 },
        { 62, 254, 152 }, { 64, 254, 153 }, { 66, 254, 154 }, { 68, 254, 155 }, { 70, 254, 156 }, { 72, 254, 157 }, { 74, 254, 158 }, { 76, 252, 159 },
        { 78, 252, 160 }, { 78, 254, 161 }, { 80, 254, 162 }, { 82, 254, 163 }, { 84, 254, 164 }, { 86, 254, 165 }, { 88, 254, 166 }, { 90, 254, 167 },
        { 92, 254, 168 }, { 94, 254, 169 }, { 96, 254, 170 }, { 98, 254, 171 }, { 100, 254, 172 }, { 102, 254, 173 }, { 104, 254, 174 }, { 106, 254, 175 },
        { 108, 252, 176 }, { 110, 252, 177 }, { 110, 254, 178 }, { 112, 254, 179 }, { 114, 254, 180 }, { 116, 254, 181 }, { 118, 254, 182 }, { 120, 254, 183 },
        { 122, 254, 184 }, { 124, 254, 185 }, { 126, 254, 186 }, { 128, 254, 187 }, { 130, 254, 188 }, { 132, 254, 189 }, { 134, 254, 190 }, { 136, 254, 191 },
        { 138, 254, 192 }, { 140, 252, 193 }, { 142, 252, 194 }, { 142, 254, 195 }, { 144, 254, 196 }, { 146, 254, 197 }, { 148, 254, 198 }, { 150, 254, 199 },
        { 152, 254, 200 }, { 154, 254, 201 }, { 156, 254, 202 }, { 158, 254, 203 }, { 160, 254, 204 }, { 162, 254, 205 }, { 164, 254, 206 }, { 166, 254, 207 },
        { 168, 254, 208 }, { 170, 254, 209 }, { 172, 252, 210 }, { 174, 252, 211 }, { 174, 254, 212 }, { 176, 254, 213 }, { 178, 254, 214 }, { 180, 254, 215 },
        { 182, 254, 216 }, { 184, 254, 217 }, { 186, 254, 218 }, { 188, 254, 219 }, { 190, 254, 220 }, { 192, 254, 221 }, { 194, 254, 222 }, { 196, 254, 223 },
        { 198, 254, 224 }, { 200, 254, 225 }, { 202, 254, 226 }, { 204, 252, 227 }, { 206, 252, 228 }, { 206, 254, 229 }, { 208, 254, 230 }, { 210, 254, 231 },
        { 212, 254, 232 }, { 214, 254, 233 }, { 216, 254, 234 }, { 218, 254, 235 }, { 220, 254, 236 }, { 222, 254, 237 }, { 224, 254, 238 }, { 226, 254, 239 },
        { 228, 254, 240 }, { 230, 254, 241 }, { 232, 254, 242 }, { 234, 254, 243 }, { 236, 252, 244 }, { 238, 252, 245 }, { 238, 254, 246 }, { 240, 254, 247 },
        { 242, 254, 248 }, { 244, 254, 249 }, { 246, 254, 250 }, { 248, 254, 251 }, { 250, 254, 252 }, { 252, 254, 253 }, { 254, 254, 254 }, { 254, 254, 254 },
    }
};

Table g_mode6_p1_i1=
{
    1,
    1,
    {
        { 1, 1, 1 }, { 1, 1, 1 }, { 1, 9, 2 }, { 1, 25, 3 }, { 1, 41, 4 }, { 1, 57, 5 }, { 1, 73, 6 }, { 1, 89, 7 },
        { 1, 105, 8 }, { 1, 121, 9 }, { 1, 137, 10 }, { 1, 153, 11 }, { 1, 169, 12 }, { 1, 185, 13 }, { 1, 201, 14 }, { 1, 217, 15 },
        { 1, 233, 16 }, { 1, 249, 17 }, { 3, 235, 18 }, { 3, 251, 19 }, { 5, 237, 20 }, { 5, 253, 21 }, { 7, 239, 22 }, { 7, 255, 23 },
        { 9, 241, 24 }, { 11, 227, 25 }, { 11, 243, 26 }, { 13, 229, 27 }, { 13, 245, 28 }, { 15, 231, 29 }, { 15, 247, 30 }, { 17, 233, 31 },
        { 17, 249, 32 }, { 19, 235, 33 }, { 19, 251, 34 }, { 21, 237, 35 }, { 21, 253, 36 }, { 23, 239, 37 }, { 23, 255, 38 }, { 25, 241, 39 },
        { 27, 227, 40 }, { 27, 243, 41 }, { 29, 229, 42 }, { 29, 245, 43 }, { 31, 231, 44 }, { 31, 247, 45 }, { 33, 233, 46 }, { 33, 249, 47 },
        { 35, 235, 48 }, { 35, 251, 49 }, { 37, 237, 50 }, { 37, 253, 51 }, { 39, 239, 52 }, { 39, 255, 53 }, { 41, 241, 54 }, { 43, 227, 55 },
        { 43, 243, 56 }, { 45, 229, 57 }, { 45, 245, 58 }, { 47, 231, 59 }, { 47, 247, 60 }, { 49, 233, 61 }, { 49, 249, 62 }, { 51, 235, 63 },
        { 51, 251, 64 }, { 53, 237, 65 }, { 53, 253, 66 }, { 55, 239, 67 }, { 55, 255, 68 }, { 57, 241, 69 }, { 59, 227, 70 }, { 59, 243, 71 },
        { 61, 229, 72 }, { 61, 245, 73 }, { 63, 231, 74 }, { 63, 247, 75 }, { 65, 233, 76 }, { 65, 249, 77 }, { 67, 235, 78 }, { 67, 251, 79 },
        { 69, 237, 80 }, { 69, 253, 81 }, { 71, 239, 82 }, { 71, 255, 83 }, { 73, 241, 84 }, { 75, 227, 85 }, { 75, 243, 86 }, { 77, 229, 87 },
        { 77, 245, 88 }, { 79, 231, 89 }, { 79, 247, 90 }, { 81, 233, 91 }, { 81, 249, 92 }, { 83, 235, 93 }, { 83, 251, 94 }, { 85, 237, 95 },
        { 85, 253, 96 }, { 87, 239, 97 }, { 87, 255, 98 }, { 89, 241, 99 }, { 91, 227, 100 }, { 91, 243, 101 }, { 93, 229, 102 }, { 93, 245, 103 },
        { 95, 231, 104 }, { 95, 247, 105 }, { 97, 233, 106 }, { 97, 249, 107 }, { 99, 235, 108 }, { 99, 251, 109 }, { 101, 237, 110 }, { 101, 253, 111 },
        { 103, 239, 112 }, { 103, 255, 113 }, { 105, 241, 114 }, { 107, 227, 115 }, { 107, 243, 116 }, { 109, 229, 117 }, { 109, 245, 118 }, { 111, 231, 119 },
        { 111, 247, 120 }, { 113, 233, 121 }, { 113, 249, 122 }, { 115, 235, 123 }, { 115, 251, 124 }, { 117, 237, 125 }, { 117, 253, 126 }, { 119, 239, 127 },
        { 119, 255, 128 }, { 121, 241, 129 }, { 123, 227, 130 }, { 123, 243, 131 }, { 125, 229, 132 }, { 125, 245, 133 }, { 127, 231, 134 }, { 127, 247, 135 },
        { 129, 233, 136 }, { 129, 249, 137 }, { 131, 235, 138 }, { 131, 251, 139 }, { 133, 237, 140 }, { 133, 253, 141 }, { 135, 239, 142 }, { 135, 255, 143 },
        { 137, 241, 144 }, { 139, 227, 145 }, { 139, 243, 146 }, { 141, 229, 147 }, { 141, 245, 148 }, { 143, 231, 149 }, { 143, 247, 150 }, { 145, 233, 151 },
        { 145, 249, 152 }, { 147, 235, 153 }, { 147, 251, 154 }, { 149, 237, 155 }, { 149, 253, 156 }, { 151, 239, 157 }, { 151, 255, 158 }, { 153, 241, 159 },
        { 155, 227, 160 }, { 155, 243, 161 }, { 157, 229, 162 }, { 157, 245, 163 }, { 159, 231, 164 }, { 159, 247, 165 }, { 161, 233, 166 }, { 161, 249, 167 },
        { 163, 235, 168 }, { 163, 251, 169 }, { 165, 237, 170 }, { 165, 253, 171 }, { 167, 239, 172 }, { 167, 255, 173 }, { 169, 241, 174 }, { 171, 227, 175 },
        { 171, 243, 176 }, { 173, 229, 177 }, { 173, 245, 178 }, { 175, 231, 179 }, { 175, 247, 180 }, { 177, 233, 181 }, { 177, 249, 182 }, { 179, 235, 183 },
        { 179, 251, 184 }, { 181, 237, 185 }, { 181, 253, 186 }, { 183, 239, 187 }, { 183, 255, 188 }, { 185, 241, 189 }, { 187, 227, 190 }, { 187, 243, 191 },
        { 189, 229, 192 }, { 189, 245, 193 }, { 191, 231, 194 }, { 191, 247, 195 }, { 193, 233, 196 }, { 193, 249, 197 }, { 195, 235, 198 }, { 195, 251, 199 },
        { 197, 237, 200 }, { 197, 253, 201 }, { 199, 239, 202 }, { 199, 255, 203 }, { 201, 241, 204 }, { 203, 227, 205 }, { 203, 243, 206 }, { 205, 229, 207 },
        { 205, 245, 208 }, { 207, 231, 209 }, { 207, 247, 210 }, { 209, 233, 211 }, { 209, 249, 212 }, { 211, 235, 213 }, { 211, 251, 214 }, { 213, 237, 215 },
        { 213, 253, 216 }, { 215, 239, 217 }, { 215, 255, 218 }, { 217, 241, 219 }, { 219, 227, 220 }, { 219, 243, 221 }, { 221, 229, 222 }, { 221, 245, 223 },
        { 223, 231, 224 }, { 223, 247, 225 }, { 225, 233, 226 }, { 225, 249, 227 }, { 227, 235, 228 }, { 227, 251, 229 }, { 229, 237, 230 }, { 229, 253, 231 },
        { 231, 239, 232 }, { 231, 255, 233 }, { 233, 241, 234 }, { 235, 227, 235 }, { 235, 243, 236 }, { 237, 229, 237 }, { 237, 245, 238 }, { 239, 231, 239 },
        { 239, 247, 240 }, { 241, 233, 241 }, { 241, 249, 242 }, { 243, 235, 243 }, { 243, 251, 244 }, { 245, 237, 245 }, { 245, 253, 246 }, { 247, 239, 247 },
        { 247, 255, 248 }, { 249, 241, 249 }, { 251, 227, 250 }, { 251, 243, 251 }, { 253, 229, 252 }, { 253, 245, 253 }, { 255, 231, 254 }, { 255, 247, 255 },
    }
};

Table g_mode6_p1_i2=
{
    2,
    1,
    {
        { 1, 1, 1 }, { 1, 1, 1 }, { 1, 5, 2 }, { 1, 13, 3 }, { 1, 19, 4 }, { 1, 27, 5 }, { 1, 33, 6 }, { 1, 41, 7 },
        { 1, 49, 8 }, { 1, 55, 9 }, { 1, 63, 10 }, { 1, 69, 11 }, { 1, 77, 12 }, { 1, 83, 13 }, { 1, 91, 14 }, { 1, 97, 15 },
        { 1, 105, 16 }, { 1, 113, 17 }, { 1, 119, 18 }, { 1, 127, 19 }, { 1, 133, 20 }, { 1, 141, 21 }, { 1, 147, 22 }, { 1, 155, 23 },
        { 1, 161, 24 }, { 1, 169, 25 }, { 1, 177, 26 }, { 1, 183, 27 }, { 1, 191, 28 }, { 1, 197, 29 }, { 1, 205, 30 }, { 1, 211, 31 },
        { 1, 219, 32 }, { 1, 225, 33 }, { 1, 233, 34 }, { 1, 241, 35 }, { 1, 247, 36 }, { 1, 255, 37 }, { 3, 249, 38 }, { 5, 245, 39 },
        { 5, 251, 40 }, { 7, 247, 41 }, { 7, 253, 42 }, { 9, 249, 43 }, { 9, 255, 44 }, { 11, 251, 45 }, { 13, 245, 46 }, { 13, 253, 47 },
        { 15, 247, 48 }, { 15, 255, 49 }, { 17, 249, 50 }, { 19, 243, 51 }, { 19, 251, 52 }, { 21, 245, 53 }, { 21, 253, 54 }, { 23, 247, 55 },
        { 23, 255, 56 }, { 25, 249, 57 }, { 27, 245, 58 }, { 27, 251, 59 }, { 29, 247, 60 }, { 29, 253, 61 }, { 31, 249, 62 }, { 31, 255, 63 },
        { 33, 251, 64 }, { 35, 245, 65 }, { 35, 253, 66 }, { 37, 247, 67 }, { 37, 255, 68 }, { 39, 249, 69 }, { 41, 245, 70 }, { 41, 251, 71 },
        { 43, 247, 72 }, { 43, 253, 73 }, { 45, 249, 74 }, { 45, 255, 75 }, { 47, 251, 76 }, { 49, 245, 77 }, { 49, 253, 78 }, { 51, 247, 79 },
        { 51, 255, 80 }, { 53, 249, 81 }, { 55, 245, 82 }, { 55, 251, 83 }, { 57, 247, 84 }, { 57, 253, 85 }, { 59, 249, 86 }, { 59, 255, 87 },
        { 61, 251, 88 }, { 63, 245, 89 }, { 63, 253, 90 }, { 65, 247, 91 }, { 65, 255, 92 }, { 67, 249, 93 }, { 69, 245, 94 }, { 69, 251, 95 },
        { 71, 247, 96 }, { 71, 253, 97 }, { 73, 249, 98 }, { 73, 255, 99 }, { 75, 251, 100 }, { 77, 245, 101 }, { 77, 253, 102 }, { 79, 247, 103 },
        { 79, 255, 104 }, { 81, 249, 105 }, { 83, 243, 106 }, { 83, 251, 107 }, { 85, 245, 108 }, { 85, 253, 109 }, { 87, 247, 110 }, { 87, 255, 111 },
        { 89, 249, 112 }, { 91, 245, 113 }, { 91, 251, 114 }, { 93, 247, 115 }, { 93, 253, 116 }, { 95, 249, 117 }, { 95, 255, 118 }, { 97, 251, 119 },
        { 99, 245, 120 }, { 99, 253, 121 }, { 101, 247, 122 }, { 101, 255, 123 }, { 103, 249, 124 }, { 105, 245, 125 }, { 105, 251, 126 }, { 107, 247, 127 },
        { 107, 253, 128 }, { 109, 249, 129 }, { 109, 255, 130 }, { 111, 251, 131 }, { 113, 245, 132 }, { 113, 253, 133 }, { 115, 247, 134 }, { 115, 255, 135 },
        { 117, 249, 136 }, { 119, 245, 137 }, { 119, 251, 138 }, { 121, 247, 139 }, { 121, 253, 140 }, { 123, 249, 141 }, { 123, 255, 142 }, { 125, 251, 143 },
        { 127, 245, 144 }, { 127, 253, 145 }, { 129, 247, 146 }, { 129, 255, 147 }, { 131, 249, 148 }, { 133, 245, 149 }, { 133, 251, 150 }, { 135, 247, 151 },
        { 135, 253, 152 }, { 137, 249, 153 }, { 137, 255, 154 }, { 139, 251, 155 }, { 141, 245, 156 }, { 141, 253, 157 }, { 143, 247, 158 }, { 143, 255, 159 },
        { 145, 249, 160 }, { 147, 243, 161 }, { 147, 251, 162 }, { 149, 245, 163 }, { 149, 253, 164 }, { 151, 247, 165 }, { 151, 255, 166 }, { 153, 249, 167 },
        { 155, 245, 168 }, { 155, 251, 169 }, { 157, 247, 170 }, { 157, 253, 171 }, { 159, 249, 172 }, { 159, 255, 173 }, { 161, 251, 174 }, { 163, 245, 175 },
        { 163, 253, 176 }, { 165, 247, 177 }, { 165, 255, 178 }, { 167, 249, 179 }, { 169, 245, 180 }, { 169, 251, 181 }, { 171, 247, 182 }, { 171, 253, 183 },
        { 173, 249, 184 }, { 173, 255, 185 }, { 175, 251, 186 }, { 177, 245, 187 }, { 177, 253, 188 }, { 179, 247, 189 }, { 179, 255, 190 }, { 181, 249, 191 },
        { 183, 245, 192 }, { 183, 251, 193 }, { 185, 247, 194 }, { 185, 253, 195 }, { 187, 249, 196 }, { 187, 255, 197 }, { 189, 251, 198 }, { 191, 245, 199 },
        { 191, 253, 200 }, { 193, 247, 201 }, { 193, 255, 202 }, { 195, 249, 203 }, { 197, 245, 204 }, { 197, 251, 205 }, { 199, 247, 206 }, { 199, 253, 207 },
        { 201, 249, 208 }, { 201, 255, 209 }, { 203, 251, 210 }, { 205, 245, 211 }, { 205, 253, 212 }, { 207, 247, 213 }, { 207, 255, 214 }, { 209, 249, 215 },
        { 211, 243, 216 }, { 211, 251, 217 }, { 213, 245, 218 }, { 213, 253, 219 }, { 215, 247, 220 }, { 215, 255, 221 }, { 217, 249, 222 }, { 219, 245, 223 },
        { 219, 251, 224 }, { 221, 247, 225 }, { 221, 253, 226 }, { 223, 249, 227 }, { 223, 255, 228 }, { 225, 251, 229 }, { 227, 245, 230 }, { 227, 253, 231 },
        { 229, 247, 232 }, { 229, 255, 233 }, { 231, 249, 234 }, { 233, 245, 235 }, { 233, 251, 236 }, { 235, 247, 237 }, { 235, 253, 238 }, { 237, 249, 239 },
        { 237, 255, 240 }, { 239, 251, 241 }, { 241, 245, 242 }, { 241, 253, 243 }, { 243, 247, 244 }, { 243, 255, 245 }, { 245, 249, 246 }, { 247, 245, 247 },
        { 247, 251, 248 }, { 249, 247, 249 }, { 249, 253, 250 }, { 251, 249, 251 }, { 251, 255, 252 }, { 253, 251, 253 }, { 255, 245, 254 }, { 255, 253, 255 },
    }
};

Table g_mode6_p1_i3=
{
    3,
    1,
    {
        { 1, 1, 1 }, { 1, 1, 1 }, { 1, 5, 2 }, { 1, 9, 3 }, { 1, 15, 4 }, { 1, 19, 5 }, { 1, 25, 6 }, { 1, 29, 7 },
        { 1, 33, 8 }, { 1, 39, 9 }, { 1, 43, 10 }, { 1, 49, 11 }, { 1, 53, 12 }, { 1, 59, 13 }, { 1, 63, 14 }, { 1, 69, 15 },
        { 1, 73, 16 }, { 1, 79, 17 }, { 1, 83, 18 }, { 1, 89, 19 }, { 1, 93, 20 }, { 1, 97, 21 }, { 1, 103, 22 }, { 1, 107, 23 },
        { 1, 113, 24 }, { 1, 117, 25 }, { 1, 123, 26 }, { 1, 127, 27 }, { 1, 133, 28 }, { 1, 137, 29 }, { 1, 143, 30 }, { 1, 147, 31 },
        { 1, 153, 32 }, { 1, 157, 33 }, { 1, 161, 34 }, { 1, 167, 35 }, { 1, 171, 36 }, { 1, 177, 37 }, { 1, 181, 38 }, { 1, 187, 39 },
        { 1, 191, 40 }, { 1, 197, 41 }, { 1, 201, 42 }, { 1, 207, 43 }, { 1, 211, 44 }, { 1, 217, 45 }, { 1, 221, 46 }, { 1, 225, 47 },
        { 1, 231, 48 }, { 1, 235, 49 }, { 1, 241, 50 }, { 1, 245, 51 }, { 1, 251, 52 }, { 1, 255, 53 }, { 3, 253, 54 }, { 5, 249, 55 },
        { 5, 255, 56 }, { 7, 251, 57 }, { 9, 249, 58 }, { 9, 253, 59 }, { 11, 251, 60 }, { 11, 255, 61 }, { 13, 253, 62 }, { 15, 249, 63 },
        { 15, 255, 64 }, { 17, 251, 65 }, { 19, 249, 66 }, { 19, 253, 67 }, { 21, 251, 68 }, { 21, 255, 69 }, { 23, 253, 70 }, { 25, 249, 71 },
        { 25, 255, 72 }, { 27, 251, 73 }, { 29, 249, 74 }, { 29, 253, 75 }, { 31, 251, 76 }, { 31, 255, 77 }, { 33, 253, 78 }, { 35, 251, 79 },
        { 35, 255, 80 }, { 37, 253, 81 }, { 39, 249, 82 }, { 39, 255, 83 }, { 41, 251, 84 }, { 43, 249, 85 }, { 43, 253, 86 }, { 45, 251, 87 },
        { 45, 255, 88 }, { 47, 253, 89 }, { 49, 249, 90 }, { 49, 255, 91 }, { 51, 251, 92 }, { 53, 249, 93 }, { 53, 253, 94 }, { 55, 251, 95 },
        { 55, 255, 96 }, { 57, 253, 97 }, { 59, 249, 98 }, { 59, 255, 99 }, { 61, 251, 100 }, { 63, 249, 101 }, { 63, 253, 102 }, { 65, 251, 103 },
        { 65, 255, 104 }, { 67, 253, 105 }, { 69, 249, 106 }, { 69, 255, 107 }, { 71, 251, 108 }, { 73, 249, 109 }, { 73, 253, 110 }, { 75, 251, 111 },
        { 75, 255, 112 }, { 77, 253, 113 }, { 79, 249, 114 }, { 79, 255, 115 }, { 81, 251, 116 }, { 83, 249, 117 }, { 83, 253, 118 }, { 85, 251, 119 },
        { 85, 255, 120 }, { 87, 253, 121 }, { 89, 249, 122 }, { 89, 255, 123 }, { 91, 251, 124 }, { 93, 249, 125 }, { 93, 253, 126 }, { 95, 251, 127 },
        { 95, 255, 128 }, { 97, 253, 129 }, { 99, 251, 130 }, { 99, 255, 131 }, { 101, 253, 132 }, { 103, 249, 133 }, { 103, 255, 134 }, { 105, 251, 135 },
        { 107, 249, 136 }, { 107, 253, 137 }, { 109, 251, 138 }, { 109, 255, 139 }, { 111, 253, 140 }, { 113, 249, 141 }, { 113, 255, 142 }, { 115, 251, 143 },
        { 117, 249, 144 }, { 117, 253, 145 }, { 119, 251, 146 }, { 119, 255, 147 }, { 121, 253, 148 }, { 123, 249, 149 }, { 123, 255, 150 }, { 125, 251, 151 },
        { 127, 249, 152 }, { 127, 253, 153 }, { 129, 251, 154 }, { 129, 255, 155 }, { 131, 253, 156 }, { 133, 249, 157 }, { 133, 255, 158 }, { 135, 251, 159 },
        { 137, 249, 160 }, { 137, 253, 161 }, { 139, 251, 162 }, { 139, 255, 163 }, { 141, 253, 164 }, { 143, 249, 165 }, { 143, 255, 166 }, { 145, 251, 167 },
        { 147, 249, 168 }, { 147, 253, 169 }, { 149, 251, 170 }, { 149, 255, 171 }, { 151, 253, 172 }, { 153, 249, 173 }, { 153, 255, 174 }, { 155, 251, 175 },
        { 157, 249, 176 }, { 157, 253, 177 }, { 159, 251, 178 }, { 159, 255, 179 }, { 161, 253, 180 }, { 163, 251, 181 }, { 163, 255, 182 }, { 165, 253, 183 },
        { 167, 249, 184 }, { 167, 255, 185 }, { 169, 251, 186 }, { 171, 249, 187 }, { 171, 253, 188 }, { 173, 251, 189 }, { 173, 255, 190 }, { 175, 253, 191 },
        { 177, 249, 192 }, { 177, 255, 193 }, { 179, 251, 194 }, { 181, 249, 195 }, { 181, 253, 196 }, { 183, 251, 197 }, { 183, 255, 198 }, { 185, 253, 199 },
        { 187, 249, 200 }, { 187, 255, 201 }, { 189, 251, 202 }, { 191, 249, 203 }, { 191, 253, 204 }, { 193, 251, 205 }, { 193, 255, 206 }, { 195, 253, 207 },
        { 197, 249, 208 }, { 197, 255, 209 }, { 199, 251, 210 }, { 201, 249, 211 }, { 201, 253, 212 }, { 203, 251, 213 }, { 203, 255, 214 }, { 205, 253, 215 },
        { 207, 249, 216 }, { 207, 255, 217 }, { 209, 251, 218 }, { 211, 249, 219 }, { 211, 253, 220 }, { 213, 251, 221 }, { 213, 255, 222 }, { 215, 253, 223 },
        { 217, 249, 224 }, { 217, 255, 225 }, { 219, 251, 226 }, { 221, 249, 227 }, { 221, 253, 228 }, { 223, 251, 229 }, { 223, 255, 230 }, { 225, 253, 231 },
        { 227, 251, 232 }, { 227, 255, 233 }, { 229, 253, 234 }, { 231, 249, 235 }, { 231, 255, 236 }, { 233, 251, 237 }, { 235, 249, 238 }, { 235, 253, 239 },
        { 237, 251, 240 }, { 237, 255, 241 }, { 239, 253, 242 }, { 241, 249, 243 }, { 241, 255, 244 }, { 243, 251, 245 }, { 245, 249, 246 }, { 245, 253, 247 },
        { 247, 251, 248 }, { 247, 255, 249 }, { 249, 253, 250 }, { 251, 249, 251 }, { 251, 255, 252 }, { 253, 251, 253 }, { 255, 249, 254 }, { 255, 253, 255 },
    }
};

Table g_mode6_p1_i4=
{
    4,
    1,
    {
        { 1, 1, 1 }, { 1, 1, 1 }, { 1, 3, 2 }, { 1, 7, 3 }, { 1, 11, 4 }, { 1, 15, 5 }, { 1, 19, 6 }, { 1, 23, 7 },
        { 1, 27, 8 }, { 1, 31, 9 }, { 1, 33, 10 }, { 1, 37, 11 }, { 1, 41, 12 }, { 1, 45, 13 }, { 1, 49, 14 }, { 1, 53, 15 },
        { 1, 57, 16 }, { 1, 61, 17 }, { 1, 65, 18 }, { 1, 67, 19 }, { 1, 71, 20 }, { 1, 75, 21 }, { 1, 79, 22 }, { 1, 83, 23 },
        { 1, 87, 24 }, { 1, 91, 25 }, { 1, 95, 26 }, { 1, 97, 27 }, { 1, 101, 28 }, { 1, 105, 29 }, { 1, 109, 30 }, { 1, 113, 31 },
        { 1, 117, 32 }, { 1, 121, 33 }, { 1, 125, 34 }, { 1, 129, 35 }, { 1, 131, 36 }, { 1, 135, 37 }, { 1, 139, 38 }, { 1, 143, 39 },
        { 1, 147, 40 }, { 1, 151, 41 }, { 1, 155, 42 }, { 1, 159, 43 }, { 1, 161, 44 }, { 1, 165, 45 }, { 1, 169, 46 }, { 1, 173, 47 },
        { 1, 177, 48 }, { 1, 181, 49 }, { 1, 185, 50 }, { 1, 189, 51 }, { 1, 193, 52 }, { 1, 195, 53 }, { 1, 199, 54 }, { 1, 203, 55 },
        { 1, 207, 56 }, { 1, 211, 57 }, { 1, 215, 58 }, { 1, 219, 59 }, { 1, 223, 60 }, { 1, 225, 61 }, { 1, 229, 62 }, { 1, 233, 63 },
        { 1, 237, 64 }, { 1, 241, 65 }, { 1, 245, 66 }, { 1, 249, 67 }, { 1, 253, 68 }, { 3, 251, 69 }, { 3, 255, 70 }, { 5, 253, 71 },
        { 7, 251, 72 }, { 7, 255, 73 }, { 9, 253, 74 }, { 11, 251, 75 }, { 11, 255, 76 }, { 13, 253, 77 }, { 15, 251, 78 }, { 15, 255, 79 },
        { 17, 253, 80 }, { 19, 251, 81 }, { 19, 255, 82 }, { 21, 253, 83 }, { 23, 251, 84 }, { 23, 255, 85 }, { 25, 253, 86 }, { 27, 251, 87 },
        { 27, 255, 88 }, { 29, 253, 89 }, { 31, 253, 90 }, { 31, 255, 91 }, { 33, 255, 92 }, { 35, 253, 93 }, { 37, 251, 94 }, { 37, 255, 95 },
        { 39, 253, 96 }, { 41, 251, 97 }, { 41, 255, 98 }, { 43, 253, 99 }, { 45, 251, 100 }, { 45, 255, 101 }, { 47, 253, 102 }, { 49, 251, 103 },
        { 49, 255, 104 }, { 51, 253, 105 }, { 53, 251, 106 }, { 53, 255, 107 }, { 55, 253, 108 }, { 57, 251, 109 }, { 57, 255, 110 }, { 59, 253, 111 },
        { 61, 253, 112 }, { 61, 255, 113 }, { 63, 255, 114 }, { 65, 253, 115 }, { 67, 251, 116 }, { 67, 255, 117 }, { 69, 253, 118 }, { 71, 251, 119 },
        { 71, 255, 120 }, { 73, 253, 121 }, { 75, 251, 122 }, { 75, 255, 123 }, { 77, 253, 124 }, { 79, 251, 125 }, { 79, 255, 126 }, { 81, 253, 127 },
        { 83, 251, 128 }, { 83, 255, 129 }, { 85, 253, 130 }, { 87, 251, 131 }, { 87, 255, 132 }, { 89, 253, 133 }, { 91, 251, 134 }, { 91, 255, 135 },
        { 93, 253, 136 }, { 95, 253, 137 }, { 95, 255, 138 }, { 97, 255, 139 }, { 99, 253, 140 }, { 101, 251, 141 }, { 101, 255, 142 }, { 103, 253, 143 },
        { 105, 251, 144 }, { 105, 255, 145 }, { 107, 253, 146 }, { 109, 251, 147 }, { 109, 255, 148 }, { 111, 253, 149 }, { 113, 251, 150 }, { 113, 255, 151 },
        { 115, 253, 152 }, { 117, 251, 153 }, { 117, 255, 154 }, { 119, 253, 155 }, { 121, 251, 156 }, { 121, 255, 157 }, { 123, 253, 158 }, { 125, 253, 159 },
        { 125, 255, 160 }, { 127, 255, 161 }, { 129, 253, 162 }, { 131, 251, 163 }, { 131, 255, 164 }, { 133, 253, 165 }, { 135, 251, 166 }, { 135, 255, 167 },
        { 137, 253, 168 }, { 139, 251, 169 }, { 139, 255, 170 }, { 141, 253, 171 }, { 143, 251, 172 }, { 143, 255, 173 }, { 145, 253, 174 }, { 147, 251, 175 },
        { 147, 255, 176 }, { 149, 253, 177 }, { 151, 251, 178 }, { 151, 255, 179 }, { 153, 253, 180 }, { 155, 251, 181 }, { 155, 255, 182 }, { 157, 253, 183 },
        { 159, 253, 184 }, { 159, 255, 185 }, { 161, 255, 186 }, { 163, 253, 187 }, { 165, 251, 188 }, { 165, 255, 189 }, { 167, 253, 190 }, { 169, 251, 191 },
        { 169, 255, 192 }, { 171, 253, 193 }, { 173, 251, 194 }, { 173, 255, 195 }, { 175, 253, 196 }, { 177, 251, 197 }, { 177, 255, 198 }, { 179, 253, 199 },
        { 181, 251, 200 }, { 181, 255, 201 }, { 183, 253, 202 }, { 185, 251, 203 }, { 185, 255, 204 }, { 187, 253, 205 }, { 189, 253, 206 }, { 189, 255, 207 },
        { 191, 255, 208 }, { 193, 253, 209 }, { 195, 251, 210 }, { 195, 255, 211 }, { 197, 253, 212 }, { 199, 251, 213 }, { 199, 255, 214 }, { 201, 253, 215 },
        { 203, 251, 216 }, { 203, 255, 217 }, { 205, 253, 218 }, { 207, 251, 219 }, { 207, 255, 220 }, { 209, 253, 221 }, { 211, 251, 222 }, { 211, 255, 223 },
        { 213, 253, 224 }, { 215, 251, 225 }, { 215, 255, 226 }, { 217, 253, 227 }, { 219, 251, 228 }, { 219, 255, 229 }, { 221, 253, 230 }, { 223, 253, 231 },
        { 223, 255, 232 }, { 225, 255, 233 }, { 227, 253, 234 }, { 229, 251, 235 }, { 229, 255, 236 }, { 231, 253, 237 }, { 233, 251, 238 }, { 233, 255, 239 },
        { 235, 253, 240 }, { 237, 251, 241 }, { 237, 255, 242 }, { 239, 253, 243 }, { 241, 251, 244 }, { 241, 255, 245 }, { 243, 253, 246 }, { 245, 251, 247 },
        { 245, 255, 248 }, { 247, 253, 249 }, { 249, 251, 250 }, { 249, 255, 251 }, { 251, 253, 252 }, { 253, 253, 253 }, { 253, 255, 254 }, { 255, 255, 255 },
    }
};

Table g_mode6_p1_i5=
{
    5,
    1,
    {
        { 1, 1, 1 }, { 1, 1, 1 }, { 1, 3, 2 }, { 1, 7, 3 }, { 1, 9, 4 }, { 1, 13, 5 }, { 1, 15, 6 }, { 1, 19, 7 },
        { 1, 21, 8 }, { 1, 25, 9 }, { 1, 27, 10 }, { 1, 31, 11 }, { 1, 33, 12 }, { 1, 37, 13 }, { 1, 41, 14 }, { 1, 43, 15 },
        { 1, 47, 16 }, { 1, 49, 17 }, { 1, 53, 18 }, { 1, 55, 19 }, { 1, 59, 20 }, { 1, 61, 21 }, { 1, 65, 22 }, { 1, 67, 23 },
        { 1, 71, 24 }, { 1, 73, 25 }, { 1, 77, 26 }, { 1, 79, 27 }, { 1, 83, 28 }, { 1, 85, 29 }, { 1, 89, 30 }, { 1, 91, 31 },
        { 1, 95, 32 }, { 1, 97, 33 }, { 1, 101, 34 }, { 1, 105, 35 }, { 1, 107, 36 }, { 1, 111, 37 }, { 1, 113, 38 }, { 1, 117, 39 },
        { 1, 119, 40 }, { 1, 123, 41 }, { 1, 125, 42 }, { 1, 129, 43 }, { 1, 131, 44 }, { 1, 135, 45 }, { 1, 137, 46 }, { 1, 141, 47 },
        { 1, 143, 48 }, { 1, 147, 49 }, { 1, 149, 50 }, { 1, 153, 51 }, { 1, 155, 52 }, { 1, 159, 53 }, { 1, 161, 54 }, { 1, 165, 55 },
        { 1, 169, 56 }, { 1, 171, 57 }, { 1, 175, 58 }, { 1, 177, 59 }, { 1, 181, 60 }, { 1, 183, 61 }, { 1, 187, 62 }, { 1, 189, 63 },
        { 1, 193, 64 }, { 1, 195, 65 }, { 1, 199, 66 }, { 1, 201, 67 }, { 1, 205, 68 }, { 1, 207, 69 }, { 1, 211, 70 }, { 1, 213, 71 },
        { 1, 217, 72 }, { 1, 219, 73 }, { 1, 223, 74 }, { 1, 225, 75 }, { 1, 229, 76 }, { 1, 233, 77 }, { 1, 235, 78 }, { 1, 239, 79 },
        { 1, 241, 80 }, { 1, 245, 81 }, { 1, 247, 82 }, { 1, 251, 83 }, { 1, 253, 84 }, { 3, 253, 85 }, { 3, 255, 86 }, { 5, 255, 87 },
        { 7, 253, 88 }, { 9, 253, 89 }, { 9, 255, 90 }, { 11, 255, 91 }, { 13, 253, 92 }, { 15, 253, 93 }, { 15, 255, 94 }, { 17, 255, 95 },
        { 19, 253, 96 }, { 21, 253, 97 }, { 21, 255, 98 }, { 23, 255, 99 }, { 25, 253, 100 }, { 27, 251, 101 }, { 27, 255, 102 }, { 29, 253, 103 },
        { 31, 253, 104 }, { 31, 255, 105 }, { 33, 255, 106 }, { 35, 253, 107 }, { 37, 253, 108 }, { 37, 255, 109 }, { 39, 255, 110 }, { 41, 253, 111 },
        { 43, 253, 112 }, { 43, 255, 113 }, { 45, 255, 114 }, { 47, 253, 115 }, { 49, 253, 116 }, { 49, 255, 117 }, { 51, 255, 118 }, { 53, 253, 119 },
        { 55, 253, 120 }, { 55, 255, 121 }, { 57, 255, 122 }, { 59, 253, 123 }, { 61, 253, 124 }, { 61, 255, 125 }, { 63, 255, 126 }, { 65, 253, 127 },
        { 67, 253, 128 }, { 67, 255, 129 }, { 69, 255, 130 }, { 71, 253, 131 }, { 73, 253, 132 }, { 73, 255, 133 }, { 75, 255, 134 }, { 77, 253, 135 },
        { 79, 253, 136 }, { 79, 255, 137 }, { 81, 255, 138 }, { 83, 253, 139 }, { 85, 253, 140 }, { 85, 255, 141 }, { 87, 255, 142 }, { 89, 253, 143 },
        { 91, 251, 144 }, { 91, 255, 145 }, { 93, 253, 146 }, { 95, 253, 147 }, { 95, 255, 148 }, { 97, 255, 149 }, { 99, 253, 150 }, { 101, 253, 151 },
        { 101, 255, 152 }, { 103, 255, 153 }, { 105, 253, 154 }, { 107, 253, 155 }, { 107, 255, 156 }, { 109, 255, 157 }, { 111, 253, 158 }, { 113, 253, 159 },
        { 113, 255, 160 }, { 115, 255, 161 }, { 117, 253, 162 }, { 119, 253, 163 }, { 119, 255, 164 }, { 121, 255, 165 }, { 123, 253, 166 }, { 125, 253, 167 },
        { 125, 255, 168 }, { 127, 255, 169 }, { 129, 253, 170 }, { 131, 253, 171 }, { 131, 255, 172 }, { 133, 255, 173 }, { 135, 253, 174 }, { 137, 253, 175 },
        { 137, 255, 176 }, { 139, 255, 177 }, { 141, 253, 178 }, { 143, 253, 179 }, { 143, 255, 180 }, { 145, 255, 181 }, { 147, 253, 182 }, { 149, 253, 183 },
        { 149, 255, 184 }, { 151, 255, 185 }, { 153, 253, 186 }, { 155, 251, 187 }, { 155, 255, 188 }, { 157, 253, 189 }, { 159, 253, 190 }, { 159, 255, 191 },
        { 161, 255, 192 }, { 163, 253, 193 }, { 165, 253, 194 }, { 165, 255, 195 }, { 167, 255, 196 }, { 169, 253, 197 }, { 171, 253, 198 }, { 171, 255, 199 },
        { 173, 255, 200 }, { 175, 253, 201 }, { 177, 253, 202 }, { 177, 255, 203 }, { 179, 255, 204 }, { 181, 253, 205 }, { 183, 253, 206 }, { 183, 255, 207 },
        { 185, 255, 208 }, { 187, 253, 209 }, { 189, 253, 210 }, { 189, 255, 211 }, { 191, 255, 212 }, { 193, 253, 213 }, { 195, 253, 214 }, { 195, 255, 215 },
        { 197, 255, 216 }, { 199, 253, 217 }, { 201, 253, 218 }, { 201, 255, 219 }, { 203, 255, 220 }, { 205, 253, 221 }, { 207, 253, 222 }, { 207, 255, 223 },
        { 209, 255, 224 }, { 211, 253, 225 }, { 213, 253, 226 }, { 213, 255, 227 }, { 215, 255, 228 }, { 217, 253, 229 }, { 219, 251, 230 }, { 219, 255, 231 },
        { 221, 253, 232 }, { 223, 253, 233 }, { 223, 255, 234 }, { 225, 255, 235 }, { 227, 253, 236 }, { 229, 253, 237 }, { 229, 255, 238 }, { 231, 255, 239 },
        { 233, 253, 240 }, { 235, 253, 241 }, { 235, 255, 242 }, { 237, 255, 243 }, { 239, 253, 244 }, { 241, 253, 245 }, { 241, 255, 246 }, { 243, 255, 247 },
        { 245, 253, 248 }, { 247, 253, 249 }, { 247, 255, 250 }, { 249, 255, 251 }, { 251, 253, 252 }, { 253, 253, 253 }, { 253, 255, 254 }, { 255, 255, 255 },
    }
};

Table g_mode6_p1_i6=
{
    6,
    1,
    {
        { 1, 1, 1 }, { 1, 1, 1 }, { 1, 3, 2 }, { 1, 5, 3 }, { 1, 9, 4 }, { 1, 11, 5 }, { 1, 13, 6 }, { 1, 15, 7 },
        { 1, 17, 8 }, { 1, 21, 9 }, { 1, 23, 10 }, { 1, 25, 11 }, { 1, 27, 12 }, { 1, 31, 13 }, { 1, 33, 14 }, { 1, 35, 15 },
        { 1, 37, 16 }, { 1, 41, 17 }, { 1, 43, 18 }, { 1, 45, 19 }, { 1, 47, 20 }, { 1, 49, 21 }, { 1, 53, 22 }, { 1, 55, 23 },
        { 1, 57, 24 }, { 1, 59, 25 }, { 1, 63, 26 }, { 1, 65, 27 }, { 1, 67, 28 }, { 1, 69, 29 }, { 1, 73, 30 }, { 1, 75, 31 },
        { 1, 77, 32 }, { 1, 79, 33 }, { 1, 81, 34 }, { 1, 85, 35 }, { 1, 87, 36 }, { 1, 89, 37 }, { 1, 91, 38 }, { 1, 95, 39 },
        { 1, 97, 40 }, { 1, 99, 41 }, { 1, 101, 42 }, { 1, 105, 43 }, { 1, 107, 44 }, { 1, 109, 45 }, { 1, 111, 46 }, { 1, 113, 47 },
        { 1, 117, 48 }, { 1, 119, 49 }, { 1, 121, 50 }, { 1, 123, 51 }, { 1, 127, 52 }, { 1, 129, 53 }, { 1, 131, 54 }, { 1, 133, 55 },
        { 1, 137, 56 }, { 1, 139, 57 }, { 1, 141, 58 }, { 1, 143, 59 }, { 1, 145, 60 }, { 1, 149, 61 }, { 1, 151, 62 }, { 1, 153, 63 },
        { 1, 155, 64 }, { 1, 159, 65 }, { 1, 161, 66 }, { 1, 163, 67 }, { 1, 165, 68 }, { 1, 169, 69 }, { 1, 171, 70 }, { 1, 173, 71 },
        { 1, 175, 72 }, { 1, 177, 73 }, { 1, 181, 74 }, { 1, 183, 75 }, { 1, 185, 76 }, { 1, 187, 77 }, { 1, 191, 78 }, { 1, 193, 79 },
        { 1, 195, 80 }, { 1, 197, 81 }, { 1, 201, 82 }, { 1, 203, 83 }, { 1, 205, 84 }, { 1, 207, 85 }, { 1, 209, 86 }, { 1, 213, 87 },
        { 1, 215, 88 }, { 1, 217, 89 }, { 1, 219, 90 }, { 1, 223, 91 }, { 1, 225, 92 }, { 1, 227, 93 }, { 1, 229, 94 }, { 1, 233, 95 },
        { 1, 235, 96 }, { 1, 237, 97 }, { 1, 239, 98 }, { 1, 241, 99 }, { 1, 245, 100 }, { 1, 247, 101 }, { 1, 249, 102 }, { 1, 251, 103 },
        { 1, 255, 104 }, { 3, 253, 105 }, { 5, 253, 106 }, { 5, 255, 107 }, { 7, 255, 108 }, { 9, 255, 109 }, { 11, 255, 110 }, { 13, 253, 111 },
        { 15, 253, 112 }, { 15, 255, 113 }, { 17, 255, 114 }, { 19, 255, 115 }, { 21, 255, 116 }, { 23, 255, 117 }, { 25, 253, 118 }, { 27, 253, 119 },
        { 27, 255, 120 }, { 29, 255, 121 }, { 31, 255, 122 }, { 33, 255, 123 }, { 35, 253, 124 }, { 37, 253, 125 }, { 37, 255, 126 }, { 39, 255, 127 },
        { 41, 255, 128 }, { 43, 255, 129 }, { 45, 253, 130 }, { 47, 253, 131 }, { 47, 255, 132 }, { 49, 255, 133 }, { 51, 255, 134 }, { 53, 255, 135 },
        { 55, 255, 136 }, { 57, 253, 137 }, { 59, 253, 138 }, { 59, 255, 139 }, { 61, 255, 140 }, { 63, 255, 141 }, { 65, 255, 142 }, { 67, 253, 143 },
        { 69, 253, 144 }, { 69, 255, 145 }, { 71, 255, 146 }, { 73, 255, 147 }, { 75, 255, 148 }, { 77, 253, 149 }, { 79, 253, 150 }, { 79, 255, 151 },
        { 81, 255, 152 }, { 83, 255, 153 }, { 85, 255, 154 }, { 87, 255, 155 }, { 89, 253, 156 }, { 91, 253, 157 }, { 91, 255, 158 }, { 93, 255, 159 },
        { 95, 255, 160 }, { 97, 255, 161 }, { 99, 253, 162 }, { 101, 253, 163 }, { 101, 255, 164 }, { 103, 255, 165 }, { 105, 255, 166 }, { 107, 255, 167 },
        { 109, 253, 168 }, { 111, 253, 169 }, { 111, 255, 170 }, { 113, 255, 171 }, { 115, 255, 172 }, { 117, 255, 173 }, { 119, 255, 174 }, { 121, 253, 175 },
        { 123, 253, 176 }, { 123, 255, 177 }, { 125, 255, 178 }, { 127, 255, 179 }, { 129, 255, 180 }, { 131, 253, 181 }, { 133, 253, 182 }, { 133, 255, 183 },
        { 135, 255, 184 }, { 137, 255, 185 }, { 139, 255, 186 }, { 141, 253, 187 }, { 143, 253, 188 }, { 143, 255, 189 }, { 145, 255, 190 }, { 147, 255, 191 },
        { 149, 255, 192 }, { 151, 255, 193 }, { 153, 253, 194 }, { 155, 253, 195 }, { 155, 255, 196 }, { 157, 255, 197 }, { 159, 255, 198 }, { 161, 255, 199 },
        { 163, 253, 200 }, { 165, 253, 201 }, { 165, 255, 202 }, { 167, 255, 203 }, { 169, 255, 204 }, { 171, 255, 205 }, { 173, 253, 206 }, { 175, 253, 207 },
        { 175, 255, 208 }, { 177, 255, 209 }, { 179, 255, 210 }, { 181, 255, 211 }, { 183, 255, 212 }, { 185, 253, 213 }, { 187, 253, 214 }, { 187, 255, 215 },
        { 189, 255, 216 }, { 191, 255, 217 }, { 193, 255, 218 }, { 195, 253, 219 }, { 197, 253, 220 }, { 197, 255, 221 }, { 199, 255, 222 }, { 201, 255, 223 },
        { 203, 255, 224 }, { 205, 253, 225 }, { 207, 253, 226 }, { 207, 255, 227 }, { 209, 255, 228 }, { 211, 255, 229 }, { 213, 255, 230 }, { 215, 255, 231 },
        { 217, 253, 232 }, { 219, 253, 233 }, { 219, 255, 234 }, { 221, 255, 235 }, { 223, 255, 236 }, { 225, 255, 237 }, { 227, 253, 238 }, { 229, 253, 239 },
        { 229, 255, 240 }, { 231, 255, 241 }, { 233, 255, 242 }, { 235, 255, 243 }, { 237, 253, 244 }, { 239, 253, 245 }, { 239, 255, 246 }, { 241, 255, 247 },
        { 243, 255, 248 }, { 245, 255, 249 }, { 247, 255, 250 }, { 249, 253, 251 }, { 251, 253, 252 }, { 251, 255, 253 }, { 253, 255, 254 }, { 255, 255, 255 },
    }
};

Table g_mode6_p1_i7=
{
    7,
    1,
    {
        { 1, 1, 1 }, { 1, 1, 1 }, { 1, 3, 2 }, { 1, 5, 3 }, { 1, 7, 4 }, { 1, 9, 5 }, { 1, 11, 6 }, { 1, 13, 7 },
        { 1, 15, 8 }, { 1, 17, 9 }, { 1, 21, 10 }, { 1, 23, 11 }, { 1, 25, 12 }, { 1, 27, 13 }, { 1, 29, 14 }, { 1, 31, 15 },
        { 1, 33, 16 }, { 1, 35, 17 }, { 1, 37, 18 }, { 1, 39, 19 }, { 1, 41, 20 }, { 1, 43, 21 }, { 1, 45, 22 }, { 1, 47, 23 },
        { 1, 49, 24 }, { 1, 53, 25 }, { 1, 55, 26 }, { 1, 57, 27 }, { 1, 59, 28 }, { 1, 61, 29 }, { 1, 63, 30 }, { 1, 65, 31 },
        { 1, 67, 32 }, { 1, 69, 33 }, { 1, 71, 34 }, { 1, 73, 35 }, { 1, 75, 36 }, { 1, 77, 37 }, { 1, 79, 38 }, { 1, 81, 39 },
        { 1, 85, 40 }, { 1, 87, 41 }, { 1, 89, 42 }, { 1, 91, 43 }, { 1, 93, 44 }, { 1, 95, 45 }, { 1, 97, 46 }, { 1, 99, 47 },
        { 1, 101, 48 }, { 1, 103, 49 }, { 1, 105, 50 }, { 1, 107, 51 }, { 1, 109, 52 }, { 1, 111, 53 }, { 1, 113, 54 }, { 1, 117, 55 },
        { 1, 119, 56 }, { 1, 121, 57 }, { 1, 123, 58 }, { 1, 125, 59 }, { 1, 127, 60 }, { 1, 129, 61 }, { 1, 131, 62 }, { 1, 133, 63 },
        { 1, 135, 64 }, { 1, 137, 65 }, { 1, 139, 66 }, { 1, 141, 67 }, { 1, 143, 68 }, { 1, 145, 69 }, { 1, 149, 70 }, { 1, 151, 71 },
        { 1, 153, 72 }, { 1, 155, 73 }, { 1, 157, 74 }, { 1, 159, 75 }, { 1, 161, 76 }, { 1, 163, 77 }, { 1, 165, 78 }, { 1, 167, 79 },
        { 1, 169, 80 }, { 1, 171, 81 }, { 1, 173, 82 }, { 1, 175, 83 }, { 1, 177, 84 }, { 1, 181, 85 }, { 1, 183, 86 }, { 1, 185, 87 },
        { 1, 187, 88 }, { 1, 189, 89 }, { 1, 191, 90 }, { 1, 193, 91 }, { 1, 195, 92 }, { 1, 197, 93 }, { 1, 199, 94 }, { 1, 201, 95 },
        { 1, 203, 96 }, { 1, 205, 97 }, { 1, 207, 98 }, { 1, 209, 99 }, { 1, 213, 100 }, { 1, 215, 101 }, { 1, 217, 102 }, { 1, 219, 103 },
        { 1, 221, 104 }, { 1, 223, 105 }, { 1, 225, 106 }, { 1, 227, 107 }, { 1, 229, 108 }, { 1, 231, 109 }, { 1, 233, 110 }, { 1, 235, 111 },
        { 1, 237, 112 }, { 1, 239, 113 }, { 1, 241, 114 }, { 1, 245, 115 }, { 1, 247, 116 }, { 1, 249, 117 }, { 1, 251, 118 }, { 1, 253, 119 },
        { 1, 255, 120 }, { 3, 255, 121 }, { 5, 255, 122 }, { 7, 255, 123 }, { 9, 255, 124 }, { 11, 255, 125 }, { 13, 253, 126 }, { 15, 253, 127 },
        { 15, 255, 128 }, { 17, 255, 129 }, { 19, 255, 130 }, { 21, 255, 131 }, { 23, 255, 132 }, { 25, 255, 133 }, { 27, 255, 134 }, { 29, 255, 135 },
        { 31, 255, 136 }, { 33, 255, 137 }, { 35, 255, 138 }, { 37, 255, 139 }, { 39, 255, 140 }, { 41, 255, 141 }, { 43, 255, 142 }, { 45, 253, 143 },
        { 47, 253, 144 }, { 47, 255, 145 }, { 49, 255, 146 }, { 51, 255, 147 }, { 53, 255, 148 }, { 55, 255, 149 }, { 57, 255, 150 }, { 59, 255, 151 },
        { 61, 255, 152 }, { 63, 255, 153 }, { 65, 255, 154 }, { 67, 255, 155 }, { 69, 255, 156 }, { 71, 255, 157 }, { 73, 255, 158 }, { 75, 255, 159 },
        { 77, 253, 160 }, { 79, 253, 161 }, { 79, 255, 162 }, { 81, 255, 163 }, { 83, 255, 164 }, { 85, 255, 165 }, { 87, 255, 166 }, { 89, 255, 167 },
        { 91, 255, 168 }, { 93, 255, 169 }, { 95, 255, 170 }, { 97, 255, 171 }, { 99, 255, 172 }, { 101, 255, 173 }, { 103, 255, 174 }, { 105, 255, 175 },
        { 107, 255, 176 }, { 109, 253, 177 }, { 111, 253, 178 }, { 111, 255, 179 }, { 113, 255, 180 }, { 115, 255, 181 }, { 117, 255, 182 }, { 119, 255, 183 },
        { 121, 255, 184 }, { 123, 255, 185 }, { 125, 255, 186 }, { 127, 255, 187 }, { 129, 255, 188 }, { 131, 255, 189 }, { 133, 255, 190 }, { 135, 255, 191 },
        { 137, 255, 192 }, { 139, 255, 193 }, { 141, 253, 194 }, { 143, 253, 195 }, { 143, 255, 196 }, { 145, 255, 197 }, { 147, 255, 198 }, { 149, 255, 199 },
        { 151, 255, 200 }, { 153, 255, 201 }, { 155, 255, 202 }, { 157, 255, 203 }, { 159, 255, 204 }, { 161, 255, 205 }, { 163, 255, 206 }, { 165, 255, 207 },
        { 167, 255, 208 }, { 169, 255, 209 }, { 171, 255, 210 }, { 173, 253, 211 }, { 175, 253, 212 }, { 175, 255, 213 }, { 177, 255, 214 }, { 179, 255, 215 },
        { 181, 255, 216 }, { 183, 255, 217 }, { 185, 255, 218 }, { 187, 255, 219 }, { 189, 255, 220 }, { 191, 255, 221 }, { 193, 255, 222 }, { 195, 255, 223 },
        { 197, 255, 224 }, { 199, 255, 225 }, { 201, 255, 226 }, { 203, 255, 227 }, { 205, 253, 228 }, { 207, 253, 229 }, { 207, 255, 230 }, { 209, 255, 231 },
        { 211, 255, 232 }, { 213, 255, 233 }, { 215, 255, 234 }, { 217, 255, 235 }, { 219, 255, 236 }, { 221, 255, 237 }, { 223, 255, 238 }, { 225, 255, 239 },
        { 227, 255, 240 }, { 229, 255, 241 }, { 231, 255, 242 }, { 233, 255, 243 }, { 235, 255, 244 }, { 237, 253, 245 }, { 239, 253, 246 }, { 239, 255, 247 },
        { 241, 255, 248 }, { 243, 255, 249 }, { 245, 255, 250 }, { 247, 255, 251 }, { 249, 255, 252 }, { 251, 255, 253 }, { 253, 255, 254 }, { 255, 255, 255 },
    }
};

Table g_mode7_p00=
{
    1,
    0,
    {
        { 0, 0, 0 }, { 0, 2, 1 }, { 0, 6, 2 }, { 0, 8, 3 }, { 0, 12, 4 }, { 0, 14, 5 }, { 0, 18, 6 }, { 0, 20, 7 },
        { 0, 24, 8 }, { 0, 26, 9 }, { 0, 30, 10 }, { 0, 32, 11 }, { 0, 36, 12 }, { 0, 40, 13 }, { 0, 42, 14 }, { 0, 46, 15 },
        { 0, 48, 16 }, { 0, 52, 17 }, { 0, 54, 18 }, { 0, 58, 19 }, { 0, 60, 20 }, { 0, 64, 21 }, { 0, 66, 22 }, { 0, 70, 23 },
        { 0, 72, 24 }, { 0, 76, 25 }, { 0, 78, 26 }, { 0, 82, 27 }, { 0, 84, 28 }, { 0, 88, 29 }, { 0, 90, 30 }, { 0, 94, 31 },
        { 0, 96, 32 }, { 0, 100, 33 }, { 0, 104, 34 }, { 0, 106, 35 }, { 0, 110, 36 }, { 0, 112, 37 }, { 0, 116, 38 }, { 0, 118, 39 },
        { 0, 122, 40 }, { 0, 124, 41 }, { 0, 128, 42 }, { 0, 130, 43 }, { 0, 134, 44 }, { 0, 136, 45 }, { 0, 140, 46 }, { 0, 142, 47 },
        { 0, 146, 48 }, { 0, 148, 49 }, { 0, 152, 50 }, { 0, 154, 51 }, { 0, 158, 52 }, { 0, 160, 53 }, { 0, 164, 54 }, { 0, 168, 55 },
        { 0, 170, 56 }, { 0, 174, 57 }, { 0, 176, 58 }, { 0, 180, 59 }, { 0, 182, 60 }, { 0, 186, 61 }, { 0, 188, 62 }, { 0, 192, 63 },
        { 0, 194, 64 }, { 0, 198, 65 }, { 0, 200, 66 }, { 0, 204, 67 }, { 0, 206, 68 }, { 0, 210, 69 }, { 0, 212, 70 }, { 0, 216, 71 },
        { 0, 218, 72 }, { 0, 222, 73 }, { 0, 224, 74 }, { 0, 228, 75 }, { 0, 232, 76 }, { 0, 234, 77 }, { 0, 238, 78 }, { 0, 240, 79 },
        { 0, 244, 80 }, { 0, 246, 81 }, { 0, 250, 82 }, { 0, 252, 83 }, { 2, 252, 84 }, { 2, 254, 85 }, { 4, 254, 86 }, { 6, 252, 87 },
        { 8, 252, 88 }, { 8, 254, 89 }, { 10, 254, 90 }, { 12, 252, 91 }, { 14, 252, 92 }, { 14, 254, 93 }, { 16, 254, 94 }, { 18, 252, 95 },
        { 20, 252, 96 }, { 20, 254, 97 }, { 22, 254, 98 }, { 24, 252, 99 }, { 26, 250, 100 }, { 26, 254, 101 }, { 28, 252, 102 }, { 30, 252, 103 },
        { 30, 254, 104 }, { 32, 254, 105 }, { 34, 252, 106 }, { 36, 252, 107 }, { 36, 254, 108 }, { 38, 254, 109 }, { 40, 252, 110 }, { 42, 252, 111 },
        { 42, 254, 112 }, { 44, 254, 113 }, { 46, 252, 114 }, { 48, 252, 115 }, { 48, 254, 116 }, { 50, 254, 117 }, { 52, 252, 118 }, { 54, 252, 119 },
        { 54, 254, 120 }, { 56, 254, 121 }, { 58, 252, 122 }, { 60, 252, 123 }, { 60, 254, 124 }, { 62, 254, 125 }, { 64, 252, 126 }, { 66, 252, 127 },
        { 66, 254, 128 }, { 68, 254, 129 }, { 70, 252, 130 }, { 72, 252, 131 }, { 72, 254, 132 }, { 74, 254, 133 }, { 76, 252, 134 }, { 78, 252, 135 },
        { 78, 254, 136 }, { 80, 254, 137 }, { 82, 252, 138 }, { 84, 252, 139 }, { 84, 254, 140 }, { 86, 254, 141 }, { 88, 252, 142 }, { 90, 250, 143 },
        { 90, 254, 144 }, { 92, 252, 145 }, { 94, 252, 146 }, { 94, 254, 147 }, { 96, 254, 148 }, { 98, 252, 149 }, { 100, 252, 150 }, { 100, 254, 151 },
        { 102, 254, 152 }, { 104, 252, 153 }, { 106, 252, 154 }, { 106, 254, 155 }, { 108, 254, 156 }, { 110, 252, 157 }, { 112, 252, 158 }, { 112, 254, 159 },
        { 114, 254, 160 }, { 116, 252, 161 }, { 118, 252, 162 }, { 118, 254, 163 }, { 120, 254, 164 }, { 122, 252, 165 }, { 124, 252, 166 }, { 124, 254, 167 },
        { 126, 254, 168 }, { 128, 252, 169 }, { 130, 252, 170 }, { 130, 254, 171 }, { 132, 254, 172 }, { 134, 252, 173 }, { 136, 252, 174 }, { 136, 254, 175 },
        { 138, 254, 176 }, { 140, 252, 177 }, { 142, 252, 178 }, { 142, 254, 179 }, { 144, 254, 180 }, { 146, 252, 181 }, { 148, 252, 182 }, { 148, 254, 183 },
        { 150, 254, 184 }, { 152, 252, 185 }, { 154, 250, 186 }, { 154, 254, 187 }, { 156, 252, 188 }, { 158, 252, 189 }, { 158, 254, 190 }, { 160, 254, 191 },
        { 162, 252, 192 }, { 164, 252, 193 }, { 164, 254, 194 }, { 166, 254, 195 }, { 168, 252, 196 }, { 170, 252, 197 }, { 170, 254, 198 }, { 172, 254, 199 },
        { 174, 252, 200 }, { 176, 252, 201 }, { 176, 254, 202 }, { 178, 254, 203 }, { 180, 252, 204 }, { 182, 252, 205 }, { 182, 254, 206 }, { 184, 254, 207 },
        { 186, 252, 208 }, { 188, 252, 209 }, { 188, 254, 210 }, { 190, 254, 211 }, { 192, 252, 212 }, { 194, 252, 213 }, { 194, 254, 214 }, { 196, 254, 215 },
        { 198, 252, 216 }, { 200, 252, 217 }, { 200, 254, 218 }, { 202, 254, 219 }, { 204, 252, 220 }, { 206, 252, 221 }, { 206, 254, 222 }, { 208, 254, 223 },
        { 210, 252, 224 }, { 212, 252, 225 }, { 212, 254, 226 }, { 214, 254, 227 }, { 216, 252, 228 }, { 218, 250, 229 }, { 218, 254, 230 }, { 220, 252, 231 },
        { 222, 252, 232 }, { 222, 254, 233 }, { 224, 254, 234 }, { 226, 252, 235 }, { 228, 252, 236 }, { 228, 254, 237 }, { 230, 254, 238 }, { 232, 252, 239 },
        { 234, 252, 240 }, { 234, 254, 241 }, { 236, 254, 242 }, { 238, 252, 243 }, { 240, 252, 244 }, { 240, 254, 245 }, { 242, 254, 246 }, { 244, 252, 247 },
        { 246, 252, 248 }, { 246, 254, 249 }, { 248, 254, 250 }, { 250, 252, 251 }, { 252, 252, 252 }, { 252, 254, 253 }, { 254, 254, 254 }, { 254, 254, 254 },
    }
};

Table g_mode7_p01=
{
    1,
    2,
    {
        { 0, 1, 0 }, { 0, 3, 1 }, { 0, 5, 2 }, { 0, 9, 3 }, { 0, 11, 4 }, { 0, 15, 5 }, { 0, 17, 6 }, { 0, 21, 7 },
        { 0, 23, 8 }, { 0, 27, 9 }, { 0, 29, 10 }, { 0, 33, 11 }, { 0, 37, 12 }, { 0, 39, 13 }, { 0, 43, 14 }, { 0, 45, 15 },
        { 0, 49, 16 }, { 0, 51, 17 }, { 0, 55, 18 }, { 0, 57, 19 }, { 0, 61, 20 }, { 0, 63, 21 }, { 0, 67, 22 }, { 0, 69, 23 },
        { 0, 73, 24 }, { 0, 75, 25 }, { 0, 79, 26 }, { 0, 81, 27 }, { 0, 85, 28 }, { 0, 87, 29 }, { 0, 91, 30 }, { 0, 93, 31 },
        { 0, 97, 32 }, { 0, 101, 33 }, { 0, 103, 34 }, { 0, 107, 35 }, { 0, 109, 36 }, { 0, 113, 37 }, { 0, 115, 38 }, { 0, 119, 39 },
        { 0, 121, 40 }, { 0, 125, 41 }, { 0, 127, 42 }, { 0, 131, 43 }, { 0, 133, 44 }, { 0, 137, 45 }, { 0, 139, 46 }, { 0, 143, 47 },
        { 0, 145, 48 }, { 0, 149, 49 }, { 0, 151, 50 }, { 0, 155, 51 }, { 0, 157, 52 }, { 0, 161, 53 }, { 0, 165, 54 }, { 0, 167, 55 },
        { 0, 171, 56 }, { 0, 173, 57 }, { 0, 177, 58 }, { 0, 179, 59 }, { 0, 183, 60 }, { 0, 185, 61 }, { 0, 189, 62 }, { 0, 191, 63 },
        { 0, 195, 64 }, { 0, 197, 65 }, { 0, 201, 66 }, { 0, 203, 67 }, { 0, 207, 68 }, { 0, 209, 69 }, { 0, 213, 70 }, { 0, 215, 71 },
        { 0, 219, 72 }, { 0, 221, 73 }, { 0, 225, 74 }, { 0, 229, 75 }, { 0, 231, 76 }, { 0, 235, 77 }, { 0, 237, 78 }, { 0, 241, 79 },
        { 0, 243, 80 }, { 0, 247, 81 }, { 0, 249, 82 }, { 0, 253, 83 }, { 0, 255, 84 }, { 2, 255, 85 }, { 4, 253, 86 }, { 6, 253, 87 },
        { 6, 255, 88 }, { 8, 255, 89 }, { 10, 253, 90 }, { 12, 253, 91 }, { 12, 255, 92 }, { 14, 255, 93 }, { 16, 253, 94 }, { 18, 253, 95 },
        { 18, 255, 96 }, { 20, 255, 97 }, { 22, 253, 98 }, { 24, 253, 99 }, { 24, 255, 100 }, { 26, 255, 101 }, { 28, 253, 102 }, { 30, 251, 103 },
        { 30, 255, 104 }, { 32, 253, 105 }, { 34, 253, 106 }, { 34, 255, 107 }, { 36, 255, 108 }, { 38, 253, 109 }, { 40, 253, 110 }, { 40, 255, 111 },
        { 42, 255, 112 }, { 44, 253, 113 }, { 46, 253, 114 }, { 46, 255, 115 }, { 48, 255, 116 }, { 50, 253, 117 }, { 52, 253, 118 }, { 52, 255, 119 },
        { 54, 255, 120 }, { 56, 253, 121 }, { 58, 253, 122 }, { 58, 255, 123 }, { 60, 255, 124 }, { 62, 253, 125 }, { 64, 253, 126 }, { 64, 255, 127 },
        { 66, 255, 128 }, { 68, 253, 129 }, { 70, 253, 130 }, { 70, 255, 131 }, { 72, 255, 132 }, { 74, 253, 133 }, { 76, 253, 134 }, { 76, 255, 135 },
        { 78, 255, 136 }, { 80, 253, 137 }, { 82, 253, 138 }, { 82, 255, 139 }, { 84, 255, 140 }, { 86, 253, 141 }, { 88, 253, 142 }, { 88, 255, 143 },
        { 90, 255, 144 }, { 92, 253, 145 }, { 94, 251, 146 }, { 94, 255, 147 }, { 96, 253, 148 }, { 98, 253, 149 }, { 98, 255, 150 }, { 100, 255, 151 },
        { 102, 253, 152 }, { 104, 253, 153 }, { 104, 255, 154 }, { 106, 255, 155 }, { 108, 253, 156 }, { 110, 253, 157 }, { 110, 255, 158 }, { 112, 255, 159 },
        { 114, 253, 160 }, { 116, 253, 161 }, { 116, 255, 162 }, { 118, 255, 163 }, { 120, 253, 164 }, { 122, 253, 165 }, { 122, 255, 166 }, { 124, 255, 167 },
        { 126, 253, 168 }, { 128, 253, 169 }, { 128, 255, 170 }, { 130, 255, 171 }, { 132, 253, 172 }, { 134, 253, 173 }, { 134, 255, 174 }, { 136, 255, 175 },
        { 138, 253, 176 }, { 140, 253, 177 }, { 140, 255, 178 }, { 142, 255, 179 }, { 144, 253, 180 }, { 146, 253, 181 }, { 146, 255, 182 }, { 148, 255, 183 },
        { 150, 253, 184 }, { 152, 253, 185 }, { 152, 255, 186 }, { 154, 255, 187 }, { 156, 253, 188 }, { 158, 251, 189 }, { 158, 255, 190 }, { 160, 253, 191 },
        { 162, 253, 192 }, { 162, 255, 193 }, { 164, 255, 194 }, { 166, 253, 195 }, { 168, 253, 196 }, { 168, 255, 197 }, { 170, 255, 198 }, { 172, 253, 199 },
        { 174, 253, 200 }, { 174, 255, 201 }, { 176, 255, 202 }, { 178, 253, 203 }, { 180, 253, 204 }, { 180, 255, 205 }, { 182, 255, 206 }, { 184, 253, 207 },
        { 186, 253, 208 }, { 186, 255, 209 }, { 188, 255, 210 }, { 190, 253, 211 }, { 192, 253, 212 }, { 192, 255, 213 }, { 194, 255, 214 }, { 196, 253, 215 },
        { 198, 253, 216 }, { 198, 255, 217 }, { 200, 255, 218 }, { 202, 253, 219 }, { 204, 253, 220 }, { 204, 255, 221 }, { 206, 255, 222 }, { 208, 253, 223 },
        { 210, 253, 224 }, { 210, 255, 225 }, { 212, 255, 226 }, { 214, 253, 227 }, { 216, 253, 228 }, { 216, 255, 229 }, { 218, 255, 230 }, { 220, 253, 231 },
        { 222, 251, 232 }, { 222, 255, 233 }, { 224, 253, 234 }, { 226, 253, 235 }, { 226, 255, 236 }, { 228, 255, 237 }, { 230, 253, 238 }, { 232, 253, 239 },
        { 232, 255, 240 }, { 234, 255, 241 }, { 236, 253, 242 }, { 238, 253, 243 }, { 238, 255, 244 }, { 240, 255, 245 }, { 242, 253, 246 }, { 244, 253, 247 },
        { 244, 255, 248 }, { 246, 255, 249 }, { 248, 253, 250 }, { 250, 253, 251 }, { 250, 255, 252 }, { 252, 255, 253 }, { 254, 253, 254 }, { 254, 253, 254 },
    }
};

Table g_mode7_p10=
{
    1,
    1,
    {
        { 1, 0, 1 }, { 1, 0, 1 }, { 1, 4, 2 }, { 1, 6, 3 }, { 1, 10, 4 }, { 1, 12, 5 }, { 1, 16, 6 }, { 1, 18, 7 },
        { 1, 22, 8 }, { 1, 24, 9 }, { 1, 28, 10 }, { 1, 30, 11 }, { 1, 34, 12 }, { 1, 38, 13 }, { 1, 40, 14 }, { 1, 44, 15 },
        { 1, 46, 16 }, { 1, 50, 17 }, { 1, 52, 18 }, { 1, 56, 19 }, { 1, 58, 20 }, { 1, 62, 21 }, { 1, 64, 22 }, { 1, 68, 23 },
        { 1, 70, 24 }, { 1, 74, 25 }, { 1, 76, 26 }, { 1, 80, 27 }, { 1, 82, 28 }, { 1, 86, 29 }, { 1, 88, 30 }, { 1, 92, 31 },
        { 1, 94, 32 }, { 1, 98, 33 }, { 1, 102, 34 }, { 1, 104, 35 }, { 1, 108, 36 }, { 1, 110, 37 }, { 1, 114, 38 }, { 1, 116, 39 },
        { 1, 120, 40 }, { 1, 122, 41 }, { 1, 126, 42 }, { 1, 128, 43 }, { 1, 132, 44 }, { 1, 134, 45 }, { 1, 138, 46 }, { 1, 140, 47 },
        { 1, 144, 48 }, { 1, 146, 49 }, { 1, 150, 50 }, { 1, 152, 51 }, { 1, 156, 52 }, { 1, 158, 53 }, { 1, 162, 54 }, { 1, 166, 55 },
        { 1, 168, 56 }, { 1, 172, 57 }, { 1, 174, 58 }, { 1, 178, 59 }, { 1, 180, 60 }, { 1, 184, 61 }, { 1, 186, 62 }, { 1, 190, 63 },
        { 1, 192, 64 }, { 1, 196, 65 }, { 1, 198, 66 }, { 1, 202, 67 }, { 1, 204, 68 }, { 1, 208, 69 }, { 1, 210, 70 }, { 1, 214, 71 },
        { 1, 216, 72 }, { 1, 220, 73 }, { 1, 222, 74 }, { 1, 226, 75 }, { 1, 230, 76 }, { 1, 232, 77 }, { 1, 236, 78 }, { 1, 238, 79 },
        { 1, 242, 80 }, { 1, 244, 81 }, { 1, 248, 82 }, { 1, 250, 83 }, { 1, 254, 84 }, { 3, 252, 85 }, { 5, 252, 86 }, { 5, 254, 87 },
        { 7, 254, 88 }, { 9, 252, 89 }, { 11, 252, 90 }, { 11, 254, 91 }, { 13, 254, 92 }, { 15, 252, 93 }, { 17, 252, 94 }, { 17, 254, 95 },
        { 19, 254, 96 }, { 21, 252, 97 }, { 23, 252, 98 }, { 23, 254, 99 }, { 25, 254, 100 }, { 27, 252, 101 }, { 29, 250, 102 }, { 29, 254, 103 },
        { 31, 252, 104 }, { 33, 252, 105 }, { 33, 254, 106 }, { 35, 254, 107 }, { 37, 252, 108 }, { 39, 252, 109 }, { 39, 254, 110 }, { 41, 254, 111 },
        { 43, 252, 112 }, { 45, 252, 113 }, { 45, 254, 114 }, { 47, 254, 115 }, { 49, 252, 116 }, { 51, 252, 117 }, { 51, 254, 118 }, { 53, 254, 119 },
        { 55, 252, 120 }, { 57, 252, 121 }, { 57, 254, 122 }, { 59, 254, 123 }, { 61, 252, 124 }, { 63, 252, 125 }, { 63, 254, 126 }, { 65, 254, 127 },
        { 67, 252, 128 }, { 69, 252, 129 }, { 69, 254, 130 }, { 71, 254, 131 }, { 73, 252, 132 }, { 75, 252, 133 }, { 75, 254, 134 }, { 77, 254, 135 },
        { 79, 252, 136 }, { 81, 252, 137 }, { 81, 254, 138 }, { 83, 254, 139 }, { 85, 252, 140 }, { 87, 252, 141 }, { 87, 254, 142 }, { 89, 254, 143 },
        { 91, 252, 144 }, { 93, 250, 145 }, { 93, 254, 146 }, { 95, 252, 147 }, { 97, 252, 148 }, { 97, 254, 149 }, { 99, 254, 150 }, { 101, 252, 151 },
        { 103, 252, 152 }, { 103, 254, 153 }, { 105, 254, 154 }, { 107, 252, 155 }, { 109, 252, 156 }, { 109, 254, 157 }, { 111, 254, 158 }, { 113, 252, 159 },
        { 115, 252, 160 }, { 115, 254, 161 }, { 117, 254, 162 }, { 119, 252, 163 }, { 121, 252, 164 }, { 121, 254, 165 }, { 123, 254, 166 }, { 125, 252, 167 },
        { 127, 252, 168 }, { 127, 254, 169 }, { 129, 254, 170 }, { 131, 252, 171 }, { 133, 252, 172 }, { 133, 254, 173 }, { 135, 254, 174 }, { 137, 252, 175 },
        { 139, 252, 176 }, { 139, 254, 177 }, { 141, 254, 178 }, { 143, 252, 179 }, { 145, 252, 180 }, { 145, 254, 181 }, { 147, 254, 182 }, { 149, 252, 183 },
        { 151, 252, 184 }, { 151, 254, 185 }, { 153, 254, 186 }, { 155, 252, 187 }, { 157, 250, 188 }, { 157, 254, 189 }, { 159, 252, 190 }, { 161, 252, 191 },
        { 161, 254, 192 }, { 163, 254, 193 }, { 165, 252, 194 }, { 167, 252, 195 }, { 167, 254, 196 }, { 169, 254, 197 }, { 171, 252, 198 }, { 173, 252, 199 },
        { 173, 254, 200 }, { 175, 254, 201 }, { 177, 252, 202 }, { 179, 252, 203 }, { 179, 254, 204 }, { 181, 254, 205 }, { 183, 252, 206 }, { 185, 252, 207 },
        { 185, 254, 208 }, { 187, 254, 209 }, { 189, 252, 210 }, { 191, 252, 211 }, { 191, 254, 212 }, { 193, 254, 213 }, { 195, 252, 214 }, { 197, 252, 215 },
        { 197, 254, 216 }, { 199, 254, 217 }, { 201, 252, 218 }, { 203, 252, 219 }, { 203, 254, 220 }, { 205, 254, 221 }, { 207, 252, 222 }, { 209, 252, 223 },
        { 209, 254, 224 }, { 211, 254, 225 }, { 213, 252, 226 }, { 215, 252, 227 }, { 215, 254, 228 }, { 217, 254, 229 }, { 219, 252, 230 }, { 221, 250, 231 },
        { 221, 254, 232 }, { 223, 252, 233 }, { 225, 252, 234 }, { 225, 254, 235 }, { 227, 254, 236 }, { 229, 252, 237 }, { 231, 252, 238 }, { 231, 254, 239 },
        { 233, 254, 240 }, { 235, 252, 241 }, { 237, 252, 242 }, { 237, 254, 243 }, { 239, 254, 244 }, { 241, 252, 245 }, { 243, 252, 246 }, { 243, 254, 247 },
        { 245, 254, 248 }, { 247, 252, 249 }, { 249, 252, 250 }, { 249, 254, 251 }, { 251, 254, 252 }, { 253, 252, 253 }, { 255, 252, 254 }, { 255, 254, 255 },
    }
};

Table g_mode7_p11=
{
    1,
    3,
    {
        { 1, 1, 1 }, { 1, 1, 1 }, { 1, 3, 2 }, { 1, 7, 3 }, { 1, 9, 4 }, { 1, 13, 5 }, { 1, 15, 6 }, { 1, 19, 7 },
        { 1, 21, 8 }, { 1, 25, 9 }, { 1, 27, 10 }, { 1, 31, 11 }, { 1, 33, 12 }, { 1, 37, 13 }, { 1, 41, 14 }, { 1, 43, 15 },
        { 1, 47, 16 }, { 1, 49, 17 }, { 1, 53, 18 }, { 1, 55, 19 }, { 1, 59, 20 }, { 1, 61, 21 }, { 1, 65, 22 }, { 1, 67, 23 },
        { 1, 71, 24 }, { 1, 73, 25 }, { 1, 77, 26 }, { 1, 79, 27 }, { 1, 83, 28 }, { 1, 85, 29 }, { 1, 89, 30 }, { 1, 91, 31 },
        { 1, 95, 32 }, { 1, 97, 33 }, { 1, 101, 34 }, { 1, 105, 35 }, { 1, 107, 36 }, { 1, 111, 37 }, { 1, 113, 38 }, { 1, 117, 39 },
        { 1, 119, 40 }, { 1, 123, 41 }, { 1, 125, 42 }, { 1, 129, 43 }, { 1, 131, 44 }, { 1, 135, 45 }, { 1, 137, 46 }, { 1, 141, 47 },
        { 1, 143, 48 }, { 1, 147, 49 }, { 1, 149, 50 }, { 1, 153, 51 }, { 1, 155, 52 }, { 1, 159, 53 }, { 1, 161, 54 }, { 1, 165, 55 },
        { 1, 169, 56 }, { 1, 171, 57 }, { 1, 175, 58 }, { 1, 177, 59 }, { 1, 181, 60 }, { 1, 183, 61 }, { 1, 187, 62 }, { 1, 189, 63 },
        { 1, 193, 64 }, { 1, 195, 65 }, { 1, 199, 66 }, { 1, 201, 67 }, { 1, 205, 68 }, { 1, 207, 69 }, { 1, 211, 70 }, { 1, 213, 71 },
        { 1, 217, 72 }, { 1, 219, 73 }, { 1, 223, 74 }, { 1, 225, 75 }, { 1, 229, 76 }, { 1, 233, 77 }, { 1, 235, 78 }, { 1, 239, 79 },
        { 1, 241, 80 }, { 1, 245, 81 }, { 1, 247, 82 }, { 1, 251, 83 }, { 1, 253, 84 }, { 3, 253, 85 }, { 3, 255, 86 }, { 5, 255, 87 },
        { 7, 253, 88 }, { 9, 253, 89 }, { 9, 255, 90 }, { 11, 255, 91 }, { 13, 253, 92 }, { 15, 253, 93 }, { 15, 255, 94 }, { 17, 255, 95 },
        { 19, 253, 96 }, { 21, 253, 97 }, { 21, 255, 98 }, { 23, 255, 99 }, { 25, 253, 100 }, { 27, 251, 101 }, { 27, 255, 102 }, { 29, 253, 103 },
        { 31, 253, 104 }, { 31, 255, 105 }, { 33, 255, 106 }, { 35, 253, 107 }, { 37, 253, 108 }, { 37, 255, 109 }, { 39, 255, 110 }, { 41, 253, 111 },
        { 43, 253, 112 }, { 43, 255, 113 }, { 45, 255, 114 }, { 47, 253, 115 }, { 49, 253, 116 }, { 49, 255, 117 }, { 51, 255, 118 }, { 53, 253, 119 },
        { 55, 253, 120 }, { 55, 255, 121 }, { 57, 255, 122 }, { 59, 253, 123 }, { 61, 253, 124 }, { 61, 255, 125 }, { 63, 255, 126 }, { 65, 253, 127 },
        { 67, 253, 128 }, { 67, 255, 129 }, { 69, 255, 130 }, { 71, 253, 131 }, { 73, 253, 132 }, { 73, 255, 133 }, { 75, 255, 134 }, { 77, 253, 135 },
        { 79, 253, 136 }, { 79, 255, 137 }, { 81, 255, 138 }, { 83, 253, 139 }, { 85, 253, 140 }, { 85, 255, 141 }, { 87, 255, 142 }, { 89, 253, 143 },
        { 91, 251, 144 }, { 91, 255, 145 }, { 93, 253, 146 }, { 95, 253, 147 }, { 95, 255, 148 }, { 97, 255, 149 }, { 99, 253, 150 }, { 101, 253, 151 },
        { 101, 255, 152 }, { 103, 255, 153 }, { 105, 253, 154 }, { 107, 253, 155 }, { 107, 255, 156 }, { 109, 255, 157 }, { 111, 253, 158 }, { 113, 253, 159 },
        { 113, 255, 160 }, { 115, 255, 161 }, { 117, 253, 162 }, { 119, 253, 163 }, { 119, 255, 164 }, { 121, 255, 165 }, { 123, 253, 166 }, { 125, 253, 167 },
        { 125, 255, 168 }, { 127, 255, 169 }, { 129, 253, 170 }, { 131, 253, 171 }, { 131, 255, 172 }, { 133, 255, 173 }, { 135, 253, 174 }, { 137, 253, 175 },
        { 137, 255, 176 }, { 139, 255, 177 }, { 141, 253, 178 }, { 143, 253, 179 }, { 143, 255, 180 }, { 145, 255, 181 }, { 147, 253, 182 }, { 149, 253, 183 },
        { 149, 255, 184 }, { 151, 255, 185 }, { 153, 253, 186 }, { 155, 251, 187 }, { 155, 255, 188 }, { 157, 253, 189 }, { 159, 253, 190 }, { 159, 255, 191 },
        { 161, 255, 192 }, { 163, 253, 193 }, { 165, 253, 194 }, { 165, 255, 195 }, { 167, 255, 196 }, { 169, 253, 197 }, { 171, 253, 198 }, { 171, 255, 199 },
        { 173, 255, 200 }, { 175, 253, 201 }, { 177, 253, 202 }, { 177, 255, 203 }, { 179, 255, 204 }, { 181, 253, 205 }, { 183, 253, 206 }, { 183, 255, 207 },
        { 185, 255, 208 }, { 187, 253, 209 }, { 189, 253, 210 }, { 189, 255, 211 }, { 191, 255, 212 }, { 193, 253, 213 }, { 195, 253, 214 }, { 195, 255, 215 },
        { 197, 255, 216 }, { 199, 253, 217 }, { 201, 253, 218 }, { 201, 255, 219 }, { 203, 255, 220 }, { 205, 253, 221 }, { 207, 253, 222 }, { 207, 255, 223 },
        { 209, 255, 224 }, { 211, 253, 225 }, { 213, 253, 226 }, { 213, 255, 227 }, { 215, 255, 228 }, { 217, 253, 229 }, { 219, 251, 230 }, { 219, 255, 231 },
        { 221, 253, 232 }, { 223, 253, 233 }, { 223, 255, 234 }, { 225, 255, 235 }, { 227, 253, 236 }, { 229, 253, 237 }, { 229, 255, 238 }, { 231, 255, 239 },
        { 233, 253, 240 }, { 235, 253, 241 }, { 235, 255, 242 }, { 237, 255, 243 }, { 239, 253, 244 }, { 241, 253, 245 }, { 241, 255, 246 }, { 243, 255, 247 },
        { 245, 253, 248 }, { 247, 253, 249 }, { 247, 255, 250 }, { 249, 255, 251 }, { 251, 253, 252 }, { 253, 253, 253 }, { 253, 255, 254 }, { 255, 255, 255 },
    }
};

}}}
