// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#ifndef __SampleShellH
#define __SampleShellH

#include "defines.h"
#include "structs.h"
#include "Sample.h"

#ifdef USE_X

#include <qapp.h>
#include <qlistbox.h>
#include <qpushbt.h>

class SampleShell : public QWidget
{
  Q_OBJECT

public:
  SampleShell(QWidget *w = 0);
  void setSamples(Sample **, int);
  
 public slots:
 void showSampleShell();

protected:
  void resizeEvent(QResizeEvent *);

private:
  QListBox *sampleList;
  QPushButton *closeButton;

 private slots:
 void closeSampleShell();
};

#else /* !USE_X */

class SampleShell
{
public:
#ifdef USE_NCURSES
  SampleShell(int);
  void scrollSamples(int);
#else
  SampleShell(int, int);
#endif
  void setSamples(Sample **, int);

private:
  int background_;

#ifdef USE_NCURSES
  int firstVisible_;
  int nrSamples_;
  int sampleLines_;
  WINDOW *sampleWin_;
#else
  int showEmpty_;
#endif
};

#endif

#endif
