/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.DisplayRealType;
import visad.RealType;
import visad.Set;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.Quantity;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryDisplayRealType;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryQuantity;
import visad.data.visad.object.BinarySerializedObject;
import visad.data.visad.object.BinaryString;
import visad.data.visad.object.BinaryUnit;

public class BinaryRealType
implements BinaryObject {
    public static final int computeBytes(RealType rt) {
        return 9 + BinaryString.computeBytes(rt.getName()) + (rt.getDefaultUnit() == null ? 0 : 5) + (rt.getDefaultSet() == null ? 0 : 1) + 1;
    }

    public static final RealType read(BinaryReader reader, int index) throws IOException, VisADException {
        BinaryObjectCache typeCache = reader.getTypeCache();
        BinaryObjectCache unitCache = reader.getUnitCache();
        DataInput file = reader.getInput();
        int attrMask = file.readInt();
        String name = BinaryString.read(reader);
        Unit u = null;
        boolean setFollowsType = false;
        boolean reading = true;
        block9: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 30: {
                    int uIndex = file.readInt();
                    u = (Unit)unitCache.get(uIndex);
                    continue block9;
                }
                case 70: {
                    setFollowsType = true;
                    continue block9;
                }
                case 80: {
                    reading = false;
                    continue block9;
                }
            }
            throw new IOException("Unknown RealType directive " + directive);
        }
        RealType rt = RealType.getRealType(name, u, null, attrMask);
        typeCache.add(index, rt);
        if (setFollowsType) {
            Set set = (Set)BinaryGeneric.read(reader);
            try {
                rt.setDefaultSet(set);
            }
            catch (TypeException te) {
                // empty catch block
            }
        }
        return rt;
    }

    public static final int write(BinaryWriter writer, RealType rt, Object token) throws IOException {
        if (rt instanceof DisplayRealType) {
            return BinaryDisplayRealType.write(writer, (DisplayRealType)rt, token);
        }
        if (rt instanceof Quantity) {
            return BinaryQuantity.write(writer, (Quantity)rt, token);
        }
        BinaryObjectCache cache = writer.getTypeCache();
        int index = cache.getIndex(rt);
        if (index < 0) {
            index = cache.add(rt);
            if (index < 0) {
                throw new IOException("Couldn't cache RealType " + rt);
            }
            if (!(rt.getClass().equals(RealType.class) || rt instanceof RealType && rt instanceof Saveable)) {
                BinarySerializedObject.write(writer, (byte)6, rt, token);
                return index;
            }
            String name = rt.getName();
            Set dfltSet = rt.getDefaultSet();
            int uIndex = -1;
            Unit u = rt.getDefaultUnit();
            if (u != null) {
                uIndex = BinaryUnit.write(writer, u, token);
            }
            int objLen = BinaryRealType.computeBytes(rt);
            DataOutput file = writer.getOutput();
            file.writeByte(5);
            file.writeInt(objLen);
            file.writeInt(index);
            file.writeByte(2);
            file.writeInt(rt.getAttributeMask());
            BinaryString.write(writer, name, token);
            if (uIndex >= 0) {
                file.writeByte(30);
                file.writeInt(uIndex);
            }
            if (dfltSet != null) {
                file.writeByte(70);
            }
            file.writeByte(80);
            if (dfltSet != null) {
                Object dependToken = token == SAVE_DEPEND_BIG ? token : SAVE_DEPEND;
                BinaryGeneric.write(writer, dfltSet, dependToken);
                BinaryGeneric.write(writer, dfltSet, SAVE_DATA);
            }
        }
        return index;
    }
}

