/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.visad.FakeData;
import visad.data.visad.VisADForm;

public class TestBinary {
    private static final String OUTPUT_SUBDIRECTORY = "tstout";
    private String progName;
    private boolean allowBinary;
    private boolean verbose;
    private String[] files;

    public TestBinary(String[] args) throws VisADException {
        this.initArgs();
        if (!this.processArgs(args)) {
            System.err.println("Exiting...");
            System.exit(1);
        }
        DefaultFamily df = new DefaultFamily("DefaultFamily");
        VisADForm form = new VisADForm(this.allowBinary);
        if (!this.makeSubdirectory(OUTPUT_SUBDIRECTORY)) {
            throw new VisADException("Couldn't create test subdirectory \"tstout\"");
        }
        boolean success = true;
        if (this.files != null) {
            for (int i = 0; i < this.files.length; ++i) {
                DataImpl data;
                try {
                    data = df.open(this.files[i]);
                }
                catch (BadFormException bfe) {
                    System.err.println("Couldn't read " + this.files[i] + ": " + bfe.getMessage());
                    success = false;
                    continue;
                }
                System.out.println(this.files[i]);
                success &= this.writeData(form, data, i);
                if (!this.verbose) continue;
                System.out.println("-- ");
            }
        } else {
            DataImpl[] dataList = new FakeData().getList();
            for (int i = 0; i < dataList.length; ++i) {
                success &= this.writeData(form, dataList[i], i);
                if (!this.verbose) continue;
                System.out.println("-- ");
            }
        }
        if (success) {
            System.out.println("All tests succeeded!");
        }
    }

    private int getSerializedSize(Object obj) {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outStream = new ObjectOutputStream(outBytes);
            outStream.writeObject(obj);
            outStream.flush();
            outStream.close();
        }
        catch (IOException ioe) {
            return 0;
        }
        return outBytes.size();
    }

    public void initArgs() {
        this.verbose = false;
        this.allowBinary = false;
        this.files = null;
    }

    private boolean makeSubdirectory(String name) {
        File subdir = new File(name);
        if (subdir.isDirectory()) {
            return true;
        }
        if (subdir.exists()) {
            System.err.println(this.progName + ": Subdirectory \"" + name + "\" exists but is not a directory");
            return false;
        }
        return subdir.mkdir();
    }

    public boolean processArgs(String[] args) {
        int i;
        boolean usage = false;
        String className = this.getClass().getName();
        int pt = className.lastIndexOf(46);
        int ds = className.lastIndexOf(36);
        if (ds > pt) {
            pt = ds;
        }
        this.progName = className.substring(pt == -1 ? 0 : pt + 1);
        ArrayList<String> fileList = null;
        for (i = 0; args != null && i < args.length; ++i) {
            if (args[i].length() > 0 && args[i].charAt(0) == '-') {
                char ch = args[i].charAt(1);
                switch (ch) {
                    case 'a': {
                        this.allowBinary = true;
                        break;
                    }
                    case 'v': {
                        this.verbose = true;
                        break;
                    }
                    default: {
                        System.err.println(this.progName + ": Unknown option \"-" + ch + "\"");
                        usage = true;
                        break;
                    }
                }
                continue;
            }
            if (fileList == null) {
                fileList = new ArrayList<String>();
            }
            fileList.add(args[i]);
        }
        if (usage) {
            System.err.println("Usage: " + this.getClass().getName() + " [-a(llowBinary)]" + " [-v(erbose)]" + "");
        }
        if (fileList != null) {
            this.files = new String[fileList.size()];
            for (i = 0; i < this.files.length; ++i) {
                this.files[i] = (String)fileList.get(i);
            }
            fileList.clear();
        }
        return !usage;
    }

    private boolean writeData(Form form, DataImpl data, int num) {
        DataImpl newData;
        String path = OUTPUT_SUBDIRECTORY + File.separatorChar + "binary" + num + ".vad";
        if (this.verbose) {
            System.out.println("Writing " + data.getClass().getName() + " to " + path);
        }
        try {
            form.save(path, data, true);
        }
        catch (Throwable t) {
            t.printStackTrace();
            new File(path).delete();
            return false;
        }
        if (this.verbose) {
            System.out.println("Reading " + data.getClass().getName());
        }
        try {
            newData = form.open(path);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        if (newData == null) {
            System.err.println("Got null Data while reading " + data);
            return false;
        }
        if (!data.equals(newData)) {
            System.err.println("MISMATCH");
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            new TestBinary(args);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
        }
        System.exit(0);
    }
}

