/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.Delaunay;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DDoubleSet;
import visad.Gridded2DSet;
import visad.Gridded3DDoubleSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.IntegerNDSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.LinearNDSet;
import visad.List1DSet;
import visad.ProductSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.SimpleSet;
import visad.SingletonSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.data.BaseDataProcessor;
import visad.data.DataWriter;
import visad.data.visad.BinaryFile;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.object.BinaryFieldImpl;
import visad.data.visad.object.BinaryFlatField;
import visad.data.visad.object.BinaryGriddedDoubleSet;
import visad.data.visad.object.BinaryGriddedSet;
import visad.data.visad.object.BinaryIntegerSet;
import visad.data.visad.object.BinaryIrregularSet;
import visad.data.visad.object.BinaryLinearSet;
import visad.data.visad.object.BinaryList1DSet;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryProductSet;
import visad.data.visad.object.BinaryReal;
import visad.data.visad.object.BinaryRealTuple;
import visad.data.visad.object.BinarySimpleSet;
import visad.data.visad.object.BinarySingletonSet;
import visad.data.visad.object.BinaryText;
import visad.data.visad.object.BinaryTuple;
import visad.data.visad.object.BinaryUnionSet;
import visad.data.visad.object.BinaryUnknown;

public class BinaryWriter
extends BaseDataProcessor
implements BinaryFile,
DataWriter {
    private boolean initialized;
    private DataOutputStream file;
    private BinaryObjectCache unitCache;
    private BinaryObjectCache errorCache;
    private BinaryObjectCache cSysCache;
    private BinaryObjectCache typeCache;

    public BinaryWriter() {
        this.file = null;
    }

    public BinaryWriter(String name) throws IOException {
        this(new File(name));
    }

    public BinaryWriter(File ref) throws IOException {
        this(new BufferedOutputStream(new FileOutputStream(ref)));
    }

    public BinaryWriter(OutputStream stream) throws IOException {
        this.setOutputStream(stream);
    }

    public void close() throws IOException {
        this.file.close();
        this.file = null;
    }

    public void flush() throws IOException {
        if (this.file == null) {
            throw new IOException("No active file");
        }
        this.file.flush();
    }

    public final BinaryObjectCache getCoordinateSystemCache() {
        return this.cSysCache;
    }

    public final BinaryObjectCache getErrorEstimateCache() {
        return this.errorCache;
    }

    public final DataOutput getOutput() {
        return this.file;
    }

    public final BinaryObjectCache getTypeCache() {
        return this.typeCache;
    }

    public final BinaryObjectCache getUnitCache() {
        return this.unitCache;
    }

    private final void initVars() {
        if (!this.initialized) {
            this.file = null;
        }
        this.unitCache = new BinaryObjectCache();
        this.errorCache = new BinaryObjectCache();
        this.cSysCache = new BinaryObjectCache();
        this.typeCache = new BinaryObjectCache();
    }

    public void processDoubleSet(SetType type, CoordinateSystem cs, Unit[] units, DoubleSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinarySimpleSet.write(this, type, cs, units, set, DoubleSet.class, (byte)32, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write " + set.getClass().getName() + ": " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processFieldImpl(FunctionType type, Set set, FieldImpl fld, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (fld == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryFieldImpl.write(this, type, set, fld, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write " + fld.getClass().getName() + ": " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processFlatField(FunctionType type, Set domainSet, CoordinateSystem cs, CoordinateSystem[] rangeCS, Set[] rangeSets, Unit[] units, FlatField fld, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (fld == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryFlatField.write(this, type, domainSet, cs, rangeCS, rangeSets, units, fld, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write " + fld.getClass().getName() + ": " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processFloatSet(SetType type, CoordinateSystem cs, Unit[] units, FloatSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinarySimpleSet.write(this, type, cs, units, set, FloatSet.class, (byte)33, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write " + set.getClass().getName() + ": " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processGridded1DDoubleSet(SetType type, double[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Gridded1DDoubleSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryGriddedDoubleSet.write(this, type, samples, lengths, cs, units, errors, set, Gridded1DDoubleSet.class, (byte)47, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Gridded1DDoubleSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processGridded2DDoubleSet(SetType type, double[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Gridded2DDoubleSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryGriddedDoubleSet.write(this, type, samples, lengths, cs, units, errors, set, Gridded2DDoubleSet.class, (byte)48, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Gridded2DDoubleSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processGridded3DDoubleSet(SetType type, double[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Gridded3DDoubleSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryGriddedDoubleSet.write(this, type, samples, lengths, cs, units, errors, set, Gridded3DDoubleSet.class, (byte)49, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Gridded3DDoubleSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processGridded1DSet(SetType type, float[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Gridded1DSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryGriddedSet.write(this, type, samples, lengths, cs, units, errors, set, Gridded1DSet.class, (byte)44, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Gridded1DSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processGridded2DSet(SetType type, float[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Gridded2DSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryGriddedSet.write(this, type, samples, lengths, cs, units, errors, set, Gridded2DSet.class, (byte)45, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Gridded2DSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processGridded3DSet(SetType type, float[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Gridded3DSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryGriddedSet.write(this, type, samples, lengths, cs, units, errors, set, Gridded3DSet.class, (byte)46, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Gridded3DSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processGriddedSet(SetType type, float[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, GriddedSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryGriddedSet.write(this, type, samples, lengths, cs, units, errors, set, GriddedSet.class, (byte)43, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write GriddedSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processInteger1DSet(SetType type, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Integer1DSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryIntegerSet.write(this, type, lengths, null, cs, units, errors, set, Integer1DSet.class, (byte)55, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Integer1DSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processInteger2DSet(SetType type, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Integer2DSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        Integer1DSet[] comps = BinaryIntegerSet.getComponents(set);
        try {
            BinaryIntegerSet.write(this, type, lengths, comps, cs, units, errors, set, Integer2DSet.class, (byte)56, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Integer2DSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processInteger3DSet(SetType type, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Integer3DSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        Integer1DSet[] comps = BinaryIntegerSet.getComponents(set);
        try {
            BinaryIntegerSet.write(this, type, lengths, comps, cs, units, errors, set, Integer3DSet.class, (byte)57, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Integer3DSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processIntegerNDSet(SetType type, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, IntegerNDSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        Integer1DSet[] comps = BinaryIntegerSet.getComponents(set);
        try {
            BinaryIntegerSet.write(this, type, lengths, comps, cs, units, errors, set, IntegerNDSet.class, (byte)58, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write IntegerNDSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processIrregular1DSet(SetType type, float[][] samples, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Irregular1DSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryIrregularSet.write(this, type, samples, cs, units, errors, null, set, Irregular1DSet.class, (byte)40, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Irregular1DSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processIrregular2DSet(SetType type, float[][] samples, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Delaunay delaunay, Irregular2DSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryIrregularSet.write(this, type, samples, cs, units, errors, delaunay, set, Irregular2DSet.class, (byte)41, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Irregular2DSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processIrregular3DSet(SetType type, float[][] samples, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Delaunay delaunay, Irregular3DSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryIrregularSet.write(this, type, samples, cs, units, errors, delaunay, set, Irregular3DSet.class, (byte)42, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Irregular3DSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processIrregularSet(SetType type, float[][] samples, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Delaunay delaunay, IrregularSet set, Object token) throws VisADException {
        try {
            BinaryIrregularSet.write(this, type, samples, cs, units, errors, delaunay, set, IrregularSet.class, (byte)39, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write IrregularSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processLinear1DSet(SetType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Linear1DSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryLinearSet.write(this, type, firsts, lasts, lengths, null, cs, units, errors, set, Linear1DSet.class, (byte)50, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Linear1DSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processLinear2DSet(SetType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Linear2DSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        Linear1DSet[] comps = new Linear1DSet[2];
        for (int i = 0; i < comps.length; ++i) {
            comps[i] = set.getLinear1DComponent(i);
        }
        try {
            BinaryLinearSet.write(this, type, firsts, lasts, lengths, comps, cs, units, errors, set, Linear2DSet.class, (byte)51, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Linear2DSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processLinear3DSet(SetType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Linear3DSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        Linear1DSet[] comps = new Linear1DSet[3];
        for (int i = 0; i < comps.length; ++i) {
            comps[i] = set.getLinear1DComponent(i);
        }
        try {
            BinaryLinearSet.write(this, type, firsts, lasts, lengths, comps, cs, units, errors, set, Linear3DSet.class, (byte)52, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Linear3DSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processLinearLatLonSet(SetType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, LinearLatLonSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        Linear1DSet[] comps = new Linear1DSet[2];
        for (int i = 0; i < comps.length; ++i) {
            comps[i] = set.getLinear1DComponent(i);
        }
        try {
            BinaryLinearSet.write(this, type, firsts, lasts, lengths, comps, cs, units, errors, set, LinearLatLonSet.class, (byte)54, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write LinearLatLonSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processLinearNDSet(SetType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, LinearNDSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        Linear1DSet[] comps = new Linear1DSet[set.getDimension()];
        for (int i = 0; i < comps.length; ++i) {
            comps[i] = set.getLinear1DComponent(i);
        }
        try {
            BinaryLinearSet.write(this, type, firsts, lasts, lengths, comps, cs, units, errors, set, LinearNDSet.class, (byte)53, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write LinearNDSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processList1DSet(SetType type, float[] list, CoordinateSystem cs, Unit[] units, List1DSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryList1DSet.write(this, type, list, cs, units, set, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write List1DSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processProductSet(SetType type, SampledSet[] sets, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, ProductSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryProductSet.write(this, type, sets, cs, units, errors, set, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write " + set.getClass().getName() + ": " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processReal(RealType type, double value, Unit unit, ErrorEstimate error, Real real, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        try {
            BinaryReal.write(this, type, value, unit, error, real, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write " + real.getClass().getName() + ": " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processRealTuple(RealTupleType type, Real[] components, CoordinateSystem cs, RealTuple rt, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (rt == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryRealTuple.write(this, type, components, cs, rt, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write " + rt.getClass().getName() + ": " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processSampledSet(SetType st, int manifold_dimension, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, SampledSet set, Object token) throws VisADException {
        try {
            BinaryUnknown.write(this, set, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write SampledSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processSimpleSet(SetType st, int manifold_dimension, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, SimpleSet set, Object token) throws VisADException {
        try {
            BinaryUnknown.write(this, set, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write SimpleSet object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processSingletonSet(RealTuple sample, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, SingletonSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinarySingletonSet.write(this, sample, cs, units, errors, set, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write " + set.getClass().getName() + ": " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processText(TextType type, String value, boolean missing, Text text, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        try {
            BinaryText.write(this, type, value, missing, text, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write " + text.getClass().getName() + ": " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processTuple(TupleType type, Data[] components, Tuple t, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (t == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryTuple.write(this, type, components, t, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write " + t.getClass().getName() + ": " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processUnionSet(SetType type, SampledSet[] sets, UnionSet set, Object token) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (set == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryUnionSet.write(this, type, sets, set, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write " + set.getClass().getName() + ": " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void processUnknownData(DataImpl data, Object token) throws VisADException {
        try {
            BinaryUnknown.write(this, data, token);
        }
        catch (IOException ioe) {
            throw new VisADException("Couldn't write Data object: " + ioe.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void save(DataImpl data) throws VisADException {
        this.save(data, false);
    }

    public void save(DataImpl data, boolean bigObject) throws VisADException {
        Object dependToken = bigObject ? BinaryObject.SAVE_DEPEND_BIG : BinaryObject.SAVE_DEPEND;
        this.process(data, dependToken);
        this.process(data, BinaryObject.SAVE_DATA);
    }

    public void setFile(String name) throws IOException {
        this.setFile(new File(name));
    }

    public void setFile(File ref) throws IOException {
        this.setOutputStream(new FileOutputStream(ref));
    }

    public void setOutputStream(OutputStream stream) throws IOException {
        if (this.file != null) {
            this.file.flush();
            this.file.close();
            this.file = null;
        }
        this.initVars();
        if (stream == null) {
            throw new IOException("Null OutputStream");
        }
        this.file = new DataOutputStream(new BufferedOutputStream(stream));
        this.file.writeBytes("VisADBin");
        this.file.writeInt(1);
    }
}

