/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.data.in.ValueVetter;

final class SingleValueVetter
extends ValueVetter {
    private double doubleValue;
    private float floatValue;
    private static final WeakHashMap map = new WeakHashMap();

    private SingleValueVetter(double value) {
        this.doubleValue = value;
        this.floatValue = (float)value;
    }

    static synchronized SingleValueVetter singleValueVetter(double value) {
        SingleValueVetter vetter = new SingleValueVetter(value);
        WeakReference ref = (WeakReference)map.get(vetter);
        if (ref == null) {
            map.put(vetter, new WeakReference<SingleValueVetter>(vetter));
        } else {
            SingleValueVetter oldVetter = (SingleValueVetter)ref.get();
            if (oldVetter == null) {
                map.put(vetter, new WeakReference<SingleValueVetter>(vetter));
            } else {
                vetter = oldVetter;
            }
        }
        return vetter;
    }

    public float process(float value) {
        return value == this.floatValue ? Float.NaN : value;
    }

    public double process(double value) {
        return value == this.doubleValue ? Double.NaN : value;
    }

    public float[] process(float[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != this.floatValue) continue;
            values[i] = Float.NaN;
        }
        return values;
    }

    public double[] process(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != this.doubleValue) continue;
            values[i] = Double.NaN;
        }
        return values;
    }

    public boolean equals(Object obj) {
        SingleValueVetter that;
        boolean equals = !this.getClass().isInstance(obj) ? false : this == (that = (SingleValueVetter)obj) || this.doubleValue == that.doubleValue;
        return equals;
    }

    public int hashCode() {
        return new Double(this.doubleValue).hashCode();
    }
}

