/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.CoordinateSystem;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.Unit;
import visad.VisADException;
import visad.data.hdfeos.GctpException;
import visad.data.hdfeos.GctpFunction;

public class LambertConformalConic
extends CoordinateSystem {
    double r_major;
    double es;
    double e;
    double r_minor;
    double lon_center;
    double lat_center;
    double ns;
    double f0;
    double rh;
    double false_easting;
    double false_northing;
    private static Unit[] coordinate_system_units = new Unit[]{SI.meter, SI.meter};

    public LambertConformalConic(RealTupleType reference, double r_major, double r_minor, double s_lat1, double s_lat2, double lon_center, double lat_center, double false_easting, double false_northing) throws VisADException {
        super(reference, coordinate_system_units);
        this.r_major = r_major;
        this.r_minor = r_minor;
        this.lon_center = lon_center;
        this.lat_center = lat_center;
        this.false_easting = false_easting;
        this.false_northing = false_northing;
        if (Math.abs(s_lat1 + s_lat2) < 1.0E-10) {
            throw new GctpException("Equal latitudes for st. paralles on opposite sides of equator");
        }
        double temp = r_minor / r_major;
        this.es = 1.0 - temp * temp;
        this.e = Math.sqrt(this.es);
        double sin_po = Math.sin(s_lat1);
        double cos_po = Math.cos(s_lat1);
        double con = sin_po;
        double ms1 = GctpFunction.msfnz(this.e, sin_po, cos_po);
        double ts1 = GctpFunction.tsfnz(this.e, s_lat1, sin_po);
        sin_po = Math.sin(s_lat2);
        cos_po = Math.cos(s_lat2);
        double ms2 = GctpFunction.msfnz(this.e, sin_po, cos_po);
        double ts2 = GctpFunction.tsfnz(this.e, s_lat2, sin_po);
        sin_po = Math.sin(lat_center);
        double ts0 = GctpFunction.tsfnz(this.e, lat_center, sin_po);
        this.ns = Math.abs(s_lat1 - s_lat2) > 1.0E-10 ? Math.log(ms1 / ms2) / Math.log(ts1 / ts2) : con;
        this.f0 = ms1 / (this.ns * Math.pow(ts1, this.ns));
        this.rh = r_major * this.f0 * Math.pow(ts0, this.ns);
    }

    public double[][] toReference(double[][] tuples) throws VisADException {
        int n_tuples = tuples[0].length;
        int tuple_dim = tuples.length;
        if (tuple_dim != 2) {
            throw new VisADException("LambertConformalConic: tuple dim != 2");
        }
        double[][] t_tuples = new double[2][n_tuples];
        for (int ii = 0; ii < n_tuples; ++ii) {
            double con;
            double rh1;
            double y = tuples[1][ii];
            double x = tuples[0][ii];
            long flag = 0L;
            x -= this.false_easting;
            y = this.rh - y + this.false_northing;
            if (this.ns > 0.0) {
                rh1 = Math.sqrt(x * x + y * y);
                con = 1.0;
            } else {
                rh1 = -Math.sqrt(x * x + y * y);
                con = -1.0;
            }
            double theta = 0.0;
            if (rh1 != 0.0) {
                theta = Math.atan2(con * x, con * y);
            }
            if (rh1 != 0.0 || this.ns > 0.0) {
                con = 1.0 / this.ns;
                double ts = Math.pow(rh1 / (this.r_major * this.f0), con);
                t_tuples[1][ii] = GctpFunction.phi2z(this.e, ts);
            } else {
                t_tuples[1][ii] = -1.5707963267948966;
            }
            t_tuples[0][ii] = GctpFunction.adjust_lon(theta / this.ns + this.lon_center);
        }
        return t_tuples;
    }

    public double[][] fromReference(double[][] tuples) throws VisADException {
        int n_tuples = tuples[0].length;
        int tuple_dim = tuples.length;
        if (tuple_dim != 2) {
            throw new VisADException("LambertConformalConic: tuple dim != 2");
        }
        double[] rh1 = new double[n_tuples];
        double[][] t_tuples = new double[2][n_tuples];
        for (int ii = 0; ii < n_tuples; ++ii) {
            double lon = tuples[0][ii];
            double lat = tuples[1][ii];
            double con = Math.abs(Math.abs(lat) - 1.5707963267948966);
            if (con > 1.0E-10) {
                double sinphi = Math.sin(lat);
                double ts = GctpFunction.tsfnz(this.e, lat, sinphi);
                rh1[ii] = this.r_major * this.f0 * Math.pow(ts, this.ns);
            } else {
                con = lat * this.ns;
                if (con <= 0.0) {
                    t_tuples[0][ii] = Double.NaN;
                    t_tuples[1][ii] = Double.NaN;
                }
                rh1[ii] = 0.0;
            }
            double theta = this.ns * GctpFunction.adjust_lon(lon - this.lon_center);
            t_tuples[0][ii] = rh1[ii] * Math.sin(theta) + this.false_easting;
            t_tuples[1][ii] = this.rh - rh1[ii] * Math.cos(theta) + this.false_northing;
        }
        return t_tuples;
    }

    public boolean equals(Object cs) {
        return cs instanceof LambertConformalConic;
    }

    public static void main(String[] args) throws VisADException {
        LambertConformalConic cs_lamcc = null;
        double[][] values_in = new double[][]{{-2.3292989, -1.6580627, -1.6580627, -1.6580627}, {0.2127555, 0.4363323, 0.6981317, 0.8726646}};
        RealType real1 = RealType.getRealType("Theta", SI.radian);
        RealType real2 = RealType.getRealType("radius", SI.meter);
        RealType[] reals = new RealType[]{RealType.Longitude, RealType.Latitude};
        double r_major = 6367470.0;
        double r_minor = 6367470.0;
        double s_lat1 = 0.4014257279586958;
        double s_lat2 = 0.47123889803846897;
        double center_lat = 0.4363323129985824;
        double center_lon = -1.6580627893946132;
        double false_easting = 0.0;
        double false_northing = 0.0;
        RealTupleType Reference2 = new RealTupleType(reals);
        cs_lamcc = new LambertConformalConic(Reference2, r_major, r_minor, s_lat1, s_lat2, center_lon, center_lat, false_easting, false_northing);
        double[][] values_out = ((CoordinateSystem)cs_lamcc).fromReference(values_in);
        for (int i = 0; i < values_out[0].length; ++i) {
            System.out.println(values_out[0][i] + ",  " + values_out[1][i]);
        }
        System.out.println(" ");
        double[][] values_inR = ((CoordinateSystem)cs_lamcc).toReference(values_out);
        for (int i = 0; i < values_inR[0].length; ++i) {
            System.out.println(values_inR[0][i] + ",  " + values_inR[1][i]);
        }
    }
}

