/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.io.IOException;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataReferenceImpl;
import visad.VisADException;

public abstract class LinkedDataSource {
    protected static final boolean DEBUG = false;
    protected String name;
    private DataReferenceImpl ref;
    private boolean alive;

    public LinkedDataSource(String name) {
        this.name = name;
        try {
            this.ref = new DataReferenceImpl(name);
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        this.alive = false;
    }

    public abstract void open(String var1) throws IOException, VisADException, RemoteException;

    public void dataChanged(Data data) throws VisADException, RemoteException {
        if (data == null) {
            this.alive = false;
        } else {
            this.ref.setData(data);
        }
    }

    public String getName() {
        return this.name;
    }

    public DataReferenceImpl getReference() {
        return this.ref;
    }

    public boolean isAlive() {
        return this.alive;
    }
}

