/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.CellImpl;
import visad.Control;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DelaunayCustom;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer1DSet;
import visad.Irregular2DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.UnionSet;
import visad.VisADError;
import visad.VisADException;
import visad.bom.FrontActionListener;
import visad.bom.FrontManipulationRendererJ3D;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.MouseBehaviorJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.AnimationWidget;

public class FrontDrawer
implements ControlListener {
    private static boolean debug = true;
    private Object data_lock = new Object();
    private DataReferenceImpl front_ref;
    private DefaultRendererJ3D front_renderer;
    private DataReferenceImpl curve_ref = null;
    private FrontManipulationRendererJ3D front_manipulation_renderer;
    private ReleaseCell release_cell;
    private DataReferenceImpl release_ref;
    private ZoomCell zoom_cell;
    private DataReferenceImpl zoom_ref;
    private ProjectionControl pcontrol = null;
    private ProjectionControlListener pcl = null;
    private float zoom = 1.0f;
    private AnimationControl acontrol = null;
    private DisplayImplJ3D display;
    private ScalarMap lat_map = null;
    private ScalarMap lon_map = null;
    private static Object type_lock = new Object();
    private int ntimes = 0;
    private int current_time_step = -1;
    private UnionSet init_curve = null;
    private static SetType curve_type = null;
    private int lat_index = 0;
    private int lon_index = 1;
    private float[][][] curves = null;
    private boolean[] flips = null;
    private FieldImpl fronts = null;
    private static FunctionType fronts_type = null;
    private FieldImpl front = null;
    private static FunctionType front_type = null;
    private static FunctionType front_inner = null;
    private static RealType front_index = null;
    private static RealType front_red = null;
    private static RealType front_green = null;
    private static RealType front_blue = null;
    private int nfshapes = -1;
    private float[][][] first_shapes = null;
    private int[][][] first_tris = null;
    private float[] first_red = null;
    private float[] first_green = null;
    private float[] first_blue = null;
    private int nrshapes = -1;
    private float[][][] repeat_shapes = null;
    private int[][][] repeat_tris = null;
    private float[] repeat_red = null;
    private float[] repeat_green = null;
    private float[] repeat_blue = null;
    private float fsegment_length;
    private float rsegment_length;
    private int fprofile_length = -1;
    private int rprofile_length = -1;
    private int filter_window = 1;
    float[][][] ccs = null;
    FieldImpl ffs = null;
    public static final int COLD_FRONT = 0;
    public static final int WARM_FRONT = 1;
    public static final int OCCLUDED_FRONT = 2;
    public static final int STATIONARY_FRONT = 3;
    public static final int CONVERGENCE = 4;
    public static final int FRONTOGENESIS = 5;
    public static final int FRONTOLYSIS = 6;
    public static final int UPPER_COLD_FRONT = 7;
    public static final int UPPER_WARM_FRONT = 8;
    public static final int TROUGH = 9;
    public static final int RIDGE = 10;
    public static final int MOISTURE = 11;
    public static final int LOW_LEVEL_JET = 12;
    public static final int UPPER_LEVEL_JET = 13;
    public static final int DRY_LINE = 14;
    public static final int TOTAL_TOTALS = 15;
    public static final int LIFTED_INDEX = 16;
    public static final int ISOTHERMS = 17;
    public static final int THICKNESS_RIDGE = 18;
    public static final int LOWER_THERMAL_TROUGH = 19;
    public static final int UPPER_THERMAL_TROUGH = 20;
    public static final int UNEVEN_LOW_LEVEL_JET = 21;
    private static final float[] rsegmentarray = new float[]{0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.05f, 0.1f, 0.05f, 0.2f, 0.2f, 0.1f, 0.05f, 0.1f, 0.15f, 0.1f, 0.05f, 0.1f, 0.1f};
    private static final float[] fsegmentarray = new float[]{0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.05f, 0.1f, 0.05f, 0.2f, 0.2f, 0.1f, 0.05f, 0.1f, 0.15f, 0.1f, 0.05f, 0.1f, 0.2f};
    private static final float[][][][] rshapesarray = new float[][][][]{new float[][][]{new float[][]{{0.0f, 0.025f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.025f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.04f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.035f, 0.07f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.07f, 0.0525f, 0.035f, 0.0175f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.03f, 0.037f, 0.03f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.025f, 0.05f, 0.07f, 0.105f, 0.14f, 0.17f, 0.2f, 0.2f, 0.17f, 0.14f, 0.1225f, 0.105f, 0.0875f, 0.07f, 0.05f, 0.025f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.03f, 0.037f, 0.03f, 0.01f, 0.01f, 0.04f, 0.01f}}}, new float[][][]{new float[][]{{0.09f, 0.11f, 0.1275f, 0.145f, 0.1625f, 0.18f, 0.2f, 0.2f, 0.1775f, 0.155f, 0.1175f, 0.09f}, {0.0f, 0.0f, -0.02f, -0.027f, -0.02f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}, new float[][]{{0.0f, 0.02f, 0.045f, 0.07f, 0.09f, 0.09f, 0.07f, 0.045f, 0.02f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.04f, 0.01f, 0.0f}}}, new float[][][]{new float[][]{{0.0f, 0.03f, 0.035f, 0.01f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.11f, 0.135f, 0.13f, 0.1f, 0.05f, 0.0f}, {0.01f, 0.04f, 0.035f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.0f, 0.0f, 0.0f, -0.025f, -0.03f, 0.0f, 0.0f, 0.0f}}}, new float[][][]{new float[][]{{0.0f, 0.035f, 0.07f, 0.1f, 0.15f, 0.15f, 0.1f, 0.0875f, 0.075f, 0.0625f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.025f, 0.035f, 0.025f, 0.01f, 0.01f}}, new float[][]{{0.16f, 0.19f, 0.19f, 0.16f}, {-0.005f, -0.005f, 0.015f, 0.015f}}}, new float[][][]{new float[][]{{0.0f, 0.035f, 0.07f, 0.1f, 0.15f, 0.15f, 0.1f, 0.0875f, 0.075f, 0.0625f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.025f, 0.035f, 0.025f, 0.01f, 0.01f}}, new float[][]{{0.16f, 0.17f, 0.17f, 0.18f, 0.18f, 0.19f, 0.19f, 0.18f, 0.18f, 0.17f, 0.17f, 0.16f}, {0.0f, 0.0f, -0.01f, -0.01f, 0.0f, 0.0f, 0.01f, 0.01f, 0.02f, 0.02f, 0.01f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}, new float[][]{{0.0f, 0.03f, 0.06f, 0.05f, 0.03f, 0.01f}, {0.01f, 0.04f, 0.01f, 0.01f, 0.03f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}, new float[][]{{0.0f, 0.015f, 0.03f, 0.045f, 0.06f, 0.05f, 0.04f, 0.03f, 0.02f, 0.01f}, {0.01f, 0.03f, 0.037f, 0.03f, 0.01f, 0.01f, 0.023f, 0.027f, 0.023f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.035f, 0.035f, 0.0f}, {0.0f, 0.0f, 0.01f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.1f, 0.1f, 0.05f, 0.0f}, {0.04f, -0.06f, 0.04f, 0.06f, -0.04f, 0.06f}}}, new float[][][]{new float[][]{{0.0f, 0.0f, 0.01f, 0.01f, 0.05f, 0.05f, 0.0f}, {0.01f, 0.05f, 0.05f, 0.01f, 0.01f, 0.0f, 0.0f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.0f}, {-0.01f, -0.01f, -0.01f, -0.01f, -0.01f, 0.02f, 0.02f, 0.02f, 0.02f, 0.02f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.01f, 0.01f}}, new float[][]{{0.06f, 0.09f, 0.09f, 0.06f}, {-0.005f, -0.005f, 0.015f, 0.015f}}}, new float[][][]{new float[][]{{0.0f, 0.035f, 0.035f, 0.0f}, {0.0f, 0.0f, 0.01f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.01f, 0.01f}}, new float[][]{{0.06f, 0.09f, 0.09f, 0.06f}, {-0.005f, -0.005f, 0.015f, 0.015f}}}, new float[][][]{new float[][]{{0.0f, 0.0f, 0.04f, 0.08f, 0.08f, 0.04f, 0.0f, 0.0f, 0.02f, 0.02f, 0.06f, 0.06f, 0.02f, 0.02f}, {0.0f, -0.02f, -0.02f, -0.02f, 0.02f, 0.02f, 0.02f, 0.0f, 0.0f, 0.01f, 0.01f, -0.01f, -0.01f, 0.0f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.1f, 0.1f, 0.05f, 0.0f}, {0.01f, -0.06f, 0.01f, 0.06f, -0.01f, 0.06f}}}, new float[][][]{new float[][]{{0.0f, 0.045f, 0.045f, 0.0f}, {-0.01f, -0.01f, 0.02f, 0.02f}}}, new float[][][]{new float[][]{{0.0f, 0.04f, 0.02f}, {0.0f, 0.0f, 0.04f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.1f, 0.1f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f}}}};
    private static final float[][] rredarray = new float[][]{{0.0f}, {1.0f}, {1.0f}, {1.0f, 0.0f}, {1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {0.5f}, {0.5f}, {1.0f}, {0.5f}, {0.5f}, {0.5f, 0.5f}, {1.0f}, {1.0f, 1.0f}, {1.0f}, {1.0f}, {1.0f}, {1.0f}, {0.5f}};
    private static final float[][] rgreenarray = new float[][]{{0.0f}, {0.0f}, {0.0f}, {0.0f, 0.0f}, {1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {0.3f}, {0.3f}, {1.0f}, {0.5f}, {0.5f}, {0.3f, 0.3f}, {1.0f}, {1.0f, 1.0f}, {1.0f}, {1.0f}, {1.0f}, {1.0f}, {0.5f}};
    private static final float[][] rbluearray = new float[][]{{1.0f}, {0.0f}, {1.0f}, {0.0f, 1.0f}, {1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {0.0f}, {0.0f}, {1.0f}, {1.0f}, {1.0f}, {0.0f, 0.0f}, {1.0f}, {1.0f, 1.0f}, {1.0f}, {1.0f}, {1.0f}, {1.0f}, {1.0f}};
    private static final float[][][][] fshapesarray = new float[][][][]{(float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, new float[][][]{new float[][]{{0.0f, 0.07f, 0.075f, 0.01f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.01f, 0.075f, 0.07f, 0.0f}, {0.0f, -0.07f, -0.065f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.075f, 0.08f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.06f, 0.077f, 0.04f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.04f, 0.077f, 0.06f, 0.0f}, {-0.001f, -0.06f, -0.04f, -0.01f, -0.01f, -0.01f, -0.01f, -0.01f, 0.02f, 0.02f, 0.02f, 0.02f, 0.02f, 0.05f, 0.07f, 0.02f}}}, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, new float[][][]{new float[][]{{0.0f, 0.07f, 0.075f, 0.01f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.01f, 0.075f, 0.07f, 0.0f}, {0.0f, -0.07f, -0.065f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.075f, 0.08f, 0.01f}}}};
    private static final float[][] fredarray = new float[][]{null, null, null, null, null, null, null, null, null, null, null, null, {0.5f}, {0.5f}, null, null, null, null, null, null, null, {0.5f}};
    private static final float[][] fgreenarray = new float[][]{null, null, null, null, null, null, null, null, null, null, null, null, {0.5f}, {0.5f}, null, null, null, null, null, null, null, {0.5f}};
    private static final float[][] fbluearray = new float[][]{null, null, null, null, null, null, null, null, null, null, null, null, {1.0f}, {1.0f}, null, null, null, null, null, null, null, {1.0f}};
    private Gridded2DSet last_curve_set = null;
    private static final float CLIP_DELTA = 0.001f;
    private boolean pfirst = true;
    private float last_zoom = 1.0f;

    public FrontDrawer(FieldImpl fs, float[][][] cs, DisplayImplJ3D d, int fw, int front_kind, float[] fred, float[] fgreen, float[] fblue, float[] rred, float[] rgreen, float[] rblue) throws VisADException, RemoteException {
        this(fs, cs, d, fw, fsegmentarray[front_kind], rsegmentarray[front_kind], fshapesarray[front_kind], fred, fgreen, fblue, rshapesarray[front_kind], rred, rgreen, rblue);
    }

    public FrontDrawer(FieldImpl fs, float[][][] cs, DisplayImplJ3D d, int fw, int front_kind) throws VisADException, RemoteException {
        this(fs, cs, d, fw, fsegmentarray[front_kind], rsegmentarray[front_kind], fshapesarray[front_kind], fredarray[front_kind], fgreenarray[front_kind], fbluearray[front_kind], rshapesarray[front_kind], rredarray[front_kind], rgreenarray[front_kind], rbluearray[front_kind]);
    }

    public FrontDrawer(FieldImpl fs, float[][][] cs, DisplayImplJ3D d, int fw, float segment, float[][][] fshapes, float[] fred, float[] fgreen, float[] fblue, float[][][] rshapes, float[] rred, float[] rgreen, float[] rblue) throws VisADException, RemoteException {
        this(fs, cs, d, fw, segment, segment, fshapes, fred, fgreen, fblue, rshapes, rred, rgreen, rblue);
    }

    public FrontDrawer(FieldImpl fs, float[][][] cs, DisplayImplJ3D d, int fw, float fsegment, float rsegment, float[][][] fshapes, float[] fred, float[] fgreen, float[] fblue, float[][][] rshapes, float[] rred, float[] rgreen, float[] rblue) throws VisADException, RemoteException {
        int i;
        int i2;
        int i3;
        SampledSet[] sets;
        try {
            FrontDrawer.initColormaps(d);
        }
        catch (VisADException e) {
            // empty catch block
        }
        this.ccs = cs;
        this.ffs = fs;
        this.curve_ref = new DataReferenceImpl("curve_ref");
        Gridded2DSet set = null;
        set = cs == null || cs[0] == null ? new Gridded2DSet((MathType)curve_type, (float[][])new float[][]{{0.0f}, {0.0f}}, 1) : new Gridded2DSet((MathType)curve_type, cs[0], cs[0][0].length);
        this.init_curve = new UnionSet((MathType)curve_type, new Gridded2DSet[]{set});
        Data data = this.curve_ref.getData();
        DataImpl curve_set = null;
        if (data != null && data instanceof UnionSet && (sets = ((UnionSet)data).getSets())[0] instanceof Gridded2DSet) {
            curve_set = (Gridded2DSet)sets[0];
        }
        if (curve_set == null) {
            this.curve_ref.setData(this.init_curve);
        } else {
            SetType st = (SetType)curve_set.getType();
            if (!st.equals(curve_type)) {
                SetType rft = new SetType(new RealTupleType(RealType.Longitude, RealType.Latitude));
                if (!st.equals(rft)) {
                    throw new SetException("cr data bad MathType");
                }
                this.lat_index = 1;
                this.lon_index = 0;
            }
        }
        this.display = d;
        this.filter_window = fw;
        this.fsegment_length = fsegment;
        this.rsegment_length = rsegment;
        if (rshapes == null) {
            throw new VisADException("bad rshapes");
        }
        this.nrshapes = rshapes.length;
        for (i3 = 0; i3 < this.nrshapes; ++i3) {
            if (rshapes[i3] != null && rshapes[i3].length == 2 && rshapes[i3][0] != null && rshapes[i3][1] != null && rshapes[i3][0].length == rshapes[i3][1].length) continue;
            throw new VisADException("bad rshapes[" + i3 + "]");
        }
        if (rred == null || rred.length != this.nrshapes || rgreen == null || rgreen.length != this.nrshapes || rblue == null || rblue.length != this.nrshapes) {
            throw new VisADException("bad rcolors");
        }
        this.repeat_tris = new int[this.nrshapes][][];
        for (i3 = 0; i3 < this.nrshapes; ++i3) {
            this.repeat_tris[i3] = DelaunayCustom.fill(rshapes[i3]);
        }
        this.repeat_shapes = new float[this.nrshapes][2][];
        int rlen = 0;
        for (i2 = 0; i2 < this.nrshapes; ++i2) {
            int n = rshapes[i2][0].length;
            rlen += n;
            this.repeat_shapes[i2][0] = new float[n];
            this.repeat_shapes[i2][1] = new float[n];
            System.arraycopy(rshapes[i2][0], 0, this.repeat_shapes[i2][0], 0, n);
            System.arraycopy(rshapes[i2][1], 0, this.repeat_shapes[i2][1], 0, n);
        }
        this.rprofile_length = rlen;
        this.repeat_red = new float[this.nrshapes];
        this.repeat_green = new float[this.nrshapes];
        this.repeat_blue = new float[this.nrshapes];
        System.arraycopy(rred, 0, this.repeat_red, 0, this.nrshapes);
        System.arraycopy(rgreen, 0, this.repeat_green, 0, this.nrshapes);
        System.arraycopy(rblue, 0, this.repeat_blue, 0, this.nrshapes);
        if (fshapes == null) {
            this.nfshapes = this.nrshapes;
            this.first_tris = this.repeat_tris;
            this.first_shapes = this.repeat_shapes;
            this.first_red = this.repeat_red;
            this.first_green = this.repeat_green;
            this.first_blue = this.repeat_blue;
        } else {
            this.nfshapes = fshapes.length;
            for (i2 = 0; i2 < this.nfshapes; ++i2) {
                if (fshapes[i2] != null && fshapes[i2].length == 2 && fshapes[i2][0] != null && fshapes[i2][1] != null && fshapes[i2][0].length == fshapes[i2][1].length) continue;
                throw new VisADException("bad fshapes[" + i2 + "]");
            }
            if (fred == null || fred.length != this.nfshapes || fgreen == null || fgreen.length != this.nfshapes || fblue == null || fblue.length != this.nfshapes) {
                throw new VisADException("bad fcolors");
            }
            this.first_tris = new int[this.nfshapes][][];
            for (i2 = 0; i2 < this.nfshapes; ++i2) {
                this.first_tris[i2] = DelaunayCustom.fill(fshapes[i2]);
            }
            this.first_shapes = new float[this.nfshapes][2][];
            int flen = 0;
            for (i = 0; i < this.nfshapes; ++i) {
                int n = fshapes[i][0].length;
                flen += n;
                this.first_shapes[i][0] = new float[n];
                this.first_shapes[i][1] = new float[n];
                System.arraycopy(fshapes[i][0], 0, this.first_shapes[i][0], 0, n);
                System.arraycopy(fshapes[i][1], 0, this.first_shapes[i][1], 0, n);
            }
            this.fprofile_length = flen;
            this.first_red = new float[this.nfshapes];
            this.first_green = new float[this.nfshapes];
            this.first_blue = new float[this.nfshapes];
            System.arraycopy(fred, 0, this.first_red, 0, this.nfshapes);
            System.arraycopy(fgreen, 0, this.first_green, 0, this.nfshapes);
            System.arraycopy(fblue, 0, this.first_blue, 0, this.nfshapes);
        }
        if (this.rprofile_length < 5) {
            this.rprofile_length = 5;
        }
        if (this.fprofile_length < 5) {
            this.fprofile_length = 5;
        }
        this.pcontrol = this.display.getProjectionControl();
        this.pcl = new ProjectionControlListener();
        this.pcontrol.addControlListener(this.pcl);
        this.acontrol = (AnimationControl)((Object)this.display.getControl(AnimationControl.class));
        if (this.acontrol == null) {
            throw new DisplayException("display must include ScalarMap to Animation");
        }
        Vector tmap = this.display.getMapVector();
        for (i = 0; i < tmap.size(); ++i) {
            ScalarMap map = (ScalarMap)tmap.elementAt(i);
            Control c = map.getControl();
            if (!this.acontrol.equals(c) || RealType.Time.equals(map.getScalar())) continue;
            throw new DisplayException("must be Time mapped to Animation " + map.getScalar());
        }
        Set aset = this.acontrol.getSet();
        if (aset != null) {
            this.setupAnimationSet(aset);
        } else {
            this.acontrol.addControlListener(this);
        }
        this.lat_map = null;
        this.lon_map = null;
        Vector scalar_map_vector = this.display.getMapVector();
        Enumeration en = scalar_map_vector.elements();
        while (en.hasMoreElements()) {
            ScalarMap map = (ScalarMap)en.nextElement();
            DisplayRealType real = map.getDisplayScalar();
            DisplayTupleType tuple = real.getTuple();
            if (tuple == null || !tuple.equals(Display.DisplaySpatialCartesianTuple) && (tuple.getCoordinateSystem() == null || !tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
            if (RealType.Latitude.equals(map.getScalar())) {
                this.lat_map = map;
                continue;
            }
            if (!RealType.Longitude.equals(map.getScalar())) continue;
            this.lon_map = map;
        }
        if (this.lat_map == null || this.lon_map == null) {
            throw new DisplayException("Latitude and Longitude must be mapped");
        }
        int mmm = 0;
        int mmv = 0;
        this.front_manipulation_renderer = new FrontManipulationRendererJ3D(this, mmm, mmv);
        this.display.addReferences((DataRenderer)this.front_manipulation_renderer, this.curve_ref);
        this.front_ref = new DataReferenceImpl("front");
        this.front_ref.setData(this.fronts);
        this.front_renderer = new DefaultRendererJ3D();
        this.front_renderer.suppressExceptions(true);
        this.display.addReferences((DataRenderer)this.front_renderer, this.front_ref);
        this.release_ref = new DataReferenceImpl("release");
        this.release_cell = new ReleaseCell();
        this.release_cell.addReference(this.release_ref);
        this.zoom_ref = new DataReferenceImpl("zoom");
        this.zoom_cell = new ZoomCell();
        this.zoom_cell.addReference(this.zoom_ref);
        this.setScale();
    }

    private void setupAnimationSet(Set aset) throws VisADException {
        this.ntimes = aset.getLength();
        this.current_time_step = this.acontrol.getCurrent();
        if (this.ccs == null) {
            this.curves = new float[this.ntimes][][];
        } else {
            this.curves = this.ccs;
            if (this.ccs.length != this.ntimes) {
                throw new VisADException("cs bad number of times " + this.ccs.length + " != " + this.ntimes);
            }
        }
        this.flips = new boolean[this.ntimes];
        if (this.ffs == null) {
            this.fronts = new FieldImpl(fronts_type, aset);
        } else {
            this.fronts = this.ffs;
            if (!aset.equals(this.ffs.getDomainSet())) {
                throw new VisADException("fs bad time Set " + this.ffs.getDomainSet() + " != " + aset);
            }
        }
    }

    public void controlChanged(ControlEvent e) {
        if (this.fronts == null) {
            try {
                Set aset = this.acontrol.getSet();
                if (aset != null) {
                    this.setupAnimationSet(aset);
                }
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public DefaultRendererJ3D getFrontRenderer() {
        return this.front_renderer;
    }

    public static void initColormaps(DisplayImplJ3D display) throws VisADException, RemoteException {
        FrontDrawer.setupTypes();
        ScalarMap rmap = new ScalarMap(front_red, Display.Red);
        rmap.setRange(0.0, 1.0);
        display.addMap(rmap);
        ScalarMap gmap = new ScalarMap(front_green, Display.Green);
        gmap.setRange(0.0, 1.0);
        display.addMap(gmap);
        ScalarMap bmap = new ScalarMap(front_blue, Display.Blue);
        bmap.setRange(0.0, 1.0);
        display.addMap(bmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupTypes() throws VisADException {
        Object object = type_lock;
        synchronized (object) {
            if (curve_type == null) {
                RealTupleType latlon = new RealTupleType(RealType.Latitude, RealType.Longitude);
                curve_type = new SetType(latlon);
                front_index = RealType.getRealType("front_index");
                front_red = RealType.getRealType("front_red");
                front_green = RealType.getRealType("front_green");
                front_blue = RealType.getRealType("front_blue");
                RealTupleType rgb = new RealTupleType(front_red, front_green, front_blue);
                front_inner = new FunctionType(latlon, rgb);
                front_type = new FunctionType(front_index, front_inner);
                fronts_type = new FunctionType(RealType.Time, front_type);
            }
        }
    }

    private FieldImpl robustCurveToFront(float[][] curve, boolean flip) throws RemoteException {
        float increment = this.rsegment_length / ((float)this.rprofile_length * this.zoom);
        float[][] old_curve = FrontDrawer.resample_curve(curve, increment);
        int fw = this.filter_window;
        for (int tries = 0; tries < 12; ++tries) {
            curve = FrontDrawer.smooth_curve(old_curve, fw);
            curve = FrontDrawer.resample_curve(curve, increment);
            try {
                this.front = this.curveToFront(curve, flip);
                break;
            }
            catch (VisADException e) {
                int n;
                old_curve = curve;
                if (tries > 4 && (n = old_curve[0].length) > 2) {
                    float[][] no = new float[2][n - 2];
                    System.arraycopy(old_curve[0], 1, no[0], 0, n - 2);
                    System.arraycopy(old_curve[1], 1, no[1], 0, n - 2);
                    old_curve = no;
                }
                if (tries > 8) {
                    fw = 2 * fw;
                }
                if (tries != 9) continue;
                System.out.println("cannot smooth curve");
                this.front = null;
                continue;
            }
        }
        return this.front;
    }

    public Gridded2DSet getCurve() {
        return this.last_curve_set;
    }

    public void release() {
        block4: {
            try {
                this.release_ref.setData(null);
            }
            catch (VisADException e) {
                if (debug) {
                    System.out.println("release fail: " + e.toString());
                }
            }
            catch (RemoteException e) {
                if (!debug) break block4;
                System.out.println("release fail: " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endManipulation() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            if (this.curve_ref != null) {
                this.display.removeReference(this.curve_ref);
            }
            this.curve_ref = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector endItAll() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            if (this.curve_ref != null) {
                this.display.removeReference(this.curve_ref);
            }
            this.curve_ref = null;
            if (this.front_ref != null) {
                this.display.removeReference(this.front_ref);
                this.pcontrol.removeControlListener(this.pcl);
                this.release_cell.removeReference(this.release_ref);
                this.zoom_cell.removeReference(this.zoom_ref);
            }
            this.front_ref = null;
        }
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(this.fronts);
        vector.addElement(this.curves);
        return vector;
    }

    private FieldImpl curveToFront(float[][] curve, boolean flip) throws VisADException, RemoteException {
        int len = curve[0].length;
        if (len < 2) {
            return null;
        }
        float[] seg_length = new float[len - 1];
        float curve_length = FrontDrawer.curveLength(curve, seg_length);
        float delta = curve_length / (float)(len - 1);
        float mul = (float)this.rprofile_length * this.zoom / this.rsegment_length;
        float ratio = delta * mul;
        float[][] curve_perp = new float[2][len];
        for (int i = 0; i < len; ++i) {
            int im = i - 1;
            int ip = i + 1;
            if (im < 0) {
                im = 0;
            }
            if (ip > len - 1) {
                ip = len - 1;
            }
            float yp = curve[0][ip] - curve[0][im];
            float xp = curve[1][ip] - curve[1][im];
            xp = -xp;
            float d = (float)Math.sqrt(xp * xp + yp * yp);
            if (flip) {
                d = -d;
            }
            curve_perp[0][i] = xp /= d;
            curve_perp[1][i] = yp /= d;
        }
        Vector<FlatField> inner_field_vector = new Vector<FlatField>();
        int segment = 0;
        while (true) {
            float segment_length = segment == 0 ? this.fsegment_length : this.rsegment_length;
            int profile_length = segment == 0 ? this.fprofile_length : this.rprofile_length;
            mul = (float)profile_length * this.zoom / segment_length;
            boolean clip = false;
            float xclip = 0.0f;
            int ibase = segment == 0 ? 0 : this.fprofile_length + (segment - 1) * this.rprofile_length;
            int iend = ibase + profile_length;
            if (ibase > len - 1) break;
            if (iend > len - 1) {
                clip = true;
                iend = len - 1;
                xclip = (float)(iend - ibase) / mul;
            }
            int nshapes = this.nrshapes;
            float[][][] shapes = this.repeat_shapes;
            int[][][] tris = this.repeat_tris;
            float[] red = this.repeat_red;
            float[] green = this.repeat_green;
            float[] blue = this.repeat_blue;
            if (segment == 0) {
                nshapes = this.nfshapes;
                shapes = this.first_shapes;
                tris = this.first_tris;
                red = this.first_red;
                green = this.first_green;
                blue = this.first_blue;
            }
            for (int shape = 0; shape < nshapes; ++shape) {
                float[][] samples = shapes[shape];
                int[][] ts = tris[shape];
                if (samples == null || samples[0].length < 1) break;
                float[][] ss = this.mapShape(samples, len, ibase, mul, ratio, curve, curve_perp);
                ts = DelaunayCustom.fill(ss);
                if (clip) {
                    float[][] clip_samples = new float[][]{{xclip, xclip, xclip - 0.001f}, {0.001f, -0.001f, 0.0f}};
                    float[][] clip_ss = this.mapShape(clip_samples, len, ibase, mul, ratio, curve, curve_perp);
                    float det = clip_samples[0][1] * clip_samples[1][0] - clip_samples[0][0] * clip_samples[1][1];
                    float xc = (clip_samples[1][0] - clip_samples[1][1]) / det;
                    float yc = (clip_samples[0][1] - clip_samples[0][0]) / det;
                    float v = 1.0f;
                    if (xc * clip_samples[0][2] + yc * clip_samples[1][2] > v) {
                        xc = -xc;
                        yc = -yc;
                        v = -v;
                    }
                    float[][][] outs = new float[1][][];
                    int[][][] outt = new int[1][][];
                    DelaunayCustom.clip(ss, ts, xc, yc, v, outs, outt);
                    ss = outs[0];
                    ts = outt[0];
                }
                if (ss == null) break;
                int n = ss[0].length;
                float[][] values = new float[3][n];
                float r = red[shape];
                float g = green[shape];
                float b = blue[shape];
                for (int i = 0; i < n; ++i) {
                    values[0][i] = r;
                    values[1][i] = g;
                    values[2][i] = b;
                }
                DelaunayCustom delaunay = new DelaunayCustom(ss, ts);
                Irregular2DSet set = new Irregular2DSet(curve_type, ss, null, null, null, delaunay);
                FlatField field = new FlatField(front_inner, set);
                field.setSamples(values, false);
                inner_field_vector.addElement(field);
            }
            ++segment;
        }
        int nfields = inner_field_vector.size();
        Integer1DSet iset = new Integer1DSet((MathType)front_index, nfields);
        FieldImpl front = new FieldImpl(front_type, iset);
        Data[] fields = new FlatField[nfields];
        for (int i = 0; i < nfields; ++i) {
            fields[i] = (FlatField)inner_field_vector.elementAt(i);
        }
        front.setSamples(fields, false);
        return front;
    }

    private float[][] mapShape(float[][] samples, int len, int ibase, float mul, float ratio, float[][] curve, float[][] curve_perp) {
        int n = samples[0].length;
        float[][] ss = new float[2][n];
        for (int i = 0; i < n; ++i) {
            float a;
            float findex = (float)ibase + mul * samples[0][i] / this.zoom;
            int il = (int)findex;
            int ih = il + 1;
            if (il < 0) {
                il = 0;
                ih = il + 1;
            }
            if (ih > len - 1) {
                ih = len - 1;
                il = ih - 1;
            }
            if ((a = findex - (float)il) < -1.0f) {
                a = -1.0f;
            }
            if (a > 2.0f) {
                a = 2.0f;
            }
            float b = 1.0f - a;
            float xl = curve[0][il] + ratio * samples[1][i] * curve_perp[0][il] / this.zoom;
            float yl = curve[1][il] + ratio * samples[1][i] * curve_perp[1][il] / this.zoom;
            float xh = curve[0][ih] + ratio * samples[1][i] * curve_perp[0][ih] / this.zoom;
            float yh = curve[1][ih] + ratio * samples[1][i] * curve_perp[1][ih] / this.zoom;
            ss[0][i] = b * xl + a * xh;
            ss[1][i] = b * yl + a * yh;
        }
        ss[this.lat_index] = this.lat_map.inverseScaleValues(ss[0]);
        ss[this.lon_index] = this.lon_map.inverseScaleValues(ss[1]);
        return ss;
    }

    public static float[][] smooth_curve(float[][] curve, int window) {
        int len = curve[0].length;
        float[][] newcurve = new float[2][len];
        for (int i = 0; i < len; ++i) {
            int ii;
            int win = window;
            if (i < win) {
                win = i;
            }
            if ((ii = len - 1 - i) < win) {
                win = ii;
            }
            float runx = 0.0f;
            float runy = 0.0f;
            for (int j = i - win; j <= i + win; ++j) {
                runx += curve[0][j];
                runy += curve[1][j];
            }
            newcurve[0][i] = runx / (float)(2 * win + 1);
            newcurve[1][i] = runy / (float)(2 * win + 1);
        }
        return newcurve;
    }

    public static float[][] resample_curve(float[][] curve, float increment) {
        int len = curve[0].length;
        float[] seg_length = new float[len - 1];
        float curve_length = FrontDrawer.curveLength(curve, seg_length);
        int npoints = 1 + (int)(curve_length / increment);
        float delta = curve_length / (float)(npoints - 1);
        float[][] newcurve = new float[2][npoints];
        newcurve[0][0] = curve[0][0];
        newcurve[1][0] = curve[1][0];
        if (npoints < 2) {
            return newcurve;
        }
        int k = 0;
        float old_seg = seg_length[k];
        for (int i = 1; i < npoints - 1; ++i) {
            float new_seg;
            for (new_seg = delta; old_seg < new_seg; new_seg -= old_seg) {
                if (++k > len - 2) {
                    throw new VisADError("k = " + k + " i = " + i);
                }
                old_seg = seg_length[k];
            }
            float a = (old_seg -= new_seg) / seg_length[k];
            newcurve[0][i] = a * curve[0][k] + (1.0f - a) * curve[0][k + 1];
            newcurve[1][i] = a * curve[1][k] + (1.0f - a) * curve[1][k + 1];
        }
        newcurve[0][npoints - 1] = curve[0][len - 1];
        newcurve[1][npoints - 1] = curve[1][len - 1];
        return newcurve;
    }

    public static float curveLength(float[][] curve, float[] seg_length) {
        int len = curve[0].length;
        float curve_length = 0.0f;
        for (int i = 0; i < len - 1; ++i) {
            seg_length[i] = (float)Math.sqrt((curve[0][i + 1] - curve[0][i]) * (curve[0][i + 1] - curve[0][i]) + (curve[1][i + 1] - curve[1][i]) * (curve[1][i + 1] - curve[1][i]));
            curve_length += seg_length[i];
        }
        return curve_length;
    }

    private void setScale() throws VisADException, RemoteException {
        double[] matrix = this.pcontrol.getMatrix();
        double[] rot = new double[3];
        double[] scale = new double[1];
        double[] trans = new double[3];
        MouseBehaviorJ3D.unmake_matrix(rot, scale, trans, matrix);
        this.zoom = (float)scale[0];
        float ratio = this.zoom / this.last_zoom;
        if (ratio < 0.95f || 1.05f < ratio) {
            this.last_zoom = this.zoom;
            if (this.zoom_ref != null) {
                this.zoom_ref.setData(null);
            }
        }
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        RealType lat = RealType.Latitude;
        RealType lon = RealType.Longitude;
        SetType curve_type = new SetType(new RealTupleType(lat, lon));
        DisplayImplJ3D display = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap lonmap = new ScalarMap(lon, Display.XAxis);
        display.addMap(lonmap);
        lonmap.setRange(0.0, 20.0);
        ScalarMap latmap = new ScalarMap(lat, Display.YAxis);
        display.addMap(latmap);
        latmap.setRange(-40.0, -20.0);
        ScalarMap timemap = new ScalarMap(RealType.Time, Display.Animation);
        display.addMap(timemap);
        AnimationControl acontrol = (AnimationControl)((Object)timemap.getControl());
        acontrol.setSet(new Integer1DSet((MathType)RealType.Time, 4));
        FrontDrawer.initColormaps(display);
        JFrame frame = new JFrame("test FrontDrawer");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        panel.add(new AnimationWidget(timemap));
        int front_kind = 0;
        try {
            if (args.length > 0) {
                front_kind = Integer.parseInt(args[0]);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        FrontDrawer fd = new FrontDrawer(null, null, display, 8, front_kind);
        JPanel button_panel = new JPanel();
        button_panel.setLayout(new BoxLayout(button_panel, 0));
        button_panel.setAlignmentY(0.0f);
        button_panel.setAlignmentX(0.0f);
        JButton end = new JButton("detach");
        FrontActionListener fal = new FrontActionListener(fd, end, display, front_kind);
        end.addActionListener(fal);
        end.setActionCommand("detach");
        button_panel.add(end);
        panel.add(button_panel);
        frame.setSize(500, 700);
        frame.setVisible(true);
    }

    class ProjectionControlListener
    implements ControlListener {
        ProjectionControlListener() {
        }

        public void controlChanged(ControlEvent e) throws VisADException, RemoteException {
            FrontDrawer.this.setScale();
        }
    }

    class ZoomCell
    extends CellImpl {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAction() throws VisADException, RemoteException {
            Object object = FrontDrawer.this.data_lock;
            synchronized (object) {
                for (int i = 0; i < FrontDrawer.this.ntimes; ++i) {
                    if (FrontDrawer.this.curves[i] == null) continue;
                    FrontDrawer.this.front = FrontDrawer.this.robustCurveToFront(FrontDrawer.this.curves[i], FrontDrawer.this.flips[i]);
                    if (FrontDrawer.this.front == null) continue;
                    FrontDrawer.this.fronts.setSample(i, (Data)FrontDrawer.this.front);
                }
            }
        }
    }

    class ReleaseCell
    extends CellImpl {
        private boolean first = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAction() throws VisADException, RemoteException {
            if (this.first) {
                this.first = false;
                return;
            }
            if (FrontDrawer.this.acontrol.getOn()) {
                return;
            }
            FrontDrawer.this.current_time_step = FrontDrawer.this.acontrol.getCurrent();
            if (FrontDrawer.this.current_time_step < 0 || FrontDrawer.this.current_time_step >= FrontDrawer.this.ntimes) {
                return;
            }
            Object object = FrontDrawer.this.data_lock;
            synchronized (object) {
                Data data = null;
                if (FrontDrawer.this.curve_ref != null) {
                    data = FrontDrawer.this.curve_ref.getData();
                }
                Gridded2DSet curve_set = null;
                if (data == null || !(data instanceof UnionSet)) {
                    if (debug) {
                        System.out.println("data null or not UnionSet");
                    }
                    if (FrontDrawer.this.curve_ref != null) {
                        FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                    }
                    curve_set = FrontDrawer.this.last_curve_set;
                } else {
                    SampledSet[] sets = ((UnionSet)data).getSets();
                    if (sets == null || sets.length == 0 || !(sets[0] instanceof Gridded2DSet)) {
                        if (debug) {
                            System.out.println("data not Gridded2DSet");
                        }
                        if (FrontDrawer.this.curve_ref != null) {
                            FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                        }
                        curve_set = FrontDrawer.this.last_curve_set;
                    } else if (sets[0].getManifoldDimension() != 1) {
                        if (debug) {
                            System.out.println("ManifoldDimension != 1");
                        }
                        if (FrontDrawer.this.curve_ref != null) {
                            FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                        }
                        curve_set = FrontDrawer.this.last_curve_set;
                    } else {
                        curve_set = (Gridded2DSet)sets[0];
                    }
                }
                if (curve_set == null) {
                    if (debug) {
                        System.out.println("curve_set is null");
                    }
                    if (FrontDrawer.this.curve_ref != null) {
                        FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                    }
                    return;
                }
                float[][] curve_samples = null;
                try {
                    curve_samples = curve_set.getSamples(false);
                    if (curve_samples == null || curve_samples[0].length < 2) {
                        if (FrontDrawer.this.curve_ref != null) {
                            FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                        }
                        throw new VisADException("bad curve_samples");
                    }
                }
                catch (VisADException e) {
                    if (FrontDrawer.this.curve_ref != null) {
                        FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                    }
                    curve_set = FrontDrawer.this.last_curve_set;
                    try {
                        if (curve_set != null) {
                            curve_samples = curve_set.getSamples(false);
                        }
                        if ((curve_samples == null || curve_samples[0].length < 2) && FrontDrawer.this.curve_ref != null) {
                            FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                        }
                    }
                    catch (VisADException ee) {
                        if (debug) {
                            System.out.println("release " + ee);
                        }
                        return;
                    }
                }
                FrontDrawer.this.last_curve_set = curve_set;
                boolean flip = false;
                double[] lat_range = FrontDrawer.this.lat_map.getRange();
                double[] lon_range = FrontDrawer.this.lon_map.getRange();
                if (lat_range[1] < lat_range[0]) {
                    boolean bl = flip = !flip;
                }
                if (lon_range[1] < lon_range[0]) {
                    boolean bl = flip = !flip;
                }
                if ((double)curve_samples[FrontDrawer.this.lat_index][0] < 0.0) {
                    boolean bl = flip = !flip;
                }
                if (FrontDrawer.this.lon_index < FrontDrawer.this.lat_index) {
                    flip = !flip;
                }
                float[][] curve = new float[][]{FrontDrawer.this.lat_map.scaleValues(curve_samples[FrontDrawer.this.lat_index]), FrontDrawer.this.lon_map.scaleValues(curve_samples[FrontDrawer.this.lon_index])};
                FrontDrawer.this.front = FrontDrawer.this.robustCurveToFront(curve, flip);
                ((FrontDrawer)FrontDrawer.this).curves[((FrontDrawer)FrontDrawer.this).current_time_step] = curve;
                ((FrontDrawer)FrontDrawer.this).flips[((FrontDrawer)FrontDrawer.this).current_time_step] = flip;
                if (FrontDrawer.this.front != null) {
                    FrontDrawer.this.fronts.setSample(FrontDrawer.this.current_time_step, (Data)FrontDrawer.this.front);
                }
                FrontDrawer.this.front_ref.setData(FrontDrawer.this.fronts);
                if (FrontDrawer.this.curve_ref != null) {
                    FrontDrawer.this.curve_ref.setData(FrontDrawer.this.init_curve);
                }
            }
        }
    }
}

