/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.FunctionType;
import visad.MathType;
import visad.RealTuple;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.ShadowType;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADError;
import visad.VisADException;

public class RealTupleType
extends TupleType {
    private CoordinateSystem DefaultCoordinateSystem;
    private Unit[] DefaultUnits;
    private Set DefaultSet;
    private boolean DefaultSetEverAccessed;
    private static RealType[] components2c = new RealType[]{RealType.XAxis, RealType.YAxis};
    public static final RealTupleType SpatialCartesian2DTuple = new RealTupleType(components2c, true);
    private static RealType[] components3c = new RealType[]{RealType.XAxis, RealType.YAxis, RealType.ZAxis};
    public static final RealTupleType SpatialCartesian3DTuple = new RealTupleType(components3c, true);
    private static RealType[] components2e = new RealType[]{RealType.Longitude, RealType.Latitude};
    public static final RealTupleType SpatialEarth2DTuple = new RealTupleType(components2e, true);
    private static RealType[] componentsll = new RealType[]{RealType.Latitude, RealType.Longitude};
    public static final RealTupleType LatitudeLongitudeTuple = new RealTupleType(componentsll, true);
    private static RealType[] components3e = new RealType[]{RealType.Longitude, RealType.Latitude, RealType.Altitude};
    public static final RealTupleType SpatialEarth3DTuple = new RealTupleType(components3e, true);
    private static RealType[] componentslla = new RealType[]{RealType.Latitude, RealType.Longitude, RealType.Altitude};
    public static final RealTupleType LatitudeLongitudeAltitude = new RealTupleType(componentslla, true);
    private static RealType[] components1t = new RealType[]{RealType.Time};
    public static final RealTupleType Time1DTuple = new RealTupleType(components1t, true);
    private static RealType[] components2g = new RealType[]{RealType.Generic, RealType.Generic};
    public static final RealTupleType Generic2D = new RealTupleType(components2g, true);
    private static RealType[] components3g = new RealType[]{RealType.Generic, RealType.Generic, RealType.Generic};
    public static final RealTupleType Generic3D = new RealTupleType(components3g, true);

    public RealTupleType(RealType[] types) throws VisADException {
        this(types, null, null);
    }

    public RealTupleType(RealType a) throws VisADException {
        this(RealTupleType.makeArray(a), null, null);
    }

    public RealTupleType(RealType a, RealType b) throws VisADException {
        this(RealTupleType.makeArray(a, b), null, null);
    }

    public RealTupleType(RealType a, RealType b, RealType c) throws VisADException {
        this(RealTupleType.makeArray(a, b, c), null, null);
    }

    public RealTupleType(RealType a, RealType b, RealType c, RealType d) throws VisADException {
        this(RealTupleType.makeArray(a, b, c, d), null, null);
    }

    public RealTupleType(RealType[] types, CoordinateSystem coord_sys, Set set) throws VisADException {
        super(types);
        if (coord_sys != null && types.length != coord_sys.getDimension()) {
            throw new CoordinateSystemException("RealTupleType: bad CoordinateSystem dimension");
        }
        this.DefaultCoordinateSystem = coord_sys;
        this.DefaultSet = set;
        this.DefaultSetEverAccessed = false;
        this.setDefaultUnits(types);
        if (this.DefaultCoordinateSystem != null && !Unit.canConvertArray(this.DefaultCoordinateSystem.getCoordinateSystemUnits(), this.DefaultUnits)) {
            throw new UnitException("RealTupleType: CoordinateSystem Units must be convertable with default Units");
        }
        if (this.DefaultSet != null && !Unit.canConvertArray(this.DefaultSet.getSetUnits(), this.DefaultUnits)) {
            throw new UnitException("RealTupleType: default Set Units must be convertable with default Units");
        }
        if (this.DefaultCoordinateSystem != null && this.DefaultSet != null) {
            CoordinateSystem cs = this.DefaultSet.getCoordinateSystem();
            if (cs != null && !cs.getReference().equals(this.DefaultCoordinateSystem.getReference())) {
                throw new CoordinateSystemException("RealTupleType: Default coordinate system " + (coord_sys == null ? null : coord_sys.getReference()) + " must match" + " default set CoordinateSystem " + (cs == null ? null : cs.getReference()));
            }
            if (!Unit.canConvertArray(this.DefaultCoordinateSystem.getCoordinateSystemUnits(), this.DefaultSet.getSetUnits())) {
                throw new UnitException("RealTupleType: CoordinateSystem Units must be convertable with default Set Units");
            }
        }
    }

    public RealTupleType(RealType a, CoordinateSystem coord_sys, Set set) throws VisADException {
        this(RealTupleType.makeArray(a), coord_sys, set);
    }

    public RealTupleType(RealType a, RealType b, CoordinateSystem coord_sys, Set set) throws VisADException {
        this(RealTupleType.makeArray(a, b), coord_sys, set);
    }

    public RealTupleType(RealType a, RealType b, RealType c, CoordinateSystem coord_sys, Set set) throws VisADException {
        this(RealTupleType.makeArray(a, b, c), coord_sys, set);
    }

    public RealTupleType(RealType a, RealType b, RealType c, RealType d, CoordinateSystem coord_sys, Set set) throws VisADException {
        this(RealTupleType.makeArray(a, b, c, d), coord_sys, set);
    }

    RealTupleType(RealType[] types, boolean b) {
        this(types, null, b);
    }

    RealTupleType(RealType[] types, CoordinateSystem coord_sys, boolean b) {
        super(types, b);
        this.DefaultCoordinateSystem = coord_sys;
        this.DefaultSet = null;
        this.DefaultSetEverAccessed = false;
        this.setDefaultUnits(types);
        if (this.DefaultCoordinateSystem != null && !Unit.canConvertArray(this.DefaultCoordinateSystem.getCoordinateSystemUnits(), this.DefaultUnits)) {
            throw new VisADError("RealTupleType (trusted): CoordinateSystem Units must be convertable with default Units");
        }
    }

    public MathType binary(MathType type, int op, Vector names) throws TypeException, VisADException {
        if (type == null) {
            throw new TypeException("RealTupleType.binary: type may not be null");
        }
        if (type instanceof RealTupleType) {
            int n_comps = this.getDimension();
            RealType[] new_types = new RealType[n_comps];
            for (int ii = 0; ii < n_comps; ++ii) {
                RealType type_component = (RealType)((RealTupleType)type).getComponent(ii);
                new_types[ii] = (RealType)this.getComponent(ii).binary(type_component, op, names);
            }
            return new RealTupleType(new_types);
        }
        if (type instanceof RealType) {
            int n_comps = this.getDimension();
            RealType[] new_types = new RealType[n_comps];
            for (int ii = 0; ii < n_comps; ++ii) {
                new_types[ii] = (RealType)this.getComponent(ii).binary(type, op, names);
            }
            return new RealTupleType(new_types);
        }
        if (type instanceof FunctionType && ((FunctionType)type).getRange().equalsExceptName(this)) {
            return new FunctionType(((FunctionType)type).getDomain(), ((FunctionType)type).getRange().binary(this, DataImpl.invertOp(op), names));
        }
        throw new TypeException("RealTupleType.binary: types don't match");
    }

    public MathType unary(int op, Vector names) throws VisADException {
        int n_comps = this.getDimension();
        RealType[] R_types = new RealType[n_comps];
        for (int ii = 0; ii < n_comps; ++ii) {
            R_types[ii] = (RealType)this.getComponent(ii).unary(op, names);
        }
        return new RealTupleType(R_types, this.DefaultCoordinateSystem, null);
    }

    public static RealType[] makeArray(RealType a) {
        RealType[] types = new RealType[]{a};
        return types;
    }

    public static RealType[] makeArray(RealType a, RealType b) {
        RealType[] types = new RealType[]{a, b};
        return types;
    }

    public static RealType[] makeArray(RealType a, RealType b, RealType c) {
        RealType[] types = new RealType[]{a, b, c};
        return types;
    }

    public static RealType[] makeArray(RealType a, RealType b, RealType c, RealType d) {
        RealType[] types = new RealType[]{a, b, c, d};
        return types;
    }

    private void setDefaultUnits(RealType[] types) {
        int n = types.length;
        this.DefaultUnits = new Unit[n];
        for (int i = 0; i < n; ++i) {
            this.DefaultUnits[i] = types[i].getDefaultUnit();
        }
    }

    public Unit[] getDefaultUnits() {
        return Unit.copyUnitsArray(this.DefaultUnits);
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.DefaultCoordinateSystem;
    }

    public synchronized void setDefaultSet(Set sampling) throws VisADException {
        if (sampling.getDimension() != this.getDimension()) {
            throw new SetException("RealTupleType.setDefaultSet: dimensions don't match");
        }
        if (this.DefaultSetEverAccessed) {
            throw new TypeException("RealTupleType: DefaultSet already accessed so cannot change");
        }
        this.DefaultSet = sampling;
        if (this.DefaultSet != null && !Unit.canConvertArray(this.DefaultSet.getSetUnits(), this.DefaultUnits)) {
            throw new UnitException("RealTupleType: default Set Units must be convertable with default Units");
        }
        if (this.DefaultCoordinateSystem != null && this.DefaultSet != null) {
            CoordinateSystem cs = this.DefaultSet.getCoordinateSystem();
            if (cs != null && !cs.getReference().equals(this.DefaultCoordinateSystem.getReference())) {
                throw new CoordinateSystemException("RealTupleType: Default coordinate system " + this.DefaultCoordinateSystem.getReference() + " must match" + " default set CoordinateSystem " + (cs == null ? null : cs.getReference()));
            }
            if (!Unit.canConvertArray(this.DefaultCoordinateSystem.getCoordinateSystemUnits(), this.DefaultSet.getSetUnits())) {
                throw new UnitException("RealTupleType: CoordinateSystem Units must be convertable with default Set Units");
            }
        }
    }

    public synchronized Set getDefaultSet() {
        this.DefaultSetEverAccessed = true;
        return this.DefaultSet;
    }

    public boolean equalsExceptName(MathType type) {
        int n = this.getDimension();
        try {
            if (type instanceof RealType) {
                return n == 1 && this.getComponent(0) instanceof RealType;
            }
            if (!(type instanceof RealTupleType)) {
                return false;
            }
            if (n != ((TupleType)type).getDimension()) {
                return false;
            }
            boolean flag = true;
            for (int i = 0; i < n; ++i) {
                flag = flag && this.getComponent(i).equalsExceptName(((TupleType)type).getComponent(i));
            }
            return flag;
        }
        catch (VisADException e) {
            return false;
        }
    }

    public boolean equalsExceptNameButUnits(MathType type) {
        int n = this.getDimension();
        try {
            if (type instanceof RealType) {
                return type.equalsExceptNameButUnits(this);
            }
            if (!(type instanceof RealTupleType)) {
                return false;
            }
            if (n != ((RealTupleType)type).getDimension()) {
                return false;
            }
            boolean flag = true;
            for (int i = 0; i < n; ++i) {
                flag = flag && this.getComponent(i).equalsExceptNameButUnits(((RealTupleType)type).getComponent(i));
            }
            return flag;
        }
        catch (VisADException e) {
            return false;
        }
    }

    public String prettyString(int indent) {
        try {
            if (this.getDimension() == 1) {
                return ((RealType)this.getComponent(0)).toString();
            }
        }
        catch (VisADException e) {
            return super.prettyString(0);
        }
        return super.prettyString(0);
    }

    public Data missingData() {
        return new RealTuple(this);
    }

    public ShadowType buildShadowType(DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return link.getRenderer().makeShadowRealTupleType(this, link, parent);
    }
}

