/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import visad.BaseQuantity;
import visad.DerivedUnit;
import visad.Unit;
import visad.UnitException;

public final class QuantityDimension
implements Serializable,
Comparable {
    private byte[] exponents;

    public QuantityDimension() {
        this.initialize(0);
    }

    public QuantityDimension(QuantityDimension that) {
        this.initialize(that.exponents.length);
        System.arraycopy(that.exponents, 0, this.exponents, 0, that.exponents.length);
    }

    public QuantityDimension(Unit unit) throws UnitException {
        this.initialize(unit.getDerivedUnit());
    }

    private void initialize(int n) {
        this.exponents = new byte[n];
    }

    private void initialize(DerivedUnit unit) throws UnitException {
        this.initialize(BaseQuantity.size());
        for (int i = 0; i < unit.factors.length; ++i) {
            String name = unit.factors[i].baseUnit.quantityName();
            BaseQuantity baseQuantity = BaseQuantity.get(name);
            if (baseQuantity == null) {
                throw new UnitException("No base quantity for \"" + name + "\"");
            }
            this.exponents[baseQuantity.getIndex()] = (byte)unit.factors[i].power;
        }
    }

    public int compareTo(Object obj) {
        QuantityDimension that = (QuantityDimension)obj;
        return this.isShorterThan(that) ? QuantityDimension.compare(this, that) : -QuantityDimension.compare(that, this);
    }

    private boolean isShorterThan(QuantityDimension that) {
        return this.exponents.length < that.exponents.length;
    }

    private static int compare(QuantityDimension shorter, QuantityDimension longer) {
        int i;
        int n = 0;
        for (i = 0; n == 0 && i < shorter.exponents.length; ++i) {
            n = shorter.exponents[i] - longer.exponents[i];
        }
        for (i = shorter.exponents.length; n == 0 && i < longer.exponents.length; ++i) {
            n = -longer.exponents[i];
        }
        return n;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public QuantityDimension raise(int power) {
        QuantityDimension newDimension = new QuantityDimension(this);
        int i = 0;
        while (i < newDimension.exponents.length) {
            int n = i++;
            newDimension.exponents[n] = (byte)(newDimension.exponents[n] * power);
        }
        return newDimension;
    }

    public QuantityDimension multiply(QuantityDimension that) {
        return this.isShorterThan(that) ? QuantityDimension.multiply(this, that) : QuantityDimension.multiply(that, this);
    }

    private static QuantityDimension multiply(QuantityDimension shorter, QuantityDimension longer) {
        QuantityDimension newDimension = new QuantityDimension(longer);
        for (int i = 0; i < shorter.exponents.length; ++i) {
            int n = i;
            newDimension.exponents[n] = (byte)(newDimension.exponents[n] + shorter.exponents[i]);
        }
        return newDimension;
    }

    public QuantityDimension divide(QuantityDimension that) {
        return this.multiply(that.raise(-1));
    }

    public boolean isDimensionless() {
        for (int i = 0; i < this.exponents.length; ++i) {
            if (this.exponents[i] == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String rep;
        if (this.isDimensionless()) {
            rep = "1";
        } else {
            StringBuffer buf = new StringBuffer(128);
            for (int i = 0; i < this.exponents.length; ++i) {
                byte exponent = this.exponents[i];
                if (exponent == 0) continue;
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append("(");
                buf.append(BaseQuantity.get(i).getName());
                buf.append(")");
                if (exponent == 1) continue;
                buf.append("^");
                buf.append(exponent);
            }
            rep = buf.toString();
        }
        return rep;
    }

    public static void main(String[] args) {
        QuantityDimension dim1 = new QuantityDimension();
        dim1.exponents[0] = -3;
        dim1.exponents[1] = -2;
        dim1.exponents[2] = -1;
        dim1.exponents[3] = 0;
        dim1.exponents[4] = 1;
        dim1.exponents[5] = 2;
        dim1.exponents[6] = 3;
        dim1.exponents[7] = 4;
        System.out.println("dim1=(" + dim1 + ")");
        System.out.println("dim1.equals(dim1)=" + dim1.equals(dim1));
        System.out.println("dim1.compareTo(dim1)=" + dim1.compareTo(dim1));
        QuantityDimension dim2 = new QuantityDimension();
        dim2.exponents[0] = -3;
        dim2.exponents[1] = -2;
        dim2.exponents[2] = -1;
        dim2.exponents[3] = 1;
        dim2.exponents[4] = 1;
        dim2.exponents[5] = 2;
        dim2.exponents[6] = 3;
        dim2.exponents[7] = 4;
        System.out.println("dim2=(" + dim2 + ")");
        System.out.println("dim1.equals(dim2)=" + dim1.equals(dim2));
        System.out.println("dim1.compareTo(dim2)=" + dim1.compareTo(dim2));
    }
}

