/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.CartesianProductCoordinateSystem;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.DomainException;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldEnumerator;
import visad.FieldException;
import visad.FlatField;
import visad.FloatSet;
import visad.Function;
import visad.FunctionImpl;
import visad.FunctionType;
import visad.GriddedDoubleSet;
import visad.GriddedSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.ProductSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowType;
import visad.SimpleSet;
import visad.SingletonSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleIface;
import visad.TupleType;
import visad.TypeException;
import visad.UnimplementedException;
import visad.UnionSet;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.VisADRay;
import visad.util.Trace;

public class FieldImpl
extends FunctionImpl
implements Field {
    Set DomainSet;
    CoordinateSystem DomainCoordinateSystem;
    Unit[] DomainUnits;
    int Length;
    private Data[] MyRange;
    private VisADRay RangeLock = new VisADRay();
    private boolean MissingFlag;

    public FieldImpl(FunctionType type) throws VisADException {
        this(type, null);
    }

    public FieldImpl(FunctionType type, Set set) throws VisADException {
        this(type, set, true);
    }

    protected FieldImpl(FunctionType type, Set set, boolean createRangeArray) throws VisADException {
        super(type);
        RealTupleType DomainType = type.getDomain();
        if (set == null) {
            set = DomainType.getDefaultSet();
        }
        if (set == null) {
            throw new SetException("FieldImpl: set cannot be null");
        }
        if (set instanceof DoubleSet || set instanceof FloatSet) {
            throw new SetException("FieldImpl: set may not be DoubleSet or FloatSet");
        }
        if (DomainType.getDimension() != set.getDimension()) {
            throw new SetException("FieldImpl: set dimension " + set.getDimension() + " and type dimension " + DomainType.getDimension() + " don't match");
        }
        this.DomainSet = DomainType.equals(((SetType)set.getType()).getDomain()) ? set : (Set)set.cloneButType(new SetType(DomainType));
        this.DomainCoordinateSystem = this.DomainSet.getCoordinateSystem();
        CoordinateSystem domTypeCs = DomainType.getCoordinateSystem();
        if (domTypeCs == null ? this.DomainCoordinateSystem != null : this.DomainCoordinateSystem != null && !domTypeCs.getReference().equals(this.DomainCoordinateSystem.getReference())) {
            throw new CoordinateSystemException(domTypeCs, this.DomainCoordinateSystem);
        }
        this.DomainUnits = this.DomainSet.getSetUnits();
        this.Length = this.DomainSet.getLength();
        if (createRangeArray) {
            this.MyRange = new Data[this.Length];
        }
        this.MissingFlag = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Data[] getRange() {
        VisADRay visADRay = this.RangeLock;
        synchronized (visADRay) {
            if (this.MyRange == null) {
                this.MyRange = new Data[this.getLength()];
            }
        }
        return this.MyRange;
    }

    public void setSamples(Data[] range, boolean copy) throws VisADException, RemoteException {
        this.setSamples(range, copy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSamples(Data[] range, boolean copy, boolean checkAllRangeTypes) throws VisADException, RemoteException {
        if (range == null) {
            this.MyRange = null;
            this.MissingFlag = true;
            return;
        }
        if (range.length != this.getLength()) {
            throw new FieldException("FieldImpl.setSamples: bad array length");
        }
        Data[] Range2 = this.getRange();
        VisADRay visADRay = this.RangeLock;
        synchronized (visADRay) {
            int i;
            this.MissingFlag = false;
            MathType t = ((FunctionType)this.Type).getRange();
            for (i = 0; i < this.getLength(); ++i) {
                if (range[i] != null) {
                    if ((i == 0 || checkAllRangeTypes) && !t.equals(range[i].getType())) {
                        throw new TypeException("FieldImpl.setSamples: sample#" + i + " type " + range[i].getType() + " doesn't match field type " + t);
                    }
                    if (copy) {
                        Range2[i] = (Data)range[i].dataClone();
                        continue;
                    }
                    Range2[i] = range[i];
                    continue;
                }
                Range2[i] = null;
            }
            for (i = 0; i < this.getLength(); ++i) {
                if (!(Range2[i] instanceof DataImpl)) continue;
                ((DataImpl)Range2[i]).setParent(this);
            }
        }
        this.notifyReferences();
    }

    public Set getDomainSet() {
        return this.DomainSet;
    }

    public int getLength() {
        return this.Length;
    }

    public Unit[] getDomainUnits() {
        return this.DomainUnits;
    }

    public CoordinateSystem getDomainCoordinateSystem() {
        return this.DomainCoordinateSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[][] getStringValues() throws VisADException, RemoteException {
        MathType RangeType;
        TextType[] textComponents = ((FunctionType)this.Type).getTextComponents();
        if (textComponents == null) {
            return null;
        }
        int[] textIndices = ((FunctionType)this.Type).getTextIndices();
        int n = textComponents.length;
        int len = this.getLength();
        String[][] values = new String[n][len];
        if (!this.isMissing()) {
            RangeType = ((FunctionType)this.Type).getRange();
            VisADRay visADRay = this.RangeLock;
            synchronized (visADRay) {
            }
        } else {
            int k = 0;
            while (k < n) {
                for (int i = 0; i < len; ++i) {
                    values[k][i] = "";
                }
                ++k;
            }
            return values;
        }
        {
            int i = 0;
            while (i < len) {
                int k;
                Data range;
                Data data = range = this.MyRange == null ? null : this.MyRange[i];
                if (range == null || range.isMissing()) {
                    for (k = 0; k < n; ++k) {
                        values[k][i] = "";
                    }
                } else if (RangeType instanceof TextType) {
                    values[0][i] = ((Text)range).getValue();
                } else if (RangeType instanceof TupleType) {
                    for (k = 0; k < n; ++k) {
                        Text t = (Text)((TupleIface)range).getComponent(textIndices[k]);
                        values[k][i] = t.getValue();
                    }
                }
                ++i;
            }
            return values;
        }
    }

    public float[][] getFloats() throws VisADException, RemoteException {
        return this.getFloats(true);
    }

    public float[][] getFloats(boolean copy) throws VisADException, RemoteException {
        return Set.doubleToFloat(this.getValues(copy));
    }

    public double[][] getValues() throws VisADException, RemoteException {
        return this.getValues(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double[][] getValues(boolean copy) throws VisADException, RemoteException {
        MathType RangeType;
        RealType[] realComponents = ((FunctionType)this.Type).getRealComponents();
        if (realComponents == null) {
            return null;
        }
        int n = realComponents.length;
        Unit[] units = this.getDefaultRangeUnits();
        int len = this.getLength();
        double[][] values = new double[n][len];
        if (!this.isMissing()) {
            RangeType = ((FunctionType)this.Type).getRange();
            VisADRay visADRay = this.RangeLock;
            synchronized (visADRay) {
            }
        } else {
            int k = 0;
            while (k < n) {
                for (int i = 0; i < len; ++i) {
                    values[k][i] = Double.NaN;
                }
                ++k;
            }
            return values;
        }
        {
            int i = 0;
            while (i < len) {
                int k;
                Data range;
                Data data = range = this.MyRange == null ? null : this.MyRange[i];
                if (range == null || range.isMissing()) {
                    for (k = 0; k < n; ++k) {
                        values[k][i] = Double.NaN;
                    }
                } else if (RangeType instanceof RealType) {
                    values[0][i] = ((Real)range).getValue(units[0]);
                } else if (RangeType instanceof TupleType) {
                    k = 0;
                    for (int j = 0; j < ((TupleType)RangeType).getDimension(); ++j) {
                        MathType component_type = ((TupleType)RangeType).getComponent(j);
                        Data component = ((TupleIface)range).getComponent(j);
                        if (component_type instanceof RealType) {
                            values[k][i] = ((Real)component).getValue(units[k]);
                            ++k;
                            continue;
                        }
                        if (!(component_type instanceof RealTupleType)) continue;
                        for (int m = 0; m < ((TupleType)component_type).getDimension(); ++k, ++m) {
                            Data comp_comp = ((TupleIface)component).getComponent(m);
                            values[k][i] = ((Real)comp_comp).getValue(units[k]);
                        }
                    }
                }
                ++i;
            }
            return values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSamples(double[][] range) throws VisADException, RemoteException {
        RealType[] realComponents = ((FunctionType)this.Type).getRealComponents();
        if (!((FunctionType)this.Type).getFlat()) {
            throw new FieldException("FieldImpl.setSamples: not Flat range");
        }
        if (realComponents == null) {
            throw new FieldException("FieldImpl.setSamples: no Real components");
        }
        int n = realComponents.length;
        int len = this.getLength();
        if (range == null || range.length != n) {
            throw new FieldException("FieldImpl.setSamples: bad tuple length");
        }
        if (range[0] == null || range[0].length != len) {
            throw new FieldException("FieldImpl.setSamples: bad array length");
        }
        Unit[] units = this.getDefaultRangeUnits();
        MathType RangeType = ((FunctionType)this.Type).getRange();
        VisADRay visADRay = this.RangeLock;
        synchronized (visADRay) {
            this.MissingFlag = false;
            Data[] Range2 = this.getRange();
            if (RangeType instanceof RealType) {
                for (int i = 0; i < len; ++i) {
                    Range2[i] = new Real((RealType)RangeType, range[0][i], units[0]);
                }
            } else if (RangeType instanceof RealTupleType) {
                int ntup = ((RealTupleType)RangeType).getDimension();
                Real[] reals = new Real[ntup];
                for (int i = 0; i < len; ++i) {
                    for (int j = 0; j < ntup; ++j) {
                        RealType type = (RealType)((RealTupleType)RangeType).getComponent(j);
                        reals[j] = new Real(type, range[j][i], units[j]);
                    }
                    Range2[i] = new RealTuple(reals);
                }
            } else if (RangeType instanceof TupleType) {
                int ntup = ((TupleType)RangeType).getDimension();
                Data[] data = new Real[ntup];
                MathType[] types = new MathType[ntup];
                for (int j = 0; j < ntup; ++j) {
                    types[j] = ((TupleType)RangeType).getComponent(j);
                }
                for (int i = 0; i < len; ++i) {
                    int k = 0;
                    for (int j = 0; j < ntup; ++j) {
                        if (types[j] instanceof RealType) {
                            data[j] = new Real((RealType)types[j], range[k][i], units[k]);
                            ++k;
                            continue;
                        }
                        int mtup = ((RealTupleType)types[j]).getDimension();
                        Real[] reals = new Real[mtup];
                        for (int m = 0; m < mtup; ++m) {
                            RealType type = (RealType)((RealTupleType)types[j]).getComponent(m);
                            reals[m] = new Real(type, range[k][i], units[k]);
                            ++k;
                        }
                        data[j] = new RealTuple(reals);
                    }
                    Range2[i] = new Tuple(data);
                }
            }
        }
    }

    public void setSamples(float[][] range) throws VisADException, RemoteException {
        this.setSamples(Set.floatToDouble(range));
    }

    public Unit[][] getRangeUnits() throws VisADException, RemoteException {
        RealType[] realComponents = ((FunctionType)this.Type).getRealComponents();
        if (realComponents == null) {
            return null;
        }
        int n = realComponents.length;
        Unit[][] units = new Unit[n][this.getLength()];
        Unit[] default_units = this.getDefaultRangeUnits();
        MathType RangeType = ((FunctionType)this.Type).getRange();
        for (int i = 0; i < this.getLength(); ++i) {
            int k;
            Data range;
            Data data = range = this.MyRange == null ? null : this.MyRange[i];
            if (range == null || range.isMissing()) {
                for (k = 0; k < n; ++k) {
                    units[k][i] = default_units[k];
                }
                continue;
            }
            if (RangeType instanceof RealType) {
                units[0][i] = ((Real)range).getUnit();
                continue;
            }
            if (!(RangeType instanceof TupleType)) continue;
            k = 0;
            for (int j = 0; j < ((TupleType)RangeType).getDimension(); ++j) {
                MathType component_type = ((TupleType)RangeType).getComponent(i);
                Data component = ((TupleIface)range).getComponent(j);
                if (component_type instanceof RealType) {
                    units[k][i] = ((Real)component).getUnit();
                    ++k;
                    continue;
                }
                if (!(component_type instanceof RealTupleType)) continue;
                for (int m = 0; m < ((TupleType)component_type).getDimension(); ++m) {
                    Data comp_comp = ((TupleIface)component).getComponent(m);
                    units[k][i] = ((Real)comp_comp).getUnit();
                    ++k;
                }
            }
        }
        return units;
    }

    public CoordinateSystem[] getRangeCoordinateSystem() throws VisADException, RemoteException {
        MathType RangeType = ((FunctionType)this.Type).getRange();
        if (!(RangeType instanceof RealTupleType)) {
            throw new TypeException("FieldImpl.getRangeCoordinateSystem: Range is not RealTupleType");
        }
        CoordinateSystem[] cs = new CoordinateSystem[this.getLength()];
        CoordinateSystem default_cs = ((RealTupleType)RangeType).getCoordinateSystem();
        for (int i = 0; i < this.getLength(); ++i) {
            Data range = this.MyRange == null ? null : this.MyRange[i];
            cs[i] = range == null || range.isMissing() ? default_cs : ((RealTuple)range).getCoordinateSystem();
        }
        return cs;
    }

    public CoordinateSystem[] getRangeCoordinateSystem(int component) throws VisADException, RemoteException {
        MathType RangeType = ((FunctionType)this.Type).getRange();
        if (!(RangeType instanceof TupleType) || RangeType instanceof RealTupleType) {
            throw new TypeException("FieldImpl.getRangeCoordinateSystem: Range must be TupleType but not RealTupleType");
        }
        MathType component_type = ((TupleType)RangeType).getComponent(component);
        if (!(component_type instanceof RealTupleType)) {
            throw new TypeException("FieldImpl.getRangeCoordinateSystem: selected Range component must be RealTupleType");
        }
        CoordinateSystem[] cs = new CoordinateSystem[this.getLength()];
        CoordinateSystem default_cs = ((RealTupleType)component_type).getCoordinateSystem();
        for (int i = 0; i < this.getLength(); ++i) {
            Data comp;
            Data range;
            Data data = range = this.MyRange == null ? null : this.MyRange[i];
            cs[i] = range == null || range.isMissing() ? default_cs : ((comp = ((TupleIface)range).getComponent(component)) == null || comp.isMissing() ? default_cs : ((RealTuple)comp).getCoordinateSystem());
        }
        return cs;
    }

    public Unit[] getDefaultRangeUnits() {
        RealType[] realComponents = ((FunctionType)this.Type).getRealComponents();
        if (realComponents == null) {
            return null;
        }
        int n = realComponents.length;
        Unit[] units = new Unit[n];
        for (int i = 0; i < n; ++i) {
            units[i] = realComponents[i].getDefaultUnit();
        }
        return units;
    }

    public Data getSample(int index) throws VisADException, RemoteException {
        return this.getSample(index, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data getSample(int index, boolean metadataOnly) throws VisADException, RemoteException {
        VisADRay visADRay = this.RangeLock;
        synchronized (visADRay) {
            if (this.MyRange == null || this.isMissing() || index < 0 || index >= this.getLength() || this.MyRange[index] == null) {
                return ((FunctionType)this.Type).getRange().missingData();
            }
            return this.MyRange[index];
        }
    }

    public void setSample(RealTuple domain, Data range, boolean copy) throws VisADException, RemoteException {
        if (this.getDomainSet() == null) {
            throw new FieldException("FieldImpl.setSample: DomainSet undefined");
        }
        if (!((FunctionType)this.Type).getDomain().equals(domain.getType())) {
            throw new TypeException("FieldImpl.setSample: bad domain type");
        }
        int dimension = this.getDomainSet().getDimension();
        double[][] vals = new double[dimension][1];
        for (int j = 0; j < dimension; ++j) {
            vals[j][0] = ((Real)domain.getComponent(j)).getValue();
        }
        int[] indices = this.getDomainSet().doubleToIndex(vals);
        this.setSample(indices[0], range, copy);
    }

    public void setSample(RealTuple domain, Data range) throws VisADException, RemoteException {
        this.setSample(domain, range, true);
    }

    public void setSample(int index, Data range) throws VisADException, RemoteException {
        this.setSample(index, range, true);
    }

    public void setSample(int index, Data range, boolean copy) throws VisADException, RemoteException {
        this.setSample(index, range, copy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSample(int index, Data range, boolean copy, boolean checkRangeType) throws VisADException, RemoteException {
        if (this.getDomainSet() == null) {
            throw new FieldException("FieldImpl.setSample: DomainSet undefined");
        }
        if (range != null && checkRangeType && !((FunctionType)this.Type).getRange().equals(range.getType())) {
            throw new TypeException("FieldImpl.setSample: bad range type");
        }
        if (index >= 0 && index < this.getLength()) {
            Data[] Range2 = this.getRange();
            VisADRay visADRay = this.RangeLock;
            synchronized (visADRay) {
                this.MissingFlag = false;
                if (range != null) {
                    Range2[index] = copy ? (Data)range.dataClone() : range;
                    if (Range2[index] instanceof DataImpl) {
                        ((DataImpl)Range2[index]).setParent(this);
                    }
                } else {
                    Range2[index] = null;
                }
            }
        }
        this.notifyReferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMissing() {
        VisADRay visADRay = this.RangeLock;
        synchronized (visADRay) {
            return this.MissingFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data binary(Data data, int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        boolean field_flag;
        if (new_type == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (this.Type.equalsExceptName(data.getType())) {
            if (!this.Type.equalsExceptName(new_type)) {
                throw new TypeException("binary: new_type doesn't match return type");
            }
            field_flag = true;
            if (((Field)data).isFlatField()) {
                data = data.local();
                data = ((FlatField)data).convertToField();
            }
        } else if (data instanceof Real || ((FunctionType)this.Type).getRange().equalsExceptName(data.getType())) {
            field_flag = false;
            if (!this.Type.equalsExceptName(new_type)) {
                throw new TypeException("binary: new_type doesn't match return type");
            }
        } else {
            if (data instanceof Field && ((FunctionType)data.getType()).getRange().equalsExceptName(this.Type)) {
                if (!((FunctionType)data.getType()).getRange().equalsExceptName(new_type)) {
                    throw new TypeException("binary: new_type doesn't match return type");
                }
                return data.binary(this, FieldImpl.invertOp(op), new_type, sampling_mode, error_mode);
            }
            throw new TypeException("FieldImpl.binary: types don't match");
        }
        FieldImpl new_field = new FieldImpl((FunctionType)new_type, this.getDomainSet());
        if (this.isMissing() || data.isMissing()) {
            return new_field;
        }
        Data[] range = new Data[this.getLength()];
        MathType m_type = ((FunctionType)new_type).getRange();
        if (field_flag) {
            data = ((Field)data).resample(this.getDomainSet(), sampling_mode, error_mode);
            for (int i = 0; i < this.getLength(); ++i) {
                VisADRay visADRay = this.RangeLock;
                synchronized (visADRay) {
                    range[i] = this.MyRange == null || this.MyRange[i] == null ? null : this.MyRange[i].binary(((Field)data).getSample(i), op, m_type, sampling_mode, error_mode);
                    continue;
                }
            }
        } else {
            for (int i = 0; i < this.getLength(); ++i) {
                VisADRay visADRay = this.RangeLock;
                synchronized (visADRay) {
                    range[i] = this.MyRange == null || this.MyRange[i] == null ? null : this.MyRange[i].binary(data, op, m_type, sampling_mode, error_mode);
                    continue;
                }
            }
        }
        new_field.setSamples(range, false);
        return new_field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (new_type == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        if (!this.Type.equalsExceptName(new_type)) {
            throw new TypeException("unary: new_type doesn't match return type");
        }
        MathType m_type = ((FunctionType)new_type).getRange();
        RealTupleType d_type = ((FunctionType)new_type).getDomain();
        Set new_set = null;
        new_set = !d_type.equals(((FunctionType)this.getType()).getDomain()) ? (Set)this.getDomainSet().cloneButType(d_type) : this.getDomainSet();
        FieldImpl new_field = new FieldImpl((FunctionType)new_type, new_set);
        if (this.isMissing()) {
            return new_field;
        }
        Data[] range = new Data[this.getLength()];
        for (int i = 0; i < this.getLength(); ++i) {
            VisADRay visADRay = this.RangeLock;
            synchronized (visADRay) {
                range[i] = this.MyRange == null || this.MyRange[i] == null ? null : this.MyRange[i].unary(op, m_type, sampling_mode, error_mode);
                continue;
            }
        }
        new_field.setSamples(range, false);
        return new_field;
    }

    public static Field combine(Field[] fields) throws VisADException, RemoteException {
        return FieldImpl.combine(fields, 100, 202, true);
    }

    public static Field combine(Field[] fields, boolean flatten) throws VisADException, RemoteException {
        return FieldImpl.combine(fields, 100, 202, flatten);
    }

    public static Field combine(Field[] fields, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return FieldImpl.combine(fields, sampling_mode, error_mode, true);
    }

    public static Field combine(Field[] fields, int sampling_mode, int error_mode, boolean flatten) throws VisADException, RemoteException {
        return FieldImpl.combine(fields, sampling_mode, error_mode, flatten, true);
    }

    public static Field combine(Field[] fields, int sampling_mode, int error_mode, boolean flatten, boolean copy) throws VisADException, RemoteException {
        FieldImpl new_field;
        int jj;
        int n_dims;
        int ii;
        Trace.call1("combine, copy = " + copy);
        int domainDim = 0;
        boolean allFlat = true;
        Field field_0 = fields[0];
        int n_fields = fields.length;
        MathType[] fieldRange_s = new MathType[n_fields];
        MathType[][] rangeComp_s = new MathType[n_fields][];
        FunctionType[] fieldType_s = new FunctionType[n_fields];
        float[][] valuesF = null;
        Object new_valuesF = null;
        double[][] valuesD = null;
        Object new_valuesD = null;
        boolean cnt = false;
        n_fields = fields.length;
        int n_comps = 0;
        for (ii = 0; ii < n_fields; ++ii) {
            if (ii == 0) {
                domainDim = field_0.getDomainDimension();
            } else if (domainDim != fields[ii].getDomainDimension()) {
                throw new VisADException("FieldImpl.combine: domain dimensions of inputfields must match");
            }
            if (!fields[ii].isFlatField()) {
                allFlat = false;
            }
            fieldType_s[ii] = (FunctionType)fields[ii].getType();
            fieldRange_s[ii] = ((FunctionType)fields[ii].getType()).getRange();
            MathType range = fieldRange_s[ii];
            if (range instanceof RealType) {
                rangeComp_s[ii] = new MathType[1];
                rangeComp_s[ii][0] = range;
                ++n_comps;
                continue;
            }
            if (range instanceof RealTupleType) {
                rangeComp_s[ii] = new MathType[1];
                rangeComp_s[ii][0] = range;
                ++n_comps;
                continue;
            }
            if (range instanceof TupleType) {
                n_dims = ((TupleType)range).getDimension();
                rangeComp_s[ii] = new MathType[n_dims];
                for (jj = 0; jj < n_dims; ++jj) {
                    rangeComp_s[ii][jj] = ((TupleType)range).getComponent(jj);
                }
                n_comps += n_dims;
                continue;
            }
            rangeComp_s[ii] = new MathType[1];
            rangeComp_s[ii][0] = range;
            ++n_comps;
        }
        Set domainSet_0 = field_0.getDomainSet();
        RealTupleType domainType_0 = ((FunctionType)field_0.getType()).getDomain();
        int n_samples_0 = domainSet_0.getLength();
        if (allFlat) {
            TupleType new_range;
            int length;
            boolean allReal = true;
            int tupleDim = 0;
            cnt = false;
            Vector<CoordinateSystem> coordsys_s = new Vector<CoordinateSystem>();
            Vector<MathType> m_types = new Vector<MathType>();
            Vector<MathType> r_types = new Vector<MathType>();
            for (ii = 0; ii < n_fields; ++ii) {
                MathType m_type;
                CoordinateSystem[] rangeCoordSys_s;
                Field field = fields[ii];
                MathType fieldRange = fieldRange_s[ii];
                if (fieldRange instanceof RealType) {
                    m_types.add(fieldRange);
                    r_types.add(fieldRange);
                    rangeCoordSys_s = field.getRangeCoordinateSystem();
                    coordsys_s.add(rangeCoordSys_s[0]);
                    ++tupleDim;
                    continue;
                }
                if (fieldRange instanceof RealTupleType) {
                    n_dims = ((RealTupleType)fieldRange).getDimension();
                    tupleDim += n_dims;
                    rangeCoordSys_s = field.getRangeCoordinateSystem();
                    if (rangeCoordSys_s[0] == null && flatten) {
                        for (jj = 0; jj < n_dims; ++jj) {
                            m_type = ((RealTupleType)fieldRange).getComponent(jj);
                            m_types.add(m_type);
                            r_types.add(m_type);
                            coordsys_s.add(null);
                        }
                        continue;
                    }
                    m_types.add(fieldRange);
                    coordsys_s.add(rangeCoordSys_s[0]);
                    allReal = false;
                    continue;
                }
                for (jj = 0; jj < rangeComp_s[ii].length; ++jj) {
                    rangeCoordSys_s = field.getRangeCoordinateSystem(jj);
                    m_type = rangeComp_s[ii][jj];
                    if (m_type instanceof RealType) {
                        r_types.add(m_type);
                        m_types.add(m_type);
                        coordsys_s.add(rangeCoordSys_s[0]);
                        ++tupleDim;
                        continue;
                    }
                    if (!(m_type instanceof RealTupleType)) continue;
                    n_dims = ((RealTupleType)m_type).getDimension();
                    tupleDim += n_dims;
                    if (rangeCoordSys_s[0] == null && flatten) {
                        for (int kk = 0; kk < n_dims; ++kk) {
                            m_types.add(((RealTupleType)m_type).getComponent(kk));
                            r_types.add(((RealTupleType)m_type).getComponent(kk));
                            coordsys_s.add(null);
                        }
                        continue;
                    }
                    m_types.add(m_type);
                    coordsys_s.add(rangeCoordSys_s[0]);
                    allReal = false;
                }
            }
            if (allReal) {
                length = r_types.size();
                RealType[] r_array = new RealType[length];
                for (ii = 0; ii < length; ++ii) {
                    r_array[ii] = (RealType)r_types.elementAt(ii);
                }
                new_range = new RealTupleType(r_array);
            } else {
                length = m_types.size();
                MathType[] m_array = new MathType[length];
                for (ii = 0; ii < length; ++ii) {
                    m_array[ii] = (MathType)m_types.elementAt(ii);
                }
                new_range = new TupleType(m_array);
            }
            FunctionType new_type = new FunctionType(domainType_0, new_range);
            length = coordsys_s.size();
            CoordinateSystem[] all_rangeCoordSys_s = new CoordinateSystem[length];
            for (ii = 0; ii < length; ++ii) {
                all_rangeCoordSys_s[ii] = (CoordinateSystem)coordsys_s.elementAt(ii);
            }
            Set[] new_rangeSets = new Set[tupleDim];
            Unit[] new_rangeUnits = new Unit[tupleDim];
            int cnt_a = 0;
            int cnt_b = 0;
            boolean cnt_c = false;
            boolean cnt_u = false;
            boolean n_coordsys = false;
            boolean allFloat = true;
            FlatField[] resampledFields = new FlatField[n_fields];
            for (ii = 0; ii < n_fields; ++ii) {
                FlatField f_field = (FlatField)fields[ii].local();
                if (ii > 0) {
                    f_field = (FlatField)f_field.resample(domainSet_0, sampling_mode, error_mode);
                }
                resampledFields[ii] = f_field;
                Set[] rangeSets = f_field.getRangeSets();
                int n_sets = rangeSets.length;
                if (allFloat) {
                    for (int s = 0; s < n_sets; ++s) {
                        if (rangeSets[s] instanceof FloatSet) continue;
                        allFloat = false;
                        break;
                    }
                }
                System.arraycopy(rangeSets, 0, new_rangeSets, cnt_a, n_sets);
                cnt_a += n_sets;
            }
            if (allFloat) {
                new_valuesF = new float[tupleDim][];
            } else {
                new_valuesD = new double[tupleDim][];
            }
            for (int f = 0; f < n_fields; ++f) {
                if (allFloat) {
                    valuesF = resampledFields[f].getFloats(copy);
                    for (jj = 0; jj < valuesF.length; ++jj) {
                        new_valuesF[cnt_b++] = valuesF[jj];
                    }
                    continue;
                }
                valuesD = resampledFields[f].getValues(copy);
                for (jj = 0; jj < valuesD.length; ++jj) {
                    new_valuesD[cnt_b++] = valuesD[jj];
                }
            }
            new_field = new_type.getReal() ? new FlatField(new_type, domainSet_0, null, null, new_rangeSets, null) : new FlatField(new_type, domainSet_0, all_rangeCoordSys_s, new_rangeSets, null);
            if (allFloat) {
                ((FlatField)new_field).setSamples((float[][])new_valuesF, false);
            } else {
                ((FlatField)new_field).setSamples((double[][])new_valuesD, false);
            }
        } else {
            TupleType new_range;
            Vector<MathType> sub_types = new Vector<MathType>();
            boolean allReal = true;
            Vector[] v_array = new Vector[n_samples_0];
            for (ii = 0; ii < n_samples_0; ++ii) {
                v_array[ii] = new Vector();
            }
            for (ii = 0; ii < n_fields; ++ii) {
                int kk;
                Field field = ii == 0 ? (Field)((Object)fields[ii].local()) : fields[ii].resample(domainSet_0, sampling_mode, error_mode);
                MathType fieldRange = fieldRange_s[ii];
                if (fieldRange instanceof RealType) {
                    sub_types.add(fieldRange);
                    for (kk = 0; kk < n_samples_0; ++kk) {
                        v_array[kk].add(field.getSample(kk));
                    }
                    continue;
                }
                if (fieldRange instanceof RealTupleType) {
                    if (((RealTupleType)fieldRange).getCoordinateSystem() != null) {
                        sub_types.add(fieldRange);
                        allReal = false;
                        for (kk = 0; kk < n_samples_0; ++kk) {
                            v_array[kk].add(field.getSample(kk));
                        }
                        continue;
                    }
                    n_dims = ((RealTupleType)fieldRange).getDimension();
                    for (jj = 0; jj < n_dims; ++jj) {
                        sub_types.add(((RealTupleType)fieldRange).getComponent(jj));
                    }
                    for (kk = 0; kk < n_samples_0; ++kk) {
                        Data rangeData = field.getSample(kk);
                        for (jj = 0; jj < n_dims; ++jj) {
                            v_array[kk].add(((RealTuple)rangeData).getComponent(jj));
                        }
                    }
                    continue;
                }
                if (fieldRange instanceof TupleType && !(fieldRange instanceof RealTupleType)) {
                    if (!((TupleType)fieldRange).getFlat()) {
                        sub_types.add(fieldRange);
                        for (kk = 0; kk < n_samples_0; ++kk) {
                            v_array[kk].add(field.getSample(kk));
                        }
                        allReal = false;
                        continue;
                    }
                    n_dims = ((TupleType)fieldRange).getDimension();
                    for (ii = 0; ii < n_dims; ++ii) {
                        MathType m_type = ((TupleType)fieldRange).getComponent(ii);
                        if (m_type instanceof RealType) {
                            sub_types.add(m_type);
                            for (kk = 0; kk < n_samples_0; ++kk) {
                                v_array[kk].add(((TupleIface)field.getSample(kk)).getComponent(ii));
                            }
                            continue;
                        }
                        if (!(m_type instanceof RealTupleType)) continue;
                        if (((RealTupleType)m_type).getCoordinateSystem() != null) {
                            sub_types.add(m_type);
                            allReal = false;
                            for (kk = 0; kk < n_samples_0; ++kk) {
                                v_array[kk].add(((TupleIface)field.getSample(kk)).getComponent(ii));
                            }
                            continue;
                        }
                        for (jj = 0; jj < ((RealTupleType)m_type).getDimension(); ++jj) {
                            sub_types.add(((RealTupleType)m_type).getComponent(jj));
                        }
                        for (kk = 0; kk < n_samples_0; ++kk) {
                            RealTuple R_tuple = (RealTuple)((TupleIface)field.getSample(kk)).getComponent(ii);
                            for (jj = 0; jj < ((RealTupleType)m_type).getDimension(); ++jj) {
                                v_array[kk].add(R_tuple.getComponent(jj));
                            }
                        }
                    }
                    continue;
                }
                if (!(fieldRange instanceof FunctionType)) continue;
                sub_types.add(fieldRange);
                for (kk = 0; kk < n_samples_0; ++kk) {
                    v_array[kk].add(field.getSample(kk));
                }
                allReal = false;
            }
            int size = sub_types.size();
            if (allReal) {
                RealType[] r_types = new RealType[size];
                for (ii = 0; ii < size; ++ii) {
                    r_types[ii] = (RealType)sub_types.elementAt(ii);
                }
                new_range = new RealTupleType(r_types);
            } else {
                MathType[] m_types = new MathType[size];
                for (ii = 0; ii < size; ++ii) {
                    m_types[ii] = (MathType)sub_types.elementAt(ii);
                }
                new_range = new TupleType(m_types);
            }
            FunctionType new_type = new FunctionType(domainType_0, new_range);
            new_field = new FieldImpl(new_type, domainSet_0);
            for (ii = 0; ii < n_samples_0; ++ii) {
                size = v_array[ii].size();
                Data[] data_s = new Data[size];
                for (jj = 0; jj < size; ++jj) {
                    data_s[jj] = (Data)v_array[ii].elementAt(jj);
                }
                Tuple data = new Tuple(data_s);
                new_field.setSample(ii, (Data)data, copy);
            }
        }
        Trace.call2("combine, copy = " + copy);
        return new_field;
    }

    public Field extract(MathType type) throws VisADException, RemoteException {
        int index = -1;
        MathType rangeType = ((FunctionType)this.Type).getRange();
        if (!(rangeType instanceof TupleType)) {
            throw new VisADException("FieldImpl.extract: range must be a TupleType");
        }
        int n_comps = ((TupleType)rangeType).getDimension();
        for (int i = 0; i < n_comps; ++i) {
            MathType test_comp = ((TupleType)rangeType).getComponent(i);
            if (!test_comp.equals(type)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            return this.extract(index);
        }
        return null;
    }

    public Field extract(String name) throws VisADException, RemoteException {
        int index = -1;
        MathType rangeType = ((FunctionType)this.Type).getRange();
        if (!(rangeType instanceof TupleType)) {
            throw new VisADException("FieldImpl.extract: range must be a TupleType");
        }
        int n_comps = ((TupleType)rangeType).getDimension();
        for (int i = 0; i < n_comps; ++i) {
            String test_comp = ((TupleType)rangeType).getComponent(i).toString();
            if (!test_comp.equals(name) && !test_comp.equals("(" + name + ")")) continue;
            index = i;
            break;
        }
        if (index != -1) {
            return this.extract(index);
        }
        return null;
    }

    public Field extract(int component) throws VisADException, RemoteException {
        FieldImpl new_field;
        Set domainSet = this.getDomainSet();
        int n_samples = domainSet.getLength();
        MathType rangeType = ((FunctionType)this.Type).getRange();
        RealTupleType domainType = ((FunctionType)this.Type).getDomain();
        if (!(rangeType instanceof TupleType)) {
            throw new VisADException("extract: range type must be TupleType");
        }
        int n_comps = ((TupleType)rangeType).getDimension();
        if (component == 0 && n_comps == 1) {
            return this;
        }
        if (component + 1 > n_comps) {
            throw new VisADException("extract: component selection too large");
        }
        MathType new_range = ((TupleType)rangeType).getComponent(component);
        FunctionType new_type = new FunctionType(domainType, new_range);
        if (new_range instanceof RealType) {
            Unit[] new_unit = new Unit[]{((RealType)new_range).getDefaultUnit()};
            new_field = new FlatField(new_type, domainSet, null, null, null, new_unit);
            double[][] values = new double[1][n_samples];
            for (int ii = 0; ii < n_samples; ++ii) {
                Real real = (Real)((TupleIface)this.getSample(ii)).getComponent(component);
                double value = real.getValue();
                Unit unit = real.getUnit();
                values[0][ii] = new_unit[0].toThis(value, unit);
            }
            ((FlatField)new_field).setSamples(values, false);
        } else if (new_range instanceof RealTupleType) {
            CoordinateSystem coord_out = ((RealTupleType)new_range).getCoordinateSystem();
            int dim = ((RealTupleType)new_range).getDimension();
            Unit[] unit_out = new Unit[dim];
            Unit[] unit_in = new Unit[dim];
            unit_out = ((RealTupleType)new_range).getDefaultUnits();
            new_field = new FlatField(new_type, domainSet, coord_out, null, unit_out);
            double[][] values = new double[dim][n_samples];
            double[][] t_values = new double[dim][1];
            for (int ii = 0; ii < n_samples; ++ii) {
                int jj;
                RealTuple r_tuple = (RealTuple)((TupleIface)this.getSample(ii)).getComponent(component);
                CoordinateSystem coord_in = r_tuple.getCoordinateSystem();
                unit_in = r_tuple.getTupleUnits();
                for (jj = 0; jj < dim; ++jj) {
                    t_values[jj][0] = ((Real)r_tuple.getComponent(jj)).getValue();
                }
                t_values = CoordinateSystem.transformCoordinates((RealTupleType)new_range, coord_out, unit_out, null, (RealTupleType)new_range, coord_in, unit_in, null, t_values);
                for (jj = 0; jj < dim; ++jj) {
                    values[jj][ii] = t_values[jj][0];
                }
            }
            ((FlatField)new_field).setSamples(values, false);
        } else if (new_range instanceof TupleType && ((TupleType)new_range).getFlat()) {
            MathType m_type;
            int ii;
            new_field = new FlatField(new_type, domainSet);
            int dim = ((TupleType)new_range).getDimension();
            int t_dim = 0;
            int n_coordsys = 0;
            for (ii = 0; ii < dim; ++ii) {
                m_type = ((TupleType)new_range).getComponent(ii);
                if (m_type instanceof RealType) {
                    ++t_dim;
                    continue;
                }
                if (!(m_type instanceof RealTupleType)) continue;
                RealTupleType rt_type = (RealTupleType)m_type;
                t_dim += rt_type.getDimension();
                if (rt_type.getCoordinateSystem() == null) continue;
                ++n_coordsys;
            }
            double[][] values = new double[t_dim][n_samples];
            t_dim = 0;
            for (ii = 0; ii < n_samples; ++ii) {
                Data rangeData = this.getSample(ii);
                m_type = rangeData.getType();
                for (int jj = 0; jj < dim; ++jj) {
                    if (m_type instanceof RealType) {
                        values[t_dim][ii] = ((Real)((TupleIface)rangeData).getComponent(jj)).getValue();
                        ++t_dim;
                        continue;
                    }
                    RealTuple r_tuple = (RealTuple)((TupleIface)rangeData).getComponent(jj);
                    for (int kk = 0; kk < ((RealTupleType)m_type).getDimension(); ++kk) {
                        values[t_dim][ii] = ((Real)r_tuple.getComponent(kk)).getValue();
                        ++t_dim;
                    }
                }
            }
            ((FlatField)new_field).setSamples(values, false);
        } else {
            new_field = new FieldImpl(new_type, domainSet);
            for (int ii = 0; ii < n_samples; ++ii) {
                Data rangeData = this.getSample(ii);
                Data new_rangeData = ((TupleIface)rangeData).getComponent(component);
                new_field.setSample(ii, new_rangeData, false);
            }
        }
        return new_field;
    }

    public Field domainFactor(RealType factor) throws DomainException, VisADException, RemoteException {
        return this.domainFactor(factor, false);
    }

    public Field domainFactor(RealType factor, boolean copy) throws DomainException, VisADException, RemoteException {
        int kk;
        int ii;
        Set factor_domain = null;
        Object lengths = null;
        int[] new_lengths = null;
        int[] dim_lengths = null;
        int[] dim_product = null;
        int[] sub_domain = null;
        SampledSet new_domain = null;
        RealTupleType new_domain_type = null;
        FieldImpl factor_field = null;
        FunctionType new_type = null;
        Data[] new_range_data = null;
        RealTupleType domainType = ((FunctionType)this.Type).getDomain();
        MathType rangeType = ((FunctionType)this.Type).getRange();
        int domainDim = domainType.getDimension();
        RealType[] r_types = new RealType[domainDim - 1];
        int factorIndex = domainType.getIndex(factor);
        if (factorIndex < 0) {
            throw new DomainException("domainFactor: factor not element of domain");
        }
        int cnt = 0;
        for (ii = 0; ii < domainDim; ++ii) {
            if (ii == factorIndex) continue;
            r_types[cnt++] = (RealType)domainType.getComponent(ii);
        }
        new_domain_type = new RealTupleType(r_types);
        Set domainSet = this.getDomainSet();
        if (domainSet instanceof LinearSet) {
            factor_domain = ((LinearSet)((Object)domainSet)).getLinear1DComponent(factorIndex);
            dim_lengths = ((GriddedSet)domainSet).getLengths();
            Linear1DSet[] L1D_sets = new Linear1DSet[domainDim - 1];
            new_lengths = new int[domainDim - 1];
            sub_domain = new int[domainDim - 1];
            cnt = 0;
            for (ii = 0; ii < domainDim; ++ii) {
                if (ii == factorIndex) continue;
                L1D_sets[cnt] = ((LinearSet)((Object)domainSet)).getLinear1DComponent(ii);
                new_lengths[cnt] = L1D_sets[cnt].LengthX;
                sub_domain[cnt] = ii;
                ++cnt;
            }
            new_domain = new LinearNDSet((MathType)new_domain_type, L1D_sets);
            new_type = new FunctionType(new_domain_type, rangeType);
        } else {
            if (domainSet instanceof GriddedSet) {
                throw new DomainException("domainFactor: DomainSet is GriddedSet, if aligned use ProductSet");
            }
            if (domainSet instanceof ProductSet) {
                ProductSet prod_set = (ProductSet)((ProductSet)domainSet).product();
                SampledSet[] sets = prod_set.Sets;
                int n_sets = sets.length;
                SampledSet[] sub_sets = new SampledSet[n_sets - 1];
                Set factor_set = null;
                Set fin_factor_set = null;
                int sub_factor_index = -1;
                int fac_set_idx = -1;
                int fac_set_len = -1;
                int[] sub_set_idx = new int[n_sets - 1];
                int[] sub_set_lengths = new int[n_sets - 1];
                cnt = 0;
                for (kk = 0; kk < n_sets; ++kk) {
                    SetType s_type = (SetType)sets[kk].getType();
                    sub_factor_index = s_type.getDomain().getIndex(factor);
                    if (sub_factor_index >= 0) {
                        factor_set = sets[kk];
                        fac_set_idx = kk;
                        fac_set_len = factor_set.getLength();
                        continue;
                    }
                    sub_sets[cnt] = sets[kk];
                    sub_set_idx[cnt] = kk;
                    sub_set_lengths[cnt] = sets[kk].getLength();
                    ++cnt;
                }
                int factor_set_dim = factor_set.getDimension();
                int n_sub_sets = sub_sets.length;
                if (factor_set_dim == 1) {
                    fin_factor_set = factor_set;
                    new_lengths = new int[n_sub_sets];
                    sub_domain = new int[n_sub_sets];
                    dim_lengths = new int[n_sets];
                    new_domain = n_sub_sets > 1 ? new ProductSet(sub_sets) : sub_sets[0];
                    factor_domain = factor_set;
                    System.arraycopy(sub_set_lengths, 0, new_lengths, 0, n_sub_sets);
                    System.arraycopy(sub_set_idx, 0, sub_domain, 0, n_sub_sets);
                    for (ii = 0; ii < n_sub_sets; ++ii) {
                        dim_lengths[sub_set_idx[ii]] = sub_set_lengths[ii];
                    }
                    dim_lengths[fac_set_idx] = fac_set_len;
                    new_type = new FunctionType(((SetType)new_domain.getType()).getDomain(), rangeType);
                } else {
                    if (!(factor_set instanceof LinearNDSet)) {
                        throw new DomainException("cannot factor into " + factor_set.getClass());
                    }
                    MathType n_type = null;
                    new_lengths = new int[n_sub_sets + 1];
                    sub_domain = new int[n_sub_sets + 1];
                    dim_lengths = new int[n_sets + 1];
                    Linear1DSet[] L1D_sets = new Linear1DSet[factor_set_dim - 1];
                    cnt = 0;
                    for (ii = 0; ii < factor_set_dim; ++ii) {
                        if (ii != sub_factor_index) {
                            L1D_sets[cnt] = ((LinearSet)((Object)domainSet)).getLinear1DComponent(ii);
                            ++cnt;
                            continue;
                        }
                        fin_factor_set = ((LinearSet)((Object)domainSet)).getLinear1DComponent(ii);
                    }
                    LinearNDSet new_set = new LinearNDSet(n_type, L1D_sets);
                    cnt = 0;
                    System.arraycopy(sub_set_lengths, 0, new_lengths, 0, fac_set_idx);
                    System.arraycopy(sub_set_idx, 0, sub_domain, 0, fac_set_idx);
                    cnt += fac_set_idx;
                    new_lengths[fac_set_idx] = new_set.getLength();
                    System.arraycopy(sub_set_lengths, fac_set_idx, new_lengths, ++cnt, n_sub_sets - fac_set_idx);
                    System.arraycopy(sub_set_idx, fac_set_idx, sub_domain, cnt, n_sub_sets - fac_set_idx);
                    new_type = new FunctionType(((SetType)new_set.getType()).getDomain(), rangeType);
                    new_domain = new_set;
                }
            } else {
                if (domainSet instanceof UnionSet) {
                    throw new UnimplementedException("domainFactor: DomainSet is UnionSet");
                }
                if (domainSet instanceof IrregularSet) {
                    throw new DomainException("domainFactor: DomainSet is IrregularSet, can't factor");
                }
            }
        }
        int length = factor_domain.getLength();
        new_range_data = new Data[length];
        dim_product = new int[domainDim];
        for (kk = 0; kk < domainDim; ++kk) {
            dim_product[kk] = 1;
            for (int mm = 0; mm < kk; ++mm) {
                int n = kk;
                dim_product[n] = dim_product[n] * dim_lengths[mm];
            }
        }
        int s_dims = new_lengths.length;
        int[] indexes = new int[s_dims];
        int product = 1;
        for (ii = 0; ii < s_dims; ++ii) {
            product *= new_lengths[ii];
        }
        int[] work = new int[product];
        for (int k = 0; k < product; ++k) {
            int k2 = k;
            for (int j = s_dims - 1; j >= 0; --j) {
                int temp = 1;
                for (int m = 0; m < j; ++m) {
                    temp *= new_lengths[m];
                }
                indexes[j] = k2 / temp;
                k2 -= temp * indexes[j];
            }
            for (int t = 0; t < indexes.length; ++t) {
                int n = k;
                work[n] = work[n] + dim_product[sub_domain[t]] * indexes[t];
            }
        }
        if (this.isFlatField()) {
            double[][] old_range_values = this.getValues(false);
            int tup_dim = old_range_values.length;
            for (ii = 0; ii < length; ++ii) {
                double[][] new_range_values = new double[tup_dim][work.length];
                FlatField new_field = new FlatField(new_type, new_domain);
                for (int jj = 0; jj < work.length; ++jj) {
                    int index = 0;
                    index = ii * dim_product[factorIndex];
                    index += work[jj];
                    for (kk = 0; kk < tup_dim; ++kk) {
                        new_range_values[kk][jj] = old_range_values[kk][index];
                    }
                }
                new_field.setSamples(new_range_values, false);
                new_range_data[ii] = new_field;
            }
        } else {
            for (ii = 0; ii < length; ++ii) {
                FieldImpl new_field = new FieldImpl(new_type, new_domain);
                for (int jj = 0; jj < work.length; ++jj) {
                    int index = 0;
                    index = ii * dim_product[factorIndex];
                    new_range_data[jj] = this.getSample(index += work[jj]);
                }
                new_field.setSamples(new_range_data, false, false);
                new_range_data[ii] = new_field;
            }
        }
        factor_field = new FieldImpl(new FunctionType(factor, new_type), factor_domain);
        factor_field.setSamples(new_range_data, copy, false);
        return factor_field;
    }

    public Field domainMultiply() throws VisADException, RemoteException {
        return this.domainMultiply(1, null);
    }

    public Field domainMultiply(CoordinateSystem resultCS) throws VisADException, RemoteException {
        return this.domainMultiply(1, resultCS);
    }

    public Field domainMultiply(int collapse_depth) throws VisADException, RemoteException {
        return this.domainMultiply(collapse_depth, null);
    }

    public Field domainMultiply(int collapse_depth, CoordinateSystem resultCS) throws VisADException, RemoteException {
        FieldImpl new_field;
        SampledSet new_set = null;
        int n_irregular = 0;
        int n_linear = 0;
        int new_domainDim = 0;
        int new_manifoldDim = 0;
        class Helper {
            int cnt = 0;
            int n_samples;
            int depth;
            int depth_max;
            boolean flat;
            MathType range_type;
            MathType new_range_type;
            SampledSet[] last_set;
            SampledSet[] fac_sets;
            Data[] collapse_array;

            public Helper(Data data, int col_depth) throws VisADException, RemoteException {
                MathType m_type = data.getType();
                this.depth = 0;
                this.flat = false;
                this.depth_max = this.checkType(m_type);
                if (this.depth_max == 0) {
                    throw new FieldException("MathType " + m_type.prettyString());
                }
                if (this.depth_max >= col_depth) {
                    this.depth_max = col_depth;
                }
                this.flat = false;
                for (int kk = 0; kk < this.depth_max; ++kk) {
                    if (!(m_type instanceof FunctionType)) continue;
                    m_type = ((FunctionType)m_type).getRange();
                }
                if (m_type instanceof FunctionType) {
                    this.flat = ((FunctionType)m_type).getFlat();
                    this.new_range_type = ((FunctionType)m_type).getRange();
                }
                this.last_set = new SampledSet[this.depth_max + 1];
                this.depth = 0;
                if (!this.setsEqual((Field)data)) {
                    throw new FieldException("sets not equal");
                }
                int length = 1;
                if (this.flat) {
                    for (int kk = 0; kk < this.depth_max; ++kk) {
                        length *= this.last_set[kk].getLength();
                    }
                } else {
                    for (int kk = 0; kk < this.depth_max + 1; ++kk) {
                        length *= this.last_set[kk].getLength();
                    }
                }
                this.collapse_array = new Data[length];
                this.depth = 0;
                this.collapse(data);
            }

            public SampledSet[] getSets() {
                int length = this.last_set.length;
                this.fac_sets = new SampledSet[length];
                for (int ii = 0; ii < length; ++ii) {
                    this.fac_sets[length - 1 - ii] = this.last_set[ii];
                }
                return this.fac_sets;
            }

            public Data[] getRangeArray() {
                return this.collapse_array;
            }

            public MathType getRangeType() {
                return this.new_range_type;
            }

            public int checkType(MathType m_type) throws VisADException, RemoteException {
                if (m_type instanceof FunctionType) {
                    if (((FunctionType)m_type).getFlat()) {
                        this.flat = true;
                        this.new_range_type = ((FunctionType)m_type).getRange();
                        return this.depth;
                    }
                    this.range_type = ((FunctionType)m_type).getRange();
                    ++this.depth;
                    return this.checkType(this.range_type);
                }
                this.new_range_type = m_type;
                return this.depth;
            }

            public void collapse(Data data) throws VisADException, RemoteException {
                if (this.depth == this.depth_max) {
                    if (this.flat) {
                        this.collapse_array[this.cnt++] = (FieldImpl)data;
                    } else {
                        for (int ii = 0; ii < ((FieldImpl)data).getLength(); ++ii) {
                            this.collapse_array[this.cnt++] = ((FieldImpl)data).getSample(ii);
                        }
                    }
                } else {
                    int n_samples = ((Field)data).getDomainSet().getLength();
                    for (int ii = 0; ii < n_samples; ++ii) {
                        ++this.depth;
                        this.collapse(((FieldImpl)data).getSample(ii));
                        --this.depth;
                    }
                }
            }

            public boolean setsEqual(Field field) throws VisADException, RemoteException {
                Set domainSet = field.getDomainSet();
                int n_samples = domainSet.getLength();
                if (this.depth == 0) {
                    this.last_set[this.depth] = (SampledSet)domainSet;
                }
                ++this.depth;
                if (this.last_set[this.depth] == null) {
                    this.last_set[this.depth] = (SampledSet)((Field)field.getSample(0)).getDomainSet();
                }
                for (int ii = 0; ii < n_samples; ++ii) {
                    Field range_data = (Field)field.getSample(ii);
                    Set range_set = range_data.getDomainSet();
                    if (!this.last_set[this.depth].equals(range_set)) {
                        return false;
                    }
                    if (this.depth == this.depth_max) continue;
                    if (!this.setsEqual(range_data)) {
                        return false;
                    }
                    --this.depth;
                }
                return true;
            }
        }
        Helper helper = new Helper(this, collapse_depth);
        SampledSet[] fac_sets = helper.getSets();
        int n_sets = fac_sets.length;
        Data[] new_range = helper.getRangeArray();
        MathType new_range_type = helper.getRangeType();
        SetType[] set_types = new SetType[n_sets];
        int new_length = 1;
        for (int kk = 0; kk < n_sets; ++kk) {
            new_length *= fac_sets[kk].getLength();
            new_domainDim += fac_sets[kk].getDimension();
            new_manifoldDim += fac_sets[kk].getManifoldDimension();
            set_types[kk] = (SetType)fac_sets[kk].getType();
            if (fac_sets[kk] instanceof IrregularSet) {
                ++n_irregular;
                continue;
            }
            if (!(fac_sets[kk] instanceof LinearSet)) continue;
            ++n_linear;
        }
        RealType[] r_types = new RealType[new_domainDim];
        int cnt = 0;
        boolean any_are_null = false;
        CoordinateSystem[] coord_sys = new CoordinateSystem[n_sets];
        for (int kk = 0; kk < n_sets; ++kk) {
            RealTupleType domain = set_types[kk].getDomain();
            CoordinateSystem cs = domain.getCoordinateSystem();
            if (cs == null) {
                any_are_null = true;
            }
            coord_sys[kk] = cs;
            for (int j = 0; j < domain.getDimension(); ++j) {
                r_types[cnt++] = (RealType)domain.getComponent(j);
            }
        }
        CoordinateSystem new_cs = resultCS;
        if (!any_are_null && new_cs == null) {
            new_cs = coord_sys[0];
            for (int kk = 0; kk < coord_sys.length - 1; ++kk) {
                new_cs = new CartesianProductCoordinateSystem(new_cs, coord_sys[kk + 1]);
            }
        }
        RealTupleType new_domain_type = new RealTupleType(r_types, new_cs, null);
        FunctionType new_function_type = new FunctionType(new_domain_type, new_range_type);
        if (n_irregular > 0) {
            new_set = new ProductSet(fac_sets);
        } else if (n_linear == n_sets) {
            Linear1DSet[] L1D_sets = new Linear1DSet[new_domainDim];
            cnt = 0;
            for (int kk = 0; kk < n_sets; ++kk) {
                for (int jj = 0; jj < fac_sets[kk].getDimension(); ++jj) {
                    L1D_sets[cnt++] = ((LinearSet)((Object)fac_sets[kk])).getLinear1DComponent(jj);
                }
            }
            new_set = new LinearNDSet((MathType)new_domain_type, L1D_sets);
        } else {
            int ii;
            float[][] new_samples = new float[new_domainDim][new_length];
            float[][] sub_samples = new float[new_domainDim][];
            Unit[] newUnits = new Unit[new_domainDim];
            ErrorEstimate[] newErrors = new ErrorEstimate[new_domainDim];
            int[][] manifoldLengths = new int[new_domainDim][];
            int[][] manifoldIndexes = new int[new_domainDim][];
            int[] new_lengths = new int[new_manifoldDim];
            cnt = 0;
            int cnt_m = 0;
            int manifoldDimension = 0;
            for (int kk = 0; kk < n_sets; ++kk) {
                SampledSet set = fac_sets[kk];
                float[][] samples = set.getSamples();
                int domainDim = set.getDimension();
                int sub_manifoldDim = ((Set)set).getManifoldDimension();
                int[] lengths = ((GriddedSet)set).getLengths();
                Unit[] units = set.getSetUnits();
                ErrorEstimate[] errors = set.getSetErrors();
                for (ii = 0; ii < domainDim; ++ii) {
                    sub_samples[cnt] = samples[ii];
                    manifoldLengths[cnt] = lengths;
                    manifoldIndexes[cnt] = new int[sub_manifoldDim];
                    for (int jj = 0; jj < sub_manifoldDim; ++jj) {
                        manifoldIndexes[cnt][jj] = jj + manifoldDimension;
                    }
                    newUnits[cnt] = units[ii];
                    newErrors[cnt] = errors[ii];
                    ++cnt;
                }
                for (ii = 0; ii < sub_manifoldDim; ++ii) {
                    new_lengths[cnt_m++] = lengths[ii];
                }
                manifoldDimension += sub_manifoldDim;
            }
            int[] indexes = new int[new_manifoldDim];
            for (int k = 0; k < new_length; ++k) {
                int k2 = k;
                for (int j = new_manifoldDim - 1; j >= 0; --j) {
                    int temp = 1;
                    for (int m = 0; m < j; ++m) {
                        temp *= new_lengths[m];
                    }
                    indexes[j] = k2 / temp;
                    k2 -= temp * indexes[j];
                }
                for (ii = 0; ii < new_domainDim; ++ii) {
                    int sub_index = 0;
                    for (int mm = manifoldIndexes[ii].length - 1; mm >= 0; --mm) {
                        int product = 1;
                        for (int nn = 0; nn < mm; ++nn) {
                            product *= manifoldLengths[ii][nn];
                        }
                        sub_index += (product *= indexes[manifoldIndexes[ii][mm]]);
                    }
                    new_samples[ii][k] = sub_samples[ii][sub_index];
                }
            }
            new_set = GriddedSet.create(new_domain_type, new_samples, new_lengths, null, newUnits, newErrors);
        }
        if (helper.flat) {
            new_field = new FlatField(new_function_type, new_set);
            int tup_dim = new_function_type.getFlatRange().getDimension();
            double[][] new_values = new double[tup_dim][new_length];
            cnt = 0;
            for (int ii = 0; ii < new_range.length; ++ii) {
                double[][] sub_range = ((FieldImpl)new_range[ii]).getValues(false);
                int len = sub_range[0].length;
                for (int jj = 0; jj < tup_dim; ++jj) {
                    System.arraycopy(sub_range[jj], 0, new_values[jj], cnt, len);
                }
                cnt += len;
            }
            ((FlatField)new_field).setSamples(new_values, false);
        } else {
            new_field = new FieldImpl(new_function_type, new_set);
            for (int ii = 0; ii < new_length; ++ii) {
                new_field.setSample(ii, new_range[ii]);
            }
        }
        return new_field;
    }

    public Data derivative(RealTuple location, RealType[] d_partial_s, MathType[] derivType_s, int error_mode) throws VisADException, RemoteException {
        int pp;
        boolean transform;
        int ii;
        int n_partials;
        Set domainSet = this.getDomainSet();
        int domainDim = domainSet.getDimension();
        int manifoldDimension = domainSet.getManifoldDimension();
        int n_samples = domainSet.getLength();
        CoordinateSystem d_coordsys = this.getDomainCoordinateSystem();
        RealTupleType d_reference = d_coordsys == null ? null : d_coordsys.getReference();
        Object m_type = null;
        Object m_types = null;
        Object r_type = null;
        Object r_types = null;
        Object t_type = null;
        boolean thisDomainFlag = true;
        if (manifoldDimension != domainDim) {
            throw new SetException("derivative: manifoldDimension must equal domain dimension");
        }
        error_mode = 202;
        int sampling_mode = 101;
        if (location != null) {
            thisDomainFlag = false;
        }
        RealTupleType domainType = ((FunctionType)this.Type).getDomain();
        RealType[] r_comps = domainType.getRealComponents();
        RealType[] r_compsRef = d_reference == null ? null : d_reference.getRealComponents();
        MathType RangeType = ((FunctionType)this.Type).getRange();
        if (d_partial_s == null) {
            n_partials = domainDim;
            d_partial_s = r_comps;
        } else {
            n_partials = d_partial_s.length;
            if (n_partials > domainDim) {
                throw new VisADException("derivative: too many d_partial components");
            }
        }
        int[] u_index = new int[n_partials];
        double[][] u_vectors = new double[n_partials][domainDim];
        int found = 0;
        int foundRef = 0;
        for (ii = 0; ii < n_partials; ++ii) {
            for (int jj = 0; jj < domainDim; ++jj) {
                u_vectors[ii][jj] = 0.0;
                if (r_comps[jj].equals(d_partial_s[ii])) {
                    u_index[ii] = jj;
                    u_vectors[ii][jj] = 1.0;
                    ++found;
                    continue;
                }
                if (d_reference == null || !r_compsRef[jj].equals(d_partial_s[ii])) continue;
                u_index[ii] = jj;
                u_vectors[jj][ii] = 1.0;
                ++foundRef;
            }
        }
        if (found == 0) {
            if (foundRef == 0) {
                throw new VisADException("derivative: d_partial_s not in domain or reference");
            }
            if (0 < foundRef && foundRef < n_partials) {
                throw new VisADException("derivative: d_partial_s must ALL be in function's domain or ALL in domain's reference");
            }
            transform = true;
        } else {
            if (0 < found && found < n_partials) {
                throw new VisADException("derivative: d_partial_s must ALL be in function's domain or ALL in domain's reference");
            }
            transform = false;
        }
        String[][] derivNames = null;
        MathType[] new_range = new MathType[n_partials];
        MathType[] new_types = new MathType[n_partials];
        Unit[] D_units = !transform ? domainSet.getSetUnits() : d_reference.getDefaultUnits();
        if (derivType_s == null) {
            for (ii = 0; ii < n_partials; ++ii) {
                MathType M_type = this.Type.cloneDerivative(d_partial_s[ii]);
                new_types[ii] = thisDomainFlag ? M_type : ((FunctionType)M_type).getRange();
            }
            derivType_s = new_types;
        } else {
            if (derivType_s.length != n_partials) {
                throw new VisADException("derivative: must be a single MathType for each domain RealType");
            }
            for (ii = 0; ii < n_partials; ++ii) {
                if (!(thisDomainFlag ? !this.Type.equalsExceptName(derivType_s[ii]) : !((FunctionType)this.Type).getRange().equalsExceptName(derivType_s[ii]))) continue;
                throw new TypeException("derivative: incompatible with function range");
            }
        }
        Object neighbors = null;
        Data[] p_derivatives = new Data[n_partials];
        ErrorEstimate[] domainErrors = domainSet.getSetErrors();
        Data[] new_fields = new FieldImpl[n_partials];
        Data[] rangeValues = null;
        for (pp = 0; pp < n_partials; ++pp) {
            new_fields[pp] = new FieldImpl((FunctionType)derivType_s[pp], domainSet);
        }
        if (this.isMissing()) {
            if (domainSet instanceof LinearSet && thisDomainFlag) {
                for (int kk = 0; kk < n_partials; ++kk) {
                    RangeType = ((FunctionType)derivType_s[kk]).getRange();
                    int m_index = u_index[kk];
                    neighbors = domainSet.getNeighbors(m_index);
                    float step = (float)((LinearSet)((Object)domainSet)).getLinear1DComponent(kk).getStep();
                    for (ii = 0; ii < n_samples; ++ii) {
                        int index;
                        int n_index;
                        float distance;
                        if (neighbors[ii][0] == -1) {
                            distance = step;
                            n_index = neighbors[ii][1];
                            index = ii;
                        } else if (neighbors[ii][1] == -1) {
                            distance = step;
                            n_index = ii;
                            index = neighbors[ii][0];
                        } else {
                            distance = 2.0f * step;
                            n_index = neighbors[ii][1];
                            index = neighbors[ii][0];
                        }
                        Data data_1 = this.getSample(n_index);
                        Data data_0 = this.getSample(index);
                        Real deltaDomain = new Real(d_partial_s[kk], distance, D_units[m_index]);
                        Data rangeDiff = data_1.binary(data_0, 2, sampling_mode, error_mode);
                        Data newRange = rangeDiff.binary(deltaDomain, 5, RangeType, sampling_mode, error_mode);
                        ((FieldImpl)new_fields[kk]).setSample(ii, newRange);
                    }
                }
            } else {
                int kk;
                int n_points;
                float[][] Samples;
                Object weights = null;
                if (thisDomainFlag) {
                    neighbors = new int[n_samples][];
                    weights = new float[n_samples][];
                    domainSet.getNeighbors((int[][])neighbors, (float[][])weights);
                    if (transform) {
                        Samples = domainSet.getSamples(true);
                        Samples = CoordinateSystem.transformCoordinates(d_reference, null, null, null, domainType, d_coordsys, null, null, Samples);
                    } else {
                        Samples = domainSet.getSamples(false);
                    }
                } else {
                    n_samples = 1;
                    float[][] org_Samples = domainSet.getSamples(false);
                    Field field = this.resample(new SingletonSet(location, null, null, null), 101, error_mode);
                    float[][] evalSamples = field.getDomainSet().getSamples(false);
                    neighbors = new int[n_samples][];
                    weights = new float[n_samples][];
                    ((SimpleSet)domainSet).valueToInterp(evalSamples, (int[][])neighbors, (float[][])weights);
                    n_points = neighbors[0].length;
                    int[][] new_neighbors = new int[n_samples][n_points];
                    Data[] new_rangeValues = new Data[n_points + 1];
                    float[][] new_Samples = new float[domainDim][n_points + 1];
                    for (ii = 0; ii < domainDim; ++ii) {
                        new_Samples[ii][0] = evalSamples[ii][0];
                    }
                    new_rangeValues[0] = field.getSample(0);
                    for (kk = 0; kk < n_points; ++kk) {
                        new_neighbors[0][kk] = kk + 1;
                        new_rangeValues[kk + 1] = this.getSample(neighbors[0][kk]);
                        for (ii = 0; ii < domainDim; ++ii) {
                            new_Samples[ii][kk + 1] = org_Samples[ii][neighbors[0][kk]];
                        }
                    }
                    neighbors = new_neighbors;
                    rangeValues = new_rangeValues;
                    Samples = new_Samples;
                    if (transform) {
                        Samples = CoordinateSystem.transformCoordinates(d_reference, null, null, null, domainType, d_coordsys, null, null, Samples);
                    }
                }
                for (ii = 0; ii < n_samples; ++ii) {
                    int dd;
                    n_points = neighbors[ii].length;
                    Data[] rangeDiff_s = new Data[n_points];
                    Data p_derivative = null;
                    double[][] uvecPoint = new double[n_points][domainDim];
                    Data data_0 = thisDomainFlag ? this.getSample(ii) : rangeValues[ii];
                    for (kk = 0; kk < n_points; ++kk) {
                        for (dd = 0; dd < domainDim; ++dd) {
                            uvecPoint[kk][dd] = Samples[dd][neighbors[ii][kk]] - Samples[dd][ii];
                        }
                        Data data_1 = thisDomainFlag ? this.getSample(neighbors[ii][kk]) : rangeValues[neighbors[ii][kk]];
                        rangeDiff_s[kk] = data_1.binary(data_0, 2, sampling_mode, error_mode);
                    }
                    boolean first = true;
                    for (pp = 0; pp < n_partials; ++pp) {
                        int m_index = u_index[pp];
                        RangeType = ((FunctionType)derivType_s[pp]).getRange();
                        float sum_weights = 0.0f;
                        for (kk = 0; kk < n_points; ++kk) {
                            float dotproduct = 0.0f;
                            for (dd = 0; dd < domainDim; ++dd) {
                                dotproduct = (float)((double)dotproduct + uvecPoint[kk][dd] * u_vectors[pp][dd]);
                            }
                            float inv_dotproduct = 1.0f / dotproduct;
                            if (Float.isInfinite(inv_dotproduct)) continue;
                            sum_weights += weights[ii][kk];
                            float factor = inv_dotproduct * weights[ii][kk];
                            rangeDiff_s[kk] = rangeDiff_s[kk].binary(new Real(factor), 4, sampling_mode, error_mode);
                            if (first) {
                                p_derivative = rangeDiff_s[kk];
                                first = false;
                                continue;
                            }
                            p_derivative = p_derivative.binary(rangeDiff_s[kk], 1, sampling_mode, error_mode);
                        }
                        Real real = new Real(d_partial_s[pp], sum_weights, D_units[m_index]);
                        p_derivative = p_derivative.binary(real, 5, RangeType, sampling_mode, error_mode);
                        ((FieldImpl)new_fields[pp]).setSample(ii, p_derivative);
                    }
                }
            }
        }
        if (n_partials == 1) {
            return new_fields[0];
        }
        return new Tuple(new_fields);
    }

    public Data derivative(int error_mode) throws VisADException, RemoteException {
        MathType[] derivType_s = null;
        RealType[] d_partial_s = null;
        return this.derivative(null, d_partial_s, derivType_s, error_mode);
    }

    public Data derivative(MathType[] derivType_s, int error_mode) throws VisADException, RemoteException {
        return this.derivative(null, null, derivType_s, error_mode);
    }

    public Function derivative(RealType d_partial, int error_mode) throws VisADException, RemoteException {
        MathType[] derivType_s = null;
        RealType[] d_partial_s = new RealType[]{d_partial};
        return (Function)this.derivative(null, d_partial_s, derivType_s, error_mode);
    }

    public Function derivative(RealType d_partial, MathType derivType, int error_mode) throws VisADException, RemoteException {
        MathType[] derivType_s = new MathType[1];
        RealType[] d_partial_s = new RealType[1];
        derivType_s[0] = derivType;
        d_partial_s[0] = d_partial;
        return (Function)this.derivative(null, d_partial_s, derivType_s, error_mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Field resample(Set set, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        float[][] error_values;
        int k;
        Object indices;
        boolean sampling_errors;
        Set domainSet = this.getDomainSet();
        if (domainSet.equals(set)) {
            return this;
        }
        MathType range_type = ((FunctionType)this.Type).getRange();
        RealTupleType domain_type = ((SetType)set.getType()).getDomain();
        FunctionType func_type = new FunctionType(domain_type, range_type);
        FieldImpl field = new FieldImpl(func_type, set);
        if (this.isMissing()) {
            return field;
        }
        int dim = domainSet.getDimension();
        if (dim != set.getDimension()) {
            throw new SetException("FieldImpl.resample: bad Set Dimension");
        }
        if (domainSet instanceof GriddedDoubleSet) {
            return this.resampleDouble(set, sampling_mode, error_mode);
        }
        CoordinateSystem coord_sys = set.getCoordinateSystem();
        Unit[] units = set.getSetUnits();
        ErrorEstimate[] errors = error_mode == 202 ? new ErrorEstimate[dim] : set.getSetErrors();
        int length = set.getLength();
        int[] wedge = set.getWedge();
        Data[] range = new Data[length];
        float[][] vals = set.indexToValue(wedge);
        ErrorEstimate[] errors_out = new ErrorEstimate[dim];
        float[][] oldvals = vals;
        try {
            vals = CoordinateSystem.transformCoordinates(((FunctionType)this.Type).getDomain(), this.getDomainCoordinateSystem(), this.getDomainUnits(), errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, errors, vals);
        }
        catch (UnitException ue) {
            throw new VisADException("Sampling set is not compatible with domain");
        }
        boolean coord_transform = vals != oldvals;
        boolean bl = sampling_errors = error_mode != 202;
        if (sampling_errors) {
            for (int i = 0; i < dim; ++i) {
                if (errors_out[i] != null) continue;
                sampling_errors = false;
            }
        }
        Data[] sampling_partials = new Data[dim];
        double[] means = new double[dim];
        Data[] Range2 = this.getRange();
        if (sampling_mode == 101 && domainSet instanceof SimpleSet) {
            indices = new int[length][];
            float[][] coefs = new float[length][];
            ((SimpleSet)domainSet).valueToInterp(vals, (int[][])indices, coefs);
            for (int i2 = 0; i2 < length; ++i2) {
                Data e;
                int j;
                int len;
                int n = len = indices[i2] == null ? 0 : ((int)indices[i2]).length;
                if (len > 0) {
                    Data r = null;
                    for (k = 0; k < len; ++k) {
                        Data RangeIK;
                        VisADRay visADRay = this.RangeLock;
                        synchronized (visADRay) {
                            RangeIK = Range2[indices[i2][k]];
                        }
                        if (RangeIK == null) {
                            r = null;
                            break;
                        }
                        r = r == null ? RangeIK.multiply(new Real(coefs[i2][k])) : r.add(RangeIK.multiply(new Real(coefs[i2][k])));
                    }
                    if (r != null) {
                        r = r.changeMathType(((FunctionType)this.Type).getRange());
                    }
                    range[wedge[i2]] = r;
                } else {
                    range[wedge[i2]] = ((FunctionType)this.Type).getRange().missingData();
                }
                if (!sampling_errors || range[wedge[i2]].isMissing()) continue;
                for (int j2 = 0; j2 < dim; ++j2) {
                    means[j2] = vals[j2][i2];
                }
                error_values = Set.doubleToFloat(ErrorEstimate.init_error_values(errors_out, means));
                int[][] error_indices2 = new int[2 * dim][];
                float[][] error_coefs = new float[2 * dim][];
                coefs = new float[2 * dim][];
                ((SimpleSet)domainSet).valueToInterp(error_values, error_indices2, error_coefs);
                for (int j3 = 0; j3 < dim; ++j3) {
                    Data RangeIK;
                    VisADRay visADRay;
                    int k2;
                    Data a = null;
                    Data b = null;
                    len = error_indices2[2 * j3].length;
                    if (len > 0) {
                        for (k2 = 0; k2 < len; ++k2) {
                            visADRay = this.RangeLock;
                            synchronized (visADRay) {
                                RangeIK = Range2[error_indices2[2 * j3][k2]];
                            }
                            if (RangeIK == null) {
                                a = null;
                                break;
                            }
                            a = a == null ? RangeIK.multiply(new Real(error_coefs[2 * j3][k2])) : a.add(RangeIK.multiply(new Real(error_coefs[2 * j3][k2])));
                        }
                    }
                    if ((len = error_indices2[2 * j3 + 1].length) > 0) {
                        for (k2 = 0; k2 < len; ++k2) {
                            visADRay = this.RangeLock;
                            synchronized (visADRay) {
                                RangeIK = Range2[error_indices2[2 * j3 + 1][k2]];
                            }
                            if (RangeIK == null) {
                                b = null;
                                break;
                            }
                            b = b == null ? RangeIK.multiply(new Real(error_coefs[2 * j3 + 1][k2])) : b.add(RangeIK.multiply(new Real(error_coefs[2 * j3 + 1][k2])));
                        }
                    }
                    sampling_partials[j3] = a == null || b == null ? null : b.subtract(a).abs();
                }
                Data error = null;
                if (error_mode == 200) {
                    for (j = 0; j < dim; ++j) {
                        e = sampling_partials[j].multiply(sampling_partials[j]);
                        error = error == null ? e : error.add(e);
                    }
                    error = error.sqrt();
                } else {
                    for (j = 0; j < dim; ++j) {
                        e = sampling_partials[j];
                        error = error == null ? e : error.add(e);
                    }
                }
                range[wedge[i2]] = range[wedge[i2]].adjustSamplingError(error, error_mode);
            }
        } else {
            indices = domainSet.valueToIndex(vals);
            for (int i = 0; i < length; ++i) {
                Data e;
                int j;
                VisADRay i2 = this.RangeLock;
                synchronized (i2) {
                    range[wedge[i]] = indices[i] >= 0 && Range2[indices[i]] != null ? Range2[indices[i]] : ((FunctionType)this.Type).getRange().missingData();
                }
                if (!sampling_errors || range[wedge[i]].isMissing()) continue;
                for (int j4 = 0; j4 < dim; ++j4) {
                    means[j4] = vals[j4][i];
                }
                error_values = Set.doubleToFloat(ErrorEstimate.init_error_values(errors_out, means));
                int[] error_indices = domainSet.valueToIndex(error_values);
                for (int j5 = 0; j5 < dim; ++j5) {
                    VisADRay error_indices2 = this.RangeLock;
                    synchronized (error_indices2) {
                        sampling_partials[j5] = error_indices[2 * j5] < 0 || Range2[error_indices[2 * j5]] == null || error_indices[2 * j5 + 1] < 0 || Range2[error_indices[2 * j5 + 1]] == null ? null : Range2[error_indices[2 * j5 + 1]].subtract(Range2[error_indices[2 * j5]]).abs();
                        continue;
                    }
                }
                Data error = null;
                if (error_mode == 200) {
                    for (j = 0; j < dim; ++j) {
                        e = sampling_partials[j].multiply(sampling_partials[j]);
                        error = error == null ? e : error.add(e);
                    }
                    error = error.sqrt();
                } else {
                    for (j = 0; j < dim; ++j) {
                        e = sampling_partials[j];
                        error = error == null ? e : error.add(e);
                    }
                }
                range[wedge[i]] = range[wedge[i]].adjustSamplingError(error, error_mode);
            }
        }
        if (coord_transform) {
            MathType RangeType = ((FunctionType)this.Type).getRange();
            if (RangeType instanceof RealVectorType) {
                int n = vals.length;
                float[][] inloc = new float[n][1];
                float[][] outloc = new float[n][1];
                for (int i = 0; i < length; ++i) {
                    for (k = 0; k < n; ++k) {
                        inloc[k][0] = oldvals[k][i];
                    }
                    for (k = 0; k < n; ++k) {
                        outloc[k][0] = vals[k][i];
                    }
                    range[i] = ((RealVectorType)RangeType).transformVectors(((FunctionType)this.Type).getDomain(), this.getDomainCoordinateSystem(), this.getDomainUnits(), errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, ((RealTuple)range[i]).getCoordinateSystem(), inloc, outloc, (RealTuple)range[i]);
                }
            } else if (RangeType instanceof TupleType && !(RangeType instanceof RealTupleType)) {
                int m = ((TupleType)RangeType).getDimension();
                boolean any_vector = false;
                for (int j = 0; j < m; ++j) {
                    if (!(((TupleType)RangeType).getComponent(j) instanceof RealVectorType)) continue;
                    any_vector = true;
                }
                if (any_vector) {
                    int n = vals.length;
                    float[][] inloc = new float[n][1];
                    float[][] outloc = new float[n][1];
                    Data[] datums = new Data[m];
                    for (int i = 0; i < length; ++i) {
                        int k3;
                        for (k3 = 0; k3 < n; ++k3) {
                            inloc[k3][0] = oldvals[k3][i];
                        }
                        for (k3 = 0; k3 < n; ++k3) {
                            outloc[k3][0] = vals[k3][i];
                        }
                        for (int j = 0; j < m; ++j) {
                            MathType comp_type = ((TupleType)RangeType).getComponent(j);
                            if (comp_type instanceof RealVectorType) {
                                RealTuple component = (RealTuple)((TupleIface)range[i]).getComponent(j);
                                datums[j] = ((RealVectorType)comp_type).transformVectors(((FunctionType)this.Type).getDomain(), this.getDomainCoordinateSystem(), this.getDomainUnits(), errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, component.getCoordinateSystem(), inloc, outloc, component);
                                continue;
                            }
                            datums[j] = ((TupleIface)range[i]).getComponent(j);
                        }
                        range[i] = new Tuple(datums);
                    }
                }
            }
        }
        field.setSamples(range, false, false);
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Field resampleDouble(Set set, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        double[][] error_values;
        int k;
        Object indices;
        boolean sampling_errors;
        Set domainSet = this.getDomainSet();
        if (domainSet.equals(set)) {
            return this;
        }
        MathType range_type = ((FunctionType)this.Type).getRange();
        RealTupleType domain_type = ((SetType)set.getType()).getDomain();
        FunctionType func_type = new FunctionType(domain_type, range_type);
        FieldImpl field = new FieldImpl(func_type, set);
        if (this.isMissing()) {
            return field;
        }
        int dim = domainSet.getDimension();
        if (dim != set.getDimension()) {
            throw new SetException("FieldImpl.resample: bad Set Dimension");
        }
        if (!(domainSet instanceof GriddedDoubleSet)) {
            return this.resample(set, sampling_mode, error_mode);
        }
        CoordinateSystem coord_sys = set.getCoordinateSystem();
        Unit[] units = set.getSetUnits();
        ErrorEstimate[] errors = error_mode == 202 ? new ErrorEstimate[dim] : set.getSetErrors();
        int length = set.getLength();
        int[] wedge = set.getWedge();
        Data[] range = new Data[length];
        double[][] vals = set.indexToDouble(wedge);
        ErrorEstimate[] errors_out = new ErrorEstimate[dim];
        double[][] oldvals = vals;
        try {
            vals = CoordinateSystem.transformCoordinates(((FunctionType)this.Type).getDomain(), this.getDomainCoordinateSystem(), this.getDomainUnits(), errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, errors, vals);
        }
        catch (UnitException ue) {
            throw new VisADException("Sampling set is not compatible with domain");
        }
        boolean coord_transform = vals != oldvals;
        boolean bl = sampling_errors = error_mode != 202;
        if (sampling_errors) {
            for (int i = 0; i < dim; ++i) {
                if (errors_out[i] != null) continue;
                sampling_errors = false;
            }
        }
        Data[] sampling_partials = new Data[dim];
        double[] means = new double[dim];
        Data[] Range2 = this.getRange();
        if (sampling_mode == 101) {
            indices = new int[length][];
            double[][] coefs = new double[length][];
            ((GriddedDoubleSet)((Object)domainSet)).doubleToInterp(vals, (int[][])indices, coefs);
            for (int i2 = 0; i2 < length; ++i2) {
                Data e;
                int j;
                int len;
                int n = len = indices[i2] == null ? 0 : indices[i2].length;
                if (len > 0) {
                    Data r = null;
                    for (k = 0; k < len; ++k) {
                        Data RangeIK;
                        VisADRay visADRay = this.RangeLock;
                        synchronized (visADRay) {
                            RangeIK = Range2[indices[i2][k]];
                        }
                        if (RangeIK == null) {
                            r = null;
                            break;
                        }
                        r = r == null ? RangeIK.multiply(new Real(coefs[i2][k])) : r.add(RangeIK.multiply(new Real(coefs[i2][k])));
                    }
                    if (r != null) {
                        r = r.changeMathType(((FunctionType)this.Type).getRange());
                    }
                    range[wedge[i2]] = r;
                } else {
                    range[wedge[i2]] = ((FunctionType)this.Type).getRange().missingData();
                }
                if (!sampling_errors || range[wedge[i2]].isMissing()) continue;
                for (int j2 = 0; j2 < dim; ++j2) {
                    means[j2] = vals[j2][i2];
                }
                error_values = ErrorEstimate.init_error_values(errors_out, means);
                int[][] error_indices2 = new int[2 * dim][];
                double[][] error_coefs = new double[2 * dim][];
                coefs = new double[2 * dim][];
                ((GriddedDoubleSet)((Object)domainSet)).doubleToInterp(error_values, error_indices2, error_coefs);
                for (int j3 = 0; j3 < dim; ++j3) {
                    Data RangeIK;
                    VisADRay visADRay;
                    int k2;
                    Data a = null;
                    Data b = null;
                    len = error_indices2[2 * j3].length;
                    if (len > 0) {
                        for (k2 = 0; k2 < len; ++k2) {
                            visADRay = this.RangeLock;
                            synchronized (visADRay) {
                                RangeIK = Range2[error_indices2[2 * j3][k2]];
                            }
                            if (RangeIK == null) {
                                a = null;
                                break;
                            }
                            a = a == null ? RangeIK.multiply(new Real(error_coefs[2 * j3][k2])) : a.add(RangeIK.multiply(new Real(error_coefs[2 * j3][k2])));
                        }
                    }
                    if ((len = error_indices2[2 * j3 + 1].length) > 0) {
                        for (k2 = 0; k2 < len; ++k2) {
                            visADRay = this.RangeLock;
                            synchronized (visADRay) {
                                RangeIK = Range2[error_indices2[2 * j3 + 1][k2]];
                            }
                            if (RangeIK == null) {
                                b = null;
                                break;
                            }
                            b = b == null ? RangeIK.multiply(new Real(error_coefs[2 * j3 + 1][k2])) : b.add(RangeIK.multiply(new Real(error_coefs[2 * j3 + 1][k2])));
                        }
                    }
                    sampling_partials[j3] = a == null || b == null ? null : b.subtract(a).abs();
                }
                Data error = null;
                if (error_mode == 200) {
                    for (j = 0; j < dim; ++j) {
                        e = sampling_partials[j].multiply(sampling_partials[j]);
                        error = error == null ? e : error.add(e);
                    }
                    error = error.sqrt();
                } else {
                    for (j = 0; j < dim; ++j) {
                        e = sampling_partials[j];
                        error = error == null ? e : error.add(e);
                    }
                }
                range[wedge[i2]] = range[wedge[i2]].adjustSamplingError(error, error_mode);
            }
        } else {
            indices = domainSet.doubleToIndex(vals);
            for (int i = 0; i < length; ++i) {
                Data e;
                int j;
                VisADRay i2 = this.RangeLock;
                synchronized (i2) {
                    range[wedge[i]] = indices[i] >= 0 && Range2[indices[i]] != null ? Range2[indices[i]] : ((FunctionType)this.Type).getRange().missingData();
                }
                if (!sampling_errors || range[wedge[i]].isMissing()) continue;
                for (int j4 = 0; j4 < dim; ++j4) {
                    means[j4] = vals[j4][i];
                }
                error_values = ErrorEstimate.init_error_values(errors_out, means);
                int[] error_indices = domainSet.doubleToIndex(error_values);
                for (int j5 = 0; j5 < dim; ++j5) {
                    VisADRay error_indices2 = this.RangeLock;
                    synchronized (error_indices2) {
                        sampling_partials[j5] = error_indices[2 * j5] < 0 || Range2[error_indices[2 * j5]] == null || error_indices[2 * j5 + 1] < 0 || Range2[error_indices[2 * j5 + 1]] == null ? null : Range2[error_indices[2 * j5 + 1]].subtract(Range2[error_indices[2 * j5]]).abs();
                        continue;
                    }
                }
                Data error = null;
                if (error_mode == 200) {
                    for (j = 0; j < dim; ++j) {
                        e = sampling_partials[j].multiply(sampling_partials[j]);
                        error = error == null ? e : error.add(e);
                    }
                    error = error.sqrt();
                } else {
                    for (j = 0; j < dim; ++j) {
                        e = sampling_partials[j];
                        error = error == null ? e : error.add(e);
                    }
                }
                range[wedge[i]] = range[wedge[i]].adjustSamplingError(error, error_mode);
            }
        }
        if (coord_transform) {
            MathType RangeType = ((FunctionType)this.Type).getRange();
            if (RangeType instanceof RealVectorType) {
                int n = vals.length;
                double[][] inloc = new double[n][1];
                double[][] outloc = new double[n][1];
                for (int i = 0; i < length; ++i) {
                    for (k = 0; k < n; ++k) {
                        inloc[k][0] = oldvals[k][i];
                    }
                    for (k = 0; k < n; ++k) {
                        outloc[k][0] = vals[k][i];
                    }
                    range[i] = ((RealVectorType)RangeType).transformVectors(((FunctionType)this.Type).getDomain(), this.getDomainCoordinateSystem(), this.getDomainUnits(), errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, ((RealTuple)range[i]).getCoordinateSystem(), inloc, outloc, (RealTuple)range[i]);
                }
            } else if (RangeType instanceof TupleType && !(RangeType instanceof RealTupleType)) {
                int m = ((TupleType)RangeType).getDimension();
                boolean any_vector = false;
                for (int j = 0; j < m; ++j) {
                    if (!(((TupleType)RangeType).getComponent(j) instanceof RealVectorType)) continue;
                    any_vector = true;
                }
                if (any_vector) {
                    int n = vals.length;
                    double[][] inloc = new double[n][1];
                    double[][] outloc = new double[n][1];
                    Data[] datums = new Data[m];
                    for (int i = 0; i < length; ++i) {
                        int k3;
                        for (k3 = 0; k3 < n; ++k3) {
                            inloc[k3][0] = oldvals[k3][i];
                        }
                        for (k3 = 0; k3 < n; ++k3) {
                            outloc[k3][0] = vals[k3][i];
                        }
                        for (int j = 0; j < m; ++j) {
                            MathType comp_type = ((TupleType)RangeType).getComponent(j);
                            if (comp_type instanceof RealVectorType) {
                                RealTuple component = (RealTuple)((TupleIface)range[i]).getComponent(j);
                                datums[j] = ((RealVectorType)comp_type).transformVectors(((FunctionType)this.Type).getDomain(), this.getDomainCoordinateSystem(), this.getDomainUnits(), errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, component.getCoordinateSystem(), inloc, outloc, component);
                                continue;
                            }
                            datums[j] = ((TupleIface)range[i]).getComponent(j);
                        }
                        range[i] = new Tuple(datums);
                    }
                }
            }
        }
        field.setSamples(range, false, false);
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException, RemoteException {
        if (this.isMissing()) {
            return shadow;
        }
        ShadowRealTupleType domain_type = ((ShadowFunctionType)type).getDomain();
        int n = domain_type.getDimension();
        double[][] ranges = new double[2][n];
        shadow = this.getDomainSet().computeRanges(domain_type, shadow, ranges, true);
        ShadowType rtype = ((ShadowFunctionType)type).getRange();
        if (this.MyRange != null) {
            for (int i = 0; i < this.MyRange.length; ++i) {
                VisADRay visADRay = this.RangeLock;
                synchronized (visADRay) {
                    if (this.MyRange[i] != null) {
                        shadow = this.MyRange[i].computeRanges(rtype, shadow);
                    }
                    continue;
                }
            }
        }
        return shadow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data adjustSamplingError(Data error, int error_mode) throws VisADException, RemoteException {
        if (this.isMissing() || error == null || error.isMissing()) {
            return this;
        }
        FieldImpl field = new FieldImpl((FunctionType)this.Type, this.getDomainSet());
        if (this.isMissing()) {
            return field;
        }
        Field new_error = ((Field)error).resample(this.getDomainSet(), 100, 202);
        Data[] range = new Data[this.getLength()];
        for (int i = 0; i < this.getLength(); ++i) {
            VisADRay visADRay = this.RangeLock;
            synchronized (visADRay) {
                range[i] = this.MyRange != null && this.MyRange[i] != null ? this.MyRange[i].adjustSamplingError(new_error.getSample(i), error_mode) : null;
                continue;
            }
        }
        field.setSamples(range, true);
        return field;
    }

    public boolean isFlatField() {
        return false;
    }

    public int __len__() throws VisADException, RemoteException {
        return this.getLength();
    }

    public Data __getitem__(int index) throws VisADException, RemoteException {
        return this.getSample(index);
    }

    public void __setitem__(int index, Data data) throws VisADException, RemoteException {
        this.setSample(index, data);
    }

    public void __setitem__(int index, double data) throws VisADException, RemoteException {
        RealType real = null;
        boolean tuple = false;
        MathType range = ((FunctionType)this.getType()).getRange();
        if (range instanceof RealType) {
            real = (RealType)range;
        } else if (range instanceof RealTupleType && ((RealTupleType)range).getDimension() == 1) {
            real = (RealType)((RealTupleType)range).getComponent(0);
            tuple = true;
        }
        if (real != null) {
            Real r = new Real(real, data);
            if (tuple) {
                this.__setitem__(index, new RealTuple(new Real[]{r}));
            } else {
                this.__setitem__(index, r);
            }
        } else {
            System.out.println("FieldImpl.__setitem__ bad type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        FieldImpl clone = (FieldImpl)super.clone();
        VisADRay visADRay = this.RangeLock;
        synchronized (visADRay) {
            if (this.MyRange != null) {
                clone.MyRange = new Data[this.MyRange.length];
                for (int i = 0; i < this.MyRange.length; ++i) {
                    if (this.MyRange[i] == null) continue;
                    try {
                        clone.MyRange[i] = (Data)this.MyRange[i].dataClone();
                        continue;
                    }
                    catch (RemoteException ex) {
                        throw new RuntimeException(ex.toString());
                    }
                }
            }
        }
        return clone;
    }

    public String longString(String pre) throws VisADException, RemoteException {
        StringBuffer s = new StringBuffer(pre + "FieldImpl\n" + pre + "  Type: " + this.Type.toString() + "\n");
        Set domainSet = this.getDomainSet();
        if (domainSet != null) {
            s.append(pre + "  DomainSet:\n" + domainSet.longString(pre + "    "));
        } else {
            s.append(pre + "  DomainSet: undefined\n");
        }
        if (this.isMissing()) {
            s.append("  missing\n");
            return s.toString();
        }
        if (this.MyRange != null) {
            for (int i = 0; i < this.getLength(); ++i) {
                s.append(pre + "  Range value " + i + ":\n" + (this.MyRange[i] == null ? pre + "missing\n" : this.MyRange[i].longString(pre + "    ")));
            }
        }
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FieldImpl)) {
            return false;
        }
        FieldImpl fi = (FieldImpl)obj;
        if (!this.getType().equals(fi.getType())) {
            return false;
        }
        if (this.getLength() != fi.getLength()) {
            return false;
        }
        if (this.MissingFlag != fi.MissingFlag) {
            return false;
        }
        Set domainSet = this.getDomainSet();
        return !(domainSet == null || fi.getDomainSet() == null ? domainSet != null || fi.getDomainSet() != null : !domainSet.equals(fi.getDomainSet()));
    }

    public Enumeration domainEnumeration() throws VisADException, RemoteException {
        return new FieldEnumerator(this);
    }
}

