/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.Real;
import visad.ScalarMap;
import visad.VisADException;
import visad.util.Util;

public class ConstantMap
extends ScalarMap {
    private double Constant;
    private static boolean allowMultipleUseKludge = false;

    public ConstantMap(double constant, DisplayRealType display_scalar) throws VisADException {
        super(null, display_scalar, false);
        if (Double.isNaN(constant) || Double.isInfinite(constant)) {
            throw new DisplayException("ConstantMap: constant is missing (NaN) or infinity");
        }
        if (display_scalar.equals(Display.Animation) || display_scalar.equals(Display.SelectValue) || display_scalar.equals(Display.SelectRange) || display_scalar.equals(Display.IsoContour) || display_scalar.equals(Display.Text)) {
            throw new DisplayException("ConstantMap: illegal for " + display_scalar);
        }
        if (this.isScaled && !display_scalar.equals(Display.XAxis) && !display_scalar.equals(Display.YAxis) && !display_scalar.equals(Display.ZAxis) && (constant < this.displayRange[0] || constant > this.displayRange[1])) {
            throw new DisplayException("ConstantMap: constant is out of range");
        }
        this.Constant = constant;
    }

    public ConstantMap(Real constant, DisplayRealType display_scalar) throws VisADException {
        this(constant.getValue(), display_scalar);
    }

    public static void setAllowMultipleUseKludge(boolean k) {
        allowMultipleUseKludge = k;
    }

    public static boolean getAllowMultipleUseKludge() {
        return allowMultipleUseKludge;
    }

    void setControl() throws VisADException, RemoteException {
    }

    public double getConstant() {
        return this.Constant;
    }

    public boolean equals(Object o) {
        ConstantMap cm;
        boolean equals = !(o instanceof ConstantMap) ? false : this == (cm = (ConstantMap)o) || this.compareTo(cm) == 0;
        return equals;
    }

    public int compareTo(Object obj) {
        return obj instanceof ConstantMap ? this.compareTo((ConstantMap)obj) : this.compareTo((ScalarMap)obj);
    }

    protected int compareTo(ConstantMap that) {
        int comp = this.getDisplayScalar().compareTo(that.getDisplayScalar());
        if (comp == 0) {
            comp = Util.isApproximatelyEqual(this.Constant, that.Constant) ? 0 : (this.Constant - that.Constant < 0.0 ? -1 : 1);
        }
        return comp;
    }

    protected int compareTo(ScalarMap that) {
        return -1;
    }

    public Object clone() {
        try {
            ConstantMap cm = new ConstantMap(this.Constant, this.getDisplayScalar());
            this.copy(cm);
            return cm;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(String pre) {
        return pre + "ConstantMap: " + this.Constant + " -> " + this.getDisplayScalar().toString() + "\n";
    }

    void setAspectCartesian(double[] aspect) throws VisADException, RemoteException {
    }
}

