/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import thredds.ui.BAMutil;
import thredds.ui.IndependentWindow;
import thredds.ui.ProgressMonitorTask;
import thredds.ui.TextHistoryPane;
import ucar.ma2.Array;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Variable;
import ucar.nc2.dt.image.ImageArrayAdapter;
import ucar.nc2.ui.StopButton;
import ucar.nc2.ui.image.ImageViewPanel;
import ucar.nc2.util.CancelTask;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.ComboBox;

public class NCdumpPane
extends TextHistoryPane {
    private static final String ImageViewer_WindowSize = "ImageViewer_WindowSize";
    private PreferencesExt prefs;
    private ComboBox cb;
    private CommonTask task;
    private StopButton stopButton;
    private NetcdfFile ds;
    private IndependentWindow imageWindow = null;
    private ImageViewPanel imageView = null;

    public NCdumpPane(PreferencesExt prefs) {
        super(true);
        this.prefs = prefs;
        this.cb = new ComboBox(prefs);
        JButton getButton = new JButton("NCdump");
        getButton.setToolTipText("show selected data values");
        getButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NCdumpPane.this.ncdump((String)NCdumpPane.this.cb.getSelectedItem());
            }
        });
        JButton imageButton = new JButton("Image");
        imageButton.setToolTipText("view selected data as Image");
        imageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NCdumpPane.this.showImage((String)NCdumpPane.this.cb.getSelectedItem());
            }
        });
        this.stopButton = new StopButton("stop NCdump");
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NCdumpPane.this.ta.setText(((NCdumpPane)NCdumpPane.this).task.v.toString());
                NCdumpPane.this.ta.append("\n data:\n");
                NCdumpPane.this.ta.append(((NCdumpPane)NCdumpPane.this).task.contents);
                if (e.getActionCommand().equals("success")) {
                    NCdumpPane.this.cb.setSelectedItem(((NCdumpPane)NCdumpPane.this).task.command);
                }
            }
        });
        JPanel buttPanel = new JPanel(new FlowLayout(0, 5, 0));
        buttPanel.add(getButton);
        buttPanel.add(imageButton);
        buttPanel.add(this.stopButton);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel("Variable:"), "West");
        topPanel.add((Component)this.cb, "Center");
        topPanel.add((Component)buttPanel, "East");
        this.add((Component)topPanel, "North");
    }

    public void setContext(NetcdfFile ds, String command) {
        this.ds = ds;
        this.cb.addItem(command);
    }

    private void ncdump(String command) {
        if (this.ds == null) {
            return;
        }
        if (command == null) {
            return;
        }
        this.task = new NCdumpTask(command);
        if (this.task.v != null) {
            this.stopButton.startProgressMonitorTask(this.task);
        }
    }

    private void showImage(String command) {
        if (this.ds == null) {
            return;
        }
        if (command == null) {
            return;
        }
        if (this.imageWindow == null) {
            this.makeImageViewer();
        }
        this.task = new GetContentsTask(command);
        if (this.task.v != null) {
            this.stopButton.startProgressMonitorTask(this.task);
        }
    }

    private void makeImageViewer() {
        this.imageWindow = new IndependentWindow("Image Viewer", BAMutil.getImage("ImageData"));
        this.imageView = new ImageViewPanel(null);
        this.imageWindow.setComponent(new JScrollPane(this.imageView));
        Rectangle b = (Rectangle)this.prefs.getBean(ImageViewer_WindowSize, new Rectangle(99, 33, 700, 900));
        this.imageWindow.setBounds(b);
    }

    public void save() {
        this.cb.save();
        if (this.imageWindow != null) {
            this.prefs.putBeanObject(ImageViewer_WindowSize, this.imageWindow.getBounds());
        }
    }

    public void clear() {
        this.ta.setText(null);
    }

    public String getText() {
        return this.ta.getText();
    }

    public void gotoTop() {
        this.ta.setCaretPosition(0);
    }

    public void setText(String text) {
        this.ta.setText(text);
    }

    private class NCdumpTask
    extends CommonTask {
        NCdumpTask(String command) {
            super(command);
        }

        public void run() {
            try {
                this.data = NCdumpPane.this.ds.readSection(this.command);
                this.contents = NCdumpW.printArray(this.data, null, this);
            }
            catch (Exception e) {
                e.printStackTrace();
                ByteArrayOutputStream bos = new ByteArrayOutputStream(100000);
                e.printStackTrace(new PrintStream(bos));
                this.contents = bos.toString();
                this.setError(e.getMessage());
                this.done = true;
                return;
            }
            if (this.cancel) {
                this.contents = "\n***Cancelled by User";
            }
            this.success = !this.cancel;
            this.done = true;
        }
    }

    private class GetContentsTask
    extends CommonTask {
        GetContentsTask(String command) {
            super(command);
        }

        public void run() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(100000);
            PrintStream ps = new PrintStream(bos);
            try {
                this.data = NCdumpPane.this.ds.readSection(this.command);
                if (this.data != null) {
                    NCdumpPane.this.imageView.setImage(ImageArrayAdapter.makeGrayscaleImage(((NCdumpPane)NCdumpPane.this).task.data));
                    NCdumpPane.this.imageWindow.show();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.contents = bos.toString();
                this.setError(e.getMessage());
                this.done = true;
                return;
            }
            if (this.cancel) {
                ps.println("\n***Cancelled by User");
            }
            this.contents = bos.toString();
            this.success = !this.cancel;
            this.done = true;
        }
    }

    private abstract class CommonTask
    extends ProgressMonitorTask
    implements CancelTask {
        String contents;
        String command;
        Variable v = null;
        Array data;

        CommonTask(String command) {
            this.command = command;
            try {
                ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection(NCdumpPane.this.ds, command);
                while (cer != null) {
                    this.v = cer.v;
                    cer = cer.child;
                }
            }
            catch (Exception e) {
                NCdumpPane.this.ta.setText(e.getMessage());
            }
        }
    }
}

