/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.thredds;

import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ThreddsMetadata;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.PointObsDataset;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class MetadataExtractor {
    private static Logger logger = LoggerFactory.getLogger(MetadataExtractor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static ThreddsMetadata.GeospatialCoverage extractGeospatial(InvDatasetImpl threddsDataset) throws IOException {
        block16: {
            ThreddsDataFactory.Result result;
            block15: {
                ThreddsMetadata.GeospatialCoverage geospatialCoverage;
                ThreddsMetadata.GeospatialCoverage geospatialCoverage2;
                ThreddsMetadata.GeospatialCoverage geospatialCoverage3;
                result = null;
                result = new ThreddsDataFactory().openFeatureDataset(threddsDataset, null);
                if (!result.fatalError) break block17;
                System.out.println(" openDatatype errs=" + result.errLog);
                ThreddsMetadata.GeospatialCoverage geospatialCoverage4 = null;
                Object var7_6 = null;
                try {
                    if (result != null && result.featureDataset != null) {
                        result.featureDataset.close();
                    }
                }
                catch (IOException ioe) {
                    logger.error("Closing dataset " + result.featureDataset, ioe);
                }
                {
                    block17: {
                        return geospatialCoverage4;
                    }
                    if (result.featureType != FeatureType.GRID) break block18;
                    System.out.println(" GRID=" + result.location);
                    GridDataset gridDataset = (GridDataset)((Object)result.featureDataset);
                    geospatialCoverage3 = MetadataExtractor.extractGeospatial(gridDataset);
                }
                Object var7_7 = null;
                try {
                    if (result != null && result.featureDataset != null) {
                        result.featureDataset.close();
                    }
                }
                catch (IOException ioe) {
                    logger.error("Closing dataset " + result.featureDataset, ioe);
                }
                {
                    block18: {
                        return geospatialCoverage3;
                    }
                    if (result.featureType != FeatureType.POINT) break block19;
                    PointObsDataset pobsDataset = (PointObsDataset)((Object)result.featureDataset);
                    LatLonRect llbb = pobsDataset.getBoundingBox();
                    if (null == llbb) break block15;
                    ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage();
                    gc.setBoundingBox(llbb);
                    geospatialCoverage2 = gc;
                }
                Object var7_8 = null;
                try {
                    if (result != null && result.featureDataset != null) {
                        result.featureDataset.close();
                    }
                }
                catch (IOException ioe) {
                    logger.error("Closing dataset " + result.featureDataset, ioe);
                }
                {
                    StationObsDataset sobsDataset;
                    LatLonRect llbb;
                    block19: {
                        return geospatialCoverage2;
                    }
                    if (result.featureType != FeatureType.STATION || null == (llbb = (sobsDataset = (StationObsDataset)((Object)result.featureDataset)).getBoundingBox())) break block15;
                    ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage();
                    gc.setBoundingBox(llbb);
                    geospatialCoverage = gc;
                }
                Object var7_9 = null;
                try {
                    if (result != null && result.featureDataset != null) {
                        result.featureDataset.close();
                    }
                }
                catch (IOException ioe) {
                    logger.error("Closing dataset " + result.featureDataset, ioe);
                }
                return geospatialCoverage;
            }
            Object var7_10 = null;
            try {
                if (result != null && result.featureDataset != null) {
                    result.featureDataset.close();
                }
                break block16;
            }
            catch (IOException ioe) {
                logger.error("Closing dataset " + result.featureDataset, ioe);
            }
            break block16;
            catch (Throwable throwable) {
                Object var7_11 = null;
                try {
                    if (result != null && result.featureDataset != null) {
                        result.featureDataset.close();
                    }
                }
                catch (IOException ioe) {
                    logger.error("Closing dataset " + result.featureDataset, ioe);
                }
                throw throwable;
            }
        }
        return null;
    }

    public static ThreddsMetadata.GeospatialCoverage extractGeospatial(GridDataset gridDataset) {
        ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage();
        LatLonRect llbb = null;
        CoordinateAxis1D vaxis = null;
        for (GridDataset.Gridset gridset : gridDataset.getGridsets()) {
            GridCoordSystem gsys = gridset.getGeoCoordSystem();
            if (llbb == null) {
                llbb = gsys.getLatLonBoundingBox();
            }
            CoordinateAxis1D vaxis2 = gsys.getVerticalAxis();
            if (vaxis == null) {
                vaxis = vaxis2;
                continue;
            }
            if (vaxis2 == null || vaxis2.getSize() <= vaxis.getSize()) continue;
            vaxis = vaxis2;
        }
        gc.setBoundingBox(llbb);
        if (vaxis != null) {
            gc.setVertical(vaxis);
        }
        return gc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreddsMetadata.Variables extractVariables(InvDatasetImpl threddsDataset) throws IOException {
        ThreddsDataFactory.Result result;
        block21: {
            ThreddsMetadata.Variables variables;
            block19: {
                block17: {
                    result = null;
                    result = new ThreddsDataFactory().openFeatureDataset(threddsDataset, null);
                    if (!result.fatalError) break block17;
                    System.out.println(" openDatatype errs=" + result.errLog);
                    ThreddsMetadata.Variables variables2 = null;
                    Object var9_5 = null;
                    try {
                        if (result != null && result.featureDataset != null) {
                            result.featureDataset.close();
                        }
                    }
                    catch (IOException ioe) {
                        logger.error("Closing dataset " + result.featureDataset, ioe);
                    }
                    return variables2;
                }
                if (result.featureType != FeatureType.GRID) break block19;
                GridDataset gridDataset = (GridDataset)((Object)result.featureDataset);
                ThreddsMetadata.Variables variables3 = MetadataExtractor.extractVariables(threddsDataset, gridDataset);
                Object var9_6 = null;
                try {
                    if (result != null && result.featureDataset != null) {
                        result.featureDataset.close();
                    }
                }
                catch (IOException ioe) {
                    logger.error("Closing dataset " + result.featureDataset, ioe);
                }
                return variables3;
            }
            try {
                if (result.featureType != FeatureType.STATION && result.featureType != FeatureType.POINT) break block21;
                PointObsDataset pobsDataset = (PointObsDataset)((Object)result.featureDataset);
                ThreddsMetadata.Variables vars = new ThreddsMetadata.Variables("CF-1.0");
                for (VariableSimpleIF vs : pobsDataset.getDataVariables()) {
                    ThreddsMetadata.Variable v = new ThreddsMetadata.Variable();
                    vars.addVariable(v);
                    v.setName(vs.getName());
                    v.setDescription(vs.getDescription());
                    v.setUnits(vs.getUnitsString());
                    Attribute att = vs.findAttributeIgnoreCase("standard_name");
                    v.setVocabularyName(att != null ? att.getStringValue() : "N/A");
                }
                vars.sort();
                variables = vars;
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (result != null && result.featureDataset != null) {
                        result.featureDataset.close();
                    }
                }
                catch (IOException ioe) {
                    logger.error("Closing dataset " + result.featureDataset, ioe);
                }
                throw throwable;
            }
            try {
                if (result != null && result.featureDataset != null) {
                    result.featureDataset.close();
                }
            }
            catch (IOException ioe) {
                logger.error("Closing dataset " + result.featureDataset, ioe);
            }
            return variables;
        }
        Object var9_8 = null;
        try {
            if (result != null && result.featureDataset != null) {
                result.featureDataset.close();
            }
        }
        catch (IOException ioe) {
            logger.error("Closing dataset " + result.featureDataset, ioe);
        }
        return null;
    }

    public static ThreddsMetadata.Variables extractVariables(InvDatasetImpl threddsDataset, GridDataset gridDataset) {
        DataFormatType fileFormat = threddsDataset.getDataFormatType();
        if (fileFormat != null && (fileFormat.equals(DataFormatType.GRIB1) || fileFormat.equals(DataFormatType.GRIB2))) {
            boolean isGrib1 = fileFormat.equals(DataFormatType.GRIB1);
            ThreddsMetadata.Variables vars = new ThreddsMetadata.Variables(fileFormat.toString());
            for (GridDatatype grid : gridDataset.getGrids()) {
                ThreddsMetadata.Variable v = new ThreddsMetadata.Variable();
                v.setName(grid.getName());
                v.setDescription(grid.getDescription());
                v.setUnits(grid.getUnitsString());
                if (isGrib1) {
                    v.setVocabularyName(grid.findAttValueIgnoreCase("GRIB_param_name", "ERROR"));
                    v.setVocabularyId(grid.findAttributeIgnoreCase("GRIB_param_id"));
                } else {
                    String paramDisc = grid.findAttValueIgnoreCase("GRIB_param_discipline", "");
                    String paramCategory = grid.findAttValueIgnoreCase("GRIB_param_category", "");
                    String paramName = grid.findAttValueIgnoreCase("GRIB_param_name", "");
                    v.setVocabularyName(paramDisc + " / " + paramCategory + " / " + paramName);
                    v.setVocabularyId(grid.findAttributeIgnoreCase("GRIB_param_id"));
                }
                vars.addVariable(v);
            }
            vars.sort();
            return vars;
        }
        ThreddsMetadata.Variables vars = new ThreddsMetadata.Variables("CF-1.0");
        for (GridDatatype grid : gridDataset.getGrids()) {
            ThreddsMetadata.Variable v = new ThreddsMetadata.Variable();
            vars.addVariable(v);
            v.setName(grid.getName());
            v.setDescription(grid.getDescription());
            v.setUnits(grid.getUnitsString());
            Attribute att = grid.findAttributeIgnoreCase("standard_name");
            v.setVocabularyName(att != null ? att.getStringValue() : "N/A");
        }
        vars.sort();
        return vars;
    }

    public static DateRange extractDateRange(GridDataset gridDataset) {
        DateRange maxDateRange = null;
        for (GridDataset.Gridset gridset : gridDataset.getGridsets()) {
            DateRange dateRange;
            GridCoordSystem gsys = gridset.getGeoCoordSystem();
            CoordinateAxis1DTime time1D = gsys.getTimeAxis1D();
            if (time1D != null) {
                dateRange = time1D.getDateRange();
            } else {
                CoordinateAxis time = gsys.getTimeAxis();
                if (time1D == null) continue;
                try {
                    DateUnit du = new DateUnit(time.getUnitsString());
                    Date minDate = du.makeDate(time.getMinValue());
                    Date maxDate = du.makeDate(time.getMaxValue());
                    dateRange = new DateRange(minDate, maxDate);
                }
                catch (Exception e) {
                    logger.warn("Illegal Date Unit " + time.getUnitsString());
                    continue;
                }
            }
            if (maxDateRange == null) {
                maxDateRange = dateRange;
                continue;
            }
            maxDateRange.extend(dateRange);
        }
        return maxDateRange;
    }
}

