/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.iosp.Indexer;

public class SegmentedLayout
extends Indexer {
    private List<Dim> dimList = new ArrayList<Dim>();
    private Index myIndex;
    private long total;
    private long done;
    private int elemSize;
    int nsegs;
    private long[] segPos;
    private long[] segMax;
    private long[] segMin;
    private Indexer.Chunk chunkOuter;
    private int contigElemsOuter;
    private long origin;
    private Indexer.Chunk chunkInner;
    private boolean debug = false;
    private boolean debugDetail = false;
    private boolean debugMerge = false;
    private boolean debugNext = false;
    private int needInner = 0;

    public SegmentedLayout(long[] segPos, int[] segSize, int elemSize, int[] varShape, Section wantSection) throws InvalidRangeException {
        Dim elem2;
        Dim elem;
        int i;
        assert (segPos.length == segSize.length);
        this.nsegs = segPos.length;
        this.segPos = segPos;
        this.elemSize = elemSize;
        this.segMin = new long[this.nsegs];
        this.segMax = new long[this.nsegs];
        long totalElems = 0L;
        for (int i2 = 0; i2 < this.nsegs; ++i2) {
            assert (segPos[i2] >= 0L);
            assert (segSize[i2] > 0);
            assert (segSize[i2] % elemSize == 0);
            this.segMin[i2] = totalElems;
            this.segMax[i2] = totalElems += (long)segSize[i2];
        }
        assert (totalElems >= Index.computeSize(varShape) * (long)elemSize);
        wantSection = Section.fill(wantSection, varShape);
        this.total = wantSection.computeSize();
        this.done = 0L;
        this.origin = 0L;
        this.contigElemsOuter = 1;
        int varRank = varShape.length;
        int stride = 1;
        for (int ii = varRank - 1; ii >= 0; --ii) {
            int realStride = elemSize * stride;
            this.dimList.add(new Dim(realStride, varShape[ii], wantSection.getRange(ii)));
            stride *= varShape[ii];
        }
        int lastDim = 1;
        if (this.debugMerge) {
            System.out.println("merge= " + this);
        }
        int merge = 0;
        for (i = 0; i < this.dimList.size() - lastDim; ++i) {
            elem = this.dimList.get(i);
            elem2 = this.dimList.get(i + 1);
            if (elem.maxSize != elem.wantSize || elem2.want.stride() != 1) break;
            ++merge;
        }
        for (i = 0; i < merge; ++i) {
            elem = this.dimList.get(i);
            elem2 = this.dimList.get(i + 1);
            elem2.maxSize *= elem.maxSize;
            elem2.wantSize *= elem.wantSize;
            if (!this.debugMerge) continue;
            System.out.println(" ----" + this);
        }
        for (i = 0; i < merge; ++i) {
            this.dimList.remove(0);
        }
        if (this.debugDetail) {
            System.out.println(" final= " + this);
        }
        if (varRank == 0 || this.dimList.get((int)0).want.stride() > 1) {
            this.contigElemsOuter = 1;
        } else {
            Dim innerDim = this.dimList.get(0);
            this.contigElemsOuter = innerDim.wantSize;
            innerDim.wantSize = 1;
        }
        for (Dim dim : this.dimList) {
            this.origin += (long)(dim.byteStride * dim.want.first());
        }
        int rank = this.dimList.size();
        int[] byteStride = new int[rank];
        int[] shape = new int[rank];
        for (int i3 = 0; i3 < this.dimList.size(); ++i3) {
            Dim dim = this.dimList.get(i3);
            byteStride[rank - i3 - 1] = dim.byteStride * dim.want.stride();
            shape[rank - i3 - 1] = dim.wantSize;
        }
        if (this.debugDetail) {
            this.printa(" indexShape=", shape);
            this.printa(" indexStride=", byteStride);
            System.out.println(" indexChunks=" + Index.computeSize(shape));
        }
        this.myIndex = new Index(shape, byteStride);
        long nchunks = Index.computeSize(shape);
        assert (nchunks * (long)this.contigElemsOuter == this.total);
        if (this.debug) {
            System.out.println("SegmentedLayout = " + this);
            System.out.println("origin= " + this.origin + " elemSize= " + elemSize + " varShape= " + this.printa(varShape) + " section= " + wantSection);
        }
    }

    private long getFilePos(long elem) {
        elem += this.origin;
        int segno = 0;
        while (elem >= this.segMax[segno]) {
            ++segno;
        }
        return this.segPos[segno] + elem - this.segMin[segno];
    }

    private int getMaxElems(long start) {
        start += this.origin;
        int segno = 0;
        while (start >= this.segMax[segno]) {
            ++segno;
        }
        return (int)(this.segMax[segno] - start);
    }

    public long getTotalNelems() {
        return this.total;
    }

    public int getElemSize() {
        return this.elemSize;
    }

    public boolean hasNext() {
        return this.done < this.total;
    }

    public Indexer.Chunk next() {
        Indexer.Chunk result = null;
        if (this.needInner > 0) {
            result = this.nextInner(false, 0);
        } else {
            result = this.nextOuter();
            int n = this.getMaxElems(this.done * (long)this.elemSize);
            if (n < this.contigElemsOuter * this.elemSize) {
                result = this.nextInner(true, n);
            }
        }
        this.done += (long)result.getNelems();
        this.needInner -= result.getNelems();
        if (this.debugNext) {
            System.out.println(" next chunk: " + result);
        }
        return result;
    }

    private Indexer.Chunk nextInner(boolean first, int n) {
        if (first) {
            this.chunkInner.setFilePos(this.chunkOuter.getFilePos());
            this.chunkInner.setNelems(n / this.elemSize);
            this.chunkInner.setStartElem(this.chunkOuter.getStartElem());
            this.needInner = this.contigElemsOuter;
        } else {
            n = this.getMaxElems(this.done * (long)this.elemSize);
            n = Math.min(n, this.needInner * this.elemSize);
            this.chunkInner.setFilePos(this.getFilePos(this.done * (long)this.elemSize));
            this.chunkInner.incrStartElem(this.chunkInner.getNelems());
            this.chunkInner.setNelems(n / this.elemSize);
        }
        return this.chunkInner;
    }

    public Indexer.Chunk nextOuter() {
        if (this.chunkOuter == null) {
            this.chunkOuter = new Indexer.Chunk(this.getFilePos(0L), this.contigElemsOuter, 0L);
            this.chunkInner = new Indexer.Chunk(0L, 0, 0L);
        } else {
            this.myIndex.incr();
            this.chunkOuter.incrStartElem(this.contigElemsOuter);
        }
        this.chunkOuter.setFilePos(this.getFilePos(this.myIndex.currentElement()));
        return this.chunkOuter;
    }

    public String toString() {
        Dim elem;
        int i;
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("wantSize=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.wantSize);
        }
        sbuff.append(" wantStride=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.want.stride());
        }
        sbuff.append(" maxSize=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.maxSize);
        }
        sbuff.append(" byteStride=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.byteStride);
        }
        return sbuff.toString();
    }

    private class Dim {
        int byteStride;
        int maxSize;
        Range want;
        int wantSize;

        Dim(int byteStride, int maxSize, Range want) {
            this.byteStride = byteStride;
            this.maxSize = maxSize;
            this.wantSize = want.length();
            this.want = want;
        }
    }
}

