/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.icc.tags;

import ucar.jpeg.icc.ICCProfile;
import ucar.jpeg.icc.tags.ICCCurveType;
import ucar.jpeg.icc.tags.ICCTag;

public class ICCCurveTypeReverse
extends ICCTag {
    private static final String eol = System.getProperty("line.separator");
    public final int type;
    public final int reserved;
    public final int nEntries;
    public final int[] entry;

    public String toString() {
        StringBuffer rep = new StringBuffer("[").append(super.toString()).append(eol);
        rep.append("num entries = " + String.valueOf(this.nEntries) + eol);
        rep.append("data length = " + String.valueOf(this.entry.length) + eol);
        for (int i = 0; i < this.nEntries; ++i) {
            rep.append(ICCProfile.toHexString(this.entry[i]) + eol);
        }
        return rep.append("]").toString();
    }

    public static double CurveToDouble(int entry) {
        return ICCCurveType.CurveToDouble(entry);
    }

    public static short DoubleToCurve(int entry) {
        return ICCCurveType.DoubleToCurve(entry);
    }

    public static double CurveGammaToDouble(int entry) {
        return ICCCurveType.CurveGammaToDouble(entry);
    }

    protected ICCCurveTypeReverse(int signature, byte[] data, int offset, int length) {
        super(signature, data, offset, offset + 8);
        this.type = ICCProfile.getInt(data, offset);
        this.reserved = ICCProfile.getInt(data, offset + 4);
        this.nEntries = ICCProfile.getInt(data, offset + 8);
        this.entry = new int[this.nEntries];
        for (int i = 0; i < this.nEntries; ++i) {
            this.entry[this.nEntries - 1 + i] = ICCProfile.getShort(data, offset + 12 + i * 2) & 0xFFFF;
        }
    }

    public final int entry(int i) {
        return this.entry[i];
    }
}

