/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class SpinIcon
implements Icon {
    public static final Type TypeUp = new Type();
    public static final Type TypeDown = new Type();
    public static final Type TypeRight = new Type();
    public static final Type TypeLeft = new Type();
    private Type type;
    private boolean orientH;

    public SpinIcon(Type type) {
        this.type = type;
        this.orientH = type == TypeUp || type == TypeDown;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        JComponent component = (JComponent)c;
        int iconWidth = 10;
        g.translate(x, y);
        g.setColor(component.isEnabled() ? MetalLookAndFeel.getControlInfo() : MetalLookAndFeel.getControlShadow());
        int line = 0;
        if (this.type == TypeUp) {
            g.drawLine(4, line, 4 + (iconWidth - 9), line);
            g.drawLine(3, ++line, 3 + (iconWidth - 7), line);
            g.drawLine(2, ++line, 2 + (iconWidth - 5), line);
            g.drawLine(1, ++line, 1 + (iconWidth - 3), line);
            g.drawLine(0, ++line, iconWidth - 1, line);
            ++line;
        } else if (this.type == TypeDown) {
            g.drawLine(0, line, iconWidth - 1, line);
            g.drawLine(1, ++line, 1 + (iconWidth - 3), line);
            g.drawLine(2, ++line, 2 + (iconWidth - 5), line);
            g.drawLine(3, ++line, 3 + (iconWidth - 7), line);
            g.drawLine(4, ++line, 4 + (iconWidth - 9), line);
            ++line;
        } else if (this.type == TypeRight) {
            g.drawLine(line, 0, line, iconWidth - 1);
            g.drawLine(++line, 1, line, 1 + (iconWidth - 3));
            g.drawLine(++line, 2, line, 2 + (iconWidth - 5));
            g.drawLine(++line, 3, line, 3 + (iconWidth - 7));
            g.drawLine(++line, 4, line, 4 + (iconWidth - 9));
            ++line;
        } else {
            g.drawLine(line, 4, line, 4 + (iconWidth - 9));
            g.drawLine(++line, 3, line, 3 + (iconWidth - 7));
            g.drawLine(++line, 2, line, 2 + (iconWidth - 5));
            g.drawLine(++line, 1, line, 1 + (iconWidth - 3));
            g.drawLine(++line, 0, line, iconWidth - 1);
            ++line;
        }
        g.translate(-x, -y);
    }

    public int getIconWidth() {
        return this.orientH ? 10 : 5;
    }

    public int getIconHeight() {
        return this.orientH ? 5 : 10;
    }

    public static class Type {
    }
}

