/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import ucar.unidata.util.StringUtil;

public class PopupManager {
    private PopupFactory factory = PopupFactory.getSharedInstance();
    private Popup popup;
    private JPanel main;
    private JLabel info;
    private boolean isShowing = false;
    private Object showing;
    private StringBuffer sbuff = new StringBuffer();

    public PopupManager(String title) {
        this.main = new JPanel();
        this.main.setBorder(new TitledBorder(title));
        this.info = new JLabel();
        this.main.add(this.info);
        this.main.setFocusable(false);
    }

    public void show(String text, Point p, Component owner, Object forWho) {
        if (this.isShowing && this.showing == forWho) {
            return;
        }
        if (this.isShowing && this.showing != forWho) {
            this.popup.hide();
        }
        this.isShowing = true;
        this.showing = forWho;
        this.sbuff.setLength(0);
        this.sbuff.append("<html><body>");
        String textSubbed = StringUtil.substitute(text, "\n", "<br>");
        this.sbuff.append(textSubbed);
        this.sbuff.append("</body></html>");
        this.info.setText(this.sbuff.toString());
        SwingUtilities.convertPointToScreen(p, owner);
        int x = (int)p.getX();
        int y = (int)p.getY();
        this.popup = this.factory.getPopup(owner, this.main, x + 5, y + 5);
        this.popup.show();
    }

    public void hide() {
        if (!this.isShowing) {
            return;
        }
        this.isShowing = false;
        this.popup.hide();
    }
}

