/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import [Ljava.lang.Class;;
import [Ljava.lang.String;;
import [Lorg.springframework.core.io.Resource;;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.regex.Pattern;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.propertyeditors.ByteArrayPropertyEditor;
import org.springframework.beans.propertyeditors.CharArrayPropertyEditor;
import org.springframework.beans.propertyeditors.CharacterEditor;
import org.springframework.beans.propertyeditors.CharsetEditor;
import org.springframework.beans.propertyeditors.ClassArrayEditor;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.CustomCollectionEditor;
import org.springframework.beans.propertyeditors.CustomMapEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.beans.propertyeditors.FileEditor;
import org.springframework.beans.propertyeditors.InputStreamEditor;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.beans.propertyeditors.PatternEditor;
import org.springframework.beans.propertyeditors.PropertiesEditor;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.beans.propertyeditors.URIEditor;
import org.springframework.beans.propertyeditors.URLEditor;
import org.springframework.core.io.support.ResourceArrayPropertyEditor;
import org.springframework.util.ClassUtils;

public class PropertyEditorRegistrySupport
implements PropertyEditorRegistry {
    private boolean defaultEditorsActive = false;
    private boolean configValueEditorsActive = false;
    private boolean propertySpecificEditorsRegistered = false;
    private Map defaultEditors;
    private Map customEditors;
    private Set sharedEditors;
    private Map customEditorCache;

    protected void registerDefaultEditors() {
        this.defaultEditorsActive = true;
    }

    public void useConfigValueEditors() {
        this.configValueEditorsActive = true;
    }

    public PropertyEditor getDefaultEditor(Class requiredType) {
        if (!this.defaultEditorsActive) {
            return null;
        }
        if (this.defaultEditors == null) {
            this.doRegisterDefaultEditors();
        }
        return (PropertyEditor)this.defaultEditors.get(requiredType);
    }

    private void doRegisterDefaultEditors() {
        this.defaultEditors = new HashMap(64);
        this.defaultEditors.put(Charset.class, new CharsetEditor());
        this.defaultEditors.put(Class.class, new ClassEditor());
        this.defaultEditors.put(Class;.class, new ClassArrayEditor());
        this.defaultEditors.put(File.class, new FileEditor());
        this.defaultEditors.put(InputStream.class, new InputStreamEditor());
        this.defaultEditors.put(Locale.class, new LocaleEditor());
        this.defaultEditors.put(Pattern.class, new PatternEditor());
        this.defaultEditors.put(Properties.class, new PropertiesEditor());
        this.defaultEditors.put(Resource;.class, new ResourceArrayPropertyEditor());
        this.defaultEditors.put(URI.class, new URIEditor());
        this.defaultEditors.put(URL.class, new URLEditor());
        this.defaultEditors.put(Collection.class, new CustomCollectionEditor(Collection.class));
        this.defaultEditors.put(Set.class, new CustomCollectionEditor(Set.class));
        this.defaultEditors.put(SortedSet.class, new CustomCollectionEditor(SortedSet.class));
        this.defaultEditors.put(List.class, new CustomCollectionEditor(List.class));
        this.defaultEditors.put(SortedMap.class, new CustomMapEditor(SortedMap.class));
        this.defaultEditors.put([B.class, new ByteArrayPropertyEditor());
        this.defaultEditors.put([C.class, new CharArrayPropertyEditor());
        this.defaultEditors.put(Character.TYPE, new CharacterEditor(false));
        this.defaultEditors.put(Character.class, new CharacterEditor(true));
        this.defaultEditors.put(Boolean.TYPE, new CustomBooleanEditor(false));
        this.defaultEditors.put(Boolean.class, new CustomBooleanEditor(true));
        this.defaultEditors.put(Byte.TYPE, new CustomNumberEditor(Byte.class, false));
        this.defaultEditors.put(Byte.class, new CustomNumberEditor(Byte.class, true));
        this.defaultEditors.put(Short.TYPE, new CustomNumberEditor(Short.class, false));
        this.defaultEditors.put(Short.class, new CustomNumberEditor(Short.class, true));
        this.defaultEditors.put(Integer.TYPE, new CustomNumberEditor(Integer.class, false));
        this.defaultEditors.put(Integer.class, new CustomNumberEditor(Integer.class, true));
        this.defaultEditors.put(Long.TYPE, new CustomNumberEditor(Long.class, false));
        this.defaultEditors.put(Long.class, new CustomNumberEditor(Long.class, true));
        this.defaultEditors.put(Float.TYPE, new CustomNumberEditor(Float.class, false));
        this.defaultEditors.put(Float.class, new CustomNumberEditor(Float.class, true));
        this.defaultEditors.put(Double.TYPE, new CustomNumberEditor(Double.class, false));
        this.defaultEditors.put(Double.class, new CustomNumberEditor(Double.class, true));
        this.defaultEditors.put(BigDecimal.class, new CustomNumberEditor(BigDecimal.class, true));
        this.defaultEditors.put(BigInteger.class, new CustomNumberEditor(BigInteger.class, true));
        if (this.configValueEditorsActive) {
            StringArrayPropertyEditor sae = new StringArrayPropertyEditor();
            this.defaultEditors.put(String;.class, sae);
            this.defaultEditors.put([S.class, sae);
            this.defaultEditors.put([I.class, sae);
            this.defaultEditors.put([J.class, sae);
        }
    }

    protected void copyDefaultEditorsTo(PropertyEditorRegistrySupport target) {
        target.defaultEditors = this.defaultEditors;
        target.defaultEditorsActive = this.defaultEditorsActive;
        target.configValueEditorsActive = this.configValueEditorsActive;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.registerCustomEditor(requiredType, null, propertyEditor);
    }

    public void registerCustomEditor(Class requiredType, String propertyPath, PropertyEditor propertyEditor) {
        if (requiredType == null && propertyPath == null) {
            throw new IllegalArgumentException("Either requiredType or propertyPath is required");
        }
        if (this.customEditors == null) {
            this.customEditors = new LinkedHashMap(16);
        }
        if (propertyPath != null) {
            this.customEditors.put(propertyPath, new CustomEditorHolder(propertyEditor, requiredType));
            this.propertySpecificEditorsRegistered = true;
        } else {
            this.customEditors.put(requiredType, propertyEditor);
            this.customEditorCache = null;
        }
    }

    public void registerSharedEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.registerCustomEditor(requiredType, null, propertyEditor);
        if (this.sharedEditors == null) {
            this.sharedEditors = new HashSet();
        }
        this.sharedEditors.add(propertyEditor);
    }

    public boolean isSharedEditor(PropertyEditor propertyEditor) {
        return this.sharedEditors != null && this.sharedEditors.contains(propertyEditor);
    }

    public PropertyEditor findCustomEditor(Class requiredType, String propertyPath) {
        if (this.customEditors == null) {
            return null;
        }
        Class requiredTypeToUse = requiredType;
        if (propertyPath != null) {
            if (this.propertySpecificEditorsRegistered) {
                PropertyEditor editor = this.getCustomEditor(propertyPath, requiredType);
                if (editor == null) {
                    LinkedList strippedPaths = new LinkedList();
                    this.addStrippedPropertyPaths(strippedPaths, "", propertyPath);
                    Iterator it = strippedPaths.iterator();
                    while (it.hasNext() && editor == null) {
                        String strippedPath = (String)it.next();
                        editor = this.getCustomEditor(strippedPath, requiredType);
                    }
                }
                if (editor != null) {
                    return editor;
                }
            }
            if (requiredType == null) {
                requiredTypeToUse = this.getPropertyType(propertyPath);
            }
        }
        return this.getCustomEditor(requiredTypeToUse);
    }

    public boolean hasCustomEditorForElement(Class elementType, String propertyPath) {
        if (this.customEditors == null) {
            return false;
        }
        if (propertyPath != null && this.propertySpecificEditorsRegistered) {
            Iterator it = this.customEditors.entrySet().iterator();
            while (it.hasNext()) {
                CustomEditorHolder editorHolder;
                String regPath;
                Map.Entry entry = it.next();
                if (!(entry.getKey() instanceof String) || !PropertyAccessorUtils.matchesProperty(regPath = (String)entry.getKey(), propertyPath) || (editorHolder = (CustomEditorHolder)entry.getValue()).getPropertyEditor(elementType) == null) continue;
                return true;
            }
        }
        return elementType != null && this.customEditors.containsKey(elementType);
    }

    protected Class getPropertyType(String propertyPath) {
        return null;
    }

    private PropertyEditor getCustomEditor(String propertyName, Class requiredType) {
        CustomEditorHolder holder = (CustomEditorHolder)this.customEditors.get(propertyName);
        return holder != null ? holder.getPropertyEditor(requiredType) : null;
    }

    private PropertyEditor getCustomEditor(Class requiredType) {
        if (requiredType == null) {
            return null;
        }
        PropertyEditor editor = (PropertyEditor)this.customEditors.get(requiredType);
        if (editor == null) {
            if (this.customEditorCache != null) {
                editor = (PropertyEditor)this.customEditorCache.get(requiredType);
            }
            if (editor == null) {
                Iterator it = this.customEditors.keySet().iterator();
                while (it.hasNext() && editor == null) {
                    Object key = it.next();
                    if (!(key instanceof Class) || !((Class)key).isAssignableFrom(requiredType)) continue;
                    editor = (PropertyEditor)this.customEditors.get(key);
                    if (this.customEditorCache == null) {
                        this.customEditorCache = new HashMap();
                    }
                    this.customEditorCache.put(requiredType, editor);
                }
            }
        }
        return editor;
    }

    protected Class guessPropertyTypeFromEditors(String propertyName) {
        if (this.customEditors != null) {
            CustomEditorHolder editorHolder = (CustomEditorHolder)this.customEditors.get(propertyName);
            if (editorHolder == null) {
                LinkedList strippedPaths = new LinkedList();
                this.addStrippedPropertyPaths(strippedPaths, "", propertyName);
                Iterator it = strippedPaths.iterator();
                while (it.hasNext() && editorHolder == null) {
                    String strippedName = (String)it.next();
                    editorHolder = (CustomEditorHolder)this.customEditors.get(strippedName);
                }
            }
            if (editorHolder != null) {
                return editorHolder.getRegisteredType();
            }
        }
        return null;
    }

    protected void copyCustomEditorsTo(PropertyEditorRegistry target, String nestedProperty) {
        String actualPropertyName;
        String string = actualPropertyName = nestedProperty != null ? PropertyAccessorUtils.getPropertyName(nestedProperty) : null;
        if (this.customEditors != null) {
            Iterator it = this.customEditors.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (entry.getKey() instanceof Class) {
                    Class requiredType = (Class)entry.getKey();
                    PropertyEditor editor = (PropertyEditor)entry.getValue();
                    target.registerCustomEditor(requiredType, editor);
                    continue;
                }
                if (!(entry.getKey() instanceof String)) continue;
                String editorPath = (String)entry.getKey();
                CustomEditorHolder editorHolder = (CustomEditorHolder)entry.getValue();
                if (nestedProperty != null) {
                    int pos = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex(editorPath);
                    if (pos == -1) continue;
                    String editorNestedProperty = editorPath.substring(0, pos);
                    String editorNestedPath = editorPath.substring(pos + 1);
                    if (!editorNestedProperty.equals(nestedProperty) && !editorNestedProperty.equals(actualPropertyName)) continue;
                    target.registerCustomEditor(editorHolder.getRegisteredType(), editorNestedPath, editorHolder.getPropertyEditor());
                    continue;
                }
                target.registerCustomEditor(editorHolder.getRegisteredType(), editorPath, editorHolder.getPropertyEditor());
            }
        }
    }

    private void addStrippedPropertyPaths(List strippedPaths, String nestedPath, String propertyPath) {
        int endIndex;
        int startIndex = propertyPath.indexOf(91);
        if (startIndex != -1 && (endIndex = propertyPath.indexOf(93)) != -1) {
            String prefix = propertyPath.substring(0, startIndex);
            String key = propertyPath.substring(startIndex, endIndex + 1);
            String suffix = propertyPath.substring(endIndex + 1, propertyPath.length());
            strippedPaths.add(nestedPath + prefix + suffix);
            this.addStrippedPropertyPaths(strippedPaths, nestedPath + prefix, suffix);
            this.addStrippedPropertyPaths(strippedPaths, nestedPath + prefix + key, suffix);
        }
    }

    private static class CustomEditorHolder {
        private final PropertyEditor propertyEditor;
        private final Class registeredType;

        private CustomEditorHolder(PropertyEditor propertyEditor, Class registeredType) {
            this.propertyEditor = propertyEditor;
            this.registeredType = registeredType;
        }

        private PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }

        private Class getRegisteredType() {
            return this.registeredType;
        }

        private PropertyEditor getPropertyEditor(Class requiredType) {
            if (this.registeredType == null || requiredType != null && (ClassUtils.isAssignable(this.registeredType, requiredType) || ClassUtils.isAssignable(requiredType, this.registeredType)) || requiredType == null && !(class$java$util$Collection == null ? (class$java$util$Collection = PropertyEditorRegistrySupport.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(this.registeredType) && !this.registeredType.isArray()) {
                return this.propertyEditor;
            }
            return null;
        }
    }
}

