/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;

class MultiTermDocs
implements TermDocs {
    protected IndexReader[] readers;
    protected int[] starts;
    protected Term term;
    protected int base = 0;
    protected int pointer = 0;
    private SegmentTermDocs[] segTermDocs;
    protected SegmentTermDocs current;

    public MultiTermDocs(IndexReader[] r, int[] s) {
        this.readers = r;
        this.starts = s;
        this.segTermDocs = new SegmentTermDocs[r.length];
    }

    public int doc() {
        return this.base + this.current.doc;
    }

    public int freq() {
        return this.current.freq;
    }

    public void seek(Term term) {
        this.term = term;
        this.base = 0;
        this.pointer = 0;
        this.current = null;
    }

    public void seek(TermEnum termEnum) throws IOException {
        this.seek(termEnum.term());
    }

    public boolean next() throws IOException {
        if (this.current != null && this.current.next()) {
            return true;
        }
        if (this.pointer < this.readers.length) {
            this.base = this.starts[this.pointer];
            this.current = this.termDocs(this.pointer++);
            return this.next();
        }
        return false;
    }

    public int read(int[] docs, int[] freqs) throws IOException {
        int end;
        while (true) {
            if (this.current == null) {
                if (this.pointer < this.readers.length) {
                    this.base = this.starts[this.pointer];
                    this.current = this.termDocs(this.pointer++);
                    continue;
                }
                return 0;
            }
            end = this.current.read(docs, freqs);
            if (end != 0) break;
            this.current = null;
        }
        int b = this.base;
        int i = 0;
        while (i < end) {
            int n = i++;
            docs[n] = docs[n] + b;
        }
        return end;
    }

    public boolean skipTo(int target) throws IOException {
        do {
            if (this.next()) continue;
            return false;
        } while (target > this.doc());
        return true;
    }

    private SegmentTermDocs termDocs(int i) throws IOException {
        if (this.term == null) {
            return null;
        }
        SegmentTermDocs result = this.segTermDocs[i];
        if (result == null) {
            result = this.segTermDocs[i] = this.termDocs(this.readers[i]);
        }
        result.seek(this.term);
        return result;
    }

    protected SegmentTermDocs termDocs(IndexReader reader) throws IOException {
        return (SegmentTermDocs)reader.termDocs();
    }

    public void close() throws IOException {
        for (int i = 0; i < this.segTermDocs.length; ++i) {
            if (this.segTermDocs[i] == null) continue;
            this.segTermDocs[i].close();
        }
    }
}

