/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.EOFException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.LogTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;
import loci.formats.codec.JPEGCodec;
import loci.formats.in.LegacyZVIReader;

public class ZeissZVIReader
extends FormatReader {
    private static final String NO_POI_MSG = "Jakarta POI is required to read ZVI files. Please obtain poi-loci.jar from http://loci.wisc.edu/ome/formats.html";
    private LegacyZVIReader legacy = new LegacyZVIReader();
    private static boolean noPOI = false;
    private static ReflectedUniverse r = ZeissZVIReader.createReflectedUniverse();
    private boolean needLegacy = false;
    private int bpp;
    private Hashtable pixels;
    private Hashtable names;
    private Vector zIndices;
    private Vector cIndices;
    private Vector tIndices;
    private Hashtable offsets;
    private int zIndex = -1;
    private int cIndex = -1;
    private int tIndex = -1;
    private boolean isTiled;
    private int tileRows;
    private int tileColumns;
    private boolean isJPEG;

    private static ReflectedUniverse createReflectedUniverse() {
        block2: {
            r = null;
            try {
                r = new ReflectedUniverse();
                r.exec("import org.apache.poi.poifs.filesystem.POIFSFileSystem");
                r.exec("import org.apache.poi.poifs.filesystem.DirectoryEntry");
                r.exec("import org.apache.poi.poifs.filesystem.DocumentEntry");
                r.exec("import org.apache.poi.poifs.filesystem.DocumentInputStream");
                r.exec("import java.util.Iterator");
            }
            catch (ReflectException exc) {
                noPOI = true;
                if (!debug) break block2;
                LogTools.trace(exc);
            }
        }
        return r;
    }

    public ZeissZVIReader() {
        super("Zeiss Vision Image (ZVI)", "zvi");
    }

    public boolean isThisType(byte[] block) {
        return block[0] == 208 && block[1] == 207 && block[2] == 17 && block[3] == 224;
    }

    public void setMetadataStore(MetadataStore store) {
        FormatTools.assertId(this.currentId, false, 1);
        super.setMetadataStore(store);
        if (noPOI || this.needLegacy) {
            this.legacy.setMetadataStore(store);
        }
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPOI || this.needLegacy) {
            return this.legacy.openBytes(no, buf);
        }
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        try {
            int i;
            int tiles = this.tileRows * this.tileColumns;
            if (tiles == 0) {
                tiles = 1;
                this.tileRows = 1;
                this.tileColumns = 1;
            }
            int start = no * tiles;
            int bytes = FormatTools.getBytesPerPixel(this.core.pixelType[0]) * this.getRGBChannelCount();
            int ex = this.core.sizeX[0] / this.tileColumns;
            int ey = this.core.sizeY[0] / this.tileRows;
            int row = ex * bytes;
            int[] tileOrder = new int[tiles];
            if (tiles == 1) {
                tileOrder[0] = no;
            } else {
                int p = 0;
                for (int r = 0; r < this.tileRows; ++r) {
                    for (int c = 0; c < this.tileColumns; ++c) {
                        int n = no % this.core.sizeC[0] + tiles * this.core.sizeC[0] * (no / this.core.sizeC[0]);
                        if (r % 2 == 0) {
                            tileOrder[p] = p * this.core.sizeC[0] + n;
                        } else {
                            tileOrder[p] = (this.tileColumns - c) * this.core.sizeC[0];
                            if (p > 0 && c == 0) {
                                int n2 = p;
                                tileOrder[n2] = tileOrder[n2] + tileOrder[p - 1];
                            } else if (c > 0) {
                                tileOrder[p] = tileOrder[p - 1] - this.core.sizeC[0];
                            }
                        }
                        ++p;
                    }
                }
            }
            for (i = start; i < start + tiles; ++i) {
                Integer ii = new Integer(tileOrder[i - start]);
                Object directory = this.pixels.get(ii);
                String name = (String)this.names.get(ii);
                r.setVar("dir", directory);
                r.setVar("entryName", name);
                r.exec("document = dir.getEntry(entryName)");
                r.exec("dis = new DocumentInputStream(document)");
                r.exec("numBytes = dis.available()");
                r.setVar("skipBytes", ((Integer)this.offsets.get(ii)).longValue());
                r.exec("blah = dis.skip(skipBytes)");
                r.setVar("data", buf);
                int xf = (i - start) % this.tileColumns * ex * bytes;
                int yf = (i - start) / this.tileRows * ey;
                int offset = yf * this.core.sizeX[0] * bytes + xf;
                for (int y = 0; y < ey; ++y) {
                    r.setVar("offset", offset);
                    r.setVar("len", row);
                    try {
                        r.exec("dis.read(data, offset, len)");
                    }
                    catch (ReflectException e) {
                        // empty catch block
                    }
                    offset += this.core.sizeX[0] * bytes;
                }
                if (!this.isJPEG) continue;
                JPEGCodec codec = new JPEGCodec();
                buf = codec.decompress(buf);
            }
            if (this.bpp > 6) {
                this.bpp = 1;
            }
            if (this.bpp == 3) {
                for (i = 0; i < buf.length; i += 3) {
                    byte b = buf[i + 2];
                    buf[i + 2] = buf[i];
                    buf[i] = b;
                }
            }
            return buf;
        }
        catch (ReflectException e) {
            this.needLegacy = true;
            return this.openBytes(no, buf);
        }
    }

    public void close(boolean fileOnly) throws IOException {
        if (fileOnly) {
            if (this.in != null) {
                this.in.close();
            }
            if (this.legacy != null) {
                this.legacy.close(fileOnly);
            }
        } else {
            this.close();
        }
    }

    public void close() throws IOException {
        super.close();
        this.needLegacy = false;
        if (this.legacy != null) {
            this.legacy.close();
        }
        this.pixels = null;
        this.names = null;
        this.offsets = null;
        String[] vars = new String[]{"dirName", "root", "dir", "document", "dis", "numBytes", "data", "fis", "fs", "iter", "isInstance", "isDocument", "entry", "documentName", "entryName"};
        for (int i = 0; i < vars.length; ++i) {
            r.setVar(vars[i], null);
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        block47: {
            int lastT;
            if (debug) {
                this.debug("ZeissZVIReader.initFile(" + id + ")");
            }
            if (noPOI || this.needLegacy) {
                this.legacy.setId(id);
                this.core = this.legacy.getCoreMetadata();
                return;
            }
            super.initFile(id);
            this.pixels = new Hashtable();
            this.names = new Hashtable();
            this.offsets = new Hashtable();
            this.zIndices = new Vector();
            this.cIndices = new Vector();
            this.tIndices = new Vector();
            try {
                this.in = new RandomAccessStream(id);
                r.setVar("fis", this.in);
                r.exec("fs = new POIFSFileSystem(fis)");
                r.exec("dir = fs.getRoot()");
                this.parseDir(0, r.getVar("dir"));
                this.status("Populating metadata");
                this.core.rgb[0] = this.core.sizeC[0] > 1 && this.core.sizeZ[0] * this.core.sizeC[0] * this.core.sizeT[0] != this.core.imageCount[0];
                this.core.littleEndian[0] = true;
                this.core.interleaved[0] = !this.isJPEG;
                this.core.indexed[0] = false;
                this.core.falseColor[0] = false;
                this.core.metadataComplete[0] = true;
                this.core.sizeZ[0] = this.zIndices.size();
                this.core.sizeT[0] = this.tIndices.size();
                if (this.core.sizeC[0] != this.cIndices.size()) {
                    this.core.sizeC[0] = this.core.sizeC[0] * this.cIndices.size();
                }
                this.core.imageCount[0] = this.core.sizeZ[0] * this.core.sizeT[0] * (this.core.rgb[0] ? this.core.sizeC[0] / 3 : this.core.sizeC[0]);
                if (this.isTiled) {
                    String zeroIndex = (String)this.getMeta("ImageTile Index 0");
                    String oneIndex = (String)this.getMeta("ImageTile Index 1");
                    if (zeroIndex == null || zeroIndex.equals("")) {
                        zeroIndex = null;
                    }
                    if (oneIndex == null || oneIndex.equals("")) {
                        oneIndex = null;
                    }
                    if (zeroIndex == null || oneIndex == null) {
                        this.isTiled = false;
                    } else {
                        int lowerLeft = Integer.parseInt(zeroIndex);
                        int middle = Integer.parseInt(oneIndex);
                        this.tileColumns = lowerLeft - middle - 1;
                        this.tileRows = lowerLeft / this.tileColumns + 1;
                        if (this.tileColumns < 0) {
                            this.tileColumns = 1;
                        }
                        if (this.tileRows < 0) {
                            this.tileRows = 1;
                        }
                        this.core.sizeX[0] = this.core.sizeX[0] * this.tileColumns;
                        this.core.sizeY[0] = this.core.sizeY[0] * this.tileRows;
                        if (this.tileColumns == 1 && this.tileRows == 1) {
                            this.isTiled = false;
                        }
                    }
                }
                if (this.cIndex != -1) {
                    int[] dims = new int[]{this.core.sizeZ[0], this.core.sizeC[0], this.core.sizeT[0]};
                    int max = 0;
                    int min = Integer.MAX_VALUE;
                    int maxNdx = 0;
                    int minNdx = 0;
                    String[] axes = new String[]{"Z", "C", "T"};
                    for (int i = 0; i < dims.length; ++i) {
                        if (dims[i] > max) {
                            max = dims[i];
                            maxNdx = i;
                        }
                        if (dims[i] >= min) continue;
                        min = dims[i];
                        minNdx = i;
                    }
                    int medNdx = 0;
                    for (int i = 0; i < 3; ++i) {
                        if (i == maxNdx || i == minNdx) continue;
                        medNdx = i;
                    }
                    this.core.currentOrder[0] = "XY" + axes[maxNdx] + axes[medNdx] + axes[minNdx];
                    int num = this.core.sizeZ[0] * this.core.sizeT[0] - this.core.sizeC[0];
                    if (this.zIndex != -1 && this.tIndex != -1 && this.zIndex != num && this.tIndex != num && this.zIndex != this.core.sizeZ[0]) {
                        this.core.currentOrder[0] = this.core.sizeZ[0] != 1 ? this.core.currentOrder[0].replaceAll("Z", "") + "Z" : this.core.currentOrder[0].replaceAll("T", "") + "T";
                    }
                    if (this.core.sizeZ[0] == this.core.sizeC[0] && this.core.sizeC[0] == this.core.sizeT[0]) {
                        this.legacy.setId(id);
                        this.core.currentOrder[0] = this.legacy.getDimensionOrder();
                    }
                } else {
                    this.core.currentOrder[0] = this.core.rgb[0] ? (this.core.sizeZ[0] > this.core.sizeT[0] ? "XYCZT" : "XYCTZ") : (this.metadata.get("MultiChannelEnabled") != null || this.metadata.get("MultiChannelEnabled 0") != null ? (this.core.sizeZ[0] > this.core.sizeT[0] ? "XYCZT" : "XYCTZ") : (this.core.sizeZ[0] > this.core.sizeT[0] ? "XYZTC" : "XYTZC"));
                }
            }
            catch (ReflectException exc) {
                this.needLegacy = true;
                if (debug) {
                    this.trace(exc);
                }
                this.initFile(id);
            }
            int lastZ = this.zIndices.size() == 0 ? Integer.MAX_VALUE : (Integer)this.zIndices.get(this.zIndices.size() - 1);
            int n = lastT = this.tIndices.size() == 0 ? Integer.MAX_VALUE : (Integer)this.tIndices.get(this.tIndices.size() - 1);
            if ((this.zIndex > lastZ || this.tIndex > lastT) && (this.zIndex == this.core.sizeC[0] - 1 || this.tIndex == this.core.sizeC[0] - 1 || this.zIndex != 0 && this.zIndex % this.core.sizeC[0] == 0 || this.tIndex != 0 && this.tIndex % this.core.sizeC[0] == 0) && this.zIndex != lastT && (this.zIndex >= this.core.sizeZ[0] || this.tIndex >= this.core.sizeT[0])) {
                int tmp = this.core.sizeZ[0];
                this.core.sizeZ[0] = this.core.sizeT[0];
                this.core.sizeT[0] = tmp;
            }
            if (this.metadata.size() > 0) {
                String lastEM = (String)this.getMeta("Emission Wavelength " + (this.core.sizeC[0] - 1));
                String nextToLastEM = (String)this.getMeta("Emission Wavelength " + (this.core.sizeC[0] - 2));
                if (lastEM == null || nextToLastEM == null || lastEM.equals(nextToLastEM)) {
                    String lastDye = (String)this.getMeta("Reflector " + (this.core.sizeC[0] - 1));
                    String nextToLastDye = (String)this.getMeta("Reflector " + (this.core.sizeC[0] - 2));
                    if (lastDye == null) {
                        lastDye = "";
                    }
                    if (nextToLastDye == null) {
                        nextToLastDye = "";
                    }
                    lastDye = DataTools.stripString(lastDye);
                    if ((nextToLastDye = DataTools.stripString(nextToLastDye)).indexOf("Rhodamine") != -1) {
                        this.addMeta("Emission Wavelength " + (this.core.sizeC[0] - 2), "580");
                        this.addMeta("Excitation Wavelength " + (this.core.sizeC[0] - 2), "540");
                    } else if (nextToLastDye.indexOf("DAPI") != -1) {
                        this.addMeta("Emission Wavelength " + (this.core.sizeC[0] - 2), "461");
                        this.addMeta("Excitation Wavelength " + (this.core.sizeC[0] - 2), "359");
                    } else if (nextToLastDye.startsWith("Alexa Fluor")) {
                        this.addMeta("Emission Wavelength " + (this.core.sizeC[0] - 2), "519");
                        this.addMeta("Excitation Wavelength " + (this.core.sizeC[0] - 2), "495");
                    } else if (nextToLastDye.indexOf("Alexa Fluor") != -1) {
                        this.addMeta("Emission Wavelength " + (this.core.sizeC[0] - 2), "668");
                        this.addMeta("Excitation Wavelength " + (this.core.sizeC[0] - 2), "650");
                    }
                    if (lastDye.indexOf("Rhodamine") != -1) {
                        this.addMeta("Emission Wavelength " + (this.core.sizeC[0] - 1), "580");
                        this.addMeta("Excitation Wavelength " + (this.core.sizeC[0] - 1), "540");
                    } else if (lastDye.indexOf("DAPI") != -1) {
                        this.addMeta("Emission Wavelength " + (this.core.sizeC[0] - 1), "461");
                        this.addMeta("Excitation Wavelength " + (this.core.sizeC[0] - 1), "359");
                    } else if (lastDye.startsWith("Alexa Fluor")) {
                        this.addMeta("Emission Wavelength " + (this.core.sizeC[0] - 1), "519");
                        this.addMeta("Excitation Wavelength " + (this.core.sizeC[0] - 1), "495");
                    } else if (lastDye.indexOf("Alexa Fluor") != -1) {
                        this.addMeta("Emission Wavelength " + (this.core.sizeC[0] - 1), "668");
                        this.addMeta("Excitation Wavelength " + (this.core.sizeC[0] - 1), "650");
                    }
                }
            }
            try {
                this.initMetadata();
            }
            catch (FormatException exc) {
                if (debug) {
                    this.trace(exc);
                }
            }
            catch (IOException exc) {
                if (!debug) break block47;
                this.trace(exc);
            }
        }
        String[] keys = this.metadata.keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            String n = keys[i];
            if (n.indexOf(" ") == -1) continue;
            n = n.substring(n.lastIndexOf(" ") + 1);
            try {
                int ndx = Integer.parseInt(n);
                if (ndx < this.core.sizeC[0]) continue;
                this.metadata.remove(keys[i]);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private void initMetadata() throws FormatException, IOException {
        String objectiveMag;
        int i;
        MetadataStore store = this.getMetadataStore();
        String fname = (String)this.getMeta("Title");
        if (fname == null) {
            fname = this.currentId;
        }
        store.setImage(fname, null, null, null);
        if (this.bpp == 1 || this.bpp == 3) {
            this.core.pixelType[0] = 1;
        } else if (this.bpp == 2 || this.bpp == 6) {
            this.core.pixelType[0] = 3;
        }
        FormatTools.populatePixels(store, this);
        String pixX = (String)this.getMeta("Scale Factor for X");
        String pixY = (String)this.getMeta("Scale Factor for Y");
        String pixZ = (String)this.getMeta("Scale Factor for Z");
        store.setDimensions(pixX == null ? null : new Float(pixX), pixY == null ? null : new Float(pixY), pixZ == null ? null : new Float(pixZ), null, null, null);
        String scopeName = (String)this.getMeta("Microscope Name");
        if (scopeName == null) {
            scopeName = (String)this.getMeta("Microscope Name 0");
        }
        store.setInstrument(null, scopeName, null, null, null);
        for (i = 0; i < this.core.sizeC[0]; ++i) {
            int idx = FormatTools.getIndex(this, 0, i % this.getEffectiveSizeC(), 0);
            String emWave = (String)this.getMeta("Emission Wavelength " + idx);
            String exWave = (String)this.getMeta("Excitation Wavelength " + idx);
            if (emWave != null && emWave.indexOf(".") != -1) {
                emWave = emWave.substring(0, emWave.indexOf("."));
            }
            if (exWave != null && exWave.indexOf(".") != -1) {
                exWave = exWave.substring(0, exWave.indexOf("."));
            }
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, emWave == null ? null : new Integer(emWave), exWave == null ? null : new Integer(exWave), null, null, null);
            String black = (String)this.getMeta("BlackValue " + idx);
            String white = (String)this.getMeta("WhiteValue " + idx);
            String gamma = (String)this.getMeta("GammaValue " + idx);
            Double blackValue = null;
            Double whiteValue = null;
            Float gammaValue = null;
            try {
                blackValue = new Double(black);
            }
            catch (NumberFormatException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                whiteValue = new Double(white);
            }
            catch (NumberFormatException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                gammaValue = new Float(gamma);
            }
            catch (NumberFormatException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            store.setDisplayChannel(new Integer(i), blackValue, whiteValue, gammaValue, null);
        }
        for (i = 0; i < this.core.imageCount[0]; ++i) {
            int[] zct = FormatTools.getZCTCoords(this, i);
            String exposure = (String)this.getMeta("Exposure Time [ms] " + i);
            Float exp = new Float(0.0);
            try {
                exp = new Float(exposure);
            }
            catch (NumberFormatException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            store.setPlaneInfo(zct[0], zct[1], zct[2], new Float(0.0), exp, null);
        }
        String objectiveName = (String)this.getMeta("Objective Name 0");
        if (objectiveName != null) {
            objectiveName = DataTools.stripString(objectiveName);
        }
        objectiveMag = (objectiveMag = (String)this.getMeta("Objective Magnification 0")) != null ? DataTools.stripString(objectiveMag) : "1.0";
        String objectiveNA = (String)this.getMeta("Objective N.A. 0");
        objectiveNA = objectiveNA != null ? DataTools.stripString(objectiveNA) : "1.0";
        store.setObjective(null, objectiveName, null, new Float(objectiveNA), new Float(objectiveMag), null, null);
    }

    protected void parseDir(int depth, Object dir) throws IOException, FormatException, ReflectException {
        r.setVar("dir", dir);
        r.exec("dirName = dir.getName()");
        r.setVar("depth", depth);
        r.exec("iter = dir.getEntries()");
        Iterator iter = (Iterator)r.getVar("iter");
        while (iter.hasNext()) {
            byte[] data;
            block33: {
                r.setVar("entry", iter.next());
                r.exec("isInstance = entry.isDirectoryEntry()");
                r.exec("isDocument = entry.isDocumentEntry()");
                boolean isInstance = (Boolean)r.getVar("isInstance");
                boolean isDocument = (Boolean)r.getVar("isDocument");
                r.setVar("dir", dir);
                r.exec("dirName = dir.getName()");
                if (isInstance) {
                    this.status("Parsing embedded folder (" + (depth + 1) + ")");
                    this.parseDir(depth + 1, r.getVar("entry"));
                    continue;
                }
                if (!isDocument) continue;
                this.status("Parsing embedded file (" + depth + ")");
                r.exec("entryName = entry.getName()");
                if (debug) {
                    this.print(depth + 1, "Found document: " + r.getVar("entryName"));
                }
                r.exec("dis = new DocumentInputStream(entry)");
                r.exec("numBytes = dis.available()");
                int numbytes = (Integer)r.getVar("numBytes");
                data = new byte[numbytes + 4];
                r.setVar("data", data);
                try {
                    r.exec("dis.read(data)");
                }
                catch (ReflectException exc) {
                    if (!debug) break block33;
                    this.trace(exc);
                }
            }
            String entryName = (String)r.getVar("entryName");
            String dirName = (String)r.getVar("dirName");
            boolean isContents = entryName.toUpperCase().equals("CONTENTS");
            Object directory = r.getVar("dir");
            RandomAccessStream s = new RandomAccessStream(data);
            s.order(true);
            if (dirName.toUpperCase().equals("ROOT ENTRY") || dirName.toUpperCase().equals("ROOTENTRY")) {
                if (entryName.equals("Tags")) {
                    try {
                        this.parseTags(s);
                    }
                    catch (EOFException e) {}
                }
            } else if (dirName.equals("Tags") && isContents) {
                try {
                    this.parseTags(s);
                }
                catch (EOFException e) {}
            } else if (isContents && (dirName.equals("Image") || dirName.toUpperCase().indexOf("ITEM") != -1) && data.length > this.core.sizeX[0] * this.core.sizeY[0]) {
                s.skipBytes(6);
                short vt = s.readShort();
                if (vt == 3) {
                    s.skipBytes(6);
                } else if (vt == 8) {
                    short l = s.readShort();
                    s.skipBytes(l + 2);
                }
                int len = s.readShort();
                if (s.readShort() != 0) {
                    s.seek(s.getFilePointer() - 2L);
                }
                if (s.getFilePointer() + (long)len > s.length()) break;
                s.skipBytes(len);
                vt = s.readShort();
                if (vt == 8) {
                    len = s.readInt();
                    s.skipBytes(len + 2);
                }
                int tw = s.readInt();
                if (this.core.sizeX[0] == 0 || tw < this.core.sizeX[0] && tw > 0) {
                    this.core.sizeX[0] = tw;
                }
                s.skipBytes(2);
                int th = s.readInt();
                if (this.core.sizeY[0] == 0 || th < this.core.sizeY[0] && th > 0) {
                    this.core.sizeY[0] = th;
                }
                s.skipBytes(14);
                int numImageContainers = s.readInt();
                s.skipBytes(6);
                while (s.readShort() != 65) {
                }
                len = s.readInt();
                s.skipBytes(len);
                s.skipBytes(2);
                long old = s.getFilePointer();
                len = s.readInt();
                s.skipBytes(8);
                int tidx = s.readInt();
                int cidx = s.readInt();
                int zidx = s.readInt();
                Integer zndx = new Integer(zidx);
                Integer cndx = new Integer(cidx);
                Integer tndx = new Integer(tidx);
                if (!this.zIndices.contains(zndx)) {
                    this.zIndices.add(zndx);
                }
                if (!this.cIndices.contains(cndx)) {
                    this.cIndices.add(cndx);
                }
                if (!this.tIndices.contains(tndx)) {
                    this.tIndices.add(tndx);
                }
                s.seek(old + (long)len + 4L);
                boolean foundWidth = s.readInt() == this.core.sizeX[0];
                boolean foundHeight = s.readInt() == this.core.sizeY[0];
                boolean findFailed = false;
                while (!(foundWidth && foundHeight || s.getFilePointer() + 1L >= s.length())) {
                    s.seek(s.getFilePointer() - 7L);
                    foundWidth = s.readInt() == this.core.sizeX[0];
                    foundHeight = s.readInt() == this.core.sizeY[0];
                }
                s.seek(s.getFilePointer() - 16L);
                boolean bl = findFailed = !foundWidth && !foundHeight;
                if (dirName.toUpperCase().indexOf("ITEM") != -1 || dirName.equals("Image") && numImageContainers == 0) {
                    if (findFailed) {
                        s.seek(old + (long)len + 92L);
                    }
                    long fp = s.getFilePointer();
                    byte[] o = new byte[(int)(s.length() - fp)];
                    s.read(o);
                    int imageNum = 0;
                    if (dirName.toUpperCase().indexOf("ITEM") != -1) {
                        String num = dirName.substring(5);
                        num = num.substring(0, num.length() - 1);
                        imageNum = Integer.parseInt(num);
                    }
                    this.offsets.put(new Integer(imageNum), new Integer((int)fp + 32));
                    this.parsePlane(o, imageNum, directory, entryName);
                }
            } else {
                try {
                    this.parseTags(s);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            s.close();
            data = null;
            r.exec("dis.close()");
        }
    }

    protected void print(int depth, String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append(s);
        this.debug(sb.toString());
    }

    private void parsePlane(byte[] data, int num, Object directory, String entry) throws IOException {
        RandomAccessStream s = new RandomAccessStream(data);
        s.order(true);
        if (s.readInt() == 0) {
            s.skipBytes(4);
        }
        this.core.sizeX[0] = s.readInt();
        this.core.sizeY[0] = s.readInt();
        s.skipBytes(4);
        this.bpp = s.readInt();
        s.skipBytes(4);
        int valid = s.readInt();
        this.isJPEG = valid == 0 || valid == 1;
        this.pixels.put(new Integer(num), directory);
        this.names.put(new Integer(num), entry);
        this.core.imageCount[0] = this.core.imageCount[0] + 1;
        this.core.sizeC[0] = this.bpp % 3 == 0 ? 3 : 1;
    }

    private void parseTags(RandomAccessStream s) throws IOException {
        s.skipBytes(24);
        int count = s.readInt();
        if (count > 4096) {
            count = 4096;
        }
        for (int i = 0; i < count && s.getFilePointer() + 2L < s.length(); ++i) {
            short type = s.readShort();
            String value = "";
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    value = "" + s.readShort();
                    break;
                }
                case 3: 
                case 22: 
                case 23: {
                    value = "" + s.readInt();
                    break;
                }
                case 4: {
                    value = "" + s.readFloat();
                    break;
                }
                case 5: {
                    value = "" + s.readDouble();
                    break;
                }
                case 7: 
                case 20: 
                case 21: {
                    value = "" + s.readLong();
                    break;
                }
                case 8: 
                case 69: {
                    int len = s.readInt();
                    if (s.getFilePointer() + (long)len < s.length()) {
                        value = s.readString(len);
                        break;
                    }
                    return;
                }
                case 66: {
                    short l = s.readShort();
                    s.seek(s.getFilePointer() - 2L);
                    value = s.readString(l + 2);
                    break;
                }
                default: {
                    long old = s.getFilePointer();
                    while (s.readShort() != 3 && s.getFilePointer() + 2L < s.length()) {
                    }
                    long fp = s.getFilePointer() - 2L;
                    s.seek(old - 2L);
                    value = s.readString((int)(fp - old + 2L));
                }
            }
            s.skipBytes(2);
            int tagID = 0;
            try {
                tagID = s.readInt();
            }
            catch (IOException e) {
                // empty catch block
            }
            s.skipBytes(6);
            String key = this.getKey(tagID);
            if (key.equals("Image Index Z")) {
                try {
                    this.zIndex = Integer.parseInt(DataTools.stripString(value));
                }
                catch (NumberFormatException f) {}
            } else if (key.equals("Image Index T")) {
                try {
                    this.tIndex = Integer.parseInt(DataTools.stripString(value));
                }
                catch (NumberFormatException f) {}
            } else if (key.equals("Image Channel Index")) {
                try {
                    this.cIndex = Integer.parseInt(DataTools.stripString(value));
                }
                catch (NumberFormatException f) {}
            } else if (key.equals("ImageWidth")) {
                try {
                    if (this.core.sizeX[0] == 0) {
                        this.core.sizeX[0] = Integer.parseInt(value);
                    }
                }
                catch (NumberFormatException f) {}
            } else if (key.equals("ImageHeight")) {
                try {
                    if (this.core.sizeY[0] == 0) {
                        this.core.sizeY[0] = Integer.parseInt(value);
                    }
                }
                catch (NumberFormatException f) {
                    // empty catch block
                }
            }
            if (this.metadata.get(key) != null || this.metadata.get(key + " 0") != null) {
                if (this.metadata.get(key) != null) {
                    Object v = this.metadata.remove(key);
                    this.metadata.put(key + " 0", v);
                }
                int ndx = 0;
                while (this.metadata.get(key + " " + ndx) != null) {
                    ++ndx;
                }
                key = key + " " + ndx;
            }
            if (key.indexOf("ImageTile") != -1) {
                this.isTiled = true;
            }
            this.addMeta(key, value);
        }
    }

    private String getKey(int tagID) {
        switch (tagID) {
            case 222: {
                return "Compression";
            }
            case 258: {
                return "BlackValue";
            }
            case 259: {
                return "WhiteValue";
            }
            case 260: {
                return "ImageDataMappingAutoRange";
            }
            case 261: {
                return "Thumbnail";
            }
            case 262: {
                return "GammaValue";
            }
            case 264: {
                return "ImageOverExposure";
            }
            case 265: {
                return "ImageRelativeTime1";
            }
            case 266: {
                return "ImageRelativeTime2";
            }
            case 267: {
                return "ImageRelativeTime3";
            }
            case 268: {
                return "ImageRelativeTime4";
            }
            case 333: {
                return "RelFocusPosition1";
            }
            case 334: {
                return "RelFocusPosition2";
            }
            case 513: {
                return "ObjectType";
            }
            case 515: {
                return "ImageWidth";
            }
            case 516: {
                return "ImageHeight";
            }
            case 517: {
                return "Number Raw Count";
            }
            case 518: {
                return "PixelType";
            }
            case 519: {
                return "NumberOfRawImages";
            }
            case 520: {
                return "ImageSize";
            }
            case 523: {
                return "Acquisition pause annotation";
            }
            case 530: {
                return "Document Subtype";
            }
            case 531: {
                return "Acquisition Bit Depth";
            }
            case 532: {
                return "Image Memory Usage (RAM)";
            }
            case 534: {
                return "Z-Stack single representative";
            }
            case 769: {
                return "Scale Factor for X";
            }
            case 770: {
                return "Scale Unit for X";
            }
            case 771: {
                return "Scale Width";
            }
            case 772: {
                return "Scale Factor for Y";
            }
            case 773: {
                return "Scale Unit for Y";
            }
            case 774: {
                return "Scale Height";
            }
            case 775: {
                return "Scale Factor for Z";
            }
            case 776: {
                return "Scale Unit for Z";
            }
            case 777: {
                return "Scale Depth";
            }
            case 778: {
                return "Scaling Parent";
            }
            case 1001: {
                return "Date";
            }
            case 1002: {
                return "code";
            }
            case 1003: {
                return "Source";
            }
            case 1004: {
                return "Message";
            }
            case 1025: {
                return "Acquisition Date";
            }
            case 1026: {
                return "8-bit acquisition";
            }
            case 1027: {
                return "Camera Bit Depth";
            }
            case 1029: {
                return "MonoReferenceLow";
            }
            case 1030: {
                return "MonoReferenceHigh";
            }
            case 1031: {
                return "RedReferenceLow";
            }
            case 1032: {
                return "RedReferenceHigh";
            }
            case 1033: {
                return "GreenReferenceLow";
            }
            case 1034: {
                return "GreenReferenceHigh";
            }
            case 1035: {
                return "BlueReferenceLow";
            }
            case 1036: {
                return "BlueReferenceHigh";
            }
            case 1041: {
                return "FrameGrabber Name";
            }
            case 1042: {
                return "Camera";
            }
            case 1044: {
                return "CameraTriggerSignalType";
            }
            case 1045: {
                return "CameraTriggerEnable";
            }
            case 1046: {
                return "GrabberTimeout";
            }
            case 1281: {
                return "MultiChannelEnabled";
            }
            case 1282: {
                return "MultiChannel Color";
            }
            case 1283: {
                return "MultiChannel Weight";
            }
            case 1284: {
                return "Channel Name";
            }
            case 1536: {
                return "DocumentInformationGroup";
            }
            case 1537: {
                return "Title";
            }
            case 1538: {
                return "Author";
            }
            case 1539: {
                return "Keywords";
            }
            case 1540: {
                return "Comments";
            }
            case 1541: {
                return "SampleID";
            }
            case 1542: {
                return "Subject";
            }
            case 1543: {
                return "RevisionNumber";
            }
            case 1544: {
                return "Save Folder";
            }
            case 1545: {
                return "FileLink";
            }
            case 1546: {
                return "Document Type";
            }
            case 1547: {
                return "Storage Media";
            }
            case 1548: {
                return "File ID";
            }
            case 1549: {
                return "Reference";
            }
            case 1550: {
                return "File Date";
            }
            case 1551: {
                return "File Size";
            }
            case 1553: {
                return "Filename";
            }
            case 1792: {
                return "ProjectGroup";
            }
            case 1793: {
                return "Acquisition Date";
            }
            case 1794: {
                return "Last modified by";
            }
            case 1795: {
                return "User company";
            }
            case 1796: {
                return "User company logo";
            }
            case 1797: {
                return "Image";
            }
            case 1800: {
                return "User ID";
            }
            case 1801: {
                return "User Name";
            }
            case 1802: {
                return "User City";
            }
            case 1803: {
                return "User Address";
            }
            case 1804: {
                return "User Country";
            }
            case 1805: {
                return "User Phone";
            }
            case 1806: {
                return "User Fax";
            }
            case 2049: {
                return "Objective Name";
            }
            case 2050: {
                return "Optovar";
            }
            case 2051: {
                return "Reflector";
            }
            case 2052: {
                return "Condenser Contrast";
            }
            case 2053: {
                return "Transmitted Light Filter 1";
            }
            case 2054: {
                return "Transmitted Light Filter 2";
            }
            case 2055: {
                return "Reflected Light Shutter";
            }
            case 2056: {
                return "Condenser Front Lens";
            }
            case 2057: {
                return "Excitation Filter Name";
            }
            case 2060: {
                return "Transmitted Light Fieldstop Aperture";
            }
            case 2061: {
                return "Reflected Light Aperture";
            }
            case 2062: {
                return "Condenser N.A.";
            }
            case 2063: {
                return "Light Path";
            }
            case 2064: {
                return "HalogenLampOn";
            }
            case 2065: {
                return "Halogen Lamp Mode";
            }
            case 2066: {
                return "Halogen Lamp Voltage";
            }
            case 2068: {
                return "Fluorescence Lamp Level";
            }
            case 2069: {
                return "Fluorescence Lamp Intensity";
            }
            case 2070: {
                return "LightManagerEnabled";
            }
            case 2071: {
                return "tag_ID_2071";
            }
            case 2072: {
                return "Focus Position";
            }
            case 2073: {
                return "Stage Position X";
            }
            case 2074: {
                return "Stage Position Y";
            }
            case 2075: {
                return "Microscope Name";
            }
            case 2076: {
                return "Objective Magnification";
            }
            case 2077: {
                return "Objective N.A.";
            }
            case 2078: {
                return "MicroscopeIllumination";
            }
            case 2079: {
                return "External Shutter 1";
            }
            case 2080: {
                return "External Shutter 2";
            }
            case 2081: {
                return "External Shutter 3";
            }
            case 2082: {
                return "External Filter Wheel 1 Name";
            }
            case 2083: {
                return "External Filter Wheel 2 Name";
            }
            case 2084: {
                return "Parfocal Correction";
            }
            case 2086: {
                return "External Shutter 4";
            }
            case 2087: {
                return "External Shutter 5";
            }
            case 2088: {
                return "External Shutter 6";
            }
            case 2089: {
                return "External Filter Wheel 3 Name";
            }
            case 2090: {
                return "External Filter Wheel 4 Name";
            }
            case 2103: {
                return "Objective Turret Position";
            }
            case 2104: {
                return "Objective Contrast Method";
            }
            case 2105: {
                return "Objective Immersion Type";
            }
            case 2107: {
                return "Reflector Position";
            }
            case 2109: {
                return "Transmitted Light Filter 1 Position";
            }
            case 2110: {
                return "Transmitted Light Filter 2 Position";
            }
            case 2112: {
                return "Excitation Filter Position";
            }
            case 2113: {
                return "Lamp Mirror Position";
            }
            case 2114: {
                return "External Filter Wheel 1 Position";
            }
            case 2115: {
                return "External Filter Wheel 2 Position";
            }
            case 2116: {
                return "External Filter Wheel 3 Position";
            }
            case 2117: {
                return "External Filter Wheel 4 Position";
            }
            case 2118: {
                return "Lightmanager Mode";
            }
            case 2119: {
                return "Halogen Lamp Calibration";
            }
            case 2120: {
                return "CondenserNAGoSpeed";
            }
            case 2121: {
                return "TransmittedLightFieldstopGoSpeed";
            }
            case 2122: {
                return "OptovarGoSpeed";
            }
            case 2123: {
                return "Focus calibrated";
            }
            case 2124: {
                return "FocusBasicPosition";
            }
            case 2125: {
                return "FocusPower";
            }
            case 2126: {
                return "FocusBacklash";
            }
            case 2127: {
                return "FocusMeasurementOrigin";
            }
            case 2128: {
                return "FocusMeasurementDistance";
            }
            case 2129: {
                return "FocusSpeed";
            }
            case 2130: {
                return "FocusGoSpeed";
            }
            case 2131: {
                return "FocusDistance";
            }
            case 2132: {
                return "FocusInitPosition";
            }
            case 2133: {
                return "Stage calibrated";
            }
            case 2134: {
                return "StagePower";
            }
            case 2135: {
                return "StageXBacklash";
            }
            case 2136: {
                return "StageYBacklash";
            }
            case 2137: {
                return "StageSpeedX";
            }
            case 2138: {
                return "StageSpeedY";
            }
            case 2139: {
                return "StageSpeed";
            }
            case 2140: {
                return "StageGoSpeedX";
            }
            case 2141: {
                return "StageGoSpeedY";
            }
            case 2142: {
                return "StageStepDistanceX";
            }
            case 2143: {
                return "StageStepDistanceY";
            }
            case 2144: {
                return "StageInitialisationPositionX";
            }
            case 2145: {
                return "StageInitialisationPositionY";
            }
            case 2146: {
                return "MicroscopeMagnification";
            }
            case 2147: {
                return "ReflectorMagnification";
            }
            case 2148: {
                return "LampMirrorPosition";
            }
            case 2149: {
                return "FocusDepth";
            }
            case 2150: {
                return "MicroscopeType";
            }
            case 2151: {
                return "Objective Working Distance";
            }
            case 2152: {
                return "ReflectedLightApertureGoSpeed";
            }
            case 2153: {
                return "External Shutter";
            }
            case 2154: {
                return "ObjectiveImmersionStop";
            }
            case 2155: {
                return "Focus Start Speed";
            }
            case 2156: {
                return "Focus Acceleration";
            }
            case 2157: {
                return "ReflectedLightFieldstop";
            }
            case 2158: {
                return "ReflectedLightFieldstopGoSpeed";
            }
            case 2159: {
                return "ReflectedLightFilter 1";
            }
            case 2160: {
                return "ReflectedLightFilter 2";
            }
            case 2161: {
                return "ReflectedLightFilter1Position";
            }
            case 2162: {
                return "ReflectedLightFilter2Position";
            }
            case 2163: {
                return "TransmittedLightAttenuator";
            }
            case 2164: {
                return "ReflectedLightAttenuator";
            }
            case 2165: {
                return "Transmitted Light Shutter";
            }
            case 2166: {
                return "TransmittedLightAttenuatorGoSpeed";
            }
            case 2167: {
                return "ReflectedLightAttenuatorGoSpeed";
            }
            case 2176: {
                return "TransmittedLightVirtualFilterPosition";
            }
            case 2177: {
                return "TransmittedLightVirtualFilter";
            }
            case 2178: {
                return "ReflectedLightVirtualFilterPosition";
            }
            case 2179: {
                return "ReflectedLightVirtualFilter";
            }
            case 2180: {
                return "ReflectedLightHalogenLampMode";
            }
            case 2181: {
                return "ReflectedLightHalogenLampVoltage";
            }
            case 2182: {
                return "ReflectedLightHalogenLampColorTemperature";
            }
            case 2183: {
                return "ContrastManagerMode";
            }
            case 2184: {
                return "Dazzle Protection Active";
            }
            case 2195: {
                return "Zoom";
            }
            case 2196: {
                return "ZoomGoSpeed";
            }
            case 2197: {
                return "LightZoom";
            }
            case 2198: {
                return "LightZoomGoSpeed";
            }
            case 2199: {
                return "LightZoomCoupled";
            }
            case 2200: {
                return "TransmittedLightHalogenLampMode";
            }
            case 2201: {
                return "TransmittedLightHalogenLampVoltage";
            }
            case 2202: {
                return "TransmittedLightHalogenLampColorTemperature";
            }
            case 2203: {
                return "Reflected Coldlight Mode";
            }
            case 2204: {
                return "Reflected Coldlight Intensity";
            }
            case 2205: {
                return "Reflected Coldlight Color Temperature";
            }
            case 2206: {
                return "Transmitted Coldlight Mode";
            }
            case 2207: {
                return "Transmitted Coldlight Intensity";
            }
            case 2208: {
                return "Transmitted Coldlight Color Temperature";
            }
            case 2209: {
                return "Infinityspace Portchanger Position";
            }
            case 2210: {
                return "Beamsplitter Infinity Space";
            }
            case 2211: {
                return "TwoTv VisCamChanger Position";
            }
            case 2212: {
                return "Beamsplitter Ocular";
            }
            case 2213: {
                return "TwoTv CamerasChanger Position";
            }
            case 2214: {
                return "Beamsplitter Cameras";
            }
            case 2215: {
                return "Ocular Shutter";
            }
            case 2216: {
                return "TwoTv CamerasChangerCube";
            }
            case 2218: {
                return "Ocular Magnification";
            }
            case 2219: {
                return "Camera Adapter Magnification";
            }
            case 2220: {
                return "Microscope Port";
            }
            case 2221: {
                return "Ocular Total Magnification";
            }
            case 2222: {
                return "Field of View";
            }
            case 2223: {
                return "Ocular";
            }
            case 2224: {
                return "CameraAdapter";
            }
            case 2225: {
                return "StageJoystickEnabled";
            }
            case 2226: {
                return "ContrastManager Contrast Method";
            }
            case 2229: {
                return "CamerasChanger Beamsplitter Type";
            }
            case 2235: {
                return "Rearport Slider Position";
            }
            case 2236: {
                return "Rearport Source";
            }
            case 2237: {
                return "Beamsplitter Type Infinity Space";
            }
            case 2238: {
                return "Fluorescence Attenuator";
            }
            case 2239: {
                return "Fluorescence Attenuator Position";
            }
            case 2261: {
                return "Objective ID";
            }
            case 2262: {
                return "Reflector ID";
            }
            case 2307: {
                return "Camera Framestart Left";
            }
            case 2308: {
                return "Camera Framestart Top";
            }
            case 2309: {
                return "Camera Frame Width";
            }
            case 2310: {
                return "Camera Frame Height";
            }
            case 2311: {
                return "Camera Binning";
            }
            case 2312: {
                return "CameraFrameFull";
            }
            case 2313: {
                return "CameraFramePixelDistance";
            }
            case 2318: {
                return "DataFormatUseScaling";
            }
            case 2319: {
                return "CameraFrameImageOrientation";
            }
            case 2320: {
                return "VideoMonochromeSignalType";
            }
            case 2321: {
                return "VideoColorSignalType";
            }
            case 2322: {
                return "MeteorChannelInput";
            }
            case 2323: {
                return "MeteorChannelSync";
            }
            case 2324: {
                return "WhiteBalanceEnabled";
            }
            case 2325: {
                return "CameraWhiteBalanceRed";
            }
            case 2326: {
                return "CameraWhiteBalanceGreen";
            }
            case 2327: {
                return "CameraWhiteBalanceBlue";
            }
            case 2331: {
                return "CameraFrameScalingFactor";
            }
            case 2562: {
                return "Meteor Camera Type";
            }
            case 2564: {
                return "Exposure Time [ms]";
            }
            case 2568: {
                return "CameraExposureTimeAutoCalculate";
            }
            case 2569: {
                return "Meteor Gain Value";
            }
            case 2571: {
                return "Meteor Gain Automatic";
            }
            case 2572: {
                return "MeteorAdjustHue";
            }
            case 2573: {
                return "MeteorAdjustSaturation";
            }
            case 2574: {
                return "MeteorAdjustRedLow";
            }
            case 2575: {
                return "MeteorAdjustGreenLow";
            }
            case 2576: {
                return "Meteor Blue Low";
            }
            case 2577: {
                return "MeteorAdjustRedHigh";
            }
            case 2578: {
                return "MeteorAdjustGreenHigh";
            }
            case 2579: {
                return "MeteorBlue High";
            }
            case 2582: {
                return "CameraExposureTimeCalculationControl";
            }
            case 2585: {
                return "AxioCamFadingCorrectionEnable";
            }
            case 2587: {
                return "CameraLiveImage";
            }
            case 2588: {
                return "CameraLiveEnabled";
            }
            case 2589: {
                return "LiveImageSyncObjectName";
            }
            case 2590: {
                return "CameraLiveSpeed";
            }
            case 2591: {
                return "CameraImage";
            }
            case 2592: {
                return "CameraImageWidth";
            }
            case 2593: {
                return "CameraImageHeight";
            }
            case 2594: {
                return "CameraImagePixelType";
            }
            case 2595: {
                return "CameraImageShMemoryName";
            }
            case 2596: {
                return "CameraLiveImageWidth";
            }
            case 2597: {
                return "CameraLiveImageHeight";
            }
            case 2598: {
                return "CameraLiveImagePixelType";
            }
            case 2599: {
                return "CameraLiveImageShMemoryName";
            }
            case 2600: {
                return "CameraLiveMaximumSpeed";
            }
            case 2601: {
                return "CameraLiveBinning";
            }
            case 2602: {
                return "CameraLiveGainValue";
            }
            case 2603: {
                return "CameraLiveExposureTimeValue";
            }
            case 2604: {
                return "CameraLiveScalingFactor";
            }
            case 2819: {
                return "Image Index Z";
            }
            case 2820: {
                return "Image Channel Index";
            }
            case 2821: {
                return "Image Index T";
            }
            case 2822: {
                return "ImageTile Index";
            }
            case 2823: {
                return "Image acquisition Index";
            }
            case 2827: {
                return "Image IndexS";
            }
            case 2841: {
                return "Original Stage Position X";
            }
            case 2842: {
                return "Original Stage Position Y";
            }
            case 3088: {
                return "LayerDrawFlags";
            }
            case 3334: {
                return "RemainingTime";
            }
            case 3585: {
                return "User Field 1";
            }
            case 3586: {
                return "User Field 2";
            }
            case 3587: {
                return "User Field 3";
            }
            case 3588: {
                return "User Field 4";
            }
            case 3589: {
                return "User Field 5";
            }
            case 3590: {
                return "User Field 6";
            }
            case 3591: {
                return "User Field 7";
            }
            case 3592: {
                return "User Field 8";
            }
            case 3593: {
                return "User Field 9";
            }
            case 3594: {
                return "User Field 10";
            }
            case 3840: {
                return "ID";
            }
            case 3841: {
                return "Name";
            }
            case 3842: {
                return "Value";
            }
            case 5501: {
                return "PvCamClockingMode";
            }
            case 8193: {
                return "Autofocus Status Report";
            }
            case 8194: {
                return "Autofocus Position";
            }
            case 8195: {
                return "Autofocus Position Offset";
            }
            case 8196: {
                return "Autofocus Empty Field Threshold";
            }
            case 8197: {
                return "Autofocus Calibration Name";
            }
            case 8198: {
                return "Autofocus Current Calibration Item";
            }
            case 20478: {
                return "tag_ID_20478";
            }
            case 65537: {
                return "CameraFrameFullWidth";
            }
            case 65538: {
                return "CameraFrameFullHeight";
            }
            case 65541: {
                return "AxioCam Shutter Signal";
            }
            case 65542: {
                return "AxioCam Delay Time";
            }
            case 65543: {
                return "AxioCam Shutter Control";
            }
            case 65544: {
                return "AxioCam BlackRefIsCalculated";
            }
            case 65545: {
                return "AxioCam Black Reference";
            }
            case 65547: {
                return "Camera Shading Correction";
            }
            case 65550: {
                return "AxioCam Enhance Color";
            }
            case 65551: {
                return "AxioCam NIR Mode";
            }
            case 65552: {
                return "CameraShutterCloseDelay";
            }
            case 65553: {
                return "CameraWhiteBalanceAutoCalculate";
            }
            case 65556: {
                return "AxioCam NIR Mode Available";
            }
            case 65557: {
                return "AxioCam Fading Correction Available";
            }
            case 65559: {
                return "AxioCam Enhance Color Available";
            }
            case 65565: {
                return "MeteorVideoNorm";
            }
            case 65566: {
                return "MeteorAdjustWhiteReference";
            }
            case 65567: {
                return "MeteorBlackReference";
            }
            case 65568: {
                return "MeteorChannelInputCountMono";
            }
            case 65570: {
                return "MeteorChannelInputCountRGB";
            }
            case 65571: {
                return "MeteorEnableVCR";
            }
            case 65572: {
                return "Meteor Brightness";
            }
            case 65573: {
                return "Meteor Contrast";
            }
            case 65575: {
                return "AxioCam Selector";
            }
            case 65576: {
                return "AxioCam Type";
            }
            case 65577: {
                return "AxioCam Info";
            }
            case 65580: {
                return "AxioCam Resolution";
            }
            case 65581: {
                return "AxioCam Color Model";
            }
            case 65582: {
                return "AxioCam MicroScanning";
            }
            case 65585: {
                return "Amplification Index";
            }
            case 65586: {
                return "Device Command";
            }
            case 65587: {
                return "BeamLocation";
            }
            case 65588: {
                return "ComponentType";
            }
            case 65589: {
                return "ControllerType";
            }
            case 65590: {
                return "CameraWhiteBalanceCalculationRedPaint";
            }
            case 65591: {
                return "CameraWhiteBalanceCalculationBluePaint";
            }
            case 65592: {
                return "CameraWhiteBalanceSetRed";
            }
            case 65593: {
                return "CameraWhiteBalanceSetGreen";
            }
            case 65594: {
                return "CameraWhiteBalanceSetBlue";
            }
            case 65595: {
                return "CameraWhiteBalanceSetTargetRed";
            }
            case 65596: {
                return "CameraWhiteBalanceSetTargetGreen";
            }
            case 65597: {
                return "CameraWhiteBalanceSetTargetBlue";
            }
            case 65598: {
                return "ApotomeCamCalibrationMode";
            }
            case 65599: {
                return "ApoTome Grid Position";
            }
            case 65600: {
                return "ApotomeCamScannerPosition";
            }
            case 65601: {
                return "ApoTome Full Phase Shift";
            }
            case 65602: {
                return "ApoTome Grid Name";
            }
            case 65603: {
                return "ApoTome Staining";
            }
            case 65604: {
                return "ApoTome Processing Mode";
            }
            case 65605: {
                return "ApotmeCamLiveCombineMode";
            }
            case 65606: {
                return "ApoTome Filter Name";
            }
            case 65607: {
                return "Apotome Filter Strength";
            }
            case 65608: {
                return "ApotomeCamFilterHarmonics";
            }
            case 65609: {
                return "ApoTome Grating Period";
            }
            case 65610: {
                return "ApoTome Auto Shutter Used";
            }
            case 65611: {
                return "Apotome Cam Status";
            }
            case 65612: {
                return "ApotomeCamNormalize";
            }
            case 65613: {
                return "ApotomeCamSettingsManager";
            }
            case 65614: {
                return "DeepviewCamSupervisorMode";
            }
            case 65615: {
                return "DeepView Processing";
            }
            case 65616: {
                return "DeepviewCamFilterName";
            }
            case 65617: {
                return "DeepviewCamStatus";
            }
            case 65618: {
                return "DeepviewCamSettingsManager";
            }
            case 65619: {
                return "DeviceScalingName";
            }
            case 65620: {
                return "CameraShadingIsCalculated";
            }
            case 65621: {
                return "CameraShadingCalculationName";
            }
            case 65622: {
                return "CameraShadingAutoCalculate";
            }
            case 65623: {
                return "CameraTriggerAvailable";
            }
            case 65626: {
                return "CameraShutterAvailable";
            }
            case 65627: {
                return "AxioCam ShutterMicroScanningEnable";
            }
            case 65628: {
                return "ApotomeCamLiveFocus";
            }
            case 65629: {
                return "DeviceInitStatus";
            }
            case 65630: {
                return "DeviceErrorStatus";
            }
            case 65631: {
                return "ApotomeCamSliderInGridPosition";
            }
            case 65632: {
                return "Orca NIR Mode Used";
            }
            case 65633: {
                return "Orca Analog Gain";
            }
            case 65634: {
                return "Orca Analog Offset";
            }
            case 65635: {
                return "Orca Binning";
            }
            case 65636: {
                return "Orca Bit Depth";
            }
            case 65637: {
                return "ApoTome Averaging Count";
            }
            case 65638: {
                return "DeepView DoF";
            }
            case 65639: {
                return "DeepView EDoF";
            }
            case 65643: {
                return "DeepView Slider Name";
            }
            case 65655: {
                return "DeepView Slider Name";
            }
            case 0x530003: {
                return "Acquisition Sofware";
            }
            case 0x1000110: {
                return "Excitation Wavelength";
            }
            case 0x1000111: {
                return "Emission Wavelength";
            }
            case 101515267: {
                return "File Name";
            }
            case 101253123: 
            case 101777411: {
                return "Image Name";
            }
        }
        return "" + tagID;
    }
}

